/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.query.dsl.EntityContext;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.QueryContextBuilder;
import org.hibernate.search.query.dsl.impl.ConnectedQueryBuilder;
import org.hibernate.search.query.dsl.impl.QueryBuildingContext;
import org.hibernate.search.util.impl.ScopedAnalyzer;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ConnectedQueryContextBuilder
implements QueryContextBuilder {
    private static final Log log = LoggerFactory.make();
    private final ExtendedSearchIntegrator factory;

    public ConnectedQueryContextBuilder(ExtendedSearchIntegrator factory) {
        this.factory = factory;
    }

    @Override
    public EntityContext forEntity(Class<?> entityType) {
        return new HSearchEntityContext(entityType, this.factory);
    }

    public final class HSearchEntityContext
    implements EntityContext {
        private final ScopedAnalyzer queryAnalyzer;
        private final QueryBuildingContext context;

        public HSearchEntityContext(Class<?> entityType, ExtendedSearchIntegrator factory) {
            Class<?> indexBoundType = this.getIndexBoundType(entityType, factory);
            if (indexBoundType == null) {
                throw log.cantQueryUnindexedType(entityType.getCanonicalName());
            }
            this.queryAnalyzer = new ScopedAnalyzer(factory.getAnalyzer(indexBoundType));
            this.context = new QueryBuildingContext(factory, (Analyzer)this.queryAnalyzer, indexBoundType);
        }

        private Class<?> getIndexBoundType(Class<?> entityType, ExtendedSearchIntegrator factory) {
            if (factory.getIndexBinding(entityType) != null) {
                return entityType;
            }
            Set<Class<?>> indexedSubTypes = factory.getIndexedTypesPolymorphic(new Class[]{entityType});
            if (!indexedSubTypes.isEmpty()) {
                return indexedSubTypes.iterator().next();
            }
            return null;
        }

        @Override
        public EntityContext overridesForField(String field, String analyzerName) {
            this.queryAnalyzer.addScopedAnalyzer(field, ConnectedQueryContextBuilder.this.factory.getAnalyzer(analyzerName));
            return this;
        }

        @Override
        public QueryBuilder get() {
            return new ConnectedQueryBuilder(this.context);
        }
    }
}

