# cloud-readiness
## Description
This ruleset detects logging configurations that may be problematic when migrating an application to a cloud environment.
* Source of rules: https://github.com/konveyor/rulesets/tree/main/default/generated
## Violations
Number of Violations: 7
### #0 - java-corba-00000
* Category: optional
* Effort: 5
* Description: CORBA
* Labels: corba, konveyor.io/source=java, konveyor.io/target=cloud-readiness
* Incidents
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/javax/rmi/CORBA/Stub.java
      * Line Number: 42
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
32  
33  package javax.rmi.CORBA;
34  
35  import java.io.IOException;
36  import java.net.MalformedURLException;
37  import java.rmi.RemoteException;
38  import java.rmi.server.RMIClassLoader;
39  import java.security.AccessController;
40  import java.util.Properties;
41  
42  import org.omg.CORBA.INITIALIZE;
43  import org.omg.CORBA.ORB;
44  import org.omg.CORBA_2_3.portable.ObjectImpl;
45  
46  /**
47   * Base class from which all RMI-IIOP stubs must inherit.
48   */
49  public abstract class Stub extends ObjectImpl implements java.io.Serializable
50  {
51  
52      private static final long serialVersionUID = 1087775603798577179L;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/javax/rmi/CORBA/Stub.java
      * Line Number: 43
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
33  package javax.rmi.CORBA;
34  
35  import java.io.IOException;
36  import java.net.MalformedURLException;
37  import java.rmi.RemoteException;
38  import java.rmi.server.RMIClassLoader;
39  import java.security.AccessController;
40  import java.util.Properties;
41  
42  import org.omg.CORBA.INITIALIZE;
43  import org.omg.CORBA.ORB;
44  import org.omg.CORBA_2_3.portable.ObjectImpl;
45  
46  /**
47   * Base class from which all RMI-IIOP stubs must inherit.
48   */
49  public abstract class Stub extends ObjectImpl implements java.io.Serializable
50  {
51  
52      private static final long serialVersionUID = 1087775603798577179L;
53  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/javax/rmi/CORBA/Stub.java
      * Line Number: 44
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
34  
35  import java.io.IOException;
36  import java.net.MalformedURLException;
37  import java.rmi.RemoteException;
38  import java.rmi.server.RMIClassLoader;
39  import java.security.AccessController;
40  import java.util.Properties;
41  
42  import org.omg.CORBA.INITIALIZE;
43  import org.omg.CORBA.ORB;
44  import org.omg.CORBA_2_3.portable.ObjectImpl;
45  
46  /**
47   * Base class from which all RMI-IIOP stubs must inherit.
48   */
49  public abstract class Stub extends ObjectImpl implements java.io.Serializable
50  {
51  
52      private static final long serialVersionUID = 1087775603798577179L;
53  
54      // This can only be set at object construction time (no sync necessary).
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/javax/rmi/CORBA/Tie.java
      * Line Number: 36
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
26   * Licensed Materials - Property of IBM
27   * RMI-IIOP v1.0
28   * Copyright IBM Corp. 1998 1999  All Rights Reserved
29   *
30   */
31  
32  package javax.rmi.CORBA;
33  
34  import java.rmi.Remote;
35  
36  import org.omg.CORBA.ORB;
37  import org.omg.CORBA.portable.InvokeHandler;
38  
39  /**
40   * Defines methods which all RMI-IIOP server side ties must implement.
41   */
42  public interface Tie extends InvokeHandler
43  {
44      /**
45       * Returns an object reference for the target object represented by this tie.
46       * 
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/javax/rmi/CORBA/Tie.java
      * Line Number: 37
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
27   * RMI-IIOP v1.0
28   * Copyright IBM Corp. 1998 1999  All Rights Reserved
29   *
30   */
31  
32  package javax.rmi.CORBA;
33  
34  import java.rmi.Remote;
35  
36  import org.omg.CORBA.ORB;
37  import org.omg.CORBA.portable.InvokeHandler;
38  
39  /**
40   * Defines methods which all RMI-IIOP server side ties must implement.
41   */
42  public interface Tie extends InvokeHandler
43  {
44      /**
45       * Returns an object reference for the target object represented by this tie.
46       * 
47       * @return an object reference for the target object.
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/javax/rmi/CORBA/Tie.java
      * Line Number: 49
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
39  /**
40   * Defines methods which all RMI-IIOP server side ties must implement.
41   */
42  public interface Tie extends InvokeHandler
43  {
44      /**
45       * Returns an object reference for the target object represented by this tie.
46       * 
47       * @return an object reference for the target object.
48       */
49      org.omg.CORBA.Object thisObject();
50  
51      /**
52       * Deactivates the target object represented by this tie.
53       */
54      void deactivate() throws java.rmi.NoSuchObjectException;
55  
56      /**
57       * Returns the ORB for this tie.
58       * 
59       * @return the ORB.
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/javax/rmi/CORBA/Util.java
      * Line Number: 41
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
31  
32  package javax.rmi.CORBA;
33  
34  import java.net.MalformedURLException;
35  import java.rmi.Remote;
36  import java.rmi.RemoteException;
37  import java.rmi.server.RMIClassLoader;
38  import java.security.AccessController;
39  import java.util.Properties;
40  
41  import org.omg.CORBA.INITIALIZE;
42  import org.omg.CORBA.ORB;
43  import org.omg.CORBA.SystemException;
44  import org.omg.CORBA.portable.InputStream;
45  import org.omg.CORBA.portable.OutputStream;
46  
47  /**
48   * Provides utility methods that can be used by stubs and ties to perform common operations.
49   */
50  public class Util
51  {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/javax/rmi/CORBA/Util.java
      * Line Number: 42
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
32  package javax.rmi.CORBA;
33  
34  import java.net.MalformedURLException;
35  import java.rmi.Remote;
36  import java.rmi.RemoteException;
37  import java.rmi.server.RMIClassLoader;
38  import java.security.AccessController;
39  import java.util.Properties;
40  
41  import org.omg.CORBA.INITIALIZE;
42  import org.omg.CORBA.ORB;
43  import org.omg.CORBA.SystemException;
44  import org.omg.CORBA.portable.InputStream;
45  import org.omg.CORBA.portable.OutputStream;
46  
47  /**
48   * Provides utility methods that can be used by stubs and ties to perform common operations.
49   */
50  public class Util
51  {
52  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/javax/rmi/CORBA/Util.java
      * Line Number: 43
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
33  
34  import java.net.MalformedURLException;
35  import java.rmi.Remote;
36  import java.rmi.RemoteException;
37  import java.rmi.server.RMIClassLoader;
38  import java.security.AccessController;
39  import java.util.Properties;
40  
41  import org.omg.CORBA.INITIALIZE;
42  import org.omg.CORBA.ORB;
43  import org.omg.CORBA.SystemException;
44  import org.omg.CORBA.portable.InputStream;
45  import org.omg.CORBA.portable.OutputStream;
46  
47  /**
48   * Provides utility methods that can be used by stubs and ties to perform common operations.
49   */
50  public class Util
51  {
52  
53      // This can only be set at static initialization time (no sync necessary).
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/javax/rmi/CORBA/Util.java
      * Line Number: 44
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
34  import java.net.MalformedURLException;
35  import java.rmi.Remote;
36  import java.rmi.RemoteException;
37  import java.rmi.server.RMIClassLoader;
38  import java.security.AccessController;
39  import java.util.Properties;
40  
41  import org.omg.CORBA.INITIALIZE;
42  import org.omg.CORBA.ORB;
43  import org.omg.CORBA.SystemException;
44  import org.omg.CORBA.portable.InputStream;
45  import org.omg.CORBA.portable.OutputStream;
46  
47  /**
48   * Provides utility methods that can be used by stubs and ties to perform common operations.
49   */
50  public class Util
51  {
52  
53      // This can only be set at static initialization time (no sync necessary).
54      private static javax.rmi.CORBA.UtilDelegate utilDelegate = null;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/javax/rmi/CORBA/Util.java
      * Line Number: 45
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
35  import java.rmi.Remote;
36  import java.rmi.RemoteException;
37  import java.rmi.server.RMIClassLoader;
38  import java.security.AccessController;
39  import java.util.Properties;
40  
41  import org.omg.CORBA.INITIALIZE;
42  import org.omg.CORBA.ORB;
43  import org.omg.CORBA.SystemException;
44  import org.omg.CORBA.portable.InputStream;
45  import org.omg.CORBA.portable.OutputStream;
46  
47  /**
48   * Provides utility methods that can be used by stubs and ties to perform common operations.
49   */
50  public class Util
51  {
52  
53      // This can only be set at static initialization time (no sync necessary).
54      private static javax.rmi.CORBA.UtilDelegate utilDelegate = null;
55  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/javax/rmi/PortableRemoteObject.java
      * Line Number: 47
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
37  import java.rmi.NoSuchObjectException;
38  import java.rmi.Remote;
39  import java.rmi.RemoteException;
40  import java.rmi.server.RMIClassLoader;
41  import java.security.AccessController;
42  import java.security.PrivilegedAction;
43  import java.util.Properties;
44  
45  import javax.rmi.CORBA.GetPropertyAction;
46  
47  import org.omg.CORBA.INITIALIZE;
48  
49  /**
50   * Server implementation objects may either inherit from javax.rmi.PortableRemoteObject or they may implement a remote
51   * interface and then use the exportObject method to register themselves as a server object. The toStub method takes a
52   * server implementation and returns a stub that can be used to access that server object. The connect method makes a
53   * Remote object ready for remote communication. The unexportObject method is used to deregister a server object,
54   * allowing it to become available for garbage collection. The narrow method takes an object reference or abstract
55   * interface type and attempts to narrow it to conform to the given interface. If the operation is successful the result
56   * will be an object of the specified type, otherwise an exception will be thrown.
57   */
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/AnyImpl.java
      * Line Number: 83
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/AnyImpl.java
      * Line Number: 1100
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/AnyImpl.java
      * Line Number: 1125
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/AnyImpl.java
      * Line Number: 1132
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/AnyImpl.java
      * Line Number: 1135
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/AnyImpl.java
      * Line Number: 1234
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/AnyImpl.java
      * Line Number: 1250
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/AnyImpl.java
      * Line Number: 1259
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/AnyImpl.java
      * Line Number: 1073
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
1063      public Any extract_any()
1064      {
1065          // debug.log ("extract_any");
1066          checkExtractBadOperation(TCKind._tk_any);
1067          return (Any) object;
1068      }
1069  
1070      /**
1071       * See the description of the <a href="#anyOps">general Any operations.</a>
1072       */
1073      public void insert_Object(org.omg.CORBA.Object o)
1074      {
1075          // debug.log ("insert_Object");
1076          if (o == null)
1077          {
1078              typeCode = orb.get_primitive_tc(TCKind._tk_objref);
1079          }
1080          else
1081          {
1082              if (StubAdapter.isStub(o))
1083              {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/AnyImpl.java
      * Line Number: 51
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
41  import org.jboss.com.sun.corba.se.impl.encoding.EncapsOutputStream;
42  import org.jboss.com.sun.corba.se.impl.io.ValueUtility;
43  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
44  import org.jboss.com.sun.corba.se.impl.orbutil.ORBUtility;
45  import org.jboss.com.sun.corba.se.impl.orbutil.RepositoryIdFactory;
46  import org.jboss.com.sun.corba.se.impl.orbutil.RepositoryIdStrings;
47  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
48  import org.jboss.com.sun.corba.se.spi.orb.ORB;
49  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
50  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
51  import org.omg.CORBA.Any;
52  import org.omg.CORBA.CompletionStatus;
53  import org.omg.CORBA.Principal;
54  import org.omg.CORBA.TCKind;
55  import org.omg.CORBA.TypeCode;
56  import org.omg.CORBA.TypeCodePackage.BadKind;
57  import org.omg.CORBA.TypeCodePackage.Bounds;
58  import org.omg.CORBA.portable.InputStream;
59  import org.omg.CORBA.portable.OutputStream;
60  import org.omg.CORBA.portable.Streamable;
61  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/AnyImpl.java
      * Line Number: 52
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
42  import org.jboss.com.sun.corba.se.impl.io.ValueUtility;
43  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
44  import org.jboss.com.sun.corba.se.impl.orbutil.ORBUtility;
45  import org.jboss.com.sun.corba.se.impl.orbutil.RepositoryIdFactory;
46  import org.jboss.com.sun.corba.se.impl.orbutil.RepositoryIdStrings;
47  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
48  import org.jboss.com.sun.corba.se.spi.orb.ORB;
49  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
50  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
51  import org.omg.CORBA.Any;
52  import org.omg.CORBA.CompletionStatus;
53  import org.omg.CORBA.Principal;
54  import org.omg.CORBA.TCKind;
55  import org.omg.CORBA.TypeCode;
56  import org.omg.CORBA.TypeCodePackage.BadKind;
57  import org.omg.CORBA.TypeCodePackage.Bounds;
58  import org.omg.CORBA.portable.InputStream;
59  import org.omg.CORBA.portable.OutputStream;
60  import org.omg.CORBA.portable.Streamable;
61  
62  // subclasses must provide a matching helper class
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/AnyImpl.java
      * Line Number: 53
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
43  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
44  import org.jboss.com.sun.corba.se.impl.orbutil.ORBUtility;
45  import org.jboss.com.sun.corba.se.impl.orbutil.RepositoryIdFactory;
46  import org.jboss.com.sun.corba.se.impl.orbutil.RepositoryIdStrings;
47  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
48  import org.jboss.com.sun.corba.se.spi.orb.ORB;
49  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
50  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
51  import org.omg.CORBA.Any;
52  import org.omg.CORBA.CompletionStatus;
53  import org.omg.CORBA.Principal;
54  import org.omg.CORBA.TCKind;
55  import org.omg.CORBA.TypeCode;
56  import org.omg.CORBA.TypeCodePackage.BadKind;
57  import org.omg.CORBA.TypeCodePackage.Bounds;
58  import org.omg.CORBA.portable.InputStream;
59  import org.omg.CORBA.portable.OutputStream;
60  import org.omg.CORBA.portable.Streamable;
61  
62  // subclasses must provide a matching helper class
63  @SuppressWarnings("deprecation")
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/AnyImpl.java
      * Line Number: 54
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
44  import org.jboss.com.sun.corba.se.impl.orbutil.ORBUtility;
45  import org.jboss.com.sun.corba.se.impl.orbutil.RepositoryIdFactory;
46  import org.jboss.com.sun.corba.se.impl.orbutil.RepositoryIdStrings;
47  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
48  import org.jboss.com.sun.corba.se.spi.orb.ORB;
49  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
50  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
51  import org.omg.CORBA.Any;
52  import org.omg.CORBA.CompletionStatus;
53  import org.omg.CORBA.Principal;
54  import org.omg.CORBA.TCKind;
55  import org.omg.CORBA.TypeCode;
56  import org.omg.CORBA.TypeCodePackage.BadKind;
57  import org.omg.CORBA.TypeCodePackage.Bounds;
58  import org.omg.CORBA.portable.InputStream;
59  import org.omg.CORBA.portable.OutputStream;
60  import org.omg.CORBA.portable.Streamable;
61  
62  // subclasses must provide a matching helper class
63  @SuppressWarnings("deprecation")
64  public class AnyImpl extends Any
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/AnyImpl.java
      * Line Number: 55
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
45  import org.jboss.com.sun.corba.se.impl.orbutil.RepositoryIdFactory;
46  import org.jboss.com.sun.corba.se.impl.orbutil.RepositoryIdStrings;
47  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
48  import org.jboss.com.sun.corba.se.spi.orb.ORB;
49  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
50  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
51  import org.omg.CORBA.Any;
52  import org.omg.CORBA.CompletionStatus;
53  import org.omg.CORBA.Principal;
54  import org.omg.CORBA.TCKind;
55  import org.omg.CORBA.TypeCode;
56  import org.omg.CORBA.TypeCodePackage.BadKind;
57  import org.omg.CORBA.TypeCodePackage.Bounds;
58  import org.omg.CORBA.portable.InputStream;
59  import org.omg.CORBA.portable.OutputStream;
60  import org.omg.CORBA.portable.Streamable;
61  
62  // subclasses must provide a matching helper class
63  @SuppressWarnings("deprecation")
64  public class AnyImpl extends Any
65  {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/AnyImpl.java
      * Line Number: 56
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
46  import org.jboss.com.sun.corba.se.impl.orbutil.RepositoryIdStrings;
47  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
48  import org.jboss.com.sun.corba.se.spi.orb.ORB;
49  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
50  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
51  import org.omg.CORBA.Any;
52  import org.omg.CORBA.CompletionStatus;
53  import org.omg.CORBA.Principal;
54  import org.omg.CORBA.TCKind;
55  import org.omg.CORBA.TypeCode;
56  import org.omg.CORBA.TypeCodePackage.BadKind;
57  import org.omg.CORBA.TypeCodePackage.Bounds;
58  import org.omg.CORBA.portable.InputStream;
59  import org.omg.CORBA.portable.OutputStream;
60  import org.omg.CORBA.portable.Streamable;
61  
62  // subclasses must provide a matching helper class
63  @SuppressWarnings("deprecation")
64  public class AnyImpl extends Any
65  {
66      private static final long serialVersionUID = 5085834738845046320L;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/AnyImpl.java
      * Line Number: 57
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
47  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
48  import org.jboss.com.sun.corba.se.spi.orb.ORB;
49  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
50  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
51  import org.omg.CORBA.Any;
52  import org.omg.CORBA.CompletionStatus;
53  import org.omg.CORBA.Principal;
54  import org.omg.CORBA.TCKind;
55  import org.omg.CORBA.TypeCode;
56  import org.omg.CORBA.TypeCodePackage.BadKind;
57  import org.omg.CORBA.TypeCodePackage.Bounds;
58  import org.omg.CORBA.portable.InputStream;
59  import org.omg.CORBA.portable.OutputStream;
60  import org.omg.CORBA.portable.Streamable;
61  
62  // subclasses must provide a matching helper class
63  @SuppressWarnings("deprecation")
64  public class AnyImpl extends Any
65  {
66      private static final long serialVersionUID = 5085834738845046320L;
67  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/AnyImpl.java
      * Line Number: 58
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
48  import org.jboss.com.sun.corba.se.spi.orb.ORB;
49  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
50  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
51  import org.omg.CORBA.Any;
52  import org.omg.CORBA.CompletionStatus;
53  import org.omg.CORBA.Principal;
54  import org.omg.CORBA.TCKind;
55  import org.omg.CORBA.TypeCode;
56  import org.omg.CORBA.TypeCodePackage.BadKind;
57  import org.omg.CORBA.TypeCodePackage.Bounds;
58  import org.omg.CORBA.portable.InputStream;
59  import org.omg.CORBA.portable.OutputStream;
60  import org.omg.CORBA.portable.Streamable;
61  
62  // subclasses must provide a matching helper class
63  @SuppressWarnings("deprecation")
64  public class AnyImpl extends Any
65  {
66      private static final long serialVersionUID = 5085834738845046320L;
67  
68      private static final class AnyInputStream extends EncapsInputStream
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/AnyImpl.java
      * Line Number: 499
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
489                          }
490                      }
491                      return true;
492                  }
493  
494                      // Too complicated to handle value types the way we handle
495                      // other complex types above. Don't try to decompose it here
496                      // for faster comparison, just use Object.equals().
497                  case TCKind._tk_value :
498                  case TCKind._tk_value_box :
499                      org.omg.CORBA_2_3.portable.InputStream mine = (org.omg.CORBA_2_3.portable.InputStream) myStream;
500                      org.omg.CORBA_2_3.portable.InputStream other = (org.omg.CORBA_2_3.portable.InputStream) otherStream;
501                      return mine.read_value().equals(other.read_value());
502  
503                  case TCKind._tk_alias :
504                      // error resolving alias above
505                      throw wrapper.errorResolvingAlias();
506  
507                  case TCKind._tk_longdouble :
508                      throw wrapper.tkLongDoubleNotSupported();
509  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/AnyImpl.java
      * Line Number: 59
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
49  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
50  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
51  import org.omg.CORBA.Any;
52  import org.omg.CORBA.CompletionStatus;
53  import org.omg.CORBA.Principal;
54  import org.omg.CORBA.TCKind;
55  import org.omg.CORBA.TypeCode;
56  import org.omg.CORBA.TypeCodePackage.BadKind;
57  import org.omg.CORBA.TypeCodePackage.Bounds;
58  import org.omg.CORBA.portable.InputStream;
59  import org.omg.CORBA.portable.OutputStream;
60  import org.omg.CORBA.portable.Streamable;
61  
62  // subclasses must provide a matching helper class
63  @SuppressWarnings("deprecation")
64  public class AnyImpl extends Any
65  {
66      private static final long serialVersionUID = 5085834738845046320L;
67  
68      private static final class AnyInputStream extends EncapsInputStream
69      {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/AnyImpl.java
      * Line Number: 500
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
490                      }
491                      return true;
492                  }
493  
494                      // Too complicated to handle value types the way we handle
495                      // other complex types above. Don't try to decompose it here
496                      // for faster comparison, just use Object.equals().
497                  case TCKind._tk_value :
498                  case TCKind._tk_value_box :
499                      org.omg.CORBA_2_3.portable.InputStream mine = (org.omg.CORBA_2_3.portable.InputStream) myStream;
500                      org.omg.CORBA_2_3.portable.InputStream other = (org.omg.CORBA_2_3.portable.InputStream) otherStream;
501                      return mine.read_value().equals(other.read_value());
502  
503                  case TCKind._tk_alias :
504                      // error resolving alias above
505                      throw wrapper.errorResolvingAlias();
506  
507                  case TCKind._tk_longdouble :
508                      throw wrapper.tkLongDoubleNotSupported();
509  
510                  default :
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/AnyImpl.java
      * Line Number: 60
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
50  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
51  import org.omg.CORBA.Any;
52  import org.omg.CORBA.CompletionStatus;
53  import org.omg.CORBA.Principal;
54  import org.omg.CORBA.TCKind;
55  import org.omg.CORBA.TypeCode;
56  import org.omg.CORBA.TypeCodePackage.BadKind;
57  import org.omg.CORBA.TypeCodePackage.Bounds;
58  import org.omg.CORBA.portable.InputStream;
59  import org.omg.CORBA.portable.OutputStream;
60  import org.omg.CORBA.portable.Streamable;
61  
62  // subclasses must provide a matching helper class
63  @SuppressWarnings("deprecation")
64  public class AnyImpl extends Any
65  {
66      private static final long serialVersionUID = 5085834738845046320L;
67  
68      private static final class AnyInputStream extends EncapsInputStream
69      {
70          public AnyInputStream(EncapsInputStream theStream)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/AnyImpl.java
      * Line Number: 532
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
522      }
523  
524      // /////////////////////////////////////////////////////////////////////////
525      // accessors for marshaling/unmarshaling
526  
527      /**
528       * returns an output stream that an Any value can be marshaled into.
529       * 
530       * @result the OutputStream to marshal value of Any into
531       */
532      public org.omg.CORBA.portable.OutputStream create_output_stream()
533      {
534          // debug.log ("create_output_stream");
535          return new AnyOutputStream(orb);
536      }
537  
538      /**
539       * returns an input stream that an Any value can be marshaled out of.
540       * 
541       * @result the InputStream to marshal value of Any out of.
542       */
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/AnyImpl.java
      * Line Number: 543
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
533      {
534          // debug.log ("create_output_stream");
535          return new AnyOutputStream(orb);
536      }
537  
538      /**
539       * returns an input stream that an Any value can be marshaled out of.
540       * 
541       * @result the InputStream to marshal value of Any out of.
542       */
543      public org.omg.CORBA.portable.InputStream create_input_stream()
544      {
545          //
546          // We create a new InputStream so that multiple threads can call here
547          // and read the streams in parallel without thread safety problems.
548          //
549          // debug.log ("create_input_stream");
550          if (AnyImpl.isStreamed[realType().kind().value()])
551          {
552              return stream.dup();
553          }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/AnyImpl.java
      * Line Number: 570
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
560          }
561      }
562  
563      // /////////////////////////////////////////////////////////////////////////
564      // marshaling/unmarshaling routines
565  
566      //
567      // If the InputStream is a CDRInputStream then we can copy the bytes
568      // since it is in our format and does not have alignment issues.
569      //
570      public void read_value(org.omg.CORBA.portable.InputStream in, TypeCode tc)
571      {
572          // debug.log ("read_value");
573          //
574          // Assume that someone isn't going to think they can keep reading
575          // from this stream after calling us. That would be likely for
576          // an IIOPInputStream but if it is an AnyInputStream then they
577          // presumably obtained it via our create_output_stream() so they could
578          // write the contents of an IDL data type to it and then call
579          // create_input_stream() for us to read it. This is how Helper classes
580          // typically implement the insert() method.
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/AnyImpl.java
      * Line Number: 601
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
591  
592          if (AnyImpl.isStreamed[kind])
593          {
594              if (in instanceof AnyInputStream)
595              {
596                  // could only have been created here
597                  stream = (CDRInputStream) in;
598              }
599              else
600              {
601                  org.omg.CORBA_2_3.portable.OutputStream out = (org.omg.CORBA_2_3.portable.OutputStream) orb
602                          .create_output_stream();
603                  typeCode.copy(in, out);
604                  stream = (CDRInputStream) out.create_input_stream();
605              }
606          }
607          else
608          {
609              java.lang.Object[] objholder = new java.lang.Object[1];
610              objholder[0] = object;
611              long[] longholder = new long[1];
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/CORBAObjectImpl.java
      * Line Number: 37
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
27   * RMI-IIOP v1.0
28   * Copyright IBM Corp. 1998 1999  All Rights Reserved
29   *
30   */
31  
32  package org.jboss.com.sun.corba.se.impl.corba;
33  
34  //
35  // Bare implementation of CORBA Object.
36  //
37  public class CORBAObjectImpl extends org.omg.CORBA_2_3.portable.ObjectImpl
38  {
39      public String[] _ids()
40      {
41          String[] typeids = new String[1];
42          typeids[0] = "IDL:omg.org/CORBA/Object:1.0";
43          return typeids;
44      }
45  }

```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/ContextImpl.java
      * Line Number: 36
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
26   * Licensed Materials - Property of IBM
27   * RMI-IIOP v1.0
28   * Copyright IBM Corp. 1998 1999  All Rights Reserved
29   *
30   */
31  
32  package org.jboss.com.sun.corba.se.impl.corba;
33  
34  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
35  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
36  import org.omg.CORBA.Any;
37  import org.omg.CORBA.Context;
38  import org.omg.CORBA.NVList;
39  
40  public final class ContextImpl extends Context
41  {
42  
43      private ORBUtilSystemException wrapper;
44  
45      public ContextImpl(org.omg.CORBA.ORB orb)
46      {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/ContextImpl.java
      * Line Number: 37
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
27   * RMI-IIOP v1.0
28   * Copyright IBM Corp. 1998 1999  All Rights Reserved
29   *
30   */
31  
32  package org.jboss.com.sun.corba.se.impl.corba;
33  
34  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
35  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
36  import org.omg.CORBA.Any;
37  import org.omg.CORBA.Context;
38  import org.omg.CORBA.NVList;
39  
40  public final class ContextImpl extends Context
41  {
42  
43      private ORBUtilSystemException wrapper;
44  
45      public ContextImpl(org.omg.CORBA.ORB orb)
46      {
47          wrapper = ORBUtilSystemException.get((org.jboss.com.sun.corba.se.spi.orb.ORB) orb,
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/ContextImpl.java
      * Line Number: 38
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
28   * Copyright IBM Corp. 1998 1999  All Rights Reserved
29   *
30   */
31  
32  package org.jboss.com.sun.corba.se.impl.corba;
33  
34  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
35  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
36  import org.omg.CORBA.Any;
37  import org.omg.CORBA.Context;
38  import org.omg.CORBA.NVList;
39  
40  public final class ContextImpl extends Context
41  {
42  
43      private ORBUtilSystemException wrapper;
44  
45      public ContextImpl(org.omg.CORBA.ORB orb)
46      {
47          wrapper = ORBUtilSystemException.get((org.jboss.com.sun.corba.se.spi.orb.ORB) orb,
48                  CORBALogDomains.RPC_PRESENTATION);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/ContextImpl.java
      * Line Number: 45
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
35  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
36  import org.omg.CORBA.Any;
37  import org.omg.CORBA.Context;
38  import org.omg.CORBA.NVList;
39  
40  public final class ContextImpl extends Context
41  {
42  
43      private ORBUtilSystemException wrapper;
44  
45      public ContextImpl(org.omg.CORBA.ORB orb)
46      {
47          wrapper = ORBUtilSystemException.get((org.jboss.com.sun.corba.se.spi.orb.ORB) orb,
48                  CORBALogDomains.RPC_PRESENTATION);
49      }
50  
51      public ContextImpl(Context parent)
52      {
53          throw wrapper.contextNotImplemented();
54      }
55  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/ContextListImpl.java
      * Line Number: 36
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
26   * Licensed Materials - Property of IBM
27   * RMI-IIOP v1.0
28   * Copyright IBM Corp. 1998 1999  All Rights Reserved
29   *
30   */
31  
32  package org.jboss.com.sun.corba.se.impl.corba;
33  
34  import java.util.Vector;
35  
36  import org.omg.CORBA.Bounds;
37  import org.omg.CORBA.ContextList;
38  
39  public class ContextListImpl extends ContextList
40  {
41      private final int INITIAL_CAPACITY = 2;
42  
43      private final int CAPACITY_INCREMENT = 2;
44  
45      private Vector<String> _contexts;
46  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/ContextListImpl.java
      * Line Number: 37
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
27   * RMI-IIOP v1.0
28   * Copyright IBM Corp. 1998 1999  All Rights Reserved
29   *
30   */
31  
32  package org.jboss.com.sun.corba.se.impl.corba;
33  
34  import java.util.Vector;
35  
36  import org.omg.CORBA.Bounds;
37  import org.omg.CORBA.ContextList;
38  
39  public class ContextListImpl extends ContextList
40  {
41      private final int INITIAL_CAPACITY = 2;
42  
43      private final int CAPACITY_INCREMENT = 2;
44  
45      private Vector<String> _contexts;
46  
47      public ContextListImpl(org.omg.CORBA.ORB orb)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/ContextListImpl.java
      * Line Number: 47
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
37  import org.omg.CORBA.ContextList;
38  
39  public class ContextListImpl extends ContextList
40  {
41      private final int INITIAL_CAPACITY = 2;
42  
43      private final int CAPACITY_INCREMENT = 2;
44  
45      private Vector<String> _contexts;
46  
47      public ContextListImpl(org.omg.CORBA.ORB orb)
48      {
49          _contexts = new Vector<String>(INITIAL_CAPACITY, CAPACITY_INCREMENT);
50      }
51  
52      public int count()
53      {
54          return _contexts.size();
55      }
56  
57      public void add(String ctxt)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/EnvironmentImpl.java
      * Line Number: 34
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
24   */
25  /*
26   * Licensed Materials - Property of IBM
27   * RMI-IIOP v1.0
28   * Copyright IBM Corp. 1998 1999  All Rights Reserved
29   *
30   */
31  
32  package org.jboss.com.sun.corba.se.impl.corba;
33  
34  import org.omg.CORBA.Environment;
35  
36  public class EnvironmentImpl extends Environment {
37  
38      private Exception _exc;
39  
40      public EnvironmentImpl()
41      {
42      }
43  
44      public Exception exception()
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/ExceptionListImpl.java
      * Line Number: 36
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
26   * Licensed Materials - Property of IBM
27   * RMI-IIOP v1.0
28   * Copyright IBM Corp. 1998 1999  All Rights Reserved
29   *
30   */
31  
32  package org.jboss.com.sun.corba.se.impl.corba;
33  
34  import java.util.Vector;
35  
36  import org.omg.CORBA.Bounds;
37  import org.omg.CORBA.ExceptionList;
38  import org.omg.CORBA.TypeCode;
39  
40  public class ExceptionListImpl extends ExceptionList
41  {
42  
43      private final int INITIAL_CAPACITY = 2;
44  
45      private final int CAPACITY_INCREMENT = 2;
46  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/ExceptionListImpl.java
      * Line Number: 37
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
27   * RMI-IIOP v1.0
28   * Copyright IBM Corp. 1998 1999  All Rights Reserved
29   *
30   */
31  
32  package org.jboss.com.sun.corba.se.impl.corba;
33  
34  import java.util.Vector;
35  
36  import org.omg.CORBA.Bounds;
37  import org.omg.CORBA.ExceptionList;
38  import org.omg.CORBA.TypeCode;
39  
40  public class ExceptionListImpl extends ExceptionList
41  {
42  
43      private final int INITIAL_CAPACITY = 2;
44  
45      private final int CAPACITY_INCREMENT = 2;
46  
47      private Vector<TypeCode> _exceptions;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/ExceptionListImpl.java
      * Line Number: 38
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
28   * Copyright IBM Corp. 1998 1999  All Rights Reserved
29   *
30   */
31  
32  package org.jboss.com.sun.corba.se.impl.corba;
33  
34  import java.util.Vector;
35  
36  import org.omg.CORBA.Bounds;
37  import org.omg.CORBA.ExceptionList;
38  import org.omg.CORBA.TypeCode;
39  
40  public class ExceptionListImpl extends ExceptionList
41  {
42  
43      private final int INITIAL_CAPACITY = 2;
44  
45      private final int CAPACITY_INCREMENT = 2;
46  
47      private Vector<TypeCode> _exceptions;
48  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/NVListImpl.java
      * Line Number: 37
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
27   * RMI-IIOP v1.0
28   * Copyright IBM Corp. 1998 1999  All Rights Reserved
29   *
30   */
31  
32  package org.jboss.com.sun.corba.se.impl.corba;
33  
34  import java.util.Vector;
35  
36  import org.jboss.com.sun.corba.se.spi.orb.ORB;
37  import org.omg.CORBA.Any;
38  import org.omg.CORBA.Bounds;
39  import org.omg.CORBA.NVList;
40  import org.omg.CORBA.NamedValue;
41  
42  public class NVListImpl extends NVList
43  {
44      private final int INITIAL_CAPACITY = 4;
45  
46      private final int CAPACITY_INCREMENT = 2;
47  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/NVListImpl.java
      * Line Number: 38
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
28   * Copyright IBM Corp. 1998 1999  All Rights Reserved
29   *
30   */
31  
32  package org.jboss.com.sun.corba.se.impl.corba;
33  
34  import java.util.Vector;
35  
36  import org.jboss.com.sun.corba.se.spi.orb.ORB;
37  import org.omg.CORBA.Any;
38  import org.omg.CORBA.Bounds;
39  import org.omg.CORBA.NVList;
40  import org.omg.CORBA.NamedValue;
41  
42  public class NVListImpl extends NVList
43  {
44      private final int INITIAL_CAPACITY = 4;
45  
46      private final int CAPACITY_INCREMENT = 2;
47  
48      private Vector<NamedValue> _namedValues;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/NVListImpl.java
      * Line Number: 39
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
29   *
30   */
31  
32  package org.jboss.com.sun.corba.se.impl.corba;
33  
34  import java.util.Vector;
35  
36  import org.jboss.com.sun.corba.se.spi.orb.ORB;
37  import org.omg.CORBA.Any;
38  import org.omg.CORBA.Bounds;
39  import org.omg.CORBA.NVList;
40  import org.omg.CORBA.NamedValue;
41  
42  public class NVListImpl extends NVList
43  {
44      private final int INITIAL_CAPACITY = 4;
45  
46      private final int CAPACITY_INCREMENT = 2;
47  
48      private Vector<NamedValue> _namedValues;
49  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/NVListImpl.java
      * Line Number: 40
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
30   */
31  
32  package org.jboss.com.sun.corba.se.impl.corba;
33  
34  import java.util.Vector;
35  
36  import org.jboss.com.sun.corba.se.spi.orb.ORB;
37  import org.omg.CORBA.Any;
38  import org.omg.CORBA.Bounds;
39  import org.omg.CORBA.NVList;
40  import org.omg.CORBA.NamedValue;
41  
42  public class NVListImpl extends NVList
43  {
44      private final int INITIAL_CAPACITY = 4;
45  
46      private final int CAPACITY_INCREMENT = 2;
47  
48      private Vector<NamedValue> _namedValues;
49  
50      private ORB orb;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/NamedValueImpl.java
      * Line Number: 35
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
25  /*
26   * Licensed Materials - Property of IBM
27   * RMI-IIOP v1.0
28   * Copyright IBM Corp. 1998 1999  All Rights Reserved
29   *
30   */
31  
32  package org.jboss.com.sun.corba.se.impl.corba;
33  
34  import org.jboss.com.sun.corba.se.spi.orb.ORB;
35  import org.omg.CORBA.Any;
36  import org.omg.CORBA.NamedValue;
37  
38  public class NamedValueImpl extends NamedValue
39  {
40      private String _name;
41  
42      private Any _value;
43  
44      private int _flags;
45  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/NamedValueImpl.java
      * Line Number: 36
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
26   * Licensed Materials - Property of IBM
27   * RMI-IIOP v1.0
28   * Copyright IBM Corp. 1998 1999  All Rights Reserved
29   *
30   */
31  
32  package org.jboss.com.sun.corba.se.impl.corba;
33  
34  import org.jboss.com.sun.corba.se.spi.orb.ORB;
35  import org.omg.CORBA.Any;
36  import org.omg.CORBA.NamedValue;
37  
38  public class NamedValueImpl extends NamedValue
39  {
40      private String _name;
41  
42      private Any _value;
43  
44      private int _flags;
45  
46      private ORB _orb;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/PrincipalImpl.java
      * Line Number: 35
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
25  /*
26   * Licensed Materials - Property of IBM
27   * RMI-IIOP v1.0
28   * Copyright IBM Corp. 1998 1999  All Rights Reserved
29   *
30   */
31  
32  package org.jboss.com.sun.corba.se.impl.corba;
33  
34  @SuppressWarnings("deprecation")
35  public class PrincipalImpl extends org.omg.CORBA.Principal
36  {
37      private byte[] value;
38  
39      public void name(byte[] value)
40      {
41          this.value = value;
42      }
43  
44      public byte[] name()
45      {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/RequestImpl.java
      * Line Number: 126
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/RequestImpl.java
      * Line Number: 175
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/RequestImpl.java
      * Line Number: 180
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/RequestImpl.java
      * Line Number: 185
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/RequestImpl.java
      * Line Number: 190
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/RequestImpl.java
      * Line Number: 195
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/RequestImpl.java
      * Line Number: 200
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/RequestImpl.java
      * Line Number: 247
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/RequestImpl.java
      * Line Number: 267
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/RequestImpl.java
      * Line Number: 299
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/RequestImpl.java
      * Line Number: 358
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/RequestImpl.java
      * Line Number: 38
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
28   * Copyright IBM Corp. 1998 1999  All Rights Reserved
29   *
30   */
31  
32  package org.jboss.com.sun.corba.se.impl.corba;
33  
34  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
35  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
36  import org.jboss.com.sun.corba.se.spi.orb.ORB;
37  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
38  import org.omg.CORBA.ARG_IN;
39  import org.omg.CORBA.ARG_INOUT;
40  import org.omg.CORBA.ARG_OUT;
41  import org.omg.CORBA.Any;
42  import org.omg.CORBA.Context;
43  import org.omg.CORBA.ContextList;
44  import org.omg.CORBA.Environment;
45  import org.omg.CORBA.ExceptionList;
46  import org.omg.CORBA.NVList;
47  import org.omg.CORBA.NamedValue;
48  import org.omg.CORBA.Request;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/RequestImpl.java
      * Line Number: 39
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
29   *
30   */
31  
32  package org.jboss.com.sun.corba.se.impl.corba;
33  
34  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
35  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
36  import org.jboss.com.sun.corba.se.spi.orb.ORB;
37  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
38  import org.omg.CORBA.ARG_IN;
39  import org.omg.CORBA.ARG_INOUT;
40  import org.omg.CORBA.ARG_OUT;
41  import org.omg.CORBA.Any;
42  import org.omg.CORBA.Context;
43  import org.omg.CORBA.ContextList;
44  import org.omg.CORBA.Environment;
45  import org.omg.CORBA.ExceptionList;
46  import org.omg.CORBA.NVList;
47  import org.omg.CORBA.NamedValue;
48  import org.omg.CORBA.Request;
49  import org.omg.CORBA.SystemException;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/RequestImpl.java
      * Line Number: 40
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
30   */
31  
32  package org.jboss.com.sun.corba.se.impl.corba;
33  
34  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
35  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
36  import org.jboss.com.sun.corba.se.spi.orb.ORB;
37  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
38  import org.omg.CORBA.ARG_IN;
39  import org.omg.CORBA.ARG_INOUT;
40  import org.omg.CORBA.ARG_OUT;
41  import org.omg.CORBA.Any;
42  import org.omg.CORBA.Context;
43  import org.omg.CORBA.ContextList;
44  import org.omg.CORBA.Environment;
45  import org.omg.CORBA.ExceptionList;
46  import org.omg.CORBA.NVList;
47  import org.omg.CORBA.NamedValue;
48  import org.omg.CORBA.Request;
49  import org.omg.CORBA.SystemException;
50  import org.omg.CORBA.TCKind;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/RequestImpl.java
      * Line Number: 41
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
31  
32  package org.jboss.com.sun.corba.se.impl.corba;
33  
34  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
35  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
36  import org.jboss.com.sun.corba.se.spi.orb.ORB;
37  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
38  import org.omg.CORBA.ARG_IN;
39  import org.omg.CORBA.ARG_INOUT;
40  import org.omg.CORBA.ARG_OUT;
41  import org.omg.CORBA.Any;
42  import org.omg.CORBA.Context;
43  import org.omg.CORBA.ContextList;
44  import org.omg.CORBA.Environment;
45  import org.omg.CORBA.ExceptionList;
46  import org.omg.CORBA.NVList;
47  import org.omg.CORBA.NamedValue;
48  import org.omg.CORBA.Request;
49  import org.omg.CORBA.SystemException;
50  import org.omg.CORBA.TCKind;
51  import org.omg.CORBA.TypeCode;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/RequestImpl.java
      * Line Number: 42
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
32  package org.jboss.com.sun.corba.se.impl.corba;
33  
34  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
35  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
36  import org.jboss.com.sun.corba.se.spi.orb.ORB;
37  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
38  import org.omg.CORBA.ARG_IN;
39  import org.omg.CORBA.ARG_INOUT;
40  import org.omg.CORBA.ARG_OUT;
41  import org.omg.CORBA.Any;
42  import org.omg.CORBA.Context;
43  import org.omg.CORBA.ContextList;
44  import org.omg.CORBA.Environment;
45  import org.omg.CORBA.ExceptionList;
46  import org.omg.CORBA.NVList;
47  import org.omg.CORBA.NamedValue;
48  import org.omg.CORBA.Request;
49  import org.omg.CORBA.SystemException;
50  import org.omg.CORBA.TCKind;
51  import org.omg.CORBA.TypeCode;
52  import org.omg.CORBA.portable.ApplicationException;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/RequestImpl.java
      * Line Number: 43
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
33  
34  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
35  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
36  import org.jboss.com.sun.corba.se.spi.orb.ORB;
37  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
38  import org.omg.CORBA.ARG_IN;
39  import org.omg.CORBA.ARG_INOUT;
40  import org.omg.CORBA.ARG_OUT;
41  import org.omg.CORBA.Any;
42  import org.omg.CORBA.Context;
43  import org.omg.CORBA.ContextList;
44  import org.omg.CORBA.Environment;
45  import org.omg.CORBA.ExceptionList;
46  import org.omg.CORBA.NVList;
47  import org.omg.CORBA.NamedValue;
48  import org.omg.CORBA.Request;
49  import org.omg.CORBA.SystemException;
50  import org.omg.CORBA.TCKind;
51  import org.omg.CORBA.TypeCode;
52  import org.omg.CORBA.portable.ApplicationException;
53  import org.omg.CORBA.portable.InputStream;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/RequestImpl.java
      * Line Number: 44
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
34  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
35  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
36  import org.jboss.com.sun.corba.se.spi.orb.ORB;
37  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
38  import org.omg.CORBA.ARG_IN;
39  import org.omg.CORBA.ARG_INOUT;
40  import org.omg.CORBA.ARG_OUT;
41  import org.omg.CORBA.Any;
42  import org.omg.CORBA.Context;
43  import org.omg.CORBA.ContextList;
44  import org.omg.CORBA.Environment;
45  import org.omg.CORBA.ExceptionList;
46  import org.omg.CORBA.NVList;
47  import org.omg.CORBA.NamedValue;
48  import org.omg.CORBA.Request;
49  import org.omg.CORBA.SystemException;
50  import org.omg.CORBA.TCKind;
51  import org.omg.CORBA.TypeCode;
52  import org.omg.CORBA.portable.ApplicationException;
53  import org.omg.CORBA.portable.InputStream;
54  import org.omg.CORBA.portable.OutputStream;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/RequestImpl.java
      * Line Number: 45
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
35  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
36  import org.jboss.com.sun.corba.se.spi.orb.ORB;
37  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
38  import org.omg.CORBA.ARG_IN;
39  import org.omg.CORBA.ARG_INOUT;
40  import org.omg.CORBA.ARG_OUT;
41  import org.omg.CORBA.Any;
42  import org.omg.CORBA.Context;
43  import org.omg.CORBA.ContextList;
44  import org.omg.CORBA.Environment;
45  import org.omg.CORBA.ExceptionList;
46  import org.omg.CORBA.NVList;
47  import org.omg.CORBA.NamedValue;
48  import org.omg.CORBA.Request;
49  import org.omg.CORBA.SystemException;
50  import org.omg.CORBA.TCKind;
51  import org.omg.CORBA.TypeCode;
52  import org.omg.CORBA.portable.ApplicationException;
53  import org.omg.CORBA.portable.InputStream;
54  import org.omg.CORBA.portable.OutputStream;
55  import org.omg.CORBA.portable.RemarshalException;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/RequestImpl.java
      * Line Number: 46
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
36  import org.jboss.com.sun.corba.se.spi.orb.ORB;
37  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
38  import org.omg.CORBA.ARG_IN;
39  import org.omg.CORBA.ARG_INOUT;
40  import org.omg.CORBA.ARG_OUT;
41  import org.omg.CORBA.Any;
42  import org.omg.CORBA.Context;
43  import org.omg.CORBA.ContextList;
44  import org.omg.CORBA.Environment;
45  import org.omg.CORBA.ExceptionList;
46  import org.omg.CORBA.NVList;
47  import org.omg.CORBA.NamedValue;
48  import org.omg.CORBA.Request;
49  import org.omg.CORBA.SystemException;
50  import org.omg.CORBA.TCKind;
51  import org.omg.CORBA.TypeCode;
52  import org.omg.CORBA.portable.ApplicationException;
53  import org.omg.CORBA.portable.InputStream;
54  import org.omg.CORBA.portable.OutputStream;
55  import org.omg.CORBA.portable.RemarshalException;
56  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/RequestImpl.java
      * Line Number: 47
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
37  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
38  import org.omg.CORBA.ARG_IN;
39  import org.omg.CORBA.ARG_INOUT;
40  import org.omg.CORBA.ARG_OUT;
41  import org.omg.CORBA.Any;
42  import org.omg.CORBA.Context;
43  import org.omg.CORBA.ContextList;
44  import org.omg.CORBA.Environment;
45  import org.omg.CORBA.ExceptionList;
46  import org.omg.CORBA.NVList;
47  import org.omg.CORBA.NamedValue;
48  import org.omg.CORBA.Request;
49  import org.omg.CORBA.SystemException;
50  import org.omg.CORBA.TCKind;
51  import org.omg.CORBA.TypeCode;
52  import org.omg.CORBA.portable.ApplicationException;
53  import org.omg.CORBA.portable.InputStream;
54  import org.omg.CORBA.portable.OutputStream;
55  import org.omg.CORBA.portable.RemarshalException;
56  
57  public class RequestImpl extends Request
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/RequestImpl.java
      * Line Number: 48
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
38  import org.omg.CORBA.ARG_IN;
39  import org.omg.CORBA.ARG_INOUT;
40  import org.omg.CORBA.ARG_OUT;
41  import org.omg.CORBA.Any;
42  import org.omg.CORBA.Context;
43  import org.omg.CORBA.ContextList;
44  import org.omg.CORBA.Environment;
45  import org.omg.CORBA.ExceptionList;
46  import org.omg.CORBA.NVList;
47  import org.omg.CORBA.NamedValue;
48  import org.omg.CORBA.Request;
49  import org.omg.CORBA.SystemException;
50  import org.omg.CORBA.TCKind;
51  import org.omg.CORBA.TypeCode;
52  import org.omg.CORBA.portable.ApplicationException;
53  import org.omg.CORBA.portable.InputStream;
54  import org.omg.CORBA.portable.OutputStream;
55  import org.omg.CORBA.portable.RemarshalException;
56  
57  public class RequestImpl extends Request
58  {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/RequestImpl.java
      * Line Number: 49
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
39  import org.omg.CORBA.ARG_INOUT;
40  import org.omg.CORBA.ARG_OUT;
41  import org.omg.CORBA.Any;
42  import org.omg.CORBA.Context;
43  import org.omg.CORBA.ContextList;
44  import org.omg.CORBA.Environment;
45  import org.omg.CORBA.ExceptionList;
46  import org.omg.CORBA.NVList;
47  import org.omg.CORBA.NamedValue;
48  import org.omg.CORBA.Request;
49  import org.omg.CORBA.SystemException;
50  import org.omg.CORBA.TCKind;
51  import org.omg.CORBA.TypeCode;
52  import org.omg.CORBA.portable.ApplicationException;
53  import org.omg.CORBA.portable.InputStream;
54  import org.omg.CORBA.portable.OutputStream;
55  import org.omg.CORBA.portable.RemarshalException;
56  
57  public class RequestImpl extends Request
58  {
59      protected org.omg.CORBA.Object _target;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/RequestImpl.java
      * Line Number: 50
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
40  import org.omg.CORBA.ARG_OUT;
41  import org.omg.CORBA.Any;
42  import org.omg.CORBA.Context;
43  import org.omg.CORBA.ContextList;
44  import org.omg.CORBA.Environment;
45  import org.omg.CORBA.ExceptionList;
46  import org.omg.CORBA.NVList;
47  import org.omg.CORBA.NamedValue;
48  import org.omg.CORBA.Request;
49  import org.omg.CORBA.SystemException;
50  import org.omg.CORBA.TCKind;
51  import org.omg.CORBA.TypeCode;
52  import org.omg.CORBA.portable.ApplicationException;
53  import org.omg.CORBA.portable.InputStream;
54  import org.omg.CORBA.portable.OutputStream;
55  import org.omg.CORBA.portable.RemarshalException;
56  
57  public class RequestImpl extends Request
58  {
59      protected org.omg.CORBA.Object _target;
60  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/RequestImpl.java
      * Line Number: 51
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
41  import org.omg.CORBA.Any;
42  import org.omg.CORBA.Context;
43  import org.omg.CORBA.ContextList;
44  import org.omg.CORBA.Environment;
45  import org.omg.CORBA.ExceptionList;
46  import org.omg.CORBA.NVList;
47  import org.omg.CORBA.NamedValue;
48  import org.omg.CORBA.Request;
49  import org.omg.CORBA.SystemException;
50  import org.omg.CORBA.TCKind;
51  import org.omg.CORBA.TypeCode;
52  import org.omg.CORBA.portable.ApplicationException;
53  import org.omg.CORBA.portable.InputStream;
54  import org.omg.CORBA.portable.OutputStream;
55  import org.omg.CORBA.portable.RemarshalException;
56  
57  public class RequestImpl extends Request
58  {
59      protected org.omg.CORBA.Object _target;
60  
61      protected String _opName;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/RequestImpl.java
      * Line Number: 52
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
42  import org.omg.CORBA.Context;
43  import org.omg.CORBA.ContextList;
44  import org.omg.CORBA.Environment;
45  import org.omg.CORBA.ExceptionList;
46  import org.omg.CORBA.NVList;
47  import org.omg.CORBA.NamedValue;
48  import org.omg.CORBA.Request;
49  import org.omg.CORBA.SystemException;
50  import org.omg.CORBA.TCKind;
51  import org.omg.CORBA.TypeCode;
52  import org.omg.CORBA.portable.ApplicationException;
53  import org.omg.CORBA.portable.InputStream;
54  import org.omg.CORBA.portable.OutputStream;
55  import org.omg.CORBA.portable.RemarshalException;
56  
57  public class RequestImpl extends Request
58  {
59      protected org.omg.CORBA.Object _target;
60  
61      protected String _opName;
62  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/RequestImpl.java
      * Line Number: 53
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
43  import org.omg.CORBA.ContextList;
44  import org.omg.CORBA.Environment;
45  import org.omg.CORBA.ExceptionList;
46  import org.omg.CORBA.NVList;
47  import org.omg.CORBA.NamedValue;
48  import org.omg.CORBA.Request;
49  import org.omg.CORBA.SystemException;
50  import org.omg.CORBA.TCKind;
51  import org.omg.CORBA.TypeCode;
52  import org.omg.CORBA.portable.ApplicationException;
53  import org.omg.CORBA.portable.InputStream;
54  import org.omg.CORBA.portable.OutputStream;
55  import org.omg.CORBA.portable.RemarshalException;
56  
57  public class RequestImpl extends Request
58  {
59      protected org.omg.CORBA.Object _target;
60  
61      protected String _opName;
62  
63      protected NVList _arguments;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/RequestImpl.java
      * Line Number: 54
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
44  import org.omg.CORBA.Environment;
45  import org.omg.CORBA.ExceptionList;
46  import org.omg.CORBA.NVList;
47  import org.omg.CORBA.NamedValue;
48  import org.omg.CORBA.Request;
49  import org.omg.CORBA.SystemException;
50  import org.omg.CORBA.TCKind;
51  import org.omg.CORBA.TypeCode;
52  import org.omg.CORBA.portable.ApplicationException;
53  import org.omg.CORBA.portable.InputStream;
54  import org.omg.CORBA.portable.OutputStream;
55  import org.omg.CORBA.portable.RemarshalException;
56  
57  public class RequestImpl extends Request
58  {
59      protected org.omg.CORBA.Object _target;
60  
61      protected String _opName;
62  
63      protected NVList _arguments;
64  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/RequestImpl.java
      * Line Number: 55
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
45  import org.omg.CORBA.ExceptionList;
46  import org.omg.CORBA.NVList;
47  import org.omg.CORBA.NamedValue;
48  import org.omg.CORBA.Request;
49  import org.omg.CORBA.SystemException;
50  import org.omg.CORBA.TCKind;
51  import org.omg.CORBA.TypeCode;
52  import org.omg.CORBA.portable.ApplicationException;
53  import org.omg.CORBA.portable.InputStream;
54  import org.omg.CORBA.portable.OutputStream;
55  import org.omg.CORBA.portable.RemarshalException;
56  
57  public class RequestImpl extends Request
58  {
59      protected org.omg.CORBA.Object _target;
60  
61      protected String _opName;
62  
63      protected NVList _arguments;
64  
65      protected ExceptionList _exceptions;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/RequestImpl.java
      * Line Number: 59
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
49  import org.omg.CORBA.SystemException;
50  import org.omg.CORBA.TCKind;
51  import org.omg.CORBA.TypeCode;
52  import org.omg.CORBA.portable.ApplicationException;
53  import org.omg.CORBA.portable.InputStream;
54  import org.omg.CORBA.portable.OutputStream;
55  import org.omg.CORBA.portable.RemarshalException;
56  
57  public class RequestImpl extends Request
58  {
59      protected org.omg.CORBA.Object _target;
60  
61      protected String _opName;
62  
63      protected NVList _arguments;
64  
65      protected ExceptionList _exceptions;
66  
67      private NamedValue _result;
68  
69      protected Environment _env;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/RequestImpl.java
      * Line Number: 87
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
77      private ORBUtilSystemException _wrapper;
78  
79      // invocation-specific stuff
80      protected boolean _isOneWay = false;
81  
82      // support for deferred invocations.
83      // protected instead of private since it needs to be set by the thread object doing the asynchronous invocation.
84      protected boolean gotResponse = false;
85  
86      // REVISIT - used to be protected. Now public so it can be accessed from xgiop.
87      public RequestImpl(ORB orb, org.omg.CORBA.Object targetObject, Context ctx, String operationName,
88              NVList argumentList, NamedValue resultContainer, ExceptionList exceptionList, ContextList ctxList)
89      {
90  
91          // initialize the orb
92          _orb = orb;
93          _wrapper = ORBUtilSystemException.get(orb, CORBALogDomains.OA_INVOCATION);
94  
95          // initialize target, context and operation name
96          _target = targetObject;
97          _ctx = ctx;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/TCUtility.java
      * Line Number: 118
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
108  
109              case TCKind._tk_TypeCode :
110                  s.write_TypeCode((TypeCode) o);
111                  break;
112  
113              case TCKind._tk_Principal :
114                  s.write_Principal((Principal) o);
115                  break;
116  
117              case TCKind._tk_objref :
118                  s.write_Object((org.omg.CORBA.Object) o);
119                  break;
120  
121              case TCKind._tk_longlong :
122                  s.write_longlong(l);
123                  break;
124  
125              case TCKind._tk_ulonglong :
126                  s.write_ulonglong(l);
127                  break;
128  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/TCUtility.java
      * Line Number: 143
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
133              case TCKind._tk_string :
134                  s.write_string((String) o);
135                  break;
136  
137              case TCKind._tk_wstring :
138                  s.write_wstring((String) o);
139                  break;
140  
141              case TCKind._tk_value :
142              case TCKind._tk_value_box :
143                  ((org.omg.CORBA_2_3.portable.OutputStream) s).write_value((Serializable) o);
144                  break;
145  
146              case TCKind._tk_fixed :
147                  // _REVISIT_ As soon as the java-rtf adds digits and scale parameters to
148                  // OutputStream, this check will be unnecessary
149                  if (s instanceof CDROutputStream)
150                  {
151                      try
152                      {
153                          ((CDROutputStream) s).write_fixed((BigDecimal) o, typeCode.fixed_digits(),
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/TCUtility.java
      * Line Number: 176
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
166              case TCKind._tk_struct :
167              case TCKind._tk_union :
168              case TCKind._tk_sequence :
169              case TCKind._tk_array :
170              case TCKind._tk_alias :
171              case TCKind._tk_except :
172                  ((Streamable) o)._write(s);
173                  break;
174  
175              case TCKind._tk_abstract_interface :
176                  ((org.omg.CORBA_2_3.portable.OutputStream) s).write_abstract_interface(o);
177                  break;
178  
179              case TCKind._tk_longdouble :
180                  // Unspecified for Java
181              default :
182                  ORBUtilSystemException wrapper = ORBUtilSystemException.get(
183                          (org.jboss.com.sun.corba.se.spi.orb.ORB) s.orb(), CORBALogDomains.RPC_PRESENTATION);
184                  throw wrapper.typecodeNotSupported();
185          }
186      }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/TCUtility.java
      * Line Number: 188
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
178  
179              case TCKind._tk_longdouble :
180                  // Unspecified for Java
181              default :
182                  ORBUtilSystemException wrapper = ORBUtilSystemException.get(
183                          (org.jboss.com.sun.corba.se.spi.orb.ORB) s.orb(), CORBALogDomains.RPC_PRESENTATION);
184                  throw wrapper.typecodeNotSupported();
185          }
186      }
187  
188      static void unmarshalIn(org.omg.CORBA.portable.InputStream s, TypeCode typeCode, long[] la, Object[] oa)
189      {
190          int type = typeCode.kind().value();
191          long l = 0;
192          Object o = oa[0];
193  
194          switch (type)
195          {
196              case TCKind._tk_null :
197              case TCKind._tk_void :
198              case TCKind._tk_native :
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/TCUtility.java
      * Line Number: 283
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
273              case TCKind._tk_string :
274                  o = s.read_string();
275                  break;
276  
277              case TCKind._tk_wstring :
278                  o = s.read_wstring();
279                  break;
280  
281              case TCKind._tk_value :
282              case TCKind._tk_value_box :
283                  o = ((org.omg.CORBA_2_3.portable.InputStream) s).read_value();
284                  break;
285  
286              case TCKind._tk_fixed :
287                  try
288                  {
289                      // _REVISIT_ As soon as the java-rtf adds digits and scale parameters to
290                      // InputStream, this check will be unnecessary
291                      if (s instanceof CDRInputStream)
292                      {
293                          o = ((CDRInputStream) s).read_fixed(typeCode.fixed_digits(), typeCode.fixed_scale());
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/TCUtility.java
      * Line Number: 316
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
306              case TCKind._tk_struct :
307              case TCKind._tk_union :
308              case TCKind._tk_sequence :
309              case TCKind._tk_array :
310              case TCKind._tk_alias :
311              case TCKind._tk_except :
312                  ((Streamable) o)._read(s);
313                  break;
314  
315              case TCKind._tk_abstract_interface :
316                  o = ((org.omg.CORBA_2_3.portable.InputStream) s).read_abstract_interface();
317                  break;
318  
319              case TCKind._tk_longdouble :
320                  // Unspecified for Java
321              default :
322                  ORBUtilSystemException wrapper = ORBUtilSystemException.get(
323                          (org.jboss.com.sun.corba.se.spi.orb.ORB) s.orb(), CORBALogDomains.RPC_PRESENTATION);
324                  throw wrapper.typecodeNotSupported();
325          }
326  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/TCUtility.java
      * Line Number: 41
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
31  
32  package org.jboss.com.sun.corba.se.impl.corba;
33  
34  import java.io.Serializable;
35  import java.math.BigDecimal;
36  
37  import org.jboss.com.sun.corba.se.impl.encoding.CDRInputStream;
38  import org.jboss.com.sun.corba.se.impl.encoding.CDROutputStream;
39  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
40  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
41  import org.omg.CORBA.Any;
42  import org.omg.CORBA.Principal;
43  import org.omg.CORBA.TCKind;
44  import org.omg.CORBA.TypeCode;
45  import org.omg.CORBA.TypeCodePackage.BadKind;
46  import org.omg.CORBA.portable.Streamable;
47  
48  /**
49   * Static functions for TypeCode interpretation.
50   */
51  @SuppressWarnings("deprecation")
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/TCUtility.java
      * Line Number: 42
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
32  package org.jboss.com.sun.corba.se.impl.corba;
33  
34  import java.io.Serializable;
35  import java.math.BigDecimal;
36  
37  import org.jboss.com.sun.corba.se.impl.encoding.CDRInputStream;
38  import org.jboss.com.sun.corba.se.impl.encoding.CDROutputStream;
39  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
40  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
41  import org.omg.CORBA.Any;
42  import org.omg.CORBA.Principal;
43  import org.omg.CORBA.TCKind;
44  import org.omg.CORBA.TypeCode;
45  import org.omg.CORBA.TypeCodePackage.BadKind;
46  import org.omg.CORBA.portable.Streamable;
47  
48  /**
49   * Static functions for TypeCode interpretation.
50   */
51  @SuppressWarnings("deprecation")
52  public final class TCUtility
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/TCUtility.java
      * Line Number: 43
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
33  
34  import java.io.Serializable;
35  import java.math.BigDecimal;
36  
37  import org.jboss.com.sun.corba.se.impl.encoding.CDRInputStream;
38  import org.jboss.com.sun.corba.se.impl.encoding.CDROutputStream;
39  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
40  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
41  import org.omg.CORBA.Any;
42  import org.omg.CORBA.Principal;
43  import org.omg.CORBA.TCKind;
44  import org.omg.CORBA.TypeCode;
45  import org.omg.CORBA.TypeCodePackage.BadKind;
46  import org.omg.CORBA.portable.Streamable;
47  
48  /**
49   * Static functions for TypeCode interpretation.
50   */
51  @SuppressWarnings("deprecation")
52  public final class TCUtility
53  {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/TCUtility.java
      * Line Number: 44
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
34  import java.io.Serializable;
35  import java.math.BigDecimal;
36  
37  import org.jboss.com.sun.corba.se.impl.encoding.CDRInputStream;
38  import org.jboss.com.sun.corba.se.impl.encoding.CDROutputStream;
39  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
40  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
41  import org.omg.CORBA.Any;
42  import org.omg.CORBA.Principal;
43  import org.omg.CORBA.TCKind;
44  import org.omg.CORBA.TypeCode;
45  import org.omg.CORBA.TypeCodePackage.BadKind;
46  import org.omg.CORBA.portable.Streamable;
47  
48  /**
49   * Static functions for TypeCode interpretation.
50   */
51  @SuppressWarnings("deprecation")
52  public final class TCUtility
53  {
54  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/TCUtility.java
      * Line Number: 45
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
35  import java.math.BigDecimal;
36  
37  import org.jboss.com.sun.corba.se.impl.encoding.CDRInputStream;
38  import org.jboss.com.sun.corba.se.impl.encoding.CDROutputStream;
39  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
40  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
41  import org.omg.CORBA.Any;
42  import org.omg.CORBA.Principal;
43  import org.omg.CORBA.TCKind;
44  import org.omg.CORBA.TypeCode;
45  import org.omg.CORBA.TypeCodePackage.BadKind;
46  import org.omg.CORBA.portable.Streamable;
47  
48  /**
49   * Static functions for TypeCode interpretation.
50   */
51  @SuppressWarnings("deprecation")
52  public final class TCUtility
53  {
54  
55      static void marshalIn(org.omg.CORBA.portable.OutputStream s, TypeCode typeCode, long l, Object o)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/TCUtility.java
      * Line Number: 46
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
36  
37  import org.jboss.com.sun.corba.se.impl.encoding.CDRInputStream;
38  import org.jboss.com.sun.corba.se.impl.encoding.CDROutputStream;
39  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
40  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
41  import org.omg.CORBA.Any;
42  import org.omg.CORBA.Principal;
43  import org.omg.CORBA.TCKind;
44  import org.omg.CORBA.TypeCode;
45  import org.omg.CORBA.TypeCodePackage.BadKind;
46  import org.omg.CORBA.portable.Streamable;
47  
48  /**
49   * Static functions for TypeCode interpretation.
50   */
51  @SuppressWarnings("deprecation")
52  public final class TCUtility
53  {
54  
55      static void marshalIn(org.omg.CORBA.portable.OutputStream s, TypeCode typeCode, long l, Object o)
56      {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/TCUtility.java
      * Line Number: 55
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
45  import org.omg.CORBA.TypeCodePackage.BadKind;
46  import org.omg.CORBA.portable.Streamable;
47  
48  /**
49   * Static functions for TypeCode interpretation.
50   */
51  @SuppressWarnings("deprecation")
52  public final class TCUtility
53  {
54  
55      static void marshalIn(org.omg.CORBA.portable.OutputStream s, TypeCode typeCode, long l, Object o)
56      {
57          switch (typeCode.kind().value())
58          {
59              case TCKind._tk_null :
60              case TCKind._tk_void :
61              case TCKind._tk_native :
62                  // nothing to write
63                  break;
64  
65              case TCKind._tk_short :
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/TypeCodeImpl.java
      * Line Number: 1942
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/TypeCodeImpl.java
      * Line Number: 2025
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/TypeCodeImpl.java
      * Line Number: 2026
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/TypeCodeImpl.java
      * Line Number: 2278
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/TypeCodeImpl.java
      * Line Number: 1066
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
1056              case TCKind._tk_struct :
1057              case TCKind._tk_union :
1058              case TCKind._tk_enum :
1059              case TCKind._tk_value :
1060                  return _memberCount;
1061              default :
1062                  throw new BadKind();
1063          }
1064      }
1065  
1066      public String member_name(int index) throws BadKind, org.omg.CORBA.TypeCodePackage.Bounds
1067      {
1068          switch (_kind)
1069          {
1070              case tk_indirect :
1071                  return indirectType().member_name(index);
1072              case TCKind._tk_except :
1073              case TCKind._tk_struct :
1074              case TCKind._tk_union :
1075              case TCKind._tk_enum :
1076              case TCKind._tk_value :
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/TypeCodeImpl.java
      * Line Number: 1083
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
1073              case TCKind._tk_struct :
1074              case TCKind._tk_union :
1075              case TCKind._tk_enum :
1076              case TCKind._tk_value :
1077                  try
1078                  {
1079                      return _memberNames[index];
1080                  }
1081                  catch (ArrayIndexOutOfBoundsException e)
1082                  {
1083                      throw new org.omg.CORBA.TypeCodePackage.Bounds();
1084                  }
1085              default :
1086                  throw new BadKind();
1087          }
1088      }
1089  
1090      public TypeCode member_type(int index) throws BadKind, org.omg.CORBA.TypeCodePackage.Bounds
1091      {
1092          switch (_kind)
1093          {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/TypeCodeImpl.java
      * Line Number: 1090
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
1080                  }
1081                  catch (ArrayIndexOutOfBoundsException e)
1082                  {
1083                      throw new org.omg.CORBA.TypeCodePackage.Bounds();
1084                  }
1085              default :
1086                  throw new BadKind();
1087          }
1088      }
1089  
1090      public TypeCode member_type(int index) throws BadKind, org.omg.CORBA.TypeCodePackage.Bounds
1091      {
1092          switch (_kind)
1093          {
1094              case tk_indirect :
1095                  return indirectType().member_type(index);
1096              case TCKind._tk_except :
1097              case TCKind._tk_struct :
1098              case TCKind._tk_union :
1099              case TCKind._tk_value :
1100                  try
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/TypeCodeImpl.java
      * Line Number: 1106
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
1096              case TCKind._tk_except :
1097              case TCKind._tk_struct :
1098              case TCKind._tk_union :
1099              case TCKind._tk_value :
1100                  try
1101                  {
1102                      return _memberTypes[index];
1103                  }
1104                  catch (ArrayIndexOutOfBoundsException e)
1105                  {
1106                      throw new org.omg.CORBA.TypeCodePackage.Bounds();
1107                  }
1108              default :
1109                  throw new BadKind();
1110          }
1111      }
1112  
1113      public Any member_label(int index) throws BadKind, org.omg.CORBA.TypeCodePackage.Bounds
1114      {
1115          switch (_kind)
1116          {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/TypeCodeImpl.java
      * Line Number: 1113
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
1103                  }
1104                  catch (ArrayIndexOutOfBoundsException e)
1105                  {
1106                      throw new org.omg.CORBA.TypeCodePackage.Bounds();
1107                  }
1108              default :
1109                  throw new BadKind();
1110          }
1111      }
1112  
1113      public Any member_label(int index) throws BadKind, org.omg.CORBA.TypeCodePackage.Bounds
1114      {
1115          switch (_kind)
1116          {
1117              case tk_indirect :
1118                  return indirectType().member_label(index);
1119              case TCKind._tk_union :
1120                  try
1121                  {
1122                      // _REVISIT_ Why create a new Any for this?
1123                      return new AnyImpl(_orb, _unionLabels[index]);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/TypeCodeImpl.java
      * Line Number: 1127
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
1117              case tk_indirect :
1118                  return indirectType().member_label(index);
1119              case TCKind._tk_union :
1120                  try
1121                  {
1122                      // _REVISIT_ Why create a new Any for this?
1123                      return new AnyImpl(_orb, _unionLabels[index]);
1124                  }
1125                  catch (ArrayIndexOutOfBoundsException e)
1126                  {
1127                      throw new org.omg.CORBA.TypeCodePackage.Bounds();
1128                  }
1129              default :
1130                  throw new BadKind();
1131          }
1132      }
1133  
1134      public TypeCode discriminator_type() throws BadKind
1135      {
1136          switch (_kind)
1137          {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/TypeCodeImpl.java
      * Line Number: 1215
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
1205      {
1206          switch (_kind)
1207          {
1208              case TCKind._tk_fixed :
1209                  return _scale;
1210              default :
1211                  throw new BadKind();
1212          }
1213      }
1214  
1215      public short member_visibility(int index) throws BadKind, org.omg.CORBA.TypeCodePackage.Bounds
1216      {
1217          switch (_kind)
1218          {
1219              case tk_indirect :
1220                  return indirectType().member_visibility(index);
1221              case TCKind._tk_value :
1222                  try
1223                  {
1224                      return _memberAccess[index];
1225                  }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/TypeCodeImpl.java
      * Line Number: 1228
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
1218          {
1219              case tk_indirect :
1220                  return indirectType().member_visibility(index);
1221              case TCKind._tk_value :
1222                  try
1223                  {
1224                      return _memberAccess[index];
1225                  }
1226                  catch (ArrayIndexOutOfBoundsException e)
1227                  {
1228                      throw new org.omg.CORBA.TypeCodePackage.Bounds();
1229                  }
1230              default :
1231                  throw new BadKind();
1232          }
1233      }
1234  
1235      public short type_modifier() throws BadKind
1236      {
1237          switch (_kind)
1238          {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/TypeCodeImpl.java
      * Line Number: 31
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
21   * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
22   * or visit www.oracle.com if you need additional information or have any
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.corba;
27  
28  import java.io.ByteArrayOutputStream;
29  import java.io.PrintStream;
30  
31  import org.omg.CORBA.Any;
32  import org.omg.CORBA.StructMember;
33  import org.omg.CORBA.TCKind;
34  import org.omg.CORBA.TypeCode;
35  import org.omg.CORBA.UnionMember;
36  import org.omg.CORBA.ValueMember;
37  import org.omg.CORBA.TypeCodePackage.BadKind;
38  import org.omg.CORBA_2_3.portable.InputStream;
39  import org.omg.CORBA_2_3.portable.OutputStream;
40  
41  import org.jboss.com.sun.corba.se.impl.corba.AnyImpl;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/TypeCodeImpl.java
      * Line Number: 32
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
22   * or visit www.oracle.com if you need additional information or have any
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.corba;
27  
28  import java.io.ByteArrayOutputStream;
29  import java.io.PrintStream;
30  
31  import org.omg.CORBA.Any;
32  import org.omg.CORBA.StructMember;
33  import org.omg.CORBA.TCKind;
34  import org.omg.CORBA.TypeCode;
35  import org.omg.CORBA.UnionMember;
36  import org.omg.CORBA.ValueMember;
37  import org.omg.CORBA.TypeCodePackage.BadKind;
38  import org.omg.CORBA_2_3.portable.InputStream;
39  import org.omg.CORBA_2_3.portable.OutputStream;
40  
41  import org.jboss.com.sun.corba.se.impl.corba.AnyImpl;
42  import org.jboss.com.sun.corba.se.impl.encoding.CDRInputStream;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/TypeCodeImpl.java
      * Line Number: 33
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.corba;
27  
28  import java.io.ByteArrayOutputStream;
29  import java.io.PrintStream;
30  
31  import org.omg.CORBA.Any;
32  import org.omg.CORBA.StructMember;
33  import org.omg.CORBA.TCKind;
34  import org.omg.CORBA.TypeCode;
35  import org.omg.CORBA.UnionMember;
36  import org.omg.CORBA.ValueMember;
37  import org.omg.CORBA.TypeCodePackage.BadKind;
38  import org.omg.CORBA_2_3.portable.InputStream;
39  import org.omg.CORBA_2_3.portable.OutputStream;
40  
41  import org.jboss.com.sun.corba.se.impl.corba.AnyImpl;
42  import org.jboss.com.sun.corba.se.impl.encoding.CDRInputStream;
43  import org.jboss.com.sun.corba.se.impl.encoding.CDROutputStream;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/TypeCodeImpl.java
      * Line Number: 34
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.corba;
27  
28  import java.io.ByteArrayOutputStream;
29  import java.io.PrintStream;
30  
31  import org.omg.CORBA.Any;
32  import org.omg.CORBA.StructMember;
33  import org.omg.CORBA.TCKind;
34  import org.omg.CORBA.TypeCode;
35  import org.omg.CORBA.UnionMember;
36  import org.omg.CORBA.ValueMember;
37  import org.omg.CORBA.TypeCodePackage.BadKind;
38  import org.omg.CORBA_2_3.portable.InputStream;
39  import org.omg.CORBA_2_3.portable.OutputStream;
40  
41  import org.jboss.com.sun.corba.se.impl.corba.AnyImpl;
42  import org.jboss.com.sun.corba.se.impl.encoding.CDRInputStream;
43  import org.jboss.com.sun.corba.se.impl.encoding.CDROutputStream;
44  import org.jboss.com.sun.corba.se.impl.encoding.TypeCodeInputStream;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/TypeCodeImpl.java
      * Line Number: 35
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
25  
26  package org.jboss.com.sun.corba.se.impl.corba;
27  
28  import java.io.ByteArrayOutputStream;
29  import java.io.PrintStream;
30  
31  import org.omg.CORBA.Any;
32  import org.omg.CORBA.StructMember;
33  import org.omg.CORBA.TCKind;
34  import org.omg.CORBA.TypeCode;
35  import org.omg.CORBA.UnionMember;
36  import org.omg.CORBA.ValueMember;
37  import org.omg.CORBA.TypeCodePackage.BadKind;
38  import org.omg.CORBA_2_3.portable.InputStream;
39  import org.omg.CORBA_2_3.portable.OutputStream;
40  
41  import org.jboss.com.sun.corba.se.impl.corba.AnyImpl;
42  import org.jboss.com.sun.corba.se.impl.encoding.CDRInputStream;
43  import org.jboss.com.sun.corba.se.impl.encoding.CDROutputStream;
44  import org.jboss.com.sun.corba.se.impl.encoding.TypeCodeInputStream;
45  import org.jboss.com.sun.corba.se.impl.encoding.TypeCodeOutputStream;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/TypeCodeImpl.java
      * Line Number: 36
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
26  package org.jboss.com.sun.corba.se.impl.corba;
27  
28  import java.io.ByteArrayOutputStream;
29  import java.io.PrintStream;
30  
31  import org.omg.CORBA.Any;
32  import org.omg.CORBA.StructMember;
33  import org.omg.CORBA.TCKind;
34  import org.omg.CORBA.TypeCode;
35  import org.omg.CORBA.UnionMember;
36  import org.omg.CORBA.ValueMember;
37  import org.omg.CORBA.TypeCodePackage.BadKind;
38  import org.omg.CORBA_2_3.portable.InputStream;
39  import org.omg.CORBA_2_3.portable.OutputStream;
40  
41  import org.jboss.com.sun.corba.se.impl.corba.AnyImpl;
42  import org.jboss.com.sun.corba.se.impl.encoding.CDRInputStream;
43  import org.jboss.com.sun.corba.se.impl.encoding.CDROutputStream;
44  import org.jboss.com.sun.corba.se.impl.encoding.TypeCodeInputStream;
45  import org.jboss.com.sun.corba.se.impl.encoding.TypeCodeOutputStream;
46  import org.jboss.com.sun.corba.se.impl.encoding.TypeCodeReader;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/TypeCodeImpl.java
      * Line Number: 37
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
27  
28  import java.io.ByteArrayOutputStream;
29  import java.io.PrintStream;
30  
31  import org.omg.CORBA.Any;
32  import org.omg.CORBA.StructMember;
33  import org.omg.CORBA.TCKind;
34  import org.omg.CORBA.TypeCode;
35  import org.omg.CORBA.UnionMember;
36  import org.omg.CORBA.ValueMember;
37  import org.omg.CORBA.TypeCodePackage.BadKind;
38  import org.omg.CORBA_2_3.portable.InputStream;
39  import org.omg.CORBA_2_3.portable.OutputStream;
40  
41  import org.jboss.com.sun.corba.se.impl.corba.AnyImpl;
42  import org.jboss.com.sun.corba.se.impl.encoding.CDRInputStream;
43  import org.jboss.com.sun.corba.se.impl.encoding.CDROutputStream;
44  import org.jboss.com.sun.corba.se.impl.encoding.TypeCodeInputStream;
45  import org.jboss.com.sun.corba.se.impl.encoding.TypeCodeOutputStream;
46  import org.jboss.com.sun.corba.se.impl.encoding.TypeCodeReader;
47  import org.jboss.com.sun.corba.se.impl.encoding.WrapperInputStream;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/TypeCodeImpl.java
      * Line Number: 280
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
270              // set up content type
271              switch (_kind)
272              {
273                  case TCKind._tk_sequence :
274                  case TCKind._tk_array :
275                  case TCKind._tk_alias :
276                  case TCKind._tk_value_box :
277                      _contentType = convertToNative(_orb, tc.content_type());
278              }
279          }
280          catch (org.omg.CORBA.TypeCodePackage.Bounds e)
281          {
282          }
283          catch (BadKind e)
284          {
285          }
286          // dont have to worry about these since code ensures we dont step
287          // out of bounds.
288      }
289  
290      public TypeCodeImpl(ORB orb, int creationKind)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/TypeCodeImpl.java
      * Line Number: 38
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
28  import java.io.ByteArrayOutputStream;
29  import java.io.PrintStream;
30  
31  import org.omg.CORBA.Any;
32  import org.omg.CORBA.StructMember;
33  import org.omg.CORBA.TCKind;
34  import org.omg.CORBA.TypeCode;
35  import org.omg.CORBA.UnionMember;
36  import org.omg.CORBA.ValueMember;
37  import org.omg.CORBA.TypeCodePackage.BadKind;
38  import org.omg.CORBA_2_3.portable.InputStream;
39  import org.omg.CORBA_2_3.portable.OutputStream;
40  
41  import org.jboss.com.sun.corba.se.impl.corba.AnyImpl;
42  import org.jboss.com.sun.corba.se.impl.encoding.CDRInputStream;
43  import org.jboss.com.sun.corba.se.impl.encoding.CDROutputStream;
44  import org.jboss.com.sun.corba.se.impl.encoding.TypeCodeInputStream;
45  import org.jboss.com.sun.corba.se.impl.encoding.TypeCodeOutputStream;
46  import org.jboss.com.sun.corba.se.impl.encoding.TypeCodeReader;
47  import org.jboss.com.sun.corba.se.impl.encoding.WrapperInputStream;
48  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/TypeCodeImpl.java
      * Line Number: 39
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
29  import java.io.PrintStream;
30  
31  import org.omg.CORBA.Any;
32  import org.omg.CORBA.StructMember;
33  import org.omg.CORBA.TCKind;
34  import org.omg.CORBA.TypeCode;
35  import org.omg.CORBA.UnionMember;
36  import org.omg.CORBA.ValueMember;
37  import org.omg.CORBA.TypeCodePackage.BadKind;
38  import org.omg.CORBA_2_3.portable.InputStream;
39  import org.omg.CORBA_2_3.portable.OutputStream;
40  
41  import org.jboss.com.sun.corba.se.impl.corba.AnyImpl;
42  import org.jboss.com.sun.corba.se.impl.encoding.CDRInputStream;
43  import org.jboss.com.sun.corba.se.impl.encoding.CDROutputStream;
44  import org.jboss.com.sun.corba.se.impl.encoding.TypeCodeInputStream;
45  import org.jboss.com.sun.corba.se.impl.encoding.TypeCodeOutputStream;
46  import org.jboss.com.sun.corba.se.impl.encoding.TypeCodeReader;
47  import org.jboss.com.sun.corba.se.impl.encoding.WrapperInputStream;
48  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
49  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/TypeCodeImpl.java
      * Line Number: 853
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
843                              if (_id.compareTo(tc.id()) != 0)
844                              {
845                                  return false;
846                              }
847                              // check for equality with the true type
848                              return _contentType.equal(tc.content_type());
849                          }
850                      }
851              }
852          }
853          catch (org.omg.CORBA.TypeCodePackage.Bounds e)
854          {
855          }
856          catch (BadKind e)
857          {
858          }
859          // dont have to worry about these since the code ensures these dont
860          // arise.
861          return false;
862      }
863  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/TypeCodeImpl.java
      * Line Number: 970
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
960                      if (!myRealType.member_type(i).equivalent(otherRealType.member_type(i)))
961                          return false;
962                  }
963              }
964          }
965          catch (BadKind e)
966          {
967              // impossible if we checked correctly above
968              throw wrapper.badkindCannotOccur();
969          }
970          catch (org.omg.CORBA.TypeCodePackage.Bounds e)
971          {
972              // impossible if we checked correctly above
973              throw wrapper.boundsCannotOccur();
974          }
975  
976          // Structural comparison succeeded!
977          return true;
978      }
979  
980      public TypeCode get_compact_typecode()
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/TypeCodeImplHelper.java
      * Line Number: 38
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
28   * Copyright IBM Corp. 1998 1999  All Rights Reserved
29   *
30   */
31  
32  package org.jboss.com.sun.corba.se.impl.corba;
33  
34  abstract public class TypeCodeImplHelper
35  {
36      private static String _id = "IDL:omg.org/CORBA/TypeCode:1.0";
37  
38      public static void insert(org.omg.CORBA.Any a, org.omg.CORBA.TypeCode that)
39      {
40          org.omg.CORBA.portable.OutputStream out = a.create_output_stream();
41          a.type(type());
42          write(out, that);
43          a.read_value(out.create_input_stream(), type());
44      }
45  
46      public static org.omg.CORBA.TypeCode extract(org.omg.CORBA.Any a)
47      {
48          return read(a.create_input_stream());
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/TypeCodeImplHelper.java
      * Line Number: 40
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
30   */
31  
32  package org.jboss.com.sun.corba.se.impl.corba;
33  
34  abstract public class TypeCodeImplHelper
35  {
36      private static String _id = "IDL:omg.org/CORBA/TypeCode:1.0";
37  
38      public static void insert(org.omg.CORBA.Any a, org.omg.CORBA.TypeCode that)
39      {
40          org.omg.CORBA.portable.OutputStream out = a.create_output_stream();
41          a.type(type());
42          write(out, that);
43          a.read_value(out.create_input_stream(), type());
44      }
45  
46      public static org.omg.CORBA.TypeCode extract(org.omg.CORBA.Any a)
47      {
48          return read(a.create_input_stream());
49      }
50  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/TypeCodeImplHelper.java
      * Line Number: 46
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
36      private static String _id = "IDL:omg.org/CORBA/TypeCode:1.0";
37  
38      public static void insert(org.omg.CORBA.Any a, org.omg.CORBA.TypeCode that)
39      {
40          org.omg.CORBA.portable.OutputStream out = a.create_output_stream();
41          a.type(type());
42          write(out, that);
43          a.read_value(out.create_input_stream(), type());
44      }
45  
46      public static org.omg.CORBA.TypeCode extract(org.omg.CORBA.Any a)
47      {
48          return read(a.create_input_stream());
49      }
50  
51      private static org.omg.CORBA.TypeCode __typeCode = null;
52  
53      synchronized public static org.omg.CORBA.TypeCode type()
54      {
55          if (__typeCode == null)
56          {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/TypeCodeImplHelper.java
      * Line Number: 51
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
41          a.type(type());
42          write(out, that);
43          a.read_value(out.create_input_stream(), type());
44      }
45  
46      public static org.omg.CORBA.TypeCode extract(org.omg.CORBA.Any a)
47      {
48          return read(a.create_input_stream());
49      }
50  
51      private static org.omg.CORBA.TypeCode __typeCode = null;
52  
53      synchronized public static org.omg.CORBA.TypeCode type()
54      {
55          if (__typeCode == null)
56          {
57              __typeCode = org.omg.CORBA.ORB.init().get_primitive_tc(org.omg.CORBA.TCKind.tk_TypeCode);
58          }
59          return __typeCode;
60      }
61  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/TypeCodeImplHelper.java
      * Line Number: 53
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
43          a.read_value(out.create_input_stream(), type());
44      }
45  
46      public static org.omg.CORBA.TypeCode extract(org.omg.CORBA.Any a)
47      {
48          return read(a.create_input_stream());
49      }
50  
51      private static org.omg.CORBA.TypeCode __typeCode = null;
52  
53      synchronized public static org.omg.CORBA.TypeCode type()
54      {
55          if (__typeCode == null)
56          {
57              __typeCode = org.omg.CORBA.ORB.init().get_primitive_tc(org.omg.CORBA.TCKind.tk_TypeCode);
58          }
59          return __typeCode;
60      }
61  
62      public static String id()
63      {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/TypeCodeImplHelper.java
      * Line Number: 57
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
47      {
48          return read(a.create_input_stream());
49      }
50  
51      private static org.omg.CORBA.TypeCode __typeCode = null;
52  
53      synchronized public static org.omg.CORBA.TypeCode type()
54      {
55          if (__typeCode == null)
56          {
57              __typeCode = org.omg.CORBA.ORB.init().get_primitive_tc(org.omg.CORBA.TCKind.tk_TypeCode);
58          }
59          return __typeCode;
60      }
61  
62      public static String id()
63      {
64          return _id;
65      }
66  
67      public static org.omg.CORBA.TypeCode read(org.omg.CORBA.portable.InputStream istream)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/TypeCodeImplHelper.java
      * Line Number: 67
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
57              __typeCode = org.omg.CORBA.ORB.init().get_primitive_tc(org.omg.CORBA.TCKind.tk_TypeCode);
58          }
59          return __typeCode;
60      }
61  
62      public static String id()
63      {
64          return _id;
65      }
66  
67      public static org.omg.CORBA.TypeCode read(org.omg.CORBA.portable.InputStream istream)
68      {
69          return istream.read_TypeCode();
70      }
71  
72      public static void write(org.omg.CORBA.portable.OutputStream ostream, org.omg.CORBA.TypeCode value)
73      {
74          ostream.write_TypeCode(value);
75      }
76  
77      public static void write(org.omg.CORBA.portable.OutputStream ostream, TypeCodeImpl value)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/TypeCodeImplHelper.java
      * Line Number: 72
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
62      public static String id()
63      {
64          return _id;
65      }
66  
67      public static org.omg.CORBA.TypeCode read(org.omg.CORBA.portable.InputStream istream)
68      {
69          return istream.read_TypeCode();
70      }
71  
72      public static void write(org.omg.CORBA.portable.OutputStream ostream, org.omg.CORBA.TypeCode value)
73      {
74          ostream.write_TypeCode(value);
75      }
76  
77      public static void write(org.omg.CORBA.portable.OutputStream ostream, TypeCodeImpl value)
78      {
79          ostream.write_TypeCode(value);
80      }
81  
82  }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/corba/TypeCodeImplHelper.java
      * Line Number: 77
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
67      public static org.omg.CORBA.TypeCode read(org.omg.CORBA.portable.InputStream istream)
68      {
69          return istream.read_TypeCode();
70      }
71  
72      public static void write(org.omg.CORBA.portable.OutputStream ostream, org.omg.CORBA.TypeCode value)
73      {
74          ostream.write_TypeCode(value);
75      }
76  
77      public static void write(org.omg.CORBA.portable.OutputStream ostream, TypeCodeImpl value)
78      {
79          ostream.write_TypeCode(value);
80      }
81  
82  }

```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/BufferManagerFactory.java
      * Line Number: 28
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
18   * 2 along with this work; if not, write to the Free Software Foundation,
19   * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
20   *
21   * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
22   * or visit www.oracle.com if you need additional information or have any
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.encoding;
27  
28  import org.omg.CORBA.INTERNAL;
29  
30  import org.jboss.com.sun.corba.se.impl.encoding.BufferManagerRead;
31  import org.jboss.com.sun.corba.se.impl.encoding.BufferManagerReadGrow;
32  import org.jboss.com.sun.corba.se.impl.encoding.BufferManagerReadStream;
33  import org.jboss.com.sun.corba.se.impl.encoding.BufferManagerWrite;
34  import org.jboss.com.sun.corba.se.impl.encoding.BufferManagerWriteCollect;
35  import org.jboss.com.sun.corba.se.impl.encoding.BufferManagerWriteGrow;
36  import org.jboss.com.sun.corba.se.impl.encoding.BufferManagerWriteStream;
37  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
38  import org.jboss.com.sun.corba.se.impl.protocol.giopmsgheaders.Message;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream.java
      * Line Number: 394
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream.java
      * Line Number: 399
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream.java
      * Line Number: 404
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream.java
      * Line Number: 409
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream.java
      * Line Number: 414
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream.java
      * Line Number: 514
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream.java
      * Line Number: 103
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
 93      public CDRInputStream()
 94      {
 95      }
 96  
 97      public CDRInputStream(CDRInputStream is)
 98      {
 99          impl = is.impl.dup();
100          impl.setParent(this);
101      }
102  
103      public CDRInputStream(org.omg.CORBA.ORB orb, ByteBuffer byteBuffer, int size, boolean littleEndian,
104              GIOPVersion version, byte encodingVersion, BufferManagerRead bufMgr)
105      {
106          impl = InputStreamFactory.newInputStream((ORB) orb, version, encodingVersion);
107  
108          impl.init(orb, byteBuffer, size, littleEndian, bufMgr);
109  
110          impl.setParent(this);
111      }
112  
113      // org.omg.CORBA.portable.InputStream
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream.java
      * Line Number: 249
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
239      public final void read_float_array(float[] value, int offset, int length)
240      {
241          impl.read_float_array(value, offset, length);
242      }
243  
244      public final void read_double_array(double[] value, int offset, int length)
245      {
246          impl.read_double_array(value, offset, length);
247      }
248  
249      public final org.omg.CORBA.Object read_Object()
250      {
251          return impl.read_Object();
252      }
253  
254      public final TypeCode read_TypeCode()
255      {
256          return impl.read_TypeCode();
257      }
258  
259      public final Any read_any()
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream.java
      * Line Number: 279
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
269      public final int read() throws java.io.IOException
270      {
271          return impl.read();
272      }
273  
274      public final java.math.BigDecimal read_fixed()
275      {
276          return impl.read_fixed();
277      }
278  
279      public final org.omg.CORBA.Context read_Context()
280      {
281          return impl.read_Context();
282      }
283  
284      public final org.omg.CORBA.Object read_Object(Class clz)
285      {
286          return impl.read_Object(clz);
287      }
288  
289      public final org.omg.CORBA.ORB orb()
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream.java
      * Line Number: 284
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
274      public final java.math.BigDecimal read_fixed()
275      {
276          return impl.read_fixed();
277      }
278  
279      public final org.omg.CORBA.Context read_Context()
280      {
281          return impl.read_Context();
282      }
283  
284      public final org.omg.CORBA.Object read_Object(Class clz)
285      {
286          return impl.read_Object(clz);
287      }
288  
289      public final org.omg.CORBA.ORB orb()
290      {
291          return impl.orb();
292      }
293  
294      // org.omg.CORBA_2_3.portable.InputStream
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream.java
      * Line Number: 289
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
279      public final org.omg.CORBA.Context read_Context()
280      {
281          return impl.read_Context();
282      }
283  
284      public final org.omg.CORBA.Object read_Object(Class clz)
285      {
286          return impl.read_Object(clz);
287      }
288  
289      public final org.omg.CORBA.ORB orb()
290      {
291          return impl.orb();
292      }
293  
294      // org.omg.CORBA_2_3.portable.InputStream
295      public final java.io.Serializable read_value()
296      {
297          return impl.read_value();
298      }
299  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream.java
      * Line Number: 38
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
28  import java.nio.ByteBuffer;
29  
30  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
31  import org.jboss.com.sun.corba.se.impl.protocol.giopmsgheaders.Message;
32  import org.jboss.com.sun.corba.se.pept.protocol.MessageMediator;
33  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
34  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
35  import org.jboss.com.sun.corba.se.spi.orb.ORB;
36  import org.jboss.com.sun.corba.se.spi.protocol.CorbaMessageMediator;
37  import org.jboss.com.sun.org.omg.SendingContext.CodeBase;
38  import org.omg.CORBA.Any;
39  import org.omg.CORBA.Principal;
40  import org.omg.CORBA.TypeCode;
41  
42  /**
43   * This is delegates to the real implementation.
44   * 
45   * NOTE:
46   * 
47   * Before using the stream for valuetype unmarshaling, one must call performORBVersionSpecificInit().
48   */
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream.java
      * Line Number: 39
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
29  
30  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
31  import org.jboss.com.sun.corba.se.impl.protocol.giopmsgheaders.Message;
32  import org.jboss.com.sun.corba.se.pept.protocol.MessageMediator;
33  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
34  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
35  import org.jboss.com.sun.corba.se.spi.orb.ORB;
36  import org.jboss.com.sun.corba.se.spi.protocol.CorbaMessageMediator;
37  import org.jboss.com.sun.org.omg.SendingContext.CodeBase;
38  import org.omg.CORBA.Any;
39  import org.omg.CORBA.Principal;
40  import org.omg.CORBA.TypeCode;
41  
42  /**
43   * This is delegates to the real implementation.
44   * 
45   * NOTE:
46   * 
47   * Before using the stream for valuetype unmarshaling, one must call performORBVersionSpecificInit().
48   */
49  @SuppressWarnings({"deprecation", "rawtypes"})
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream.java
      * Line Number: 305
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
295      public final java.io.Serializable read_value()
296      {
297          return impl.read_value();
298      }
299  
300      public final java.io.Serializable read_value(Class clz)
301      {
302          return impl.read_value(clz);
303      }
304  
305      public final java.io.Serializable read_value(org.omg.CORBA.portable.BoxedValueHelper factory)
306      {
307          return impl.read_value(factory);
308      }
309  
310      public final java.io.Serializable read_value(String rep_id)
311      {
312          return impl.read_value(rep_id);
313      }
314  
315      public final java.io.Serializable read_value(java.io.Serializable value)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream.java
      * Line Number: 40
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
30  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
31  import org.jboss.com.sun.corba.se.impl.protocol.giopmsgheaders.Message;
32  import org.jboss.com.sun.corba.se.pept.protocol.MessageMediator;
33  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
34  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
35  import org.jboss.com.sun.corba.se.spi.orb.ORB;
36  import org.jboss.com.sun.corba.se.spi.protocol.CorbaMessageMediator;
37  import org.jboss.com.sun.org.omg.SendingContext.CodeBase;
38  import org.omg.CORBA.Any;
39  import org.omg.CORBA.Principal;
40  import org.omg.CORBA.TypeCode;
41  
42  /**
43   * This is delegates to the real implementation.
44   * 
45   * NOTE:
46   * 
47   * Before using the stream for valuetype unmarshaling, one must call performORBVersionSpecificInit().
48   */
49  @SuppressWarnings({"deprecation", "rawtypes"})
50  public abstract class CDRInputStream extends org.omg.CORBA_2_3.portable.InputStream
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream.java
      * Line Number: 354
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
344      public final Object read_Abstract()
345      {
346          return impl.read_Abstract();
347      }
348  
349      public final java.io.Serializable read_Value()
350      {
351          return impl.read_Value();
352      }
353  
354      public final void read_any_array(org.omg.CORBA.AnySeqHolder seq, int offset, int length)
355      {
356          impl.read_any_array(seq, offset, length);
357      }
358  
359      public final void read_boolean_array(org.omg.CORBA.BooleanSeqHolder seq, int offset, int length)
360      {
361          impl.read_boolean_array(seq, offset, length);
362      }
363  
364      public final void read_char_array(org.omg.CORBA.CharSeqHolder seq, int offset, int length)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream.java
      * Line Number: 359
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
349      public final java.io.Serializable read_Value()
350      {
351          return impl.read_Value();
352      }
353  
354      public final void read_any_array(org.omg.CORBA.AnySeqHolder seq, int offset, int length)
355      {
356          impl.read_any_array(seq, offset, length);
357      }
358  
359      public final void read_boolean_array(org.omg.CORBA.BooleanSeqHolder seq, int offset, int length)
360      {
361          impl.read_boolean_array(seq, offset, length);
362      }
363  
364      public final void read_char_array(org.omg.CORBA.CharSeqHolder seq, int offset, int length)
365      {
366          impl.read_char_array(seq, offset, length);
367      }
368  
369      public final void read_wchar_array(org.omg.CORBA.WCharSeqHolder seq, int offset, int length)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream.java
      * Line Number: 364
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
354      public final void read_any_array(org.omg.CORBA.AnySeqHolder seq, int offset, int length)
355      {
356          impl.read_any_array(seq, offset, length);
357      }
358  
359      public final void read_boolean_array(org.omg.CORBA.BooleanSeqHolder seq, int offset, int length)
360      {
361          impl.read_boolean_array(seq, offset, length);
362      }
363  
364      public final void read_char_array(org.omg.CORBA.CharSeqHolder seq, int offset, int length)
365      {
366          impl.read_char_array(seq, offset, length);
367      }
368  
369      public final void read_wchar_array(org.omg.CORBA.WCharSeqHolder seq, int offset, int length)
370      {
371          impl.read_wchar_array(seq, offset, length);
372      }
373  
374      public final void read_octet_array(org.omg.CORBA.OctetSeqHolder seq, int offset, int length)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream.java
      * Line Number: 369
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
359      public final void read_boolean_array(org.omg.CORBA.BooleanSeqHolder seq, int offset, int length)
360      {
361          impl.read_boolean_array(seq, offset, length);
362      }
363  
364      public final void read_char_array(org.omg.CORBA.CharSeqHolder seq, int offset, int length)
365      {
366          impl.read_char_array(seq, offset, length);
367      }
368  
369      public final void read_wchar_array(org.omg.CORBA.WCharSeqHolder seq, int offset, int length)
370      {
371          impl.read_wchar_array(seq, offset, length);
372      }
373  
374      public final void read_octet_array(org.omg.CORBA.OctetSeqHolder seq, int offset, int length)
375      {
376          impl.read_octet_array(seq, offset, length);
377      }
378  
379      public final void read_short_array(org.omg.CORBA.ShortSeqHolder seq, int offset, int length)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream.java
      * Line Number: 374
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
364      public final void read_char_array(org.omg.CORBA.CharSeqHolder seq, int offset, int length)
365      {
366          impl.read_char_array(seq, offset, length);
367      }
368  
369      public final void read_wchar_array(org.omg.CORBA.WCharSeqHolder seq, int offset, int length)
370      {
371          impl.read_wchar_array(seq, offset, length);
372      }
373  
374      public final void read_octet_array(org.omg.CORBA.OctetSeqHolder seq, int offset, int length)
375      {
376          impl.read_octet_array(seq, offset, length);
377      }
378  
379      public final void read_short_array(org.omg.CORBA.ShortSeqHolder seq, int offset, int length)
380      {
381          impl.read_short_array(seq, offset, length);
382      }
383  
384      public final void read_ushort_array(org.omg.CORBA.UShortSeqHolder seq, int offset, int length)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream.java
      * Line Number: 379
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
369      public final void read_wchar_array(org.omg.CORBA.WCharSeqHolder seq, int offset, int length)
370      {
371          impl.read_wchar_array(seq, offset, length);
372      }
373  
374      public final void read_octet_array(org.omg.CORBA.OctetSeqHolder seq, int offset, int length)
375      {
376          impl.read_octet_array(seq, offset, length);
377      }
378  
379      public final void read_short_array(org.omg.CORBA.ShortSeqHolder seq, int offset, int length)
380      {
381          impl.read_short_array(seq, offset, length);
382      }
383  
384      public final void read_ushort_array(org.omg.CORBA.UShortSeqHolder seq, int offset, int length)
385      {
386          impl.read_ushort_array(seq, offset, length);
387      }
388  
389      public final void read_long_array(org.omg.CORBA.LongSeqHolder seq, int offset, int length)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream.java
      * Line Number: 384
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
374      public final void read_octet_array(org.omg.CORBA.OctetSeqHolder seq, int offset, int length)
375      {
376          impl.read_octet_array(seq, offset, length);
377      }
378  
379      public final void read_short_array(org.omg.CORBA.ShortSeqHolder seq, int offset, int length)
380      {
381          impl.read_short_array(seq, offset, length);
382      }
383  
384      public final void read_ushort_array(org.omg.CORBA.UShortSeqHolder seq, int offset, int length)
385      {
386          impl.read_ushort_array(seq, offset, length);
387      }
388  
389      public final void read_long_array(org.omg.CORBA.LongSeqHolder seq, int offset, int length)
390      {
391          impl.read_long_array(seq, offset, length);
392      }
393  
394      public final void read_ulong_array(org.omg.CORBA.ULongSeqHolder seq, int offset, int length)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream.java
      * Line Number: 389
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
379      public final void read_short_array(org.omg.CORBA.ShortSeqHolder seq, int offset, int length)
380      {
381          impl.read_short_array(seq, offset, length);
382      }
383  
384      public final void read_ushort_array(org.omg.CORBA.UShortSeqHolder seq, int offset, int length)
385      {
386          impl.read_ushort_array(seq, offset, length);
387      }
388  
389      public final void read_long_array(org.omg.CORBA.LongSeqHolder seq, int offset, int length)
390      {
391          impl.read_long_array(seq, offset, length);
392      }
393  
394      public final void read_ulong_array(org.omg.CORBA.ULongSeqHolder seq, int offset, int length)
395      {
396          impl.read_ulong_array(seq, offset, length);
397      }
398  
399      public final void read_ulonglong_array(org.omg.CORBA.ULongLongSeqHolder seq, int offset, int length)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream.java
      * Line Number: 50
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
40  import org.omg.CORBA.TypeCode;
41  
42  /**
43   * This is delegates to the real implementation.
44   * 
45   * NOTE:
46   * 
47   * Before using the stream for valuetype unmarshaling, one must call performORBVersionSpecificInit().
48   */
49  @SuppressWarnings({"deprecation", "rawtypes"})
50  public abstract class CDRInputStream extends org.omg.CORBA_2_3.portable.InputStream
51          implements
52              MarshalInputStream,
53              org.omg.CORBA.DataInputStream,
54              org.omg.CORBA.portable.ValueInputStream
55  {
56      protected CorbaMessageMediator messageMediator;
57  
58      private CDRInputStreamBase impl;
59  
60      // We can move this out somewhere later. For now, it serves its purpose to create a concrete CDR delegate based on
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream.java
      * Line Number: 53
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
43   * This is delegates to the real implementation.
44   * 
45   * NOTE:
46   * 
47   * Before using the stream for valuetype unmarshaling, one must call performORBVersionSpecificInit().
48   */
49  @SuppressWarnings({"deprecation", "rawtypes"})
50  public abstract class CDRInputStream extends org.omg.CORBA_2_3.portable.InputStream
51          implements
52              MarshalInputStream,
53              org.omg.CORBA.DataInputStream,
54              org.omg.CORBA.portable.ValueInputStream
55  {
56      protected CorbaMessageMediator messageMediator;
57  
58      private CDRInputStreamBase impl;
59  
60      // We can move this out somewhere later. For now, it serves its purpose to create a concrete CDR delegate based on
61      // the GIOP version.
62      private static class InputStreamFactory
63      {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream.java
      * Line Number: 54
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
44   * 
45   * NOTE:
46   * 
47   * Before using the stream for valuetype unmarshaling, one must call performORBVersionSpecificInit().
48   */
49  @SuppressWarnings({"deprecation", "rawtypes"})
50  public abstract class CDRInputStream extends org.omg.CORBA_2_3.portable.InputStream
51          implements
52              MarshalInputStream,
53              org.omg.CORBA.DataInputStream,
54              org.omg.CORBA.portable.ValueInputStream
55  {
56      protected CorbaMessageMediator messageMediator;
57  
58      private CDRInputStreamBase impl;
59  
60      // We can move this out somewhere later. For now, it serves its purpose to create a concrete CDR delegate based on
61      // the GIOP version.
62      private static class InputStreamFactory
63      {
64  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStreamBase.java
      * Line Number: 174
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStreamBase.java
      * Line Number: 176
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStreamBase.java
      * Line Number: 178
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStreamBase.java
      * Line Number: 180
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStreamBase.java
      * Line Number: 241
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStreamBase.java
      * Line Number: 107
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
 97      public abstract void read_ulong_array(int[] value, int offset, int length);
 98  
 99      public abstract void read_longlong_array(long[] value, int offset, int length);
100  
101      public abstract void read_ulonglong_array(long[] value, int offset, int length);
102  
103      public abstract void read_float_array(float[] value, int offset, int length);
104  
105      public abstract void read_double_array(double[] value, int offset, int length);
106  
107      public abstract org.omg.CORBA.Object read_Object();
108  
109      public abstract TypeCode read_TypeCode();
110  
111      public abstract Any read_any();
112  
113      public abstract Principal read_Principal();
114  
115      public int read() throws java.io.IOException
116      {
117          throw new org.omg.CORBA.NO_IMPLEMENT();
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStreamBase.java
      * Line Number: 117
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
107      public abstract org.omg.CORBA.Object read_Object();
108  
109      public abstract TypeCode read_TypeCode();
110  
111      public abstract Any read_any();
112  
113      public abstract Principal read_Principal();
114  
115      public int read() throws java.io.IOException
116      {
117          throw new org.omg.CORBA.NO_IMPLEMENT();
118      }
119  
120      public abstract java.math.BigDecimal read_fixed();
121  
122      public org.omg.CORBA.Context read_Context()
123      {
124          throw new org.omg.CORBA.NO_IMPLEMENT();
125      }
126  
127      public abstract org.omg.CORBA.Object read_Object(Class<?> clz);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStreamBase.java
      * Line Number: 122
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
112  
113      public abstract Principal read_Principal();
114  
115      public int read() throws java.io.IOException
116      {
117          throw new org.omg.CORBA.NO_IMPLEMENT();
118      }
119  
120      public abstract java.math.BigDecimal read_fixed();
121  
122      public org.omg.CORBA.Context read_Context()
123      {
124          throw new org.omg.CORBA.NO_IMPLEMENT();
125      }
126  
127      public abstract org.omg.CORBA.Object read_Object(Class<?> clz);
128  
129      public abstract org.omg.CORBA.ORB orb();
130  
131      // org.omg.CORBA_2_3.portable.InputStream
132      public abstract java.io.Serializable read_value();
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStreamBase.java
      * Line Number: 124
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
114  
115      public int read() throws java.io.IOException
116      {
117          throw new org.omg.CORBA.NO_IMPLEMENT();
118      }
119  
120      public abstract java.math.BigDecimal read_fixed();
121  
122      public org.omg.CORBA.Context read_Context()
123      {
124          throw new org.omg.CORBA.NO_IMPLEMENT();
125      }
126  
127      public abstract org.omg.CORBA.Object read_Object(Class<?> clz);
128  
129      public abstract org.omg.CORBA.ORB orb();
130  
131      // org.omg.CORBA_2_3.portable.InputStream
132      public abstract java.io.Serializable read_value();
133  
134      public abstract java.io.Serializable read_value(Class<?> clz);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStreamBase.java
      * Line Number: 127
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
117          throw new org.omg.CORBA.NO_IMPLEMENT();
118      }
119  
120      public abstract java.math.BigDecimal read_fixed();
121  
122      public org.omg.CORBA.Context read_Context()
123      {
124          throw new org.omg.CORBA.NO_IMPLEMENT();
125      }
126  
127      public abstract org.omg.CORBA.Object read_Object(Class<?> clz);
128  
129      public abstract org.omg.CORBA.ORB orb();
130  
131      // org.omg.CORBA_2_3.portable.InputStream
132      public abstract java.io.Serializable read_value();
133  
134      public abstract java.io.Serializable read_value(Class<?> clz);
135  
136      public abstract java.io.Serializable read_value(org.omg.CORBA.portable.BoxedValueHelper factory);
137  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStreamBase.java
      * Line Number: 129
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
119  
120      public abstract java.math.BigDecimal read_fixed();
121  
122      public org.omg.CORBA.Context read_Context()
123      {
124          throw new org.omg.CORBA.NO_IMPLEMENT();
125      }
126  
127      public abstract org.omg.CORBA.Object read_Object(Class<?> clz);
128  
129      public abstract org.omg.CORBA.ORB orb();
130  
131      // org.omg.CORBA_2_3.portable.InputStream
132      public abstract java.io.Serializable read_value();
133  
134      public abstract java.io.Serializable read_value(Class<?> clz);
135  
136      public abstract java.io.Serializable read_value(org.omg.CORBA.portable.BoxedValueHelper factory);
137  
138      public abstract java.io.Serializable read_value(String rep_id);
139  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStreamBase.java
      * Line Number: 136
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
126  
127      public abstract org.omg.CORBA.Object read_Object(Class<?> clz);
128  
129      public abstract org.omg.CORBA.ORB orb();
130  
131      // org.omg.CORBA_2_3.portable.InputStream
132      public abstract java.io.Serializable read_value();
133  
134      public abstract java.io.Serializable read_value(Class<?> clz);
135  
136      public abstract java.io.Serializable read_value(org.omg.CORBA.portable.BoxedValueHelper factory);
137  
138      public abstract java.io.Serializable read_value(String rep_id);
139  
140      public abstract java.io.Serializable read_value(java.io.Serializable value);
141  
142      public abstract Object read_abstract_interface();
143  
144      public abstract Object read_abstract_interface(Class<?> clz);
145  
146      // org.jboss.com.sun.corba.se.impl.encoding.MarshalInputStream
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStreamBase.java
      * Line Number: 156
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
146      // org.jboss.com.sun.corba.se.impl.encoding.MarshalInputStream
147      public abstract void consumeEndian();
148  
149      public abstract int getPosition();
150  
151      // org.omg.CORBA.DataInputStream
152      public abstract Object read_Abstract();
153  
154      public abstract java.io.Serializable read_Value();
155  
156      public abstract void read_any_array(org.omg.CORBA.AnySeqHolder seq, int offset, int length);
157  
158      public abstract void read_boolean_array(org.omg.CORBA.BooleanSeqHolder seq, int offset, int length);
159  
160      public abstract void read_char_array(org.omg.CORBA.CharSeqHolder seq, int offset, int length);
161  
162      public abstract void read_wchar_array(org.omg.CORBA.WCharSeqHolder seq, int offset, int length);
163  
164      public abstract void read_octet_array(org.omg.CORBA.OctetSeqHolder seq, int offset, int length);
165  
166      public abstract void read_short_array(org.omg.CORBA.ShortSeqHolder seq, int offset, int length);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStreamBase.java
      * Line Number: 158
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
148  
149      public abstract int getPosition();
150  
151      // org.omg.CORBA.DataInputStream
152      public abstract Object read_Abstract();
153  
154      public abstract java.io.Serializable read_Value();
155  
156      public abstract void read_any_array(org.omg.CORBA.AnySeqHolder seq, int offset, int length);
157  
158      public abstract void read_boolean_array(org.omg.CORBA.BooleanSeqHolder seq, int offset, int length);
159  
160      public abstract void read_char_array(org.omg.CORBA.CharSeqHolder seq, int offset, int length);
161  
162      public abstract void read_wchar_array(org.omg.CORBA.WCharSeqHolder seq, int offset, int length);
163  
164      public abstract void read_octet_array(org.omg.CORBA.OctetSeqHolder seq, int offset, int length);
165  
166      public abstract void read_short_array(org.omg.CORBA.ShortSeqHolder seq, int offset, int length);
167  
168      public abstract void read_ushort_array(org.omg.CORBA.UShortSeqHolder seq, int offset, int length);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStreamBase.java
      * Line Number: 160
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
150  
151      // org.omg.CORBA.DataInputStream
152      public abstract Object read_Abstract();
153  
154      public abstract java.io.Serializable read_Value();
155  
156      public abstract void read_any_array(org.omg.CORBA.AnySeqHolder seq, int offset, int length);
157  
158      public abstract void read_boolean_array(org.omg.CORBA.BooleanSeqHolder seq, int offset, int length);
159  
160      public abstract void read_char_array(org.omg.CORBA.CharSeqHolder seq, int offset, int length);
161  
162      public abstract void read_wchar_array(org.omg.CORBA.WCharSeqHolder seq, int offset, int length);
163  
164      public abstract void read_octet_array(org.omg.CORBA.OctetSeqHolder seq, int offset, int length);
165  
166      public abstract void read_short_array(org.omg.CORBA.ShortSeqHolder seq, int offset, int length);
167  
168      public abstract void read_ushort_array(org.omg.CORBA.UShortSeqHolder seq, int offset, int length);
169  
170      public abstract void read_long_array(org.omg.CORBA.LongSeqHolder seq, int offset, int length);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStreamBase.java
      * Line Number: 162
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
152      public abstract Object read_Abstract();
153  
154      public abstract java.io.Serializable read_Value();
155  
156      public abstract void read_any_array(org.omg.CORBA.AnySeqHolder seq, int offset, int length);
157  
158      public abstract void read_boolean_array(org.omg.CORBA.BooleanSeqHolder seq, int offset, int length);
159  
160      public abstract void read_char_array(org.omg.CORBA.CharSeqHolder seq, int offset, int length);
161  
162      public abstract void read_wchar_array(org.omg.CORBA.WCharSeqHolder seq, int offset, int length);
163  
164      public abstract void read_octet_array(org.omg.CORBA.OctetSeqHolder seq, int offset, int length);
165  
166      public abstract void read_short_array(org.omg.CORBA.ShortSeqHolder seq, int offset, int length);
167  
168      public abstract void read_ushort_array(org.omg.CORBA.UShortSeqHolder seq, int offset, int length);
169  
170      public abstract void read_long_array(org.omg.CORBA.LongSeqHolder seq, int offset, int length);
171  
172      public abstract void read_ulong_array(org.omg.CORBA.ULongSeqHolder seq, int offset, int length);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStreamBase.java
      * Line Number: 164
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
154      public abstract java.io.Serializable read_Value();
155  
156      public abstract void read_any_array(org.omg.CORBA.AnySeqHolder seq, int offset, int length);
157  
158      public abstract void read_boolean_array(org.omg.CORBA.BooleanSeqHolder seq, int offset, int length);
159  
160      public abstract void read_char_array(org.omg.CORBA.CharSeqHolder seq, int offset, int length);
161  
162      public abstract void read_wchar_array(org.omg.CORBA.WCharSeqHolder seq, int offset, int length);
163  
164      public abstract void read_octet_array(org.omg.CORBA.OctetSeqHolder seq, int offset, int length);
165  
166      public abstract void read_short_array(org.omg.CORBA.ShortSeqHolder seq, int offset, int length);
167  
168      public abstract void read_ushort_array(org.omg.CORBA.UShortSeqHolder seq, int offset, int length);
169  
170      public abstract void read_long_array(org.omg.CORBA.LongSeqHolder seq, int offset, int length);
171  
172      public abstract void read_ulong_array(org.omg.CORBA.ULongSeqHolder seq, int offset, int length);
173  
174      public abstract void read_ulonglong_array(org.omg.CORBA.ULongLongSeqHolder seq, int offset, int length);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStreamBase.java
      * Line Number: 166
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
156      public abstract void read_any_array(org.omg.CORBA.AnySeqHolder seq, int offset, int length);
157  
158      public abstract void read_boolean_array(org.omg.CORBA.BooleanSeqHolder seq, int offset, int length);
159  
160      public abstract void read_char_array(org.omg.CORBA.CharSeqHolder seq, int offset, int length);
161  
162      public abstract void read_wchar_array(org.omg.CORBA.WCharSeqHolder seq, int offset, int length);
163  
164      public abstract void read_octet_array(org.omg.CORBA.OctetSeqHolder seq, int offset, int length);
165  
166      public abstract void read_short_array(org.omg.CORBA.ShortSeqHolder seq, int offset, int length);
167  
168      public abstract void read_ushort_array(org.omg.CORBA.UShortSeqHolder seq, int offset, int length);
169  
170      public abstract void read_long_array(org.omg.CORBA.LongSeqHolder seq, int offset, int length);
171  
172      public abstract void read_ulong_array(org.omg.CORBA.ULongSeqHolder seq, int offset, int length);
173  
174      public abstract void read_ulonglong_array(org.omg.CORBA.ULongLongSeqHolder seq, int offset, int length);
175  
176      public abstract void read_longlong_array(org.omg.CORBA.LongLongSeqHolder seq, int offset, int length);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStreamBase.java
      * Line Number: 168
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
158      public abstract void read_boolean_array(org.omg.CORBA.BooleanSeqHolder seq, int offset, int length);
159  
160      public abstract void read_char_array(org.omg.CORBA.CharSeqHolder seq, int offset, int length);
161  
162      public abstract void read_wchar_array(org.omg.CORBA.WCharSeqHolder seq, int offset, int length);
163  
164      public abstract void read_octet_array(org.omg.CORBA.OctetSeqHolder seq, int offset, int length);
165  
166      public abstract void read_short_array(org.omg.CORBA.ShortSeqHolder seq, int offset, int length);
167  
168      public abstract void read_ushort_array(org.omg.CORBA.UShortSeqHolder seq, int offset, int length);
169  
170      public abstract void read_long_array(org.omg.CORBA.LongSeqHolder seq, int offset, int length);
171  
172      public abstract void read_ulong_array(org.omg.CORBA.ULongSeqHolder seq, int offset, int length);
173  
174      public abstract void read_ulonglong_array(org.omg.CORBA.ULongLongSeqHolder seq, int offset, int length);
175  
176      public abstract void read_longlong_array(org.omg.CORBA.LongLongSeqHolder seq, int offset, int length);
177  
178      public abstract void read_float_array(org.omg.CORBA.FloatSeqHolder seq, int offset, int length);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStreamBase.java
      * Line Number: 170
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
160      public abstract void read_char_array(org.omg.CORBA.CharSeqHolder seq, int offset, int length);
161  
162      public abstract void read_wchar_array(org.omg.CORBA.WCharSeqHolder seq, int offset, int length);
163  
164      public abstract void read_octet_array(org.omg.CORBA.OctetSeqHolder seq, int offset, int length);
165  
166      public abstract void read_short_array(org.omg.CORBA.ShortSeqHolder seq, int offset, int length);
167  
168      public abstract void read_ushort_array(org.omg.CORBA.UShortSeqHolder seq, int offset, int length);
169  
170      public abstract void read_long_array(org.omg.CORBA.LongSeqHolder seq, int offset, int length);
171  
172      public abstract void read_ulong_array(org.omg.CORBA.ULongSeqHolder seq, int offset, int length);
173  
174      public abstract void read_ulonglong_array(org.omg.CORBA.ULongLongSeqHolder seq, int offset, int length);
175  
176      public abstract void read_longlong_array(org.omg.CORBA.LongLongSeqHolder seq, int offset, int length);
177  
178      public abstract void read_float_array(org.omg.CORBA.FloatSeqHolder seq, int offset, int length);
179  
180      public abstract void read_double_array(org.omg.CORBA.DoubleSeqHolder seq, int offset, int length);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStreamBase.java
      * Line Number: 172
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
162      public abstract void read_wchar_array(org.omg.CORBA.WCharSeqHolder seq, int offset, int length);
163  
164      public abstract void read_octet_array(org.omg.CORBA.OctetSeqHolder seq, int offset, int length);
165  
166      public abstract void read_short_array(org.omg.CORBA.ShortSeqHolder seq, int offset, int length);
167  
168      public abstract void read_ushort_array(org.omg.CORBA.UShortSeqHolder seq, int offset, int length);
169  
170      public abstract void read_long_array(org.omg.CORBA.LongSeqHolder seq, int offset, int length);
171  
172      public abstract void read_ulong_array(org.omg.CORBA.ULongSeqHolder seq, int offset, int length);
173  
174      public abstract void read_ulonglong_array(org.omg.CORBA.ULongLongSeqHolder seq, int offset, int length);
175  
176      public abstract void read_longlong_array(org.omg.CORBA.LongLongSeqHolder seq, int offset, int length);
177  
178      public abstract void read_float_array(org.omg.CORBA.FloatSeqHolder seq, int offset, int length);
179  
180      public abstract void read_double_array(org.omg.CORBA.DoubleSeqHolder seq, int offset, int length);
181  
182      // org.omg.CORBA.portable.ValueBase
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStreamBase.java
      * Line Number: 31
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
21   * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
22   * or visit www.oracle.com if you need additional information or have any
23   * questions.
24   */
25  package org.jboss.com.sun.corba.se.impl.encoding;
26  
27  import java.nio.ByteBuffer;
28  
29  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
30  import org.jboss.com.sun.org.omg.SendingContext.CodeBase;
31  import org.omg.CORBA.Any;
32  import org.omg.CORBA.Principal;
33  import org.omg.CORBA.TypeCode;
34  
35  /**
36   * Describes CDRInputStream delegates and provides some implementation. Non-default constructors are avoided in the
37   * delegation to separate instantiation from initialization, so we use init methods.
38   */
39  @SuppressWarnings("deprecation")
40  abstract class CDRInputStreamBase extends java.io.InputStream
41  {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStreamBase.java
      * Line Number: 32
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
22   * or visit www.oracle.com if you need additional information or have any
23   * questions.
24   */
25  package org.jboss.com.sun.corba.se.impl.encoding;
26  
27  import java.nio.ByteBuffer;
28  
29  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
30  import org.jboss.com.sun.org.omg.SendingContext.CodeBase;
31  import org.omg.CORBA.Any;
32  import org.omg.CORBA.Principal;
33  import org.omg.CORBA.TypeCode;
34  
35  /**
36   * Describes CDRInputStream delegates and provides some implementation. Non-default constructors are avoided in the
37   * delegation to separate instantiation from initialization, so we use init methods.
38   */
39  @SuppressWarnings("deprecation")
40  abstract class CDRInputStreamBase extends java.io.InputStream
41  {
42      protected CDRInputStream parent;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStreamBase.java
      * Line Number: 33
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
23   * questions.
24   */
25  package org.jboss.com.sun.corba.se.impl.encoding;
26  
27  import java.nio.ByteBuffer;
28  
29  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
30  import org.jboss.com.sun.org.omg.SendingContext.CodeBase;
31  import org.omg.CORBA.Any;
32  import org.omg.CORBA.Principal;
33  import org.omg.CORBA.TypeCode;
34  
35  /**
36   * Describes CDRInputStream delegates and provides some implementation. Non-default constructors are avoided in the
37   * delegation to separate instantiation from initialization, so we use init methods.
38   */
39  @SuppressWarnings("deprecation")
40  abstract class CDRInputStreamBase extends java.io.InputStream
41  {
42      protected CDRInputStream parent;
43  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStreamBase.java
      * Line Number: 49
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
39  @SuppressWarnings("deprecation")
40  abstract class CDRInputStreamBase extends java.io.InputStream
41  {
42      protected CDRInputStream parent;
43  
44      public void setParent(CDRInputStream parent)
45      {
46          this.parent = parent;
47      }
48  
49      public abstract void init(org.omg.CORBA.ORB orb, ByteBuffer byteBuffer, int size, boolean littleEndian,
50              BufferManagerRead bufferManager);
51  
52      // org.omg.CORBA.portable.InputStream
53      public abstract boolean read_boolean();
54  
55      public abstract char read_char();
56  
57      public abstract char read_wchar();
58  
59      public abstract byte read_octet();
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream_1_0.java
      * Line Number: 797
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream_1_0.java
      * Line Number: 810
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream_1_0.java
      * Line Number: 812
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream_1_0.java
      * Line Number: 814
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream_1_0.java
      * Line Number: 822
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream_1_0.java
      * Line Number: 997
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream_1_0.java
      * Line Number: 1137
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream_1_0.java
      * Line Number: 1286
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream_1_0.java
      * Line Number: 1354
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream_1_0.java
      * Line Number: 1632
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream_1_0.java
      * Line Number: 1718
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream_1_0.java
      * Line Number: 1833
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream_1_0.java
      * Line Number: 1838
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream_1_0.java
      * Line Number: 1843
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream_1_0.java
      * Line Number: 1848
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream_1_0.java
      * Line Number: 1853
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream_1_0.java
      * Line Number: 1858
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream_1_0.java
      * Line Number: 1863
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream_1_0.java
      * Line Number: 1868
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream_1_0.java
      * Line Number: 1873
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream_1_0.java
      * Line Number: 1878
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream_1_0.java
      * Line Number: 1883
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream_1_0.java
      * Line Number: 1888
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream_1_0.java
      * Line Number: 1893
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream_1_0.java
      * Line Number: 2092
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream_1_0.java
      * Line Number: 91
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
 81  import org.omg.CORBA.SystemException;
 82  import org.omg.CORBA.TCKind;
 83  import org.omg.CORBA.TypeCode;
 84  import org.omg.CORBA.TypeCodePackage.BadKind;
 85  import org.omg.CORBA.portable.BoxedValueHelper;
 86  import org.omg.CORBA.portable.CustomValue;
 87  import org.omg.CORBA.portable.IDLEntity;
 88  import org.omg.CORBA.portable.IndirectionException;
 89  import org.omg.CORBA.portable.StreamableValue;
 90  import org.omg.CORBA.portable.ValueBase;
 91  import org.omg.CORBA.portable.ValueFactory;
 92  
 93  @SuppressWarnings("deprecation")
 94  public class CDRInputStream_1_0 extends CDRInputStreamBase implements RestorableInputStream
 95  {
 96      private static final String kReadMethod = "read";
 97  
 98      private static final int maxBlockLength = 0x7fffff00;
 99  
100      protected BufferManagerRead bufferManagerRead;
101  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream_1_0.java
      * Line Number: 202
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
192          ((CDRInputStream_1_0) result).bbwi.position(this.bbwi.position());
193          // To ensure we keep bbwi.byteBuffer.limit in sync with bbwi.buflen.
194          ((CDRInputStream_1_0) result).bbwi.byteBuffer.limit(this.bbwi.buflen);
195  
196          return result;
197      }
198  
199      /**
200       * NOTE: size passed to init means buffer size
201       */
202      public void init(org.omg.CORBA.ORB orb, ByteBuffer byteBuffer, int size, boolean littleEndian,
203              BufferManagerRead bufferManager)
204      {
205          this.orb = (ORB) orb;
206          this.wrapper = ORBUtilSystemException.get((ORB) orb, CORBALogDomains.RPC_ENCODING);
207          this.omgWrapper = OMGSystemException.get((ORB) orb, CORBALogDomains.RPC_ENCODING);
208          this.littleEndian = littleEndian;
209          this.bufferManagerRead = bufferManager;
210          this.bbwi = new ByteBufferWithInfo(orb, byteBuffer, 0);
211          this.bbwi.buflen = size;
212          this.bbwi.byteBuffer.limit(bbwi.buflen);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream_1_0.java
      * Line Number: 76
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
66  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
67  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
68  import org.jboss.com.sun.corba.se.spi.orb.ORB;
69  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
70  import org.jboss.com.sun.corba.se.spi.presentation.rmi.PresentationDefaults;
71  import org.jboss.com.sun.corba.se.spi.presentation.rmi.PresentationManager;
72  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
73  import org.jboss.com.sun.corba.se.spi.protocol.CorbaClientDelegate;
74  import org.jboss.com.sun.org.omg.CORBA.portable.ValueHelper;
75  import org.jboss.com.sun.org.omg.SendingContext.CodeBase;
76  import org.omg.CORBA.Any;
77  import org.omg.CORBA.CompletionStatus;
78  import org.omg.CORBA.CustomMarshal;
79  import org.omg.CORBA.MARSHAL;
80  import org.omg.CORBA.Principal;
81  import org.omg.CORBA.SystemException;
82  import org.omg.CORBA.TCKind;
83  import org.omg.CORBA.TypeCode;
84  import org.omg.CORBA.TypeCodePackage.BadKind;
85  import org.omg.CORBA.portable.BoxedValueHelper;
86  import org.omg.CORBA.portable.CustomValue;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream_1_0.java
      * Line Number: 77
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
67  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
68  import org.jboss.com.sun.corba.se.spi.orb.ORB;
69  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
70  import org.jboss.com.sun.corba.se.spi.presentation.rmi.PresentationDefaults;
71  import org.jboss.com.sun.corba.se.spi.presentation.rmi.PresentationManager;
72  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
73  import org.jboss.com.sun.corba.se.spi.protocol.CorbaClientDelegate;
74  import org.jboss.com.sun.org.omg.CORBA.portable.ValueHelper;
75  import org.jboss.com.sun.org.omg.SendingContext.CodeBase;
76  import org.omg.CORBA.Any;
77  import org.omg.CORBA.CompletionStatus;
78  import org.omg.CORBA.CustomMarshal;
79  import org.omg.CORBA.MARSHAL;
80  import org.omg.CORBA.Principal;
81  import org.omg.CORBA.SystemException;
82  import org.omg.CORBA.TCKind;
83  import org.omg.CORBA.TypeCode;
84  import org.omg.CORBA.TypeCodePackage.BadKind;
85  import org.omg.CORBA.portable.BoxedValueHelper;
86  import org.omg.CORBA.portable.CustomValue;
87  import org.omg.CORBA.portable.IDLEntity;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream_1_0.java
      * Line Number: 78
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
68  import org.jboss.com.sun.corba.se.spi.orb.ORB;
69  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
70  import org.jboss.com.sun.corba.se.spi.presentation.rmi.PresentationDefaults;
71  import org.jboss.com.sun.corba.se.spi.presentation.rmi.PresentationManager;
72  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
73  import org.jboss.com.sun.corba.se.spi.protocol.CorbaClientDelegate;
74  import org.jboss.com.sun.org.omg.CORBA.portable.ValueHelper;
75  import org.jboss.com.sun.org.omg.SendingContext.CodeBase;
76  import org.omg.CORBA.Any;
77  import org.omg.CORBA.CompletionStatus;
78  import org.omg.CORBA.CustomMarshal;
79  import org.omg.CORBA.MARSHAL;
80  import org.omg.CORBA.Principal;
81  import org.omg.CORBA.SystemException;
82  import org.omg.CORBA.TCKind;
83  import org.omg.CORBA.TypeCode;
84  import org.omg.CORBA.TypeCodePackage.BadKind;
85  import org.omg.CORBA.portable.BoxedValueHelper;
86  import org.omg.CORBA.portable.CustomValue;
87  import org.omg.CORBA.portable.IDLEntity;
88  import org.omg.CORBA.portable.IndirectionException;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream_1_0.java
      * Line Number: 79
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
69  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
70  import org.jboss.com.sun.corba.se.spi.presentation.rmi.PresentationDefaults;
71  import org.jboss.com.sun.corba.se.spi.presentation.rmi.PresentationManager;
72  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
73  import org.jboss.com.sun.corba.se.spi.protocol.CorbaClientDelegate;
74  import org.jboss.com.sun.org.omg.CORBA.portable.ValueHelper;
75  import org.jboss.com.sun.org.omg.SendingContext.CodeBase;
76  import org.omg.CORBA.Any;
77  import org.omg.CORBA.CompletionStatus;
78  import org.omg.CORBA.CustomMarshal;
79  import org.omg.CORBA.MARSHAL;
80  import org.omg.CORBA.Principal;
81  import org.omg.CORBA.SystemException;
82  import org.omg.CORBA.TCKind;
83  import org.omg.CORBA.TypeCode;
84  import org.omg.CORBA.TypeCodePackage.BadKind;
85  import org.omg.CORBA.portable.BoxedValueHelper;
86  import org.omg.CORBA.portable.CustomValue;
87  import org.omg.CORBA.portable.IDLEntity;
88  import org.omg.CORBA.portable.IndirectionException;
89  import org.omg.CORBA.portable.StreamableValue;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream_1_0.java
      * Line Number: 80
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
70  import org.jboss.com.sun.corba.se.spi.presentation.rmi.PresentationDefaults;
71  import org.jboss.com.sun.corba.se.spi.presentation.rmi.PresentationManager;
72  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
73  import org.jboss.com.sun.corba.se.spi.protocol.CorbaClientDelegate;
74  import org.jboss.com.sun.org.omg.CORBA.portable.ValueHelper;
75  import org.jboss.com.sun.org.omg.SendingContext.CodeBase;
76  import org.omg.CORBA.Any;
77  import org.omg.CORBA.CompletionStatus;
78  import org.omg.CORBA.CustomMarshal;
79  import org.omg.CORBA.MARSHAL;
80  import org.omg.CORBA.Principal;
81  import org.omg.CORBA.SystemException;
82  import org.omg.CORBA.TCKind;
83  import org.omg.CORBA.TypeCode;
84  import org.omg.CORBA.TypeCodePackage.BadKind;
85  import org.omg.CORBA.portable.BoxedValueHelper;
86  import org.omg.CORBA.portable.CustomValue;
87  import org.omg.CORBA.portable.IDLEntity;
88  import org.omg.CORBA.portable.IndirectionException;
89  import org.omg.CORBA.portable.StreamableValue;
90  import org.omg.CORBA.portable.ValueBase;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream_1_0.java
      * Line Number: 81
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
71  import org.jboss.com.sun.corba.se.spi.presentation.rmi.PresentationManager;
72  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
73  import org.jboss.com.sun.corba.se.spi.protocol.CorbaClientDelegate;
74  import org.jboss.com.sun.org.omg.CORBA.portable.ValueHelper;
75  import org.jboss.com.sun.org.omg.SendingContext.CodeBase;
76  import org.omg.CORBA.Any;
77  import org.omg.CORBA.CompletionStatus;
78  import org.omg.CORBA.CustomMarshal;
79  import org.omg.CORBA.MARSHAL;
80  import org.omg.CORBA.Principal;
81  import org.omg.CORBA.SystemException;
82  import org.omg.CORBA.TCKind;
83  import org.omg.CORBA.TypeCode;
84  import org.omg.CORBA.TypeCodePackage.BadKind;
85  import org.omg.CORBA.portable.BoxedValueHelper;
86  import org.omg.CORBA.portable.CustomValue;
87  import org.omg.CORBA.portable.IDLEntity;
88  import org.omg.CORBA.portable.IndirectionException;
89  import org.omg.CORBA.portable.StreamableValue;
90  import org.omg.CORBA.portable.ValueBase;
91  import org.omg.CORBA.portable.ValueFactory;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream_1_0.java
      * Line Number: 721
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
711                  throw ex;
712              // We can be sure that the whole typecode encapsulation has been read off.
713              dprintThrowable(ex);
714          }
715          // read off the value of the any
716          any.read_value(parent, tc);
717  
718          return any;
719      }
720  
721      public org.omg.CORBA.Object read_Object()
722      {
723          return read_Object(null);
724      }
725  
726      // ------------ RMI related methods --------------------------
727  
728      // IDL to Java ptc-00-01-08 1.21.4.1
729      //
730      // The clz argument to read_Object can be either a stub Class or the
731      // "Class object for the RMI/IDL interface type that is statically expected." This functions as follows:
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream_1_0.java
      * Line Number: 82
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
72  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
73  import org.jboss.com.sun.corba.se.spi.protocol.CorbaClientDelegate;
74  import org.jboss.com.sun.org.omg.CORBA.portable.ValueHelper;
75  import org.jboss.com.sun.org.omg.SendingContext.CodeBase;
76  import org.omg.CORBA.Any;
77  import org.omg.CORBA.CompletionStatus;
78  import org.omg.CORBA.CustomMarshal;
79  import org.omg.CORBA.MARSHAL;
80  import org.omg.CORBA.Principal;
81  import org.omg.CORBA.SystemException;
82  import org.omg.CORBA.TCKind;
83  import org.omg.CORBA.TypeCode;
84  import org.omg.CORBA.TypeCodePackage.BadKind;
85  import org.omg.CORBA.portable.BoxedValueHelper;
86  import org.omg.CORBA.portable.CustomValue;
87  import org.omg.CORBA.portable.IDLEntity;
88  import org.omg.CORBA.portable.IndirectionException;
89  import org.omg.CORBA.portable.StreamableValue;
90  import org.omg.CORBA.portable.ValueBase;
91  import org.omg.CORBA.portable.ValueFactory;
92  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream_1_0.java
      * Line Number: 736
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
726      // ------------ RMI related methods --------------------------
727  
728      // IDL to Java ptc-00-01-08 1.21.4.1
729      //
730      // The clz argument to read_Object can be either a stub Class or the
731      // "Class object for the RMI/IDL interface type that is statically expected." This functions as follows:
732      // 1. If clz==null, just use the repository ID from the stub
733      // 2. If clz is a stub class, just use it as a static factory. clz is a stub class if StubAdapter.isStubClass(clz).
734      // In addition, clz is a IDL stub class if IDLEntity.class.isAssignableFrom( clz ).
735      // 3. If clz is an interface, use it to create the appropriate stub factory.
736      public org.omg.CORBA.Object read_Object(Class<?> clz)
737      {
738          // In any case, we must first read the IOR.
739          IOR ior = IORFactories.makeIOR(parent);
740          if (ior.isNil())
741              return null;
742  
743          PresentationManager.StubFactoryFactory sff = ORB.getStubFactoryFactory();
744          String codeBase = ior.getProfile().getCodebase();
745          PresentationManager.StubFactory stubFactory = null;
746  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream_1_0.java
      * Line Number: 83
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
73  import org.jboss.com.sun.corba.se.spi.protocol.CorbaClientDelegate;
74  import org.jboss.com.sun.org.omg.CORBA.portable.ValueHelper;
75  import org.jboss.com.sun.org.omg.SendingContext.CodeBase;
76  import org.omg.CORBA.Any;
77  import org.omg.CORBA.CompletionStatus;
78  import org.omg.CORBA.CustomMarshal;
79  import org.omg.CORBA.MARSHAL;
80  import org.omg.CORBA.Principal;
81  import org.omg.CORBA.SystemException;
82  import org.omg.CORBA.TCKind;
83  import org.omg.CORBA.TypeCode;
84  import org.omg.CORBA.TypeCodePackage.BadKind;
85  import org.omg.CORBA.portable.BoxedValueHelper;
86  import org.omg.CORBA.portable.CustomValue;
87  import org.omg.CORBA.portable.IDLEntity;
88  import org.omg.CORBA.portable.IndirectionException;
89  import org.omg.CORBA.portable.StreamableValue;
90  import org.omg.CORBA.portable.ValueBase;
91  import org.omg.CORBA.portable.ValueFactory;
92  
93  @SuppressWarnings("deprecation")
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream_1_0.java
      * Line Number: 84
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
74  import org.jboss.com.sun.org.omg.CORBA.portable.ValueHelper;
75  import org.jboss.com.sun.org.omg.SendingContext.CodeBase;
76  import org.omg.CORBA.Any;
77  import org.omg.CORBA.CompletionStatus;
78  import org.omg.CORBA.CustomMarshal;
79  import org.omg.CORBA.MARSHAL;
80  import org.omg.CORBA.Principal;
81  import org.omg.CORBA.SystemException;
82  import org.omg.CORBA.TCKind;
83  import org.omg.CORBA.TypeCode;
84  import org.omg.CORBA.TypeCodePackage.BadKind;
85  import org.omg.CORBA.portable.BoxedValueHelper;
86  import org.omg.CORBA.portable.CustomValue;
87  import org.omg.CORBA.portable.IDLEntity;
88  import org.omg.CORBA.portable.IndirectionException;
89  import org.omg.CORBA.portable.StreamableValue;
90  import org.omg.CORBA.portable.ValueBase;
91  import org.omg.CORBA.portable.ValueFactory;
92  
93  @SuppressWarnings("deprecation")
94  public class CDRInputStream_1_0 extends CDRInputStreamBase implements RestorableInputStream
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream_1_0.java
      * Line Number: 85
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
75  import org.jboss.com.sun.org.omg.SendingContext.CodeBase;
76  import org.omg.CORBA.Any;
77  import org.omg.CORBA.CompletionStatus;
78  import org.omg.CORBA.CustomMarshal;
79  import org.omg.CORBA.MARSHAL;
80  import org.omg.CORBA.Principal;
81  import org.omg.CORBA.SystemException;
82  import org.omg.CORBA.TCKind;
83  import org.omg.CORBA.TypeCode;
84  import org.omg.CORBA.TypeCodePackage.BadKind;
85  import org.omg.CORBA.portable.BoxedValueHelper;
86  import org.omg.CORBA.portable.CustomValue;
87  import org.omg.CORBA.portable.IDLEntity;
88  import org.omg.CORBA.portable.IndirectionException;
89  import org.omg.CORBA.portable.StreamableValue;
90  import org.omg.CORBA.portable.ValueBase;
91  import org.omg.CORBA.portable.ValueFactory;
92  
93  @SuppressWarnings("deprecation")
94  public class CDRInputStream_1_0 extends CDRInputStreamBase implements RestorableInputStream
95  {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream_1_0.java
      * Line Number: 86
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
76  import org.omg.CORBA.Any;
77  import org.omg.CORBA.CompletionStatus;
78  import org.omg.CORBA.CustomMarshal;
79  import org.omg.CORBA.MARSHAL;
80  import org.omg.CORBA.Principal;
81  import org.omg.CORBA.SystemException;
82  import org.omg.CORBA.TCKind;
83  import org.omg.CORBA.TypeCode;
84  import org.omg.CORBA.TypeCodePackage.BadKind;
85  import org.omg.CORBA.portable.BoxedValueHelper;
86  import org.omg.CORBA.portable.CustomValue;
87  import org.omg.CORBA.portable.IDLEntity;
88  import org.omg.CORBA.portable.IndirectionException;
89  import org.omg.CORBA.portable.StreamableValue;
90  import org.omg.CORBA.portable.ValueBase;
91  import org.omg.CORBA.portable.ValueFactory;
92  
93  @SuppressWarnings("deprecation")
94  public class CDRInputStream_1_0 extends CDRInputStreamBase implements RestorableInputStream
95  {
96      private static final String kReadMethod = "read";
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream_1_0.java
      * Line Number: 87
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
77  import org.omg.CORBA.CompletionStatus;
78  import org.omg.CORBA.CustomMarshal;
79  import org.omg.CORBA.MARSHAL;
80  import org.omg.CORBA.Principal;
81  import org.omg.CORBA.SystemException;
82  import org.omg.CORBA.TCKind;
83  import org.omg.CORBA.TypeCode;
84  import org.omg.CORBA.TypeCodePackage.BadKind;
85  import org.omg.CORBA.portable.BoxedValueHelper;
86  import org.omg.CORBA.portable.CustomValue;
87  import org.omg.CORBA.portable.IDLEntity;
88  import org.omg.CORBA.portable.IndirectionException;
89  import org.omg.CORBA.portable.StreamableValue;
90  import org.omg.CORBA.portable.ValueBase;
91  import org.omg.CORBA.portable.ValueFactory;
92  
93  @SuppressWarnings("deprecation")
94  public class CDRInputStream_1_0 extends CDRInputStreamBase implements RestorableInputStream
95  {
96      private static final String kReadMethod = "read";
97  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream_1_0.java
      * Line Number: 787
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
777              stubFactory = sff.createStubFactory(clz.getName(), isIDL, codeBase, clz, clz.getClassLoader());
778          }
779  
780          return internalIORToObject(ior, stubFactory, orb);
781      }
782  
783      /*
784       * This is used as a general utility (e.g., the PortableInterceptor implementation uses it. If stubFactory is null,
785       * the ior's IIOPProfile must support getServant.
786       */
787      public static org.omg.CORBA.Object internalIORToObject(IOR ior, PresentationManager.StubFactory stubFactory, ORB orb)
788      {
789          ORBUtilSystemException wrapper = ORBUtilSystemException.get(orb, CORBALogDomains.RPC_ENCODING);
790  
791          Object servant = ior.getProfile().getServant();
792          if (servant != null)
793          {
794              if (servant instanceof Tie)
795              {
796                  String codebase = ior.getProfile().getCodebase();
797                  org.omg.CORBA.Object objref = (org.omg.CORBA.Object) Utility.loadStub((Tie) servant, stubFactory,
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream_1_0.java
      * Line Number: 88
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
78  import org.omg.CORBA.CustomMarshal;
79  import org.omg.CORBA.MARSHAL;
80  import org.omg.CORBA.Principal;
81  import org.omg.CORBA.SystemException;
82  import org.omg.CORBA.TCKind;
83  import org.omg.CORBA.TypeCode;
84  import org.omg.CORBA.TypeCodePackage.BadKind;
85  import org.omg.CORBA.portable.BoxedValueHelper;
86  import org.omg.CORBA.portable.CustomValue;
87  import org.omg.CORBA.portable.IDLEntity;
88  import org.omg.CORBA.portable.IndirectionException;
89  import org.omg.CORBA.portable.StreamableValue;
90  import org.omg.CORBA.portable.ValueBase;
91  import org.omg.CORBA.portable.ValueFactory;
92  
93  @SuppressWarnings("deprecation")
94  public class CDRInputStream_1_0 extends CDRInputStreamBase implements RestorableInputStream
95  {
96      private static final String kReadMethod = "read";
97  
98      private static final int maxBlockLength = 0x7fffff00;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream_1_0.java
      * Line Number: 89
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
79  import org.omg.CORBA.MARSHAL;
80  import org.omg.CORBA.Principal;
81  import org.omg.CORBA.SystemException;
82  import org.omg.CORBA.TCKind;
83  import org.omg.CORBA.TypeCode;
84  import org.omg.CORBA.TypeCodePackage.BadKind;
85  import org.omg.CORBA.portable.BoxedValueHelper;
86  import org.omg.CORBA.portable.CustomValue;
87  import org.omg.CORBA.portable.IDLEntity;
88  import org.omg.CORBA.portable.IndirectionException;
89  import org.omg.CORBA.portable.StreamableValue;
90  import org.omg.CORBA.portable.ValueBase;
91  import org.omg.CORBA.portable.ValueFactory;
92  
93  @SuppressWarnings("deprecation")
94  public class CDRInputStream_1_0 extends CDRInputStreamBase implements RestorableInputStream
95  {
96      private static final String kReadMethod = "read";
97  
98      private static final int maxBlockLength = 0x7fffff00;
99  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDRInputStream_1_0.java
      * Line Number: 90
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
80  import org.omg.CORBA.Principal;
81  import org.omg.CORBA.SystemException;
82  import org.omg.CORBA.TCKind;
83  import org.omg.CORBA.TypeCode;
84  import org.omg.CORBA.TypeCodePackage.BadKind;
85  import org.omg.CORBA.portable.BoxedValueHelper;
86  import org.omg.CORBA.portable.CustomValue;
87  import org.omg.CORBA.portable.IDLEntity;
88  import org.omg.CORBA.portable.IndirectionException;
89  import org.omg.CORBA.portable.StreamableValue;
90  import org.omg.CORBA.portable.ValueBase;
91  import org.omg.CORBA.portable.ValueFactory;
92  
93  @SuppressWarnings("deprecation")
94  public class CDRInputStream_1_0 extends CDRInputStreamBase implements RestorableInputStream
95  {
96      private static final String kReadMethod = "read";
97  
98      private static final int maxBlockLength = 0x7fffff00;
99  
100      protected BufferManagerRead bufferManagerRead;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStream.java
      * Line Number: 113
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
103  
104      public CDROutputStream(ORB orb, GIOPVersion version, byte encodingVersion, boolean littleEndian,
105              BufferManagerWrite bufferManager, byte streamFormatVersion)
106      {
107          this(orb, version, encodingVersion, littleEndian, bufferManager, streamFormatVersion, true);
108      }
109  
110      // org.omg.CORBA.portable.OutputStream
111  
112      // Provided by IIOPOutputStream and EncapsOutputStream
113      public abstract org.omg.CORBA.portable.InputStream create_input_stream();
114  
115      public final void write_boolean(boolean value)
116      {
117          impl.write_boolean(value);
118      }
119  
120      public final void write_char(char value)
121      {
122          impl.write_char(value);
123      }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStream.java
      * Line Number: 250
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
240      public final void write_float_array(float[] value, int offset, int length)
241      {
242          impl.write_float_array(value, offset, length);
243      }
244  
245      public final void write_double_array(double[] value, int offset, int length)
246      {
247          impl.write_double_array(value, offset, length);
248      }
249  
250      public final void write_Object(org.omg.CORBA.Object value)
251      {
252          impl.write_Object(value);
253      }
254  
255      public final void write_TypeCode(TypeCode value)
256      {
257          impl.write_TypeCode(value);
258      }
259  
260      public final void write_any(Any value)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStream.java
      * Line Number: 36
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
26  import java.io.IOException;
27  import java.nio.ByteBuffer;
28  
29  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
30  import org.jboss.com.sun.corba.se.impl.protocol.giopmsgheaders.Message;
31  import org.jboss.com.sun.corba.se.pept.protocol.MessageMediator;
32  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
33  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
34  import org.jboss.com.sun.corba.se.spi.orb.ORB;
35  import org.jboss.com.sun.corba.se.spi.protocol.CorbaMessageMediator;
36  import org.omg.CORBA.Any;
37  import org.omg.CORBA.Principal;
38  import org.omg.CORBA.TypeCode;
39  
40  /**
41   * This is delegates to the real implementation.
42   */
43  @SuppressWarnings("deprecation")
44  public abstract class CDROutputStream extends org.omg.CORBA_2_3.portable.OutputStream
45          implements
46              MarshalOutputStream,
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStream.java
      * Line Number: 37
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
27  import java.nio.ByteBuffer;
28  
29  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
30  import org.jboss.com.sun.corba.se.impl.protocol.giopmsgheaders.Message;
31  import org.jboss.com.sun.corba.se.pept.protocol.MessageMediator;
32  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
33  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
34  import org.jboss.com.sun.corba.se.spi.orb.ORB;
35  import org.jboss.com.sun.corba.se.spi.protocol.CorbaMessageMediator;
36  import org.omg.CORBA.Any;
37  import org.omg.CORBA.Principal;
38  import org.omg.CORBA.TypeCode;
39  
40  /**
41   * This is delegates to the real implementation.
42   */
43  @SuppressWarnings("deprecation")
44  public abstract class CDROutputStream extends org.omg.CORBA_2_3.portable.OutputStream
45          implements
46              MarshalOutputStream,
47              org.omg.CORBA.DataOutputStream,
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStream.java
      * Line Number: 280
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
270      public final void write(int b) throws java.io.IOException
271      {
272          impl.write(b);
273      }
274  
275      public final void write_fixed(java.math.BigDecimal value)
276      {
277          impl.write_fixed(value);
278      }
279  
280      public final void write_Context(org.omg.CORBA.Context ctx, org.omg.CORBA.ContextList contexts)
281      {
282          impl.write_Context(ctx, contexts);
283      }
284  
285      public final org.omg.CORBA.ORB orb()
286      {
287          return impl.orb();
288      }
289  
290      // org.omg.CORBA_2_3.portable.OutputStream
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStream.java
      * Line Number: 285
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
275      public final void write_fixed(java.math.BigDecimal value)
276      {
277          impl.write_fixed(value);
278      }
279  
280      public final void write_Context(org.omg.CORBA.Context ctx, org.omg.CORBA.ContextList contexts)
281      {
282          impl.write_Context(ctx, contexts);
283      }
284  
285      public final org.omg.CORBA.ORB orb()
286      {
287          return impl.orb();
288      }
289  
290      // org.omg.CORBA_2_3.portable.OutputStream
291      public final void write_value(java.io.Serializable value)
292      {
293          impl.write_value(value);
294      }
295  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStream.java
      * Line Number: 38
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
28  
29  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
30  import org.jboss.com.sun.corba.se.impl.protocol.giopmsgheaders.Message;
31  import org.jboss.com.sun.corba.se.pept.protocol.MessageMediator;
32  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
33  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
34  import org.jboss.com.sun.corba.se.spi.orb.ORB;
35  import org.jboss.com.sun.corba.se.spi.protocol.CorbaMessageMediator;
36  import org.omg.CORBA.Any;
37  import org.omg.CORBA.Principal;
38  import org.omg.CORBA.TypeCode;
39  
40  /**
41   * This is delegates to the real implementation.
42   */
43  @SuppressWarnings("deprecation")
44  public abstract class CDROutputStream extends org.omg.CORBA_2_3.portable.OutputStream
45          implements
46              MarshalOutputStream,
47              org.omg.CORBA.DataOutputStream,
48              org.omg.CORBA.portable.ValueOutputStream
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStream.java
      * Line Number: 307
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
297      public final void write_value(java.io.Serializable value, Class clz)
298      {
299          impl.write_value(value, clz);
300      }
301  
302      public final void write_value(java.io.Serializable value, String repository_id)
303      {
304          impl.write_value(value, repository_id);
305      }
306  
307      public final void write_value(java.io.Serializable value, org.omg.CORBA.portable.BoxedValueHelper factory)
308      {
309          impl.write_value(value, factory);
310      }
311  
312      public final void write_abstract_interface(Object obj)
313      {
314          impl.write_abstract_interface(obj);
315      }
316  
317      // java.io.OutputStream
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStream.java
      * Line Number: 44
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
34  import org.jboss.com.sun.corba.se.spi.orb.ORB;
35  import org.jboss.com.sun.corba.se.spi.protocol.CorbaMessageMediator;
36  import org.omg.CORBA.Any;
37  import org.omg.CORBA.Principal;
38  import org.omg.CORBA.TypeCode;
39  
40  /**
41   * This is delegates to the real implementation.
42   */
43  @SuppressWarnings("deprecation")
44  public abstract class CDROutputStream extends org.omg.CORBA_2_3.portable.OutputStream
45          implements
46              MarshalOutputStream,
47              org.omg.CORBA.DataOutputStream,
48              org.omg.CORBA.portable.ValueOutputStream
49  {
50      private CDROutputStreamBase impl;
51  
52      protected ORB orb;
53  
54      protected ORBUtilSystemException wrapper;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStream.java
      * Line Number: 375
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
365      public final void write_Abstract(Object value)
366      {
367          impl.write_Abstract(value);
368      }
369  
370      public final void write_Value(java.io.Serializable value)
371      {
372          impl.write_Value(value);
373      }
374  
375      public final void write_any_array(org.omg.CORBA.Any[] seq, int offset, int length)
376      {
377          impl.write_any_array(seq, offset, length);
378      }
379  
380      public void setMessageMediator(MessageMediator messageMediator)
381      {
382          this.corbaMessageMediator = (CorbaMessageMediator) messageMediator;
383      }
384  
385      public MessageMediator getMessageMediator()
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStream.java
      * Line Number: 47
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
37  import org.omg.CORBA.Principal;
38  import org.omg.CORBA.TypeCode;
39  
40  /**
41   * This is delegates to the real implementation.
42   */
43  @SuppressWarnings("deprecation")
44  public abstract class CDROutputStream extends org.omg.CORBA_2_3.portable.OutputStream
45          implements
46              MarshalOutputStream,
47              org.omg.CORBA.DataOutputStream,
48              org.omg.CORBA.portable.ValueOutputStream
49  {
50      private CDROutputStreamBase impl;
51  
52      protected ORB orb;
53  
54      protected ORBUtilSystemException wrapper;
55  
56      protected CorbaMessageMediator corbaMessageMediator;
57  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStream.java
      * Line Number: 48
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
38  import org.omg.CORBA.TypeCode;
39  
40  /**
41   * This is delegates to the real implementation.
42   */
43  @SuppressWarnings("deprecation")
44  public abstract class CDROutputStream extends org.omg.CORBA_2_3.portable.OutputStream
45          implements
46              MarshalOutputStream,
47              org.omg.CORBA.DataOutputStream,
48              org.omg.CORBA.portable.ValueOutputStream
49  {
50      private CDROutputStreamBase impl;
51  
52      protected ORB orb;
53  
54      protected ORBUtilSystemException wrapper;
55  
56      protected CorbaMessageMediator corbaMessageMediator;
57  
58      // We can move this out somewhere later. For now, it serves its purpose
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStream.java
      * Line Number: 456
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
446      public final BufferManagerWrite getBufferManager()
447      {
448          return impl.getBufferManager();
449      }
450  
451      public final void write_fixed(java.math.BigDecimal bigDecimal, short digits, short scale)
452      {
453          impl.write_fixed(bigDecimal, digits, scale);
454      }
455  
456      public final void writeOctetSequenceTo(org.omg.CORBA.portable.OutputStream s)
457      {
458          impl.writeOctetSequenceTo(s);
459      }
460  
461      public final GIOPVersion getGIOPVersion()
462      {
463          return impl.getGIOPVersion();
464      }
465  
466      public final void writeIndirection(int tag, int posIndirectedTo)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStreamBase.java
      * Line Number: 113
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
103      public abstract void write_ulong_array(int[] value, int offset, int length);
104  
105      public abstract void write_longlong_array(long[] value, int offset, int length);
106  
107      public abstract void write_ulonglong_array(long[] value, int offset, int length);
108  
109      public abstract void write_float_array(float[] value, int offset, int length);
110  
111      public abstract void write_double_array(double[] value, int offset, int length);
112  
113      public abstract void write_Object(org.omg.CORBA.Object value);
114  
115      public abstract void write_TypeCode(TypeCode value);
116  
117      public abstract void write_any(Any value);
118  
119      public abstract void write_Principal(Principal value);
120  
121      public void write(int b) throws java.io.IOException
122      {
123          throw new org.omg.CORBA.NO_IMPLEMENT();
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStreamBase.java
      * Line Number: 123
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
113      public abstract void write_Object(org.omg.CORBA.Object value);
114  
115      public abstract void write_TypeCode(TypeCode value);
116  
117      public abstract void write_any(Any value);
118  
119      public abstract void write_Principal(Principal value);
120  
121      public void write(int b) throws java.io.IOException
122      {
123          throw new org.omg.CORBA.NO_IMPLEMENT();
124      }
125  
126      public abstract void write_fixed(java.math.BigDecimal value);
127  
128      public void write_Context(org.omg.CORBA.Context ctx, org.omg.CORBA.ContextList contexts)
129      {
130          throw new org.omg.CORBA.NO_IMPLEMENT();
131      }
132  
133      public abstract org.omg.CORBA.ORB orb();
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStreamBase.java
      * Line Number: 128
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
118  
119      public abstract void write_Principal(Principal value);
120  
121      public void write(int b) throws java.io.IOException
122      {
123          throw new org.omg.CORBA.NO_IMPLEMENT();
124      }
125  
126      public abstract void write_fixed(java.math.BigDecimal value);
127  
128      public void write_Context(org.omg.CORBA.Context ctx, org.omg.CORBA.ContextList contexts)
129      {
130          throw new org.omg.CORBA.NO_IMPLEMENT();
131      }
132  
133      public abstract org.omg.CORBA.ORB orb();
134  
135      // org.omg.CORBA_2_3.portable.OutputStream
136      public abstract void write_value(java.io.Serializable value);
137  
138      public abstract void write_value(java.io.Serializable value, java.lang.Class<?> clz);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStreamBase.java
      * Line Number: 130
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
120  
121      public void write(int b) throws java.io.IOException
122      {
123          throw new org.omg.CORBA.NO_IMPLEMENT();
124      }
125  
126      public abstract void write_fixed(java.math.BigDecimal value);
127  
128      public void write_Context(org.omg.CORBA.Context ctx, org.omg.CORBA.ContextList contexts)
129      {
130          throw new org.omg.CORBA.NO_IMPLEMENT();
131      }
132  
133      public abstract org.omg.CORBA.ORB orb();
134  
135      // org.omg.CORBA_2_3.portable.OutputStream
136      public abstract void write_value(java.io.Serializable value);
137  
138      public abstract void write_value(java.io.Serializable value, java.lang.Class<?> clz);
139  
140      public abstract void write_value(java.io.Serializable value, String repository_id);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStreamBase.java
      * Line Number: 133
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
123          throw new org.omg.CORBA.NO_IMPLEMENT();
124      }
125  
126      public abstract void write_fixed(java.math.BigDecimal value);
127  
128      public void write_Context(org.omg.CORBA.Context ctx, org.omg.CORBA.ContextList contexts)
129      {
130          throw new org.omg.CORBA.NO_IMPLEMENT();
131      }
132  
133      public abstract org.omg.CORBA.ORB orb();
134  
135      // org.omg.CORBA_2_3.portable.OutputStream
136      public abstract void write_value(java.io.Serializable value);
137  
138      public abstract void write_value(java.io.Serializable value, java.lang.Class<?> clz);
139  
140      public abstract void write_value(java.io.Serializable value, String repository_id);
141  
142      public abstract void write_value(java.io.Serializable value, org.omg.CORBA.portable.BoxedValueHelper factory);
143  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStreamBase.java
      * Line Number: 142
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
132  
133      public abstract org.omg.CORBA.ORB orb();
134  
135      // org.omg.CORBA_2_3.portable.OutputStream
136      public abstract void write_value(java.io.Serializable value);
137  
138      public abstract void write_value(java.io.Serializable value, java.lang.Class<?> clz);
139  
140      public abstract void write_value(java.io.Serializable value, String repository_id);
141  
142      public abstract void write_value(java.io.Serializable value, org.omg.CORBA.portable.BoxedValueHelper factory);
143  
144      public abstract void write_abstract_interface(java.lang.Object obj);
145  
146      // java.io.OutputStream
147      // public abstract void write(byte b[]) throws IOException;
148      // public abstract void write(byte b[], int off, int len) throws IOException;
149      // public abstract void flush() throws IOException;
150      // public abstract void close() throws IOException;
151  
152      // org.jboss.com.sun.corba.se.impl.encoding.MarshalOutputStream
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStreamBase.java
      * Line Number: 168
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
158  
159      public abstract void writeTo(java.io.OutputStream s) throws IOException;
160  
161      public abstract byte[] toByteArray();
162  
163      // org.omg.CORBA.DataOutputStream
164      public abstract void write_Abstract(java.lang.Object value);
165  
166      public abstract void write_Value(java.io.Serializable value);
167  
168      public abstract void write_any_array(org.omg.CORBA.Any[] seq, int offset, int length);
169  
170      // org.omg.CORBA.portable.ValueBase
171      public abstract String[] _truncatable_ids();
172  
173      // Needed by request and reply messages for GIOP versions >= 1.2 only.
174      abstract void setHeaderPadding(boolean headerPadding);
175  
176      // Required by IIOPOutputStream and other subclasses
177      public abstract int getSize();
178  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStreamBase.java
      * Line Number: 197
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
187      public abstract boolean isLittleEndian();
188  
189      public abstract ByteBufferWithInfo getByteBufferWithInfo();
190  
191      public abstract void setByteBufferWithInfo(ByteBufferWithInfo bbwi);
192  
193      public abstract BufferManagerWrite getBufferManager();
194  
195      public abstract void write_fixed(java.math.BigDecimal bigDecimal, short digits, short scale);
196  
197      public abstract void writeOctetSequenceTo(org.omg.CORBA.portable.OutputStream s);
198  
199      public abstract GIOPVersion getGIOPVersion();
200  
201      public abstract void writeIndirection(int tag, int posIndirectedTo);
202  
203      abstract void freeInternalCaches();
204  
205      abstract void printBuffer();
206  
207      abstract void alignOnBoundary(int octetBoundary);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStreamBase.java
      * Line Number: 31
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
21   * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
22   * or visit www.oracle.com if you need additional information or have any
23   * questions.
24   */
25  package org.jboss.com.sun.corba.se.impl.encoding;
26  
27  import java.io.IOException;
28  import java.nio.ByteBuffer;
29  
30  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
31  import org.omg.CORBA.Any;
32  import org.omg.CORBA.Principal;
33  import org.omg.CORBA.TypeCode;
34  
35  /**
36   * Describes CDROutputStream delegates and provides some implementation. Non-default constructors are avoided in the
37   * delegation to separate instantiation from initialization, so we use init methods.
38   */
39  @SuppressWarnings("deprecation")
40  abstract class CDROutputStreamBase extends java.io.OutputStream
41  {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStreamBase.java
      * Line Number: 32
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
22   * or visit www.oracle.com if you need additional information or have any
23   * questions.
24   */
25  package org.jboss.com.sun.corba.se.impl.encoding;
26  
27  import java.io.IOException;
28  import java.nio.ByteBuffer;
29  
30  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
31  import org.omg.CORBA.Any;
32  import org.omg.CORBA.Principal;
33  import org.omg.CORBA.TypeCode;
34  
35  /**
36   * Describes CDROutputStream delegates and provides some implementation. Non-default constructors are avoided in the
37   * delegation to separate instantiation from initialization, so we use init methods.
38   */
39  @SuppressWarnings("deprecation")
40  abstract class CDROutputStreamBase extends java.io.OutputStream
41  {
42      protected CDROutputStream parent;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStreamBase.java
      * Line Number: 33
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
23   * questions.
24   */
25  package org.jboss.com.sun.corba.se.impl.encoding;
26  
27  import java.io.IOException;
28  import java.nio.ByteBuffer;
29  
30  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
31  import org.omg.CORBA.Any;
32  import org.omg.CORBA.Principal;
33  import org.omg.CORBA.TypeCode;
34  
35  /**
36   * Describes CDROutputStream delegates and provides some implementation. Non-default constructors are avoided in the
37   * delegation to separate instantiation from initialization, so we use init methods.
38   */
39  @SuppressWarnings("deprecation")
40  abstract class CDROutputStreamBase extends java.io.OutputStream
41  {
42      protected CDROutputStream parent;
43  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStreamBase.java
      * Line Number: 50
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
40  abstract class CDROutputStreamBase extends java.io.OutputStream
41  {
42      protected CDROutputStream parent;
43  
44      // Required by parent CDROutputStream
45      public void setParent(CDROutputStream parent)
46      {
47          this.parent = parent;
48      }
49  
50      public void init(org.omg.CORBA.ORB orb, BufferManagerWrite bufferManager, byte streamFormatVersion)
51      {
52          init(orb, false, bufferManager, streamFormatVersion, true);
53      }
54  
55      // See EncapsOutputStream, the only one that uses the non-pooled ByteBuffers, for additional info.
56      protected abstract void init(org.omg.CORBA.ORB orb, boolean littleEndian, BufferManagerWrite bufferManager,
57              byte streamFormatVersion, boolean usePooledByteBuffers);
58  
59      public abstract void write_boolean(boolean value);
60  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStreamBase.java
      * Line Number: 56
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
46      {
47          this.parent = parent;
48      }
49  
50      public void init(org.omg.CORBA.ORB orb, BufferManagerWrite bufferManager, byte streamFormatVersion)
51      {
52          init(orb, false, bufferManager, streamFormatVersion, true);
53      }
54  
55      // See EncapsOutputStream, the only one that uses the non-pooled ByteBuffers, for additional info.
56      protected abstract void init(org.omg.CORBA.ORB orb, boolean littleEndian, BufferManagerWrite bufferManager,
57              byte streamFormatVersion, boolean usePooledByteBuffers);
58  
59      public abstract void write_boolean(boolean value);
60  
61      public abstract void write_char(char value);
62  
63      public abstract void write_wchar(char value);
64  
65      public abstract void write_octet(byte value);
66  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStream_1_0.java
      * Line Number: 647
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStream_1_0.java
      * Line Number: 652
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStream_1_0.java
      * Line Number: 758
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStream_1_0.java
      * Line Number: 885
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStream_1_0.java
      * Line Number: 888
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStream_1_0.java
      * Line Number: 921
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStream_1_0.java
      * Line Number: 1112
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStream_1_0.java
      * Line Number: 1272
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStream_1_0.java
      * Line Number: 1303
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStream_1_0.java
      * Line Number: 1631
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStream_1_0.java
      * Line Number: 1663
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStream_1_0.java
      * Line Number: 147
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
137  
138      private RepositoryIdStrings repIdStrs;
139  
140      // Code set converters (created when first needed)
141      private CodeSetConversion.CTBConverter charConverter;
142  
143      private CodeSetConversion.CTBConverter wcharConverter;
144  
145      // REVISIT - This should be re-factored so that including whether to use pool byte buffers or not doesn't need to be
146      // known.
147      public void init(org.omg.CORBA.ORB orb, boolean littleEndian, BufferManagerWrite bufferManager,
148              byte streamFormatVersion, boolean usePooledByteBuffers)
149      {
150          // ORB must not be null. See CDROutputStream constructor.
151          this.orb = (ORB) orb;
152          this.wrapper = ORBUtilSystemException.get(this.orb, CORBALogDomains.RPC_ENCODING);
153          debug = this.orb.transportDebugFlag;
154  
155          this.littleEndian = littleEndian;
156          this.bufferManagerWrite = bufferManager;
157          this.bbwi = new ByteBufferWithInfo(orb, bufferManager, usePooledByteBuffers);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStream_1_0.java
      * Line Number: 163
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
153          debug = this.orb.transportDebugFlag;
154  
155          this.littleEndian = littleEndian;
156          this.bufferManagerWrite = bufferManager;
157          this.bbwi = new ByteBufferWithInfo(orb, bufferManager, usePooledByteBuffers);
158          this.streamFormatVersion = streamFormatVersion;
159  
160          createRepositoryIdHandlers();
161      }
162  
163      public void init(org.omg.CORBA.ORB orb, boolean littleEndian, BufferManagerWrite bufferManager,
164              byte streamFormatVersion)
165      {
166          init(orb, littleEndian, bufferManager, streamFormatVersion, true);
167      }
168  
169      private final void createRepositoryIdHandlers()
170      {
171          if (orb != null)
172          {
173              // Get the appropriate versions based on the ORB version. The ORB versioning info is only in the core ORB.
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStream_1_0.java
      * Line Number: 64
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
54  import org.jboss.com.sun.corba.se.impl.util.Utility;
55  import org.jboss.com.sun.corba.se.pept.protocol.MessageMediator;
56  import org.jboss.com.sun.corba.se.pept.transport.ByteBufferPool;
57  import org.jboss.com.sun.corba.se.spi.ior.IOR;
58  import org.jboss.com.sun.corba.se.spi.ior.IORFactories;
59  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
60  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
61  import org.jboss.com.sun.corba.se.spi.orb.ORB;
62  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
63  import org.jboss.com.sun.org.omg.CORBA.portable.ValueHelper;
64  import org.omg.CORBA.Any;
65  import org.omg.CORBA.CompletionStatus;
66  import org.omg.CORBA.CustomMarshal;
67  import org.omg.CORBA.Principal;
68  import org.omg.CORBA.SystemException;
69  import org.omg.CORBA.TypeCode;
70  import org.omg.CORBA.VM_CUSTOM;
71  import org.omg.CORBA.VM_NONE;
72  import org.omg.CORBA.VM_TRUNCATABLE;
73  import org.omg.CORBA.TypeCodePackage.BadKind;
74  import org.omg.CORBA.portable.BoxedValueHelper;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStream_1_0.java
      * Line Number: 65
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
55  import org.jboss.com.sun.corba.se.pept.protocol.MessageMediator;
56  import org.jboss.com.sun.corba.se.pept.transport.ByteBufferPool;
57  import org.jboss.com.sun.corba.se.spi.ior.IOR;
58  import org.jboss.com.sun.corba.se.spi.ior.IORFactories;
59  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
60  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
61  import org.jboss.com.sun.corba.se.spi.orb.ORB;
62  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
63  import org.jboss.com.sun.org.omg.CORBA.portable.ValueHelper;
64  import org.omg.CORBA.Any;
65  import org.omg.CORBA.CompletionStatus;
66  import org.omg.CORBA.CustomMarshal;
67  import org.omg.CORBA.Principal;
68  import org.omg.CORBA.SystemException;
69  import org.omg.CORBA.TypeCode;
70  import org.omg.CORBA.VM_CUSTOM;
71  import org.omg.CORBA.VM_NONE;
72  import org.omg.CORBA.VM_TRUNCATABLE;
73  import org.omg.CORBA.TypeCodePackage.BadKind;
74  import org.omg.CORBA.portable.BoxedValueHelper;
75  import org.omg.CORBA.portable.CustomValue;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStream_1_0.java
      * Line Number: 66
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
56  import org.jboss.com.sun.corba.se.pept.transport.ByteBufferPool;
57  import org.jboss.com.sun.corba.se.spi.ior.IOR;
58  import org.jboss.com.sun.corba.se.spi.ior.IORFactories;
59  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
60  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
61  import org.jboss.com.sun.corba.se.spi.orb.ORB;
62  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
63  import org.jboss.com.sun.org.omg.CORBA.portable.ValueHelper;
64  import org.omg.CORBA.Any;
65  import org.omg.CORBA.CompletionStatus;
66  import org.omg.CORBA.CustomMarshal;
67  import org.omg.CORBA.Principal;
68  import org.omg.CORBA.SystemException;
69  import org.omg.CORBA.TypeCode;
70  import org.omg.CORBA.VM_CUSTOM;
71  import org.omg.CORBA.VM_NONE;
72  import org.omg.CORBA.VM_TRUNCATABLE;
73  import org.omg.CORBA.TypeCodePackage.BadKind;
74  import org.omg.CORBA.portable.BoxedValueHelper;
75  import org.omg.CORBA.portable.CustomValue;
76  import org.omg.CORBA.portable.IDLEntity;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStream_1_0.java
      * Line Number: 67
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
57  import org.jboss.com.sun.corba.se.spi.ior.IOR;
58  import org.jboss.com.sun.corba.se.spi.ior.IORFactories;
59  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
60  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
61  import org.jboss.com.sun.corba.se.spi.orb.ORB;
62  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
63  import org.jboss.com.sun.org.omg.CORBA.portable.ValueHelper;
64  import org.omg.CORBA.Any;
65  import org.omg.CORBA.CompletionStatus;
66  import org.omg.CORBA.CustomMarshal;
67  import org.omg.CORBA.Principal;
68  import org.omg.CORBA.SystemException;
69  import org.omg.CORBA.TypeCode;
70  import org.omg.CORBA.VM_CUSTOM;
71  import org.omg.CORBA.VM_NONE;
72  import org.omg.CORBA.VM_TRUNCATABLE;
73  import org.omg.CORBA.TypeCodePackage.BadKind;
74  import org.omg.CORBA.portable.BoxedValueHelper;
75  import org.omg.CORBA.portable.CustomValue;
76  import org.omg.CORBA.portable.IDLEntity;
77  import org.omg.CORBA.portable.StreamableValue;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStream_1_0.java
      * Line Number: 68
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
58  import org.jboss.com.sun.corba.se.spi.ior.IORFactories;
59  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
60  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
61  import org.jboss.com.sun.corba.se.spi.orb.ORB;
62  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
63  import org.jboss.com.sun.org.omg.CORBA.portable.ValueHelper;
64  import org.omg.CORBA.Any;
65  import org.omg.CORBA.CompletionStatus;
66  import org.omg.CORBA.CustomMarshal;
67  import org.omg.CORBA.Principal;
68  import org.omg.CORBA.SystemException;
69  import org.omg.CORBA.TypeCode;
70  import org.omg.CORBA.VM_CUSTOM;
71  import org.omg.CORBA.VM_NONE;
72  import org.omg.CORBA.VM_TRUNCATABLE;
73  import org.omg.CORBA.TypeCodePackage.BadKind;
74  import org.omg.CORBA.portable.BoxedValueHelper;
75  import org.omg.CORBA.portable.CustomValue;
76  import org.omg.CORBA.portable.IDLEntity;
77  import org.omg.CORBA.portable.StreamableValue;
78  import org.omg.CORBA.portable.ValueBase;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStream_1_0.java
      * Line Number: 69
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
59  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
60  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
61  import org.jboss.com.sun.corba.se.spi.orb.ORB;
62  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
63  import org.jboss.com.sun.org.omg.CORBA.portable.ValueHelper;
64  import org.omg.CORBA.Any;
65  import org.omg.CORBA.CompletionStatus;
66  import org.omg.CORBA.CustomMarshal;
67  import org.omg.CORBA.Principal;
68  import org.omg.CORBA.SystemException;
69  import org.omg.CORBA.TypeCode;
70  import org.omg.CORBA.VM_CUSTOM;
71  import org.omg.CORBA.VM_NONE;
72  import org.omg.CORBA.VM_TRUNCATABLE;
73  import org.omg.CORBA.TypeCodePackage.BadKind;
74  import org.omg.CORBA.portable.BoxedValueHelper;
75  import org.omg.CORBA.portable.CustomValue;
76  import org.omg.CORBA.portable.IDLEntity;
77  import org.omg.CORBA.portable.StreamableValue;
78  import org.omg.CORBA.portable.ValueBase;
79  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStream_1_0.java
      * Line Number: 70
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
60  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
61  import org.jboss.com.sun.corba.se.spi.orb.ORB;
62  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
63  import org.jboss.com.sun.org.omg.CORBA.portable.ValueHelper;
64  import org.omg.CORBA.Any;
65  import org.omg.CORBA.CompletionStatus;
66  import org.omg.CORBA.CustomMarshal;
67  import org.omg.CORBA.Principal;
68  import org.omg.CORBA.SystemException;
69  import org.omg.CORBA.TypeCode;
70  import org.omg.CORBA.VM_CUSTOM;
71  import org.omg.CORBA.VM_NONE;
72  import org.omg.CORBA.VM_TRUNCATABLE;
73  import org.omg.CORBA.TypeCodePackage.BadKind;
74  import org.omg.CORBA.portable.BoxedValueHelper;
75  import org.omg.CORBA.portable.CustomValue;
76  import org.omg.CORBA.portable.IDLEntity;
77  import org.omg.CORBA.portable.StreamableValue;
78  import org.omg.CORBA.portable.ValueBase;
79  
80  @SuppressWarnings("deprecation")
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStream_1_0.java
      * Line Number: 71
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
61  import org.jboss.com.sun.corba.se.spi.orb.ORB;
62  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
63  import org.jboss.com.sun.org.omg.CORBA.portable.ValueHelper;
64  import org.omg.CORBA.Any;
65  import org.omg.CORBA.CompletionStatus;
66  import org.omg.CORBA.CustomMarshal;
67  import org.omg.CORBA.Principal;
68  import org.omg.CORBA.SystemException;
69  import org.omg.CORBA.TypeCode;
70  import org.omg.CORBA.VM_CUSTOM;
71  import org.omg.CORBA.VM_NONE;
72  import org.omg.CORBA.VM_TRUNCATABLE;
73  import org.omg.CORBA.TypeCodePackage.BadKind;
74  import org.omg.CORBA.portable.BoxedValueHelper;
75  import org.omg.CORBA.portable.CustomValue;
76  import org.omg.CORBA.portable.IDLEntity;
77  import org.omg.CORBA.portable.StreamableValue;
78  import org.omg.CORBA.portable.ValueBase;
79  
80  @SuppressWarnings("deprecation")
81  public class CDROutputStream_1_0 extends CDROutputStreamBase
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStream_1_0.java
      * Line Number: 620
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
610              tci = (TypeCodeImpl) tc;
611          }
612          else
613          {
614              tci = new TypeCodeImpl(orb, tc);
615          }
616  
617          tci.write_value(parent);
618      }
619  
620      public void write_Object(org.omg.CORBA.Object ref)
621      {
622          if (ref == null)
623          {
624              IOR nullIOR = IORFactories.makeIOR(orb);
625              nullIOR.write(parent);
626              return;
627          }
628  
629          // IDL to Java formal 01-06-06 1.21.4.2
630          if (ref instanceof org.omg.CORBA.LocalObject)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStream_1_0.java
      * Line Number: 72
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
62  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
63  import org.jboss.com.sun.org.omg.CORBA.portable.ValueHelper;
64  import org.omg.CORBA.Any;
65  import org.omg.CORBA.CompletionStatus;
66  import org.omg.CORBA.CustomMarshal;
67  import org.omg.CORBA.Principal;
68  import org.omg.CORBA.SystemException;
69  import org.omg.CORBA.TypeCode;
70  import org.omg.CORBA.VM_CUSTOM;
71  import org.omg.CORBA.VM_NONE;
72  import org.omg.CORBA.VM_TRUNCATABLE;
73  import org.omg.CORBA.TypeCodePackage.BadKind;
74  import org.omg.CORBA.portable.BoxedValueHelper;
75  import org.omg.CORBA.portable.CustomValue;
76  import org.omg.CORBA.portable.IDLEntity;
77  import org.omg.CORBA.portable.StreamableValue;
78  import org.omg.CORBA.portable.ValueBase;
79  
80  @SuppressWarnings("deprecation")
81  public class CDROutputStream_1_0 extends CDROutputStreamBase
82  {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStream_1_0.java
      * Line Number: 630
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
620      public void write_Object(org.omg.CORBA.Object ref)
621      {
622          if (ref == null)
623          {
624              IOR nullIOR = IORFactories.makeIOR(orb);
625              nullIOR.write(parent);
626              return;
627          }
628  
629          // IDL to Java formal 01-06-06 1.21.4.2
630          if (ref instanceof org.omg.CORBA.LocalObject)
631              throw wrapper.writeLocalObject(CompletionStatus.COMPLETED_MAYBE);
632  
633          IOR ior = ORBUtility.connectAndGetIOR(orb, ref);
634          ior.write(parent);
635          return;
636      }
637  
638      // ------------ RMI related methods --------------------------
639  
640      public void write_abstract_interface(Object obj)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStream_1_0.java
      * Line Number: 73
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
63  import org.jboss.com.sun.org.omg.CORBA.portable.ValueHelper;
64  import org.omg.CORBA.Any;
65  import org.omg.CORBA.CompletionStatus;
66  import org.omg.CORBA.CustomMarshal;
67  import org.omg.CORBA.Principal;
68  import org.omg.CORBA.SystemException;
69  import org.omg.CORBA.TypeCode;
70  import org.omg.CORBA.VM_CUSTOM;
71  import org.omg.CORBA.VM_NONE;
72  import org.omg.CORBA.VM_TRUNCATABLE;
73  import org.omg.CORBA.TypeCodePackage.BadKind;
74  import org.omg.CORBA.portable.BoxedValueHelper;
75  import org.omg.CORBA.portable.CustomValue;
76  import org.omg.CORBA.portable.IDLEntity;
77  import org.omg.CORBA.portable.StreamableValue;
78  import org.omg.CORBA.portable.ValueBase;
79  
80  @SuppressWarnings("deprecation")
81  public class CDROutputStream_1_0 extends CDROutputStreamBase
82  {
83      private static final int INDIRECTION_TAG = 0xffffffff;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStream_1_0.java
      * Line Number: 643
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
633          IOR ior = ORBUtility.connectAndGetIOR(orb, ref);
634          ior.write(parent);
635          return;
636      }
637  
638      // ------------ RMI related methods --------------------------
639  
640      public void write_abstract_interface(Object obj)
641      {
642          boolean corbaObject = false; // Assume value type.
643          org.omg.CORBA.Object theObject = null;
644  
645          // Is it a CORBA.Object?
646  
647          if (obj != null && obj instanceof org.omg.CORBA.Object)
648          {
649  
650              // Yes.
651  
652              theObject = (org.omg.CORBA.Object) obj;
653              corbaObject = true;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStream_1_0.java
      * Line Number: 74
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
64  import org.omg.CORBA.Any;
65  import org.omg.CORBA.CompletionStatus;
66  import org.omg.CORBA.CustomMarshal;
67  import org.omg.CORBA.Principal;
68  import org.omg.CORBA.SystemException;
69  import org.omg.CORBA.TypeCode;
70  import org.omg.CORBA.VM_CUSTOM;
71  import org.omg.CORBA.VM_NONE;
72  import org.omg.CORBA.VM_TRUNCATABLE;
73  import org.omg.CORBA.TypeCodePackage.BadKind;
74  import org.omg.CORBA.portable.BoxedValueHelper;
75  import org.omg.CORBA.portable.CustomValue;
76  import org.omg.CORBA.portable.IDLEntity;
77  import org.omg.CORBA.portable.StreamableValue;
78  import org.omg.CORBA.portable.ValueBase;
79  
80  @SuppressWarnings("deprecation")
81  public class CDROutputStream_1_0 extends CDROutputStreamBase
82  {
83      private static final int INDIRECTION_TAG = 0xffffffff;
84  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStream_1_0.java
      * Line Number: 75
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
65  import org.omg.CORBA.CompletionStatus;
66  import org.omg.CORBA.CustomMarshal;
67  import org.omg.CORBA.Principal;
68  import org.omg.CORBA.SystemException;
69  import org.omg.CORBA.TypeCode;
70  import org.omg.CORBA.VM_CUSTOM;
71  import org.omg.CORBA.VM_NONE;
72  import org.omg.CORBA.VM_TRUNCATABLE;
73  import org.omg.CORBA.TypeCodePackage.BadKind;
74  import org.omg.CORBA.portable.BoxedValueHelper;
75  import org.omg.CORBA.portable.CustomValue;
76  import org.omg.CORBA.portable.IDLEntity;
77  import org.omg.CORBA.portable.StreamableValue;
78  import org.omg.CORBA.portable.ValueBase;
79  
80  @SuppressWarnings("deprecation")
81  public class CDROutputStream_1_0 extends CDROutputStreamBase
82  {
83      private static final int INDIRECTION_TAG = 0xffffffff;
84  
85      protected boolean littleEndian;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStream_1_0.java
      * Line Number: 76
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
66  import org.omg.CORBA.CustomMarshal;
67  import org.omg.CORBA.Principal;
68  import org.omg.CORBA.SystemException;
69  import org.omg.CORBA.TypeCode;
70  import org.omg.CORBA.VM_CUSTOM;
71  import org.omg.CORBA.VM_NONE;
72  import org.omg.CORBA.VM_TRUNCATABLE;
73  import org.omg.CORBA.TypeCodePackage.BadKind;
74  import org.omg.CORBA.portable.BoxedValueHelper;
75  import org.omg.CORBA.portable.CustomValue;
76  import org.omg.CORBA.portable.IDLEntity;
77  import org.omg.CORBA.portable.StreamableValue;
78  import org.omg.CORBA.portable.ValueBase;
79  
80  @SuppressWarnings("deprecation")
81  public class CDROutputStream_1_0 extends CDROutputStreamBase
82  {
83      private static final int INDIRECTION_TAG = 0xffffffff;
84  
85      protected boolean littleEndian;
86  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStream_1_0.java
      * Line Number: 77
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
67  import org.omg.CORBA.Principal;
68  import org.omg.CORBA.SystemException;
69  import org.omg.CORBA.TypeCode;
70  import org.omg.CORBA.VM_CUSTOM;
71  import org.omg.CORBA.VM_NONE;
72  import org.omg.CORBA.VM_TRUNCATABLE;
73  import org.omg.CORBA.TypeCodePackage.BadKind;
74  import org.omg.CORBA.portable.BoxedValueHelper;
75  import org.omg.CORBA.portable.CustomValue;
76  import org.omg.CORBA.portable.IDLEntity;
77  import org.omg.CORBA.portable.StreamableValue;
78  import org.omg.CORBA.portable.ValueBase;
79  
80  @SuppressWarnings("deprecation")
81  public class CDROutputStream_1_0 extends CDROutputStreamBase
82  {
83      private static final int INDIRECTION_TAG = 0xffffffff;
84  
85      protected boolean littleEndian;
86  
87      protected BufferManagerWrite bufferManagerWrite;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStream_1_0.java
      * Line Number: 78
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
68  import org.omg.CORBA.SystemException;
69  import org.omg.CORBA.TypeCode;
70  import org.omg.CORBA.VM_CUSTOM;
71  import org.omg.CORBA.VM_NONE;
72  import org.omg.CORBA.VM_TRUNCATABLE;
73  import org.omg.CORBA.TypeCodePackage.BadKind;
74  import org.omg.CORBA.portable.BoxedValueHelper;
75  import org.omg.CORBA.portable.CustomValue;
76  import org.omg.CORBA.portable.IDLEntity;
77  import org.omg.CORBA.portable.StreamableValue;
78  import org.omg.CORBA.portable.ValueBase;
79  
80  @SuppressWarnings("deprecation")
81  public class CDROutputStream_1_0 extends CDROutputStreamBase
82  {
83      private static final int INDIRECTION_TAG = 0xffffffff;
84  
85      protected boolean littleEndian;
86  
87      protected BufferManagerWrite bufferManagerWrite;
88  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStream_1_1.java
      * Line Number: 27
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
17   * You should have received a copy of the GNU General Public License version
18   * 2 along with this work; if not, write to the Free Software Foundation,
19   * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
20   *
21   * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
22   * or visit www.oracle.com if you need additional information or have any
23   * questions.
24   */
25  package org.jboss.com.sun.corba.se.impl.encoding;
26  
27  import org.omg.CORBA.CompletionStatus;
28  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
29  import org.jboss.com.sun.corba.se.impl.encoding.CodeSetConversion;
30  
31  public class CDROutputStream_1_1 extends CDROutputStream_1_0
32  {
33      // This is used to keep indirections working across fragments. When added to the current bbwi.position(), the result
34      // is the current position in the byte stream without any fragment headers.
35      //
36      // It is equal to the following:
37      //
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/CDROutputStream_1_2.java
      * Line Number: 29
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
19   * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
20   *
21   * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
22   * or visit www.oracle.com if you need additional information or have any
23   * questions.
24   */
25  package org.jboss.com.sun.corba.se.impl.encoding;
26  
27  import org.jboss.com.sun.corba.se.impl.orbutil.ORBConstants;
28  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
29  import org.omg.CORBA.CompletionStatus;
30  
31  public class CDROutputStream_1_2 extends CDROutputStream_1_1
32  {
33      // There's a situation with chunking with fragmentation
34      // in which the alignment for a primitive value is needed
35      // to fill fragment N, but the primitive won't fit so
36      // must go into fragment N + 1. The behavior is the same
37      // as that for specialChunks.
38      //
39      // Unfortunately, given the current code, we can't reuse
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/EncapsInputStream.java
      * Line Number: 100
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
 90  
 91          performORBVersionSpecificInit();
 92      }
 93  
 94      // CDREncapsCodec
 95      // ServiceContext
 96      //
 97      // Assumes big endian (can use consumeEndian to read and set
 98      // the endianness if it is an encapsulation with a byte order
 99      // mark at the beginning)
100      public EncapsInputStream(org.omg.CORBA.ORB orb, byte[] data, int size, GIOPVersion version)
101      {
102          this(orb, data, size, false, version);
103      }
104  
105      /**
106       * Full constructor with a CodeBase parameter useful for unmarshaling RMI-IIOP valuetypes (technically against the
107       * intention of an encapsulation, but necessary due to OMG issue 4795. Used by ServiceContexts.
108       */
109      public EncapsInputStream(org.omg.CORBA.ORB orb, byte[] data, int size, GIOPVersion version, CodeBase codeBase)
110      {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/EncapsInputStream.java
      * Line Number: 109
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
 99      // mark at the beginning)
100      public EncapsInputStream(org.omg.CORBA.ORB orb, byte[] data, int size, GIOPVersion version)
101      {
102          this(orb, data, size, false, version);
103      }
104  
105      /**
106       * Full constructor with a CodeBase parameter useful for unmarshaling RMI-IIOP valuetypes (technically against the
107       * intention of an encapsulation, but necessary due to OMG issue 4795. Used by ServiceContexts.
108       */
109      public EncapsInputStream(org.omg.CORBA.ORB orb, byte[] data, int size, GIOPVersion version, CodeBase codeBase)
110      {
111          super(orb, ByteBuffer.wrap(data), size, false, version, Message.CDR_ENC_VERSION, BufferManagerFactory
112                  .newBufferManagerRead(BufferManagerFactory.GROW, Message.CDR_ENC_VERSION, (ORB) orb));
113  
114          this.codeBase = codeBase;
115  
116          performORBVersionSpecificInit();
117      }
118  
119      public CDRInputStream dup()
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/EncapsInputStream.java
      * Line Number: 36
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
26  package org.jboss.com.sun.corba.se.impl.encoding;
27  
28  import java.nio.ByteBuffer;
29  
30  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
31  import org.jboss.com.sun.corba.se.impl.protocol.giopmsgheaders.Message;
32  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
33  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
34  import org.jboss.com.sun.corba.se.spi.orb.ORB;
35  import org.jboss.com.sun.org.omg.SendingContext.CodeBase;
36  import org.omg.CORBA.CompletionStatus;
37  
38  /**
39   * Encapsulations are supposed to explicitly define their code sets and GIOP version. The original resolution to issue
40   * 2784 said that the defaults were UTF-8 and UTF-16, but that was not agreed upon.
41   * 
42   * These streams currently use CDR 1.2 with ISO8859-1 for char/string and UTF16 for wchar/wstring. If no byte order
43   * marker is available, the endianness of the encapsulation is used.
44   * 
45   * When more encapsulations arise that have their own special code sets defined, we can make all constructors take such
46   * parameters.
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/EncapsInputStream.java
      * Line Number: 55
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
45   * When more encapsulations arise that have their own special code sets defined, we can make all constructors take such
46   * parameters.
47   */
48  public class EncapsInputStream extends CDRInputStream
49  {
50      private ORBUtilSystemException wrapper;
51  
52      // corba/EncapsOutputStream
53      // corba/ORBSingleton
54      // iiop/ORB
55      public EncapsInputStream(org.omg.CORBA.ORB orb, byte[] buf, int size, boolean littleEndian, GIOPVersion version)
56      {
57          super(orb, ByteBuffer.wrap(buf), size, littleEndian, version, Message.CDR_ENC_VERSION, BufferManagerFactory
58                  .newBufferManagerRead(BufferManagerFactory.GROW, Message.CDR_ENC_VERSION, (ORB) orb));
59  
60          wrapper = ORBUtilSystemException.get((ORB) orb, CORBALogDomains.RPC_ENCODING);
61  
62          performORBVersionSpecificInit();
63      }
64  
65      public EncapsInputStream(org.omg.CORBA.ORB orb, ByteBuffer byteBuffer, int size, boolean littleEndian,
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/EncapsInputStream.java
      * Line Number: 65
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
55      public EncapsInputStream(org.omg.CORBA.ORB orb, byte[] buf, int size, boolean littleEndian, GIOPVersion version)
56      {
57          super(orb, ByteBuffer.wrap(buf), size, littleEndian, version, Message.CDR_ENC_VERSION, BufferManagerFactory
58                  .newBufferManagerRead(BufferManagerFactory.GROW, Message.CDR_ENC_VERSION, (ORB) orb));
59  
60          wrapper = ORBUtilSystemException.get((ORB) orb, CORBALogDomains.RPC_ENCODING);
61  
62          performORBVersionSpecificInit();
63      }
64  
65      public EncapsInputStream(org.omg.CORBA.ORB orb, ByteBuffer byteBuffer, int size, boolean littleEndian,
66              GIOPVersion version)
67      {
68          super(orb, byteBuffer, size, littleEndian, version, Message.CDR_ENC_VERSION, BufferManagerFactory
69                  .newBufferManagerRead(BufferManagerFactory.GROW, Message.CDR_ENC_VERSION,
70                          (org.jboss.com.sun.corba.se.spi.orb.ORB) orb));
71  
72          performORBVersionSpecificInit();
73      }
74  
75      // ior/IdentifiableBase
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/EncapsInputStream.java
      * Line Number: 79
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
69                  .newBufferManagerRead(BufferManagerFactory.GROW, Message.CDR_ENC_VERSION,
70                          (org.jboss.com.sun.corba.se.spi.orb.ORB) orb));
71  
72          performORBVersionSpecificInit();
73      }
74  
75      // ior/IdentifiableBase
76      // ior/IIOPProfile
77      // corba/ORBSingleton
78      // iiop/ORB
79      public EncapsInputStream(org.omg.CORBA.ORB orb, byte[] data, int size)
80      {
81          this(orb, data, size, GIOPVersion.V1_2);
82      }
83  
84      // corba/AnyImpl
85      public EncapsInputStream(EncapsInputStream eis)
86      {
87          super(eis);
88  
89          wrapper = ORBUtilSystemException.get((ORB) (eis.orb()), CORBALogDomains.RPC_ENCODING);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/EncapsOutputStream.java
      * Line Number: 93
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
 83          this(orb, GIOPVersion.V1_2, isLittleEndian);
 84      }
 85  
 86      public EncapsOutputStream(ORB orb, GIOPVersion version, boolean isLittleEndian)
 87      {
 88          super(orb, version, Message.CDR_ENC_VERSION, isLittleEndian, BufferManagerFactory.newBufferManagerWrite(
 89                  BufferManagerFactory.GROW, Message.CDR_ENC_VERSION, orb), ORBConstants.STREAM_FORMAT_VERSION_1,
 90                  usePooledByteBuffers);
 91      }
 92  
 93      public org.omg.CORBA.portable.InputStream create_input_stream()
 94      {
 95          freeInternalCaches();
 96  
 97          return new EncapsInputStream(orb(), getByteBuffer(), getSize(), isLittleEndian(), getGIOPVersion());
 98      }
 99  
100      protected CodeSetConversion.CTBConverter createCharCTBConverter()
101      {
102          return CodeSetConversion.impl().getCTBConverter(OSFCodeSetRegistry.ISO_8859_1);
103      }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/EncapsOutputStream.java
      * Line Number: 32
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
22   * or visit www.oracle.com if you need additional information or have any
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.encoding;
27  
28  import org.jboss.com.sun.corba.se.impl.orbutil.ORBConstants;
29  import org.jboss.com.sun.corba.se.impl.protocol.giopmsgheaders.Message;
30  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
31  import org.jboss.com.sun.corba.se.spi.orb.ORB;
32  import org.omg.CORBA.CompletionStatus;
33  
34  /**
35   * Encapsulations are supposed to explicitly define their code sets and GIOP version. The original resolution to issue
36   * 2784 said that the defaults were UTF-8 and UTF-16, but that was not agreed upon.
37   * 
38   * These streams currently use CDR 1.2 with ISO8859-1 for char/string and UTF16 for wchar/wstring. If no byte order
39   * marker is available, the endianness of the encapsulation is used.
40   * 
41   * When more encapsulations arise that have their own special code sets defined, we can make all constructors take such
42   * parameters.
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/IDLJavaSerializationInputStream.java
      * Line Number: 948
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/IDLJavaSerializationInputStream.java
      * Line Number: 953
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/IDLJavaSerializationInputStream.java
      * Line Number: 958
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/IDLJavaSerializationInputStream.java
      * Line Number: 963
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/IDLJavaSerializationInputStream.java
      * Line Number: 968
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/IDLJavaSerializationInputStream.java
      * Line Number: 973
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/IDLJavaSerializationInputStream.java
      * Line Number: 1161
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/IDLJavaSerializationInputStream.java
      * Line Number: 168
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
158              }
159              return obj;
160          }
161      }
162  
163      public IDLJavaSerializationInputStream(byte encodingVersion)
164      {
165          super();
166      }
167  
168      public void init(org.omg.CORBA.ORB orb, ByteBuffer byteBuffer, int bufSize, boolean littleEndian,
169              BufferManagerRead bufferManager)
170      {
171          this.orb = (ORB) orb;
172          this.bufSize = bufSize;
173          this.bufferManager = bufferManager;
174          buffer = byteBuffer;
175          wrapper = ORBUtilSystemException.get((ORB) orb, CORBALogDomains.RPC_ENCODING);
176  
177          byte[] buf;
178          if (buffer.hasArray())
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/IDLJavaSerializationInputStream.java
      * Line Number: 48
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
38  import org.jboss.com.sun.corba.se.impl.protocol.giopmsgheaders.Message;
39  import org.jboss.com.sun.corba.se.impl.util.RepositoryId;
40  import org.jboss.com.sun.corba.se.spi.ior.IOR;
41  import org.jboss.com.sun.corba.se.spi.ior.IORFactories;
42  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
43  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
44  import org.jboss.com.sun.corba.se.spi.orb.ORB;
45  import org.jboss.com.sun.corba.se.spi.presentation.rmi.PresentationDefaults;
46  import org.jboss.com.sun.corba.se.spi.presentation.rmi.PresentationManager;
47  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
48  import org.omg.CORBA.Any;
49  import org.omg.CORBA.CompletionStatus;
50  import org.omg.CORBA.Principal;
51  import org.omg.CORBA.TypeCode;
52  import org.omg.CORBA.portable.IDLEntity;
53  
54  /**
55   * Implementation class that uses Java serialization for input streams. This assumes a GIOP version 1.2 message format.
56   * 
57   * This class uses a ByteArrayInputStream as the underlying buffer. The first 16 bytes are directly read out of the
58   * underlying buffer. This allows [GIOPHeader (12 bytes) + requestID (4 bytes)] to be read as bytes. Subsequent write
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/IDLJavaSerializationInputStream.java
      * Line Number: 49
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
39  import org.jboss.com.sun.corba.se.impl.util.RepositoryId;
40  import org.jboss.com.sun.corba.se.spi.ior.IOR;
41  import org.jboss.com.sun.corba.se.spi.ior.IORFactories;
42  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
43  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
44  import org.jboss.com.sun.corba.se.spi.orb.ORB;
45  import org.jboss.com.sun.corba.se.spi.presentation.rmi.PresentationDefaults;
46  import org.jboss.com.sun.corba.se.spi.presentation.rmi.PresentationManager;
47  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
48  import org.omg.CORBA.Any;
49  import org.omg.CORBA.CompletionStatus;
50  import org.omg.CORBA.Principal;
51  import org.omg.CORBA.TypeCode;
52  import org.omg.CORBA.portable.IDLEntity;
53  
54  /**
55   * Implementation class that uses Java serialization for input streams. This assumes a GIOP version 1.2 message format.
56   * 
57   * This class uses a ByteArrayInputStream as the underlying buffer. The first 16 bytes are directly read out of the
58   * underlying buffer. This allows [GIOPHeader (12 bytes) + requestID (4 bytes)] to be read as bytes. Subsequent write
59   * operations on this output stream object uses ObjectInputStream class to read into the buffer. This allows
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/IDLJavaSerializationInputStream.java
      * Line Number: 50
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
40  import org.jboss.com.sun.corba.se.spi.ior.IOR;
41  import org.jboss.com.sun.corba.se.spi.ior.IORFactories;
42  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
43  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
44  import org.jboss.com.sun.corba.se.spi.orb.ORB;
45  import org.jboss.com.sun.corba.se.spi.presentation.rmi.PresentationDefaults;
46  import org.jboss.com.sun.corba.se.spi.presentation.rmi.PresentationManager;
47  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
48  import org.omg.CORBA.Any;
49  import org.omg.CORBA.CompletionStatus;
50  import org.omg.CORBA.Principal;
51  import org.omg.CORBA.TypeCode;
52  import org.omg.CORBA.portable.IDLEntity;
53  
54  /**
55   * Implementation class that uses Java serialization for input streams. This assumes a GIOP version 1.2 message format.
56   * 
57   * This class uses a ByteArrayInputStream as the underlying buffer. The first 16 bytes are directly read out of the
58   * underlying buffer. This allows [GIOPHeader (12 bytes) + requestID (4 bytes)] to be read as bytes. Subsequent write
59   * operations on this output stream object uses ObjectInputStream class to read into the buffer. This allows
60   * unmarshaling complex types and graphs using the ObjectInputStream implementation.
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/IDLJavaSerializationInputStream.java
      * Line Number: 51
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
41  import org.jboss.com.sun.corba.se.spi.ior.IORFactories;
42  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
43  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
44  import org.jboss.com.sun.corba.se.spi.orb.ORB;
45  import org.jboss.com.sun.corba.se.spi.presentation.rmi.PresentationDefaults;
46  import org.jboss.com.sun.corba.se.spi.presentation.rmi.PresentationManager;
47  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
48  import org.omg.CORBA.Any;
49  import org.omg.CORBA.CompletionStatus;
50  import org.omg.CORBA.Principal;
51  import org.omg.CORBA.TypeCode;
52  import org.omg.CORBA.portable.IDLEntity;
53  
54  /**
55   * Implementation class that uses Java serialization for input streams. This assumes a GIOP version 1.2 message format.
56   * 
57   * This class uses a ByteArrayInputStream as the underlying buffer. The first 16 bytes are directly read out of the
58   * underlying buffer. This allows [GIOPHeader (12 bytes) + requestID (4 bytes)] to be read as bytes. Subsequent write
59   * operations on this output stream object uses ObjectInputStream class to read into the buffer. This allows
60   * unmarshaling complex types and graphs using the ObjectInputStream implementation.
61   * 
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/IDLJavaSerializationInputStream.java
      * Line Number: 52
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
42  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
43  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
44  import org.jboss.com.sun.corba.se.spi.orb.ORB;
45  import org.jboss.com.sun.corba.se.spi.presentation.rmi.PresentationDefaults;
46  import org.jboss.com.sun.corba.se.spi.presentation.rmi.PresentationManager;
47  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
48  import org.omg.CORBA.Any;
49  import org.omg.CORBA.CompletionStatus;
50  import org.omg.CORBA.Principal;
51  import org.omg.CORBA.TypeCode;
52  import org.omg.CORBA.portable.IDLEntity;
53  
54  /**
55   * Implementation class that uses Java serialization for input streams. This assumes a GIOP version 1.2 message format.
56   * 
57   * This class uses a ByteArrayInputStream as the underlying buffer. The first 16 bytes are directly read out of the
58   * underlying buffer. This allows [GIOPHeader (12 bytes) + requestID (4 bytes)] to be read as bytes. Subsequent write
59   * operations on this output stream object uses ObjectInputStream class to read into the buffer. This allows
60   * unmarshaling complex types and graphs using the ObjectInputStream implementation.
61   * 
62   * Note, this class assumes a GIOP 1.2 style header. Further, the first 12 bytes, that is, the GIOPHeader is read
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/IDLJavaSerializationInputStream.java
      * Line Number: 631
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
621      public void read_double_array(double[] value, int offset, int length)
622      {
623          for (int i = 0; i < length; i++)
624          {
625              value[i + offset] = read_double();
626          }
627      }
628  
629      // Complex types.
630  
631      public org.omg.CORBA.Object read_Object()
632      {
633          return read_Object(null);
634      }
635  
636      public TypeCode read_TypeCode()
637      {
638          TypeCodeImpl tc = new TypeCodeImpl(orb);
639          tc.read_value(parent);
640          return tc;
641      }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/IDLJavaSerializationInputStream.java
      * Line Number: 661
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
651          // REVISIT We could avoid this try-catch if we could peek the typecode
652          // kind off this stream and see if it is a tk_value.
653          // Looking at the code we know that for tk_value the Any.read_value()
654          // below ignores the tc argument anyway (except for the kind field).
655          // But still we would need to make sure that the whole typecode,
656          // including encapsulations, is read off.
657          try
658          {
659              tc.read_value(parent);
660          }
661          catch (org.omg.CORBA.MARSHAL ex)
662          {
663              if (tc.kind().value() != org.omg.CORBA.TCKind._tk_value)
664              {
665                  throw ex;
666              }
667              // We can be sure that the whole typecode encapsulation has been
668              // read off.
669              ex.printStackTrace();
670          }
671  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/IDLJavaSerializationInputStream.java
      * Line Number: 663
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
653          // Looking at the code we know that for tk_value the Any.read_value()
654          // below ignores the tc argument anyway (except for the kind field).
655          // But still we would need to make sure that the whole typecode,
656          // including encapsulations, is read off.
657          try
658          {
659              tc.read_value(parent);
660          }
661          catch (org.omg.CORBA.MARSHAL ex)
662          {
663              if (tc.kind().value() != org.omg.CORBA.TCKind._tk_value)
664              {
665                  throw ex;
666              }
667              // We can be sure that the whole typecode encapsulation has been
668              // read off.
669              ex.printStackTrace();
670          }
671  
672          // read off the value of the any.
673          any.read_value(parent, tc);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/IDLJavaSerializationInputStream.java
      * Line Number: 750
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
740              }
741              else
742              {
743                  buffer.append(Character.forDigit(secondDigit, 10));
744                  wroteFirstDigit = true;
745              }
746          }
747          return buffer;
748      }
749  
750      public org.omg.CORBA.Object read_Object(Class<?> clz)
751      {
752  
753          // In any case, we must first read the IOR.
754          IOR ior = IORFactories.makeIOR(parent);
755          if (ior.isNil())
756          {
757              return null;
758          }
759  
760          PresentationManager.StubFactoryFactory sff = ORB.getStubFactoryFactory();
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/IDLJavaSerializationInputStream.java
      * Line Number: 806
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
796          {
797              // clz is an interface class
798              boolean isIDL = IDLEntity.class.isAssignableFrom(clz);
799  
800              stubFactory = sff.createStubFactory(clz.getName(), isIDL, codeBase, clz, clz.getClassLoader());
801          }
802  
803          return CDRInputStream_1_0.internalIORToObject(ior, stubFactory, orb);
804      }
805  
806      public org.omg.CORBA.ORB orb()
807      {
808          return this.orb;
809      }
810  
811      // org.omg.CORBA_2_3.portable.InputStream
812  
813      public java.io.Serializable read_value()
814      {
815          if (!markOn && !(markedItemQ.isEmpty()))
816          { // dequeue
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/IDLJavaSerializationInputStream.java
      * Line Number: 843
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
833          {
834              throw wrapper.javaSerializationException(e, "read_value");
835          }
836      }
837  
838      public java.io.Serializable read_value(Class<?> clz)
839      {
840          return read_value();
841      }
842  
843      public java.io.Serializable read_value(org.omg.CORBA.portable.BoxedValueHelper factory)
844      {
845          return read_value();
846      }
847  
848      public java.io.Serializable read_value(String rep_id)
849      {
850          return read_value();
851      }
852  
853      public java.io.Serializable read_value(java.io.Serializable value)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/IDLJavaSerializationInputStream.java
      * Line Number: 905
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
895      public Object read_Abstract()
896      {
897          return read_abstract_interface();
898      }
899  
900      public java.io.Serializable read_Value()
901      {
902          return read_value();
903      }
904  
905      public void read_any_array(org.omg.CORBA.AnySeqHolder seq, int offset, int length)
906      {
907          read_any_array(seq.value, offset, length);
908      }
909  
910      private final void read_any_array(org.omg.CORBA.Any[] value, int offset, int length)
911      {
912          for (int i = 0; i < length; i++)
913          {
914              value[i + offset] = read_any();
915          }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/IDLJavaSerializationInputStream.java
      * Line Number: 910
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
900      public java.io.Serializable read_Value()
901      {
902          return read_value();
903      }
904  
905      public void read_any_array(org.omg.CORBA.AnySeqHolder seq, int offset, int length)
906      {
907          read_any_array(seq.value, offset, length);
908      }
909  
910      private final void read_any_array(org.omg.CORBA.Any[] value, int offset, int length)
911      {
912          for (int i = 0; i < length; i++)
913          {
914              value[i + offset] = read_any();
915          }
916      }
917  
918      public void read_boolean_array(org.omg.CORBA.BooleanSeqHolder seq, int offset, int length)
919      {
920          read_boolean_array(seq.value, offset, length);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/IDLJavaSerializationInputStream.java
      * Line Number: 918
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
908      }
909  
910      private final void read_any_array(org.omg.CORBA.Any[] value, int offset, int length)
911      {
912          for (int i = 0; i < length; i++)
913          {
914              value[i + offset] = read_any();
915          }
916      }
917  
918      public void read_boolean_array(org.omg.CORBA.BooleanSeqHolder seq, int offset, int length)
919      {
920          read_boolean_array(seq.value, offset, length);
921      }
922  
923      public void read_char_array(org.omg.CORBA.CharSeqHolder seq, int offset, int length)
924      {
925          read_char_array(seq.value, offset, length);
926      }
927  
928      public void read_wchar_array(org.omg.CORBA.WCharSeqHolder seq, int offset, int length)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/IDLJavaSerializationInputStream.java
      * Line Number: 923
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
913          {
914              value[i + offset] = read_any();
915          }
916      }
917  
918      public void read_boolean_array(org.omg.CORBA.BooleanSeqHolder seq, int offset, int length)
919      {
920          read_boolean_array(seq.value, offset, length);
921      }
922  
923      public void read_char_array(org.omg.CORBA.CharSeqHolder seq, int offset, int length)
924      {
925          read_char_array(seq.value, offset, length);
926      }
927  
928      public void read_wchar_array(org.omg.CORBA.WCharSeqHolder seq, int offset, int length)
929      {
930          read_wchar_array(seq.value, offset, length);
931      }
932  
933      public void read_octet_array(org.omg.CORBA.OctetSeqHolder seq, int offset, int length)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/IDLJavaSerializationInputStream.java
      * Line Number: 928
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
918      public void read_boolean_array(org.omg.CORBA.BooleanSeqHolder seq, int offset, int length)
919      {
920          read_boolean_array(seq.value, offset, length);
921      }
922  
923      public void read_char_array(org.omg.CORBA.CharSeqHolder seq, int offset, int length)
924      {
925          read_char_array(seq.value, offset, length);
926      }
927  
928      public void read_wchar_array(org.omg.CORBA.WCharSeqHolder seq, int offset, int length)
929      {
930          read_wchar_array(seq.value, offset, length);
931      }
932  
933      public void read_octet_array(org.omg.CORBA.OctetSeqHolder seq, int offset, int length)
934      {
935          read_octet_array(seq.value, offset, length);
936      }
937  
938      public void read_short_array(org.omg.CORBA.ShortSeqHolder seq, int offset, int length)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/IDLJavaSerializationInputStream.java
      * Line Number: 933
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
923      public void read_char_array(org.omg.CORBA.CharSeqHolder seq, int offset, int length)
924      {
925          read_char_array(seq.value, offset, length);
926      }
927  
928      public void read_wchar_array(org.omg.CORBA.WCharSeqHolder seq, int offset, int length)
929      {
930          read_wchar_array(seq.value, offset, length);
931      }
932  
933      public void read_octet_array(org.omg.CORBA.OctetSeqHolder seq, int offset, int length)
934      {
935          read_octet_array(seq.value, offset, length);
936      }
937  
938      public void read_short_array(org.omg.CORBA.ShortSeqHolder seq, int offset, int length)
939      {
940          read_short_array(seq.value, offset, length);
941      }
942  
943      public void read_ushort_array(org.omg.CORBA.UShortSeqHolder seq, int offset, int length)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/IDLJavaSerializationInputStream.java
      * Line Number: 938
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
928      public void read_wchar_array(org.omg.CORBA.WCharSeqHolder seq, int offset, int length)
929      {
930          read_wchar_array(seq.value, offset, length);
931      }
932  
933      public void read_octet_array(org.omg.CORBA.OctetSeqHolder seq, int offset, int length)
934      {
935          read_octet_array(seq.value, offset, length);
936      }
937  
938      public void read_short_array(org.omg.CORBA.ShortSeqHolder seq, int offset, int length)
939      {
940          read_short_array(seq.value, offset, length);
941      }
942  
943      public void read_ushort_array(org.omg.CORBA.UShortSeqHolder seq, int offset, int length)
944      {
945          read_ushort_array(seq.value, offset, length);
946      }
947  
948      public void read_long_array(org.omg.CORBA.LongSeqHolder seq, int offset, int length)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/IDLJavaSerializationInputStream.java
      * Line Number: 943
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
933      public void read_octet_array(org.omg.CORBA.OctetSeqHolder seq, int offset, int length)
934      {
935          read_octet_array(seq.value, offset, length);
936      }
937  
938      public void read_short_array(org.omg.CORBA.ShortSeqHolder seq, int offset, int length)
939      {
940          read_short_array(seq.value, offset, length);
941      }
942  
943      public void read_ushort_array(org.omg.CORBA.UShortSeqHolder seq, int offset, int length)
944      {
945          read_ushort_array(seq.value, offset, length);
946      }
947  
948      public void read_long_array(org.omg.CORBA.LongSeqHolder seq, int offset, int length)
949      {
950          read_long_array(seq.value, offset, length);
951      }
952  
953      public void read_ulong_array(org.omg.CORBA.ULongSeqHolder seq, int offset, int length)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/IDLJavaSerializationOutputStream.java
      * Line Number: 141
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
131              }
132              return obj;
133          }
134      }
135  
136      public IDLJavaSerializationOutputStream(byte encodingVersion)
137      {
138          super();
139      }
140  
141      public void init(org.omg.CORBA.ORB orb, boolean littleEndian, BufferManagerWrite bufferManager,
142              byte streamFormatVersion, boolean usePooledByteBuffers)
143      {
144          this.orb = (ORB) orb;
145          this.bufferManager = bufferManager;
146          wrapper = ORBUtilSystemException.get((ORB) orb, CORBALogDomains.RPC_ENCODING);
147          bos = new _ByteArrayOutputStream(ORBConstants.GIOP_DEFAULT_BUFFER_SIZE);
148      }
149  
150      // Called from read_octet or read_long or read_ulong method.
151      private void initObjectOutputStream()
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/IDLJavaSerializationOutputStream.java
      * Line Number: 44
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
34  import org.jboss.com.sun.corba.se.impl.orbutil.ORBConstants;
35  import org.jboss.com.sun.corba.se.impl.orbutil.ORBUtility;
36  import org.jboss.com.sun.corba.se.impl.protocol.giopmsgheaders.Message;
37  import org.jboss.com.sun.corba.se.impl.util.Utility;
38  import org.jboss.com.sun.corba.se.spi.ior.IOR;
39  import org.jboss.com.sun.corba.se.spi.ior.IORFactories;
40  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
41  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
42  import org.jboss.com.sun.corba.se.spi.orb.ORB;
43  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
44  import org.omg.CORBA.Any;
45  import org.omg.CORBA.CompletionStatus;
46  import org.omg.CORBA.Principal;
47  import org.omg.CORBA.TypeCode;
48  
49  /**
50   * Implementation class that uses Java serialization for output streams. This assumes a GIOP version 1.2 message format.
51   * 
52   * This class uses a ByteArrayOutputStream as the underlying buffer. The first 16 bytes are direct writes into the
53   * underlying buffer. This allows [GIOPHeader (12 bytes) + requestID (4 bytes)] to be written as bytes. Subsequent write
54   * operations on this output stream object uses ObjectOutputStream class to write into the buffer. This allows
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/IDLJavaSerializationOutputStream.java
      * Line Number: 45
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
35  import org.jboss.com.sun.corba.se.impl.orbutil.ORBUtility;
36  import org.jboss.com.sun.corba.se.impl.protocol.giopmsgheaders.Message;
37  import org.jboss.com.sun.corba.se.impl.util.Utility;
38  import org.jboss.com.sun.corba.se.spi.ior.IOR;
39  import org.jboss.com.sun.corba.se.spi.ior.IORFactories;
40  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
41  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
42  import org.jboss.com.sun.corba.se.spi.orb.ORB;
43  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
44  import org.omg.CORBA.Any;
45  import org.omg.CORBA.CompletionStatus;
46  import org.omg.CORBA.Principal;
47  import org.omg.CORBA.TypeCode;
48  
49  /**
50   * Implementation class that uses Java serialization for output streams. This assumes a GIOP version 1.2 message format.
51   * 
52   * This class uses a ByteArrayOutputStream as the underlying buffer. The first 16 bytes are direct writes into the
53   * underlying buffer. This allows [GIOPHeader (12 bytes) + requestID (4 bytes)] to be written as bytes. Subsequent write
54   * operations on this output stream object uses ObjectOutputStream class to write into the buffer. This allows
55   * marshaling complex types and graphs using the ObjectOutputStream implementation.
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/IDLJavaSerializationOutputStream.java
      * Line Number: 46
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
36  import org.jboss.com.sun.corba.se.impl.protocol.giopmsgheaders.Message;
37  import org.jboss.com.sun.corba.se.impl.util.Utility;
38  import org.jboss.com.sun.corba.se.spi.ior.IOR;
39  import org.jboss.com.sun.corba.se.spi.ior.IORFactories;
40  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
41  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
42  import org.jboss.com.sun.corba.se.spi.orb.ORB;
43  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
44  import org.omg.CORBA.Any;
45  import org.omg.CORBA.CompletionStatus;
46  import org.omg.CORBA.Principal;
47  import org.omg.CORBA.TypeCode;
48  
49  /**
50   * Implementation class that uses Java serialization for output streams. This assumes a GIOP version 1.2 message format.
51   * 
52   * This class uses a ByteArrayOutputStream as the underlying buffer. The first 16 bytes are direct writes into the
53   * underlying buffer. This allows [GIOPHeader (12 bytes) + requestID (4 bytes)] to be written as bytes. Subsequent write
54   * operations on this output stream object uses ObjectOutputStream class to write into the buffer. This allows
55   * marshaling complex types and graphs using the ObjectOutputStream implementation.
56   * 
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/IDLJavaSerializationOutputStream.java
      * Line Number: 47
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
37  import org.jboss.com.sun.corba.se.impl.util.Utility;
38  import org.jboss.com.sun.corba.se.spi.ior.IOR;
39  import org.jboss.com.sun.corba.se.spi.ior.IORFactories;
40  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
41  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
42  import org.jboss.com.sun.corba.se.spi.orb.ORB;
43  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
44  import org.omg.CORBA.Any;
45  import org.omg.CORBA.CompletionStatus;
46  import org.omg.CORBA.Principal;
47  import org.omg.CORBA.TypeCode;
48  
49  /**
50   * Implementation class that uses Java serialization for output streams. This assumes a GIOP version 1.2 message format.
51   * 
52   * This class uses a ByteArrayOutputStream as the underlying buffer. The first 16 bytes are direct writes into the
53   * underlying buffer. This allows [GIOPHeader (12 bytes) + requestID (4 bytes)] to be written as bytes. Subsequent write
54   * operations on this output stream object uses ObjectOutputStream class to write into the buffer. This allows
55   * marshaling complex types and graphs using the ObjectOutputStream implementation.
56   * 
57   * Note, this class assumes a GIOP 1.2 style header. Note, we expect that the first 16 bytes are written only using the
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/IDLJavaSerializationOutputStream.java
      * Line Number: 448
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
438      public final void write_double_array(double[] value, int offset, int length)
439      {
440          for (int i = 0; i < length; i++)
441          {
442              write_double(value[offset + i]);
443          }
444      }
445  
446      // Complex types (objects and graphs).
447  
448      public final void write_Object(org.omg.CORBA.Object value)
449      {
450          if (value == null)
451          {
452              IOR nullIOR = IORFactories.makeIOR(orb);
453              nullIOR.write(parent);
454              return;
455          }
456          // IDL to Java formal 01-06-06 1.21.4.2
457          if (value instanceof org.omg.CORBA.LocalObject)
458          {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/IDLJavaSerializationOutputStream.java
      * Line Number: 457
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
447  
448      public final void write_Object(org.omg.CORBA.Object value)
449      {
450          if (value == null)
451          {
452              IOR nullIOR = IORFactories.makeIOR(orb);
453              nullIOR.write(parent);
454              return;
455          }
456          // IDL to Java formal 01-06-06 1.21.4.2
457          if (value instanceof org.omg.CORBA.LocalObject)
458          {
459              throw wrapper.writeLocalObject(CompletionStatus.COMPLETED_MAYBE);
460          }
461          IOR ior = ORBUtility.connectAndGetIOR(orb, value);
462          ior.write(parent);
463          return;
464      }
465  
466      public final void write_TypeCode(TypeCode tc)
467      {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/IDLJavaSerializationOutputStream.java
      * Line Number: 569
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
559          {
560              doubleDigit |= 0xd;
561          }
562          else
563          {
564              doubleDigit |= 0xc;
565          }
566          this.write_octet(doubleDigit);
567      }
568  
569      public final org.omg.CORBA.ORB orb()
570      {
571          return this.orb;
572      }
573  
574      // org.omg.CORBA_2_3.portable.OutputStream
575  
576      public final void write_value(java.io.Serializable value)
577      {
578          write_value(value, (String) null);
579      }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/IDLJavaSerializationOutputStream.java
      * Line Number: 598
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
588          try
589          {
590              os.writeObject(value);
591          }
592          catch (Exception e)
593          {
594              throw wrapper.javaSerializationException(e, "write_value");
595          }
596      }
597  
598      public final void write_value(java.io.Serializable value, org.omg.CORBA.portable.BoxedValueHelper factory)
599      {
600          this.write_value(value, (String) null);
601      }
602  
603      public final void write_abstract_interface(Object obj)
604      {
605  
606          boolean isCorbaObject = false; // Assume value type.
607          org.omg.CORBA.Object theCorbaObject = null;
608  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/IDLJavaSerializationOutputStream.java
      * Line Number: 607
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
597  
598      public final void write_value(java.io.Serializable value, org.omg.CORBA.portable.BoxedValueHelper factory)
599      {
600          this.write_value(value, (String) null);
601      }
602  
603      public final void write_abstract_interface(Object obj)
604      {
605  
606          boolean isCorbaObject = false; // Assume value type.
607          org.omg.CORBA.Object theCorbaObject = null;
608  
609          // Is it a CORBA.Object?
610          if (obj != null && obj instanceof org.omg.CORBA.Object)
611          {
612              theCorbaObject = (org.omg.CORBA.Object) obj;
613              isCorbaObject = true;
614          }
615  
616          // Write the boolean flag.
617          this.write_boolean(isCorbaObject);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/IDLJavaSerializationOutputStream.java
      * Line Number: 610
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
600          this.write_value(value, (String) null);
601      }
602  
603      public final void write_abstract_interface(Object obj)
604      {
605  
606          boolean isCorbaObject = false; // Assume value type.
607          org.omg.CORBA.Object theCorbaObject = null;
608  
609          // Is it a CORBA.Object?
610          if (obj != null && obj instanceof org.omg.CORBA.Object)
611          {
612              theCorbaObject = (org.omg.CORBA.Object) obj;
613              isCorbaObject = true;
614          }
615  
616          // Write the boolean flag.
617          this.write_boolean(isCorbaObject);
618  
619          // Now write out the object.
620          if (isCorbaObject)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/IDLJavaSerializationOutputStream.java
      * Line Number: 612
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
602  
603      public final void write_abstract_interface(Object obj)
604      {
605  
606          boolean isCorbaObject = false; // Assume value type.
607          org.omg.CORBA.Object theCorbaObject = null;
608  
609          // Is it a CORBA.Object?
610          if (obj != null && obj instanceof org.omg.CORBA.Object)
611          {
612              theCorbaObject = (org.omg.CORBA.Object) obj;
613              isCorbaObject = true;
614          }
615  
616          // Write the boolean flag.
617          this.write_boolean(isCorbaObject);
618  
619          // Now write out the object.
620          if (isCorbaObject)
621          {
622              write_Object(theCorbaObject);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/IDLJavaSerializationOutputStream.java
      * Line Number: 699
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
689      public final void write_Abstract(Object value)
690      {
691          write_abstract_interface(value);
692      }
693  
694      public final void write_Value(java.io.Serializable value)
695      {
696          write_value(value);
697      }
698  
699      public final void write_any_array(org.omg.CORBA.Any[] value, int offset, int length)
700      {
701          for (int i = 0; i < length; i++)
702          {
703              write_any(value[offset + i]);
704          }
705      }
706  
707      // org.omg.CORBA.portable.ValueBase
708  
709      public final String[] _truncatable_ids()
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/IDLJavaSerializationOutputStream.java
      * Line Number: 844
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
834          }
835          while (stringBuffer.length() < digits)
836          {
837              stringBuffer.insert(0, '0');
838          }
839  
840          // This string contains no sign or dot
841          this.write_fixed(stringBuffer.toString(), bigDecimal.signum());
842      }
843  
844      public final void writeOctetSequenceTo(org.omg.CORBA.portable.OutputStream s)
845      {
846          byte[] buf = this.toByteArray(); // new copy.
847          s.write_long(buf.length);
848          s.write_octet_array(buf, 0, buf.length);
849      }
850  
851      public final GIOPVersion getGIOPVersion()
852      {
853          return GIOPVersion.V1_2;
854      }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/TypeCodeInputStream.java
      * Line Number: 103
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
 93              // The enclosed stream has to consider if the enclosing stream had to read the enclosed stream completely
 94              // when creating it. This is why the size of the enclosed stream needs to be substracted.
 95              int topPos = ((TypeCodeReader) enclosure).getTopLevelPosition();
 96              // Substract getBufferLength from the parents pos because it read this stream from its own when creating it
 97              int pos = topPos - getBufferLength() + getPosition();
 98              return pos;
 99          }
100          return getPosition();
101      }
102  
103      public static TypeCodeInputStream readEncapsulation(InputStream is, org.omg.CORBA.ORB _orb)
104      {
105          // _REVISIT_ Would be nice if we didn't have to copy the buffer!
106          TypeCodeInputStream encap;
107  
108          int encapLength = is.read_long();
109  
110          // read off part of the buffer corresponding to the encapsulation
111          byte[] encapBuffer = new byte[encapLength];
112          is.read_octet_array(encapBuffer, 0, encapBuffer.length);
113  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/TypeCodeInputStream.java
      * Line Number: 35
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
25  
26  package org.jboss.com.sun.corba.se.impl.encoding;
27  
28  import java.nio.ByteBuffer;
29  import java.util.HashMap;
30  import java.util.Iterator;
31  import java.util.Map;
32  
33  import org.jboss.com.sun.corba.se.impl.corba.TypeCodeImpl;
34  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
35  import org.omg.CORBA_2_3.portable.InputStream;
36  
37  public class TypeCodeInputStream extends EncapsInputStream implements TypeCodeReader
38  {
39      private Map<Integer, TypeCodeImpl> typeMap = null;
40  
41      private InputStream enclosure = null;
42  
43      public TypeCodeInputStream(org.omg.CORBA.ORB orb, byte[] data, int size)
44      {
45          super(orb, data, size);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/TypeCodeInputStream.java
      * Line Number: 43
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
33  import org.jboss.com.sun.corba.se.impl.corba.TypeCodeImpl;
34  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
35  import org.omg.CORBA_2_3.portable.InputStream;
36  
37  public class TypeCodeInputStream extends EncapsInputStream implements TypeCodeReader
38  {
39      private Map<Integer, TypeCodeImpl> typeMap = null;
40  
41      private InputStream enclosure = null;
42  
43      public TypeCodeInputStream(org.omg.CORBA.ORB orb, byte[] data, int size)
44      {
45          super(orb, data, size);
46      }
47  
48      public TypeCodeInputStream(org.omg.CORBA.ORB orb, byte[] data, int size, boolean littleEndian, GIOPVersion version)
49      {
50          super(orb, data, size, littleEndian, version);
51      }
52  
53      public TypeCodeInputStream(org.omg.CORBA.ORB orb, ByteBuffer byteBuffer, int size, boolean littleEndian,
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/TypeCodeInputStream.java
      * Line Number: 48
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
38  {
39      private Map<Integer, TypeCodeImpl> typeMap = null;
40  
41      private InputStream enclosure = null;
42  
43      public TypeCodeInputStream(org.omg.CORBA.ORB orb, byte[] data, int size)
44      {
45          super(orb, data, size);
46      }
47  
48      public TypeCodeInputStream(org.omg.CORBA.ORB orb, byte[] data, int size, boolean littleEndian, GIOPVersion version)
49      {
50          super(orb, data, size, littleEndian, version);
51      }
52  
53      public TypeCodeInputStream(org.omg.CORBA.ORB orb, ByteBuffer byteBuffer, int size, boolean littleEndian,
54              GIOPVersion version)
55      {
56          super(orb, byteBuffer, size, littleEndian, version);
57      }
58  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/TypeCodeInputStream.java
      * Line Number: 53
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
43      public TypeCodeInputStream(org.omg.CORBA.ORB orb, byte[] data, int size)
44      {
45          super(orb, data, size);
46      }
47  
48      public TypeCodeInputStream(org.omg.CORBA.ORB orb, byte[] data, int size, boolean littleEndian, GIOPVersion version)
49      {
50          super(orb, data, size, littleEndian, version);
51      }
52  
53      public TypeCodeInputStream(org.omg.CORBA.ORB orb, ByteBuffer byteBuffer, int size, boolean littleEndian,
54              GIOPVersion version)
55      {
56          super(orb, byteBuffer, size, littleEndian, version);
57      }
58  
59      public void addTypeCodeAtPosition(TypeCodeImpl tc, int position)
60      {
61          if (typeMap == null)
62          {
63              typeMap = new HashMap<Integer, TypeCodeImpl>(16);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/TypeCodeOutputStream.java
      * Line Number: 105
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
 95          typeMap.put(id, position);
 96      }
 97  
 98      public int getPositionForID(String id)
 99      {
100          if (typeMap == null)
101              throw wrapper.refTypeIndirType(CompletionStatus.COMPLETED_NO);
102          return typeMap.get(id);
103      }
104  
105      public void writeRawBuffer(org.omg.CORBA.portable.OutputStream s, int firstLong)
106      {
107          // Writes this streams buffer to the given OutputStream without byte order flag and length as is the case for
108          // encapsulations.
109  
110          // Make sure to align s to 4 byte boundaries. Unfortunately we can't do just this:
111          // s.alignAndReserve(4, 4); So we have to take the first four bytes given in firstLong and write them with a
112          // call to write_long which will trigger the alignment. Then write the rest of the byte array.
113  
114          s.write_long(firstLong);
115          ByteBuffer byteBuffer = getByteBuffer();
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/TypeCodeOutputStream.java
      * Line Number: 131
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
121          {
122              // get bytes from DirectByteBuffer NOTE: Microbenchmarks are showing it is faster to do a loop of
123              // ByteBuffer.get(int) than it is to do a bulk ByteBuffer.get(byte[], offset, length)
124              byte[] buf = new byte[byteBuffer.limit()];
125              for (int i = 0; i < buf.length; i++)
126                  buf[i] = byteBuffer.get(i);
127              s.write_octet_array(buf, 4, getIndex() - 4);
128          }
129      }
130  
131      public TypeCodeOutputStream createEncapsulation(org.omg.CORBA.ORB _orb)
132      {
133          TypeCodeOutputStream encap = new TypeCodeOutputStream((ORB) _orb, isLittleEndian());
134          encap.setEnclosingOutputStream(this);
135          encap.makeEncapsulation();
136          // if (TypeCodeImpl.debug) System.out.println("Created TypeCodeOutputStream " + encap + " with parent " + this);
137          return encap;
138      }
139  
140      protected void makeEncapsulation()
141      {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/TypeCodeOutputStream.java
      * Line Number: 34
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.encoding;
27  
28  import java.nio.ByteBuffer;
29  import java.util.HashMap;
30  import java.util.Iterator;
31  import java.util.Map;
32  
33  import org.jboss.com.sun.corba.se.spi.orb.ORB;
34  import org.omg.CORBA.CompletionStatus;
35  import org.omg.CORBA_2_3.portable.OutputStream;
36  
37  public final class TypeCodeOutputStream extends EncapsOutputStream
38  {
39      private OutputStream enclosure = null;
40  
41      private Map<String, Integer> typeMap = null;
42  
43      private boolean isEncapsulation = false;
44  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/TypeCodeOutputStream.java
      * Line Number: 35
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
25  
26  package org.jboss.com.sun.corba.se.impl.encoding;
27  
28  import java.nio.ByteBuffer;
29  import java.util.HashMap;
30  import java.util.Iterator;
31  import java.util.Map;
32  
33  import org.jboss.com.sun.corba.se.spi.orb.ORB;
34  import org.omg.CORBA.CompletionStatus;
35  import org.omg.CORBA_2_3.portable.OutputStream;
36  
37  public final class TypeCodeOutputStream extends EncapsOutputStream
38  {
39      private OutputStream enclosure = null;
40  
41      private Map<String, Integer> typeMap = null;
42  
43      private boolean isEncapsulation = false;
44  
45      public TypeCodeOutputStream(ORB orb)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/TypeCodeOutputStream.java
      * Line Number: 55
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
45      public TypeCodeOutputStream(ORB orb)
46      {
47          super(orb, false);
48      }
49  
50      public TypeCodeOutputStream(ORB orb, boolean littleEndian)
51      {
52          super(orb, littleEndian);
53      }
54  
55      public org.omg.CORBA.portable.InputStream create_input_stream()
56      {
57          // return new TypeCodeInputStream((ORB)orb(), getByteBuffer(), getIndex(), isLittleEndian());
58          TypeCodeInputStream tcis = new TypeCodeInputStream(orb(), getByteBuffer(), getIndex(), isLittleEndian(),
59                  getGIOPVersion());
60          return tcis;
61      }
62  
63      public void setEnclosingOutputStream(OutputStream enclosure)
64      {
65          this.enclosure = enclosure;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/WrapperInputStream.java
      * Line Number: 243
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
233      public void read_float_array(float[] value, int offset, int length)
234      {
235          stream.read_float_array(value, offset, length);
236      }
237  
238      public void read_double_array(double[] value, int offset, int length)
239      {
240          stream.read_double_array(value, offset, length);
241      }
242  
243      public org.omg.CORBA.Object read_Object()
244      {
245          return stream.read_Object();
246      }
247  
248      public java.io.Serializable read_value()
249      {
250          return stream.read_value();
251      }
252  
253      public TypeCode read_TypeCode()
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/WrapperInputStream.java
      * Line Number: 273
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
263      public Principal read_Principal()
264      {
265          return stream.read_Principal();
266      }
267  
268      public java.math.BigDecimal read_fixed()
269      {
270          return stream.read_fixed();
271      }
272  
273      public org.omg.CORBA.Context read_Context()
274      {
275          return stream.read_Context();
276      }
277  
278      public org.omg.CORBA.ORB orb()
279      {
280          return stream.orb();
281      }
282  
283      public void addTypeCodeAtPosition(TypeCodeImpl tc, int position)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/WrapperInputStream.java
      * Line Number: 278
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
268      public java.math.BigDecimal read_fixed()
269      {
270          return stream.read_fixed();
271      }
272  
273      public org.omg.CORBA.Context read_Context()
274      {
275          return stream.read_Context();
276      }
277  
278      public org.omg.CORBA.ORB orb()
279      {
280          return stream.orb();
281      }
282  
283      public void addTypeCodeAtPosition(TypeCodeImpl tc, int position)
284      {
285          if (typeMap == null)
286          {
287              // if (TypeCodeImpl.debug) System.out.println("Creating typeMap");
288              typeMap = new HashMap<Integer, TypeCodeImpl>(16);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/WrapperInputStream.java
      * Line Number: 37
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
27  
28  import java.io.IOException;
29  import java.util.ArrayList;
30  import java.util.Collections;
31  import java.util.HashMap;
32  import java.util.Iterator;
33  import java.util.List;
34  import java.util.Map;
35  
36  import org.jboss.com.sun.corba.se.impl.corba.TypeCodeImpl;
37  import org.omg.CORBA.Any;
38  import org.omg.CORBA.Principal;
39  import org.omg.CORBA.TypeCode;
40  import org.omg.CORBA_2_3.portable.InputStream;
41  
42  @SuppressWarnings("deprecation")
43  public class WrapperInputStream extends org.omg.CORBA_2_3.portable.InputStream implements TypeCodeReader
44  {
45      private CDRInputStream stream;
46  
47      private Map<Integer, TypeCodeImpl> typeMap = null;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/WrapperInputStream.java
      * Line Number: 38
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
28  import java.io.IOException;
29  import java.util.ArrayList;
30  import java.util.Collections;
31  import java.util.HashMap;
32  import java.util.Iterator;
33  import java.util.List;
34  import java.util.Map;
35  
36  import org.jboss.com.sun.corba.se.impl.corba.TypeCodeImpl;
37  import org.omg.CORBA.Any;
38  import org.omg.CORBA.Principal;
39  import org.omg.CORBA.TypeCode;
40  import org.omg.CORBA_2_3.portable.InputStream;
41  
42  @SuppressWarnings("deprecation")
43  public class WrapperInputStream extends org.omg.CORBA_2_3.portable.InputStream implements TypeCodeReader
44  {
45      private CDRInputStream stream;
46  
47      private Map<Integer, TypeCodeImpl> typeMap = null;
48  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/WrapperInputStream.java
      * Line Number: 39
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
29  import java.util.ArrayList;
30  import java.util.Collections;
31  import java.util.HashMap;
32  import java.util.Iterator;
33  import java.util.List;
34  import java.util.Map;
35  
36  import org.jboss.com.sun.corba.se.impl.corba.TypeCodeImpl;
37  import org.omg.CORBA.Any;
38  import org.omg.CORBA.Principal;
39  import org.omg.CORBA.TypeCode;
40  import org.omg.CORBA_2_3.portable.InputStream;
41  
42  @SuppressWarnings("deprecation")
43  public class WrapperInputStream extends org.omg.CORBA_2_3.portable.InputStream implements TypeCodeReader
44  {
45      private CDRInputStream stream;
46  
47      private Map<Integer, TypeCodeImpl> typeMap = null;
48  
49      private int startPos = 0;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/WrapperInputStream.java
      * Line Number: 40
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
30  import java.util.Collections;
31  import java.util.HashMap;
32  import java.util.Iterator;
33  import java.util.List;
34  import java.util.Map;
35  
36  import org.jboss.com.sun.corba.se.impl.corba.TypeCodeImpl;
37  import org.omg.CORBA.Any;
38  import org.omg.CORBA.Principal;
39  import org.omg.CORBA.TypeCode;
40  import org.omg.CORBA_2_3.portable.InputStream;
41  
42  @SuppressWarnings("deprecation")
43  public class WrapperInputStream extends org.omg.CORBA_2_3.portable.InputStream implements TypeCodeReader
44  {
45      private CDRInputStream stream;
46  
47      private Map<Integer, TypeCodeImpl> typeMap = null;
48  
49      private int startPos = 0;
50  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/encoding/WrapperInputStream.java
      * Line Number: 43
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
33  import java.util.List;
34  import java.util.Map;
35  
36  import org.jboss.com.sun.corba.se.impl.corba.TypeCodeImpl;
37  import org.omg.CORBA.Any;
38  import org.omg.CORBA.Principal;
39  import org.omg.CORBA.TypeCode;
40  import org.omg.CORBA_2_3.portable.InputStream;
41  
42  @SuppressWarnings("deprecation")
43  public class WrapperInputStream extends org.omg.CORBA_2_3.portable.InputStream implements TypeCodeReader
44  {
45      private CDRInputStream stream;
46  
47      private Map<Integer, TypeCodeImpl> typeMap = null;
48  
49      private int startPos = 0;
50  
51      public WrapperInputStream(CDRInputStream s)
52      {
53          super();
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/FVDCodeBaseImpl.java
      * Line Number: 44
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
34  import java.util.Hashtable;
35  import java.util.Stack;
36  
37  import javax.rmi.CORBA.Util;
38  import javax.rmi.CORBA.ValueHandler;
39  
40  import org.jboss.com.sun.corba.se.impl.logging.OMGSystemException;
41  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
42  import org.jboss.com.sun.org.omg.CORBA.ValueDefPackage.FullValueDescription;
43  import org.jboss.com.sun.org.omg.SendingContext._CodeBaseImplBase;
44  import org.omg.CORBA.CompletionStatus;
45  import org.omg.CORBA.ORB;
46  
47  /**
48   * This class acts as the remote interface to receivers wishing to retrieve the information of a remote Class.
49   */
50  public class FVDCodeBaseImpl extends _CodeBaseImplBase
51  {
52      private static final long serialVersionUID = 5813777342105483423L;
53  
54      // Contains rep. ids as keys to FullValueDescriptions
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/FVDCodeBaseImpl.java
      * Line Number: 45
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
35  import java.util.Stack;
36  
37  import javax.rmi.CORBA.Util;
38  import javax.rmi.CORBA.ValueHandler;
39  
40  import org.jboss.com.sun.corba.se.impl.logging.OMGSystemException;
41  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
42  import org.jboss.com.sun.org.omg.CORBA.ValueDefPackage.FullValueDescription;
43  import org.jboss.com.sun.org.omg.SendingContext._CodeBaseImplBase;
44  import org.omg.CORBA.CompletionStatus;
45  import org.omg.CORBA.ORB;
46  
47  /**
48   * This class acts as the remote interface to receivers wishing to retrieve the information of a remote Class.
49   */
50  public class FVDCodeBaseImpl extends _CodeBaseImplBase
51  {
52      private static final long serialVersionUID = 5813777342105483423L;
53  
54      // Contains rep. ids as keys to FullValueDescriptions
55      private static Hashtable<String, FullValueDescription> fvds = new Hashtable<String, FullValueDescription>();
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/IIOPInputStream.java
      * Line Number: 102
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
 92  
 93      private static UtilSystemException utilWrapper = UtilSystemException.get(CORBALogDomains.RPC_ENCODING);
 94  
 95      // Necessary to pass the appropriate fields into the defaultReadObjectDelegate method (which takes no parameters
 96      // since it's called from java.io.ObjectInpuStream defaultReadObject() which we can't change).
 97      //
 98      // This is only used in the case where the fields had to be obtained remotely because of a serializable version
 99      // difference. Set in inputObjectUsingFVD. Part of serialization evolution fixes for Ladybird, bug 4365188.
100      private ValueMember defaultReadObjectFVDMembers[] = null;
101  
102      private org.omg.CORBA_2_3.portable.InputStream orbStream;
103  
104      private CodeBase cbSender;
105  
106      private ValueHandlerImpl vhandler; // d4365188
107  
108      private Object currentObject = null;
109  
110      private ObjectStreamClass currentClassDesc = null;
111  
112      private Class<?> currentClass = null;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/IIOPInputStream.java
      * Line Number: 67
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
11   * This code is distributed in the hope that it will be useful, but WITHOUT
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/IIOPInputStream.java
      * Line Number: 1934
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
1924               * This case should never happen. If the field types are not the same, InvalidClassException is raised when
1925               * matching the local class to the serialized ObjectStreamClass.
1926               */
1927              ClassCastException cce = new ClassCastException("Assigning instance of class " + field.getType().getName()
1928                      + " to field " + currentClassDesc.getName() + '#' + field.getField().getName());
1929              cce.initCause(e);
1930              throw cce;
1931          }
1932      }
1933  
1934      private Object inputObjectField(org.omg.CORBA.ValueMember field,
1935              org.jboss.com.sun.org.omg.SendingContext.CodeBase sender) throws IndirectionException,
1936              ClassNotFoundException, IOException, StreamCorruptedException
1937      {
1938  
1939          Object objectValue = null;
1940          Class<?> type = null;
1941          String id = field.id;
1942  
1943          try
1944          {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/IIOPInputStream.java
      * Line Number: 2073
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
2063          {
2064              boolean loadStubClass = false;
2065  
2066              if (java.rmi.Remote.class.isAssignableFrom(fieldType))
2067              {
2068  
2069                  // RMI Object reference...
2070                  callType = ValueHandlerImpl.kRemoteType;
2071  
2072              }
2073              else if (org.omg.CORBA.Object.class.isAssignableFrom(fieldType))
2074              {
2075  
2076                  // IDL Object reference...
2077                  callType = ValueHandlerImpl.kRemoteType;
2078                  loadStubClass = true;
2079  
2080              }
2081              else if (vhandler.isAbstractBase(fieldType))
2082              {
2083                  // IDL Abstract Object reference...
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/IIOPInputStream.java
      * Line Number: 274
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
264  
265      /**
266       * Dummy constructor; passes upper stream a dummy stream;
267       **/
268      public IIOPInputStream() throws java.io.IOException
269      {
270          super();
271          resetStream();
272      }
273  
274      public final void setOrbStream(org.omg.CORBA_2_3.portable.InputStream os)
275      {
276          orbStream = os;
277      }
278  
279      public final org.omg.CORBA_2_3.portable.InputStream getOrbStream()
280      {
281          return orbStream;
282      }
283  
284      // added setSender and getSender
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/IIOPInputStream.java
      * Line Number: 279
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
269      {
270          super();
271          resetStream();
272      }
273  
274      public final void setOrbStream(org.omg.CORBA_2_3.portable.InputStream os)
275      {
276          orbStream = os;
277      }
278  
279      public final org.omg.CORBA_2_3.portable.InputStream getOrbStream()
280      {
281          return orbStream;
282      }
283  
284      // added setSender and getSender
285      public final void setSender(CodeBase cb)
286      {
287          cbSender = cb;
288      }
289  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/IIOPInputStream.java
      * Line Number: 64
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
54  import javax.rmi.CORBA.Util;
55  import javax.rmi.CORBA.ValueHandler;
56  
57  import org.jboss.com.sun.corba.se.impl.logging.OMGSystemException;
58  import org.jboss.com.sun.corba.se.impl.logging.UtilSystemException;
59  import org.jboss.com.sun.corba.se.impl.util.Utility;
60  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
61  import org.jboss.com.sun.org.omg.CORBA.ValueDefPackage.FullValueDescription;
62  import org.jboss.com.sun.org.omg.SendingContext.CodeBase;
63  import org.jboss.sun.corba.Bridge;
64  import org.omg.CORBA.CompletionStatus;
65  import org.omg.CORBA.MARSHAL;
66  import org.omg.CORBA.ORB;
67  import org.omg.CORBA.SystemException;
68  import org.omg.CORBA.TCKind;
69  import org.omg.CORBA.TypeCode;
70  import org.omg.CORBA.ValueMember;
71  import org.omg.CORBA.portable.IndirectionException;
72  import org.omg.CORBA.portable.ValueInputStream;
73  
74  /**
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/IIOPInputStream.java
      * Line Number: 65
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
55  import javax.rmi.CORBA.ValueHandler;
56  
57  import org.jboss.com.sun.corba.se.impl.logging.OMGSystemException;
58  import org.jboss.com.sun.corba.se.impl.logging.UtilSystemException;
59  import org.jboss.com.sun.corba.se.impl.util.Utility;
60  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
61  import org.jboss.com.sun.org.omg.CORBA.ValueDefPackage.FullValueDescription;
62  import org.jboss.com.sun.org.omg.SendingContext.CodeBase;
63  import org.jboss.sun.corba.Bridge;
64  import org.omg.CORBA.CompletionStatus;
65  import org.omg.CORBA.MARSHAL;
66  import org.omg.CORBA.ORB;
67  import org.omg.CORBA.SystemException;
68  import org.omg.CORBA.TCKind;
69  import org.omg.CORBA.TypeCode;
70  import org.omg.CORBA.ValueMember;
71  import org.omg.CORBA.portable.IndirectionException;
72  import org.omg.CORBA.portable.ValueInputStream;
73  
74  /**
75   * IIOPInputStream is used by the ValueHandlerImpl to handle Java serialization input semantics.
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/IIOPInputStream.java
      * Line Number: 66
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
56  
57  import org.jboss.com.sun.corba.se.impl.logging.OMGSystemException;
58  import org.jboss.com.sun.corba.se.impl.logging.UtilSystemException;
59  import org.jboss.com.sun.corba.se.impl.util.Utility;
60  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
61  import org.jboss.com.sun.org.omg.CORBA.ValueDefPackage.FullValueDescription;
62  import org.jboss.com.sun.org.omg.SendingContext.CodeBase;
63  import org.jboss.sun.corba.Bridge;
64  import org.omg.CORBA.CompletionStatus;
65  import org.omg.CORBA.MARSHAL;
66  import org.omg.CORBA.ORB;
67  import org.omg.CORBA.SystemException;
68  import org.omg.CORBA.TCKind;
69  import org.omg.CORBA.TypeCode;
70  import org.omg.CORBA.ValueMember;
71  import org.omg.CORBA.portable.IndirectionException;
72  import org.omg.CORBA.portable.ValueInputStream;
73  
74  /**
75   * IIOPInputStream is used by the ValueHandlerImpl to handle Java serialization input semantics.
76   * 
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/IIOPInputStream.java
      * Line Number: 68
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
58  import org.jboss.com.sun.corba.se.impl.logging.UtilSystemException;
59  import org.jboss.com.sun.corba.se.impl.util.Utility;
60  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
61  import org.jboss.com.sun.org.omg.CORBA.ValueDefPackage.FullValueDescription;
62  import org.jboss.com.sun.org.omg.SendingContext.CodeBase;
63  import org.jboss.sun.corba.Bridge;
64  import org.omg.CORBA.CompletionStatus;
65  import org.omg.CORBA.MARSHAL;
66  import org.omg.CORBA.ORB;
67  import org.omg.CORBA.SystemException;
68  import org.omg.CORBA.TCKind;
69  import org.omg.CORBA.TypeCode;
70  import org.omg.CORBA.ValueMember;
71  import org.omg.CORBA.portable.IndirectionException;
72  import org.omg.CORBA.portable.ValueInputStream;
73  
74  /**
75   * IIOPInputStream is used by the ValueHandlerImpl to handle Java serialization input semantics.
76   * 
77   * @author Stephen Lewallen
78   * @since JDK1.1.6
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/IIOPInputStream.java
      * Line Number: 69
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
59  import org.jboss.com.sun.corba.se.impl.util.Utility;
60  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
61  import org.jboss.com.sun.org.omg.CORBA.ValueDefPackage.FullValueDescription;
62  import org.jboss.com.sun.org.omg.SendingContext.CodeBase;
63  import org.jboss.sun.corba.Bridge;
64  import org.omg.CORBA.CompletionStatus;
65  import org.omg.CORBA.MARSHAL;
66  import org.omg.CORBA.ORB;
67  import org.omg.CORBA.SystemException;
68  import org.omg.CORBA.TCKind;
69  import org.omg.CORBA.TypeCode;
70  import org.omg.CORBA.ValueMember;
71  import org.omg.CORBA.portable.IndirectionException;
72  import org.omg.CORBA.portable.ValueInputStream;
73  
74  /**
75   * IIOPInputStream is used by the ValueHandlerImpl to handle Java serialization input semantics.
76   * 
77   * @author Stephen Lewallen
78   * @since JDK1.1.6
79   */
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/IIOPInputStream.java
      * Line Number: 70
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
60  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
61  import org.jboss.com.sun.org.omg.CORBA.ValueDefPackage.FullValueDescription;
62  import org.jboss.com.sun.org.omg.SendingContext.CodeBase;
63  import org.jboss.sun.corba.Bridge;
64  import org.omg.CORBA.CompletionStatus;
65  import org.omg.CORBA.MARSHAL;
66  import org.omg.CORBA.ORB;
67  import org.omg.CORBA.SystemException;
68  import org.omg.CORBA.TCKind;
69  import org.omg.CORBA.TypeCode;
70  import org.omg.CORBA.ValueMember;
71  import org.omg.CORBA.portable.IndirectionException;
72  import org.omg.CORBA.portable.ValueInputStream;
73  
74  /**
75   * IIOPInputStream is used by the ValueHandlerImpl to handle Java serialization input semantics.
76   * 
77   * @author Stephen Lewallen
78   * @since JDK1.1.6
79   */
80  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/IIOPInputStream.java
      * Line Number: 71
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
61  import org.jboss.com.sun.org.omg.CORBA.ValueDefPackage.FullValueDescription;
62  import org.jboss.com.sun.org.omg.SendingContext.CodeBase;
63  import org.jboss.sun.corba.Bridge;
64  import org.omg.CORBA.CompletionStatus;
65  import org.omg.CORBA.MARSHAL;
66  import org.omg.CORBA.ORB;
67  import org.omg.CORBA.SystemException;
68  import org.omg.CORBA.TCKind;
69  import org.omg.CORBA.TypeCode;
70  import org.omg.CORBA.ValueMember;
71  import org.omg.CORBA.portable.IndirectionException;
72  import org.omg.CORBA.portable.ValueInputStream;
73  
74  /**
75   * IIOPInputStream is used by the ValueHandlerImpl to handle Java serialization input semantics.
76   * 
77   * @author Stephen Lewallen
78   * @since JDK1.1.6
79   */
80  
81  public class IIOPInputStream extends org.jboss.com.sun.corba.se.impl.io.InputStreamHook
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/IIOPInputStream.java
      * Line Number: 72
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
62  import org.jboss.com.sun.org.omg.SendingContext.CodeBase;
63  import org.jboss.sun.corba.Bridge;
64  import org.omg.CORBA.CompletionStatus;
65  import org.omg.CORBA.MARSHAL;
66  import org.omg.CORBA.ORB;
67  import org.omg.CORBA.SystemException;
68  import org.omg.CORBA.TCKind;
69  import org.omg.CORBA.TypeCode;
70  import org.omg.CORBA.ValueMember;
71  import org.omg.CORBA.portable.IndirectionException;
72  import org.omg.CORBA.portable.ValueInputStream;
73  
74  /**
75   * IIOPInputStream is used by the ValueHandlerImpl to handle Java serialization input semantics.
76   * 
77   * @author Stephen Lewallen
78   * @since JDK1.1.6
79   */
80  
81  public class IIOPInputStream extends org.jboss.com.sun.corba.se.impl.io.InputStreamHook
82  {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/IIOPInputStream.java
      * Line Number: 958
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
948              IOException exc = new IOException(e.getMessage());
949              exc.initCause(e);
950              throw exc;
951          }
952      }
953  
954      /**
955       * Helper method for correcting the Kestrel bug 4367783 (dealing with larger than 8-bit chars). The old behavior is
956       * preserved in orbutil.IIOPInputStream_1_3 in order to interoperate with our legacy ORBs.
957       */
958      protected String internalReadUTF(org.omg.CORBA.portable.InputStream stream)
959      {
960          return stream.read_wstring();
961      }
962  
963      public final String readUTF() throws IOException
964      {
965          try
966          {
967              readObjectState.readData(this);
968  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/IIOPOutputStream.java
      * Line Number: 99
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
 89      }
 90  
 91      // If using RMI-IIOP stream format version 2, this tells the ORB stream (which must be a ValueOutputStream) to begin
 92      // a new valuetype to contain the optional data of the writeObject method.
 93      protected void beginOptionalCustomData()
 94      {
 95  
 96          if (streamFormatVersion == 2)
 97          {
 98  
 99              org.omg.CORBA.portable.ValueOutputStream vout = (org.omg.CORBA.portable.ValueOutputStream) orbStream;
100  
101              vout.start_value(currentClassDesc.getRMIIIOPOptionalDataRepId());
102          }
103      }
104  
105      public final void setOrbStream(org.omg.CORBA_2_3.portable.OutputStream os)
106      {
107          orbStream = os;
108      }
109  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/IIOPOutputStream.java
      * Line Number: 105
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
 95  
 96          if (streamFormatVersion == 2)
 97          {
 98  
 99              org.omg.CORBA.portable.ValueOutputStream vout = (org.omg.CORBA.portable.ValueOutputStream) orbStream;
100  
101              vout.start_value(currentClassDesc.getRMIIIOPOptionalDataRepId());
102          }
103      }
104  
105      public final void setOrbStream(org.omg.CORBA_2_3.portable.OutputStream os)
106      {
107          orbStream = os;
108      }
109  
110      public final org.omg.CORBA_2_3.portable.OutputStream getOrbStream()
111      {
112          return orbStream;
113      }
114  
115      public final void increaseRecursionDepth()
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/IIOPOutputStream.java
      * Line Number: 110
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
100  
101              vout.start_value(currentClassDesc.getRMIIIOPOptionalDataRepId());
102          }
103      }
104  
105      public final void setOrbStream(org.omg.CORBA_2_3.portable.OutputStream os)
106      {
107          orbStream = os;
108      }
109  
110      public final org.omg.CORBA_2_3.portable.OutputStream getOrbStream()
111      {
112          return orbStream;
113      }
114  
115      public final void increaseRecursionDepth()
116      {
117          recursionDepth++;
118      }
119  
120      public final int decreaseRecursionDepth()
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/IIOPOutputStream.java
      * Line Number: 518
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
508  
509      protected final void writeStreamHeader() throws IOException
510      {
511          // no op
512      }
513  
514      /**
515       * Helper method for correcting the Kestrel bug 4367783 (dealing with larger than 8-bit chars). The old behavior is
516       * preserved in orbutil.IIOPInputStream_1_3 in order to interoperate with our legacy ORBs.
517       */
518      protected void internalWriteUTF(org.omg.CORBA.portable.OutputStream stream, String data)
519      {
520          stream.write_wstring(data);
521      }
522  
523      public final void writeUTF(String data) throws IOException
524      {
525          try
526          {
527              writeObjectState.writeData(this);
528  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/IIOPOutputStream.java
      * Line Number: 69
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
59      private UtilSystemException wrapper = UtilSystemException.get(CORBALogDomains.RPC_ENCODING);
60  
61      private static Bridge bridge = AccessController.doPrivileged(new PrivilegedAction<Bridge>()
62      {
63          public Bridge run()
64          {
65              return Bridge.get();
66          }
67      });
68  
69      private org.omg.CORBA_2_3.portable.OutputStream orbStream;
70  
71      private Object currentObject = null;
72  
73      private ObjectStreamClass currentClassDesc = null;
74  
75      private int recursionDepth = 0;
76  
77      private int simpleWriteDepth = 0;
78  
79      private IOException abortIOException = null;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/IIOPOutputStream.java
      * Line Number: 752
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
742              if (type.isInterface())
743              {
744                  if (java.rmi.Remote.class.isAssignableFrom(type))
745                  {
746  
747                      // RMI Object reference...
748  
749                      callType = ValueHandlerImpl.kRemoteType;
750  
751                  }
752                  else if (org.omg.CORBA.Object.class.isAssignableFrom(type))
753                  {
754  
755                      // IDL Object reference...
756                      callType = ValueHandlerImpl.kRemoteType;
757  
758                  }
759                  else if (RepositoryId.isAbstractBase(type))
760                  {
761                      // IDL Abstract Object reference...
762                      callType = ValueHandlerImpl.kAbstractType;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/InputStreamHook.java
      * Line Number: 259
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
249      // we have a readObject method and whether or not the
250      // sender wrote default data
251  
252      protected void setState(ReadObjectState newState)
253      {
254          readObjectState = newState;
255      }
256  
257      protected abstract byte getStreamFormatVersion();
258  
259      protected abstract org.omg.CORBA_2_3.portable.InputStream getOrbStream();
260  
261      // Description of possible actions
262      protected static class ReadObjectState
263      {
264          public void beginUnmarshalCustomValue(InputStreamHook stream, boolean calledDefaultWriteObject,
265                  boolean hasReadObject) throws IOException
266          {
267          }
268  
269          public void endUnmarshalCustomValue(InputStreamHook stream) throws IOException
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/InputStreamHook.java
      * Line Number: 46
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
36  import java.io.ObjectInputStream;
37  import java.io.StreamCorruptedException;
38  import java.util.HashMap;
39  import java.util.Map;
40  
41  import org.jboss.com.sun.corba.se.impl.logging.OMGSystemException;
42  import org.jboss.com.sun.corba.se.impl.logging.UtilSystemException;
43  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
44  import org.jboss.com.sun.corba.se.spi.orb.ORBVersion;
45  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
46  import org.omg.CORBA.portable.ValueInputStream;
47  
48  public abstract class InputStreamHook extends ObjectInputStream
49  {
50      // These should be visible in all the nested classes
51      static final OMGSystemException omgWrapper = OMGSystemException.get(CORBALogDomains.RPC_ENCODING);
52  
53      static final UtilSystemException utilWrapper = UtilSystemException.get(CORBALogDomains.RPC_ENCODING);
54  
55      private class HookGetFields extends ObjectInputStream.GetField
56      {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/InputStreamHook.java
      * Line Number: 431
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
421  
422              // Read the fake valuetype header in stream format version 2
423              if (stream.getStreamFormatVersion() == 2)
424                  ((ValueInputStream) stream.getOrbStream()).start_value();
425  
426              stream.setState(IN_READ_OBJECT_OPT_DATA);
427          }
428  
429          public void readData(InputStreamHook stream) throws IOException
430          {
431              org.omg.CORBA.ORB orb = stream.getOrbStream().orb();
432              if ((orb == null) || !(orb instanceof org.jboss.com.sun.corba.se.spi.orb.ORB))
433              {
434                  throw new StreamCorruptedException("Default data must be read first");
435              }
436              ORBVersion clientOrbVersion = ((org.jboss.com.sun.corba.se.spi.orb.ORB) orb).getORBVersion();
437  
438              // Fix Date interop bug. For older versions of the ORB don't do
439              // anything for readData(). Before this used to throw
440              // StreamCorruptedException for older versions of the ORB where
441              // calledDefaultWriteObject always returns true.
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/ObjectStreamClass.java
      * Line Number: 57
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
47  import java.security.DigestOutputStream;
48  import java.security.MessageDigest;
49  import java.security.NoSuchAlgorithmException;
50  import java.security.PrivilegedAction;
51  import java.util.Arrays;
52  import java.util.Comparator;
53  import java.util.Hashtable;
54  
55  import org.jboss.com.sun.corba.se.impl.util.RepositoryId;
56  import org.jboss.sun.corba.Bridge;
57  import org.omg.CORBA.ValueMember;
58  
59  /**
60   * A ObjectStreamClass describes a class that can be serialized to a stream or a class that was serialized to a stream.
61   * It contains the name and the serialVersionUID of the class. <br>
62   * The ObjectStreamClass for a specific class loaded in this Java VM can be found using the lookup method.
63   * 
64   * @author Roger Riggs
65   * @since JDK1.1
66   */
67  public class ObjectStreamClass implements java.io.Serializable
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/OutputStreamHook.java
      * Line Number: 192
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
182      // User uses PutFields to simulate default data.
183      // See java.io.ObjectOutputStream.PutFields
184      public void writeFields() throws IOException
185      {
186  
187          writeObjectState.defaultWriteObject(this);
188  
189          putFields.write(this);
190      }
191  
192      public abstract org.omg.CORBA_2_3.portable.OutputStream getOrbStream();
193  
194      protected abstract void beginOptionalCustomData();
195  
196      // The following is a State pattern implementation of what
197      // should be done when a Serializable has a
198      // writeObject method. This was especially necessary for
199      // RMI-IIOP stream format version 2. Please see the
200      // state diagrams in the docs directory of the workspace.
201  
202      protected WriteObjectState writeObjectState = NOT_IN_WRITE_OBJECT;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/OutputStreamHook.java
      * Line Number: 336
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
326      }
327  
328      protected static class WroteCustomDataState extends InWriteObjectState
329      {
330  
331          public void exitWriteObject(OutputStreamHook stream) throws IOException
332          {
333              // In stream format version 2, we must tell the ORB
334              // stream to close the fake custom valuetype.
335              if (stream.getStreamFormatVersion() == 2)
336                  ((org.omg.CORBA.portable.ValueOutputStream) stream.getOrbStream()).end_value();
337  
338              stream.setState(NOT_IN_WRITE_OBJECT);
339          }
340  
341          public void defaultWriteObject(OutputStreamHook stream) throws IOException
342          {
343              // XXX I18N, logging needed.
344              throw new IOException("Cannot call defaultWriteObject/writeFields after writing custom data in RMI-IIOP");
345          }
346  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/ValueHandlerImpl.java
      * Line Number: 782
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/ValueHandlerImpl.java
      * Line Number: 143
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
133  
134      private UtilSystemException utilWrapper = UtilSystemException.get(CORBALogDomains.RPC_ENCODING);
135  
136      // See javax.rmi.CORBA.ValueHandlerMultiFormat
137      public byte getMaximumStreamFormatVersion()
138      {
139          return MAX_STREAM_FORMAT_VERSION;
140      }
141  
142      // See javax.rmi.CORBA.ValueHandlerMultiFormat
143      public void writeValue(org.omg.CORBA.portable.OutputStream out, java.io.Serializable value, byte streamFormatVersion)
144      {
145  
146          if (streamFormatVersion == 2)
147          {
148              if (!(out instanceof org.omg.CORBA.portable.ValueOutputStream))
149              {
150                  throw omgWrapper.notAValueoutputstream();
151              }
152          }
153          else if (streamFormatVersion != 1)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/ValueHandlerImpl.java
      * Line Number: 148
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
138      {
139          return MAX_STREAM_FORMAT_VERSION;
140      }
141  
142      // See javax.rmi.CORBA.ValueHandlerMultiFormat
143      public void writeValue(org.omg.CORBA.portable.OutputStream out, java.io.Serializable value, byte streamFormatVersion)
144      {
145  
146          if (streamFormatVersion == 2)
147          {
148              if (!(out instanceof org.omg.CORBA.portable.ValueOutputStream))
149              {
150                  throw omgWrapper.notAValueoutputstream();
151              }
152          }
153          else if (streamFormatVersion != 1)
154          {
155              throw omgWrapper.invalidStreamFormatVersion(new Integer(streamFormatVersion));
156          }
157  
158          writeValueWithVersion(out, value, streamFormatVersion);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/ValueHandlerImpl.java
      * Line Number: 179
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
169      }
170  
171      /**
172       * Writes the value to the stream using java semantics.
173       * 
174       * @param out
175       *            The stream to write the value to
176       * @param value
177       *            The value to be written to the stream
178       **/
179      public void writeValue(org.omg.CORBA.portable.OutputStream _out, java.io.Serializable value)
180      {
181          writeValueWithVersion(_out, value, STREAM_FORMAT_VERSION_1);
182      }
183  
184      private void writeValueWithVersion(org.omg.CORBA.portable.OutputStream _out, java.io.Serializable value,
185              byte streamFormatVersion)
186      {
187  
188          org.omg.CORBA_2_3.portable.OutputStream out = (org.omg.CORBA_2_3.portable.OutputStream) _out;
189  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/ValueHandlerImpl.java
      * Line Number: 184
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
174       * @param out
175       *            The stream to write the value to
176       * @param value
177       *            The value to be written to the stream
178       **/
179      public void writeValue(org.omg.CORBA.portable.OutputStream _out, java.io.Serializable value)
180      {
181          writeValueWithVersion(_out, value, STREAM_FORMAT_VERSION_1);
182      }
183  
184      private void writeValueWithVersion(org.omg.CORBA.portable.OutputStream _out, java.io.Serializable value,
185              byte streamFormatVersion)
186      {
187  
188          org.omg.CORBA_2_3.portable.OutputStream out = (org.omg.CORBA_2_3.portable.OutputStream) _out;
189  
190          if (!useHashtables)
191          {
192              if (outputStreamBridge == null)
193              {
194                  outputStreamBridge = createOutputStream();
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/ValueHandlerImpl.java
      * Line Number: 188
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
178       **/
179      public void writeValue(org.omg.CORBA.portable.OutputStream _out, java.io.Serializable value)
180      {
181          writeValueWithVersion(_out, value, STREAM_FORMAT_VERSION_1);
182      }
183  
184      private void writeValueWithVersion(org.omg.CORBA.portable.OutputStream _out, java.io.Serializable value,
185              byte streamFormatVersion)
186      {
187  
188          org.omg.CORBA_2_3.portable.OutputStream out = (org.omg.CORBA_2_3.portable.OutputStream) _out;
189  
190          if (!useHashtables)
191          {
192              if (outputStreamBridge == null)
193              {
194                  outputStreamBridge = createOutputStream();
195                  outputStreamBridge.setOrbStream(out);
196              }
197  
198              try
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/ValueHandlerImpl.java
      * Line Number: 240
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
230          }
231          finally
232          {
233              if (jdkToOrbOutputStreamBridge.decreaseRecursionDepth() == 0)
234              {
235                  outputStreamPairs.remove(_out);
236              }
237          }
238      }
239  
240      private void writeValueInternal(IIOPOutputStream bridge, org.omg.CORBA_2_3.portable.OutputStream out,
241              java.io.Serializable value, byte streamFormatVersion)
242      {
243          Class<?> clazz = value.getClass();
244  
245          if (clazz.isArray())
246              write_Array(out, value, clazz.getComponentType());
247          else
248              bridge.simpleWriteObject(value, streamFormatVersion);
249      }
250  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/ValueHandlerImpl.java
      * Line Number: 261
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
251      /**
252       * Reads a value from the stream using java semantics.
253       * 
254       * @param in
255       *            The stream to read the value from
256       * @param clazz
257       *            The type of the value to be read in
258       * @param sender
259       *            The sending context runtime
260       **/
261      public java.io.Serializable readValue(org.omg.CORBA.portable.InputStream _in, int offset, Class<?> clazz,
262              String repositoryID, org.omg.SendingContext.RunTime _sender)
263      {
264          // Must use narrow rather than a direct cast to a org.jboss.com.sun class. Fix for bug 4379539.
265          CodeBase sender = CodeBaseHelper.narrow(_sender);
266  
267          org.omg.CORBA_2_3.portable.InputStream in = (org.omg.CORBA_2_3.portable.InputStream) _in;
268  
269          if (!useHashtables)
270          {
271              if (inputStreamBridge == null)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/ValueHandlerImpl.java
      * Line Number: 267
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
257       *            The type of the value to be read in
258       * @param sender
259       *            The sending context runtime
260       **/
261      public java.io.Serializable readValue(org.omg.CORBA.portable.InputStream _in, int offset, Class<?> clazz,
262              String repositoryID, org.omg.SendingContext.RunTime _sender)
263      {
264          // Must use narrow rather than a direct cast to a org.jboss.com.sun class. Fix for bug 4379539.
265          CodeBase sender = CodeBaseHelper.narrow(_sender);
266  
267          org.omg.CORBA_2_3.portable.InputStream in = (org.omg.CORBA_2_3.portable.InputStream) _in;
268  
269          if (!useHashtables)
270          {
271              if (inputStreamBridge == null)
272              {
273                  inputStreamBridge = createInputStream();
274                  inputStreamBridge.setOrbStream(in);
275                  inputStreamBridge.setSender(sender); // d11638
276                  // backward compatability 4365188
277                  inputStreamBridge.setValueHandler(this);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/ValueHandlerImpl.java
      * Line Number: 336
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
326  
327              if (jdkToOrbInputStreamBridge.decreaseRecursionDepth() == 0)
328              {
329                  inputStreamPairs.remove(_in);
330              }
331          }
332  
333          return result;
334      }
335  
336      private java.io.Serializable readValueInternal(IIOPInputStream bridge, org.omg.CORBA_2_3.portable.InputStream in,
337              int offset, Class<?> clazz, String repositoryID, org.jboss.com.sun.org.omg.SendingContext.CodeBase sender)
338      {
339          java.io.Serializable result = null;
340  
341          if (clazz == null)
342          {
343              // clazz == null indicates an FVD situation for a nonexistant class
344              if (isArray(repositoryID))
345              {
346                  read_Array(bridge, in, null, sender, offset);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/ValueHandlerImpl.java
      * Line Number: 49
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
39  
40  import javax.rmi.CORBA.Util;
41  
42  import org.jboss.com.sun.corba.se.impl.logging.OMGSystemException;
43  import org.jboss.com.sun.corba.se.impl.logging.UtilSystemException;
44  import org.jboss.com.sun.corba.se.impl.util.RepositoryId;
45  import org.jboss.com.sun.corba.se.impl.util.Utility;
46  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
47  import org.jboss.com.sun.org.omg.SendingContext.CodeBase;
48  import org.jboss.com.sun.org.omg.SendingContext.CodeBaseHelper;
49  import org.omg.CORBA.TCKind;
50  import org.omg.CORBA.portable.IndirectionException;
51  import org.omg.CORBA.portable.InputStream;
52  import org.omg.CORBA.portable.OutputStream;
53  
54  public class ValueHandlerImpl implements javax.rmi.CORBA.ValueHandlerMultiFormat
55  {
56  
57      // Property to override our maximum stream format version
58      public static final String FORMAT_VERSION_PROPERTY = "org.jboss.com.sun.CORBA.MaxStreamFormatVersion";
59  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/ValueHandlerImpl.java
      * Line Number: 50
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
40  import javax.rmi.CORBA.Util;
41  
42  import org.jboss.com.sun.corba.se.impl.logging.OMGSystemException;
43  import org.jboss.com.sun.corba.se.impl.logging.UtilSystemException;
44  import org.jboss.com.sun.corba.se.impl.util.RepositoryId;
45  import org.jboss.com.sun.corba.se.impl.util.Utility;
46  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
47  import org.jboss.com.sun.org.omg.SendingContext.CodeBase;
48  import org.jboss.com.sun.org.omg.SendingContext.CodeBaseHelper;
49  import org.omg.CORBA.TCKind;
50  import org.omg.CORBA.portable.IndirectionException;
51  import org.omg.CORBA.portable.InputStream;
52  import org.omg.CORBA.portable.OutputStream;
53  
54  public class ValueHandlerImpl implements javax.rmi.CORBA.ValueHandlerMultiFormat
55  {
56  
57      // Property to override our maximum stream format version
58      public static final String FORMAT_VERSION_PROPERTY = "org.jboss.com.sun.CORBA.MaxStreamFormatVersion";
59  
60      private static final byte MAX_SUPPORTED_FORMAT_VERSION = (byte) 2;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/ValueHandlerImpl.java
      * Line Number: 51
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
41  
42  import org.jboss.com.sun.corba.se.impl.logging.OMGSystemException;
43  import org.jboss.com.sun.corba.se.impl.logging.UtilSystemException;
44  import org.jboss.com.sun.corba.se.impl.util.RepositoryId;
45  import org.jboss.com.sun.corba.se.impl.util.Utility;
46  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
47  import org.jboss.com.sun.org.omg.SendingContext.CodeBase;
48  import org.jboss.com.sun.org.omg.SendingContext.CodeBaseHelper;
49  import org.omg.CORBA.TCKind;
50  import org.omg.CORBA.portable.IndirectionException;
51  import org.omg.CORBA.portable.InputStream;
52  import org.omg.CORBA.portable.OutputStream;
53  
54  public class ValueHandlerImpl implements javax.rmi.CORBA.ValueHandlerMultiFormat
55  {
56  
57      // Property to override our maximum stream format version
58      public static final String FORMAT_VERSION_PROPERTY = "org.jboss.com.sun.CORBA.MaxStreamFormatVersion";
59  
60      private static final byte MAX_SUPPORTED_FORMAT_VERSION = (byte) 2;
61  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/ValueHandlerImpl.java
      * Line Number: 52
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
42  import org.jboss.com.sun.corba.se.impl.logging.OMGSystemException;
43  import org.jboss.com.sun.corba.se.impl.logging.UtilSystemException;
44  import org.jboss.com.sun.corba.se.impl.util.RepositoryId;
45  import org.jboss.com.sun.corba.se.impl.util.Utility;
46  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
47  import org.jboss.com.sun.org.omg.SendingContext.CodeBase;
48  import org.jboss.com.sun.org.omg.SendingContext.CodeBaseHelper;
49  import org.omg.CORBA.TCKind;
50  import org.omg.CORBA.portable.IndirectionException;
51  import org.omg.CORBA.portable.InputStream;
52  import org.omg.CORBA.portable.OutputStream;
53  
54  public class ValueHandlerImpl implements javax.rmi.CORBA.ValueHandlerMultiFormat
55  {
56  
57      // Property to override our maximum stream format version
58      public static final String FORMAT_VERSION_PROPERTY = "org.jboss.com.sun.CORBA.MaxStreamFormatVersion";
59  
60      private static final byte MAX_SUPPORTED_FORMAT_VERSION = (byte) 2;
61  
62      private static final byte STREAM_FORMAT_VERSION_1 = (byte) 1;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/ValueHandlerImpl.java
      * Line Number: 492
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
482       **/
483      public java.io.Serializable writeReplace(java.io.Serializable value)
484      {
485          return ObjectStreamClass.lookup(value.getClass()).writeReplace(value);
486      }
487  
488      /**
489       * Encapsulates writing of Java char arrays so that the 1.3 subclass can override it without exposing internals
490       * across packages. This is a fix for bug 4367783.
491       */
492      protected void writeCharArray(org.omg.CORBA_2_3.portable.OutputStream out, char[] array, int offset, int length)
493      {
494          out.write_wchar_array(array, offset, length);
495      }
496  
497      private void write_Array(org.omg.CORBA_2_3.portable.OutputStream out, java.io.Serializable obj, Class<?> type)
498      {
499  
500          int i, length;
501  
502          if (type.isPrimitive())
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/ValueHandlerImpl.java
      * Line Number: 497
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
487  
488      /**
489       * Encapsulates writing of Java char arrays so that the 1.3 subclass can override it without exposing internals
490       * across packages. This is a fix for bug 4367783.
491       */
492      protected void writeCharArray(org.omg.CORBA_2_3.portable.OutputStream out, char[] array, int offset, int length)
493      {
494          out.write_wchar_array(array, offset, length);
495      }
496  
497      private void write_Array(org.omg.CORBA_2_3.portable.OutputStream out, java.io.Serializable obj, Class<?> type)
498      {
499  
500          int i, length;
501  
502          if (type.isPrimitive())
503          {
504              if (type == Integer.TYPE)
505              {
506                  int[] array = (int[]) obj;
507                  length = array.length;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/ValueHandlerImpl.java
      * Line Number: 590
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
580              out.write_ulong(length);
581              int callType = kValueType;
582  
583              if (type.isInterface())
584              {
585                  if (java.rmi.Remote.class.isAssignableFrom(type))
586                  {
587                      // RMI Object reference...
588                      callType = kRemoteType;
589                  }
590                  else if (org.omg.CORBA.Object.class.isAssignableFrom(type))
591                  {
592                      // IDL Object reference...
593                      callType = kRemoteType;
594                  }
595                  else if (RepositoryId.isAbstractBase(type))
596                  {
597                      // IDL Abstract Object reference...
598                      callType = kAbstractType;
599                  }
600                  else if (ObjectStreamClassCorbaExt.isAbstractInterface(type))
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/ValueHandlerImpl.java
      * Line Number: 640
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
630                          break;
631                  }
632              }
633          }
634      }
635  
636      /**
637       * Encapsulates reading of Java char arrays so that the 1.3 subclass can override it without exposing internals
638       * across packages. This is a fix for bug 4367783.
639       */
640      protected void readCharArray(org.omg.CORBA_2_3.portable.InputStream in, char[] array, int offset, int length)
641      {
642          in.read_wchar_array(array, offset, length);
643      }
644  
645      private Object read_Array(IIOPInputStream bridge, org.omg.CORBA_2_3.portable.InputStream in, Class<?> sequence,
646              org.jboss.com.sun.org.omg.SendingContext.CodeBase sender, int offset)
647      {
648          try
649          {
650              // Read length of coming array
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/ValueHandlerImpl.java
      * Line Number: 645
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
635  
636      /**
637       * Encapsulates reading of Java char arrays so that the 1.3 subclass can override it without exposing internals
638       * across packages. This is a fix for bug 4367783.
639       */
640      protected void readCharArray(org.omg.CORBA_2_3.portable.InputStream in, char[] array, int offset, int length)
641      {
642          in.read_wchar_array(array, offset, length);
643      }
644  
645      private Object read_Array(IIOPInputStream bridge, org.omg.CORBA_2_3.portable.InputStream in, Class<?> sequence,
646              org.jboss.com.sun.org.omg.SendingContext.CodeBase sender, int offset)
647      {
648          try
649          {
650              // Read length of coming array
651              int length = in.read_ulong();
652              int i;
653  
654              if (sequence == null)
655              {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/ValueUtility.java
      * Line Number: 40
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
30   */
31  
32  package org.jboss.com.sun.corba.se.impl.io;
33  
34  import java.lang.reflect.Modifier;
35  import java.util.Iterator;
36  import java.util.Stack;
37  
38  import javax.rmi.CORBA.ValueHandler;
39  
40  import org.omg.CORBA.ORB;
41  import org.omg.CORBA.TCKind;
42  import org.omg.CORBA.TypeCode;
43  import org.omg.CORBA.ValueMember;
44  
45  import org.jboss.com.sun.corba.se.impl.util.RepositoryId;
46  import org.jboss.com.sun.org.omg.CORBA.AttributeDescription;
47  import org.jboss.com.sun.org.omg.CORBA.Initializer;
48  import org.jboss.com.sun.org.omg.CORBA.OperationDescription;
49  import org.jboss.com.sun.org.omg.CORBA._IDLTypeStub;
50  import org.jboss.com.sun.org.omg.CORBA.ValueDefPackage.FullValueDescription;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/ValueUtility.java
      * Line Number: 41
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
31  
32  package org.jboss.com.sun.corba.se.impl.io;
33  
34  import java.lang.reflect.Modifier;
35  import java.util.Iterator;
36  import java.util.Stack;
37  
38  import javax.rmi.CORBA.ValueHandler;
39  
40  import org.omg.CORBA.ORB;
41  import org.omg.CORBA.TCKind;
42  import org.omg.CORBA.TypeCode;
43  import org.omg.CORBA.ValueMember;
44  
45  import org.jboss.com.sun.corba.se.impl.util.RepositoryId;
46  import org.jboss.com.sun.org.omg.CORBA.AttributeDescription;
47  import org.jboss.com.sun.org.omg.CORBA.Initializer;
48  import org.jboss.com.sun.org.omg.CORBA.OperationDescription;
49  import org.jboss.com.sun.org.omg.CORBA._IDLTypeStub;
50  import org.jboss.com.sun.org.omg.CORBA.ValueDefPackage.FullValueDescription;
51  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/ValueUtility.java
      * Line Number: 42
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
32  package org.jboss.com.sun.corba.se.impl.io;
33  
34  import java.lang.reflect.Modifier;
35  import java.util.Iterator;
36  import java.util.Stack;
37  
38  import javax.rmi.CORBA.ValueHandler;
39  
40  import org.omg.CORBA.ORB;
41  import org.omg.CORBA.TCKind;
42  import org.omg.CORBA.TypeCode;
43  import org.omg.CORBA.ValueMember;
44  
45  import org.jboss.com.sun.corba.se.impl.util.RepositoryId;
46  import org.jboss.com.sun.org.omg.CORBA.AttributeDescription;
47  import org.jboss.com.sun.org.omg.CORBA.Initializer;
48  import org.jboss.com.sun.org.omg.CORBA.OperationDescription;
49  import org.jboss.com.sun.org.omg.CORBA._IDLTypeStub;
50  import org.jboss.com.sun.org.omg.CORBA.ValueDefPackage.FullValueDescription;
51  
52  /**
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/ValueUtility.java
      * Line Number: 43
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
33  
34  import java.lang.reflect.Modifier;
35  import java.util.Iterator;
36  import java.util.Stack;
37  
38  import javax.rmi.CORBA.ValueHandler;
39  
40  import org.omg.CORBA.ORB;
41  import org.omg.CORBA.TCKind;
42  import org.omg.CORBA.TypeCode;
43  import org.omg.CORBA.ValueMember;
44  
45  import org.jboss.com.sun.corba.se.impl.util.RepositoryId;
46  import org.jboss.com.sun.org.omg.CORBA.AttributeDescription;
47  import org.jboss.com.sun.org.omg.CORBA.Initializer;
48  import org.jboss.com.sun.org.omg.CORBA.OperationDescription;
49  import org.jboss.com.sun.org.omg.CORBA._IDLTypeStub;
50  import org.jboss.com.sun.org.omg.CORBA.ValueDefPackage.FullValueDescription;
51  
52  /**
53   * Holds utility methods for converting from ObjectStreamClass to FullValueDescription and generating typecodes from
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/ValueUtility.java
      * Line Number: 437
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
427          else if (c == java.lang.String.class)
428          {
429              // Strings
430              TypeCode t = orb.create_string_tc(0);
431              return orb.create_value_box_tc(id, "StringValue", t);
432          }
433          else if (java.rmi.Remote.class.isAssignableFrom(c))
434          {
435              return orb.get_primitive_tc(TCKind.tk_objref);
436          }
437          else if (org.omg.CORBA.Object.class.isAssignableFrom(c))
438          {
439              return orb.get_primitive_tc(TCKind.tk_objref);
440          }
441  
442          // Anything else
443  
444          ObjectStreamClass osc = ObjectStreamClass.lookup(c);
445  
446          if (osc == null)
447          {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/io/ValueUtility.java
      * Line Number: 453
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
443  
444          ObjectStreamClass osc = ObjectStreamClass.lookup(c);
445  
446          if (osc == null)
447          {
448              return orb.create_value_box_tc(id, "Value", orb.get_primitive_tc(TCKind.tk_value));
449          }
450  
451          // type modifier
452          // REVISIT truncatable and abstract?
453          short modifier = (osc.isCustomMarshaled() ? org.omg.CORBA.VM_CUSTOM.value : org.omg.CORBA.VM_NONE.value);
454  
455          // concrete base
456          TypeCode base = null;
457          Class<?> superClass = c.getSuperclass();
458          if (superClass != null && java.io.Serializable.class.isAssignableFrom(superClass))
459          {
460              base = createTypeCodeForClassInternal(orb, superClass, vh, createdIDs);
461          }
462  
463          // members
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/EncapsulationUtility.java
      * Line Number: 38
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
28  import java.util.Iterator;
29  import java.util.List;
30  
31  import org.jboss.com.sun.corba.se.impl.encoding.CDROutputStream;
32  import org.jboss.com.sun.corba.se.impl.encoding.EncapsInputStream;
33  import org.jboss.com.sun.corba.se.impl.encoding.EncapsOutputStream;
34  import org.jboss.com.sun.corba.se.spi.ior.Identifiable;
35  import org.jboss.com.sun.corba.se.spi.ior.IdentifiableFactoryFinder;
36  import org.jboss.com.sun.corba.se.spi.ior.WriteContents;
37  import org.jboss.com.sun.corba.se.spi.orb.ORB;
38  import org.omg.CORBA_2_3.portable.InputStream;
39  import org.omg.CORBA_2_3.portable.OutputStream;
40  
41  /**
42   * This static utility class contains various utility methods for reading and writing CDR encapsulations.
43   * 
44   * @author Ken Cavanaugh
45   */
46  public class EncapsulationUtility
47  {
48      private EncapsulationUtility()
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/EncapsulationUtility.java
      * Line Number: 39
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
29  import java.util.List;
30  
31  import org.jboss.com.sun.corba.se.impl.encoding.CDROutputStream;
32  import org.jboss.com.sun.corba.se.impl.encoding.EncapsInputStream;
33  import org.jboss.com.sun.corba.se.impl.encoding.EncapsOutputStream;
34  import org.jboss.com.sun.corba.se.spi.ior.Identifiable;
35  import org.jboss.com.sun.corba.se.spi.ior.IdentifiableFactoryFinder;
36  import org.jboss.com.sun.corba.se.spi.ior.WriteContents;
37  import org.jboss.com.sun.corba.se.spi.orb.ORB;
38  import org.omg.CORBA_2_3.portable.InputStream;
39  import org.omg.CORBA_2_3.portable.OutputStream;
40  
41  /**
42   * This static utility class contains various utility methods for reading and writing CDR encapsulations.
43   * 
44   * @author Ken Cavanaugh
45   */
46  public class EncapsulationUtility
47  {
48      private EncapsulationUtility()
49      {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/IORImpl.java
      * Line Number: 52
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
42  import org.jboss.com.sun.corba.se.spi.ior.IORTemplateList;
43  import org.jboss.com.sun.corba.se.spi.ior.IdentifiableContainerBase;
44  import org.jboss.com.sun.corba.se.spi.ior.IdentifiableFactoryFinder;
45  import org.jboss.com.sun.corba.se.spi.ior.ObjectId;
46  import org.jboss.com.sun.corba.se.spi.ior.ObjectKeyTemplate;
47  import org.jboss.com.sun.corba.se.spi.ior.TaggedProfile;
48  import org.jboss.com.sun.corba.se.spi.ior.TaggedProfileTemplate;
49  import org.jboss.com.sun.corba.se.spi.ior.iiop.IIOPProfile;
50  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
51  import org.jboss.com.sun.corba.se.spi.orb.ORB;
52  import org.omg.CORBA_2_3.portable.InputStream;
53  import org.omg.CORBA_2_3.portable.OutputStream;
54  import org.omg.IOP.TAG_INTERNET_IOP;
55  
56  /**
57   * An IOR is represented as a list of profiles. Only objects that extend TaggedProfile should be added to an IOR.
58   * However, enforcing this restriction requires overriding all of the addXXX methods inherited from List, so no check is
59   * included here.
60   * 
61   * @author Ken Cavanaugh
62   */
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/IORImpl.java
      * Line Number: 53
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
43  import org.jboss.com.sun.corba.se.spi.ior.IdentifiableContainerBase;
44  import org.jboss.com.sun.corba.se.spi.ior.IdentifiableFactoryFinder;
45  import org.jboss.com.sun.corba.se.spi.ior.ObjectId;
46  import org.jboss.com.sun.corba.se.spi.ior.ObjectKeyTemplate;
47  import org.jboss.com.sun.corba.se.spi.ior.TaggedProfile;
48  import org.jboss.com.sun.corba.se.spi.ior.TaggedProfileTemplate;
49  import org.jboss.com.sun.corba.se.spi.ior.iiop.IIOPProfile;
50  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
51  import org.jboss.com.sun.corba.se.spi.orb.ORB;
52  import org.omg.CORBA_2_3.portable.InputStream;
53  import org.omg.CORBA_2_3.portable.OutputStream;
54  import org.omg.IOP.TAG_INTERNET_IOP;
55  
56  /**
57   * An IOR is represented as a list of profiles. Only objects that extend TaggedProfile should be added to an IOR.
58   * However, enforcing this restriction requires overriding all of the addXXX methods inherited from List, so no check is
59   * included here.
60   * 
61   * @author Ken Cavanaugh
62   */
63  public class IORImpl extends IdentifiableContainerBase implements IOR
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/IORTemplateImpl.java
      * Line Number: 39
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
29  
30  import org.jboss.com.sun.corba.se.spi.ior.IOR;
31  import org.jboss.com.sun.corba.se.spi.ior.IORFactory;
32  import org.jboss.com.sun.corba.se.spi.ior.IORTemplate;
33  import org.jboss.com.sun.corba.se.spi.ior.IdentifiableContainerBase;
34  import org.jboss.com.sun.corba.se.spi.ior.IdentifiableFactoryFinder;
35  import org.jboss.com.sun.corba.se.spi.ior.ObjectId;
36  import org.jboss.com.sun.corba.se.spi.ior.ObjectKeyTemplate;
37  import org.jboss.com.sun.corba.se.spi.ior.TaggedProfileTemplate;
38  import org.jboss.com.sun.corba.se.spi.orb.ORB;
39  import org.omg.CORBA_2_3.portable.InputStream;
40  import org.omg.CORBA_2_3.portable.OutputStream;
41  
42  /**
43   * This class is a container of TaggedProfileTemplates.
44   * 
45   * @author
46   */
47  public class IORTemplateImpl extends IdentifiableContainerBase implements IORTemplate
48  {
49      private ObjectKeyTemplate oktemp;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/IORTemplateImpl.java
      * Line Number: 40
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
30  import org.jboss.com.sun.corba.se.spi.ior.IOR;
31  import org.jboss.com.sun.corba.se.spi.ior.IORFactory;
32  import org.jboss.com.sun.corba.se.spi.ior.IORTemplate;
33  import org.jboss.com.sun.corba.se.spi.ior.IdentifiableContainerBase;
34  import org.jboss.com.sun.corba.se.spi.ior.IdentifiableFactoryFinder;
35  import org.jboss.com.sun.corba.se.spi.ior.ObjectId;
36  import org.jboss.com.sun.corba.se.spi.ior.ObjectKeyTemplate;
37  import org.jboss.com.sun.corba.se.spi.ior.TaggedProfileTemplate;
38  import org.jboss.com.sun.corba.se.spi.orb.ORB;
39  import org.omg.CORBA_2_3.portable.InputStream;
40  import org.omg.CORBA_2_3.portable.OutputStream;
41  
42  /**
43   * This class is a container of TaggedProfileTemplates.
44   * 
45   * @author
46   */
47  public class IORTemplateImpl extends IdentifiableContainerBase implements IORTemplate
48  {
49      private ObjectKeyTemplate oktemp;
50  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/IORTemplateListImpl.java
      * Line Number: 38
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
28  import java.util.ArrayList;
29  import java.util.Iterator;
30  
31  import org.jboss.com.sun.corba.se.spi.ior.IOR;
32  import org.jboss.com.sun.corba.se.spi.ior.IORFactories;
33  import org.jboss.com.sun.corba.se.spi.ior.IORFactory;
34  import org.jboss.com.sun.corba.se.spi.ior.IORTemplate;
35  import org.jboss.com.sun.corba.se.spi.ior.IORTemplateList;
36  import org.jboss.com.sun.corba.se.spi.ior.ObjectId;
37  import org.jboss.com.sun.corba.se.spi.orb.ORB;
38  import org.omg.CORBA_2_3.portable.InputStream;
39  import org.omg.CORBA_2_3.portable.OutputStream;
40  
41  public class IORTemplateListImpl extends FreezableList implements IORTemplateList
42  {
43      /*
44       * This class must override add( int, Object ) and set( int, Object ) so that adding an IORTemplateList to an
45       * IORTemplateList just results in a list of TaggedProfileTemplates.
46       */
47      public Object set(int index, Object element)
48      {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/IORTemplateListImpl.java
      * Line Number: 39
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
29  import java.util.Iterator;
30  
31  import org.jboss.com.sun.corba.se.spi.ior.IOR;
32  import org.jboss.com.sun.corba.se.spi.ior.IORFactories;
33  import org.jboss.com.sun.corba.se.spi.ior.IORFactory;
34  import org.jboss.com.sun.corba.se.spi.ior.IORTemplate;
35  import org.jboss.com.sun.corba.se.spi.ior.IORTemplateList;
36  import org.jboss.com.sun.corba.se.spi.ior.ObjectId;
37  import org.jboss.com.sun.corba.se.spi.orb.ORB;
38  import org.omg.CORBA_2_3.portable.InputStream;
39  import org.omg.CORBA_2_3.portable.OutputStream;
40  
41  public class IORTemplateListImpl extends FreezableList implements IORTemplateList
42  {
43      /*
44       * This class must override add( int, Object ) and set( int, Object ) so that adding an IORTemplateList to an
45       * IORTemplateList just results in a list of TaggedProfileTemplates.
46       */
47      public Object set(int index, Object element)
48      {
49          if (element instanceof IORTemplate)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/JIDLObjectKeyTemplate.java
      * Line Number: 30
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
20   *
21   * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
22   * or visit www.oracle.com if you need additional information or have any
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.ior;
27  
28  import org.jboss.com.sun.corba.se.spi.orb.ORB;
29  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
30  import org.omg.CORBA.OctetSeqHolder;
31  import org.omg.CORBA_2_3.portable.InputStream;
32  import org.omg.CORBA_2_3.portable.OutputStream;
33  
34  /**
35   * @author Ken Cavanaugh
36   */
37  public final class JIDLObjectKeyTemplate extends NewObjectKeyTemplateBase
38  {
39      /**
40       * This constructor reads the template ONLY from the stream.
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/JIDLObjectKeyTemplate.java
      * Line Number: 31
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
21   * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
22   * or visit www.oracle.com if you need additional information or have any
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.ior;
27  
28  import org.jboss.com.sun.corba.se.spi.orb.ORB;
29  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
30  import org.omg.CORBA.OctetSeqHolder;
31  import org.omg.CORBA_2_3.portable.InputStream;
32  import org.omg.CORBA_2_3.portable.OutputStream;
33  
34  /**
35   * @author Ken Cavanaugh
36   */
37  public final class JIDLObjectKeyTemplate extends NewObjectKeyTemplateBase
38  {
39      /**
40       * This constructor reads the template ONLY from the stream.
41       */
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/JIDLObjectKeyTemplate.java
      * Line Number: 32
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
22   * or visit www.oracle.com if you need additional information or have any
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.ior;
27  
28  import org.jboss.com.sun.corba.se.spi.orb.ORB;
29  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
30  import org.omg.CORBA.OctetSeqHolder;
31  import org.omg.CORBA_2_3.portable.InputStream;
32  import org.omg.CORBA_2_3.portable.OutputStream;
33  
34  /**
35   * @author Ken Cavanaugh
36   */
37  public final class JIDLObjectKeyTemplate extends NewObjectKeyTemplateBase
38  {
39      /**
40       * This constructor reads the template ONLY from the stream.
41       */
42      public JIDLObjectKeyTemplate(ORB orb, int magic, int scid, InputStream is)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/ObjectAdapterIdBase.java
      * Line Number: 31
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
21   * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
22   * or visit www.oracle.com if you need additional information or have any
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.ior;
27  
28  import java.util.Iterator;
29  
30  import org.jboss.com.sun.corba.se.spi.ior.ObjectAdapterId;
31  import org.omg.CORBA_2_3.portable.OutputStream;
32  
33  abstract class ObjectAdapterIdBase implements ObjectAdapterId
34  {
35      public boolean equals(Object other)
36      {
37          if (!(other instanceof ObjectAdapterId))
38              return false;
39  
40          ObjectAdapterId theOther = (ObjectAdapterId) other;
41  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/ObjectIdImpl.java
      * Line Number: 31
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
21   * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
22   * or visit www.oracle.com if you need additional information or have any
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.ior;
27  
28  import java.util.Arrays;
29  
30  import org.jboss.com.sun.corba.se.spi.ior.ObjectId;
31  import org.omg.CORBA_2_3.portable.OutputStream;
32  
33  /**
34   * @author
35   */
36  public final class ObjectIdImpl implements ObjectId
37  {
38      private byte[] id;
39  
40      public boolean equals(Object obj)
41      {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/ObjectKeyFactoryImpl.java
      * Line Number: 37
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
27  
28  import java.io.IOException;
29  
30  import org.jboss.com.sun.corba.se.impl.encoding.EncapsInputStream;
31  import org.jboss.com.sun.corba.se.impl.orbutil.ORBConstants;
32  import org.jboss.com.sun.corba.se.spi.ior.ObjectId;
33  import org.jboss.com.sun.corba.se.spi.ior.ObjectKey;
34  import org.jboss.com.sun.corba.se.spi.ior.ObjectKeyFactory;
35  import org.jboss.com.sun.corba.se.spi.ior.ObjectKeyTemplate;
36  import org.jboss.com.sun.corba.se.spi.orb.ORB;
37  import org.omg.CORBA.MARSHAL;
38  import org.omg.CORBA.OctetSeqHolder;
39  import org.omg.CORBA_2_3.portable.InputStream;
40  
41  /**
42   * Based on the magic and scid, return the appropriate ObjectKeyTemplate. Expects to be called with a valid magic. If
43   * scid is not valid, null should be returned.
44   */
45  interface Handler
46  {
47      ObjectKeyTemplate handle(int magic, int scid, InputStream is, OctetSeqHolder osh);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/ObjectKeyFactoryImpl.java
      * Line Number: 38
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
28  import java.io.IOException;
29  
30  import org.jboss.com.sun.corba.se.impl.encoding.EncapsInputStream;
31  import org.jboss.com.sun.corba.se.impl.orbutil.ORBConstants;
32  import org.jboss.com.sun.corba.se.spi.ior.ObjectId;
33  import org.jboss.com.sun.corba.se.spi.ior.ObjectKey;
34  import org.jboss.com.sun.corba.se.spi.ior.ObjectKeyFactory;
35  import org.jboss.com.sun.corba.se.spi.ior.ObjectKeyTemplate;
36  import org.jboss.com.sun.corba.se.spi.orb.ORB;
37  import org.omg.CORBA.MARSHAL;
38  import org.omg.CORBA.OctetSeqHolder;
39  import org.omg.CORBA_2_3.portable.InputStream;
40  
41  /**
42   * Based on the magic and scid, return the appropriate ObjectKeyTemplate. Expects to be called with a valid magic. If
43   * scid is not valid, null should be returned.
44   */
45  interface Handler
46  {
47      ObjectKeyTemplate handle(int magic, int scid, InputStream is, OctetSeqHolder osh);
48  }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/ObjectKeyFactoryImpl.java
      * Line Number: 39
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
29  
30  import org.jboss.com.sun.corba.se.impl.encoding.EncapsInputStream;
31  import org.jboss.com.sun.corba.se.impl.orbutil.ORBConstants;
32  import org.jboss.com.sun.corba.se.spi.ior.ObjectId;
33  import org.jboss.com.sun.corba.se.spi.ior.ObjectKey;
34  import org.jboss.com.sun.corba.se.spi.ior.ObjectKeyFactory;
35  import org.jboss.com.sun.corba.se.spi.ior.ObjectKeyTemplate;
36  import org.jboss.com.sun.corba.se.spi.orb.ORB;
37  import org.omg.CORBA.MARSHAL;
38  import org.omg.CORBA.OctetSeqHolder;
39  import org.omg.CORBA_2_3.portable.InputStream;
40  
41  /**
42   * Based on the magic and scid, return the appropriate ObjectKeyTemplate. Expects to be called with a valid magic. If
43   * scid is not valid, null should be returned.
44   */
45  interface Handler
46  {
47      ObjectKeyTemplate handle(int magic, int scid, InputStream is, OctetSeqHolder osh);
48  }
49  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/ObjectKeyTemplateBase.java
      * Line Number: 38
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
28  import java.util.Iterator;
29  
30  import org.jboss.com.sun.corba.se.impl.logging.IORSystemException;
31  import org.jboss.com.sun.corba.se.spi.ior.ObjectAdapterId;
32  import org.jboss.com.sun.corba.se.spi.ior.ObjectId;
33  import org.jboss.com.sun.corba.se.spi.ior.ObjectKeyTemplate;
34  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
35  import org.jboss.com.sun.corba.se.spi.orb.ORB;
36  import org.jboss.com.sun.corba.se.spi.orb.ORBVersion;
37  import org.jboss.com.sun.corba.se.spi.protocol.CorbaServerRequestDispatcher;
38  import org.omg.CORBA_2_3.portable.InputStream;
39  import org.omg.CORBA_2_3.portable.OutputStream;
40  
41  /**
42   * @author
43   */
44  public abstract class ObjectKeyTemplateBase implements ObjectKeyTemplate
45  {
46      // Fixed constants for Java IDL object key template forms
47      public static final String JIDL_ORB_ID = "";
48  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/ObjectKeyTemplateBase.java
      * Line Number: 39
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
29  
30  import org.jboss.com.sun.corba.se.impl.logging.IORSystemException;
31  import org.jboss.com.sun.corba.se.spi.ior.ObjectAdapterId;
32  import org.jboss.com.sun.corba.se.spi.ior.ObjectId;
33  import org.jboss.com.sun.corba.se.spi.ior.ObjectKeyTemplate;
34  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
35  import org.jboss.com.sun.corba.se.spi.orb.ORB;
36  import org.jboss.com.sun.corba.se.spi.orb.ORBVersion;
37  import org.jboss.com.sun.corba.se.spi.protocol.CorbaServerRequestDispatcher;
38  import org.omg.CORBA_2_3.portable.InputStream;
39  import org.omg.CORBA_2_3.portable.OutputStream;
40  
41  /**
42   * @author
43   */
44  public abstract class ObjectKeyTemplateBase implements ObjectKeyTemplate
45  {
46      // Fixed constants for Java IDL object key template forms
47      public static final String JIDL_ORB_ID = "";
48  
49      private static final String[] JIDL_OAID_STRINGS = {"TransientObjectAdapter"};
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/ObjectReferenceFactoryImpl.java
      * Line Number: 104
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
 94      {
 95          return ObjectReferenceFactoryHelper.type();
 96      }
 97  
 98      /**
 99       * Read the data into a (presumably) empty ObjectReferenceFactoryImpl. This sets the orb to the ORB of the
100       * InputStream.
101       */
102      public void _read(InputStream is)
103      {
104          org.omg.CORBA_2_3.portable.InputStream istr = (org.omg.CORBA_2_3.portable.InputStream) is;
105  
106          iorTemplates = IORFactories.makeIORTemplateList(istr);
107      }
108  
109      /**
110       * Write the state to the OutputStream.
111       */
112      public void _write(OutputStream os)
113      {
114          org.omg.CORBA_2_3.portable.OutputStream ostr = (org.omg.CORBA_2_3.portable.OutputStream) os;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/ObjectReferenceFactoryImpl.java
      * Line Number: 114
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
104          org.omg.CORBA_2_3.portable.InputStream istr = (org.omg.CORBA_2_3.portable.InputStream) is;
105  
106          iorTemplates = IORFactories.makeIORTemplateList(istr);
107      }
108  
109      /**
110       * Write the state to the OutputStream.
111       */
112      public void _write(OutputStream os)
113      {
114          org.omg.CORBA_2_3.portable.OutputStream ostr = (org.omg.CORBA_2_3.portable.OutputStream) os;
115  
116          iorTemplates.write(ostr);
117      }
118  
119      public IORFactory getIORFactory()
120      {
121          return iorTemplates;
122      }
123  
124      public IORTemplateList getIORTemplateList()
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/ObjectReferenceFactoryImpl.java
      * Line Number: 32
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
22   * or visit www.oracle.com if you need additional information or have any
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.ior;
27  
28  import org.jboss.com.sun.corba.se.spi.ior.IORFactories;
29  import org.jboss.com.sun.corba.se.spi.ior.IORFactory;
30  import org.jboss.com.sun.corba.se.spi.ior.IORTemplateList;
31  import org.jboss.com.sun.corba.se.spi.orb.ORB;
32  import org.omg.CORBA.TypeCode;
33  import org.omg.CORBA.portable.InputStream;
34  import org.omg.CORBA.portable.OutputStream;
35  import org.omg.CORBA.portable.StreamableValue;
36  import org.omg.PortableInterceptor.ObjectReferenceFactory;
37  import org.omg.PortableInterceptor.ObjectReferenceFactoryHelper;
38  
39  /**
40   * This is an implementation of the ObjectReferenceFactory abstract value type defined by the portable interceptors IDL.
41   * Note that this is a direct Java implementation of the abstract value type: there is no stateful value type defined in
42   * IDL, since defining the state in IDL is awkward and inefficient. The best way to define the state is to use internal
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/ObjectReferenceFactoryImpl.java
      * Line Number: 33
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.ior;
27  
28  import org.jboss.com.sun.corba.se.spi.ior.IORFactories;
29  import org.jboss.com.sun.corba.se.spi.ior.IORFactory;
30  import org.jboss.com.sun.corba.se.spi.ior.IORTemplateList;
31  import org.jboss.com.sun.corba.se.spi.orb.ORB;
32  import org.omg.CORBA.TypeCode;
33  import org.omg.CORBA.portable.InputStream;
34  import org.omg.CORBA.portable.OutputStream;
35  import org.omg.CORBA.portable.StreamableValue;
36  import org.omg.PortableInterceptor.ObjectReferenceFactory;
37  import org.omg.PortableInterceptor.ObjectReferenceFactoryHelper;
38  
39  /**
40   * This is an implementation of the ObjectReferenceFactory abstract value type defined by the portable interceptors IDL.
41   * Note that this is a direct Java implementation of the abstract value type: there is no stateful value type defined in
42   * IDL, since defining the state in IDL is awkward and inefficient. The best way to define the state is to use internal
43   * data structures that can be written to and read from CORBA streams.
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/ObjectReferenceFactoryImpl.java
      * Line Number: 34
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.ior;
27  
28  import org.jboss.com.sun.corba.se.spi.ior.IORFactories;
29  import org.jboss.com.sun.corba.se.spi.ior.IORFactory;
30  import org.jboss.com.sun.corba.se.spi.ior.IORTemplateList;
31  import org.jboss.com.sun.corba.se.spi.orb.ORB;
32  import org.omg.CORBA.TypeCode;
33  import org.omg.CORBA.portable.InputStream;
34  import org.omg.CORBA.portable.OutputStream;
35  import org.omg.CORBA.portable.StreamableValue;
36  import org.omg.PortableInterceptor.ObjectReferenceFactory;
37  import org.omg.PortableInterceptor.ObjectReferenceFactoryHelper;
38  
39  /**
40   * This is an implementation of the ObjectReferenceFactory abstract value type defined by the portable interceptors IDL.
41   * Note that this is a direct Java implementation of the abstract value type: there is no stateful value type defined in
42   * IDL, since defining the state in IDL is awkward and inefficient. The best way to define the state is to use internal
43   * data structures that can be written to and read from CORBA streams.
44   */
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/ObjectReferenceFactoryImpl.java
      * Line Number: 35
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
25  
26  package org.jboss.com.sun.corba.se.impl.ior;
27  
28  import org.jboss.com.sun.corba.se.spi.ior.IORFactories;
29  import org.jboss.com.sun.corba.se.spi.ior.IORFactory;
30  import org.jboss.com.sun.corba.se.spi.ior.IORTemplateList;
31  import org.jboss.com.sun.corba.se.spi.orb.ORB;
32  import org.omg.CORBA.TypeCode;
33  import org.omg.CORBA.portable.InputStream;
34  import org.omg.CORBA.portable.OutputStream;
35  import org.omg.CORBA.portable.StreamableValue;
36  import org.omg.PortableInterceptor.ObjectReferenceFactory;
37  import org.omg.PortableInterceptor.ObjectReferenceFactoryHelper;
38  
39  /**
40   * This is an implementation of the ObjectReferenceFactory abstract value type defined by the portable interceptors IDL.
41   * Note that this is a direct Java implementation of the abstract value type: there is no stateful value type defined in
42   * IDL, since defining the state in IDL is awkward and inefficient. The best way to define the state is to use internal
43   * data structures that can be written to and read from CORBA streams.
44   */
45  public class ObjectReferenceFactoryImpl extends ObjectReferenceProducerBase
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/ObjectReferenceTemplateImpl.java
      * Line Number: 103
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
 93      public TypeCode _type()
 94      {
 95          return ObjectReferenceTemplateHelper.type();
 96      }
 97  
 98      /**
 99       * Read the data into a (presumably) empty ORTImpl. This sets the orb to the ORB of the InputStream.
100       */
101      public void _read(InputStream is)
102      {
103          org.omg.CORBA_2_3.portable.InputStream istr = (org.omg.CORBA_2_3.portable.InputStream) is;
104          iorTemplate = IORFactories.makeIORTemplate(istr);
105          orb = (ORB) (istr.orb());
106      }
107  
108      /**
109       * Write the state to the OutputStream.
110       */
111      public void _write(OutputStream os)
112      {
113          org.omg.CORBA_2_3.portable.OutputStream ostr = (org.omg.CORBA_2_3.portable.OutputStream) os;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/ObjectReferenceTemplateImpl.java
      * Line Number: 113
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
103          org.omg.CORBA_2_3.portable.InputStream istr = (org.omg.CORBA_2_3.portable.InputStream) is;
104          iorTemplate = IORFactories.makeIORTemplate(istr);
105          orb = (ORB) (istr.orb());
106      }
107  
108      /**
109       * Write the state to the OutputStream.
110       */
111      public void _write(OutputStream os)
112      {
113          org.omg.CORBA_2_3.portable.OutputStream ostr = (org.omg.CORBA_2_3.portable.OutputStream) os;
114  
115          iorTemplate.write(ostr);
116      }
117  
118      public String server_id()
119      {
120          int val = iorTemplate.getObjectKeyTemplate().getServerId();
121          return Integer.toString(val);
122      }
123  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/ObjectReferenceTemplateImpl.java
      * Line Number: 34
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.ior;
27  
28  import org.jboss.com.sun.corba.se.spi.ior.IORFactories;
29  import org.jboss.com.sun.corba.se.spi.ior.IORFactory;
30  import org.jboss.com.sun.corba.se.spi.ior.IORTemplate;
31  import org.jboss.com.sun.corba.se.spi.ior.IORTemplateList;
32  import org.jboss.com.sun.corba.se.spi.ior.ObjectAdapterId;
33  import org.jboss.com.sun.corba.se.spi.orb.ORB;
34  import org.omg.CORBA.TypeCode;
35  import org.omg.CORBA.portable.InputStream;
36  import org.omg.CORBA.portable.OutputStream;
37  import org.omg.CORBA.portable.StreamableValue;
38  import org.omg.PortableInterceptor.ObjectReferenceTemplate;
39  import org.omg.PortableInterceptor.ObjectReferenceTemplateHelper;
40  
41  /**
42   * This is an implementation of the ObjectReferenceTemplate abstract value type defined by the portable interceptors
43   * IDL. Note that this is a direct Java implementation of the abstract value type: there is no stateful value type
44   * defined in IDL, since defining the state in IDL is awkward and inefficient. The best way to define the state is to
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/ObjectReferenceTemplateImpl.java
      * Line Number: 35
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
25  
26  package org.jboss.com.sun.corba.se.impl.ior;
27  
28  import org.jboss.com.sun.corba.se.spi.ior.IORFactories;
29  import org.jboss.com.sun.corba.se.spi.ior.IORFactory;
30  import org.jboss.com.sun.corba.se.spi.ior.IORTemplate;
31  import org.jboss.com.sun.corba.se.spi.ior.IORTemplateList;
32  import org.jboss.com.sun.corba.se.spi.ior.ObjectAdapterId;
33  import org.jboss.com.sun.corba.se.spi.orb.ORB;
34  import org.omg.CORBA.TypeCode;
35  import org.omg.CORBA.portable.InputStream;
36  import org.omg.CORBA.portable.OutputStream;
37  import org.omg.CORBA.portable.StreamableValue;
38  import org.omg.PortableInterceptor.ObjectReferenceTemplate;
39  import org.omg.PortableInterceptor.ObjectReferenceTemplateHelper;
40  
41  /**
42   * This is an implementation of the ObjectReferenceTemplate abstract value type defined by the portable interceptors
43   * IDL. Note that this is a direct Java implementation of the abstract value type: there is no stateful value type
44   * defined in IDL, since defining the state in IDL is awkward and inefficient. The best way to define the state is to
45   * use internal data structures that can be written to and read from CORBA streams.
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/ObjectReferenceTemplateImpl.java
      * Line Number: 36
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
26  package org.jboss.com.sun.corba.se.impl.ior;
27  
28  import org.jboss.com.sun.corba.se.spi.ior.IORFactories;
29  import org.jboss.com.sun.corba.se.spi.ior.IORFactory;
30  import org.jboss.com.sun.corba.se.spi.ior.IORTemplate;
31  import org.jboss.com.sun.corba.se.spi.ior.IORTemplateList;
32  import org.jboss.com.sun.corba.se.spi.ior.ObjectAdapterId;
33  import org.jboss.com.sun.corba.se.spi.orb.ORB;
34  import org.omg.CORBA.TypeCode;
35  import org.omg.CORBA.portable.InputStream;
36  import org.omg.CORBA.portable.OutputStream;
37  import org.omg.CORBA.portable.StreamableValue;
38  import org.omg.PortableInterceptor.ObjectReferenceTemplate;
39  import org.omg.PortableInterceptor.ObjectReferenceTemplateHelper;
40  
41  /**
42   * This is an implementation of the ObjectReferenceTemplate abstract value type defined by the portable interceptors
43   * IDL. Note that this is a direct Java implementation of the abstract value type: there is no stateful value type
44   * defined in IDL, since defining the state in IDL is awkward and inefficient. The best way to define the state is to
45   * use internal data structures that can be written to and read from CORBA streams.
46   */
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/ObjectReferenceTemplateImpl.java
      * Line Number: 37
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
27  
28  import org.jboss.com.sun.corba.se.spi.ior.IORFactories;
29  import org.jboss.com.sun.corba.se.spi.ior.IORFactory;
30  import org.jboss.com.sun.corba.se.spi.ior.IORTemplate;
31  import org.jboss.com.sun.corba.se.spi.ior.IORTemplateList;
32  import org.jboss.com.sun.corba.se.spi.ior.ObjectAdapterId;
33  import org.jboss.com.sun.corba.se.spi.orb.ORB;
34  import org.omg.CORBA.TypeCode;
35  import org.omg.CORBA.portable.InputStream;
36  import org.omg.CORBA.portable.OutputStream;
37  import org.omg.CORBA.portable.StreamableValue;
38  import org.omg.PortableInterceptor.ObjectReferenceTemplate;
39  import org.omg.PortableInterceptor.ObjectReferenceTemplateHelper;
40  
41  /**
42   * This is an implementation of the ObjectReferenceTemplate abstract value type defined by the portable interceptors
43   * IDL. Note that this is a direct Java implementation of the abstract value type: there is no stateful value type
44   * defined in IDL, since defining the state in IDL is awkward and inefficient. The best way to define the state is to
45   * use internal data structures that can be written to and read from CORBA streams.
46   */
47  public class ObjectReferenceTemplateImpl extends ObjectReferenceProducerBase
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/OldJIDLObjectKeyTemplate.java
      * Line Number: 32
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
22   * or visit www.oracle.com if you need additional information or have any
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.ior;
27  
28  import org.jboss.com.sun.corba.se.impl.encoding.CDRInputStream;
29  import org.jboss.com.sun.corba.se.spi.ior.ObjectId;
30  import org.jboss.com.sun.corba.se.spi.orb.ORB;
31  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
32  import org.omg.CORBA.OctetSeqHolder;
33  import org.omg.CORBA_2_3.portable.InputStream;
34  import org.omg.CORBA_2_3.portable.OutputStream;
35  
36  /**
37   * Handles object keys created by JDK ORBs from before JDK 1.4.0.
38   */
39  public final class OldJIDLObjectKeyTemplate extends OldObjectKeyTemplateBase
40  {
41      /**
42       * JDK 1.3.1 FCS did not include a version byte at the end of its object keys. JDK 1.3.1_01 included the byte with
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/OldJIDLObjectKeyTemplate.java
      * Line Number: 33
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.ior;
27  
28  import org.jboss.com.sun.corba.se.impl.encoding.CDRInputStream;
29  import org.jboss.com.sun.corba.se.spi.ior.ObjectId;
30  import org.jboss.com.sun.corba.se.spi.orb.ORB;
31  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
32  import org.omg.CORBA.OctetSeqHolder;
33  import org.omg.CORBA_2_3.portable.InputStream;
34  import org.omg.CORBA_2_3.portable.OutputStream;
35  
36  /**
37   * Handles object keys created by JDK ORBs from before JDK 1.4.0.
38   */
39  public final class OldJIDLObjectKeyTemplate extends OldObjectKeyTemplateBase
40  {
41      /**
42       * JDK 1.3.1 FCS did not include a version byte at the end of its object keys. JDK 1.3.1_01 included the byte with
43       * the value 1. Anything below 1 is considered an invalid value.
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/OldJIDLObjectKeyTemplate.java
      * Line Number: 34
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.ior;
27  
28  import org.jboss.com.sun.corba.se.impl.encoding.CDRInputStream;
29  import org.jboss.com.sun.corba.se.spi.ior.ObjectId;
30  import org.jboss.com.sun.corba.se.spi.orb.ORB;
31  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
32  import org.omg.CORBA.OctetSeqHolder;
33  import org.omg.CORBA_2_3.portable.InputStream;
34  import org.omg.CORBA_2_3.portable.OutputStream;
35  
36  /**
37   * Handles object keys created by JDK ORBs from before JDK 1.4.0.
38   */
39  public final class OldJIDLObjectKeyTemplate extends OldObjectKeyTemplateBase
40  {
41      /**
42       * JDK 1.3.1 FCS did not include a version byte at the end of its object keys. JDK 1.3.1_01 included the byte with
43       * the value 1. Anything below 1 is considered an invalid value.
44       */
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/OldPOAObjectKeyTemplate.java
      * Line Number: 28
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
18   * 2 along with this work; if not, write to the Free Software Foundation,
19   * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
20   *
21   * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
22   * or visit www.oracle.com if you need additional information or have any
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.ior;
27  
28  import org.omg.CORBA.INTERNAL;
29  import org.omg.CORBA.OctetSeqHolder;
30  
31  import org.omg.CORBA_2_3.portable.InputStream;
32  import org.omg.CORBA_2_3.portable.OutputStream;
33  
34  import org.jboss.com.sun.corba.se.spi.orb.ORB;
35  import org.jboss.com.sun.corba.se.spi.orb.ORBVersion;
36  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
37  
38  import org.jboss.com.sun.corba.se.impl.ior.ObjectKeyFactoryImpl;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/OldPOAObjectKeyTemplate.java
      * Line Number: 29
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
19   * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
20   *
21   * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
22   * or visit www.oracle.com if you need additional information or have any
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.ior;
27  
28  import org.omg.CORBA.INTERNAL;
29  import org.omg.CORBA.OctetSeqHolder;
30  
31  import org.omg.CORBA_2_3.portable.InputStream;
32  import org.omg.CORBA_2_3.portable.OutputStream;
33  
34  import org.jboss.com.sun.corba.se.spi.orb.ORB;
35  import org.jboss.com.sun.corba.se.spi.orb.ORBVersion;
36  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
37  
38  import org.jboss.com.sun.corba.se.impl.ior.ObjectKeyFactoryImpl;
39  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/OldPOAObjectKeyTemplate.java
      * Line Number: 31
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
21   * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
22   * or visit www.oracle.com if you need additional information or have any
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.ior;
27  
28  import org.omg.CORBA.INTERNAL;
29  import org.omg.CORBA.OctetSeqHolder;
30  
31  import org.omg.CORBA_2_3.portable.InputStream;
32  import org.omg.CORBA_2_3.portable.OutputStream;
33  
34  import org.jboss.com.sun.corba.se.spi.orb.ORB;
35  import org.jboss.com.sun.corba.se.spi.orb.ORBVersion;
36  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
37  
38  import org.jboss.com.sun.corba.se.impl.ior.ObjectKeyFactoryImpl;
39  
40  /**
41   * @author Ken Cavanaugh
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/OldPOAObjectKeyTemplate.java
      * Line Number: 32
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
22   * or visit www.oracle.com if you need additional information or have any
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.ior;
27  
28  import org.omg.CORBA.INTERNAL;
29  import org.omg.CORBA.OctetSeqHolder;
30  
31  import org.omg.CORBA_2_3.portable.InputStream;
32  import org.omg.CORBA_2_3.portable.OutputStream;
33  
34  import org.jboss.com.sun.corba.se.spi.orb.ORB;
35  import org.jboss.com.sun.corba.se.spi.orb.ORBVersion;
36  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
37  
38  import org.jboss.com.sun.corba.se.impl.ior.ObjectKeyFactoryImpl;
39  
40  /**
41   * @author Ken Cavanaugh
42   */
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/POAObjectKeyTemplate.java
      * Line Number: 32
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
22   * or visit www.oracle.com if you need additional information or have any
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.ior;
27  
28  import org.jboss.com.sun.corba.se.spi.activation.POANameHelper;
29  import org.jboss.com.sun.corba.se.spi.ior.ObjectAdapterId;
30  import org.jboss.com.sun.corba.se.spi.orb.ORB;
31  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
32  import org.omg.CORBA.OctetSeqHolder;
33  import org.omg.CORBA_2_3.portable.InputStream;
34  import org.omg.CORBA_2_3.portable.OutputStream;
35  
36  /**
37   * @author
38   */
39  public final class POAObjectKeyTemplate extends NewObjectKeyTemplateBase
40  {
41      /**
42       * This constructor reads the template ONLY from the stream.
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/POAObjectKeyTemplate.java
      * Line Number: 33
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.ior;
27  
28  import org.jboss.com.sun.corba.se.spi.activation.POANameHelper;
29  import org.jboss.com.sun.corba.se.spi.ior.ObjectAdapterId;
30  import org.jboss.com.sun.corba.se.spi.orb.ORB;
31  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
32  import org.omg.CORBA.OctetSeqHolder;
33  import org.omg.CORBA_2_3.portable.InputStream;
34  import org.omg.CORBA_2_3.portable.OutputStream;
35  
36  /**
37   * @author
38   */
39  public final class POAObjectKeyTemplate extends NewObjectKeyTemplateBase
40  {
41      /**
42       * This constructor reads the template ONLY from the stream.
43       */
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/POAObjectKeyTemplate.java
      * Line Number: 34
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.ior;
27  
28  import org.jboss.com.sun.corba.se.spi.activation.POANameHelper;
29  import org.jboss.com.sun.corba.se.spi.ior.ObjectAdapterId;
30  import org.jboss.com.sun.corba.se.spi.orb.ORB;
31  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
32  import org.omg.CORBA.OctetSeqHolder;
33  import org.omg.CORBA_2_3.portable.InputStream;
34  import org.omg.CORBA_2_3.portable.OutputStream;
35  
36  /**
37   * @author
38   */
39  public final class POAObjectKeyTemplate extends NewObjectKeyTemplateBase
40  {
41      /**
42       * This constructor reads the template ONLY from the stream.
43       */
44      public POAObjectKeyTemplate(ORB orb, int magic, int scid, InputStream is)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/StubIORImpl.java
      * Line Number: 115
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
105          for (int i = 0; i < profileTags.length; i++)
106          {
107              ostr.write_long(profileTags[i]);
108              ostr.write_long(profileData[i].length);
109              ostr.write_octet_array(profileData[i], 0, profileData[i].length);
110          }
111  
112          InputStream istr = ostr.create_input_stream();
113  
114          // read the IOR back from the stream
115          org.omg.CORBA.Object obj = istr.read_Object();
116          return StubAdapter.getDelegate(obj);
117      }
118  
119      public void doRead(java.io.ObjectInputStream stream) throws IOException, ClassNotFoundException
120      {
121          // read the IOR from the ObjectInputStream
122          int typeLength = stream.readInt();
123          typeData = new byte[typeLength];
124          stream.readFully(typeData);
125          int numProfiles = stream.readInt();
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/StubIORImpl.java
      * Line Number: 37
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
27   * RMI-IIOP v1.0
28   * Copyright IBM Corp. 1998 1999  All Rights Reserved
29   *
30   */
31  
32  package org.jboss.com.sun.corba.se.impl.ior;
33  
34  import java.io.IOException;
35  import java.io.ObjectOutputStream;
36  
37  import org.omg.CORBA.ORB;
38  import org.omg.CORBA.portable.Delegate;
39  import org.omg.CORBA.portable.InputStream;
40  import org.omg.CORBA.portable.OutputStream;
41  
42  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
43  
44  /**
45   * This class implements a very simply IOR representation which must be completely ORBImpl free so that this class can
46   * be used in the implementation of a portable StubDelegateImpl.
47   */
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/StubIORImpl.java
      * Line Number: 38
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
28   * Copyright IBM Corp. 1998 1999  All Rights Reserved
29   *
30   */
31  
32  package org.jboss.com.sun.corba.se.impl.ior;
33  
34  import java.io.IOException;
35  import java.io.ObjectOutputStream;
36  
37  import org.omg.CORBA.ORB;
38  import org.omg.CORBA.portable.Delegate;
39  import org.omg.CORBA.portable.InputStream;
40  import org.omg.CORBA.portable.OutputStream;
41  
42  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
43  
44  /**
45   * This class implements a very simply IOR representation which must be completely ORBImpl free so that this class can
46   * be used in the implementation of a portable StubDelegateImpl.
47   */
48  public class StubIORImpl
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/StubIORImpl.java
      * Line Number: 39
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
29   *
30   */
31  
32  package org.jboss.com.sun.corba.se.impl.ior;
33  
34  import java.io.IOException;
35  import java.io.ObjectOutputStream;
36  
37  import org.omg.CORBA.ORB;
38  import org.omg.CORBA.portable.Delegate;
39  import org.omg.CORBA.portable.InputStream;
40  import org.omg.CORBA.portable.OutputStream;
41  
42  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
43  
44  /**
45   * This class implements a very simply IOR representation which must be completely ORBImpl free so that this class can
46   * be used in the implementation of a portable StubDelegateImpl.
47   */
48  public class StubIORImpl
49  {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/StubIORImpl.java
      * Line Number: 40
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
30   */
31  
32  package org.jboss.com.sun.corba.se.impl.ior;
33  
34  import java.io.IOException;
35  import java.io.ObjectOutputStream;
36  
37  import org.omg.CORBA.ORB;
38  import org.omg.CORBA.portable.Delegate;
39  import org.omg.CORBA.portable.InputStream;
40  import org.omg.CORBA.portable.OutputStream;
41  
42  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
43  
44  /**
45   * This class implements a very simply IOR representation which must be completely ORBImpl free so that this class can
46   * be used in the implementation of a portable StubDelegateImpl.
47   */
48  public class StubIORImpl
49  {
50      // cached hash code
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/StubIORImpl.java
      * Line Number: 76
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
66      }
67  
68      public String getRepositoryId()
69      {
70          if (typeData == null)
71              return null;
72  
73          return new String(typeData);
74      }
75  
76      public StubIORImpl(org.omg.CORBA.Object obj)
77      {
78          // write the IOR to an OutputStream and get an InputStream
79          OutputStream ostr = StubAdapter.getORB(obj).create_output_stream();
80          ostr.write_Object(obj);
81          InputStream istr = ostr.create_input_stream();
82  
83          // read the IOR components back from the stream
84          int typeLength = istr.read_long();
85          typeData = new byte[typeLength];
86          istr.read_octet_array(typeData, 0, typeLength);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/WireObjectKeyTemplate.java
      * Line Number: 39
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
29  import org.jboss.com.sun.corba.se.impl.logging.IORSystemException;
30  import org.jboss.com.sun.corba.se.impl.orbutil.ORBConstants;
31  import org.jboss.com.sun.corba.se.spi.ior.ObjectAdapterId;
32  import org.jboss.com.sun.corba.se.spi.ior.ObjectId;
33  import org.jboss.com.sun.corba.se.spi.ior.ObjectKeyTemplate;
34  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
35  import org.jboss.com.sun.corba.se.spi.orb.ORB;
36  import org.jboss.com.sun.corba.se.spi.orb.ORBVersion;
37  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
38  import org.jboss.com.sun.corba.se.spi.protocol.CorbaServerRequestDispatcher;
39  import org.omg.CORBA.OctetSeqHolder;
40  import org.omg.CORBA_2_3.portable.InputStream;
41  import org.omg.CORBA_2_3.portable.OutputStream;
42  
43  /**
44   * @author Ken Cavanaugh
45   */
46  public class WireObjectKeyTemplate implements ObjectKeyTemplate
47  {
48      private IORSystemException wrapper;
49  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/WireObjectKeyTemplate.java
      * Line Number: 40
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
30  import org.jboss.com.sun.corba.se.impl.orbutil.ORBConstants;
31  import org.jboss.com.sun.corba.se.spi.ior.ObjectAdapterId;
32  import org.jboss.com.sun.corba.se.spi.ior.ObjectId;
33  import org.jboss.com.sun.corba.se.spi.ior.ObjectKeyTemplate;
34  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
35  import org.jboss.com.sun.corba.se.spi.orb.ORB;
36  import org.jboss.com.sun.corba.se.spi.orb.ORBVersion;
37  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
38  import org.jboss.com.sun.corba.se.spi.protocol.CorbaServerRequestDispatcher;
39  import org.omg.CORBA.OctetSeqHolder;
40  import org.omg.CORBA_2_3.portable.InputStream;
41  import org.omg.CORBA_2_3.portable.OutputStream;
42  
43  /**
44   * @author Ken Cavanaugh
45   */
46  public class WireObjectKeyTemplate implements ObjectKeyTemplate
47  {
48      private IORSystemException wrapper;
49  
50      public boolean equals(Object obj)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/WireObjectKeyTemplate.java
      * Line Number: 41
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
31  import org.jboss.com.sun.corba.se.spi.ior.ObjectAdapterId;
32  import org.jboss.com.sun.corba.se.spi.ior.ObjectId;
33  import org.jboss.com.sun.corba.se.spi.ior.ObjectKeyTemplate;
34  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
35  import org.jboss.com.sun.corba.se.spi.orb.ORB;
36  import org.jboss.com.sun.corba.se.spi.orb.ORBVersion;
37  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
38  import org.jboss.com.sun.corba.se.spi.protocol.CorbaServerRequestDispatcher;
39  import org.omg.CORBA.OctetSeqHolder;
40  import org.omg.CORBA_2_3.portable.InputStream;
41  import org.omg.CORBA_2_3.portable.OutputStream;
42  
43  /**
44   * @author Ken Cavanaugh
45   */
46  public class WireObjectKeyTemplate implements ObjectKeyTemplate
47  {
48      private IORSystemException wrapper;
49  
50      public boolean equals(Object obj)
51      {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/iiop/IIOPAddressBase.java
      * Line Number: 29
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
19   * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
20   *
21   * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
22   * or visit www.oracle.com if you need additional information or have any
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.ior.iiop;
27  
28  import org.jboss.com.sun.corba.se.spi.ior.iiop.IIOPAddress;
29  import org.omg.CORBA_2_3.portable.OutputStream;
30  
31  /**
32   * @author
33   */
34  abstract class IIOPAddressBase implements IIOPAddress
35  {
36      // Ports are marshalled as shorts on the wire. The IDL type is unsigned short, which lacks a convenient
37      // representation in Java in the 32768-65536 range. So, we treat ports as ints throught this code, except that
38      // marshalling requires a scaling conversion. intToShort and shortToInt are provided for this purpose.
39      protected short intToShort(int value)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/iiop/IIOPAddressImpl.java
      * Line Number: 31
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
21   * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
22   * or visit www.oracle.com if you need additional information or have any
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.ior.iiop;
27  
28  import org.jboss.com.sun.corba.se.impl.logging.IORSystemException;
29  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
30  import org.jboss.com.sun.corba.se.spi.orb.ORB;
31  import org.omg.CORBA_2_3.portable.InputStream;
32  
33  /**
34   * @author
35   */
36  public final class IIOPAddressImpl extends IIOPAddressBase
37  {
38      private IORSystemException wrapper;
39  
40      private String host;
41  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/iiop/IIOPProfileImpl.java
      * Line Number: 55
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
45  import org.jboss.com.sun.corba.se.spi.ior.iiop.IIOPFactories;
46  import org.jboss.com.sun.corba.se.spi.ior.iiop.IIOPProfile;
47  import org.jboss.com.sun.corba.se.spi.ior.iiop.IIOPProfileTemplate;
48  import org.jboss.com.sun.corba.se.spi.ior.iiop.JavaCodebaseComponent;
49  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
50  import org.jboss.com.sun.corba.se.spi.oa.ObjectAdapter;
51  import org.jboss.com.sun.corba.se.spi.oa.ObjectAdapterFactory;
52  import org.jboss.com.sun.corba.se.spi.orb.ORB;
53  import org.jboss.com.sun.corba.se.spi.orb.ORBVersion;
54  import org.jboss.com.sun.corba.se.spi.protocol.RequestDispatcherRegistry;
55  import org.omg.CORBA.SystemException;
56  import org.omg.CORBA_2_3.portable.InputStream;
57  import org.omg.CORBA_2_3.portable.OutputStream;
58  import org.omg.IOP.TAG_INTERNET_IOP;
59  import org.omg.IOP.TAG_JAVA_CODEBASE;
60  
61  /**
62   * @author
63   */
64  public class IIOPProfileImpl extends IdentifiableBase implements IIOPProfile
65  {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/iiop/IIOPProfileImpl.java
      * Line Number: 56
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
46  import org.jboss.com.sun.corba.se.spi.ior.iiop.IIOPProfile;
47  import org.jboss.com.sun.corba.se.spi.ior.iiop.IIOPProfileTemplate;
48  import org.jboss.com.sun.corba.se.spi.ior.iiop.JavaCodebaseComponent;
49  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
50  import org.jboss.com.sun.corba.se.spi.oa.ObjectAdapter;
51  import org.jboss.com.sun.corba.se.spi.oa.ObjectAdapterFactory;
52  import org.jboss.com.sun.corba.se.spi.orb.ORB;
53  import org.jboss.com.sun.corba.se.spi.orb.ORBVersion;
54  import org.jboss.com.sun.corba.se.spi.protocol.RequestDispatcherRegistry;
55  import org.omg.CORBA.SystemException;
56  import org.omg.CORBA_2_3.portable.InputStream;
57  import org.omg.CORBA_2_3.portable.OutputStream;
58  import org.omg.IOP.TAG_INTERNET_IOP;
59  import org.omg.IOP.TAG_JAVA_CODEBASE;
60  
61  /**
62   * @author
63   */
64  public class IIOPProfileImpl extends IdentifiableBase implements IIOPProfile
65  {
66      private ORB orb;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/iiop/IIOPProfileImpl.java
      * Line Number: 57
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
47  import org.jboss.com.sun.corba.se.spi.ior.iiop.IIOPProfileTemplate;
48  import org.jboss.com.sun.corba.se.spi.ior.iiop.JavaCodebaseComponent;
49  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
50  import org.jboss.com.sun.corba.se.spi.oa.ObjectAdapter;
51  import org.jboss.com.sun.corba.se.spi.oa.ObjectAdapterFactory;
52  import org.jboss.com.sun.corba.se.spi.orb.ORB;
53  import org.jboss.com.sun.corba.se.spi.orb.ORBVersion;
54  import org.jboss.com.sun.corba.se.spi.protocol.RequestDispatcherRegistry;
55  import org.omg.CORBA.SystemException;
56  import org.omg.CORBA_2_3.portable.InputStream;
57  import org.omg.CORBA_2_3.portable.OutputStream;
58  import org.omg.IOP.TAG_INTERNET_IOP;
59  import org.omg.IOP.TAG_JAVA_CODEBASE;
60  
61  /**
62   * @author
63   */
64  public class IIOPProfileImpl extends IdentifiableBase implements IIOPProfile
65  {
66      private ORB orb;
67  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/iiop/IIOPProfileTemplateImpl.java
      * Line Number: 41
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
31  import org.jboss.com.sun.corba.se.spi.ior.ObjectId;
32  import org.jboss.com.sun.corba.se.spi.ior.ObjectKeyTemplate;
33  import org.jboss.com.sun.corba.se.spi.ior.TaggedProfile;
34  import org.jboss.com.sun.corba.se.spi.ior.TaggedProfileTemplate;
35  import org.jboss.com.sun.corba.se.spi.ior.TaggedProfileTemplateBase;
36  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
37  import org.jboss.com.sun.corba.se.spi.ior.iiop.IIOPAddress;
38  import org.jboss.com.sun.corba.se.spi.ior.iiop.IIOPFactories;
39  import org.jboss.com.sun.corba.se.spi.ior.iiop.IIOPProfileTemplate;
40  import org.jboss.com.sun.corba.se.spi.orb.ORB;
41  import org.omg.CORBA_2_3.portable.InputStream;
42  import org.omg.CORBA_2_3.portable.OutputStream;
43  import org.omg.IOP.TAG_INTERNET_IOP;
44  
45  /**
46   * @author If getMinorVersion==0, this does not contain any tagged components
47   */
48  public class IIOPProfileTemplateImpl extends TaggedProfileTemplateBase implements IIOPProfileTemplate
49  {
50      private ORB orb;
51  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/iiop/IIOPProfileTemplateImpl.java
      * Line Number: 42
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
32  import org.jboss.com.sun.corba.se.spi.ior.ObjectKeyTemplate;
33  import org.jboss.com.sun.corba.se.spi.ior.TaggedProfile;
34  import org.jboss.com.sun.corba.se.spi.ior.TaggedProfileTemplate;
35  import org.jboss.com.sun.corba.se.spi.ior.TaggedProfileTemplateBase;
36  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
37  import org.jboss.com.sun.corba.se.spi.ior.iiop.IIOPAddress;
38  import org.jboss.com.sun.corba.se.spi.ior.iiop.IIOPFactories;
39  import org.jboss.com.sun.corba.se.spi.ior.iiop.IIOPProfileTemplate;
40  import org.jboss.com.sun.corba.se.spi.orb.ORB;
41  import org.omg.CORBA_2_3.portable.InputStream;
42  import org.omg.CORBA_2_3.portable.OutputStream;
43  import org.omg.IOP.TAG_INTERNET_IOP;
44  
45  /**
46   * @author If getMinorVersion==0, this does not contain any tagged components
47   */
48  public class IIOPProfileTemplateImpl extends TaggedProfileTemplateBase implements IIOPProfileTemplate
49  {
50      private ORB orb;
51  
52      private GIOPVersion giopVersion;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/iiop/JavaCodebaseComponentImpl.java
      * Line Number: 30
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
20   *
21   * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
22   * or visit www.oracle.com if you need additional information or have any
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.ior.iiop;
27  
28  import org.jboss.com.sun.corba.se.spi.ior.TaggedComponentBase;
29  import org.jboss.com.sun.corba.se.spi.ior.iiop.JavaCodebaseComponent;
30  import org.omg.CORBA_2_3.portable.OutputStream;
31  import org.omg.IOP.TAG_JAVA_CODEBASE;
32  
33  /**
34   * @author
35   */
36  public class JavaCodebaseComponentImpl extends TaggedComponentBase implements JavaCodebaseComponent
37  {
38      private String URLs;
39  
40      public boolean equals(Object obj)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/iiop/JavaSerializationComponent.java
      * Line Number: 30
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
20   *
21   * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
22   * or visit www.oracle.com if you need additional information or have any
23   * questions.
24   */
25  package org.jboss.com.sun.corba.se.impl.ior.iiop;
26  
27  import org.jboss.com.sun.corba.se.impl.orbutil.ORBConstants;
28  import org.jboss.com.sun.corba.se.impl.protocol.giopmsgheaders.Message;
29  import org.jboss.com.sun.corba.se.spi.ior.TaggedComponentBase;
30  import org.omg.CORBA_2_3.portable.OutputStream;
31  
32  /**
33   * Tagged component that contains a value that indicates the Java serialization version supported by the ORB.
34   * 
35   * ORB Java serialization uses IIOP as the transport protocol, but uses Java serialization mechanism and its
36   * accompanying encodings, instead of IIOP CDR serialization mechanism. Java serialization is generally observed to be
37   * faster than CDR.
38   */
39  public class JavaSerializationComponent extends TaggedComponentBase
40  {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/iiop/MaxStreamFormatVersionComponentImpl.java
      * Line Number: 33
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
23   * questions.
24   */
25  
26  /**
27   */
28  package org.jboss.com.sun.corba.se.impl.ior.iiop;
29  
30  import org.jboss.com.sun.corba.se.impl.orbutil.ORBUtility;
31  import org.jboss.com.sun.corba.se.spi.ior.TaggedComponentBase;
32  import org.jboss.com.sun.corba.se.spi.ior.iiop.MaxStreamFormatVersionComponent;
33  import org.omg.CORBA_2_3.portable.OutputStream;
34  import org.omg.IOP.TAG_RMI_CUSTOM_MAX_STREAM_FORMAT;
35  
36  // Java to IDL ptc 02-01-12 1.4.11
37  // TAG_RMI_CUSTOM_MAX_STREAM_FORMAT
38  public class MaxStreamFormatVersionComponentImpl extends TaggedComponentBase implements MaxStreamFormatVersionComponent
39  {
40      private byte version;
41  
42      public static final MaxStreamFormatVersionComponentImpl singleton = new MaxStreamFormatVersionComponentImpl();
43  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/iiop/ORBTypeComponentImpl.java
      * Line Number: 30
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
20   *
21   * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
22   * or visit www.oracle.com if you need additional information or have any
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.ior.iiop;
27  
28  import org.jboss.com.sun.corba.se.spi.ior.TaggedComponentBase;
29  import org.jboss.com.sun.corba.se.spi.ior.iiop.ORBTypeComponent;
30  import org.omg.CORBA_2_3.portable.OutputStream;
31  import org.omg.IOP.TAG_ORB_TYPE;
32  
33  /**
34   * @author Ken Cavanaugh
35   */
36  public class ORBTypeComponentImpl extends TaggedComponentBase implements ORBTypeComponent
37  {
38      private int ORBType;
39  
40      public boolean equals(Object obj)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/ior/iiop/RequestPartitioningComponentImpl.java
      * Line Number: 35
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
25  
26  /**
27   */
28  package org.jboss.com.sun.corba.se.impl.ior.iiop;
29  
30  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
31  import org.jboss.com.sun.corba.se.impl.orbutil.ORBConstants;
32  import org.jboss.com.sun.corba.se.spi.ior.TaggedComponentBase;
33  import org.jboss.com.sun.corba.se.spi.ior.iiop.RequestPartitioningComponent;
34  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
35  import org.omg.CORBA_2_3.portable.OutputStream;
36  
37  public class RequestPartitioningComponentImpl extends TaggedComponentBase implements RequestPartitioningComponent
38  {
39      private static ORBUtilSystemException wrapper = ORBUtilSystemException.get(CORBALogDomains.OA_IOR);
40  
41      private int partitionToUse;
42  
43      public boolean equals(Object obj)
44      {
45          if (!(obj instanceof RequestPartitioningComponentImpl))
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/javax/rmi/CORBA/Util.java
      * Line Number: 88
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/javax/rmi/CORBA/Util.java
      * Line Number: 121
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/javax/rmi/CORBA/Util.java
      * Line Number: 328
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/javax/rmi/CORBA/Util.java
      * Line Number: 330
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/javax/rmi/CORBA/Util.java
      * Line Number: 338
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/javax/rmi/CORBA/Util.java
      * Line Number: 340
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/javax/rmi/CORBA/Util.java
      * Line Number: 386
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/javax/rmi/CORBA/Util.java
      * Line Number: 408
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/javax/rmi/CORBA/Util.java
      * Line Number: 466
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/javax/rmi/CORBA/Util.java
      * Line Number: 486
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/javax/rmi/CORBA/Util.java
      * Line Number: 550
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/javax/rmi/CORBA/Util.java
      * Line Number: 669
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/javax/rmi/CORBA/Util.java
      * Line Number: 741
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/javax/rmi/CORBA/Util.java
      * Line Number: 773
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/javax/rmi/CORBA/Util.java
      * Line Number: 805
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/javax/rmi/CORBA/Util.java
      * Line Number: 808
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/javax/rmi/CORBA/Util.java
      * Line Number: 91
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
 81  import org.omg.CORBA.COMM_FAILURE;
 82  import org.omg.CORBA.CompletionStatus;
 83  import org.omg.CORBA.INVALID_ACTIVITY;
 84  import org.omg.CORBA.INVALID_TRANSACTION;
 85  import org.omg.CORBA.INV_OBJREF;
 86  import org.omg.CORBA.MARSHAL;
 87  import org.omg.CORBA.NO_PERMISSION;
 88  import org.omg.CORBA.OBJECT_NOT_EXIST;
 89  import org.omg.CORBA.SystemException;
 90  import org.omg.CORBA.TCKind;
 91  import org.omg.CORBA.TRANSACTION_REQUIRED;
 92  import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
 93  import org.omg.CORBA.TypeCode;
 94  import org.omg.CORBA.portable.InputStream;
 95  import org.omg.CORBA.portable.OutputStream;
 96  import org.omg.CORBA.portable.UnknownException;
 97  
 98  /**
 99   * Provides utility methods that can be used by stubs and ties to perform common operations.
100   */
101  public class Util implements javax.rmi.CORBA.UtilDelegate
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/javax/rmi/CORBA/Util.java
      * Line Number: 92
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
 82  import org.omg.CORBA.CompletionStatus;
 83  import org.omg.CORBA.INVALID_ACTIVITY;
 84  import org.omg.CORBA.INVALID_TRANSACTION;
 85  import org.omg.CORBA.INV_OBJREF;
 86  import org.omg.CORBA.MARSHAL;
 87  import org.omg.CORBA.NO_PERMISSION;
 88  import org.omg.CORBA.OBJECT_NOT_EXIST;
 89  import org.omg.CORBA.SystemException;
 90  import org.omg.CORBA.TCKind;
 91  import org.omg.CORBA.TRANSACTION_REQUIRED;
 92  import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
 93  import org.omg.CORBA.TypeCode;
 94  import org.omg.CORBA.portable.InputStream;
 95  import org.omg.CORBA.portable.OutputStream;
 96  import org.omg.CORBA.portable.UnknownException;
 97  
 98  /**
 99   * Provides utility methods that can be used by stubs and ties to perform common operations.
100   */
101  public class Util implements javax.rmi.CORBA.UtilDelegate
102  {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/javax/rmi/CORBA/Util.java
      * Line Number: 93
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
 83  import org.omg.CORBA.INVALID_ACTIVITY;
 84  import org.omg.CORBA.INVALID_TRANSACTION;
 85  import org.omg.CORBA.INV_OBJREF;
 86  import org.omg.CORBA.MARSHAL;
 87  import org.omg.CORBA.NO_PERMISSION;
 88  import org.omg.CORBA.OBJECT_NOT_EXIST;
 89  import org.omg.CORBA.SystemException;
 90  import org.omg.CORBA.TCKind;
 91  import org.omg.CORBA.TRANSACTION_REQUIRED;
 92  import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
 93  import org.omg.CORBA.TypeCode;
 94  import org.omg.CORBA.portable.InputStream;
 95  import org.omg.CORBA.portable.OutputStream;
 96  import org.omg.CORBA.portable.UnknownException;
 97  
 98  /**
 99   * Provides utility methods that can be used by stubs and ties to perform common operations.
100   */
101  public class Util implements javax.rmi.CORBA.UtilDelegate
102  {
103      // Runs as long as there are exportedServants
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/javax/rmi/CORBA/Util.java
      * Line Number: 94
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
 84  import org.omg.CORBA.INVALID_TRANSACTION;
 85  import org.omg.CORBA.INV_OBJREF;
 86  import org.omg.CORBA.MARSHAL;
 87  import org.omg.CORBA.NO_PERMISSION;
 88  import org.omg.CORBA.OBJECT_NOT_EXIST;
 89  import org.omg.CORBA.SystemException;
 90  import org.omg.CORBA.TCKind;
 91  import org.omg.CORBA.TRANSACTION_REQUIRED;
 92  import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
 93  import org.omg.CORBA.TypeCode;
 94  import org.omg.CORBA.portable.InputStream;
 95  import org.omg.CORBA.portable.OutputStream;
 96  import org.omg.CORBA.portable.UnknownException;
 97  
 98  /**
 99   * Provides utility methods that can be used by stubs and ties to perform common operations.
100   */
101  public class Util implements javax.rmi.CORBA.UtilDelegate
102  {
103      // Runs as long as there are exportedServants
104      private static KeepAlive keepAlive = null;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/javax/rmi/CORBA/Util.java
      * Line Number: 95
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
 85  import org.omg.CORBA.INV_OBJREF;
 86  import org.omg.CORBA.MARSHAL;
 87  import org.omg.CORBA.NO_PERMISSION;
 88  import org.omg.CORBA.OBJECT_NOT_EXIST;
 89  import org.omg.CORBA.SystemException;
 90  import org.omg.CORBA.TCKind;
 91  import org.omg.CORBA.TRANSACTION_REQUIRED;
 92  import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
 93  import org.omg.CORBA.TypeCode;
 94  import org.omg.CORBA.portable.InputStream;
 95  import org.omg.CORBA.portable.OutputStream;
 96  import org.omg.CORBA.portable.UnknownException;
 97  
 98  /**
 99   * Provides utility methods that can be used by stubs and ties to perform common operations.
100   */
101  public class Util implements javax.rmi.CORBA.UtilDelegate
102  {
103      // Runs as long as there are exportedServants
104      private static KeepAlive keepAlive = null;
105  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/javax/rmi/CORBA/Util.java
      * Line Number: 96
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
 86  import org.omg.CORBA.MARSHAL;
 87  import org.omg.CORBA.NO_PERMISSION;
 88  import org.omg.CORBA.OBJECT_NOT_EXIST;
 89  import org.omg.CORBA.SystemException;
 90  import org.omg.CORBA.TCKind;
 91  import org.omg.CORBA.TRANSACTION_REQUIRED;
 92  import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
 93  import org.omg.CORBA.TypeCode;
 94  import org.omg.CORBA.portable.InputStream;
 95  import org.omg.CORBA.portable.OutputStream;
 96  import org.omg.CORBA.portable.UnknownException;
 97  
 98  /**
 99   * Provides utility methods that can be used by stubs and ties to perform common operations.
100   */
101  public class Util implements javax.rmi.CORBA.UtilDelegate
102  {
103      // Runs as long as there are exportedServants
104      private static KeepAlive keepAlive = null;
105  
106      // Maps targets to ties.
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/javax/rmi/CORBA/Util.java
      * Line Number: 76
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
66  import org.jboss.com.sun.corba.se.pept.transport.ContactInfoList;
67  import org.jboss.com.sun.corba.se.spi.copyobject.CopierManager;
68  import org.jboss.com.sun.corba.se.spi.copyobject.ObjectCopier;
69  import org.jboss.com.sun.corba.se.spi.copyobject.ReflectiveCopyException;
70  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
71  import org.jboss.com.sun.corba.se.spi.orb.ORB;
72  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
73  import org.jboss.com.sun.corba.se.spi.protocol.CorbaClientDelegate;
74  import org.jboss.com.sun.corba.se.spi.protocol.LocalClientRequestDispatcher;
75  import org.jboss.com.sun.corba.se.spi.transport.CorbaContactInfoList;
76  import org.omg.CORBA.ACTIVITY_COMPLETED;
77  import org.omg.CORBA.ACTIVITY_REQUIRED;
78  import org.omg.CORBA.Any;
79  import org.omg.CORBA.BAD_OPERATION;
80  import org.omg.CORBA.BAD_PARAM;
81  import org.omg.CORBA.COMM_FAILURE;
82  import org.omg.CORBA.CompletionStatus;
83  import org.omg.CORBA.INVALID_ACTIVITY;
84  import org.omg.CORBA.INVALID_TRANSACTION;
85  import org.omg.CORBA.INV_OBJREF;
86  import org.omg.CORBA.MARSHAL;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/javax/rmi/CORBA/Util.java
      * Line Number: 77
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
67  import org.jboss.com.sun.corba.se.spi.copyobject.CopierManager;
68  import org.jboss.com.sun.corba.se.spi.copyobject.ObjectCopier;
69  import org.jboss.com.sun.corba.se.spi.copyobject.ReflectiveCopyException;
70  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
71  import org.jboss.com.sun.corba.se.spi.orb.ORB;
72  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
73  import org.jboss.com.sun.corba.se.spi.protocol.CorbaClientDelegate;
74  import org.jboss.com.sun.corba.se.spi.protocol.LocalClientRequestDispatcher;
75  import org.jboss.com.sun.corba.se.spi.transport.CorbaContactInfoList;
76  import org.omg.CORBA.ACTIVITY_COMPLETED;
77  import org.omg.CORBA.ACTIVITY_REQUIRED;
78  import org.omg.CORBA.Any;
79  import org.omg.CORBA.BAD_OPERATION;
80  import org.omg.CORBA.BAD_PARAM;
81  import org.omg.CORBA.COMM_FAILURE;
82  import org.omg.CORBA.CompletionStatus;
83  import org.omg.CORBA.INVALID_ACTIVITY;
84  import org.omg.CORBA.INVALID_TRANSACTION;
85  import org.omg.CORBA.INV_OBJREF;
86  import org.omg.CORBA.MARSHAL;
87  import org.omg.CORBA.NO_PERMISSION;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/javax/rmi/CORBA/Util.java
      * Line Number: 78
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
68  import org.jboss.com.sun.corba.se.spi.copyobject.ObjectCopier;
69  import org.jboss.com.sun.corba.se.spi.copyobject.ReflectiveCopyException;
70  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
71  import org.jboss.com.sun.corba.se.spi.orb.ORB;
72  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
73  import org.jboss.com.sun.corba.se.spi.protocol.CorbaClientDelegate;
74  import org.jboss.com.sun.corba.se.spi.protocol.LocalClientRequestDispatcher;
75  import org.jboss.com.sun.corba.se.spi.transport.CorbaContactInfoList;
76  import org.omg.CORBA.ACTIVITY_COMPLETED;
77  import org.omg.CORBA.ACTIVITY_REQUIRED;
78  import org.omg.CORBA.Any;
79  import org.omg.CORBA.BAD_OPERATION;
80  import org.omg.CORBA.BAD_PARAM;
81  import org.omg.CORBA.COMM_FAILURE;
82  import org.omg.CORBA.CompletionStatus;
83  import org.omg.CORBA.INVALID_ACTIVITY;
84  import org.omg.CORBA.INVALID_TRANSACTION;
85  import org.omg.CORBA.INV_OBJREF;
86  import org.omg.CORBA.MARSHAL;
87  import org.omg.CORBA.NO_PERMISSION;
88  import org.omg.CORBA.OBJECT_NOT_EXIST;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/javax/rmi/CORBA/Util.java
      * Line Number: 79
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
69  import org.jboss.com.sun.corba.se.spi.copyobject.ReflectiveCopyException;
70  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
71  import org.jboss.com.sun.corba.se.spi.orb.ORB;
72  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
73  import org.jboss.com.sun.corba.se.spi.protocol.CorbaClientDelegate;
74  import org.jboss.com.sun.corba.se.spi.protocol.LocalClientRequestDispatcher;
75  import org.jboss.com.sun.corba.se.spi.transport.CorbaContactInfoList;
76  import org.omg.CORBA.ACTIVITY_COMPLETED;
77  import org.omg.CORBA.ACTIVITY_REQUIRED;
78  import org.omg.CORBA.Any;
79  import org.omg.CORBA.BAD_OPERATION;
80  import org.omg.CORBA.BAD_PARAM;
81  import org.omg.CORBA.COMM_FAILURE;
82  import org.omg.CORBA.CompletionStatus;
83  import org.omg.CORBA.INVALID_ACTIVITY;
84  import org.omg.CORBA.INVALID_TRANSACTION;
85  import org.omg.CORBA.INV_OBJREF;
86  import org.omg.CORBA.MARSHAL;
87  import org.omg.CORBA.NO_PERMISSION;
88  import org.omg.CORBA.OBJECT_NOT_EXIST;
89  import org.omg.CORBA.SystemException;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/javax/rmi/CORBA/Util.java
      * Line Number: 80
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
70  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
71  import org.jboss.com.sun.corba.se.spi.orb.ORB;
72  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
73  import org.jboss.com.sun.corba.se.spi.protocol.CorbaClientDelegate;
74  import org.jboss.com.sun.corba.se.spi.protocol.LocalClientRequestDispatcher;
75  import org.jboss.com.sun.corba.se.spi.transport.CorbaContactInfoList;
76  import org.omg.CORBA.ACTIVITY_COMPLETED;
77  import org.omg.CORBA.ACTIVITY_REQUIRED;
78  import org.omg.CORBA.Any;
79  import org.omg.CORBA.BAD_OPERATION;
80  import org.omg.CORBA.BAD_PARAM;
81  import org.omg.CORBA.COMM_FAILURE;
82  import org.omg.CORBA.CompletionStatus;
83  import org.omg.CORBA.INVALID_ACTIVITY;
84  import org.omg.CORBA.INVALID_TRANSACTION;
85  import org.omg.CORBA.INV_OBJREF;
86  import org.omg.CORBA.MARSHAL;
87  import org.omg.CORBA.NO_PERMISSION;
88  import org.omg.CORBA.OBJECT_NOT_EXIST;
89  import org.omg.CORBA.SystemException;
90  import org.omg.CORBA.TCKind;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/javax/rmi/CORBA/Util.java
      * Line Number: 81
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
71  import org.jboss.com.sun.corba.se.spi.orb.ORB;
72  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
73  import org.jboss.com.sun.corba.se.spi.protocol.CorbaClientDelegate;
74  import org.jboss.com.sun.corba.se.spi.protocol.LocalClientRequestDispatcher;
75  import org.jboss.com.sun.corba.se.spi.transport.CorbaContactInfoList;
76  import org.omg.CORBA.ACTIVITY_COMPLETED;
77  import org.omg.CORBA.ACTIVITY_REQUIRED;
78  import org.omg.CORBA.Any;
79  import org.omg.CORBA.BAD_OPERATION;
80  import org.omg.CORBA.BAD_PARAM;
81  import org.omg.CORBA.COMM_FAILURE;
82  import org.omg.CORBA.CompletionStatus;
83  import org.omg.CORBA.INVALID_ACTIVITY;
84  import org.omg.CORBA.INVALID_TRANSACTION;
85  import org.omg.CORBA.INV_OBJREF;
86  import org.omg.CORBA.MARSHAL;
87  import org.omg.CORBA.NO_PERMISSION;
88  import org.omg.CORBA.OBJECT_NOT_EXIST;
89  import org.omg.CORBA.SystemException;
90  import org.omg.CORBA.TCKind;
91  import org.omg.CORBA.TRANSACTION_REQUIRED;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/javax/rmi/CORBA/Util.java
      * Line Number: 82
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
72  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
73  import org.jboss.com.sun.corba.se.spi.protocol.CorbaClientDelegate;
74  import org.jboss.com.sun.corba.se.spi.protocol.LocalClientRequestDispatcher;
75  import org.jboss.com.sun.corba.se.spi.transport.CorbaContactInfoList;
76  import org.omg.CORBA.ACTIVITY_COMPLETED;
77  import org.omg.CORBA.ACTIVITY_REQUIRED;
78  import org.omg.CORBA.Any;
79  import org.omg.CORBA.BAD_OPERATION;
80  import org.omg.CORBA.BAD_PARAM;
81  import org.omg.CORBA.COMM_FAILURE;
82  import org.omg.CORBA.CompletionStatus;
83  import org.omg.CORBA.INVALID_ACTIVITY;
84  import org.omg.CORBA.INVALID_TRANSACTION;
85  import org.omg.CORBA.INV_OBJREF;
86  import org.omg.CORBA.MARSHAL;
87  import org.omg.CORBA.NO_PERMISSION;
88  import org.omg.CORBA.OBJECT_NOT_EXIST;
89  import org.omg.CORBA.SystemException;
90  import org.omg.CORBA.TCKind;
91  import org.omg.CORBA.TRANSACTION_REQUIRED;
92  import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/javax/rmi/CORBA/Util.java
      * Line Number: 83
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
73  import org.jboss.com.sun.corba.se.spi.protocol.CorbaClientDelegate;
74  import org.jboss.com.sun.corba.se.spi.protocol.LocalClientRequestDispatcher;
75  import org.jboss.com.sun.corba.se.spi.transport.CorbaContactInfoList;
76  import org.omg.CORBA.ACTIVITY_COMPLETED;
77  import org.omg.CORBA.ACTIVITY_REQUIRED;
78  import org.omg.CORBA.Any;
79  import org.omg.CORBA.BAD_OPERATION;
80  import org.omg.CORBA.BAD_PARAM;
81  import org.omg.CORBA.COMM_FAILURE;
82  import org.omg.CORBA.CompletionStatus;
83  import org.omg.CORBA.INVALID_ACTIVITY;
84  import org.omg.CORBA.INVALID_TRANSACTION;
85  import org.omg.CORBA.INV_OBJREF;
86  import org.omg.CORBA.MARSHAL;
87  import org.omg.CORBA.NO_PERMISSION;
88  import org.omg.CORBA.OBJECT_NOT_EXIST;
89  import org.omg.CORBA.SystemException;
90  import org.omg.CORBA.TCKind;
91  import org.omg.CORBA.TRANSACTION_REQUIRED;
92  import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
93  import org.omg.CORBA.TypeCode;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/javax/rmi/CORBA/Util.java
      * Line Number: 84
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
74  import org.jboss.com.sun.corba.se.spi.protocol.LocalClientRequestDispatcher;
75  import org.jboss.com.sun.corba.se.spi.transport.CorbaContactInfoList;
76  import org.omg.CORBA.ACTIVITY_COMPLETED;
77  import org.omg.CORBA.ACTIVITY_REQUIRED;
78  import org.omg.CORBA.Any;
79  import org.omg.CORBA.BAD_OPERATION;
80  import org.omg.CORBA.BAD_PARAM;
81  import org.omg.CORBA.COMM_FAILURE;
82  import org.omg.CORBA.CompletionStatus;
83  import org.omg.CORBA.INVALID_ACTIVITY;
84  import org.omg.CORBA.INVALID_TRANSACTION;
85  import org.omg.CORBA.INV_OBJREF;
86  import org.omg.CORBA.MARSHAL;
87  import org.omg.CORBA.NO_PERMISSION;
88  import org.omg.CORBA.OBJECT_NOT_EXIST;
89  import org.omg.CORBA.SystemException;
90  import org.omg.CORBA.TCKind;
91  import org.omg.CORBA.TRANSACTION_REQUIRED;
92  import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
93  import org.omg.CORBA.TypeCode;
94  import org.omg.CORBA.portable.InputStream;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/javax/rmi/CORBA/Util.java
      * Line Number: 85
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
75  import org.jboss.com.sun.corba.se.spi.transport.CorbaContactInfoList;
76  import org.omg.CORBA.ACTIVITY_COMPLETED;
77  import org.omg.CORBA.ACTIVITY_REQUIRED;
78  import org.omg.CORBA.Any;
79  import org.omg.CORBA.BAD_OPERATION;
80  import org.omg.CORBA.BAD_PARAM;
81  import org.omg.CORBA.COMM_FAILURE;
82  import org.omg.CORBA.CompletionStatus;
83  import org.omg.CORBA.INVALID_ACTIVITY;
84  import org.omg.CORBA.INVALID_TRANSACTION;
85  import org.omg.CORBA.INV_OBJREF;
86  import org.omg.CORBA.MARSHAL;
87  import org.omg.CORBA.NO_PERMISSION;
88  import org.omg.CORBA.OBJECT_NOT_EXIST;
89  import org.omg.CORBA.SystemException;
90  import org.omg.CORBA.TCKind;
91  import org.omg.CORBA.TRANSACTION_REQUIRED;
92  import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
93  import org.omg.CORBA.TypeCode;
94  import org.omg.CORBA.portable.InputStream;
95  import org.omg.CORBA.portable.OutputStream;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/javax/rmi/CORBA/Util.java
      * Line Number: 86
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
76  import org.omg.CORBA.ACTIVITY_COMPLETED;
77  import org.omg.CORBA.ACTIVITY_REQUIRED;
78  import org.omg.CORBA.Any;
79  import org.omg.CORBA.BAD_OPERATION;
80  import org.omg.CORBA.BAD_PARAM;
81  import org.omg.CORBA.COMM_FAILURE;
82  import org.omg.CORBA.CompletionStatus;
83  import org.omg.CORBA.INVALID_ACTIVITY;
84  import org.omg.CORBA.INVALID_TRANSACTION;
85  import org.omg.CORBA.INV_OBJREF;
86  import org.omg.CORBA.MARSHAL;
87  import org.omg.CORBA.NO_PERMISSION;
88  import org.omg.CORBA.OBJECT_NOT_EXIST;
89  import org.omg.CORBA.SystemException;
90  import org.omg.CORBA.TCKind;
91  import org.omg.CORBA.TRANSACTION_REQUIRED;
92  import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
93  import org.omg.CORBA.TypeCode;
94  import org.omg.CORBA.portable.InputStream;
95  import org.omg.CORBA.portable.OutputStream;
96  import org.omg.CORBA.portable.UnknownException;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/javax/rmi/CORBA/Util.java
      * Line Number: 87
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
77  import org.omg.CORBA.ACTIVITY_REQUIRED;
78  import org.omg.CORBA.Any;
79  import org.omg.CORBA.BAD_OPERATION;
80  import org.omg.CORBA.BAD_PARAM;
81  import org.omg.CORBA.COMM_FAILURE;
82  import org.omg.CORBA.CompletionStatus;
83  import org.omg.CORBA.INVALID_ACTIVITY;
84  import org.omg.CORBA.INVALID_TRANSACTION;
85  import org.omg.CORBA.INV_OBJREF;
86  import org.omg.CORBA.MARSHAL;
87  import org.omg.CORBA.NO_PERMISSION;
88  import org.omg.CORBA.OBJECT_NOT_EXIST;
89  import org.omg.CORBA.SystemException;
90  import org.omg.CORBA.TCKind;
91  import org.omg.CORBA.TRANSACTION_REQUIRED;
92  import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
93  import org.omg.CORBA.TypeCode;
94  import org.omg.CORBA.portable.InputStream;
95  import org.omg.CORBA.portable.OutputStream;
96  import org.omg.CORBA.portable.UnknownException;
97  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/javax/rmi/CORBA/Util.java
      * Line Number: 89
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
79  import org.omg.CORBA.BAD_OPERATION;
80  import org.omg.CORBA.BAD_PARAM;
81  import org.omg.CORBA.COMM_FAILURE;
82  import org.omg.CORBA.CompletionStatus;
83  import org.omg.CORBA.INVALID_ACTIVITY;
84  import org.omg.CORBA.INVALID_TRANSACTION;
85  import org.omg.CORBA.INV_OBJREF;
86  import org.omg.CORBA.MARSHAL;
87  import org.omg.CORBA.NO_PERMISSION;
88  import org.omg.CORBA.OBJECT_NOT_EXIST;
89  import org.omg.CORBA.SystemException;
90  import org.omg.CORBA.TCKind;
91  import org.omg.CORBA.TRANSACTION_REQUIRED;
92  import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
93  import org.omg.CORBA.TypeCode;
94  import org.omg.CORBA.portable.InputStream;
95  import org.omg.CORBA.portable.OutputStream;
96  import org.omg.CORBA.portable.UnknownException;
97  
98  /**
99   * Provides utility methods that can be used by stubs and ties to perform common operations.
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/javax/rmi/CORBA/Util.java
      * Line Number: 90
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
80  import org.omg.CORBA.BAD_PARAM;
81  import org.omg.CORBA.COMM_FAILURE;
82  import org.omg.CORBA.CompletionStatus;
83  import org.omg.CORBA.INVALID_ACTIVITY;
84  import org.omg.CORBA.INVALID_TRANSACTION;
85  import org.omg.CORBA.INV_OBJREF;
86  import org.omg.CORBA.MARSHAL;
87  import org.omg.CORBA.NO_PERMISSION;
88  import org.omg.CORBA.OBJECT_NOT_EXIST;
89  import org.omg.CORBA.SystemException;
90  import org.omg.CORBA.TCKind;
91  import org.omg.CORBA.TRANSACTION_REQUIRED;
92  import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
93  import org.omg.CORBA.TypeCode;
94  import org.omg.CORBA.portable.InputStream;
95  import org.omg.CORBA.portable.OutputStream;
96  import org.omg.CORBA.portable.UnknownException;
97  
98  /**
99   * Provides utility methods that can be used by stubs and ties to perform common operations.
100   */
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/javax/rmi/PortableRemoteObject.java
      * Line Number: 225
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
215          try
216          {
217              if (narrowTo.isAssignableFrom(narrowFrom.getClass()))
218                  return narrowFrom;
219  
220              // Is narrowTo an interface that might be implemented by a servant running on iiop?
221              if (narrowTo.isInterface() && narrowTo != java.io.Serializable.class
222                      && narrowTo != java.io.Externalizable.class)
223              {
224  
225                  org.omg.CORBA.Object narrowObj = (org.omg.CORBA.Object) narrowFrom;
226  
227                  // Create an id from the narrowTo type...
228                  String id = RepositoryId.createForAnyType(narrowTo);
229  
230                  if (narrowObj._is_a(id))
231                  {
232                      return Utility.loadStub(narrowObj, narrowTo);
233                  }
234                  else
235                  {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/javax/rmi/PortableRemoteObject.java
      * Line Number: 44
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
34  import java.rmi.NoSuchObjectException;
35  import java.rmi.Remote;
36  import java.rmi.RemoteException;
37  import java.rmi.server.ExportException;
38  import java.rmi.server.UnicastRemoteObject;
39  
40  import javax.rmi.CORBA.Stub;
41  import javax.rmi.CORBA.Tie;
42  import javax.rmi.CORBA.Util;
43  
44  import org.omg.CORBA.ORB;
45  import org.omg.CORBA.SystemException;
46  
47  import org.jboss.com.sun.corba.se.impl.util.RepositoryId;
48  import org.jboss.com.sun.corba.se.impl.util.Utility;
49  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
50  
51  /**
52   * Server implementation objects may either inherit from javax.rmi.PortableRemoteObject or they may implement a remote
53   * interface and then use the exportObject method to register themselves as a server object. The toStub method takes a
54   * server implementation and returns a stub that can be used to access that server object. The connect method makes a
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/javax/rmi/PortableRemoteObject.java
      * Line Number: 45
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
35  import java.rmi.Remote;
36  import java.rmi.RemoteException;
37  import java.rmi.server.ExportException;
38  import java.rmi.server.UnicastRemoteObject;
39  
40  import javax.rmi.CORBA.Stub;
41  import javax.rmi.CORBA.Tie;
42  import javax.rmi.CORBA.Util;
43  
44  import org.omg.CORBA.ORB;
45  import org.omg.CORBA.SystemException;
46  
47  import org.jboss.com.sun.corba.se.impl.util.RepositoryId;
48  import org.jboss.com.sun.corba.se.impl.util.Utility;
49  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
50  
51  /**
52   * Server implementation objects may either inherit from javax.rmi.PortableRemoteObject or they may implement a remote
53   * interface and then use the exportObject method to register themselves as a server object. The toStub method takes a
54   * server implementation and returns a stub that can be used to access that server object. The connect method makes a
55   * Remote object ready for remote communication. The unexportObject method is used to deregister a server object,
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/IORSystemException.java
      * Line Number: 36
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
26  // Log wrapper class for Sun private system exceptions in group IOR
27  //
28  // Generated by mc.scm version %I%, DO NOT EDIT BY HAND!
29  // Generated from input file src/main/resources/org/jboss/com/sun/corba/se/spi/logging/data/IOR.mc on Wed Feb 02 17:13:17 PST 2011
30  
31  package org.jboss.com.sun.corba.se.impl.logging;
32  
33  import java.util.logging.Level;
34  import java.util.logging.Logger;
35  
36  import org.omg.CORBA.BAD_OPERATION;
37  import org.omg.CORBA.BAD_PARAM;
38  import org.omg.CORBA.CompletionStatus;
39  import org.omg.CORBA.INTERNAL;
40  import org.omg.CORBA.INV_OBJREF;
41  
42  import org.jboss.com.sun.corba.se.impl.util.SUNVMCID;
43  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperBase;
44  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperFactory;
45  import org.jboss.com.sun.corba.se.spi.orb.ORB;
46  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/IORSystemException.java
      * Line Number: 37
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
27  //
28  // Generated by mc.scm version %I%, DO NOT EDIT BY HAND!
29  // Generated from input file src/main/resources/org/jboss/com/sun/corba/se/spi/logging/data/IOR.mc on Wed Feb 02 17:13:17 PST 2011
30  
31  package org.jboss.com.sun.corba.se.impl.logging;
32  
33  import java.util.logging.Level;
34  import java.util.logging.Logger;
35  
36  import org.omg.CORBA.BAD_OPERATION;
37  import org.omg.CORBA.BAD_PARAM;
38  import org.omg.CORBA.CompletionStatus;
39  import org.omg.CORBA.INTERNAL;
40  import org.omg.CORBA.INV_OBJREF;
41  
42  import org.jboss.com.sun.corba.se.impl.util.SUNVMCID;
43  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperBase;
44  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperFactory;
45  import org.jboss.com.sun.corba.se.spi.orb.ORB;
46  
47  public class IORSystemException extends LogWrapperBase
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/IORSystemException.java
      * Line Number: 38
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
28  // Generated by mc.scm version %I%, DO NOT EDIT BY HAND!
29  // Generated from input file src/main/resources/org/jboss/com/sun/corba/se/spi/logging/data/IOR.mc on Wed Feb 02 17:13:17 PST 2011
30  
31  package org.jboss.com.sun.corba.se.impl.logging;
32  
33  import java.util.logging.Level;
34  import java.util.logging.Logger;
35  
36  import org.omg.CORBA.BAD_OPERATION;
37  import org.omg.CORBA.BAD_PARAM;
38  import org.omg.CORBA.CompletionStatus;
39  import org.omg.CORBA.INTERNAL;
40  import org.omg.CORBA.INV_OBJREF;
41  
42  import org.jboss.com.sun.corba.se.impl.util.SUNVMCID;
43  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperBase;
44  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperFactory;
45  import org.jboss.com.sun.corba.se.spi.orb.ORB;
46  
47  public class IORSystemException extends LogWrapperBase
48  {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/IORSystemException.java
      * Line Number: 39
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
29  // Generated from input file src/main/resources/org/jboss/com/sun/corba/se/spi/logging/data/IOR.mc on Wed Feb 02 17:13:17 PST 2011
30  
31  package org.jboss.com.sun.corba.se.impl.logging;
32  
33  import java.util.logging.Level;
34  import java.util.logging.Logger;
35  
36  import org.omg.CORBA.BAD_OPERATION;
37  import org.omg.CORBA.BAD_PARAM;
38  import org.omg.CORBA.CompletionStatus;
39  import org.omg.CORBA.INTERNAL;
40  import org.omg.CORBA.INV_OBJREF;
41  
42  import org.jboss.com.sun.corba.se.impl.util.SUNVMCID;
43  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperBase;
44  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperFactory;
45  import org.jboss.com.sun.corba.se.spi.orb.ORB;
46  
47  public class IORSystemException extends LogWrapperBase
48  {
49  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/IORSystemException.java
      * Line Number: 40
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
30  
31  package org.jboss.com.sun.corba.se.impl.logging;
32  
33  import java.util.logging.Level;
34  import java.util.logging.Logger;
35  
36  import org.omg.CORBA.BAD_OPERATION;
37  import org.omg.CORBA.BAD_PARAM;
38  import org.omg.CORBA.CompletionStatus;
39  import org.omg.CORBA.INTERNAL;
40  import org.omg.CORBA.INV_OBJREF;
41  
42  import org.jboss.com.sun.corba.se.impl.util.SUNVMCID;
43  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperBase;
44  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperFactory;
45  import org.jboss.com.sun.corba.se.spi.orb.ORB;
46  
47  public class IORSystemException extends LogWrapperBase
48  {
49  
50      public IORSystemException(Logger logger)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/OMGSystemException.java
      * Line Number: 41
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/OMGSystemException.java
      * Line Number: 42
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/OMGSystemException.java
      * Line Number: 47
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
11   * This code is distributed in the hope that it will be useful, but WITHOUT
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/OMGSystemException.java
      * Line Number: 49
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
11   * This code is distributed in the hope that it will be useful, but WITHOUT
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/OMGSystemException.java
      * Line Number: 51
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
11   * This code is distributed in the hope that it will be useful, but WITHOUT
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/OMGSystemException.java
      * Line Number: 55
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
11   * This code is distributed in the hope that it will be useful, but WITHOUT
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/OMGSystemException.java
      * Line Number: 39
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
29  // Generated from input file src/main/resources/org/jboss/com/sun/corba/se/spi/logging/data/OMG.mc on Wed Feb 02 17:13:19 PST 2011
30  
31  package org.jboss.com.sun.corba.se.impl.logging;
32  
33  import java.util.logging.Level;
34  import java.util.logging.Logger;
35  
36  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperBase;
37  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperFactory;
38  import org.jboss.com.sun.corba.se.spi.orb.ORB;
39  import org.omg.CORBA.BAD_CONTEXT;
40  import org.omg.CORBA.BAD_INV_ORDER;
41  import org.omg.CORBA.BAD_OPERATION;
42  import org.omg.CORBA.BAD_PARAM;
43  import org.omg.CORBA.BAD_TYPECODE;
44  import org.omg.CORBA.CompletionStatus;
45  import org.omg.CORBA.DATA_CONVERSION;
46  import org.omg.CORBA.IMP_LIMIT;
47  import org.omg.CORBA.INITIALIZE;
48  import org.omg.CORBA.INTERNAL;
49  import org.omg.CORBA.INTF_REPOS;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/OMGSystemException.java
      * Line Number: 40
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
30  
31  package org.jboss.com.sun.corba.se.impl.logging;
32  
33  import java.util.logging.Level;
34  import java.util.logging.Logger;
35  
36  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperBase;
37  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperFactory;
38  import org.jboss.com.sun.corba.se.spi.orb.ORB;
39  import org.omg.CORBA.BAD_CONTEXT;
40  import org.omg.CORBA.BAD_INV_ORDER;
41  import org.omg.CORBA.BAD_OPERATION;
42  import org.omg.CORBA.BAD_PARAM;
43  import org.omg.CORBA.BAD_TYPECODE;
44  import org.omg.CORBA.CompletionStatus;
45  import org.omg.CORBA.DATA_CONVERSION;
46  import org.omg.CORBA.IMP_LIMIT;
47  import org.omg.CORBA.INITIALIZE;
48  import org.omg.CORBA.INTERNAL;
49  import org.omg.CORBA.INTF_REPOS;
50  import org.omg.CORBA.INV_OBJREF;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/OMGSystemException.java
      * Line Number: 43
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
33  import java.util.logging.Level;
34  import java.util.logging.Logger;
35  
36  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperBase;
37  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperFactory;
38  import org.jboss.com.sun.corba.se.spi.orb.ORB;
39  import org.omg.CORBA.BAD_CONTEXT;
40  import org.omg.CORBA.BAD_INV_ORDER;
41  import org.omg.CORBA.BAD_OPERATION;
42  import org.omg.CORBA.BAD_PARAM;
43  import org.omg.CORBA.BAD_TYPECODE;
44  import org.omg.CORBA.CompletionStatus;
45  import org.omg.CORBA.DATA_CONVERSION;
46  import org.omg.CORBA.IMP_LIMIT;
47  import org.omg.CORBA.INITIALIZE;
48  import org.omg.CORBA.INTERNAL;
49  import org.omg.CORBA.INTF_REPOS;
50  import org.omg.CORBA.INV_OBJREF;
51  import org.omg.CORBA.INV_POLICY;
52  import org.omg.CORBA.MARSHAL;
53  import org.omg.CORBA.NO_IMPLEMENT;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/OMGSystemException.java
      * Line Number: 44
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
34  import java.util.logging.Logger;
35  
36  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperBase;
37  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperFactory;
38  import org.jboss.com.sun.corba.se.spi.orb.ORB;
39  import org.omg.CORBA.BAD_CONTEXT;
40  import org.omg.CORBA.BAD_INV_ORDER;
41  import org.omg.CORBA.BAD_OPERATION;
42  import org.omg.CORBA.BAD_PARAM;
43  import org.omg.CORBA.BAD_TYPECODE;
44  import org.omg.CORBA.CompletionStatus;
45  import org.omg.CORBA.DATA_CONVERSION;
46  import org.omg.CORBA.IMP_LIMIT;
47  import org.omg.CORBA.INITIALIZE;
48  import org.omg.CORBA.INTERNAL;
49  import org.omg.CORBA.INTF_REPOS;
50  import org.omg.CORBA.INV_OBJREF;
51  import org.omg.CORBA.INV_POLICY;
52  import org.omg.CORBA.MARSHAL;
53  import org.omg.CORBA.NO_IMPLEMENT;
54  import org.omg.CORBA.NO_RESOURCES;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/OMGSystemException.java
      * Line Number: 45
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
35  
36  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperBase;
37  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperFactory;
38  import org.jboss.com.sun.corba.se.spi.orb.ORB;
39  import org.omg.CORBA.BAD_CONTEXT;
40  import org.omg.CORBA.BAD_INV_ORDER;
41  import org.omg.CORBA.BAD_OPERATION;
42  import org.omg.CORBA.BAD_PARAM;
43  import org.omg.CORBA.BAD_TYPECODE;
44  import org.omg.CORBA.CompletionStatus;
45  import org.omg.CORBA.DATA_CONVERSION;
46  import org.omg.CORBA.IMP_LIMIT;
47  import org.omg.CORBA.INITIALIZE;
48  import org.omg.CORBA.INTERNAL;
49  import org.omg.CORBA.INTF_REPOS;
50  import org.omg.CORBA.INV_OBJREF;
51  import org.omg.CORBA.INV_POLICY;
52  import org.omg.CORBA.MARSHAL;
53  import org.omg.CORBA.NO_IMPLEMENT;
54  import org.omg.CORBA.NO_RESOURCES;
55  import org.omg.CORBA.OBJECT_NOT_EXIST;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/OMGSystemException.java
      * Line Number: 46
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
36  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperBase;
37  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperFactory;
38  import org.jboss.com.sun.corba.se.spi.orb.ORB;
39  import org.omg.CORBA.BAD_CONTEXT;
40  import org.omg.CORBA.BAD_INV_ORDER;
41  import org.omg.CORBA.BAD_OPERATION;
42  import org.omg.CORBA.BAD_PARAM;
43  import org.omg.CORBA.BAD_TYPECODE;
44  import org.omg.CORBA.CompletionStatus;
45  import org.omg.CORBA.DATA_CONVERSION;
46  import org.omg.CORBA.IMP_LIMIT;
47  import org.omg.CORBA.INITIALIZE;
48  import org.omg.CORBA.INTERNAL;
49  import org.omg.CORBA.INTF_REPOS;
50  import org.omg.CORBA.INV_OBJREF;
51  import org.omg.CORBA.INV_POLICY;
52  import org.omg.CORBA.MARSHAL;
53  import org.omg.CORBA.NO_IMPLEMENT;
54  import org.omg.CORBA.NO_RESOURCES;
55  import org.omg.CORBA.OBJECT_NOT_EXIST;
56  import org.omg.CORBA.OBJ_ADAPTER;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/OMGSystemException.java
      * Line Number: 48
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
38  import org.jboss.com.sun.corba.se.spi.orb.ORB;
39  import org.omg.CORBA.BAD_CONTEXT;
40  import org.omg.CORBA.BAD_INV_ORDER;
41  import org.omg.CORBA.BAD_OPERATION;
42  import org.omg.CORBA.BAD_PARAM;
43  import org.omg.CORBA.BAD_TYPECODE;
44  import org.omg.CORBA.CompletionStatus;
45  import org.omg.CORBA.DATA_CONVERSION;
46  import org.omg.CORBA.IMP_LIMIT;
47  import org.omg.CORBA.INITIALIZE;
48  import org.omg.CORBA.INTERNAL;
49  import org.omg.CORBA.INTF_REPOS;
50  import org.omg.CORBA.INV_OBJREF;
51  import org.omg.CORBA.INV_POLICY;
52  import org.omg.CORBA.MARSHAL;
53  import org.omg.CORBA.NO_IMPLEMENT;
54  import org.omg.CORBA.NO_RESOURCES;
55  import org.omg.CORBA.OBJECT_NOT_EXIST;
56  import org.omg.CORBA.OBJ_ADAPTER;
57  import org.omg.CORBA.OMGVMCID;
58  import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/OMGSystemException.java
      * Line Number: 50
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
40  import org.omg.CORBA.BAD_INV_ORDER;
41  import org.omg.CORBA.BAD_OPERATION;
42  import org.omg.CORBA.BAD_PARAM;
43  import org.omg.CORBA.BAD_TYPECODE;
44  import org.omg.CORBA.CompletionStatus;
45  import org.omg.CORBA.DATA_CONVERSION;
46  import org.omg.CORBA.IMP_LIMIT;
47  import org.omg.CORBA.INITIALIZE;
48  import org.omg.CORBA.INTERNAL;
49  import org.omg.CORBA.INTF_REPOS;
50  import org.omg.CORBA.INV_OBJREF;
51  import org.omg.CORBA.INV_POLICY;
52  import org.omg.CORBA.MARSHAL;
53  import org.omg.CORBA.NO_IMPLEMENT;
54  import org.omg.CORBA.NO_RESOURCES;
55  import org.omg.CORBA.OBJECT_NOT_EXIST;
56  import org.omg.CORBA.OBJ_ADAPTER;
57  import org.omg.CORBA.OMGVMCID;
58  import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
59  import org.omg.CORBA.TRANSIENT;
60  import org.omg.CORBA.UNKNOWN;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/OMGSystemException.java
      * Line Number: 52
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
42  import org.omg.CORBA.BAD_PARAM;
43  import org.omg.CORBA.BAD_TYPECODE;
44  import org.omg.CORBA.CompletionStatus;
45  import org.omg.CORBA.DATA_CONVERSION;
46  import org.omg.CORBA.IMP_LIMIT;
47  import org.omg.CORBA.INITIALIZE;
48  import org.omg.CORBA.INTERNAL;
49  import org.omg.CORBA.INTF_REPOS;
50  import org.omg.CORBA.INV_OBJREF;
51  import org.omg.CORBA.INV_POLICY;
52  import org.omg.CORBA.MARSHAL;
53  import org.omg.CORBA.NO_IMPLEMENT;
54  import org.omg.CORBA.NO_RESOURCES;
55  import org.omg.CORBA.OBJECT_NOT_EXIST;
56  import org.omg.CORBA.OBJ_ADAPTER;
57  import org.omg.CORBA.OMGVMCID;
58  import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
59  import org.omg.CORBA.TRANSIENT;
60  import org.omg.CORBA.UNKNOWN;
61  
62  public class OMGSystemException extends LogWrapperBase
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/OMGSystemException.java
      * Line Number: 53
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
43  import org.omg.CORBA.BAD_TYPECODE;
44  import org.omg.CORBA.CompletionStatus;
45  import org.omg.CORBA.DATA_CONVERSION;
46  import org.omg.CORBA.IMP_LIMIT;
47  import org.omg.CORBA.INITIALIZE;
48  import org.omg.CORBA.INTERNAL;
49  import org.omg.CORBA.INTF_REPOS;
50  import org.omg.CORBA.INV_OBJREF;
51  import org.omg.CORBA.INV_POLICY;
52  import org.omg.CORBA.MARSHAL;
53  import org.omg.CORBA.NO_IMPLEMENT;
54  import org.omg.CORBA.NO_RESOURCES;
55  import org.omg.CORBA.OBJECT_NOT_EXIST;
56  import org.omg.CORBA.OBJ_ADAPTER;
57  import org.omg.CORBA.OMGVMCID;
58  import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
59  import org.omg.CORBA.TRANSIENT;
60  import org.omg.CORBA.UNKNOWN;
61  
62  public class OMGSystemException extends LogWrapperBase
63  {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/OMGSystemException.java
      * Line Number: 54
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
44  import org.omg.CORBA.CompletionStatus;
45  import org.omg.CORBA.DATA_CONVERSION;
46  import org.omg.CORBA.IMP_LIMIT;
47  import org.omg.CORBA.INITIALIZE;
48  import org.omg.CORBA.INTERNAL;
49  import org.omg.CORBA.INTF_REPOS;
50  import org.omg.CORBA.INV_OBJREF;
51  import org.omg.CORBA.INV_POLICY;
52  import org.omg.CORBA.MARSHAL;
53  import org.omg.CORBA.NO_IMPLEMENT;
54  import org.omg.CORBA.NO_RESOURCES;
55  import org.omg.CORBA.OBJECT_NOT_EXIST;
56  import org.omg.CORBA.OBJ_ADAPTER;
57  import org.omg.CORBA.OMGVMCID;
58  import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
59  import org.omg.CORBA.TRANSIENT;
60  import org.omg.CORBA.UNKNOWN;
61  
62  public class OMGSystemException extends LogWrapperBase
63  {
64  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/OMGSystemException.java
      * Line Number: 56
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
46  import org.omg.CORBA.IMP_LIMIT;
47  import org.omg.CORBA.INITIALIZE;
48  import org.omg.CORBA.INTERNAL;
49  import org.omg.CORBA.INTF_REPOS;
50  import org.omg.CORBA.INV_OBJREF;
51  import org.omg.CORBA.INV_POLICY;
52  import org.omg.CORBA.MARSHAL;
53  import org.omg.CORBA.NO_IMPLEMENT;
54  import org.omg.CORBA.NO_RESOURCES;
55  import org.omg.CORBA.OBJECT_NOT_EXIST;
56  import org.omg.CORBA.OBJ_ADAPTER;
57  import org.omg.CORBA.OMGVMCID;
58  import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
59  import org.omg.CORBA.TRANSIENT;
60  import org.omg.CORBA.UNKNOWN;
61  
62  public class OMGSystemException extends LogWrapperBase
63  {
64  
65      public OMGSystemException(Logger logger)
66      {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/OMGSystemException.java
      * Line Number: 57
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
47  import org.omg.CORBA.INITIALIZE;
48  import org.omg.CORBA.INTERNAL;
49  import org.omg.CORBA.INTF_REPOS;
50  import org.omg.CORBA.INV_OBJREF;
51  import org.omg.CORBA.INV_POLICY;
52  import org.omg.CORBA.MARSHAL;
53  import org.omg.CORBA.NO_IMPLEMENT;
54  import org.omg.CORBA.NO_RESOURCES;
55  import org.omg.CORBA.OBJECT_NOT_EXIST;
56  import org.omg.CORBA.OBJ_ADAPTER;
57  import org.omg.CORBA.OMGVMCID;
58  import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
59  import org.omg.CORBA.TRANSIENT;
60  import org.omg.CORBA.UNKNOWN;
61  
62  public class OMGSystemException extends LogWrapperBase
63  {
64  
65      public OMGSystemException(Logger logger)
66      {
67          super(logger);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/OMGSystemException.java
      * Line Number: 58
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
48  import org.omg.CORBA.INTERNAL;
49  import org.omg.CORBA.INTF_REPOS;
50  import org.omg.CORBA.INV_OBJREF;
51  import org.omg.CORBA.INV_POLICY;
52  import org.omg.CORBA.MARSHAL;
53  import org.omg.CORBA.NO_IMPLEMENT;
54  import org.omg.CORBA.NO_RESOURCES;
55  import org.omg.CORBA.OBJECT_NOT_EXIST;
56  import org.omg.CORBA.OBJ_ADAPTER;
57  import org.omg.CORBA.OMGVMCID;
58  import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
59  import org.omg.CORBA.TRANSIENT;
60  import org.omg.CORBA.UNKNOWN;
61  
62  public class OMGSystemException extends LogWrapperBase
63  {
64  
65      public OMGSystemException(Logger logger)
66      {
67          super(logger);
68      }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/OMGSystemException.java
      * Line Number: 59
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
49  import org.omg.CORBA.INTF_REPOS;
50  import org.omg.CORBA.INV_OBJREF;
51  import org.omg.CORBA.INV_POLICY;
52  import org.omg.CORBA.MARSHAL;
53  import org.omg.CORBA.NO_IMPLEMENT;
54  import org.omg.CORBA.NO_RESOURCES;
55  import org.omg.CORBA.OBJECT_NOT_EXIST;
56  import org.omg.CORBA.OBJ_ADAPTER;
57  import org.omg.CORBA.OMGVMCID;
58  import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
59  import org.omg.CORBA.TRANSIENT;
60  import org.omg.CORBA.UNKNOWN;
61  
62  public class OMGSystemException extends LogWrapperBase
63  {
64  
65      public OMGSystemException(Logger logger)
66      {
67          super(logger);
68      }
69  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/OMGSystemException.java
      * Line Number: 60
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
50  import org.omg.CORBA.INV_OBJREF;
51  import org.omg.CORBA.INV_POLICY;
52  import org.omg.CORBA.MARSHAL;
53  import org.omg.CORBA.NO_IMPLEMENT;
54  import org.omg.CORBA.NO_RESOURCES;
55  import org.omg.CORBA.OBJECT_NOT_EXIST;
56  import org.omg.CORBA.OBJ_ADAPTER;
57  import org.omg.CORBA.OMGVMCID;
58  import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
59  import org.omg.CORBA.TRANSIENT;
60  import org.omg.CORBA.UNKNOWN;
61  
62  public class OMGSystemException extends LogWrapperBase
63  {
64  
65      public OMGSystemException(Logger logger)
66      {
67          super(logger);
68      }
69  
70      private static LogWrapperFactory factory = new LogWrapperFactory()
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/ORBUtilSystemException.java
      * Line Number: 41
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
11   * This code is distributed in the hope that it will be useful, but WITHOUT
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/ORBUtilSystemException.java
      * Line Number: 42
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
11   * This code is distributed in the hope that it will be useful, but WITHOUT
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/ORBUtilSystemException.java
      * Line Number: 44
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
11   * This code is distributed in the hope that it will be useful, but WITHOUT
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/ORBUtilSystemException.java
      * Line Number: 46
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
11   * This code is distributed in the hope that it will be useful, but WITHOUT
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/ORBUtilSystemException.java
      * Line Number: 47
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
11   * This code is distributed in the hope that it will be useful, but WITHOUT
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/ORBUtilSystemException.java
      * Line Number: 48
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
11   * This code is distributed in the hope that it will be useful, but WITHOUT
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/ORBUtilSystemException.java
      * Line Number: 51
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
11   * This code is distributed in the hope that it will be useful, but WITHOUT
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/ORBUtilSystemException.java
      * Line Number: 40
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
30  
31  package org.jboss.com.sun.corba.se.impl.logging;
32  
33  import java.util.logging.Level;
34  import java.util.logging.Logger;
35  
36  import org.jboss.com.sun.corba.se.impl.util.SUNVMCID;
37  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperBase;
38  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperFactory;
39  import org.jboss.com.sun.corba.se.spi.orb.ORB;
40  import org.omg.CORBA.BAD_INV_ORDER;
41  import org.omg.CORBA.BAD_OPERATION;
42  import org.omg.CORBA.BAD_PARAM;
43  import org.omg.CORBA.BAD_TYPECODE;
44  import org.omg.CORBA.COMM_FAILURE;
45  import org.omg.CORBA.CompletionStatus;
46  import org.omg.CORBA.DATA_CONVERSION;
47  import org.omg.CORBA.INITIALIZE;
48  import org.omg.CORBA.INTERNAL;
49  import org.omg.CORBA.INV_OBJREF;
50  import org.omg.CORBA.MARSHAL;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/ORBUtilSystemException.java
      * Line Number: 43
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
33  import java.util.logging.Level;
34  import java.util.logging.Logger;
35  
36  import org.jboss.com.sun.corba.se.impl.util.SUNVMCID;
37  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperBase;
38  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperFactory;
39  import org.jboss.com.sun.corba.se.spi.orb.ORB;
40  import org.omg.CORBA.BAD_INV_ORDER;
41  import org.omg.CORBA.BAD_OPERATION;
42  import org.omg.CORBA.BAD_PARAM;
43  import org.omg.CORBA.BAD_TYPECODE;
44  import org.omg.CORBA.COMM_FAILURE;
45  import org.omg.CORBA.CompletionStatus;
46  import org.omg.CORBA.DATA_CONVERSION;
47  import org.omg.CORBA.INITIALIZE;
48  import org.omg.CORBA.INTERNAL;
49  import org.omg.CORBA.INV_OBJREF;
50  import org.omg.CORBA.MARSHAL;
51  import org.omg.CORBA.NO_IMPLEMENT;
52  import org.omg.CORBA.OBJECT_NOT_EXIST;
53  import org.omg.CORBA.OBJ_ADAPTER;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/ORBUtilSystemException.java
      * Line Number: 45
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
35  
36  import org.jboss.com.sun.corba.se.impl.util.SUNVMCID;
37  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperBase;
38  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperFactory;
39  import org.jboss.com.sun.corba.se.spi.orb.ORB;
40  import org.omg.CORBA.BAD_INV_ORDER;
41  import org.omg.CORBA.BAD_OPERATION;
42  import org.omg.CORBA.BAD_PARAM;
43  import org.omg.CORBA.BAD_TYPECODE;
44  import org.omg.CORBA.COMM_FAILURE;
45  import org.omg.CORBA.CompletionStatus;
46  import org.omg.CORBA.DATA_CONVERSION;
47  import org.omg.CORBA.INITIALIZE;
48  import org.omg.CORBA.INTERNAL;
49  import org.omg.CORBA.INV_OBJREF;
50  import org.omg.CORBA.MARSHAL;
51  import org.omg.CORBA.NO_IMPLEMENT;
52  import org.omg.CORBA.OBJECT_NOT_EXIST;
53  import org.omg.CORBA.OBJ_ADAPTER;
54  import org.omg.CORBA.TRANSIENT;
55  import org.omg.CORBA.UNKNOWN;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/ORBUtilSystemException.java
      * Line Number: 49
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
39  import org.jboss.com.sun.corba.se.spi.orb.ORB;
40  import org.omg.CORBA.BAD_INV_ORDER;
41  import org.omg.CORBA.BAD_OPERATION;
42  import org.omg.CORBA.BAD_PARAM;
43  import org.omg.CORBA.BAD_TYPECODE;
44  import org.omg.CORBA.COMM_FAILURE;
45  import org.omg.CORBA.CompletionStatus;
46  import org.omg.CORBA.DATA_CONVERSION;
47  import org.omg.CORBA.INITIALIZE;
48  import org.omg.CORBA.INTERNAL;
49  import org.omg.CORBA.INV_OBJREF;
50  import org.omg.CORBA.MARSHAL;
51  import org.omg.CORBA.NO_IMPLEMENT;
52  import org.omg.CORBA.OBJECT_NOT_EXIST;
53  import org.omg.CORBA.OBJ_ADAPTER;
54  import org.omg.CORBA.TRANSIENT;
55  import org.omg.CORBA.UNKNOWN;
56  
57  public class ORBUtilSystemException extends LogWrapperBase
58  {
59  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/ORBUtilSystemException.java
      * Line Number: 50
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
40  import org.omg.CORBA.BAD_INV_ORDER;
41  import org.omg.CORBA.BAD_OPERATION;
42  import org.omg.CORBA.BAD_PARAM;
43  import org.omg.CORBA.BAD_TYPECODE;
44  import org.omg.CORBA.COMM_FAILURE;
45  import org.omg.CORBA.CompletionStatus;
46  import org.omg.CORBA.DATA_CONVERSION;
47  import org.omg.CORBA.INITIALIZE;
48  import org.omg.CORBA.INTERNAL;
49  import org.omg.CORBA.INV_OBJREF;
50  import org.omg.CORBA.MARSHAL;
51  import org.omg.CORBA.NO_IMPLEMENT;
52  import org.omg.CORBA.OBJECT_NOT_EXIST;
53  import org.omg.CORBA.OBJ_ADAPTER;
54  import org.omg.CORBA.TRANSIENT;
55  import org.omg.CORBA.UNKNOWN;
56  
57  public class ORBUtilSystemException extends LogWrapperBase
58  {
59  
60      public ORBUtilSystemException(Logger logger)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/ORBUtilSystemException.java
      * Line Number: 52
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
42  import org.omg.CORBA.BAD_PARAM;
43  import org.omg.CORBA.BAD_TYPECODE;
44  import org.omg.CORBA.COMM_FAILURE;
45  import org.omg.CORBA.CompletionStatus;
46  import org.omg.CORBA.DATA_CONVERSION;
47  import org.omg.CORBA.INITIALIZE;
48  import org.omg.CORBA.INTERNAL;
49  import org.omg.CORBA.INV_OBJREF;
50  import org.omg.CORBA.MARSHAL;
51  import org.omg.CORBA.NO_IMPLEMENT;
52  import org.omg.CORBA.OBJECT_NOT_EXIST;
53  import org.omg.CORBA.OBJ_ADAPTER;
54  import org.omg.CORBA.TRANSIENT;
55  import org.omg.CORBA.UNKNOWN;
56  
57  public class ORBUtilSystemException extends LogWrapperBase
58  {
59  
60      public ORBUtilSystemException(Logger logger)
61      {
62          super(logger);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/ORBUtilSystemException.java
      * Line Number: 53
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
43  import org.omg.CORBA.BAD_TYPECODE;
44  import org.omg.CORBA.COMM_FAILURE;
45  import org.omg.CORBA.CompletionStatus;
46  import org.omg.CORBA.DATA_CONVERSION;
47  import org.omg.CORBA.INITIALIZE;
48  import org.omg.CORBA.INTERNAL;
49  import org.omg.CORBA.INV_OBJREF;
50  import org.omg.CORBA.MARSHAL;
51  import org.omg.CORBA.NO_IMPLEMENT;
52  import org.omg.CORBA.OBJECT_NOT_EXIST;
53  import org.omg.CORBA.OBJ_ADAPTER;
54  import org.omg.CORBA.TRANSIENT;
55  import org.omg.CORBA.UNKNOWN;
56  
57  public class ORBUtilSystemException extends LogWrapperBase
58  {
59  
60      public ORBUtilSystemException(Logger logger)
61      {
62          super(logger);
63      }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/ORBUtilSystemException.java
      * Line Number: 54
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
44  import org.omg.CORBA.COMM_FAILURE;
45  import org.omg.CORBA.CompletionStatus;
46  import org.omg.CORBA.DATA_CONVERSION;
47  import org.omg.CORBA.INITIALIZE;
48  import org.omg.CORBA.INTERNAL;
49  import org.omg.CORBA.INV_OBJREF;
50  import org.omg.CORBA.MARSHAL;
51  import org.omg.CORBA.NO_IMPLEMENT;
52  import org.omg.CORBA.OBJECT_NOT_EXIST;
53  import org.omg.CORBA.OBJ_ADAPTER;
54  import org.omg.CORBA.TRANSIENT;
55  import org.omg.CORBA.UNKNOWN;
56  
57  public class ORBUtilSystemException extends LogWrapperBase
58  {
59  
60      public ORBUtilSystemException(Logger logger)
61      {
62          super(logger);
63      }
64  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/ORBUtilSystemException.java
      * Line Number: 55
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
45  import org.omg.CORBA.CompletionStatus;
46  import org.omg.CORBA.DATA_CONVERSION;
47  import org.omg.CORBA.INITIALIZE;
48  import org.omg.CORBA.INTERNAL;
49  import org.omg.CORBA.INV_OBJREF;
50  import org.omg.CORBA.MARSHAL;
51  import org.omg.CORBA.NO_IMPLEMENT;
52  import org.omg.CORBA.OBJECT_NOT_EXIST;
53  import org.omg.CORBA.OBJ_ADAPTER;
54  import org.omg.CORBA.TRANSIENT;
55  import org.omg.CORBA.UNKNOWN;
56  
57  public class ORBUtilSystemException extends LogWrapperBase
58  {
59  
60      public ORBUtilSystemException(Logger logger)
61      {
62          super(logger);
63      }
64  
65      private static LogWrapperFactory factory = new LogWrapperFactory()
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/POASystemException.java
      * Line Number: 40
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
30  
31  package org.jboss.com.sun.corba.se.impl.logging;
32  
33  import java.util.logging.Level;
34  import java.util.logging.Logger;
35  
36  import org.jboss.com.sun.corba.se.impl.util.SUNVMCID;
37  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperBase;
38  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperFactory;
39  import org.jboss.com.sun.corba.se.spi.orb.ORB;
40  import org.omg.CORBA.BAD_INV_ORDER;
41  import org.omg.CORBA.BAD_OPERATION;
42  import org.omg.CORBA.BAD_PARAM;
43  import org.omg.CORBA.CompletionStatus;
44  import org.omg.CORBA.INITIALIZE;
45  import org.omg.CORBA.INTERNAL;
46  import org.omg.CORBA.NO_IMPLEMENT;
47  import org.omg.CORBA.OBJECT_NOT_EXIST;
48  import org.omg.CORBA.OBJ_ADAPTER;
49  import org.omg.CORBA.TRANSIENT;
50  import org.omg.CORBA.UNKNOWN;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/POASystemException.java
      * Line Number: 41
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
31  package org.jboss.com.sun.corba.se.impl.logging;
32  
33  import java.util.logging.Level;
34  import java.util.logging.Logger;
35  
36  import org.jboss.com.sun.corba.se.impl.util.SUNVMCID;
37  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperBase;
38  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperFactory;
39  import org.jboss.com.sun.corba.se.spi.orb.ORB;
40  import org.omg.CORBA.BAD_INV_ORDER;
41  import org.omg.CORBA.BAD_OPERATION;
42  import org.omg.CORBA.BAD_PARAM;
43  import org.omg.CORBA.CompletionStatus;
44  import org.omg.CORBA.INITIALIZE;
45  import org.omg.CORBA.INTERNAL;
46  import org.omg.CORBA.NO_IMPLEMENT;
47  import org.omg.CORBA.OBJECT_NOT_EXIST;
48  import org.omg.CORBA.OBJ_ADAPTER;
49  import org.omg.CORBA.TRANSIENT;
50  import org.omg.CORBA.UNKNOWN;
51  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/POASystemException.java
      * Line Number: 42
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
32  
33  import java.util.logging.Level;
34  import java.util.logging.Logger;
35  
36  import org.jboss.com.sun.corba.se.impl.util.SUNVMCID;
37  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperBase;
38  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperFactory;
39  import org.jboss.com.sun.corba.se.spi.orb.ORB;
40  import org.omg.CORBA.BAD_INV_ORDER;
41  import org.omg.CORBA.BAD_OPERATION;
42  import org.omg.CORBA.BAD_PARAM;
43  import org.omg.CORBA.CompletionStatus;
44  import org.omg.CORBA.INITIALIZE;
45  import org.omg.CORBA.INTERNAL;
46  import org.omg.CORBA.NO_IMPLEMENT;
47  import org.omg.CORBA.OBJECT_NOT_EXIST;
48  import org.omg.CORBA.OBJ_ADAPTER;
49  import org.omg.CORBA.TRANSIENT;
50  import org.omg.CORBA.UNKNOWN;
51  
52  public class POASystemException extends LogWrapperBase
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/POASystemException.java
      * Line Number: 43
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
33  import java.util.logging.Level;
34  import java.util.logging.Logger;
35  
36  import org.jboss.com.sun.corba.se.impl.util.SUNVMCID;
37  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperBase;
38  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperFactory;
39  import org.jboss.com.sun.corba.se.spi.orb.ORB;
40  import org.omg.CORBA.BAD_INV_ORDER;
41  import org.omg.CORBA.BAD_OPERATION;
42  import org.omg.CORBA.BAD_PARAM;
43  import org.omg.CORBA.CompletionStatus;
44  import org.omg.CORBA.INITIALIZE;
45  import org.omg.CORBA.INTERNAL;
46  import org.omg.CORBA.NO_IMPLEMENT;
47  import org.omg.CORBA.OBJECT_NOT_EXIST;
48  import org.omg.CORBA.OBJ_ADAPTER;
49  import org.omg.CORBA.TRANSIENT;
50  import org.omg.CORBA.UNKNOWN;
51  
52  public class POASystemException extends LogWrapperBase
53  {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/POASystemException.java
      * Line Number: 44
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
34  import java.util.logging.Logger;
35  
36  import org.jboss.com.sun.corba.se.impl.util.SUNVMCID;
37  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperBase;
38  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperFactory;
39  import org.jboss.com.sun.corba.se.spi.orb.ORB;
40  import org.omg.CORBA.BAD_INV_ORDER;
41  import org.omg.CORBA.BAD_OPERATION;
42  import org.omg.CORBA.BAD_PARAM;
43  import org.omg.CORBA.CompletionStatus;
44  import org.omg.CORBA.INITIALIZE;
45  import org.omg.CORBA.INTERNAL;
46  import org.omg.CORBA.NO_IMPLEMENT;
47  import org.omg.CORBA.OBJECT_NOT_EXIST;
48  import org.omg.CORBA.OBJ_ADAPTER;
49  import org.omg.CORBA.TRANSIENT;
50  import org.omg.CORBA.UNKNOWN;
51  
52  public class POASystemException extends LogWrapperBase
53  {
54  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/POASystemException.java
      * Line Number: 45
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
35  
36  import org.jboss.com.sun.corba.se.impl.util.SUNVMCID;
37  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperBase;
38  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperFactory;
39  import org.jboss.com.sun.corba.se.spi.orb.ORB;
40  import org.omg.CORBA.BAD_INV_ORDER;
41  import org.omg.CORBA.BAD_OPERATION;
42  import org.omg.CORBA.BAD_PARAM;
43  import org.omg.CORBA.CompletionStatus;
44  import org.omg.CORBA.INITIALIZE;
45  import org.omg.CORBA.INTERNAL;
46  import org.omg.CORBA.NO_IMPLEMENT;
47  import org.omg.CORBA.OBJECT_NOT_EXIST;
48  import org.omg.CORBA.OBJ_ADAPTER;
49  import org.omg.CORBA.TRANSIENT;
50  import org.omg.CORBA.UNKNOWN;
51  
52  public class POASystemException extends LogWrapperBase
53  {
54  
55      public POASystemException(Logger logger)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/POASystemException.java
      * Line Number: 46
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
36  import org.jboss.com.sun.corba.se.impl.util.SUNVMCID;
37  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperBase;
38  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperFactory;
39  import org.jboss.com.sun.corba.se.spi.orb.ORB;
40  import org.omg.CORBA.BAD_INV_ORDER;
41  import org.omg.CORBA.BAD_OPERATION;
42  import org.omg.CORBA.BAD_PARAM;
43  import org.omg.CORBA.CompletionStatus;
44  import org.omg.CORBA.INITIALIZE;
45  import org.omg.CORBA.INTERNAL;
46  import org.omg.CORBA.NO_IMPLEMENT;
47  import org.omg.CORBA.OBJECT_NOT_EXIST;
48  import org.omg.CORBA.OBJ_ADAPTER;
49  import org.omg.CORBA.TRANSIENT;
50  import org.omg.CORBA.UNKNOWN;
51  
52  public class POASystemException extends LogWrapperBase
53  {
54  
55      public POASystemException(Logger logger)
56      {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/POASystemException.java
      * Line Number: 47
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
37  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperBase;
38  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperFactory;
39  import org.jboss.com.sun.corba.se.spi.orb.ORB;
40  import org.omg.CORBA.BAD_INV_ORDER;
41  import org.omg.CORBA.BAD_OPERATION;
42  import org.omg.CORBA.BAD_PARAM;
43  import org.omg.CORBA.CompletionStatus;
44  import org.omg.CORBA.INITIALIZE;
45  import org.omg.CORBA.INTERNAL;
46  import org.omg.CORBA.NO_IMPLEMENT;
47  import org.omg.CORBA.OBJECT_NOT_EXIST;
48  import org.omg.CORBA.OBJ_ADAPTER;
49  import org.omg.CORBA.TRANSIENT;
50  import org.omg.CORBA.UNKNOWN;
51  
52  public class POASystemException extends LogWrapperBase
53  {
54  
55      public POASystemException(Logger logger)
56      {
57          super(logger);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/POASystemException.java
      * Line Number: 48
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
38  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperFactory;
39  import org.jboss.com.sun.corba.se.spi.orb.ORB;
40  import org.omg.CORBA.BAD_INV_ORDER;
41  import org.omg.CORBA.BAD_OPERATION;
42  import org.omg.CORBA.BAD_PARAM;
43  import org.omg.CORBA.CompletionStatus;
44  import org.omg.CORBA.INITIALIZE;
45  import org.omg.CORBA.INTERNAL;
46  import org.omg.CORBA.NO_IMPLEMENT;
47  import org.omg.CORBA.OBJECT_NOT_EXIST;
48  import org.omg.CORBA.OBJ_ADAPTER;
49  import org.omg.CORBA.TRANSIENT;
50  import org.omg.CORBA.UNKNOWN;
51  
52  public class POASystemException extends LogWrapperBase
53  {
54  
55      public POASystemException(Logger logger)
56      {
57          super(logger);
58      }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/POASystemException.java
      * Line Number: 49
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
39  import org.jboss.com.sun.corba.se.spi.orb.ORB;
40  import org.omg.CORBA.BAD_INV_ORDER;
41  import org.omg.CORBA.BAD_OPERATION;
42  import org.omg.CORBA.BAD_PARAM;
43  import org.omg.CORBA.CompletionStatus;
44  import org.omg.CORBA.INITIALIZE;
45  import org.omg.CORBA.INTERNAL;
46  import org.omg.CORBA.NO_IMPLEMENT;
47  import org.omg.CORBA.OBJECT_NOT_EXIST;
48  import org.omg.CORBA.OBJ_ADAPTER;
49  import org.omg.CORBA.TRANSIENT;
50  import org.omg.CORBA.UNKNOWN;
51  
52  public class POASystemException extends LogWrapperBase
53  {
54  
55      public POASystemException(Logger logger)
56      {
57          super(logger);
58      }
59  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/POASystemException.java
      * Line Number: 50
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
40  import org.omg.CORBA.BAD_INV_ORDER;
41  import org.omg.CORBA.BAD_OPERATION;
42  import org.omg.CORBA.BAD_PARAM;
43  import org.omg.CORBA.CompletionStatus;
44  import org.omg.CORBA.INITIALIZE;
45  import org.omg.CORBA.INTERNAL;
46  import org.omg.CORBA.NO_IMPLEMENT;
47  import org.omg.CORBA.OBJECT_NOT_EXIST;
48  import org.omg.CORBA.OBJ_ADAPTER;
49  import org.omg.CORBA.TRANSIENT;
50  import org.omg.CORBA.UNKNOWN;
51  
52  public class POASystemException extends LogWrapperBase
53  {
54  
55      public POASystemException(Logger logger)
56      {
57          super(logger);
58      }
59  
60      private static LogWrapperFactory factory = new LogWrapperFactory()
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/UtilSystemException.java
      * Line Number: 40
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
30  
31  package org.jboss.com.sun.corba.se.impl.logging;
32  
33  import java.util.logging.Level;
34  import java.util.logging.Logger;
35  
36  import org.jboss.com.sun.corba.se.impl.util.SUNVMCID;
37  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperBase;
38  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperFactory;
39  import org.jboss.com.sun.corba.se.spi.orb.ORB;
40  import org.omg.CORBA.BAD_OPERATION;
41  import org.omg.CORBA.BAD_PARAM;
42  import org.omg.CORBA.CompletionStatus;
43  import org.omg.CORBA.DATA_CONVERSION;
44  import org.omg.CORBA.INTERNAL;
45  import org.omg.CORBA.INV_OBJREF;
46  import org.omg.CORBA.MARSHAL;
47  import org.omg.CORBA.UNKNOWN;
48  
49  public class UtilSystemException extends LogWrapperBase
50  {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/UtilSystemException.java
      * Line Number: 41
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
31  package org.jboss.com.sun.corba.se.impl.logging;
32  
33  import java.util.logging.Level;
34  import java.util.logging.Logger;
35  
36  import org.jboss.com.sun.corba.se.impl.util.SUNVMCID;
37  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperBase;
38  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperFactory;
39  import org.jboss.com.sun.corba.se.spi.orb.ORB;
40  import org.omg.CORBA.BAD_OPERATION;
41  import org.omg.CORBA.BAD_PARAM;
42  import org.omg.CORBA.CompletionStatus;
43  import org.omg.CORBA.DATA_CONVERSION;
44  import org.omg.CORBA.INTERNAL;
45  import org.omg.CORBA.INV_OBJREF;
46  import org.omg.CORBA.MARSHAL;
47  import org.omg.CORBA.UNKNOWN;
48  
49  public class UtilSystemException extends LogWrapperBase
50  {
51  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/UtilSystemException.java
      * Line Number: 42
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
32  
33  import java.util.logging.Level;
34  import java.util.logging.Logger;
35  
36  import org.jboss.com.sun.corba.se.impl.util.SUNVMCID;
37  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperBase;
38  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperFactory;
39  import org.jboss.com.sun.corba.se.spi.orb.ORB;
40  import org.omg.CORBA.BAD_OPERATION;
41  import org.omg.CORBA.BAD_PARAM;
42  import org.omg.CORBA.CompletionStatus;
43  import org.omg.CORBA.DATA_CONVERSION;
44  import org.omg.CORBA.INTERNAL;
45  import org.omg.CORBA.INV_OBJREF;
46  import org.omg.CORBA.MARSHAL;
47  import org.omg.CORBA.UNKNOWN;
48  
49  public class UtilSystemException extends LogWrapperBase
50  {
51  
52      public UtilSystemException(Logger logger)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/UtilSystemException.java
      * Line Number: 43
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
33  import java.util.logging.Level;
34  import java.util.logging.Logger;
35  
36  import org.jboss.com.sun.corba.se.impl.util.SUNVMCID;
37  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperBase;
38  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperFactory;
39  import org.jboss.com.sun.corba.se.spi.orb.ORB;
40  import org.omg.CORBA.BAD_OPERATION;
41  import org.omg.CORBA.BAD_PARAM;
42  import org.omg.CORBA.CompletionStatus;
43  import org.omg.CORBA.DATA_CONVERSION;
44  import org.omg.CORBA.INTERNAL;
45  import org.omg.CORBA.INV_OBJREF;
46  import org.omg.CORBA.MARSHAL;
47  import org.omg.CORBA.UNKNOWN;
48  
49  public class UtilSystemException extends LogWrapperBase
50  {
51  
52      public UtilSystemException(Logger logger)
53      {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/UtilSystemException.java
      * Line Number: 44
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
34  import java.util.logging.Logger;
35  
36  import org.jboss.com.sun.corba.se.impl.util.SUNVMCID;
37  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperBase;
38  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperFactory;
39  import org.jboss.com.sun.corba.se.spi.orb.ORB;
40  import org.omg.CORBA.BAD_OPERATION;
41  import org.omg.CORBA.BAD_PARAM;
42  import org.omg.CORBA.CompletionStatus;
43  import org.omg.CORBA.DATA_CONVERSION;
44  import org.omg.CORBA.INTERNAL;
45  import org.omg.CORBA.INV_OBJREF;
46  import org.omg.CORBA.MARSHAL;
47  import org.omg.CORBA.UNKNOWN;
48  
49  public class UtilSystemException extends LogWrapperBase
50  {
51  
52      public UtilSystemException(Logger logger)
53      {
54          super(logger);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/UtilSystemException.java
      * Line Number: 45
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
35  
36  import org.jboss.com.sun.corba.se.impl.util.SUNVMCID;
37  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperBase;
38  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperFactory;
39  import org.jboss.com.sun.corba.se.spi.orb.ORB;
40  import org.omg.CORBA.BAD_OPERATION;
41  import org.omg.CORBA.BAD_PARAM;
42  import org.omg.CORBA.CompletionStatus;
43  import org.omg.CORBA.DATA_CONVERSION;
44  import org.omg.CORBA.INTERNAL;
45  import org.omg.CORBA.INV_OBJREF;
46  import org.omg.CORBA.MARSHAL;
47  import org.omg.CORBA.UNKNOWN;
48  
49  public class UtilSystemException extends LogWrapperBase
50  {
51  
52      public UtilSystemException(Logger logger)
53      {
54          super(logger);
55      }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/UtilSystemException.java
      * Line Number: 46
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
36  import org.jboss.com.sun.corba.se.impl.util.SUNVMCID;
37  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperBase;
38  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperFactory;
39  import org.jboss.com.sun.corba.se.spi.orb.ORB;
40  import org.omg.CORBA.BAD_OPERATION;
41  import org.omg.CORBA.BAD_PARAM;
42  import org.omg.CORBA.CompletionStatus;
43  import org.omg.CORBA.DATA_CONVERSION;
44  import org.omg.CORBA.INTERNAL;
45  import org.omg.CORBA.INV_OBJREF;
46  import org.omg.CORBA.MARSHAL;
47  import org.omg.CORBA.UNKNOWN;
48  
49  public class UtilSystemException extends LogWrapperBase
50  {
51  
52      public UtilSystemException(Logger logger)
53      {
54          super(logger);
55      }
56  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/logging/UtilSystemException.java
      * Line Number: 47
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
37  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperBase;
38  import org.jboss.com.sun.corba.se.spi.logging.LogWrapperFactory;
39  import org.jboss.com.sun.corba.se.spi.orb.ORB;
40  import org.omg.CORBA.BAD_OPERATION;
41  import org.omg.CORBA.BAD_PARAM;
42  import org.omg.CORBA.CompletionStatus;
43  import org.omg.CORBA.DATA_CONVERSION;
44  import org.omg.CORBA.INTERNAL;
45  import org.omg.CORBA.INV_OBJREF;
46  import org.omg.CORBA.MARSHAL;
47  import org.omg.CORBA.UNKNOWN;
48  
49  public class UtilSystemException extends LogWrapperBase
50  {
51  
52      public UtilSystemException(Logger logger)
53      {
54          super(logger);
55      }
56  
57      private static LogWrapperFactory factory = new LogWrapperFactory()
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/oa/poa/DelegateImpl.java
      * Line Number: 146
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
136              byte[] oid = orb.peekInvocationInfo().id();
137              if( oid == null) return true;
138              else return false;
139          } catch (EmptyStackException exception){
140              throw wrapper.noContext(exception) ;
141          }
142      }
143  
144      // The get_interface() method has been replaced by get_interface_def()
145  
146      public org.omg.CORBA.Object get_interface_def(Servant Self)
147      {
148          throw wrapper.methodNotImplemented() ;
149      }
150  
151  	public Object get_component(Servant self) {
152  		return null;
153  	}
154  
155  	public InterfaceDef get_interface(Servant self) {
156  		return InterfaceDefHelper.narrow(get_interface_def(self));
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/oa/poa/DelegateImpl.java
      * Line Number: 32
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
22   * or visit www.oracle.com if you need additional information or have any
23   * questions.
24   */
25  package org.jboss.com.sun.corba.se.impl.oa.poa;
26  
27  import java.util.EmptyStackException;
28  
29  import org.jboss.com.sun.corba.se.impl.logging.POASystemException;
30  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
31  import org.jboss.com.sun.corba.se.spi.orb.ORB;
32  import org.omg.CORBA.InterfaceDef;
33  import org.omg.CORBA.InterfaceDefHelper;
34  import org.omg.CORBA.Object;
35  import org.omg.PortableServer.POA;
36  import org.omg.PortableServer.Servant;
37  
38  public class DelegateImpl implements org.omg.PortableServer.portable.Delegate
39  {
40      private ORB orb ;
41      private POASystemException wrapper ;
42      private POAFactory factory;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/oa/poa/DelegateImpl.java
      * Line Number: 33
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
23   * questions.
24   */
25  package org.jboss.com.sun.corba.se.impl.oa.poa;
26  
27  import java.util.EmptyStackException;
28  
29  import org.jboss.com.sun.corba.se.impl.logging.POASystemException;
30  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
31  import org.jboss.com.sun.corba.se.spi.orb.ORB;
32  import org.omg.CORBA.InterfaceDef;
33  import org.omg.CORBA.InterfaceDefHelper;
34  import org.omg.CORBA.Object;
35  import org.omg.PortableServer.POA;
36  import org.omg.PortableServer.Servant;
37  
38  public class DelegateImpl implements org.omg.PortableServer.portable.Delegate
39  {
40      private ORB orb ;
41      private POASystemException wrapper ;
42      private POAFactory factory;
43  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/oa/poa/DelegateImpl.java
      * Line Number: 34
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
24   */
25  package org.jboss.com.sun.corba.se.impl.oa.poa;
26  
27  import java.util.EmptyStackException;
28  
29  import org.jboss.com.sun.corba.se.impl.logging.POASystemException;
30  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
31  import org.jboss.com.sun.corba.se.spi.orb.ORB;
32  import org.omg.CORBA.InterfaceDef;
33  import org.omg.CORBA.InterfaceDefHelper;
34  import org.omg.CORBA.Object;
35  import org.omg.PortableServer.POA;
36  import org.omg.PortableServer.Servant;
37  
38  public class DelegateImpl implements org.omg.PortableServer.portable.Delegate
39  {
40      private ORB orb ;
41      private POASystemException wrapper ;
42      private POAFactory factory;
43  
44      public DelegateImpl(ORB orb, POAFactory factory){
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/oa/poa/DelegateImpl.java
      * Line Number: 51
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
41      private POASystemException wrapper ;
42      private POAFactory factory;
43  
44      public DelegateImpl(ORB orb, POAFactory factory){
45          this.orb = orb ;
46          this.wrapper = POASystemException.get( orb,
47              CORBALogDomains.OA ) ;
48          this.factory = factory;
49      }
50  
51      public org.omg.CORBA.ORB orb(Servant self)
52      {
53          return orb;
54      }
55  
56      public org.omg.CORBA.Object this_object(Servant self)
57      {
58          byte[] oid;
59          POA poa;
60          try {
61              oid = orb.peekInvocationInfo().id();
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/oa/poa/DelegateImpl.java
      * Line Number: 56
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
46          this.wrapper = POASystemException.get( orb,
47              CORBALogDomains.OA ) ;
48          this.factory = factory;
49      }
50  
51      public org.omg.CORBA.ORB orb(Servant self)
52      {
53          return orb;
54      }
55  
56      public org.omg.CORBA.Object this_object(Servant self)
57      {
58          byte[] oid;
59          POA poa;
60          try {
61              oid = orb.peekInvocationInfo().id();
62              poa = (POA)orb.peekInvocationInfo().oa();
63              String repId = self._all_interfaces(poa,oid)[0] ;
64              return poa.create_reference_with_id(oid, repId);
65          } catch (EmptyStackException notInInvocationE) {
66              //Not within an invocation context
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/oa/poa/IdAssignmentPolicyImpl.java
      * Line Number: 28
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
18   * 2 along with this work; if not, write to the Free Software Foundation,
19   * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
20   *
21   * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
22   * or visit www.oracle.com if you need additional information or have any
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.oa.poa;
27  
28  import org.omg.CORBA.Policy;
29  import org.omg.PortableServer.ID_ASSIGNMENT_POLICY_ID;
30  import org.omg.PortableServer.IdAssignmentPolicyValue;
31  
32  final class IdAssignmentPolicyImpl extends org.omg.CORBA.LocalObject
33          implements
34              org.omg.PortableServer.IdAssignmentPolicy
35  {
36  
37      private static final long serialVersionUID = -5589531737105347566L;
38  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/oa/poa/IdAssignmentPolicyImpl.java
      * Line Number: 32
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
22   * or visit www.oracle.com if you need additional information or have any
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.oa.poa;
27  
28  import org.omg.CORBA.Policy;
29  import org.omg.PortableServer.ID_ASSIGNMENT_POLICY_ID;
30  import org.omg.PortableServer.IdAssignmentPolicyValue;
31  
32  final class IdAssignmentPolicyImpl extends org.omg.CORBA.LocalObject
33          implements
34              org.omg.PortableServer.IdAssignmentPolicy
35  {
36  
37      private static final long serialVersionUID = -5589531737105347566L;
38  
39      public IdAssignmentPolicyImpl(IdAssignmentPolicyValue value)
40      {
41          this.value = value;
42      }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/oa/poa/IdUniquenessPolicyImpl.java
      * Line Number: 28
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
18   * 2 along with this work; if not, write to the Free Software Foundation,
19   * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
20   *
21   * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
22   * or visit www.oracle.com if you need additional information or have any
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.oa.poa;
27  
28  import org.omg.CORBA.Policy;
29  import org.omg.PortableServer.ID_UNIQUENESS_POLICY_ID;
30  import org.omg.PortableServer.IdUniquenessPolicy;
31  import org.omg.PortableServer.IdUniquenessPolicyValue;
32  
33  final class IdUniquenessPolicyImpl extends org.omg.CORBA.LocalObject implements IdUniquenessPolicy
34  {
35  
36      private static final long serialVersionUID = -2373453208253083393L;
37  
38      public IdUniquenessPolicyImpl(IdUniquenessPolicyValue value)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/oa/poa/IdUniquenessPolicyImpl.java
      * Line Number: 33
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.oa.poa;
27  
28  import org.omg.CORBA.Policy;
29  import org.omg.PortableServer.ID_UNIQUENESS_POLICY_ID;
30  import org.omg.PortableServer.IdUniquenessPolicy;
31  import org.omg.PortableServer.IdUniquenessPolicyValue;
32  
33  final class IdUniquenessPolicyImpl extends org.omg.CORBA.LocalObject implements IdUniquenessPolicy
34  {
35  
36      private static final long serialVersionUID = -2373453208253083393L;
37  
38      public IdUniquenessPolicyImpl(IdUniquenessPolicyValue value)
39      {
40          this.value = value;
41      }
42  
43      public IdUniquenessPolicyValue value()
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/oa/poa/ImplicitActivationPolicyImpl.java
      * Line Number: 28
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
18   * 2 along with this work; if not, write to the Free Software Foundation,
19   * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
20   *
21   * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
22   * or visit www.oracle.com if you need additional information or have any
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.oa.poa;
27  
28  import org.omg.CORBA.Policy;
29  import org.omg.PortableServer.IMPLICIT_ACTIVATION_POLICY_ID;
30  import org.omg.PortableServer.ImplicitActivationPolicy;
31  import org.omg.PortableServer.ImplicitActivationPolicyValue;
32  
33  final class ImplicitActivationPolicyImpl extends org.omg.CORBA.LocalObject implements ImplicitActivationPolicy
34  {
35  
36      private static final long serialVersionUID = 3189145753312485561L;
37  
38      public ImplicitActivationPolicyImpl(ImplicitActivationPolicyValue value)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/oa/poa/ImplicitActivationPolicyImpl.java
      * Line Number: 33
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.oa.poa;
27  
28  import org.omg.CORBA.Policy;
29  import org.omg.PortableServer.IMPLICIT_ACTIVATION_POLICY_ID;
30  import org.omg.PortableServer.ImplicitActivationPolicy;
31  import org.omg.PortableServer.ImplicitActivationPolicyValue;
32  
33  final class ImplicitActivationPolicyImpl extends org.omg.CORBA.LocalObject implements ImplicitActivationPolicy
34  {
35  
36      private static final long serialVersionUID = 3189145753312485561L;
37  
38      public ImplicitActivationPolicyImpl(ImplicitActivationPolicyValue value)
39      {
40          this.value = value;
41      }
42  
43      public ImplicitActivationPolicyValue value()
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/oa/poa/LifespanPolicyImpl.java
      * Line Number: 28
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
18   * 2 along with this work; if not, write to the Free Software Foundation,
19   * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
20   *
21   * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
22   * or visit www.oracle.com if you need additional information or have any
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.oa.poa;
27  
28  import org.omg.CORBA.Policy;
29  import org.omg.PortableServer.LIFESPAN_POLICY_ID;
30  import org.omg.PortableServer.LifespanPolicy;
31  import org.omg.PortableServer.LifespanPolicyValue;
32  
33  final class LifespanPolicyImpl extends org.omg.CORBA.LocalObject implements LifespanPolicy
34  {
35  
36      private static final long serialVersionUID = -7620425659409055717L;
37  
38      public LifespanPolicyImpl(LifespanPolicyValue value)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/oa/poa/LifespanPolicyImpl.java
      * Line Number: 33
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.oa.poa;
27  
28  import org.omg.CORBA.Policy;
29  import org.omg.PortableServer.LIFESPAN_POLICY_ID;
30  import org.omg.PortableServer.LifespanPolicy;
31  import org.omg.PortableServer.LifespanPolicyValue;
32  
33  final class LifespanPolicyImpl extends org.omg.CORBA.LocalObject implements LifespanPolicy
34  {
35  
36      private static final long serialVersionUID = -7620425659409055717L;
37  
38      public LifespanPolicyImpl(LifespanPolicyValue value)
39      {
40          this.value = value;
41      }
42  
43      public LifespanPolicyValue value()
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/oa/poa/POACurrent.java
      * Line Number: 174
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
164      }
165  
166      private void throwInternalIfNull(Object o)
167      {
168          if (o == null)
169          {
170              throw wrapper.poacurrentNullField(CompletionStatus.COMPLETED_MAYBE);
171          }
172      }
173  
174      public org.omg.CORBA.Object get_reference() throws NoContext
175      {
176          Servant servant = get_servant();
177          if (servant != null)
178              return servant._this_object(orb);
179          return null;
180      }
181  
182      public Servant get_servant() throws NoContext
183      {
184          return getServant();
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/oa/poa/POACurrent.java
      * Line Number: 35
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
25  
26  package org.jboss.com.sun.corba.se.impl.oa.poa;
27  
28  import java.util.EmptyStackException;
29  
30  import org.jboss.com.sun.corba.se.impl.logging.POASystemException;
31  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
32  import org.jboss.com.sun.corba.se.spi.oa.OAInvocationInfo;
33  import org.jboss.com.sun.corba.se.spi.oa.ObjectAdapter;
34  import org.jboss.com.sun.corba.se.spi.orb.ORB;
35  import org.omg.CORBA.CompletionStatus;
36  import org.omg.PortableServer.POA;
37  import org.omg.PortableServer.Servant;
38  import org.omg.PortableServer.CurrentPackage.NoContext;
39  import org.omg.PortableServer.ServantLocatorPackage.CookieHolder;
40  
41  // XXX Needs to be turned into LocalObjectImpl.
42  
43  public class POACurrent extends org.omg.CORBA.portable.ObjectImpl implements org.omg.PortableServer.Current
44  {
45      private static final long serialVersionUID = 6652432719945390553L;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/oa/poa/POACurrent.java
      * Line Number: 43
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
33  import org.jboss.com.sun.corba.se.spi.oa.ObjectAdapter;
34  import org.jboss.com.sun.corba.se.spi.orb.ORB;
35  import org.omg.CORBA.CompletionStatus;
36  import org.omg.PortableServer.POA;
37  import org.omg.PortableServer.Servant;
38  import org.omg.PortableServer.CurrentPackage.NoContext;
39  import org.omg.PortableServer.ServantLocatorPackage.CookieHolder;
40  
41  // XXX Needs to be turned into LocalObjectImpl.
42  
43  public class POACurrent extends org.omg.CORBA.portable.ObjectImpl implements org.omg.PortableServer.Current
44  {
45      private static final long serialVersionUID = 6652432719945390553L;
46  
47      private ORB orb;
48  
49      private POASystemException wrapper;
50  
51      public POACurrent(ORB orb)
52      {
53          this.orb = orb;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/oa/poa/POAFactory.java
      * Line Number: 45
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
35  import org.jboss.com.sun.corba.se.impl.logging.OMGSystemException;
36  import org.jboss.com.sun.corba.se.impl.logging.POASystemException;
37  import org.jboss.com.sun.corba.se.impl.orbutil.ORBConstants;
38  import org.jboss.com.sun.corba.se.spi.ior.ObjectAdapterId;
39  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
40  import org.jboss.com.sun.corba.se.spi.oa.ObjectAdapter;
41  import org.jboss.com.sun.corba.se.spi.oa.ObjectAdapterFactory;
42  import org.jboss.com.sun.corba.se.spi.orb.ORB;
43  import org.jboss.com.sun.corba.se.spi.orbutil.closure.Closure;
44  import org.jboss.com.sun.corba.se.spi.orbutil.closure.ClosureFactory;
45  import org.omg.CORBA.OBJECT_NOT_EXIST;
46  import org.omg.CORBA.TRANSIENT;
47  import org.omg.CORBA.ORBPackage.InvalidName;
48  import org.omg.PortableServer.POA;
49  import org.omg.PortableServer.POAManager;
50  import org.omg.PortableServer.Servant;
51  
52  public class POAFactory implements ObjectAdapterFactory
53  {
54      // Maps servants to POAs for deactivating servants when unexportObject is called.
55      // Maintained by POAs activate_object and deactivate_object.
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/oa/poa/POAFactory.java
      * Line Number: 46
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
36  import org.jboss.com.sun.corba.se.impl.logging.POASystemException;
37  import org.jboss.com.sun.corba.se.impl.orbutil.ORBConstants;
38  import org.jboss.com.sun.corba.se.spi.ior.ObjectAdapterId;
39  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
40  import org.jboss.com.sun.corba.se.spi.oa.ObjectAdapter;
41  import org.jboss.com.sun.corba.se.spi.oa.ObjectAdapterFactory;
42  import org.jboss.com.sun.corba.se.spi.orb.ORB;
43  import org.jboss.com.sun.corba.se.spi.orbutil.closure.Closure;
44  import org.jboss.com.sun.corba.se.spi.orbutil.closure.ClosureFactory;
45  import org.omg.CORBA.OBJECT_NOT_EXIST;
46  import org.omg.CORBA.TRANSIENT;
47  import org.omg.CORBA.ORBPackage.InvalidName;
48  import org.omg.PortableServer.POA;
49  import org.omg.PortableServer.POAManager;
50  import org.omg.PortableServer.Servant;
51  
52  public class POAFactory implements ObjectAdapterFactory
53  {
54      // Maps servants to POAs for deactivating servants when unexportObject is called.
55      // Maintained by POAs activate_object and deactivate_object.
56      private Map<Servant, POA> exportedServantsToPOA = new WeakHashMap<Servant, POA>();
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/oa/poa/POAFactory.java
      * Line Number: 47
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
37  import org.jboss.com.sun.corba.se.impl.orbutil.ORBConstants;
38  import org.jboss.com.sun.corba.se.spi.ior.ObjectAdapterId;
39  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
40  import org.jboss.com.sun.corba.se.spi.oa.ObjectAdapter;
41  import org.jboss.com.sun.corba.se.spi.oa.ObjectAdapterFactory;
42  import org.jboss.com.sun.corba.se.spi.orb.ORB;
43  import org.jboss.com.sun.corba.se.spi.orbutil.closure.Closure;
44  import org.jboss.com.sun.corba.se.spi.orbutil.closure.ClosureFactory;
45  import org.omg.CORBA.OBJECT_NOT_EXIST;
46  import org.omg.CORBA.TRANSIENT;
47  import org.omg.CORBA.ORBPackage.InvalidName;
48  import org.omg.PortableServer.POA;
49  import org.omg.PortableServer.POAManager;
50  import org.omg.PortableServer.Servant;
51  
52  public class POAFactory implements ObjectAdapterFactory
53  {
54      // Maps servants to POAs for deactivating servants when unexportObject is called.
55      // Maintained by POAs activate_object and deactivate_object.
56      private Map<Servant, POA> exportedServantsToPOA = new WeakHashMap<Servant, POA>();
57  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/oa/poa/POAImpl.java
      * Line Number: 1336
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
1326                  ORBUtility.dprint(this, "Exiting deactivate_object on poa " + this);
1327              }
1328  
1329              unlock();
1330          }
1331      }
1332  
1333      /**
1334       * <code>create_reference</code> <b>3.3.8.17</b>
1335       */
1336      public org.omg.CORBA.Object create_reference(String repId) throws WrongPolicy
1337      {
1338          try
1339          {
1340              lock();
1341  
1342              if (debug)
1343              {
1344                  ORBUtility.dprint(this, "Calling create_reference(repId=" + repId + ") on poa " + this);
1345              }
1346  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/oa/poa/POAImpl.java
      * Line Number: 1358
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
1348          }
1349          finally
1350          {
1351              unlock();
1352          }
1353      }
1354  
1355      /**
1356       * <code>create_reference_with_id</code> <b>3.3.8.18</b>
1357       */
1358      public org.omg.CORBA.Object create_reference_with_id(byte[] oid, String repId)
1359      {
1360          try
1361          {
1362              lock();
1363  
1364              if (debug)
1365              {
1366                  ORBUtility.dprint(this, "Calling create_reference_with_id(oid=" + oid + " repId=" + repId + ") on poa "
1367                          + this);
1368              }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/oa/poa/POAImpl.java
      * Line Number: 1407
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
1397          }
1398          finally
1399          {
1400              unlock();
1401          }
1402      }
1403  
1404      /**
1405       * <code>servant_to_reference</code> <b>3.3.8.20</b>
1406       */
1407      public org.omg.CORBA.Object servant_to_reference(Servant servant) throws ServantNotActive, WrongPolicy
1408      {
1409          try
1410          {
1411              lock();
1412  
1413              if (debug)
1414              {
1415                  ORBUtility.dprint(this, "Calling servant_to_reference(servant=" + servant + ") on poa " + this);
1416              }
1417  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/oa/poa/POAImpl.java
      * Line Number: 1431
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
1421          }
1422          finally
1423          {
1424              unlock();
1425          }
1426      }
1427  
1428      /**
1429       * <code>reference_to_servant</code> <b>3.3.8.21</b>
1430       */
1431      public Servant reference_to_servant(org.omg.CORBA.Object reference) throws ObjectNotActive, WrongPolicy,
1432              WrongAdapter
1433      {
1434          try
1435          {
1436              lock();
1437  
1438              if (debug)
1439              {
1440                  ORBUtility.dprint(this, "Calling reference_to_servant(reference=" + reference + ") on poa " + this);
1441              }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/oa/poa/POAImpl.java
      * Line Number: 1462
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
1452          }
1453          finally
1454          {
1455              unlock();
1456          }
1457      }
1458  
1459      /**
1460       * <code>reference_to_id</code> <b>3.3.8.22</b>
1461       */
1462      public byte[] reference_to_id(org.omg.CORBA.Object reference) throws WrongAdapter, WrongPolicy
1463      {
1464          try
1465          {
1466              lock();
1467  
1468              if (debug)
1469              {
1470                  ORBUtility.dprint(this, "Calling reference_to_id(reference=" + reference + ") on poa " + this);
1471              }
1472  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/oa/poa/POAImpl.java
      * Line Number: 1515
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
1505          }
1506          finally
1507          {
1508              unlock();
1509          }
1510      }
1511  
1512      /**
1513       * <code>id_to_reference</code> <b>3.3.8.24</b>
1514       */
1515      public org.omg.CORBA.Object id_to_reference(byte[] id) throws ObjectNotActive, WrongPolicy
1516  
1517      {
1518          try
1519          {
1520              lock();
1521  
1522              if (debug)
1523              {
1524                  ORBUtility.dprint(this, "Calling id_to_reference(id=" + id + ") on poa " + this);
1525              }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/oa/poa/POAImpl.java
      * Line Number: 1701
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
1691          {
1692              if (debug)
1693              {
1694                  ORBUtility.dprint(this, "Exiting getInvocationServant on poa " + this);
1695              }
1696  
1697              unlock();
1698          }
1699      }
1700  
1701      public org.omg.CORBA.Object getLocalServant(byte[] objectId)
1702      {
1703          return null;
1704      }
1705  
1706      /**
1707       * Called from the subcontract to let this POA cleanup after an invocation. Note: If getServant was called, then
1708       * returnServant MUST be called, even in the case of exceptions. This may be called multiple times for a single
1709       * request.
1710       */
1711      public void returnServant()
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/oa/poa/POAImpl.java
      * Line Number: 476
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
466  
467              if (debug)
468              {
469                  ORBUtility.dprint(this, "Exiting destroyIfNotInitDone on poa " + this);
470              }
471  
472              unlock();
473          }
474      }
475  
476      private byte[] internalReferenceToId(org.omg.CORBA.Object reference) throws WrongAdapter
477      {
478          IOR ior = ORBUtility.getIOR(reference);
479          IORTemplateList thisTemplate = ior.getIORTemplates();
480  
481          ObjectReferenceFactory orf = getCurrentFactory();
482          IORTemplateList poaTemplate = IORFactories.getIORTemplateList(orf);
483  
484          if (!poaTemplate.isEquivalent(thisTemplate))
485              throw new WrongAdapter();
486  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/oa/poa/POAImpl.java
      * Line Number: 57
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
47  import org.jboss.com.sun.corba.se.spi.ior.IORTemplateList;
48  import org.jboss.com.sun.corba.se.spi.ior.ObjectAdapterId;
49  import org.jboss.com.sun.corba.se.spi.ior.ObjectId;
50  import org.jboss.com.sun.corba.se.spi.ior.ObjectKeyTemplate;
51  import org.jboss.com.sun.corba.se.spi.ior.TaggedProfile;
52  import org.jboss.com.sun.corba.se.spi.oa.OADestroyed;
53  import org.jboss.com.sun.corba.se.spi.oa.OAInvocationInfo;
54  import org.jboss.com.sun.corba.se.spi.oa.ObjectAdapterBase;
55  import org.jboss.com.sun.corba.se.spi.orb.ORB;
56  import org.jboss.com.sun.corba.se.spi.protocol.ForwardException;
57  import org.omg.CORBA.Policy;
58  import org.omg.CORBA.SystemException;
59  import org.omg.PortableInterceptor.NON_EXISTENT;
60  import org.omg.PortableInterceptor.ObjectReferenceFactory;
61  import org.omg.PortableInterceptor.ObjectReferenceTemplate;
62  import org.omg.PortableServer.AdapterActivator;
63  import org.omg.PortableServer.ForwardRequest;
64  import org.omg.PortableServer.IdAssignmentPolicy;
65  import org.omg.PortableServer.IdAssignmentPolicyValue;
66  import org.omg.PortableServer.IdUniquenessPolicy;
67  import org.omg.PortableServer.IdUniquenessPolicyValue;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/oa/poa/POAImpl.java
      * Line Number: 58
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
48  import org.jboss.com.sun.corba.se.spi.ior.ObjectAdapterId;
49  import org.jboss.com.sun.corba.se.spi.ior.ObjectId;
50  import org.jboss.com.sun.corba.se.spi.ior.ObjectKeyTemplate;
51  import org.jboss.com.sun.corba.se.spi.ior.TaggedProfile;
52  import org.jboss.com.sun.corba.se.spi.oa.OADestroyed;
53  import org.jboss.com.sun.corba.se.spi.oa.OAInvocationInfo;
54  import org.jboss.com.sun.corba.se.spi.oa.ObjectAdapterBase;
55  import org.jboss.com.sun.corba.se.spi.orb.ORB;
56  import org.jboss.com.sun.corba.se.spi.protocol.ForwardException;
57  import org.omg.CORBA.Policy;
58  import org.omg.CORBA.SystemException;
59  import org.omg.PortableInterceptor.NON_EXISTENT;
60  import org.omg.PortableInterceptor.ObjectReferenceFactory;
61  import org.omg.PortableInterceptor.ObjectReferenceTemplate;
62  import org.omg.PortableServer.AdapterActivator;
63  import org.omg.PortableServer.ForwardRequest;
64  import org.omg.PortableServer.IdAssignmentPolicy;
65  import org.omg.PortableServer.IdAssignmentPolicyValue;
66  import org.omg.PortableServer.IdUniquenessPolicy;
67  import org.omg.PortableServer.IdUniquenessPolicyValue;
68  import org.omg.PortableServer.ImplicitActivationPolicy;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/oa/poa/POAManagerImpl.java
      * Line Number: 35
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
25  
26  package org.jboss.com.sun.corba.se.impl.oa.poa;
27  
28  import java.util.HashSet;
29  import java.util.Iterator;
30  import java.util.Set;
31  
32  import org.jboss.com.sun.corba.se.impl.logging.POASystemException;
33  import org.jboss.com.sun.corba.se.impl.orbutil.ORBUtility;
34  import org.jboss.com.sun.corba.se.spi.protocol.PIHandler;
35  import org.omg.CORBA.CompletionStatus;
36  import org.omg.PortableInterceptor.ACTIVE;
37  import org.omg.PortableInterceptor.DISCARDING;
38  import org.omg.PortableInterceptor.HOLDING;
39  import org.omg.PortableInterceptor.INACTIVE;
40  import org.omg.PortableInterceptor.NON_EXISTENT;
41  import org.omg.PortableServer.POA;
42  import org.omg.PortableServer.POAManager;
43  import org.omg.PortableServer.POAManagerPackage.State;
44  
45  /**
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/oa/poa/POAManagerImpl.java
      * Line Number: 50
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
40  import org.omg.PortableInterceptor.NON_EXISTENT;
41  import org.omg.PortableServer.POA;
42  import org.omg.PortableServer.POAManager;
43  import org.omg.PortableServer.POAManagerPackage.State;
44  
45  /**
46   * POAManagerImpl is the implementation of the POAManager interface. Its public methods are activate(), hold_requests(),
47   * discard_requests() and deactivate().
48   */
49  
50  public class POAManagerImpl extends org.omg.CORBA.LocalObject implements POAManager
51  {
52      private static final long serialVersionUID = 5295604954267836516L;
53  
54      private final POAFactory factory; // factory which contains global state for all POAManagers
55  
56      private PIHandler pihandler; // for adapterManagerStateChanged
57  
58      private State state; // current state of this POAManager
59  
60      private Set<POA> poas = new HashSet<POA>(4); // all poas controlled by this POAManager
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/oa/poa/POAPolicyMediatorImpl_R_USM.java
      * Line Number: 35
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
25  
26  package org.jboss.com.sun.corba.se.impl.oa.poa;
27  
28  import java.util.Set;
29  
30  import org.jboss.com.sun.corba.se.impl.oa.NullServantImpl;
31  import org.jboss.com.sun.corba.se.impl.oa.poa.ActiveObjectMap.Key;
32  import org.jboss.com.sun.corba.se.impl.orbutil.ORBUtility;
33  import org.jboss.com.sun.corba.se.spi.oa.NullServant;
34  import org.jboss.com.sun.corba.se.spi.oa.OAInvocationInfo;
35  import org.omg.CORBA.SystemException;
36  import org.omg.PortableServer.ForwardRequest;
37  import org.omg.PortableServer.Servant;
38  import org.omg.PortableServer.ServantActivator;
39  import org.omg.PortableServer.ServantManager;
40  import org.omg.PortableServer.POAPackage.NoServant;
41  import org.omg.PortableServer.POAPackage.ObjectNotActive;
42  import org.omg.PortableServer.POAPackage.WrongPolicy;
43  
44  /**
45   * Implementation of POARequesHandler that provides policy specific operations on the POA.
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/oa/poa/Policies.java
      * Line Number: 35
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
25  package org.jboss.com.sun.corba.se.impl.oa.poa;
26  
27  import java.util.BitSet;
28  import java.util.HashMap;
29  import java.util.Iterator;
30  
31  import org.jboss.com.sun.corba.se.impl.orbutil.ORBConstants;
32  import org.jboss.com.sun.corba.se.spi.extension.CopyObjectPolicy;
33  import org.jboss.com.sun.corba.se.spi.extension.ServantCachingPolicy;
34  import org.jboss.com.sun.corba.se.spi.extension.ZeroPortPolicy;
35  import org.omg.CORBA.Policy;
36  import org.omg.PortableServer.ID_ASSIGNMENT_POLICY_ID;
37  import org.omg.PortableServer.ID_UNIQUENESS_POLICY_ID;
38  import org.omg.PortableServer.IMPLICIT_ACTIVATION_POLICY_ID;
39  import org.omg.PortableServer.IdAssignmentPolicy;
40  import org.omg.PortableServer.IdAssignmentPolicyValue;
41  import org.omg.PortableServer.IdUniquenessPolicy;
42  import org.omg.PortableServer.IdUniquenessPolicyValue;
43  import org.omg.PortableServer.ImplicitActivationPolicy;
44  import org.omg.PortableServer.ImplicitActivationPolicyValue;
45  import org.omg.PortableServer.LIFESPAN_POLICY_ID;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/oa/poa/RequestProcessingPolicyImpl.java
      * Line Number: 28
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
18   * 2 along with this work; if not, write to the Free Software Foundation,
19   * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
20   *
21   * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
22   * or visit www.oracle.com if you need additional information or have any
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.oa.poa;
27  
28  import org.omg.CORBA.Policy;
29  import org.omg.PortableServer.REQUEST_PROCESSING_POLICY_ID;
30  import org.omg.PortableServer.RequestProcessingPolicy;
31  import org.omg.PortableServer.RequestProcessingPolicyValue;
32  
33  public class RequestProcessingPolicyImpl extends org.omg.CORBA.LocalObject implements RequestProcessingPolicy
34  {
35  
36      private static final long serialVersionUID = 5900928116128639434L;
37  
38      public RequestProcessingPolicyImpl(RequestProcessingPolicyValue value)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/oa/poa/RequestProcessingPolicyImpl.java
      * Line Number: 33
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.oa.poa;
27  
28  import org.omg.CORBA.Policy;
29  import org.omg.PortableServer.REQUEST_PROCESSING_POLICY_ID;
30  import org.omg.PortableServer.RequestProcessingPolicy;
31  import org.omg.PortableServer.RequestProcessingPolicyValue;
32  
33  public class RequestProcessingPolicyImpl extends org.omg.CORBA.LocalObject implements RequestProcessingPolicy
34  {
35  
36      private static final long serialVersionUID = 5900928116128639434L;
37  
38      public RequestProcessingPolicyImpl(RequestProcessingPolicyValue value)
39      {
40          this.value = value;
41      }
42  
43      public RequestProcessingPolicyValue value()
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/oa/poa/ServantRetentionPolicyImpl.java
      * Line Number: 28
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
18   * 2 along with this work; if not, write to the Free Software Foundation,
19   * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
20   *
21   * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
22   * or visit www.oracle.com if you need additional information or have any
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.oa.poa;
27  
28  import org.omg.CORBA.Policy;
29  import org.omg.PortableServer.SERVANT_RETENTION_POLICY_ID;
30  import org.omg.PortableServer.ServantRetentionPolicy;
31  import org.omg.PortableServer.ServantRetentionPolicyValue;
32  
33  final class ServantRetentionPolicyImpl extends org.omg.CORBA.LocalObject implements ServantRetentionPolicy
34  {
35  
36      private static final long serialVersionUID = 7744962424711138173L;
37  
38      public ServantRetentionPolicyImpl(ServantRetentionPolicyValue value)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/oa/poa/ServantRetentionPolicyImpl.java
      * Line Number: 33
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.oa.poa;
27  
28  import org.omg.CORBA.Policy;
29  import org.omg.PortableServer.SERVANT_RETENTION_POLICY_ID;
30  import org.omg.PortableServer.ServantRetentionPolicy;
31  import org.omg.PortableServer.ServantRetentionPolicyValue;
32  
33  final class ServantRetentionPolicyImpl extends org.omg.CORBA.LocalObject implements ServantRetentionPolicy
34  {
35  
36      private static final long serialVersionUID = 7744962424711138173L;
37  
38      public ServantRetentionPolicyImpl(ServantRetentionPolicyValue value)
39      {
40          this.value = value;
41      }
42  
43      public ServantRetentionPolicyValue value()
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/oa/poa/ThreadPolicyImpl.java
      * Line Number: 28
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
18   * 2 along with this work; if not, write to the Free Software Foundation,
19   * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
20   *
21   * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
22   * or visit www.oracle.com if you need additional information or have any
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.oa.poa;
27  
28  import org.omg.CORBA.Policy;
29  import org.omg.PortableServer.THREAD_POLICY_ID;
30  import org.omg.PortableServer.ThreadPolicy;
31  import org.omg.PortableServer.ThreadPolicyValue;
32  
33  final class ThreadPolicyImpl extends org.omg.CORBA.LocalObject implements ThreadPolicy
34  {
35  
36      private static final long serialVersionUID = -1130695147546073341L;
37  
38      public ThreadPolicyImpl(ThreadPolicyValue value)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/oa/poa/ThreadPolicyImpl.java
      * Line Number: 33
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.oa.poa;
27  
28  import org.omg.CORBA.Policy;
29  import org.omg.PortableServer.THREAD_POLICY_ID;
30  import org.omg.PortableServer.ThreadPolicy;
31  import org.omg.PortableServer.ThreadPolicyValue;
32  
33  final class ThreadPolicyImpl extends org.omg.CORBA.LocalObject implements ThreadPolicy
34  {
35  
36      private static final long serialVersionUID = -1130695147546073341L;
37  
38      public ThreadPolicyImpl(ThreadPolicyValue value)
39      {
40          this.value = value;
41      }
42  
43      public ThreadPolicyValue value()
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/orb/ORBVersionImpl.java
      * Line Number: 29
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
19   * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
20   *
21   * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
22   * or visit www.oracle.com if you need additional information or have any
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.orb;
27  
28  import org.jboss.com.sun.corba.se.spi.orb.ORBVersion;
29  import org.omg.CORBA.portable.OutputStream;
30  
31  public class ORBVersionImpl implements ORBVersion
32  {
33      private byte orbType;
34  
35      public ORBVersionImpl(byte orbType)
36      {
37          this.orbType = orbType;
38      }
39  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/orbutil/IIOPInputStream_1_3.java
      * Line Number: 39
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
29  import java.io.ObjectInputStream;
30  import java.util.Hashtable;
31  
32  /**
33   * Implements legacy behavior from before Ladybird to maintain backwards compatibility.
34   */
35  public class IIOPInputStream_1_3 extends org.jboss.com.sun.corba.se.impl.io.IIOPInputStream
36  {
37      // The newer version in the io package correctly reads a wstring instead.
38      // This concerns bug 4379597.
39      protected String internalReadUTF(org.omg.CORBA.portable.InputStream stream)
40      {
41          return stream.read_string();
42      }
43  
44      /**
45       * Before JDK 1.3.1_01, the PutField/GetField implementation actually sent a Hashtable.
46       */
47      @SuppressWarnings("unchecked")
48      public ObjectInputStream.GetField readFields() throws IOException, ClassNotFoundException, NotActiveException
49      {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/orbutil/IIOPOutputStream_1_3.java
      * Line Number: 41
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
31   * Implements legacy behavior from before Ladybird to maintain backwards compatibility.
32   */
33  @SuppressWarnings("deprecation")
34  public class IIOPOutputStream_1_3 extends org.jboss.com.sun.corba.se.impl.io.IIOPOutputStream
35  {
36      // We can't assume that the superclass's putFields member will be non-private. We must allow the RI to run on JDK
37      // 1.3.1 FCS as well as the JDK 1.3.1_01 patch.
38      private ObjectOutputStream.PutField putFields_1_3;
39  
40      // The newer version in the io package correctly writes a wstring instead. This concerns bug 4379597.
41      protected void internalWriteUTF(org.omg.CORBA.portable.OutputStream stream, String data)
42      {
43          stream.write_string(data);
44      }
45  
46      public IIOPOutputStream_1_3() throws java.io.IOException
47      {
48          super();
49      }
50  
51      /**
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/orbutil/ORBUtility.java
      * Line Number: 122
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
112          {
113              return (type.kind().value() == TCKind._tk_except && type.member_count() == 3
114                      && type.member_type(0).equal(systemExceptionMembers[0].type)
115                      && type.member_type(1).equal(systemExceptionMembers[1].type) && type.member_type(2).equal(
116                      systemExceptionMembers[2].type));
117          }
118          catch (BadKind ex)
119          {
120              return false;
121          }
122          catch (org.omg.CORBA.TypeCodePackage.Bounds ex)
123          {
124              return false;
125          }
126      }
127  
128      /**
129       * Static method for writing a CORBA standard exception to an Any.
130       * 
131       * @param any
132       *            The Any to write the SystemException into.
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/orbutil/ORBUtility.java
      * Line Number: 60
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
50  import org.jboss.com.sun.corba.se.spi.ior.iiop.IIOPProfile;
51  import org.jboss.com.sun.corba.se.spi.ior.iiop.IIOPProfileTemplate;
52  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
53  import org.jboss.com.sun.corba.se.spi.orb.ORB;
54  import org.jboss.com.sun.corba.se.spi.orb.ORBVersion;
55  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
56  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
57  import org.jboss.com.sun.corba.se.spi.protocol.CorbaClientDelegate;
58  import org.jboss.com.sun.corba.se.spi.protocol.CorbaMessageMediator;
59  import org.jboss.com.sun.corba.se.spi.transport.CorbaContactInfoList;
60  import org.omg.CORBA.Any;
61  import org.omg.CORBA.BAD_OPERATION;
62  import org.omg.CORBA.BAD_PARAM;
63  import org.omg.CORBA.CompletionStatus;
64  import org.omg.CORBA.INTERNAL;
65  import org.omg.CORBA.StructMember;
66  import org.omg.CORBA.SystemException;
67  import org.omg.CORBA.TCKind;
68  import org.omg.CORBA.TypeCode;
69  import org.omg.CORBA.TypeCodePackage.BadKind;
70  import org.omg.CORBA.portable.InputStream;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/orbutil/ORBUtility.java
      * Line Number: 61
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
51  import org.jboss.com.sun.corba.se.spi.ior.iiop.IIOPProfileTemplate;
52  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
53  import org.jboss.com.sun.corba.se.spi.orb.ORB;
54  import org.jboss.com.sun.corba.se.spi.orb.ORBVersion;
55  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
56  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
57  import org.jboss.com.sun.corba.se.spi.protocol.CorbaClientDelegate;
58  import org.jboss.com.sun.corba.se.spi.protocol.CorbaMessageMediator;
59  import org.jboss.com.sun.corba.se.spi.transport.CorbaContactInfoList;
60  import org.omg.CORBA.Any;
61  import org.omg.CORBA.BAD_OPERATION;
62  import org.omg.CORBA.BAD_PARAM;
63  import org.omg.CORBA.CompletionStatus;
64  import org.omg.CORBA.INTERNAL;
65  import org.omg.CORBA.StructMember;
66  import org.omg.CORBA.SystemException;
67  import org.omg.CORBA.TCKind;
68  import org.omg.CORBA.TypeCode;
69  import org.omg.CORBA.TypeCodePackage.BadKind;
70  import org.omg.CORBA.portable.InputStream;
71  import org.omg.CORBA.portable.OutputStream;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/orbutil/ORBUtility.java
      * Line Number: 62
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
52  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
53  import org.jboss.com.sun.corba.se.spi.orb.ORB;
54  import org.jboss.com.sun.corba.se.spi.orb.ORBVersion;
55  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
56  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
57  import org.jboss.com.sun.corba.se.spi.protocol.CorbaClientDelegate;
58  import org.jboss.com.sun.corba.se.spi.protocol.CorbaMessageMediator;
59  import org.jboss.com.sun.corba.se.spi.transport.CorbaContactInfoList;
60  import org.omg.CORBA.Any;
61  import org.omg.CORBA.BAD_OPERATION;
62  import org.omg.CORBA.BAD_PARAM;
63  import org.omg.CORBA.CompletionStatus;
64  import org.omg.CORBA.INTERNAL;
65  import org.omg.CORBA.StructMember;
66  import org.omg.CORBA.SystemException;
67  import org.omg.CORBA.TCKind;
68  import org.omg.CORBA.TypeCode;
69  import org.omg.CORBA.TypeCodePackage.BadKind;
70  import org.omg.CORBA.portable.InputStream;
71  import org.omg.CORBA.portable.OutputStream;
72  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/orbutil/ORBUtility.java
      * Line Number: 63
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
53  import org.jboss.com.sun.corba.se.spi.orb.ORB;
54  import org.jboss.com.sun.corba.se.spi.orb.ORBVersion;
55  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
56  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
57  import org.jboss.com.sun.corba.se.spi.protocol.CorbaClientDelegate;
58  import org.jboss.com.sun.corba.se.spi.protocol.CorbaMessageMediator;
59  import org.jboss.com.sun.corba.se.spi.transport.CorbaContactInfoList;
60  import org.omg.CORBA.Any;
61  import org.omg.CORBA.BAD_OPERATION;
62  import org.omg.CORBA.BAD_PARAM;
63  import org.omg.CORBA.CompletionStatus;
64  import org.omg.CORBA.INTERNAL;
65  import org.omg.CORBA.StructMember;
66  import org.omg.CORBA.SystemException;
67  import org.omg.CORBA.TCKind;
68  import org.omg.CORBA.TypeCode;
69  import org.omg.CORBA.TypeCodePackage.BadKind;
70  import org.omg.CORBA.portable.InputStream;
71  import org.omg.CORBA.portable.OutputStream;
72  
73  /**
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/orbutil/ORBUtility.java
      * Line Number: 64
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
54  import org.jboss.com.sun.corba.se.spi.orb.ORBVersion;
55  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
56  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
57  import org.jboss.com.sun.corba.se.spi.protocol.CorbaClientDelegate;
58  import org.jboss.com.sun.corba.se.spi.protocol.CorbaMessageMediator;
59  import org.jboss.com.sun.corba.se.spi.transport.CorbaContactInfoList;
60  import org.omg.CORBA.Any;
61  import org.omg.CORBA.BAD_OPERATION;
62  import org.omg.CORBA.BAD_PARAM;
63  import org.omg.CORBA.CompletionStatus;
64  import org.omg.CORBA.INTERNAL;
65  import org.omg.CORBA.StructMember;
66  import org.omg.CORBA.SystemException;
67  import org.omg.CORBA.TCKind;
68  import org.omg.CORBA.TypeCode;
69  import org.omg.CORBA.TypeCodePackage.BadKind;
70  import org.omg.CORBA.portable.InputStream;
71  import org.omg.CORBA.portable.OutputStream;
72  
73  /**
74   * Handy class full of static functions that don't belong in util.Utility for pure ORB reasons.
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/orbutil/ORBUtility.java
      * Line Number: 65
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
55  import org.jboss.com.sun.corba.se.spi.orb.ORBVersionFactory;
56  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
57  import org.jboss.com.sun.corba.se.spi.protocol.CorbaClientDelegate;
58  import org.jboss.com.sun.corba.se.spi.protocol.CorbaMessageMediator;
59  import org.jboss.com.sun.corba.se.spi.transport.CorbaContactInfoList;
60  import org.omg.CORBA.Any;
61  import org.omg.CORBA.BAD_OPERATION;
62  import org.omg.CORBA.BAD_PARAM;
63  import org.omg.CORBA.CompletionStatus;
64  import org.omg.CORBA.INTERNAL;
65  import org.omg.CORBA.StructMember;
66  import org.omg.CORBA.SystemException;
67  import org.omg.CORBA.TCKind;
68  import org.omg.CORBA.TypeCode;
69  import org.omg.CORBA.TypeCodePackage.BadKind;
70  import org.omg.CORBA.portable.InputStream;
71  import org.omg.CORBA.portable.OutputStream;
72  
73  /**
74   * Handy class full of static functions that don't belong in util.Utility for pure ORB reasons.
75   */
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/orbutil/ORBUtility.java
      * Line Number: 66
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
56  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
57  import org.jboss.com.sun.corba.se.spi.protocol.CorbaClientDelegate;
58  import org.jboss.com.sun.corba.se.spi.protocol.CorbaMessageMediator;
59  import org.jboss.com.sun.corba.se.spi.transport.CorbaContactInfoList;
60  import org.omg.CORBA.Any;
61  import org.omg.CORBA.BAD_OPERATION;
62  import org.omg.CORBA.BAD_PARAM;
63  import org.omg.CORBA.CompletionStatus;
64  import org.omg.CORBA.INTERNAL;
65  import org.omg.CORBA.StructMember;
66  import org.omg.CORBA.SystemException;
67  import org.omg.CORBA.TCKind;
68  import org.omg.CORBA.TypeCode;
69  import org.omg.CORBA.TypeCodePackage.BadKind;
70  import org.omg.CORBA.portable.InputStream;
71  import org.omg.CORBA.portable.OutputStream;
72  
73  /**
74   * Handy class full of static functions that don't belong in util.Utility for pure ORB reasons.
75   */
76  public final class ORBUtility
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/orbutil/ORBUtility.java
      * Line Number: 67
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
57  import org.jboss.com.sun.corba.se.spi.protocol.CorbaClientDelegate;
58  import org.jboss.com.sun.corba.se.spi.protocol.CorbaMessageMediator;
59  import org.jboss.com.sun.corba.se.spi.transport.CorbaContactInfoList;
60  import org.omg.CORBA.Any;
61  import org.omg.CORBA.BAD_OPERATION;
62  import org.omg.CORBA.BAD_PARAM;
63  import org.omg.CORBA.CompletionStatus;
64  import org.omg.CORBA.INTERNAL;
65  import org.omg.CORBA.StructMember;
66  import org.omg.CORBA.SystemException;
67  import org.omg.CORBA.TCKind;
68  import org.omg.CORBA.TypeCode;
69  import org.omg.CORBA.TypeCodePackage.BadKind;
70  import org.omg.CORBA.portable.InputStream;
71  import org.omg.CORBA.portable.OutputStream;
72  
73  /**
74   * Handy class full of static functions that don't belong in util.Utility for pure ORB reasons.
75   */
76  public final class ORBUtility
77  {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/orbutil/ORBUtility.java
      * Line Number: 68
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
58  import org.jboss.com.sun.corba.se.spi.protocol.CorbaMessageMediator;
59  import org.jboss.com.sun.corba.se.spi.transport.CorbaContactInfoList;
60  import org.omg.CORBA.Any;
61  import org.omg.CORBA.BAD_OPERATION;
62  import org.omg.CORBA.BAD_PARAM;
63  import org.omg.CORBA.CompletionStatus;
64  import org.omg.CORBA.INTERNAL;
65  import org.omg.CORBA.StructMember;
66  import org.omg.CORBA.SystemException;
67  import org.omg.CORBA.TCKind;
68  import org.omg.CORBA.TypeCode;
69  import org.omg.CORBA.TypeCodePackage.BadKind;
70  import org.omg.CORBA.portable.InputStream;
71  import org.omg.CORBA.portable.OutputStream;
72  
73  /**
74   * Handy class full of static functions that don't belong in util.Utility for pure ORB reasons.
75   */
76  public final class ORBUtility
77  {
78      private ORBUtility()
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/orbutil/ORBUtility.java
      * Line Number: 69
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
59  import org.jboss.com.sun.corba.se.spi.transport.CorbaContactInfoList;
60  import org.omg.CORBA.Any;
61  import org.omg.CORBA.BAD_OPERATION;
62  import org.omg.CORBA.BAD_PARAM;
63  import org.omg.CORBA.CompletionStatus;
64  import org.omg.CORBA.INTERNAL;
65  import org.omg.CORBA.StructMember;
66  import org.omg.CORBA.SystemException;
67  import org.omg.CORBA.TCKind;
68  import org.omg.CORBA.TypeCode;
69  import org.omg.CORBA.TypeCodePackage.BadKind;
70  import org.omg.CORBA.portable.InputStream;
71  import org.omg.CORBA.portable.OutputStream;
72  
73  /**
74   * Handy class full of static functions that don't belong in util.Utility for pure ORB reasons.
75   */
76  public final class ORBUtility
77  {
78      private ORBUtility()
79      {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/orbutil/ORBUtility.java
      * Line Number: 70
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
60  import org.omg.CORBA.Any;
61  import org.omg.CORBA.BAD_OPERATION;
62  import org.omg.CORBA.BAD_PARAM;
63  import org.omg.CORBA.CompletionStatus;
64  import org.omg.CORBA.INTERNAL;
65  import org.omg.CORBA.StructMember;
66  import org.omg.CORBA.SystemException;
67  import org.omg.CORBA.TCKind;
68  import org.omg.CORBA.TypeCode;
69  import org.omg.CORBA.TypeCodePackage.BadKind;
70  import org.omg.CORBA.portable.InputStream;
71  import org.omg.CORBA.portable.OutputStream;
72  
73  /**
74   * Handy class full of static functions that don't belong in util.Utility for pure ORB reasons.
75   */
76  public final class ORBUtility
77  {
78      private ORBUtility()
79      {
80      }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/orbutil/ORBUtility.java
      * Line Number: 71
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
61  import org.omg.CORBA.BAD_OPERATION;
62  import org.omg.CORBA.BAD_PARAM;
63  import org.omg.CORBA.CompletionStatus;
64  import org.omg.CORBA.INTERNAL;
65  import org.omg.CORBA.StructMember;
66  import org.omg.CORBA.SystemException;
67  import org.omg.CORBA.TCKind;
68  import org.omg.CORBA.TypeCode;
69  import org.omg.CORBA.TypeCodePackage.BadKind;
70  import org.omg.CORBA.portable.InputStream;
71  import org.omg.CORBA.portable.OutputStream;
72  
73  /**
74   * Handy class full of static functions that don't belong in util.Utility for pure ORB reasons.
75   */
76  public final class ORBUtility
77  {
78      private ORBUtility()
79      {
80      }
81  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/orbutil/ORBUtility.java
      * Line Number: 702
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
692      {
693          ORB orb = ior.getORB();
694          CorbaContactInfoList ccil = orb.getCorbaContactInfoListFactory().create(ior);
695          CorbaClientDelegate del = orb.getClientDelegateFactory().create(ccil);
696          return del;
697      }
698  
699      /**
700       * This method is used to create untyped object references.
701       */
702      public static org.omg.CORBA.Object makeObjectReference(IOR ior)
703      {
704          CorbaClientDelegate del = makeClientDelegate(ior);
705          org.omg.CORBA.Object objectImpl = new CORBAObjectImpl();
706          StubAdapter.setDelegate(objectImpl, del);
707          return objectImpl;
708      }
709  
710      /**
711       * This method obtains an IOR from a CORBA object reference. It will return null if obj is a local object, a null
712       * object, or an object implemented by a different ORB. It will throw BAD_OPERATION if obj is an unconnected
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/orbutil/ORBUtility.java
      * Line Number: 705
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
695          CorbaClientDelegate del = orb.getClientDelegateFactory().create(ccil);
696          return del;
697      }
698  
699      /**
700       * This method is used to create untyped object references.
701       */
702      public static org.omg.CORBA.Object makeObjectReference(IOR ior)
703      {
704          CorbaClientDelegate del = makeClientDelegate(ior);
705          org.omg.CORBA.Object objectImpl = new CORBAObjectImpl();
706          StubAdapter.setDelegate(objectImpl, del);
707          return objectImpl;
708      }
709  
710      /**
711       * This method obtains an IOR from a CORBA object reference. It will return null if obj is a local object, a null
712       * object, or an object implemented by a different ORB. It will throw BAD_OPERATION if obj is an unconnected
713       * RMI-IIOP object.
714       * 
715       * @return IOR the IOR that represents this objref. This will never be null.
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/orbutil/ORBUtility.java
      * Line Number: 721
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
711       * This method obtains an IOR from a CORBA object reference. It will return null if obj is a local object, a null
712       * object, or an object implemented by a different ORB. It will throw BAD_OPERATION if obj is an unconnected
713       * RMI-IIOP object.
714       * 
715       * @return IOR the IOR that represents this objref. This will never be null.
716       * @exception BAD_OPERATION
717       *                (from oi._get_delegate) if obj is a normal objref, but does not have a delegate set.
718       * @exception BAD_PARAM
719       *                if obj is a local object, or else was created by a foreign ORB.
720       */
721      public static IOR getIOR(org.omg.CORBA.Object obj)
722      {
723          if (obj == null)
724              throw wrapper.nullObjectReference();
725  
726          IOR ior = null;
727          if (StubAdapter.isStub(obj))
728          {
729              org.omg.CORBA.portable.Delegate del = StubAdapter.getDelegate(obj);
730  
731              if (del instanceof CorbaClientDelegate)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/orbutil/ORBUtility.java
      * Line Number: 729
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
719       *                if obj is a local object, or else was created by a foreign ORB.
720       */
721      public static IOR getIOR(org.omg.CORBA.Object obj)
722      {
723          if (obj == null)
724              throw wrapper.nullObjectReference();
725  
726          IOR ior = null;
727          if (StubAdapter.isStub(obj))
728          {
729              org.omg.CORBA.portable.Delegate del = StubAdapter.getDelegate(obj);
730  
731              if (del instanceof CorbaClientDelegate)
732              {
733                  CorbaClientDelegate cdel = (CorbaClientDelegate) del;
734                  ContactInfoList cil = cdel.getContactInfoList();
735  
736                  if (cil instanceof CorbaContactInfoList)
737                  {
738                      CorbaContactInfoList ccil = (CorbaContactInfoList) cil;
739                      ior = ccil.getTargetIOR();
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/orbutil/ORBUtility.java
      * Line Number: 774
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
764  
765      /**
766       * Obtains an IOR for the object reference obj, first connecting it to the ORB if necessary.
767       * 
768       * @return IOR the IOR that represents this objref. This will never be null.
769       * @exception BAD_OPERATION
770       *                if the object could not be connected, if a connection attempt was needed.
771       * @exception BAD_PARAM
772       *                if obj is a local object, or else was created by a foreign ORB.
773       */
774      public static IOR connectAndGetIOR(ORB orb, org.omg.CORBA.Object obj)
775      {
776          IOR result;
777          try
778          {
779              result = getIOR(obj);
780          }
781          catch (BAD_OPERATION bop)
782          {
783              if (StubAdapter.isStub(obj))
784              {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/orbutil/ObjectStreamClass_1_3_1.java
      * Line Number: 55
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
45  import java.security.DigestOutputStream;
46  import java.security.MessageDigest;
47  import java.security.NoSuchAlgorithmException;
48  import java.security.PrivilegedAction;
49  import java.util.Arrays;
50  import java.util.Comparator;
51  import java.util.Hashtable;
52  
53  import org.jboss.com.sun.corba.se.impl.io.ObjectStreamClass;
54  import org.jboss.com.sun.corba.se.impl.io.ValueUtility;
55  import org.omg.CORBA.ValueMember;
56  
57  /**
58   * This is duplicated here to preserve the JDK 1.3.1FCS behavior
59   * of calculating the OMG hash code incorrectly when serialPersistentFields
60   * is used, but some of the fields no longer exist in the class itself.
61   *
62   * We have to duplicate it since we aren't allowed to modify the
63   * org.jboss.com.sun.corba.se.impl.io version further, and can't make it
64   * public outside of its package for security reasons.
65   */
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/orbutil/RepositoryId_1_3.java
      * Line Number: 305
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
295      /**
296       * Used to convert ascii to hex.
297       */
298      private static final byte ASCII_HEX[] = {(byte) '0', (byte) '1', (byte) '2', (byte) '3', (byte) '4', (byte) '5',
299              (byte) '6', (byte) '7', (byte) '8', (byte) '9', (byte) 'A', (byte) 'B', (byte) 'C', (byte) 'D', (byte) 'E',
300              (byte) 'F',};
301  
302      // Interface Rep ID Strings
303      public static final String kjava_rmi_Remote = createForAnyType(java.rmi.Remote.class);
304  
305      public static final String korg_omg_CORBA_Object = createForAnyType(org.omg.CORBA.Object.class);
306  
307      // Dummy arguments for getIdFromHelper method
308      public static final Class<?> kNoParamTypes[] = {};
309  
310      public static final Object kNoArgs[] = {};
311  
312      RepositoryId_1_3()
313      {
314      }
315  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/orbutil/RepositoryId_1_3.java
      * Line Number: 46
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
36  import java.net.MalformedURLException;
37  import java.util.Hashtable;
38  
39  import javax.rmi.CORBA.Util;
40  
41  import org.jboss.com.sun.corba.se.impl.io.ObjectStreamClass;
42  import org.jboss.com.sun.corba.se.impl.util.IdentityHashtable;
43  import org.jboss.com.sun.corba.se.impl.util.JDKBridge;
44  import org.jboss.com.sun.corba.se.impl.util.PackagePrefixChecker;
45  import org.jboss.com.sun.corba.se.impl.util.Utility;
46  import org.omg.CORBA.portable.IDLEntity;
47  import org.omg.CORBA.portable.ValueBase;
48  
49  // keeping the original RepositoryId class that was shipped in
50  // JDK 1.3.  It has interoperability bugs
51  
52  public class RepositoryId_1_3
53  {
54  
55      // Legal IDL Identifier characters (1 = legal). Note that '.' (2E) is marked as legal even though it is not legal in
56      // IDL. This allows us to treat a fully qualified Java name with '.' package separators uniformly, and is safe
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/orbutil/RepositoryId_1_3.java
      * Line Number: 47
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
37  import java.util.Hashtable;
38  
39  import javax.rmi.CORBA.Util;
40  
41  import org.jboss.com.sun.corba.se.impl.io.ObjectStreamClass;
42  import org.jboss.com.sun.corba.se.impl.util.IdentityHashtable;
43  import org.jboss.com.sun.corba.se.impl.util.JDKBridge;
44  import org.jboss.com.sun.corba.se.impl.util.PackagePrefixChecker;
45  import org.jboss.com.sun.corba.se.impl.util.Utility;
46  import org.omg.CORBA.portable.IDLEntity;
47  import org.omg.CORBA.portable.ValueBase;
48  
49  // keeping the original RepositoryId class that was shipped in
50  // JDK 1.3.  It has interoperability bugs
51  
52  public class RepositoryId_1_3
53  {
54  
55      // Legal IDL Identifier characters (1 = legal). Note that '.' (2E) is marked as legal even though it is not legal in
56      // IDL. This allows us to treat a fully qualified Java name with '.' package separators uniformly, and is safe
57      // because that is the only legal use of '.' in a Java name.
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/orbutil/RepositoryId_1_3.java
      * Line Number: 822
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
812      {
813          try
814          {
815              Class<?> helperClazz = Utility.loadClassForClass(clazz.getName() + "Helper", null, clazz.getClassLoader(),
816                      clazz, clazz.getClassLoader());
817              Method idMethod = helperClazz.getDeclaredMethod("id", kNoParamTypes);
818              return (String) idMethod.invoke(null, kNoArgs);
819          }
820          catch (java.lang.ClassNotFoundException cnfe)
821          {
822              throw new org.omg.CORBA.MARSHAL(cnfe.toString());
823          }
824          catch (java.lang.NoSuchMethodException nsme)
825          {
826              throw new org.omg.CORBA.MARSHAL(nsme.toString());
827          }
828          catch (java.lang.reflect.InvocationTargetException ite)
829          {
830              throw new org.omg.CORBA.MARSHAL(ite.toString());
831          }
832          catch (java.lang.IllegalAccessException iae)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/orbutil/RepositoryId_1_3.java
      * Line Number: 826
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
816                      clazz, clazz.getClassLoader());
817              Method idMethod = helperClazz.getDeclaredMethod("id", kNoParamTypes);
818              return (String) idMethod.invoke(null, kNoArgs);
819          }
820          catch (java.lang.ClassNotFoundException cnfe)
821          {
822              throw new org.omg.CORBA.MARSHAL(cnfe.toString());
823          }
824          catch (java.lang.NoSuchMethodException nsme)
825          {
826              throw new org.omg.CORBA.MARSHAL(nsme.toString());
827          }
828          catch (java.lang.reflect.InvocationTargetException ite)
829          {
830              throw new org.omg.CORBA.MARSHAL(ite.toString());
831          }
832          catch (java.lang.IllegalAccessException iae)
833          {
834              throw new org.omg.CORBA.MARSHAL(iae.toString());
835          }
836      }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/orbutil/RepositoryId_1_3.java
      * Line Number: 830
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
820          catch (java.lang.ClassNotFoundException cnfe)
821          {
822              throw new org.omg.CORBA.MARSHAL(cnfe.toString());
823          }
824          catch (java.lang.NoSuchMethodException nsme)
825          {
826              throw new org.omg.CORBA.MARSHAL(nsme.toString());
827          }
828          catch (java.lang.reflect.InvocationTargetException ite)
829          {
830              throw new org.omg.CORBA.MARSHAL(ite.toString());
831          }
832          catch (java.lang.IllegalAccessException iae)
833          {
834              throw new org.omg.CORBA.MARSHAL(iae.toString());
835          }
836      }
837  
838      /**
839       * Createa a repository ID for the type if it is either a java type or an IDL type.
840       * 
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/orbutil/RepositoryId_1_3.java
      * Line Number: 834
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
824          catch (java.lang.NoSuchMethodException nsme)
825          {
826              throw new org.omg.CORBA.MARSHAL(nsme.toString());
827          }
828          catch (java.lang.reflect.InvocationTargetException ite)
829          {
830              throw new org.omg.CORBA.MARSHAL(ite.toString());
831          }
832          catch (java.lang.IllegalAccessException iae)
833          {
834              throw new org.omg.CORBA.MARSHAL(iae.toString());
835          }
836      }
837  
838      /**
839       * Createa a repository ID for the type if it is either a java type or an IDL type.
840       * 
841       * @param type
842       *            The type to create rep. id for
843       * @return The rep. id.
844       **/
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/orbutil/RepositoryId_1_3.java
      * Line Number: 875
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
865          catch (org.jboss.com.sun.corba.se.impl.io.TypeMismatchException e)
866          {
867              return null;
868          }
869  
870      }
871  
872      public static boolean isAbstractBase(Class<?> clazz)
873      {
874          return (clazz.isInterface() && IDLEntity.class.isAssignableFrom(clazz)
875                  && (!ValueBase.class.isAssignableFrom(clazz)) && (!org.omg.CORBA.Object.class.isAssignableFrom(clazz)));
876  
877      }
878  
879      /**
880       * Convert strings with illegal IDL identifier characters.
881       * <p>
882       * Section 5.5.7 of OBV spec.
883       */
884      private static String convertToISOLatin1(String name)
885      {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/orbutil/RepositoryId_1_3_1.java
      * Line Number: 41
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
31  import java.lang.reflect.Method;
32  import java.net.MalformedURLException;
33  import java.util.Hashtable;
34  
35  import javax.rmi.CORBA.Util;
36  
37  import org.jboss.com.sun.corba.se.impl.util.IdentityHashtable;
38  import org.jboss.com.sun.corba.se.impl.util.JDKBridge;
39  import org.jboss.com.sun.corba.se.impl.util.PackagePrefixChecker;
40  import org.jboss.com.sun.corba.se.impl.util.Utility;
41  import org.omg.CORBA.portable.IDLEntity;
42  import org.omg.CORBA.portable.ValueBase;
43  
44  /**
45   * Because all methods in RepositoryId are static, we have to duplicate all of this code, freezing it in its 1.3.1 form
46   * for backwards compatibility.
47   * 
48   * For security reasons, we can't expose enough of io/ObjectStreamClass, so it has to be duplicated in orbutil.
49   */
50  public class RepositoryId_1_3_1
51  {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/orbutil/RepositoryId_1_3_1.java
      * Line Number: 42
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
32  import java.net.MalformedURLException;
33  import java.util.Hashtable;
34  
35  import javax.rmi.CORBA.Util;
36  
37  import org.jboss.com.sun.corba.se.impl.util.IdentityHashtable;
38  import org.jboss.com.sun.corba.se.impl.util.JDKBridge;
39  import org.jboss.com.sun.corba.se.impl.util.PackagePrefixChecker;
40  import org.jboss.com.sun.corba.se.impl.util.Utility;
41  import org.omg.CORBA.portable.IDLEntity;
42  import org.omg.CORBA.portable.ValueBase;
43  
44  /**
45   * Because all methods in RepositoryId are static, we have to duplicate all of this code, freezing it in its 1.3.1 form
46   * for backwards compatibility.
47   * 
48   * For security reasons, we can't expose enough of io/ObjectStreamClass, so it has to be duplicated in orbutil.
49   */
50  public class RepositoryId_1_3_1
51  {
52  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/orbutil/RepositoryId_1_3_1.java
      * Line Number: 336
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
326              (byte) '6', (byte) '7', (byte) '8', (byte) '9', (byte) 'A', (byte) 'B', (byte) 'C', (byte) 'D', (byte) 'E',
327              (byte) 'F',};
328  
329      // bug fix for 4328952; to eliminate possibility of overriding this
330      // in a subclass.
331      public static final RepositoryIdCache_1_3_1 cache = new RepositoryIdCache_1_3_1();
332  
333      // Interface Rep ID Strings
334      public static final String kjava_rmi_Remote = createForAnyType(java.rmi.Remote.class);
335  
336      public static final String korg_omg_CORBA_Object = createForAnyType(org.omg.CORBA.Object.class);
337  
338      // Dummy arguments for getIdFromHelper method
339      public static final Class<?> kNoParamTypes[] = {};
340  
341      public static final Object kNoArgs[] = {};
342  
343      // To create a RepositoryID, use code similar to the following:
344      // RepositoryId.cache.getId( id );
345  
346      RepositoryId_1_3_1()
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/orbutil/RepositoryId_1_3_1.java
      * Line Number: 912
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
902      {
903          try
904          {
905              Class<?> helperClazz = Utility.loadClassForClass(clazz.getName() + "Helper", null, clazz.getClassLoader(),
906                      clazz, clazz.getClassLoader());
907              Method idMethod = helperClazz.getDeclaredMethod("id", kNoParamTypes);
908              return (String) idMethod.invoke(null, kNoArgs);
909          }
910          catch (java.lang.ClassNotFoundException cnfe)
911          {
912              throw new org.omg.CORBA.MARSHAL(cnfe.toString());
913          }
914          catch (java.lang.NoSuchMethodException nsme)
915          {
916              throw new org.omg.CORBA.MARSHAL(nsme.toString());
917          }
918          catch (java.lang.reflect.InvocationTargetException ite)
919          {
920              throw new org.omg.CORBA.MARSHAL(ite.toString());
921          }
922          catch (java.lang.IllegalAccessException iae)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/orbutil/RepositoryId_1_3_1.java
      * Line Number: 916
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
906                      clazz, clazz.getClassLoader());
907              Method idMethod = helperClazz.getDeclaredMethod("id", kNoParamTypes);
908              return (String) idMethod.invoke(null, kNoArgs);
909          }
910          catch (java.lang.ClassNotFoundException cnfe)
911          {
912              throw new org.omg.CORBA.MARSHAL(cnfe.toString());
913          }
914          catch (java.lang.NoSuchMethodException nsme)
915          {
916              throw new org.omg.CORBA.MARSHAL(nsme.toString());
917          }
918          catch (java.lang.reflect.InvocationTargetException ite)
919          {
920              throw new org.omg.CORBA.MARSHAL(ite.toString());
921          }
922          catch (java.lang.IllegalAccessException iae)
923          {
924              throw new org.omg.CORBA.MARSHAL(iae.toString());
925          }
926      }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/orbutil/RepositoryId_1_3_1.java
      * Line Number: 920
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
910          catch (java.lang.ClassNotFoundException cnfe)
911          {
912              throw new org.omg.CORBA.MARSHAL(cnfe.toString());
913          }
914          catch (java.lang.NoSuchMethodException nsme)
915          {
916              throw new org.omg.CORBA.MARSHAL(nsme.toString());
917          }
918          catch (java.lang.reflect.InvocationTargetException ite)
919          {
920              throw new org.omg.CORBA.MARSHAL(ite.toString());
921          }
922          catch (java.lang.IllegalAccessException iae)
923          {
924              throw new org.omg.CORBA.MARSHAL(iae.toString());
925          }
926      }
927  
928      /**
929       * Createa a repository ID for the type if it is either a java type or an IDL type.
930       * 
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/orbutil/RepositoryId_1_3_1.java
      * Line Number: 924
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
914          catch (java.lang.NoSuchMethodException nsme)
915          {
916              throw new org.omg.CORBA.MARSHAL(nsme.toString());
917          }
918          catch (java.lang.reflect.InvocationTargetException ite)
919          {
920              throw new org.omg.CORBA.MARSHAL(ite.toString());
921          }
922          catch (java.lang.IllegalAccessException iae)
923          {
924              throw new org.omg.CORBA.MARSHAL(iae.toString());
925          }
926      }
927  
928      /**
929       * Createa a repository ID for the type if it is either a java type or an IDL type.
930       * 
931       * @param type
932       *            The type to create rep. id for
933       * @return The rep. id.
934       **/
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/orbutil/RepositoryId_1_3_1.java
      * Line Number: 965
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
955          catch (org.jboss.com.sun.corba.se.impl.io.TypeMismatchException e)
956          {
957              return null;
958          }
959  
960      }
961  
962      public static boolean isAbstractBase(Class<?> clazz)
963      {
964          return (clazz.isInterface() && IDLEntity.class.isAssignableFrom(clazz)
965                  && (!ValueBase.class.isAssignableFrom(clazz)) && (!org.omg.CORBA.Object.class.isAssignableFrom(clazz)));
966  
967      }
968  
969      public static boolean isAnyRequired(Class<?> clazz)
970      {
971          return ((clazz == java.lang.Object.class) || (clazz == java.io.Serializable.class) || (clazz == java.io.Externalizable.class));
972      }
973  
974      public static long fromHex(String hexNumber)
975      {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/orbutil/ValueHandlerImpl_1_3.java
      * Line Number: 198
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
188      {
189          RepositoryId_1_3 repId = RepositoryId_1_3.cache.getId(id);
190          return repId.isSequence();
191      }
192  
193      /**
194       * Preserves the incorrect 1.3 behavior which truncates Java chars in arrays to 8-bit CORBA chars. Bug 4367783. This
195       * enables us to continue interoperating with our legacy ORBs. If this goes into Ladybird, then Ladybird and Kestrel
196       * will interoperate as long as people don't use chars greater than 8-bits.
197       */
198      protected void writeCharArray(org.omg.CORBA_2_3.portable.OutputStream out, char[] array, int offset, int length)
199      {
200          out.write_char_array(array, offset, length);
201      }
202  
203      /**
204       * Preserves the incorrect 1.3 behavior which truncates Java chars in arrays to 8-bit CORBA chars. Bug 4367783. This
205       * enables us to continue interoperating with our legacy ORBs. If this goes into Ladybird, then Ladybird and Kestrel
206       * will interoperate as long as people don't use chars greater than 8-bits.
207       */
208      protected void readCharArray(org.omg.CORBA_2_3.portable.InputStream in, char[] array, int offset, int length)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/orbutil/ValueHandlerImpl_1_3.java
      * Line Number: 208
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
198      protected void writeCharArray(org.omg.CORBA_2_3.portable.OutputStream out, char[] array, int offset, int length)
199      {
200          out.write_char_array(array, offset, length);
201      }
202  
203      /**
204       * Preserves the incorrect 1.3 behavior which truncates Java chars in arrays to 8-bit CORBA chars. Bug 4367783. This
205       * enables us to continue interoperating with our legacy ORBs. If this goes into Ladybird, then Ladybird and Kestrel
206       * will interoperate as long as people don't use chars greater than 8-bits.
207       */
208      protected void readCharArray(org.omg.CORBA_2_3.portable.InputStream in, char[] array, int offset, int length)
209      {
210          in.read_char_array(array, offset, length);
211      }
212  
213      protected final String getOutputStreamClassName()
214      {
215          return "org.jboss.com.sun.corba.se.impl.orbutil.IIOPOutputStream_1_3";
216      }
217  
218      protected final String getInputStreamClassName()
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/orbutil/ValueHandlerImpl_1_3.java
      * Line Number: 36
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
26   * Licensed Materials - Property of IBM
27   * RMI-IIOP v1.0
28   * Copyright IBM Corp. 1998 1999  All Rights Reserved
29   *
30   */
31  
32  package org.jboss.com.sun.corba.se.impl.orbutil;
33  
34  import java.io.IOException;
35  
36  import org.omg.CORBA.TCKind;
37  
38  /**
39   * This class overrides behavior of our current ValueHandlerImpl to provide backwards compatibility with JDK 1.3.0.
40   */
41  public class ValueHandlerImpl_1_3 extends org.jboss.com.sun.corba.se.impl.io.ValueHandlerImpl
42  {
43  
44      public ValueHandlerImpl_1_3()
45      {
46          super();
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/orbutil/ValueHandlerImpl_1_3.java
      * Line Number: 62
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
52      }
53  
54      /**
55       * Writes the value to the stream using java semantics.
56       * 
57       * @param out
58       *            The stream to write the value to
59       * @param value
60       *            The value to be written to the stream
61       **/
62      public void writeValue(org.omg.CORBA.portable.OutputStream _out, java.io.Serializable value)
63      {
64          super.writeValue(_out, value);
65      }
66  
67      /**
68       * Reads a value from the stream using java semantics.
69       * 
70       * @param in
71       *            The stream to read the value from
72       * @param clazz
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/orbutil/ValueHandlerImpl_1_3.java
      * Line Number: 77
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
67      /**
68       * Reads a value from the stream using java semantics.
69       * 
70       * @param in
71       *            The stream to read the value from
72       * @param clazz
73       *            The type of the value to be read in
74       * @param sender
75       *            The sending context runtime
76       **/
77      public java.io.Serializable readValue(org.omg.CORBA.portable.InputStream _in, int offset, Class<?> clazz,
78              String repositoryID, org.omg.SendingContext.RunTime _sender)
79      {
80          return super.readValue(_in, offset, clazz, repositoryID, _sender);
81      }
82  
83      /**
84       * Returns the repository ID for the given RMI value Class.
85       * 
86       * @param clz
87       *            The class to return a repository ID for.
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/orbutil/ValueHandlerImpl_1_3_1.java
      * Line Number: 27
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
17   * You should have received a copy of the GNU General Public License version
18   * 2 along with this work; if not, write to the Free Software Foundation,
19   * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
20   *
21   * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
22   * or visit www.oracle.com if you need additional information or have any
23   * questions.
24   */
25  package org.jboss.com.sun.corba.se.impl.orbutil;
26  
27  import org.omg.CORBA.TCKind;
28  
29  /**
30   * This class overrides behavior of our current ValueHandlerImpl to provide backwards compatibility with JDK 1.3.1.
31   */
32  public class ValueHandlerImpl_1_3_1 extends org.jboss.com.sun.corba.se.impl.io.ValueHandlerImpl
33  {
34      public ValueHandlerImpl_1_3_1()
35      {
36      }
37  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/orbutil/concurrent/ReentrantMutex.java
      * Line Number: 42
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
32   and everyone contributing, testing, and using this code.
33  
34   History:
35   Date       Who                What
36   11Jun1998  dl               Create public version
37   */
38  
39  package org.jboss.com.sun.corba.se.impl.orbutil.concurrent;
40  
41  import org.jboss.com.sun.corba.se.impl.orbutil.ORBUtility;
42  import org.omg.CORBA.INTERNAL;
43  
44  public class ReentrantMutex implements Sync
45  {
46  
47      /** The thread holding the lock **/
48      protected Thread holder_ = null;
49  
50      /** number of times thread has acquired the lock **/
51      protected int counter_ = 0;
52  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/orbutil/fsm/StateEngineImpl.java
      * Line Number: 41
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
31  import org.jboss.com.sun.corba.se.impl.orbutil.ORBUtility;
32  import org.jboss.com.sun.corba.se.spi.orbutil.fsm.Action;
33  import org.jboss.com.sun.corba.se.spi.orbutil.fsm.ActionBase;
34  import org.jboss.com.sun.corba.se.spi.orbutil.fsm.FSM;
35  import org.jboss.com.sun.corba.se.spi.orbutil.fsm.FSMImpl;
36  import org.jboss.com.sun.corba.se.spi.orbutil.fsm.Guard;
37  import org.jboss.com.sun.corba.se.spi.orbutil.fsm.Input;
38  import org.jboss.com.sun.corba.se.spi.orbutil.fsm.State;
39  import org.jboss.com.sun.corba.se.spi.orbutil.fsm.StateEngine;
40  import org.jboss.com.sun.corba.se.spi.orbutil.fsm.StateImpl;
41  import org.omg.CORBA.INTERNAL;
42  
43  /**
44   * Encodes the state transition function for a finite state machine.
45   * 
46   * @author Ken Cavanaugh
47   */
48  public class StateEngineImpl implements StateEngine
49  {
50      // An action that does nothing at all.
51      private static Action emptyAction = new ActionBase("Empty")
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/DynamicMethodMarshallerImpl.java
      * Line Number: 261
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
251  
252      private static ReaderWriter corbaObjectRW = new ReaderWriterBase("org.omg.CORBA.Object")
253      {
254          public Object read(InputStream is)
255          {
256              return is.read_Object();
257          }
258  
259          public void write(OutputStream os, Object value)
260          {
261              os.write_Object((org.omg.CORBA.Object) value);
262          }
263      };
264  
265      private static ReaderWriter anyRW = new ReaderWriterBase("any")
266      {
267          public Object read(InputStream is)
268          {
269              return Util.readAny(is);
270          }
271  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/DynamicMethodMarshallerImpl.java
      * Line Number: 38
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
28  import java.io.Externalizable;
29  import java.io.Serializable;
30  import java.lang.reflect.Method;
31  import java.rmi.RemoteException;
32  
33  import javax.rmi.PortableRemoteObject;
34  import javax.rmi.CORBA.Util;
35  
36  import org.jboss.com.sun.corba.se.spi.orb.ORB;
37  import org.jboss.com.sun.corba.se.spi.presentation.rmi.DynamicMethodMarshaller;
38  import org.omg.CORBA.portable.ApplicationException;
39  import org.omg.CORBA.portable.IDLEntity;
40  import org.omg.CORBA_2_3.portable.InputStream;
41  import org.omg.CORBA_2_3.portable.OutputStream;
42  
43  public class DynamicMethodMarshallerImpl implements DynamicMethodMarshaller
44  {
45      Method method;
46  
47      ExceptionHandler ehandler;
48  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/DynamicMethodMarshallerImpl.java
      * Line Number: 39
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
29  import java.io.Serializable;
30  import java.lang.reflect.Method;
31  import java.rmi.RemoteException;
32  
33  import javax.rmi.PortableRemoteObject;
34  import javax.rmi.CORBA.Util;
35  
36  import org.jboss.com.sun.corba.se.spi.orb.ORB;
37  import org.jboss.com.sun.corba.se.spi.presentation.rmi.DynamicMethodMarshaller;
38  import org.omg.CORBA.portable.ApplicationException;
39  import org.omg.CORBA.portable.IDLEntity;
40  import org.omg.CORBA_2_3.portable.InputStream;
41  import org.omg.CORBA_2_3.portable.OutputStream;
42  
43  public class DynamicMethodMarshallerImpl implements DynamicMethodMarshaller
44  {
45      Method method;
46  
47      ExceptionHandler ehandler;
48  
49      boolean hasArguments = true;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/DynamicMethodMarshallerImpl.java
      * Line Number: 40
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
30  import java.lang.reflect.Method;
31  import java.rmi.RemoteException;
32  
33  import javax.rmi.PortableRemoteObject;
34  import javax.rmi.CORBA.Util;
35  
36  import org.jboss.com.sun.corba.se.spi.orb.ORB;
37  import org.jboss.com.sun.corba.se.spi.presentation.rmi.DynamicMethodMarshaller;
38  import org.omg.CORBA.portable.ApplicationException;
39  import org.omg.CORBA.portable.IDLEntity;
40  import org.omg.CORBA_2_3.portable.InputStream;
41  import org.omg.CORBA_2_3.portable.OutputStream;
42  
43  public class DynamicMethodMarshallerImpl implements DynamicMethodMarshaller
44  {
45      Method method;
46  
47      ExceptionHandler ehandler;
48  
49      boolean hasArguments = true;
50  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/DynamicMethodMarshallerImpl.java
      * Line Number: 41
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
31  import java.rmi.RemoteException;
32  
33  import javax.rmi.PortableRemoteObject;
34  import javax.rmi.CORBA.Util;
35  
36  import org.jboss.com.sun.corba.se.spi.orb.ORB;
37  import org.jboss.com.sun.corba.se.spi.presentation.rmi.DynamicMethodMarshaller;
38  import org.omg.CORBA.portable.ApplicationException;
39  import org.omg.CORBA.portable.IDLEntity;
40  import org.omg.CORBA_2_3.portable.InputStream;
41  import org.omg.CORBA_2_3.portable.OutputStream;
42  
43  public class DynamicMethodMarshallerImpl implements DynamicMethodMarshaller
44  {
45      Method method;
46  
47      ExceptionHandler ehandler;
48  
49      boolean hasArguments = true;
50  
51      boolean hasVoidResult = true;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/DynamicMethodMarshallerImpl.java
      * Line Number: 322
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
312                  public Object read(InputStream is)
313                  {
314                      return PortableRemoteObject.narrow(is.read_Object(), cls);
315                  }
316  
317                  public void write(OutputStream os, Object value)
318                  {
319                      Util.writeRemoteObject(os, value);
320                  }
321              };
322          else if (cls.equals(org.omg.CORBA.Object.class))
323              return corbaObjectRW;
324          else if (org.omg.CORBA.Object.class.isAssignableFrom(cls))
325              return new ReaderWriterBase("org.omg.CORBA.Object(" + cls.getName() + ")")
326              {
327                  public Object read(InputStream is)
328                  {
329                      return is.read_Object(cls);
330                  }
331  
332                  public void write(OutputStream os, Object value)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/DynamicMethodMarshallerImpl.java
      * Line Number: 324
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
314                      return PortableRemoteObject.narrow(is.read_Object(), cls);
315                  }
316  
317                  public void write(OutputStream os, Object value)
318                  {
319                      Util.writeRemoteObject(os, value);
320                  }
321              };
322          else if (cls.equals(org.omg.CORBA.Object.class))
323              return corbaObjectRW;
324          else if (org.omg.CORBA.Object.class.isAssignableFrom(cls))
325              return new ReaderWriterBase("org.omg.CORBA.Object(" + cls.getName() + ")")
326              {
327                  public Object read(InputStream is)
328                  {
329                      return is.read_Object(cls);
330                  }
331  
332                  public void write(OutputStream os, Object value)
333                  {
334                      os.write_Object((org.omg.CORBA.Object) value);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/DynamicMethodMarshallerImpl.java
      * Line Number: 334
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
324          else if (org.omg.CORBA.Object.class.isAssignableFrom(cls))
325              return new ReaderWriterBase("org.omg.CORBA.Object(" + cls.getName() + ")")
326              {
327                  public Object read(InputStream is)
328                  {
329                      return is.read_Object(cls);
330                  }
331  
332                  public void write(OutputStream os, Object value)
333                  {
334                      os.write_Object((org.omg.CORBA.Object) value);
335                  }
336              };
337          else if (isAnyClass(cls))
338              return anyRW;
339          else if (isAbstractInterface(cls))
340              return abstractInterfaceRW;
341  
342          // For anything else, just read it as a value type.
343          return new ReaderWriterBase("value(" + cls.getName() + ")")
344          {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/DynamicStubImpl.java
      * Line Number: 39
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
29  import java.io.ObjectInputStream;
30  import java.io.ObjectOutputStream;
31  import java.io.Serializable;
32  import java.rmi.RemoteException;
33  
34  import org.jboss.com.sun.corba.se.impl.ior.StubIORImpl;
35  import org.jboss.com.sun.corba.se.impl.util.JDKBridge;
36  import org.jboss.com.sun.corba.se.impl.util.RepositoryId;
37  import org.jboss.com.sun.corba.se.spi.presentation.rmi.DynamicStub;
38  import org.jboss.com.sun.corba.se.spi.presentation.rmi.PresentationManager;
39  import org.omg.CORBA.ORB;
40  import org.omg.CORBA.portable.Delegate;
41  import org.omg.CORBA.portable.OutputStream;
42  import org.omg.CORBA_2_3.portable.ObjectImpl;
43  
44  // XXX Do we need _get_codebase?
45  public class DynamicStubImpl extends ObjectImpl implements DynamicStub, Serializable
46  {
47      private static final long serialVersionUID = 4852612040012087675L;
48  
49      private String[] typeIds;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/DynamicStubImpl.java
      * Line Number: 40
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
30  import java.io.ObjectOutputStream;
31  import java.io.Serializable;
32  import java.rmi.RemoteException;
33  
34  import org.jboss.com.sun.corba.se.impl.ior.StubIORImpl;
35  import org.jboss.com.sun.corba.se.impl.util.JDKBridge;
36  import org.jboss.com.sun.corba.se.impl.util.RepositoryId;
37  import org.jboss.com.sun.corba.se.spi.presentation.rmi.DynamicStub;
38  import org.jboss.com.sun.corba.se.spi.presentation.rmi.PresentationManager;
39  import org.omg.CORBA.ORB;
40  import org.omg.CORBA.portable.Delegate;
41  import org.omg.CORBA.portable.OutputStream;
42  import org.omg.CORBA_2_3.portable.ObjectImpl;
43  
44  // XXX Do we need _get_codebase?
45  public class DynamicStubImpl extends ObjectImpl implements DynamicStub, Serializable
46  {
47      private static final long serialVersionUID = 4852612040012087675L;
48  
49      private String[] typeIds;
50  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/DynamicStubImpl.java
      * Line Number: 41
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
31  import java.io.Serializable;
32  import java.rmi.RemoteException;
33  
34  import org.jboss.com.sun.corba.se.impl.ior.StubIORImpl;
35  import org.jboss.com.sun.corba.se.impl.util.JDKBridge;
36  import org.jboss.com.sun.corba.se.impl.util.RepositoryId;
37  import org.jboss.com.sun.corba.se.spi.presentation.rmi.DynamicStub;
38  import org.jboss.com.sun.corba.se.spi.presentation.rmi.PresentationManager;
39  import org.omg.CORBA.ORB;
40  import org.omg.CORBA.portable.Delegate;
41  import org.omg.CORBA.portable.OutputStream;
42  import org.omg.CORBA_2_3.portable.ObjectImpl;
43  
44  // XXX Do we need _get_codebase?
45  public class DynamicStubImpl extends ObjectImpl implements DynamicStub, Serializable
46  {
47      private static final long serialVersionUID = 4852612040012087675L;
48  
49      private String[] typeIds;
50  
51      private StubIORImpl ior;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/DynamicStubImpl.java
      * Line Number: 42
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
32  import java.rmi.RemoteException;
33  
34  import org.jboss.com.sun.corba.se.impl.ior.StubIORImpl;
35  import org.jboss.com.sun.corba.se.impl.util.JDKBridge;
36  import org.jboss.com.sun.corba.se.impl.util.RepositoryId;
37  import org.jboss.com.sun.corba.se.spi.presentation.rmi.DynamicStub;
38  import org.jboss.com.sun.corba.se.spi.presentation.rmi.PresentationManager;
39  import org.omg.CORBA.ORB;
40  import org.omg.CORBA.portable.Delegate;
41  import org.omg.CORBA.portable.OutputStream;
42  import org.omg.CORBA_2_3.portable.ObjectImpl;
43  
44  // XXX Do we need _get_codebase?
45  public class DynamicStubImpl extends ObjectImpl implements DynamicStub, Serializable
46  {
47      private static final long serialVersionUID = 4852612040012087675L;
48  
49      private String[] typeIds;
50  
51      private StubIORImpl ior;
52  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/ExceptionHandlerImpl.java
      * Line Number: 34
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.presentation.rmi;
27  
28  import java.lang.reflect.Method;
29  import java.rmi.RemoteException;
30  import java.rmi.UnexpectedException;
31  
32  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
33  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
34  import org.omg.CORBA.UserException;
35  import org.omg.CORBA.portable.ApplicationException;
36  import org.omg.CORBA_2_3.portable.InputStream;
37  import org.omg.CORBA_2_3.portable.OutputStream;
38  
39  public class ExceptionHandlerImpl implements ExceptionHandler
40  {
41      private ExceptionRW[] rws;
42  
43      private final ORBUtilSystemException wrapper;
44  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/ExceptionHandlerImpl.java
      * Line Number: 35
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
25  
26  package org.jboss.com.sun.corba.se.impl.presentation.rmi;
27  
28  import java.lang.reflect.Method;
29  import java.rmi.RemoteException;
30  import java.rmi.UnexpectedException;
31  
32  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
33  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
34  import org.omg.CORBA.UserException;
35  import org.omg.CORBA.portable.ApplicationException;
36  import org.omg.CORBA_2_3.portable.InputStream;
37  import org.omg.CORBA_2_3.portable.OutputStream;
38  
39  public class ExceptionHandlerImpl implements ExceptionHandler
40  {
41      private ExceptionRW[] rws;
42  
43      private final ORBUtilSystemException wrapper;
44  
45      // /////////////////////////////////////////////////////////////////////////////
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/ExceptionHandlerImpl.java
      * Line Number: 36
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
26  package org.jboss.com.sun.corba.se.impl.presentation.rmi;
27  
28  import java.lang.reflect.Method;
29  import java.rmi.RemoteException;
30  import java.rmi.UnexpectedException;
31  
32  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
33  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
34  import org.omg.CORBA.UserException;
35  import org.omg.CORBA.portable.ApplicationException;
36  import org.omg.CORBA_2_3.portable.InputStream;
37  import org.omg.CORBA_2_3.portable.OutputStream;
38  
39  public class ExceptionHandlerImpl implements ExceptionHandler
40  {
41      private ExceptionRW[] rws;
42  
43      private final ORBUtilSystemException wrapper;
44  
45      // /////////////////////////////////////////////////////////////////////////////
46      // ExceptionRW interface and implementations.
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/ExceptionHandlerImpl.java
      * Line Number: 37
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
27  
28  import java.lang.reflect.Method;
29  import java.rmi.RemoteException;
30  import java.rmi.UnexpectedException;
31  
32  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
33  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
34  import org.omg.CORBA.UserException;
35  import org.omg.CORBA.portable.ApplicationException;
36  import org.omg.CORBA_2_3.portable.InputStream;
37  import org.omg.CORBA_2_3.portable.OutputStream;
38  
39  public class ExceptionHandlerImpl implements ExceptionHandler
40  {
41      private ExceptionRW[] rws;
42  
43      private final ORBUtilSystemException wrapper;
44  
45      // /////////////////////////////////////////////////////////////////////////////
46      // ExceptionRW interface and implementations.
47      // Used to read and write exceptions.
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/IDLTypesUtil.java
      * Line Number: 206
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
196      /**
197       * Section 1.2.7
198       */
199      public boolean isObjectReference(Class<?> c)
200      {
201          if (c == null)
202          {
203              throw new IllegalArgumentException();
204          }
205  
206          return (c.isInterface() && org.omg.CORBA.Object.class.isAssignableFrom(c));
207      }
208  
209      /**
210       * Section 1.2.8
211       */
212      public boolean isEntity(Class<?> c)
213      {
214          if (c == null)
215          {
216              throw new IllegalArgumentException();
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/IDLTypesUtil.java
      * Line Number: 220
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
210       * Section 1.2.8
211       */
212      public boolean isEntity(Class<?> c)
213      {
214          if (c == null)
215          {
216              throw new IllegalArgumentException();
217          }
218  
219          Class<?> superClass = c.getSuperclass();
220          return (!c.isInterface() && (superClass != null) && (org.omg.CORBA.portable.IDLEntity.class.isAssignableFrom(c)));
221      }
222  
223      /**
224       * Return true if given method is legal property accessor as defined in Section 1.3.4.3 of Java2IDL spec.
225       */
226      public boolean isPropertyAccessorMethod(Method m, Class<?> c)
227      {
228  
229          String methodName = m.getName();
230          Class<?> returnType = m.getReturnType();
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/IDLTypesUtil.java
      * Line Number: 473
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
463              return new IDLType(c, new String[]{"java", "io"}, "Serializable");
464          }
465          else if (c == java.io.Externalizable.class)
466          {
467              return new IDLType(c, new String[]{"java", "io"}, "Externalizable");
468          }
469          else if (c == java.rmi.Remote.class)
470          {
471              return new IDLType(c, new String[]{"java", "rmi"}, "Remote");
472          }
473          else if (c == org.omg.CORBA.Object.class)
474          {
475              return new IDLType(c, "Object");
476          }
477          else
478          {
479              return null;
480          }
481      }
482  
483      /**
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/InvocationHandlerFactoryImpl.java
      * Line Number: 115
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
105          // Create an invocation handler for the methods defined on DynamicStub, which extends org.omg.CORBA.Object. This
106          // handler delegates all calls directly to a DynamicStubImpl, which extends org.omg.CORBA.portable.ObjectImpl.
107          InvocationHandler dynamicStubHandler = DelegateInvocationHandlerImpl.create(stub);
108  
109          // Create an invocation handler that handles any remote interface methods.
110          InvocationHandler stubMethodHandler = new StubInvocationHandlerImpl(pm, classData, stub);
111  
112          // Create a composite handler that handles the DynamicStub interface as well as the remote interfaces.
113          final CompositeInvocationHandler handler = new CustomCompositeInvocationHandlerImpl(stub);
114          handler.addInvocationHandler(DynamicStub.class, dynamicStubHandler);
115          handler.addInvocationHandler(org.omg.CORBA.Object.class, dynamicStubHandler);
116          handler.addInvocationHandler(Object.class, dynamicStubHandler);
117  
118          // If the method passed to invoke is not from DynamicStub or its superclasses, it must be from an implemented
119          // interface, so we just handle all of these with the stubMethodHandler. This used to be done be adding explicit
120          // entries for stubMethodHandler for each remote interface, but that does not work correctly for abstract
121          // interfaces, since the graph analysis ignores abstract interfaces in order to compute the type ids correctly
122          // (see PresentationManagerImpl.NodeImpl.getChildren). Rather than produce more graph traversal code to handle
123          // this problem, we simply use a default. This also points to a possible optimization: just use explicit checks
124          // for the three special classes, rather than a general table lookup that usually fails.
125          handler.setDefaultHandler(stubMethodHandler);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/ReflectiveTie.java
      * Line Number: 115
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
105          catch (org.omg.PortableServer.POAPackage.ObjectNotActive exception)
106          {
107              // ignore
108          }
109          catch (org.omg.PortableServer.POAPackage.ServantNotActive exception)
110          {
111              // ignore
112          }
113      }
114  
115      public org.omg.CORBA.ORB orb()
116      {
117          return _orb();
118      }
119  
120      public void orb(org.omg.CORBA.ORB orb)
121      {
122          try
123          {
124              ((org.omg.CORBA_2_3.ORB) orb).set_delegate(this);
125          }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/ReflectiveTie.java
      * Line Number: 120
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
110          {
111              // ignore
112          }
113      }
114  
115      public org.omg.CORBA.ORB orb()
116      {
117          return _orb();
118      }
119  
120      public void orb(org.omg.CORBA.ORB orb)
121      {
122          try
123          {
124              ((org.omg.CORBA_2_3.ORB) orb).set_delegate(this);
125          }
126          catch (ClassCastException e)
127          {
128              throw wrapper.badOrbForServant(e);
129          }
130      }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/ReflectiveTie.java
      * Line Number: 124
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
114  
115      public org.omg.CORBA.ORB orb()
116      {
117          return _orb();
118      }
119  
120      public void orb(org.omg.CORBA.ORB orb)
121      {
122          try
123          {
124              ((org.omg.CORBA_2_3.ORB) orb).set_delegate(this);
125          }
126          catch (ClassCastException e)
127          {
128              throw wrapper.badOrbForServant(e);
129          }
130      }
131  
132      public org.omg.CORBA.portable.OutputStream _invoke(String method, org.omg.CORBA.portable.InputStream _in,
133              ResponseHandler reply)
134      {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/ReflectiveTie.java
      * Line Number: 132
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
122          try
123          {
124              ((org.omg.CORBA_2_3.ORB) orb).set_delegate(this);
125          }
126          catch (ClassCastException e)
127          {
128              throw wrapper.badOrbForServant(e);
129          }
130      }
131  
132      public org.omg.CORBA.portable.OutputStream _invoke(String method, org.omg.CORBA.portable.InputStream _in,
133              ResponseHandler reply)
134      {
135          Method javaMethod = null;
136          DynamicMethodMarshaller dmm = null;
137  
138          try
139          {
140              InputStream in = (InputStream) _in;
141  
142              javaMethod = classData.getIDLNameTranslator().getMethod(method);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/ReflectiveTie.java
      * Line Number: 37
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
27  
28  import java.lang.reflect.InvocationTargetException;
29  import java.lang.reflect.Method;
30  import java.rmi.Remote;
31  
32  import javax.rmi.CORBA.Tie;
33  
34  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
35  import org.jboss.com.sun.corba.se.spi.presentation.rmi.DynamicMethodMarshaller;
36  import org.jboss.com.sun.corba.se.spi.presentation.rmi.PresentationManager;
37  import org.omg.CORBA.SystemException;
38  import org.omg.CORBA.portable.ResponseHandler;
39  import org.omg.CORBA.portable.UnknownException;
40  import org.omg.CORBA_2_3.portable.InputStream;
41  import org.omg.CORBA_2_3.portable.OutputStream;
42  import org.omg.PortableServer.Servant;
43  
44  public final class ReflectiveTie extends Servant implements Tie
45  {
46      private Remote target = null;
47  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/ReflectiveTie.java
      * Line Number: 38
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
28  import java.lang.reflect.InvocationTargetException;
29  import java.lang.reflect.Method;
30  import java.rmi.Remote;
31  
32  import javax.rmi.CORBA.Tie;
33  
34  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
35  import org.jboss.com.sun.corba.se.spi.presentation.rmi.DynamicMethodMarshaller;
36  import org.jboss.com.sun.corba.se.spi.presentation.rmi.PresentationManager;
37  import org.omg.CORBA.SystemException;
38  import org.omg.CORBA.portable.ResponseHandler;
39  import org.omg.CORBA.portable.UnknownException;
40  import org.omg.CORBA_2_3.portable.InputStream;
41  import org.omg.CORBA_2_3.portable.OutputStream;
42  import org.omg.PortableServer.Servant;
43  
44  public final class ReflectiveTie extends Servant implements Tie
45  {
46      private Remote target = null;
47  
48      private PresentationManager pm;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/ReflectiveTie.java
      * Line Number: 39
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
29  import java.lang.reflect.Method;
30  import java.rmi.Remote;
31  
32  import javax.rmi.CORBA.Tie;
33  
34  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
35  import org.jboss.com.sun.corba.se.spi.presentation.rmi.DynamicMethodMarshaller;
36  import org.jboss.com.sun.corba.se.spi.presentation.rmi.PresentationManager;
37  import org.omg.CORBA.SystemException;
38  import org.omg.CORBA.portable.ResponseHandler;
39  import org.omg.CORBA.portable.UnknownException;
40  import org.omg.CORBA_2_3.portable.InputStream;
41  import org.omg.CORBA_2_3.portable.OutputStream;
42  import org.omg.PortableServer.Servant;
43  
44  public final class ReflectiveTie extends Servant implements Tie
45  {
46      private Remote target = null;
47  
48      private PresentationManager pm;
49  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/ReflectiveTie.java
      * Line Number: 40
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
30  import java.rmi.Remote;
31  
32  import javax.rmi.CORBA.Tie;
33  
34  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
35  import org.jboss.com.sun.corba.se.spi.presentation.rmi.DynamicMethodMarshaller;
36  import org.jboss.com.sun.corba.se.spi.presentation.rmi.PresentationManager;
37  import org.omg.CORBA.SystemException;
38  import org.omg.CORBA.portable.ResponseHandler;
39  import org.omg.CORBA.portable.UnknownException;
40  import org.omg.CORBA_2_3.portable.InputStream;
41  import org.omg.CORBA_2_3.portable.OutputStream;
42  import org.omg.PortableServer.Servant;
43  
44  public final class ReflectiveTie extends Servant implements Tie
45  {
46      private Remote target = null;
47  
48      private PresentationManager pm;
49  
50      private PresentationManager.ClassData classData = null;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/ReflectiveTie.java
      * Line Number: 41
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
31  
32  import javax.rmi.CORBA.Tie;
33  
34  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
35  import org.jboss.com.sun.corba.se.spi.presentation.rmi.DynamicMethodMarshaller;
36  import org.jboss.com.sun.corba.se.spi.presentation.rmi.PresentationManager;
37  import org.omg.CORBA.SystemException;
38  import org.omg.CORBA.portable.ResponseHandler;
39  import org.omg.CORBA.portable.UnknownException;
40  import org.omg.CORBA_2_3.portable.InputStream;
41  import org.omg.CORBA_2_3.portable.OutputStream;
42  import org.omg.PortableServer.Servant;
43  
44  public final class ReflectiveTie extends Servant implements Tie
45  {
46      private Remote target = null;
47  
48      private PresentationManager pm;
49  
50      private PresentationManager.ClassData classData = null;
51  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/ReflectiveTie.java
      * Line Number: 90
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
80              Class<?> targetClass = target.getClass();
81              classData = pm.getClassData(targetClass);
82          }
83      }
84  
85      public Remote getTarget()
86      {
87          return target;
88      }
89  
90      public org.omg.CORBA.Object thisObject()
91      {
92          return _this_object();
93      }
94  
95      public void deactivate()
96      {
97          try
98          {
99              _poa().deactivate_object(_poa().servant_to_id(this));
100          }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/StubConnectImpl.java
      * Line Number: 32
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
22   * or visit www.oracle.com if you need additional information or have any
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.presentation.rmi;
27  
28  import java.rmi.RemoteException;
29  
30  import javax.rmi.CORBA.Tie;
31  
32  import org.omg.CORBA.BAD_INV_ORDER;
33  import org.omg.CORBA.BAD_OPERATION;
34  import org.omg.CORBA.ORB;
35  import org.omg.CORBA.SystemException;
36  import org.omg.CORBA.portable.Delegate;
37  import org.omg.CORBA.portable.ObjectImpl;
38  
39  import org.jboss.com.sun.corba.se.impl.corba.CORBAObjectImpl;
40  import org.jboss.com.sun.corba.se.impl.ior.StubIORImpl;
41  import org.jboss.com.sun.corba.se.impl.logging.UtilSystemException;
42  import org.jboss.com.sun.corba.se.impl.util.Utility;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/StubConnectImpl.java
      * Line Number: 33
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.presentation.rmi;
27  
28  import java.rmi.RemoteException;
29  
30  import javax.rmi.CORBA.Tie;
31  
32  import org.omg.CORBA.BAD_INV_ORDER;
33  import org.omg.CORBA.BAD_OPERATION;
34  import org.omg.CORBA.ORB;
35  import org.omg.CORBA.SystemException;
36  import org.omg.CORBA.portable.Delegate;
37  import org.omg.CORBA.portable.ObjectImpl;
38  
39  import org.jboss.com.sun.corba.se.impl.corba.CORBAObjectImpl;
40  import org.jboss.com.sun.corba.se.impl.ior.StubIORImpl;
41  import org.jboss.com.sun.corba.se.impl.logging.UtilSystemException;
42  import org.jboss.com.sun.corba.se.impl.util.Utility;
43  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/StubConnectImpl.java
      * Line Number: 34
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.presentation.rmi;
27  
28  import java.rmi.RemoteException;
29  
30  import javax.rmi.CORBA.Tie;
31  
32  import org.omg.CORBA.BAD_INV_ORDER;
33  import org.omg.CORBA.BAD_OPERATION;
34  import org.omg.CORBA.ORB;
35  import org.omg.CORBA.SystemException;
36  import org.omg.CORBA.portable.Delegate;
37  import org.omg.CORBA.portable.ObjectImpl;
38  
39  import org.jboss.com.sun.corba.se.impl.corba.CORBAObjectImpl;
40  import org.jboss.com.sun.corba.se.impl.ior.StubIORImpl;
41  import org.jboss.com.sun.corba.se.impl.logging.UtilSystemException;
42  import org.jboss.com.sun.corba.se.impl.util.Utility;
43  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
44  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/StubConnectImpl.java
      * Line Number: 35
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
25  
26  package org.jboss.com.sun.corba.se.impl.presentation.rmi;
27  
28  import java.rmi.RemoteException;
29  
30  import javax.rmi.CORBA.Tie;
31  
32  import org.omg.CORBA.BAD_INV_ORDER;
33  import org.omg.CORBA.BAD_OPERATION;
34  import org.omg.CORBA.ORB;
35  import org.omg.CORBA.SystemException;
36  import org.omg.CORBA.portable.Delegate;
37  import org.omg.CORBA.portable.ObjectImpl;
38  
39  import org.jboss.com.sun.corba.se.impl.corba.CORBAObjectImpl;
40  import org.jboss.com.sun.corba.se.impl.ior.StubIORImpl;
41  import org.jboss.com.sun.corba.se.impl.logging.UtilSystemException;
42  import org.jboss.com.sun.corba.se.impl.util.Utility;
43  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
44  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
45  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/StubConnectImpl.java
      * Line Number: 36
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
26  package org.jboss.com.sun.corba.se.impl.presentation.rmi;
27  
28  import java.rmi.RemoteException;
29  
30  import javax.rmi.CORBA.Tie;
31  
32  import org.omg.CORBA.BAD_INV_ORDER;
33  import org.omg.CORBA.BAD_OPERATION;
34  import org.omg.CORBA.ORB;
35  import org.omg.CORBA.SystemException;
36  import org.omg.CORBA.portable.Delegate;
37  import org.omg.CORBA.portable.ObjectImpl;
38  
39  import org.jboss.com.sun.corba.se.impl.corba.CORBAObjectImpl;
40  import org.jboss.com.sun.corba.se.impl.ior.StubIORImpl;
41  import org.jboss.com.sun.corba.se.impl.logging.UtilSystemException;
42  import org.jboss.com.sun.corba.se.impl.util.Utility;
43  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
44  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
45  
46  public abstract class StubConnectImpl
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/StubConnectImpl.java
      * Line Number: 37
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
27  
28  import java.rmi.RemoteException;
29  
30  import javax.rmi.CORBA.Tie;
31  
32  import org.omg.CORBA.BAD_INV_ORDER;
33  import org.omg.CORBA.BAD_OPERATION;
34  import org.omg.CORBA.ORB;
35  import org.omg.CORBA.SystemException;
36  import org.omg.CORBA.portable.Delegate;
37  import org.omg.CORBA.portable.ObjectImpl;
38  
39  import org.jboss.com.sun.corba.se.impl.corba.CORBAObjectImpl;
40  import org.jboss.com.sun.corba.se.impl.ior.StubIORImpl;
41  import org.jboss.com.sun.corba.se.impl.logging.UtilSystemException;
42  import org.jboss.com.sun.corba.se.impl.util.Utility;
43  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
44  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
45  
46  public abstract class StubConnectImpl
47  {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/StubConnectImpl.java
      * Line Number: 62
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
52       * 
53       * @param ior
54       *            The StubIORImpl for this stub (may be null)
55       * @param proxy
56       *            The externally visible stub seen by the user (may be the same as stub)
57       * @param stub
58       *            The stub implementation that extends ObjectImpl
59       * @param orb
60       *            The ORB to which we connect the stub.
61       */
62      public static StubIORImpl connect(StubIORImpl ior, org.omg.CORBA.Object proxy,
63              org.omg.CORBA.portable.ObjectImpl stub, ORB orb) throws RemoteException
64      {
65          Delegate del = null;
66  
67          try
68          {
69              try
70              {
71                  del = StubAdapter.getDelegate(stub);
72  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/StubConnectImpl.java
      * Line Number: 63
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
53       * @param ior
54       *            The StubIORImpl for this stub (may be null)
55       * @param proxy
56       *            The externally visible stub seen by the user (may be the same as stub)
57       * @param stub
58       *            The stub implementation that extends ObjectImpl
59       * @param orb
60       *            The ORB to which we connect the stub.
61       */
62      public static StubIORImpl connect(StubIORImpl ior, org.omg.CORBA.Object proxy,
63              org.omg.CORBA.portable.ObjectImpl stub, ORB orb) throws RemoteException
64      {
65          Delegate del = null;
66  
67          try
68          {
69              try
70              {
71                  del = StubAdapter.getDelegate(stub);
72  
73                  if (del.orb(stub) != orb)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/StubConnectImpl.java
      * Line Number: 76
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
66  
67          try
68          {
69              try
70              {
71                  del = StubAdapter.getDelegate(stub);
72  
73                  if (del.orb(stub) != orb)
74                      throw wrapper.connectWrongOrb();
75              }
76              catch (org.omg.CORBA.BAD_OPERATION err)
77              {
78                  if (ior == null)
79                  {
80                      // No IOR, can we get a Tie for this stub?
81                      Tie tie = Utility.getAndForgetTie(proxy);
82                      if (tie == null)
83                          throw wrapper.connectNoTie();
84  
85                      // Is the tie already connected? If it is, check that it's connected to the same ORB, otherwise
86                      // connect it.
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/StubFactoryFactoryDynamicBase.java
      * Line Number: 37
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
27  
28  import java.rmi.Remote;
29  
30  import javax.rmi.CORBA.Tie;
31  import javax.rmi.CORBA.Util;
32  
33  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
34  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
35  import org.jboss.com.sun.corba.se.spi.orb.ORB;
36  import org.jboss.com.sun.corba.se.spi.presentation.rmi.PresentationManager;
37  import org.omg.CORBA.CompletionStatus;
38  import org.omg.CORBA.portable.IDLEntity;
39  
40  public abstract class StubFactoryFactoryDynamicBase extends StubFactoryFactoryBase
41  {
42      protected final ORBUtilSystemException wrapper;
43  
44      public StubFactoryFactoryDynamicBase()
45      {
46          wrapper = ORBUtilSystemException.get(CORBALogDomains.RPC_PRESENTATION);
47      }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/StubFactoryFactoryDynamicBase.java
      * Line Number: 38
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
28  import java.rmi.Remote;
29  
30  import javax.rmi.CORBA.Tie;
31  import javax.rmi.CORBA.Util;
32  
33  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
34  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
35  import org.jboss.com.sun.corba.se.spi.orb.ORB;
36  import org.jboss.com.sun.corba.se.spi.presentation.rmi.PresentationManager;
37  import org.omg.CORBA.CompletionStatus;
38  import org.omg.CORBA.portable.IDLEntity;
39  
40  public abstract class StubFactoryFactoryDynamicBase extends StubFactoryFactoryBase
41  {
42      protected final ORBUtilSystemException wrapper;
43  
44      public StubFactoryFactoryDynamicBase()
45      {
46          wrapper = ORBUtilSystemException.get(CORBALogDomains.RPC_PRESENTATION);
47      }
48  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/StubFactoryFactoryStaticImpl.java
      * Line Number: 31
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
21   * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
22   * or visit www.oracle.com if you need additional information or have any
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.presentation.rmi;
27  
28  import javax.rmi.CORBA.Tie;
29  import javax.rmi.CORBA.Util;
30  
31  import org.omg.CORBA.CompletionStatus;
32  
33  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
34  import org.jboss.com.sun.corba.se.impl.presentation.rmi.StubFactoryFactoryBase;
35  import org.jboss.com.sun.corba.se.impl.util.PackagePrefixChecker;
36  import org.jboss.com.sun.corba.se.impl.util.Utility;
37  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
38  import org.jboss.com.sun.corba.se.spi.presentation.rmi.PresentationManager;
39  
40  public class StubFactoryFactoryStaticImpl extends StubFactoryFactoryBase
41  {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/StubFactoryStaticImpl.java
      * Line Number: 40
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
30  public class StubFactoryStaticImpl extends StubFactoryBase
31  {
32      private Class<?> stubClass;
33  
34      public StubFactoryStaticImpl(Class<?> cls)
35      {
36          super(null);
37          this.stubClass = cls;
38      }
39  
40      public org.omg.CORBA.Object makeStub()
41      {
42          org.omg.CORBA.Object stub = null;
43          try
44          {
45              stub = (org.omg.CORBA.Object) stubClass.newInstance();
46          }
47          catch (InstantiationException e)
48          {
49              throw new RuntimeException(e);
50          }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/StubFactoryStaticImpl.java
      * Line Number: 42
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
32      private Class<?> stubClass;
33  
34      public StubFactoryStaticImpl(Class<?> cls)
35      {
36          super(null);
37          this.stubClass = cls;
38      }
39  
40      public org.omg.CORBA.Object makeStub()
41      {
42          org.omg.CORBA.Object stub = null;
43          try
44          {
45              stub = (org.omg.CORBA.Object) stubClass.newInstance();
46          }
47          catch (InstantiationException e)
48          {
49              throw new RuntimeException(e);
50          }
51          catch (IllegalAccessException e)
52          {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/StubFactoryStaticImpl.java
      * Line Number: 45
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
35      {
36          super(null);
37          this.stubClass = cls;
38      }
39  
40      public org.omg.CORBA.Object makeStub()
41      {
42          org.omg.CORBA.Object stub = null;
43          try
44          {
45              stub = (org.omg.CORBA.Object) stubClass.newInstance();
46          }
47          catch (InstantiationException e)
48          {
49              throw new RuntimeException(e);
50          }
51          catch (IllegalAccessException e)
52          {
53              throw new RuntimeException(e);
54          }
55          return stub;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/StubInvocationHandlerImpl.java
      * Line Number: 129
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
119          }
120          catch (SystemException ex)
121          {
122              throw Util.mapSystemException(ex);
123          }
124  
125          if (!isLocal())
126          {
127              try
128              {
129                  org.omg.CORBA_2_3.portable.InputStream in = null;
130                  try
131                  {
132                      // create request
133                      org.omg.CORBA_2_3.portable.OutputStream out = (org.omg.CORBA_2_3.portable.OutputStream) delegate
134                              .request(stub, giopMethodName, true);
135  
136                      // marshal arguments
137                      dmm.writeArguments(out, args);
138  
139                      // finish invocation
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/StubInvocationHandlerImpl.java
      * Line Number: 133
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
123          }
124  
125          if (!isLocal())
126          {
127              try
128              {
129                  org.omg.CORBA_2_3.portable.InputStream in = null;
130                  try
131                  {
132                      // create request
133                      org.omg.CORBA_2_3.portable.OutputStream out = (org.omg.CORBA_2_3.portable.OutputStream) delegate
134                              .request(stub, giopMethodName, true);
135  
136                      // marshal arguments
137                      dmm.writeArguments(out, args);
138  
139                      // finish invocation
140                      in = (org.omg.CORBA_2_3.portable.InputStream) delegate.invoke(stub, out);
141  
142                      // unmarshal result
143                      return dmm.readResult(in);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/StubInvocationHandlerImpl.java
      * Line Number: 140
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
130                  try
131                  {
132                      // create request
133                      org.omg.CORBA_2_3.portable.OutputStream out = (org.omg.CORBA_2_3.portable.OutputStream) delegate
134                              .request(stub, giopMethodName, true);
135  
136                      // marshal arguments
137                      dmm.writeArguments(out, args);
138  
139                      // finish invocation
140                      in = (org.omg.CORBA_2_3.portable.InputStream) delegate.invoke(stub, out);
141  
142                      // unmarshal result
143                      return dmm.readResult(in);
144                  }
145                  catch (ApplicationException ex)
146                  {
147                      throw dmm.readException(ex);
148                  }
149                  catch (RemarshalException ex)
150                  {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/StubInvocationHandlerImpl.java
      * Line Number: 45
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
35  
36  import org.jboss.com.sun.corba.se.pept.transport.ContactInfoList;
37  import org.jboss.com.sun.corba.se.spi.orb.ORB;
38  import org.jboss.com.sun.corba.se.spi.orbutil.proxy.LinkedInvocationHandler;
39  import org.jboss.com.sun.corba.se.spi.presentation.rmi.DynamicMethodMarshaller;
40  import org.jboss.com.sun.corba.se.spi.presentation.rmi.PresentationManager;
41  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
42  import org.jboss.com.sun.corba.se.spi.protocol.CorbaClientDelegate;
43  import org.jboss.com.sun.corba.se.spi.protocol.LocalClientRequestDispatcher;
44  import org.jboss.com.sun.corba.se.spi.transport.CorbaContactInfoList;
45  import org.omg.CORBA.SystemException;
46  import org.omg.CORBA.portable.ApplicationException;
47  import org.omg.CORBA.portable.Delegate;
48  import org.omg.CORBA.portable.RemarshalException;
49  import org.omg.CORBA.portable.ServantObject;
50  
51  public final class StubInvocationHandlerImpl implements LinkedInvocationHandler
52  {
53      private transient PresentationManager.ClassData classData;
54  
55      private transient PresentationManager pm;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/StubInvocationHandlerImpl.java
      * Line Number: 46
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
36  import org.jboss.com.sun.corba.se.pept.transport.ContactInfoList;
37  import org.jboss.com.sun.corba.se.spi.orb.ORB;
38  import org.jboss.com.sun.corba.se.spi.orbutil.proxy.LinkedInvocationHandler;
39  import org.jboss.com.sun.corba.se.spi.presentation.rmi.DynamicMethodMarshaller;
40  import org.jboss.com.sun.corba.se.spi.presentation.rmi.PresentationManager;
41  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
42  import org.jboss.com.sun.corba.se.spi.protocol.CorbaClientDelegate;
43  import org.jboss.com.sun.corba.se.spi.protocol.LocalClientRequestDispatcher;
44  import org.jboss.com.sun.corba.se.spi.transport.CorbaContactInfoList;
45  import org.omg.CORBA.SystemException;
46  import org.omg.CORBA.portable.ApplicationException;
47  import org.omg.CORBA.portable.Delegate;
48  import org.omg.CORBA.portable.RemarshalException;
49  import org.omg.CORBA.portable.ServantObject;
50  
51  public final class StubInvocationHandlerImpl implements LinkedInvocationHandler
52  {
53      private transient PresentationManager.ClassData classData;
54  
55      private transient PresentationManager pm;
56  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/StubInvocationHandlerImpl.java
      * Line Number: 47
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
37  import org.jboss.com.sun.corba.se.spi.orb.ORB;
38  import org.jboss.com.sun.corba.se.spi.orbutil.proxy.LinkedInvocationHandler;
39  import org.jboss.com.sun.corba.se.spi.presentation.rmi.DynamicMethodMarshaller;
40  import org.jboss.com.sun.corba.se.spi.presentation.rmi.PresentationManager;
41  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
42  import org.jboss.com.sun.corba.se.spi.protocol.CorbaClientDelegate;
43  import org.jboss.com.sun.corba.se.spi.protocol.LocalClientRequestDispatcher;
44  import org.jboss.com.sun.corba.se.spi.transport.CorbaContactInfoList;
45  import org.omg.CORBA.SystemException;
46  import org.omg.CORBA.portable.ApplicationException;
47  import org.omg.CORBA.portable.Delegate;
48  import org.omg.CORBA.portable.RemarshalException;
49  import org.omg.CORBA.portable.ServantObject;
50  
51  public final class StubInvocationHandlerImpl implements LinkedInvocationHandler
52  {
53      private transient PresentationManager.ClassData classData;
54  
55      private transient PresentationManager pm;
56  
57      private transient org.omg.CORBA.Object stub;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/StubInvocationHandlerImpl.java
      * Line Number: 48
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
38  import org.jboss.com.sun.corba.se.spi.orbutil.proxy.LinkedInvocationHandler;
39  import org.jboss.com.sun.corba.se.spi.presentation.rmi.DynamicMethodMarshaller;
40  import org.jboss.com.sun.corba.se.spi.presentation.rmi.PresentationManager;
41  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
42  import org.jboss.com.sun.corba.se.spi.protocol.CorbaClientDelegate;
43  import org.jboss.com.sun.corba.se.spi.protocol.LocalClientRequestDispatcher;
44  import org.jboss.com.sun.corba.se.spi.transport.CorbaContactInfoList;
45  import org.omg.CORBA.SystemException;
46  import org.omg.CORBA.portable.ApplicationException;
47  import org.omg.CORBA.portable.Delegate;
48  import org.omg.CORBA.portable.RemarshalException;
49  import org.omg.CORBA.portable.ServantObject;
50  
51  public final class StubInvocationHandlerImpl implements LinkedInvocationHandler
52  {
53      private transient PresentationManager.ClassData classData;
54  
55      private transient PresentationManager pm;
56  
57      private transient org.omg.CORBA.Object stub;
58  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/StubInvocationHandlerImpl.java
      * Line Number: 49
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
39  import org.jboss.com.sun.corba.se.spi.presentation.rmi.DynamicMethodMarshaller;
40  import org.jboss.com.sun.corba.se.spi.presentation.rmi.PresentationManager;
41  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
42  import org.jboss.com.sun.corba.se.spi.protocol.CorbaClientDelegate;
43  import org.jboss.com.sun.corba.se.spi.protocol.LocalClientRequestDispatcher;
44  import org.jboss.com.sun.corba.se.spi.transport.CorbaContactInfoList;
45  import org.omg.CORBA.SystemException;
46  import org.omg.CORBA.portable.ApplicationException;
47  import org.omg.CORBA.portable.Delegate;
48  import org.omg.CORBA.portable.RemarshalException;
49  import org.omg.CORBA.portable.ServantObject;
50  
51  public final class StubInvocationHandlerImpl implements LinkedInvocationHandler
52  {
53      private transient PresentationManager.ClassData classData;
54  
55      private transient PresentationManager pm;
56  
57      private transient org.omg.CORBA.Object stub;
58  
59      private transient Proxy self;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/StubInvocationHandlerImpl.java
      * Line Number: 57
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
47  import org.omg.CORBA.portable.Delegate;
48  import org.omg.CORBA.portable.RemarshalException;
49  import org.omg.CORBA.portable.ServantObject;
50  
51  public final class StubInvocationHandlerImpl implements LinkedInvocationHandler
52  {
53      private transient PresentationManager.ClassData classData;
54  
55      private transient PresentationManager pm;
56  
57      private transient org.omg.CORBA.Object stub;
58  
59      private transient Proxy self;
60  
61      public void setProxy(Proxy self)
62      {
63          this.self = self;
64      }
65  
66      public Proxy getProxy()
67      {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/presentation/rmi/StubInvocationHandlerImpl.java
      * Line Number: 72
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
62      {
63          this.self = self;
64      }
65  
66      public Proxy getProxy()
67      {
68          return self;
69      }
70  
71      public StubInvocationHandlerImpl(PresentationManager pm, PresentationManager.ClassData classData,
72              org.omg.CORBA.Object stub)
73      {
74          SecurityManager s = System.getSecurityManager();
75          if (s != null)
76          {
77              s.checkPermission(new DynamicAccessPermission("access"));
78          }
79          this.classData = classData;
80          this.pm = pm;
81          this.stub = stub;
82      }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/AddressingDispositionHelper.java
      * Line Number: 38
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
28  /**
29   * org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/AddressingDispositionHelper.java Generated by the IDL-to-Java compiler
30   * (portable), version "3.0" from src/main/resources/idl/org/jboss/com/sun/corba/se/GiopIDL/g.idl Sunday, June 4,
31   * 2000 5:18:54 PM PDT
32   */
33  
34  abstract public class AddressingDispositionHelper
35  {
36      private static String _id = "IDL:messages/AddressingDisposition:1.0";
37  
38      public static void insert(org.omg.CORBA.Any a, short that)
39      {
40          org.omg.CORBA.portable.OutputStream out = a.create_output_stream();
41          a.type(type());
42          write(out, that);
43          a.read_value(out.create_input_stream(), type());
44      }
45  
46      public static short extract(org.omg.CORBA.Any a)
47      {
48          return read(a.create_input_stream());
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/AddressingDispositionHelper.java
      * Line Number: 40
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
30   * (portable), version "3.0" from src/main/resources/idl/org/jboss/com/sun/corba/se/GiopIDL/g.idl Sunday, June 4,
31   * 2000 5:18:54 PM PDT
32   */
33  
34  abstract public class AddressingDispositionHelper
35  {
36      private static String _id = "IDL:messages/AddressingDisposition:1.0";
37  
38      public static void insert(org.omg.CORBA.Any a, short that)
39      {
40          org.omg.CORBA.portable.OutputStream out = a.create_output_stream();
41          a.type(type());
42          write(out, that);
43          a.read_value(out.create_input_stream(), type());
44      }
45  
46      public static short extract(org.omg.CORBA.Any a)
47      {
48          return read(a.create_input_stream());
49      }
50  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/AddressingDispositionHelper.java
      * Line Number: 46
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
36      private static String _id = "IDL:messages/AddressingDisposition:1.0";
37  
38      public static void insert(org.omg.CORBA.Any a, short that)
39      {
40          org.omg.CORBA.portable.OutputStream out = a.create_output_stream();
41          a.type(type());
42          write(out, that);
43          a.read_value(out.create_input_stream(), type());
44      }
45  
46      public static short extract(org.omg.CORBA.Any a)
47      {
48          return read(a.create_input_stream());
49      }
50  
51      private static org.omg.CORBA.TypeCode __typeCode = null;
52  
53      synchronized public static org.omg.CORBA.TypeCode type()
54      {
55          if (__typeCode == null)
56          {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/AddressingDispositionHelper.java
      * Line Number: 51
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
41          a.type(type());
42          write(out, that);
43          a.read_value(out.create_input_stream(), type());
44      }
45  
46      public static short extract(org.omg.CORBA.Any a)
47      {
48          return read(a.create_input_stream());
49      }
50  
51      private static org.omg.CORBA.TypeCode __typeCode = null;
52  
53      synchronized public static org.omg.CORBA.TypeCode type()
54      {
55          if (__typeCode == null)
56          {
57              __typeCode = org.omg.CORBA.ORB.init().get_primitive_tc(org.omg.CORBA.TCKind.tk_short);
58              __typeCode = org.omg.CORBA.ORB.init().create_alias_tc(AddressingDispositionHelper.id(),
59                      "AddressingDisposition", __typeCode);
60          }
61          return __typeCode;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/AddressingDispositionHelper.java
      * Line Number: 53
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
43          a.read_value(out.create_input_stream(), type());
44      }
45  
46      public static short extract(org.omg.CORBA.Any a)
47      {
48          return read(a.create_input_stream());
49      }
50  
51      private static org.omg.CORBA.TypeCode __typeCode = null;
52  
53      synchronized public static org.omg.CORBA.TypeCode type()
54      {
55          if (__typeCode == null)
56          {
57              __typeCode = org.omg.CORBA.ORB.init().get_primitive_tc(org.omg.CORBA.TCKind.tk_short);
58              __typeCode = org.omg.CORBA.ORB.init().create_alias_tc(AddressingDispositionHelper.id(),
59                      "AddressingDisposition", __typeCode);
60          }
61          return __typeCode;
62      }
63  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/AddressingDispositionHelper.java
      * Line Number: 57
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
47      {
48          return read(a.create_input_stream());
49      }
50  
51      private static org.omg.CORBA.TypeCode __typeCode = null;
52  
53      synchronized public static org.omg.CORBA.TypeCode type()
54      {
55          if (__typeCode == null)
56          {
57              __typeCode = org.omg.CORBA.ORB.init().get_primitive_tc(org.omg.CORBA.TCKind.tk_short);
58              __typeCode = org.omg.CORBA.ORB.init().create_alias_tc(AddressingDispositionHelper.id(),
59                      "AddressingDisposition", __typeCode);
60          }
61          return __typeCode;
62      }
63  
64      public static String id()
65      {
66          return _id;
67      }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/AddressingDispositionHelper.java
      * Line Number: 58
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
48          return read(a.create_input_stream());
49      }
50  
51      private static org.omg.CORBA.TypeCode __typeCode = null;
52  
53      synchronized public static org.omg.CORBA.TypeCode type()
54      {
55          if (__typeCode == null)
56          {
57              __typeCode = org.omg.CORBA.ORB.init().get_primitive_tc(org.omg.CORBA.TCKind.tk_short);
58              __typeCode = org.omg.CORBA.ORB.init().create_alias_tc(AddressingDispositionHelper.id(),
59                      "AddressingDisposition", __typeCode);
60          }
61          return __typeCode;
62      }
63  
64      public static String id()
65      {
66          return _id;
67      }
68  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/AddressingDispositionHelper.java
      * Line Number: 69
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
59                      "AddressingDisposition", __typeCode);
60          }
61          return __typeCode;
62      }
63  
64      public static String id()
65      {
66          return _id;
67      }
68  
69      public static short read(org.omg.CORBA.portable.InputStream istream)
70      {
71          short value = (short) 0;
72          value = istream.read_short();
73          return value;
74      }
75  
76      public static void write(org.omg.CORBA.portable.OutputStream ostream, short value)
77      {
78          ostream.write_short(value);
79      }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/AddressingDispositionHelper.java
      * Line Number: 76
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
66          return _id;
67      }
68  
69      public static short read(org.omg.CORBA.portable.InputStream istream)
70      {
71          short value = (short) 0;
72          value = istream.read_short();
73          return value;
74      }
75  
76      public static void write(org.omg.CORBA.portable.OutputStream ostream, short value)
77      {
78          ostream.write_short(value);
79      }
80  
81  }

```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/CancelRequestMessage_1_0.java
      * Line Number: 62
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
52  
53      // Accessor methods
54  
55      public int getRequestId()
56      {
57          return this.request_id;
58      }
59  
60      // IO methods
61  
62      public void read(org.omg.CORBA.portable.InputStream istream)
63      {
64          super.read(istream);
65          this.request_id = istream.read_ulong();
66      }
67  
68      public void write(org.omg.CORBA.portable.OutputStream ostream)
69      {
70          super.write(ostream);
71          ostream.write_ulong(this.request_id);
72      }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/CancelRequestMessage_1_0.java
      * Line Number: 68
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
58      }
59  
60      // IO methods
61  
62      public void read(org.omg.CORBA.portable.InputStream istream)
63      {
64          super.read(istream);
65          this.request_id = istream.read_ulong();
66      }
67  
68      public void write(org.omg.CORBA.portable.OutputStream ostream)
69      {
70          super.write(ostream);
71          ostream.write_ulong(this.request_id);
72      }
73  
74      public void callback(MessageHandler handler) throws java.io.IOException
75      {
76          handler.handleInput(this);
77      }
78  } // class CancelRequestMessage_1_0
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/CancelRequestMessage_1_1.java
      * Line Number: 65
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
55  
56      // Accessor methods
57  
58      public int getRequestId()
59      {
60          return this.request_id;
61      }
62  
63      // IO methods
64  
65      public void read(org.omg.CORBA.portable.InputStream istream)
66      {
67          super.read(istream);
68          this.request_id = istream.read_ulong();
69      }
70  
71      public void write(org.omg.CORBA.portable.OutputStream ostream)
72      {
73          super.write(ostream);
74          ostream.write_ulong(this.request_id);
75      }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/CancelRequestMessage_1_1.java
      * Line Number: 71
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
61      }
62  
63      // IO methods
64  
65      public void read(org.omg.CORBA.portable.InputStream istream)
66      {
67          super.read(istream);
68          this.request_id = istream.read_ulong();
69      }
70  
71      public void write(org.omg.CORBA.portable.OutputStream ostream)
72      {
73          super.write(ostream);
74          ostream.write_ulong(this.request_id);
75      }
76  
77      public void callback(MessageHandler handler) throws java.io.IOException
78      {
79          handler.handleInput(this);
80      }
81  } // class CancelRequestMessage_1_1
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/CancelRequestMessage_1_2.java
      * Line Number: 65
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
55  
56      // Accessor methods
57  
58      public int getRequestId()
59      {
60          return this.request_id;
61      }
62  
63      // IO methods
64  
65      public void read(org.omg.CORBA.portable.InputStream istream)
66      {
67          super.read(istream);
68          this.request_id = istream.read_ulong();
69      }
70  
71      public void write(org.omg.CORBA.portable.OutputStream ostream)
72      {
73          super.write(ostream);
74          ostream.write_ulong(this.request_id);
75      }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/CancelRequestMessage_1_2.java
      * Line Number: 71
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
61      }
62  
63      // IO methods
64  
65      public void read(org.omg.CORBA.portable.InputStream istream)
66      {
67          super.read(istream);
68          this.request_id = istream.read_ulong();
69      }
70  
71      public void write(org.omg.CORBA.portable.OutputStream ostream)
72      {
73          super.write(ostream);
74          ostream.write_ulong(this.request_id);
75      }
76  
77      public void callback(MessageHandler handler) throws java.io.IOException
78      {
79          handler.handleInput(this);
80      }
81  } // class CancelRequestMessage_1_2
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/FragmentMessage_1_2.java
      * Line Number: 99
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
 89      {
 90          return GIOPMessageHeaderLength + 4;
 91      }
 92  
 93      // IO methods
 94  
 95      /*
 96       * This will never be called, since we do not currently read the request_id from an CDRInputStream. Instead we use
 97       * the readGIOP_1_2_requestId to read the requestId from a byte buffer.
 98       */
 99      public void read(org.omg.CORBA.portable.InputStream istream)
100      {
101          super.read(istream);
102          this.request_id = istream.read_ulong();
103      }
104  
105      public void write(org.omg.CORBA.portable.OutputStream ostream)
106      {
107          super.write(ostream);
108          ostream.write_ulong(this.request_id);
109      }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/FragmentMessage_1_2.java
      * Line Number: 105
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
 95      /*
 96       * This will never be called, since we do not currently read the request_id from an CDRInputStream. Instead we use
 97       * the readGIOP_1_2_requestId to read the requestId from a byte buffer.
 98       */
 99      public void read(org.omg.CORBA.portable.InputStream istream)
100      {
101          super.read(istream);
102          this.request_id = istream.read_ulong();
103      }
104  
105      public void write(org.omg.CORBA.portable.OutputStream ostream)
106      {
107          super.write(ostream);
108          ostream.write_ulong(this.request_id);
109      }
110  
111      public void callback(MessageHandler handler) throws java.io.IOException
112      {
113          handler.handleInput(this);
114      }
115  } // class FragmentMessage_1_2
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/IORAddressingInfo.java
      * Line Number: 35
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
25  
26  package org.jboss.com.sun.corba.se.impl.protocol.giopmsgheaders;
27  
28  /**
29   * org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/IORAddressingInfo.java Generated by the IDL-to-Java compiler
30   * (portable), version "3.0" from src/main/resources/idl/org/jboss/com/sun/corba/se/GiopIDL/g.idl Sunday, June 4,
31   * 2000 5:18:54 PM PDT
32   */
33  
34  @SuppressWarnings("serial")
35  public final class IORAddressingInfo implements org.omg.CORBA.portable.IDLEntity
36  {
37      public int selected_profile_index = 0;
38  
39      public org.omg.IOP.IOR ior = null;
40  
41      public IORAddressingInfo()
42      {
43      } // ctor
44  
45      public IORAddressingInfo(int _selected_profile_index, org.omg.IOP.IOR _ior)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/IORAddressingInfoHelper.java
      * Line Number: 96
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
 86      }
 87  
 88      public static IORAddressingInfo read(org.omg.CORBA.portable.InputStream istream)
 89      {
 90          IORAddressingInfo value = new IORAddressingInfo();
 91          value.selected_profile_index = istream.read_ulong();
 92          value.ior = org.omg.IOP.IORHelper.read(istream);
 93          return value;
 94      }
 95  
 96      public static void write(org.omg.CORBA.portable.OutputStream ostream, IORAddressingInfo value)
 97      {
 98          ostream.write_ulong(value.selected_profile_index);
 99          org.omg.IOP.IORHelper.write(ostream, value.ior);
100      }
101  
102  }

```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/IORAddressingInfoHelper.java
      * Line Number: 38
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
28  /**
29   * org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/IORAddressingInfoHelper.java Generated by the IDL-to-Java compiler
30   * (portable), version "3.0" from src/main/resources/idl/org/jboss/com/sun/corba/se/GiopIDL/g.idl Sunday, June 4,
31   * 2000 5:18:54 PM PDT
32   */
33  
34  abstract public class IORAddressingInfoHelper
35  {
36      private static String _id = "IDL:messages/IORAddressingInfo:1.0";
37  
38      public static void insert(org.omg.CORBA.Any a, IORAddressingInfo that)
39      {
40          org.omg.CORBA.portable.OutputStream out = a.create_output_stream();
41          a.type(type());
42          write(out, that);
43          a.read_value(out.create_input_stream(), type());
44      }
45  
46      public static IORAddressingInfo extract(org.omg.CORBA.Any a)
47      {
48          return read(a.create_input_stream());
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/IORAddressingInfoHelper.java
      * Line Number: 40
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
30   * (portable), version "3.0" from src/main/resources/idl/org/jboss/com/sun/corba/se/GiopIDL/g.idl Sunday, June 4,
31   * 2000 5:18:54 PM PDT
32   */
33  
34  abstract public class IORAddressingInfoHelper
35  {
36      private static String _id = "IDL:messages/IORAddressingInfo:1.0";
37  
38      public static void insert(org.omg.CORBA.Any a, IORAddressingInfo that)
39      {
40          org.omg.CORBA.portable.OutputStream out = a.create_output_stream();
41          a.type(type());
42          write(out, that);
43          a.read_value(out.create_input_stream(), type());
44      }
45  
46      public static IORAddressingInfo extract(org.omg.CORBA.Any a)
47      {
48          return read(a.create_input_stream());
49      }
50  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/IORAddressingInfoHelper.java
      * Line Number: 46
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
36      private static String _id = "IDL:messages/IORAddressingInfo:1.0";
37  
38      public static void insert(org.omg.CORBA.Any a, IORAddressingInfo that)
39      {
40          org.omg.CORBA.portable.OutputStream out = a.create_output_stream();
41          a.type(type());
42          write(out, that);
43          a.read_value(out.create_input_stream(), type());
44      }
45  
46      public static IORAddressingInfo extract(org.omg.CORBA.Any a)
47      {
48          return read(a.create_input_stream());
49      }
50  
51      private static org.omg.CORBA.TypeCode __typeCode = null;
52  
53      private static boolean __active = false;
54  
55      synchronized public static org.omg.CORBA.TypeCode type()
56      {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/IORAddressingInfoHelper.java
      * Line Number: 51
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
41          a.type(type());
42          write(out, that);
43          a.read_value(out.create_input_stream(), type());
44      }
45  
46      public static IORAddressingInfo extract(org.omg.CORBA.Any a)
47      {
48          return read(a.create_input_stream());
49      }
50  
51      private static org.omg.CORBA.TypeCode __typeCode = null;
52  
53      private static boolean __active = false;
54  
55      synchronized public static org.omg.CORBA.TypeCode type()
56      {
57          if (__typeCode == null)
58          {
59              synchronized (org.omg.CORBA.TypeCode.class)
60              {
61                  if (__typeCode == null)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/IORAddressingInfoHelper.java
      * Line Number: 55
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
45  
46      public static IORAddressingInfo extract(org.omg.CORBA.Any a)
47      {
48          return read(a.create_input_stream());
49      }
50  
51      private static org.omg.CORBA.TypeCode __typeCode = null;
52  
53      private static boolean __active = false;
54  
55      synchronized public static org.omg.CORBA.TypeCode type()
56      {
57          if (__typeCode == null)
58          {
59              synchronized (org.omg.CORBA.TypeCode.class)
60              {
61                  if (__typeCode == null)
62                  {
63                      if (__active)
64                      {
65                          return org.omg.CORBA.ORB.init().create_recursive_tc(_id);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/IORAddressingInfoHelper.java
      * Line Number: 59
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
49      }
50  
51      private static org.omg.CORBA.TypeCode __typeCode = null;
52  
53      private static boolean __active = false;
54  
55      synchronized public static org.omg.CORBA.TypeCode type()
56      {
57          if (__typeCode == null)
58          {
59              synchronized (org.omg.CORBA.TypeCode.class)
60              {
61                  if (__typeCode == null)
62                  {
63                      if (__active)
64                      {
65                          return org.omg.CORBA.ORB.init().create_recursive_tc(_id);
66                      }
67                      __active = true;
68                      org.omg.CORBA.StructMember[] _members0 = new org.omg.CORBA.StructMember[2];
69                      org.omg.CORBA.TypeCode _tcOf_members0 = null;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/IORAddressingInfoHelper.java
      * Line Number: 65
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
55      synchronized public static org.omg.CORBA.TypeCode type()
56      {
57          if (__typeCode == null)
58          {
59              synchronized (org.omg.CORBA.TypeCode.class)
60              {
61                  if (__typeCode == null)
62                  {
63                      if (__active)
64                      {
65                          return org.omg.CORBA.ORB.init().create_recursive_tc(_id);
66                      }
67                      __active = true;
68                      org.omg.CORBA.StructMember[] _members0 = new org.omg.CORBA.StructMember[2];
69                      org.omg.CORBA.TypeCode _tcOf_members0 = null;
70                      _tcOf_members0 = org.omg.CORBA.ORB.init().get_primitive_tc(org.omg.CORBA.TCKind.tk_ulong);
71                      _members0[0] = new org.omg.CORBA.StructMember("selected_profile_index", _tcOf_members0, null);
72                      _tcOf_members0 = org.omg.IOP.IORHelper.type();
73                      _members0[1] = new org.omg.CORBA.StructMember("ior", _tcOf_members0, null);
74                      __typeCode = org.omg.CORBA.ORB.init().create_struct_tc(IORAddressingInfoHelper.id(),
75                              "IORAddressingInfo", _members0);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/IORAddressingInfoHelper.java
      * Line Number: 68
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
58          {
59              synchronized (org.omg.CORBA.TypeCode.class)
60              {
61                  if (__typeCode == null)
62                  {
63                      if (__active)
64                      {
65                          return org.omg.CORBA.ORB.init().create_recursive_tc(_id);
66                      }
67                      __active = true;
68                      org.omg.CORBA.StructMember[] _members0 = new org.omg.CORBA.StructMember[2];
69                      org.omg.CORBA.TypeCode _tcOf_members0 = null;
70                      _tcOf_members0 = org.omg.CORBA.ORB.init().get_primitive_tc(org.omg.CORBA.TCKind.tk_ulong);
71                      _members0[0] = new org.omg.CORBA.StructMember("selected_profile_index", _tcOf_members0, null);
72                      _tcOf_members0 = org.omg.IOP.IORHelper.type();
73                      _members0[1] = new org.omg.CORBA.StructMember("ior", _tcOf_members0, null);
74                      __typeCode = org.omg.CORBA.ORB.init().create_struct_tc(IORAddressingInfoHelper.id(),
75                              "IORAddressingInfo", _members0);
76                      __active = false;
77                  }
78              }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/IORAddressingInfoHelper.java
      * Line Number: 69
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
59              synchronized (org.omg.CORBA.TypeCode.class)
60              {
61                  if (__typeCode == null)
62                  {
63                      if (__active)
64                      {
65                          return org.omg.CORBA.ORB.init().create_recursive_tc(_id);
66                      }
67                      __active = true;
68                      org.omg.CORBA.StructMember[] _members0 = new org.omg.CORBA.StructMember[2];
69                      org.omg.CORBA.TypeCode _tcOf_members0 = null;
70                      _tcOf_members0 = org.omg.CORBA.ORB.init().get_primitive_tc(org.omg.CORBA.TCKind.tk_ulong);
71                      _members0[0] = new org.omg.CORBA.StructMember("selected_profile_index", _tcOf_members0, null);
72                      _tcOf_members0 = org.omg.IOP.IORHelper.type();
73                      _members0[1] = new org.omg.CORBA.StructMember("ior", _tcOf_members0, null);
74                      __typeCode = org.omg.CORBA.ORB.init().create_struct_tc(IORAddressingInfoHelper.id(),
75                              "IORAddressingInfo", _members0);
76                      __active = false;
77                  }
78              }
79          }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/IORAddressingInfoHelper.java
      * Line Number: 70
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
60              {
61                  if (__typeCode == null)
62                  {
63                      if (__active)
64                      {
65                          return org.omg.CORBA.ORB.init().create_recursive_tc(_id);
66                      }
67                      __active = true;
68                      org.omg.CORBA.StructMember[] _members0 = new org.omg.CORBA.StructMember[2];
69                      org.omg.CORBA.TypeCode _tcOf_members0 = null;
70                      _tcOf_members0 = org.omg.CORBA.ORB.init().get_primitive_tc(org.omg.CORBA.TCKind.tk_ulong);
71                      _members0[0] = new org.omg.CORBA.StructMember("selected_profile_index", _tcOf_members0, null);
72                      _tcOf_members0 = org.omg.IOP.IORHelper.type();
73                      _members0[1] = new org.omg.CORBA.StructMember("ior", _tcOf_members0, null);
74                      __typeCode = org.omg.CORBA.ORB.init().create_struct_tc(IORAddressingInfoHelper.id(),
75                              "IORAddressingInfo", _members0);
76                      __active = false;
77                  }
78              }
79          }
80          return __typeCode;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/IORAddressingInfoHelper.java
      * Line Number: 71
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
61                  if (__typeCode == null)
62                  {
63                      if (__active)
64                      {
65                          return org.omg.CORBA.ORB.init().create_recursive_tc(_id);
66                      }
67                      __active = true;
68                      org.omg.CORBA.StructMember[] _members0 = new org.omg.CORBA.StructMember[2];
69                      org.omg.CORBA.TypeCode _tcOf_members0 = null;
70                      _tcOf_members0 = org.omg.CORBA.ORB.init().get_primitive_tc(org.omg.CORBA.TCKind.tk_ulong);
71                      _members0[0] = new org.omg.CORBA.StructMember("selected_profile_index", _tcOf_members0, null);
72                      _tcOf_members0 = org.omg.IOP.IORHelper.type();
73                      _members0[1] = new org.omg.CORBA.StructMember("ior", _tcOf_members0, null);
74                      __typeCode = org.omg.CORBA.ORB.init().create_struct_tc(IORAddressingInfoHelper.id(),
75                              "IORAddressingInfo", _members0);
76                      __active = false;
77                  }
78              }
79          }
80          return __typeCode;
81      }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/IORAddressingInfoHelper.java
      * Line Number: 73
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
63                      if (__active)
64                      {
65                          return org.omg.CORBA.ORB.init().create_recursive_tc(_id);
66                      }
67                      __active = true;
68                      org.omg.CORBA.StructMember[] _members0 = new org.omg.CORBA.StructMember[2];
69                      org.omg.CORBA.TypeCode _tcOf_members0 = null;
70                      _tcOf_members0 = org.omg.CORBA.ORB.init().get_primitive_tc(org.omg.CORBA.TCKind.tk_ulong);
71                      _members0[0] = new org.omg.CORBA.StructMember("selected_profile_index", _tcOf_members0, null);
72                      _tcOf_members0 = org.omg.IOP.IORHelper.type();
73                      _members0[1] = new org.omg.CORBA.StructMember("ior", _tcOf_members0, null);
74                      __typeCode = org.omg.CORBA.ORB.init().create_struct_tc(IORAddressingInfoHelper.id(),
75                              "IORAddressingInfo", _members0);
76                      __active = false;
77                  }
78              }
79          }
80          return __typeCode;
81      }
82  
83      public static String id()
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/IORAddressingInfoHelper.java
      * Line Number: 74
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
64                      {
65                          return org.omg.CORBA.ORB.init().create_recursive_tc(_id);
66                      }
67                      __active = true;
68                      org.omg.CORBA.StructMember[] _members0 = new org.omg.CORBA.StructMember[2];
69                      org.omg.CORBA.TypeCode _tcOf_members0 = null;
70                      _tcOf_members0 = org.omg.CORBA.ORB.init().get_primitive_tc(org.omg.CORBA.TCKind.tk_ulong);
71                      _members0[0] = new org.omg.CORBA.StructMember("selected_profile_index", _tcOf_members0, null);
72                      _tcOf_members0 = org.omg.IOP.IORHelper.type();
73                      _members0[1] = new org.omg.CORBA.StructMember("ior", _tcOf_members0, null);
74                      __typeCode = org.omg.CORBA.ORB.init().create_struct_tc(IORAddressingInfoHelper.id(),
75                              "IORAddressingInfo", _members0);
76                      __active = false;
77                  }
78              }
79          }
80          return __typeCode;
81      }
82  
83      public static String id()
84      {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/IORAddressingInfoHelper.java
      * Line Number: 88
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
78              }
79          }
80          return __typeCode;
81      }
82  
83      public static String id()
84      {
85          return _id;
86      }
87  
88      public static IORAddressingInfo read(org.omg.CORBA.portable.InputStream istream)
89      {
90          IORAddressingInfo value = new IORAddressingInfo();
91          value.selected_profile_index = istream.read_ulong();
92          value.ior = org.omg.IOP.IORHelper.read(istream);
93          return value;
94      }
95  
96      public static void write(org.omg.CORBA.portable.OutputStream ostream, IORAddressingInfo value)
97      {
98          ostream.write_ulong(value.selected_profile_index);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/LocateReplyMessage_1_0.java
      * Line Number: 97
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
 87          return null; // 1.0 LocateReply body does not contain SystemException
 88      }
 89  
 90      public IOR getIOR()
 91      {
 92          return this.ior;
 93      }
 94  
 95      // IO methods
 96  
 97      public void read(org.omg.CORBA.portable.InputStream istream)
 98      {
 99          super.read(istream);
100          this.request_id = istream.read_ulong();
101          this.locate_status = istream.read_long();
102          isValidReplyStatus(this.locate_status); // raises exception on error
103  
104          // The code below reads the reply body if status is OBJECT_FORWARD
105          if (this.locate_status == OBJECT_FORWARD)
106          {
107              CDRInputStream cdr = (CDRInputStream) istream;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/LocateReplyMessage_1_0.java
      * Line Number: 113
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
103  
104          // The code below reads the reply body if status is OBJECT_FORWARD
105          if (this.locate_status == OBJECT_FORWARD)
106          {
107              CDRInputStream cdr = (CDRInputStream) istream;
108              this.ior = IORFactories.makeIOR(cdr);
109          }
110      }
111  
112      // Note, this writes only the header information. IOR may be written afterwards into the reply mesg body.
113      public void write(org.omg.CORBA.portable.OutputStream ostream)
114      {
115          super.write(ostream);
116          ostream.write_ulong(this.request_id);
117          ostream.write_long(this.locate_status);
118      }
119  
120      // Static methods
121  
122      public static void isValidReplyStatus(int replyStatus)
123      {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/LocateReplyMessage_1_0.java
      * Line Number: 34
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.protocol.giopmsgheaders;
27  
28  import org.jboss.com.sun.corba.se.impl.encoding.CDRInputStream;
29  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
30  import org.jboss.com.sun.corba.se.spi.ior.IOR;
31  import org.jboss.com.sun.corba.se.spi.ior.IORFactories;
32  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
33  import org.jboss.com.sun.corba.se.spi.orb.ORB;
34  import org.omg.CORBA.CompletionStatus;
35  import org.omg.CORBA.SystemException;
36  
37  /**
38   * This implements the GIOP 1.0 LocateReply header.
39   * 
40   * @author Ram Jeyaraman 05/14/2000
41   */
42  
43  public final class LocateReplyMessage_1_0 extends Message_1_0 implements LocateReplyMessage
44  {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/LocateReplyMessage_1_0.java
      * Line Number: 35
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
25  
26  package org.jboss.com.sun.corba.se.impl.protocol.giopmsgheaders;
27  
28  import org.jboss.com.sun.corba.se.impl.encoding.CDRInputStream;
29  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
30  import org.jboss.com.sun.corba.se.spi.ior.IOR;
31  import org.jboss.com.sun.corba.se.spi.ior.IORFactories;
32  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
33  import org.jboss.com.sun.corba.se.spi.orb.ORB;
34  import org.omg.CORBA.CompletionStatus;
35  import org.omg.CORBA.SystemException;
36  
37  /**
38   * This implements the GIOP 1.0 LocateReply header.
39   * 
40   * @author Ram Jeyaraman 05/14/2000
41   */
42  
43  public final class LocateReplyMessage_1_0 extends Message_1_0 implements LocateReplyMessage
44  {
45  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/LocateReplyMessage_1_1.java
      * Line Number: 98
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
 88          return null; // 1.0 LocateReply body does not contain SystemException
 89      }
 90  
 91      public IOR getIOR()
 92      {
 93          return this.ior;
 94      }
 95  
 96      // IO methods
 97  
 98      public void read(org.omg.CORBA.portable.InputStream istream)
 99      {
100          super.read(istream);
101          this.request_id = istream.read_ulong();
102          this.reply_status = istream.read_long();
103          isValidReplyStatus(this.reply_status); // raises exception on error
104  
105          // The code below reads the reply body if status is OBJECT_FORWARD
106          if (this.reply_status == OBJECT_FORWARD)
107          {
108              CDRInputStream cdr = (CDRInputStream) istream;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/LocateReplyMessage_1_1.java
      * Line Number: 115
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
105          // The code below reads the reply body if status is OBJECT_FORWARD
106          if (this.reply_status == OBJECT_FORWARD)
107          {
108              CDRInputStream cdr = (CDRInputStream) istream;
109              this.ior = IORFactories.makeIOR(cdr);
110          }
111      }
112  
113      // Note, this writes only the header information. SystemException or IOR may be written afterwards into the reply
114      // mesg body.
115      public void write(org.omg.CORBA.portable.OutputStream ostream)
116      {
117          super.write(ostream);
118          ostream.write_ulong(this.request_id);
119          ostream.write_long(this.reply_status);
120      }
121  
122      // Static methods
123  
124      public static void isValidReplyStatus(int replyStatus)
125      {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/LocateReplyMessage_1_1.java
      * Line Number: 35
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
25  
26  package org.jboss.com.sun.corba.se.impl.protocol.giopmsgheaders;
27  
28  import org.jboss.com.sun.corba.se.impl.encoding.CDRInputStream;
29  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
30  import org.jboss.com.sun.corba.se.spi.ior.IOR;
31  import org.jboss.com.sun.corba.se.spi.ior.IORFactories;
32  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
33  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
34  import org.jboss.com.sun.corba.se.spi.orb.ORB;
35  import org.omg.CORBA.CompletionStatus;
36  import org.omg.CORBA.SystemException;
37  
38  /**
39   * This implements the GIOP 1.1 LocateReply header.
40   * 
41   * @author Ram Jeyaraman 05/14/2000
42   */
43  
44  public final class LocateReplyMessage_1_1 extends Message_1_1 implements LocateReplyMessage
45  {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/LocateReplyMessage_1_1.java
      * Line Number: 36
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
26  package org.jboss.com.sun.corba.se.impl.protocol.giopmsgheaders;
27  
28  import org.jboss.com.sun.corba.se.impl.encoding.CDRInputStream;
29  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
30  import org.jboss.com.sun.corba.se.spi.ior.IOR;
31  import org.jboss.com.sun.corba.se.spi.ior.IORFactories;
32  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
33  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
34  import org.jboss.com.sun.corba.se.spi.orb.ORB;
35  import org.omg.CORBA.CompletionStatus;
36  import org.omg.CORBA.SystemException;
37  
38  /**
39   * This implements the GIOP 1.1 LocateReply header.
40   * 
41   * @author Ram Jeyaraman 05/14/2000
42   */
43  
44  public final class LocateReplyMessage_1_1 extends Message_1_1 implements LocateReplyMessage
45  {
46  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/LocateReplyMessage_1_2.java
      * Line Number: 109
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
 99          return MessageBase.getSystemException(exClassName, minorCode, completionStatus, message, wrapper);
100      }
101  
102      public IOR getIOR()
103      {
104          return this.ior;
105      }
106  
107      // IO methods
108  
109      public void read(org.omg.CORBA.portable.InputStream istream)
110      {
111          super.read(istream);
112          this.request_id = istream.read_ulong();
113          this.reply_status = istream.read_long();
114          isValidReplyStatus(this.reply_status); // raises exception on error
115  
116          // GIOP 1.2 LocateReply message bodies are not aligned on 8 byte boundaries.
117  
118          // The code below reads the reply body in some cases LOC_SYSTEM_EXCEPTION & OBJECT_FORWARD & OBJECT_FORWARD_PERM
119          // & LOC_NEEDS_ADDRESSING_MODE
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/LocateReplyMessage_1_2.java
      * Line Number: 159
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
149          else if (this.reply_status == LOC_NEEDS_ADDRESSING_MODE)
150          {
151              // read GIOP::AddressingDisposition from body and resend the original request using the requested addressing
152              // mode. The resending is transparent to the caller.
153              this.addrDisposition = AddressingDispositionHelper.read(istream);
154          }
155      }
156  
157      // Note, this writes only the header information. SystemException or IOR or GIOP::AddressingDisposition may be
158      // written afterwards into the reply mesg body.
159      public void write(org.omg.CORBA.portable.OutputStream ostream)
160      {
161          super.write(ostream);
162          ostream.write_ulong(this.request_id);
163          ostream.write_long(this.reply_status);
164  
165          // GIOP 1.2 LocateReply message bodies are not aligned on 8 byte boundaries.
166      }
167  
168      // Static methods
169  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/LocateReplyMessage_1_2.java
      * Line Number: 36
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
26  package org.jboss.com.sun.corba.se.impl.protocol.giopmsgheaders;
27  
28  import org.jboss.com.sun.corba.se.impl.encoding.CDRInputStream;
29  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
30  import org.jboss.com.sun.corba.se.impl.orbutil.ORBUtility;
31  import org.jboss.com.sun.corba.se.spi.ior.IOR;
32  import org.jboss.com.sun.corba.se.spi.ior.IORFactories;
33  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
34  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
35  import org.jboss.com.sun.corba.se.spi.orb.ORB;
36  import org.omg.CORBA.CompletionStatus;
37  import org.omg.CORBA.SystemException;
38  
39  /**
40   * This implements the GIOP 1.2 LocateReply header.
41   * 
42   * @author Ram Jeyaraman 05/14/2000
43   */
44  
45  public final class LocateReplyMessage_1_2 extends Message_1_2 implements LocateReplyMessage
46  {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/LocateReplyMessage_1_2.java
      * Line Number: 37
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
27  
28  import org.jboss.com.sun.corba.se.impl.encoding.CDRInputStream;
29  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
30  import org.jboss.com.sun.corba.se.impl.orbutil.ORBUtility;
31  import org.jboss.com.sun.corba.se.spi.ior.IOR;
32  import org.jboss.com.sun.corba.se.spi.ior.IORFactories;
33  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
34  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
35  import org.jboss.com.sun.corba.se.spi.orb.ORB;
36  import org.omg.CORBA.CompletionStatus;
37  import org.omg.CORBA.SystemException;
38  
39  /**
40   * This implements the GIOP 1.2 LocateReply header.
41   * 
42   * @author Ram Jeyaraman 05/14/2000
43   */
44  
45  public final class LocateReplyMessage_1_2 extends Message_1_2 implements LocateReplyMessage
46  {
47  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/LocateRequestMessage_1_0.java
      * Line Number: 94
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
 84  
 85      public void read(org.omg.CORBA.portable.InputStream istream)
 86      {
 87          super.read(istream);;
 88          this.request_id = istream.read_ulong();
 89          int _len0 = istream.read_long();
 90          this.object_key = new byte[_len0];
 91          istream.read_octet_array(this.object_key, 0, _len0);
 92      }
 93  
 94      public void write(org.omg.CORBA.portable.OutputStream ostream)
 95      {
 96          super.write(ostream);
 97          ostream.write_ulong(this.request_id);
 98          nullCheck(this.object_key);
 99          ostream.write_long(this.object_key.length);
100          ostream.write_octet_array(this.object_key, 0, this.object_key.length);
101      }
102  
103      public void callback(MessageHandler handler) throws java.io.IOException
104      {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/LocateRequestMessage_1_0.java
      * Line Number: 85
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
75          {
76              // this will raise a MARSHAL exception upon errors.
77              this.objectKey = MessageBase.extractObjectKey(object_key, orb);
78          }
79  
80          return this.objectKey;
81      }
82  
83      // IO methods
84  
85      public void read(org.omg.CORBA.portable.InputStream istream)
86      {
87          super.read(istream);;
88          this.request_id = istream.read_ulong();
89          int _len0 = istream.read_long();
90          this.object_key = new byte[_len0];
91          istream.read_octet_array(this.object_key, 0, _len0);
92      }
93  
94      public void write(org.omg.CORBA.portable.OutputStream ostream)
95      {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/LocateRequestMessage_1_1.java
      * Line Number: 95
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
 85  
 86      public void read(org.omg.CORBA.portable.InputStream istream)
 87      {
 88          super.read(istream);
 89          this.request_id = istream.read_ulong();
 90          int _len1 = istream.read_long();
 91          this.object_key = new byte[_len1];
 92          istream.read_octet_array(this.object_key, 0, _len1);
 93      }
 94  
 95      public void write(org.omg.CORBA.portable.OutputStream ostream)
 96      {
 97          super.write(ostream);
 98          ostream.write_ulong(this.request_id);
 99          nullCheck(this.object_key);
100          ostream.write_long(this.object_key.length);
101          ostream.write_octet_array(this.object_key, 0, this.object_key.length);
102      }
103  
104      public void callback(MessageHandler handler) throws java.io.IOException
105      {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/LocateRequestMessage_1_1.java
      * Line Number: 86
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
76          {
77              // this will raise a MARSHAL exception upon errors.
78              this.objectKey = MessageBase.extractObjectKey(object_key, orb);
79          }
80  
81          return this.objectKey;
82      }
83  
84      // IO methods
85  
86      public void read(org.omg.CORBA.portable.InputStream istream)
87      {
88          super.read(istream);
89          this.request_id = istream.read_ulong();
90          int _len1 = istream.read_long();
91          this.object_key = new byte[_len1];
92          istream.read_octet_array(this.object_key, 0, _len1);
93      }
94  
95      public void write(org.omg.CORBA.portable.OutputStream ostream)
96      {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/LocateRequestMessage_1_2.java
      * Line Number: 92
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
 82      // IO methods
 83  
 84      public void read(org.omg.CORBA.portable.InputStream istream)
 85      {
 86          super.read(istream);
 87          this.request_id = istream.read_ulong();
 88          this.target = TargetAddressHelper.read(istream);
 89          getObjectKey(); // this does AddressingDisposition check
 90      }
 91  
 92      public void write(org.omg.CORBA.portable.OutputStream ostream)
 93      {
 94          super.write(ostream);
 95          ostream.write_ulong(this.request_id);
 96          nullCheck(this.target);
 97          TargetAddressHelper.write(ostream, this.target);
 98      }
 99  
100      public void callback(MessageHandler handler) throws java.io.IOException
101      {
102          handler.handleInput(this);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/LocateRequestMessage_1_2.java
      * Line Number: 84
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
74          {
75              // this will raise a MARSHAL exception upon errors.
76              this.objectKey = MessageBase.extractObjectKey(target, orb);
77          }
78  
79          return this.objectKey;
80      }
81  
82      // IO methods
83  
84      public void read(org.omg.CORBA.portable.InputStream istream)
85      {
86          super.read(istream);
87          this.request_id = istream.read_ulong();
88          this.target = TargetAddressHelper.read(istream);
89          getObjectKey(); // this does AddressingDisposition check
90      }
91  
92      public void write(org.omg.CORBA.portable.OutputStream ostream)
93      {
94          super.write(ostream);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/MessageBase.java
      * Line Number: 52
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
11   * This code is distributed in the hope that it will be useful, but WITHOUT
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/MessageBase.java
      * Line Number: 53
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
43  import org.jboss.com.sun.corba.se.spi.ior.iiop.IIOPFactories;
44  import org.jboss.com.sun.corba.se.spi.ior.iiop.IIOPProfile;
45  import org.jboss.com.sun.corba.se.spi.ior.iiop.IIOPProfileTemplate;
46  import org.jboss.com.sun.corba.se.spi.ior.iiop.RequestPartitioningComponent;
47  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
48  import org.jboss.com.sun.corba.se.spi.orb.ORB;
49  import org.jboss.com.sun.corba.se.spi.servicecontext.ServiceContexts;
50  import org.jboss.com.sun.corba.se.spi.transport.CorbaConnection;
51  import org.jboss.com.sun.corba.se.spi.transport.ReadTimeouts;
52  import org.omg.CORBA.CompletionStatus;
53  import org.omg.CORBA.Principal;
54  import org.omg.CORBA.SystemException;
55  import org.omg.IOP.TaggedProfile;
56  
57  /**
58   * This class acts as the base class for the various GIOP message types. This also serves as a factory to create various
59   * message types. We currently support GIOP 1.0, 1.1 and 1.2 message types.
60   * 
61   * @author Ram Jeyaraman 05/14/2000
62   */
63  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/MessageBase.java
      * Line Number: 54
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
44  import org.jboss.com.sun.corba.se.spi.ior.iiop.IIOPProfile;
45  import org.jboss.com.sun.corba.se.spi.ior.iiop.IIOPProfileTemplate;
46  import org.jboss.com.sun.corba.se.spi.ior.iiop.RequestPartitioningComponent;
47  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
48  import org.jboss.com.sun.corba.se.spi.orb.ORB;
49  import org.jboss.com.sun.corba.se.spi.servicecontext.ServiceContexts;
50  import org.jboss.com.sun.corba.se.spi.transport.CorbaConnection;
51  import org.jboss.com.sun.corba.se.spi.transport.ReadTimeouts;
52  import org.omg.CORBA.CompletionStatus;
53  import org.omg.CORBA.Principal;
54  import org.omg.CORBA.SystemException;
55  import org.omg.IOP.TaggedProfile;
56  
57  /**
58   * This class acts as the base class for the various GIOP message types. This also serves as a factory to create various
59   * message types. We currently support GIOP 1.0, 1.1 and 1.2 message types.
60   * 
61   * @author Ram Jeyaraman 05/14/2000
62   */
63  
64  @SuppressWarnings("deprecation")
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/Message_1_0.java
      * Line Number: 135
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
125      public FragmentMessage createFragmentMessage()
126      {
127          throw wrapper.fragmentationDisallowed(CompletionStatus.COMPLETED_MAYBE);
128      }
129  
130      // IO methods
131  
132      // This should do nothing even if it is called. The Message Header already is read off java.io.InputStream (not a
133      // CDRInputStream) by IIOPConnection in order to choose the correct CDR Version, msg_type, and msg_size. So, we
134      // would never need to read the Message Header off a CDRInputStream.
135      public void read(org.omg.CORBA.portable.InputStream istream)
136      {
137          /*
138           * this.magic = istream.read_long(); this.GIOP_version = (new GIOPVersion()).read(istream); this.byte_order =
139           * istream.read_boolean(); this.message_type = istream.read_octet(); this.message_size = istream.read_ulong();
140           */
141      }
142  
143      public void write(org.omg.CORBA.portable.OutputStream ostream)
144      {
145          ostream.write_long(this.magic);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/Message_1_0.java
      * Line Number: 143
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
133      // CDRInputStream) by IIOPConnection in order to choose the correct CDR Version, msg_type, and msg_size. So, we
134      // would never need to read the Message Header off a CDRInputStream.
135      public void read(org.omg.CORBA.portable.InputStream istream)
136      {
137          /*
138           * this.magic = istream.read_long(); this.GIOP_version = (new GIOPVersion()).read(istream); this.byte_order =
139           * istream.read_boolean(); this.message_type = istream.read_octet(); this.message_size = istream.read_ulong();
140           */
141      }
142  
143      public void write(org.omg.CORBA.portable.OutputStream ostream)
144      {
145          ostream.write_long(this.magic);
146          nullCheck(this.GIOP_version);
147          this.GIOP_version.write(ostream);
148          ostream.write_boolean(this.byte_order);
149          ostream.write_octet(this.message_type);
150          ostream.write_ulong(this.message_size);
151      }
152  
153  } // class Message_1_0
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/Message_1_0.java
      * Line Number: 33
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.protocol.giopmsgheaders;
27  
28  import java.nio.ByteBuffer;
29  
30  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
31  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
32  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
33  import org.omg.CORBA.CompletionStatus;
34  
35  /*
36   * This implements the GIOP 1.0 Message header.
37   *
38   * @author Ram Jeyaraman 05/14/2000
39   */
40  
41  public class Message_1_0 extends MessageBase
42  {
43  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/Message_1_1.java
      * Line Number: 188
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
178          }
179  
180          throw wrapper.giopVersionError(CompletionStatus.COMPLETED_MAYBE);
181      }
182  
183      // IO methods
184  
185      // This should do nothing even if it is called. The Message Header is read off a java.io.InputStream (not a
186      // CDRInputStream) by IIOPConnection in order to choose the correct CDR Version , msg_type, and msg_size. So, we
187      // would never need to read the Message Header off a CDRInputStream.
188      public void read(org.omg.CORBA.portable.InputStream istream)
189      {
190          /*
191           * this.magic = istream.read_long(); this.GIOP_version = (new GIOPVersion()).read(istream); this.flags =
192           * istream.read_octet(); this.message_type = istream.read_octet(); this.message_size = istream.read_ulong();
193           */
194      }
195  
196      public void write(org.omg.CORBA.portable.OutputStream ostream)
197      {
198          ostream.write_long(this.magic);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/Message_1_1.java
      * Line Number: 196
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
186      // CDRInputStream) by IIOPConnection in order to choose the correct CDR Version , msg_type, and msg_size. So, we
187      // would never need to read the Message Header off a CDRInputStream.
188      public void read(org.omg.CORBA.portable.InputStream istream)
189      {
190          /*
191           * this.magic = istream.read_long(); this.GIOP_version = (new GIOPVersion()).read(istream); this.flags =
192           * istream.read_octet(); this.message_type = istream.read_octet(); this.message_size = istream.read_ulong();
193           */
194      }
195  
196      public void write(org.omg.CORBA.portable.OutputStream ostream)
197      {
198          ostream.write_long(this.magic);
199          nullCheck(this.GIOP_version);
200          this.GIOP_version.write(ostream);
201          ostream.write_octet(this.flags);
202          ostream.write_octet(this.message_type);
203          ostream.write_ulong(this.message_size);
204      }
205  } // class Message_1_1

```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/Message_1_1.java
      * Line Number: 33
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.protocol.giopmsgheaders;
27  
28  import java.nio.ByteBuffer;
29  
30  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
31  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
32  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
33  import org.omg.CORBA.CompletionStatus;
34  
35  /*
36   * This implements the GIOP 1.1 & 1.2 Message header.
37   *
38   * @author Ram Jeyaraman 05/14/2000
39   */
40  
41  public class Message_1_1 extends MessageBase
42  {
43  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/ReplyMessage_1_0.java
      * Line Number: 128
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
118          return this.ior;
119      }
120  
121      public void setIOR(IOR ior)
122      {
123          this.ior = ior;
124      }
125  
126      // IO methods
127  
128      public void read(org.omg.CORBA.portable.InputStream istream)
129      {
130          super.read(istream);
131          this.service_contexts = new ServiceContexts((org.omg.CORBA_2_3.portable.InputStream) istream);
132          this.request_id = istream.read_ulong();
133          this.reply_status = istream.read_long();
134          isValidReplyStatus(this.reply_status); // raises exception on error
135  
136          // The code below reads the reply body in some cases SYSTEM_EXCEPTION & LOCATION_FORWARD
137          if (this.reply_status == SYSTEM_EXCEPTION)
138          {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/ReplyMessage_1_0.java
      * Line Number: 131
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
121      public void setIOR(IOR ior)
122      {
123          this.ior = ior;
124      }
125  
126      // IO methods
127  
128      public void read(org.omg.CORBA.portable.InputStream istream)
129      {
130          super.read(istream);
131          this.service_contexts = new ServiceContexts((org.omg.CORBA_2_3.portable.InputStream) istream);
132          this.request_id = istream.read_ulong();
133          this.reply_status = istream.read_long();
134          isValidReplyStatus(this.reply_status); // raises exception on error
135  
136          // The code below reads the reply body in some cases SYSTEM_EXCEPTION & LOCATION_FORWARD
137          if (this.reply_status == SYSTEM_EXCEPTION)
138          {
139  
140              String reposId = istream.read_string();
141              this.exClassName = ORBUtility.classNameOf(reposId);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/ReplyMessage_1_0.java
      * Line Number: 174
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
164          }
165          else if (this.reply_status == LOCATION_FORWARD)
166          {
167              CDRInputStream cdr = (CDRInputStream) istream;
168              this.ior = IORFactories.makeIOR(cdr);
169          }
170      }
171  
172      // Note, this writes only the header information. SystemException or IOR may be written afterwards into the reply
173      // mesg body.
174      public void write(org.omg.CORBA.portable.OutputStream ostream)
175      {
176          super.write(ostream);
177          if (this.service_contexts != null)
178          {
179              service_contexts.write((org.omg.CORBA_2_3.portable.OutputStream) ostream, GIOPVersion.V1_0);
180          }
181          else
182          {
183              ServiceContexts.writeNullServiceContext((org.omg.CORBA_2_3.portable.OutputStream) ostream);
184          }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/ReplyMessage_1_0.java
      * Line Number: 179
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
169          }
170      }
171  
172      // Note, this writes only the header information. SystemException or IOR may be written afterwards into the reply
173      // mesg body.
174      public void write(org.omg.CORBA.portable.OutputStream ostream)
175      {
176          super.write(ostream);
177          if (this.service_contexts != null)
178          {
179              service_contexts.write((org.omg.CORBA_2_3.portable.OutputStream) ostream, GIOPVersion.V1_0);
180          }
181          else
182          {
183              ServiceContexts.writeNullServiceContext((org.omg.CORBA_2_3.portable.OutputStream) ostream);
184          }
185          ostream.write_ulong(this.request_id);
186          ostream.write_long(this.reply_status);
187      }
188  
189      // Static methods
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/ReplyMessage_1_0.java
      * Line Number: 183
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
173      // mesg body.
174      public void write(org.omg.CORBA.portable.OutputStream ostream)
175      {
176          super.write(ostream);
177          if (this.service_contexts != null)
178          {
179              service_contexts.write((org.omg.CORBA_2_3.portable.OutputStream) ostream, GIOPVersion.V1_0);
180          }
181          else
182          {
183              ServiceContexts.writeNullServiceContext((org.omg.CORBA_2_3.portable.OutputStream) ostream);
184          }
185          ostream.write_ulong(this.request_id);
186          ostream.write_long(this.reply_status);
187      }
188  
189      // Static methods
190  
191      public static void isValidReplyStatus(int replyStatus)
192      {
193          switch (replyStatus)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/ReplyMessage_1_0.java
      * Line Number: 37
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
27  
28  import org.jboss.com.sun.corba.se.impl.encoding.CDRInputStream;
29  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
30  import org.jboss.com.sun.corba.se.impl.orbutil.ORBUtility;
31  import org.jboss.com.sun.corba.se.spi.ior.IOR;
32  import org.jboss.com.sun.corba.se.spi.ior.IORFactories;
33  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
34  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
35  import org.jboss.com.sun.corba.se.spi.orb.ORB;
36  import org.jboss.com.sun.corba.se.spi.servicecontext.ServiceContexts;
37  import org.omg.CORBA.CompletionStatus;
38  import org.omg.CORBA.SystemException;
39  
40  /**
41   * This implements the GIOP 1.0 Reply header.
42   * 
43   * @author Ram Jeyaraman 05/14/2000
44   */
45  
46  public final class ReplyMessage_1_0 extends Message_1_0 implements ReplyMessage
47  {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/ReplyMessage_1_0.java
      * Line Number: 38
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
28  import org.jboss.com.sun.corba.se.impl.encoding.CDRInputStream;
29  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
30  import org.jboss.com.sun.corba.se.impl.orbutil.ORBUtility;
31  import org.jboss.com.sun.corba.se.spi.ior.IOR;
32  import org.jboss.com.sun.corba.se.spi.ior.IORFactories;
33  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
34  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
35  import org.jboss.com.sun.corba.se.spi.orb.ORB;
36  import org.jboss.com.sun.corba.se.spi.servicecontext.ServiceContexts;
37  import org.omg.CORBA.CompletionStatus;
38  import org.omg.CORBA.SystemException;
39  
40  /**
41   * This implements the GIOP 1.0 Reply header.
42   * 
43   * @author Ram Jeyaraman 05/14/2000
44   */
45  
46  public final class ReplyMessage_1_0 extends Message_1_0 implements ReplyMessage
47  {
48  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/ReplyMessage_1_1.java
      * Line Number: 128
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
118          return this.ior;
119      }
120  
121      public void setIOR(IOR ior)
122      {
123          this.ior = ior;
124      }
125  
126      // IO methods
127  
128      public void read(org.omg.CORBA.portable.InputStream istream)
129      {
130          super.read(istream);
131          this.service_contexts = new ServiceContexts((org.omg.CORBA_2_3.portable.InputStream) istream);
132          this.request_id = istream.read_ulong();
133          this.reply_status = istream.read_long();
134          isValidReplyStatus(this.reply_status); // raises exception on error
135  
136          // The code below reads the reply body in some cases SYSTEM_EXCEPTION & LOCATION_FORWARD
137          if (this.reply_status == SYSTEM_EXCEPTION)
138          {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/ReplyMessage_1_1.java
      * Line Number: 131
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
121      public void setIOR(IOR ior)
122      {
123          this.ior = ior;
124      }
125  
126      // IO methods
127  
128      public void read(org.omg.CORBA.portable.InputStream istream)
129      {
130          super.read(istream);
131          this.service_contexts = new ServiceContexts((org.omg.CORBA_2_3.portable.InputStream) istream);
132          this.request_id = istream.read_ulong();
133          this.reply_status = istream.read_long();
134          isValidReplyStatus(this.reply_status); // raises exception on error
135  
136          // The code below reads the reply body in some cases SYSTEM_EXCEPTION & LOCATION_FORWARD
137          if (this.reply_status == SYSTEM_EXCEPTION)
138          {
139  
140              String reposId = istream.read_string();
141              this.exClassName = ORBUtility.classNameOf(reposId);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/ReplyMessage_1_1.java
      * Line Number: 173
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
163          }
164          else if (this.reply_status == LOCATION_FORWARD)
165          {
166              CDRInputStream cdr = (CDRInputStream) istream;
167              this.ior = IORFactories.makeIOR(cdr);
168          }
169      }
170  
171      // Note, this writes only the header information. SystemException or IOR may be written afterwards into the reply
172      // mesg body.
173      public void write(org.omg.CORBA.portable.OutputStream ostream)
174      {
175          super.write(ostream);
176          if (this.service_contexts != null)
177          {
178              service_contexts.write((org.omg.CORBA_2_3.portable.OutputStream) ostream, GIOPVersion.V1_1);
179          }
180          else
181          {
182              ServiceContexts.writeNullServiceContext((org.omg.CORBA_2_3.portable.OutputStream) ostream);
183          }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/ReplyMessage_1_1.java
      * Line Number: 178
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
168          }
169      }
170  
171      // Note, this writes only the header information. SystemException or IOR may be written afterwards into the reply
172      // mesg body.
173      public void write(org.omg.CORBA.portable.OutputStream ostream)
174      {
175          super.write(ostream);
176          if (this.service_contexts != null)
177          {
178              service_contexts.write((org.omg.CORBA_2_3.portable.OutputStream) ostream, GIOPVersion.V1_1);
179          }
180          else
181          {
182              ServiceContexts.writeNullServiceContext((org.omg.CORBA_2_3.portable.OutputStream) ostream);
183          }
184          ostream.write_ulong(this.request_id);
185          ostream.write_long(this.reply_status);
186      }
187  
188      // Static methods
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/ReplyMessage_1_1.java
      * Line Number: 182
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
172      // mesg body.
173      public void write(org.omg.CORBA.portable.OutputStream ostream)
174      {
175          super.write(ostream);
176          if (this.service_contexts != null)
177          {
178              service_contexts.write((org.omg.CORBA_2_3.portable.OutputStream) ostream, GIOPVersion.V1_1);
179          }
180          else
181          {
182              ServiceContexts.writeNullServiceContext((org.omg.CORBA_2_3.portable.OutputStream) ostream);
183          }
184          ostream.write_ulong(this.request_id);
185          ostream.write_long(this.reply_status);
186      }
187  
188      // Static methods
189  
190      public static void isValidReplyStatus(int replyStatus)
191      {
192          switch (replyStatus)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/ReplyMessage_1_1.java
      * Line Number: 37
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
27  
28  import org.jboss.com.sun.corba.se.impl.encoding.CDRInputStream;
29  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
30  import org.jboss.com.sun.corba.se.impl.orbutil.ORBUtility;
31  import org.jboss.com.sun.corba.se.spi.ior.IOR;
32  import org.jboss.com.sun.corba.se.spi.ior.IORFactories;
33  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
34  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
35  import org.jboss.com.sun.corba.se.spi.orb.ORB;
36  import org.jboss.com.sun.corba.se.spi.servicecontext.ServiceContexts;
37  import org.omg.CORBA.CompletionStatus;
38  import org.omg.CORBA.SystemException;
39  
40  /**
41   * This implements the GIOP 1.1 Reply header.
42   * 
43   * @author Ram Jeyaraman 05/14/2000
44   */
45  
46  public final class ReplyMessage_1_1 extends Message_1_1 implements ReplyMessage
47  {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/ReplyMessage_1_1.java
      * Line Number: 38
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
28  import org.jboss.com.sun.corba.se.impl.encoding.CDRInputStream;
29  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
30  import org.jboss.com.sun.corba.se.impl.orbutil.ORBUtility;
31  import org.jboss.com.sun.corba.se.spi.ior.IOR;
32  import org.jboss.com.sun.corba.se.spi.ior.IORFactories;
33  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
34  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
35  import org.jboss.com.sun.corba.se.spi.orb.ORB;
36  import org.jboss.com.sun.corba.se.spi.servicecontext.ServiceContexts;
37  import org.omg.CORBA.CompletionStatus;
38  import org.omg.CORBA.SystemException;
39  
40  /**
41   * This implements the GIOP 1.1 Reply header.
42   * 
43   * @author Ram Jeyaraman 05/14/2000
44   */
45  
46  public final class ReplyMessage_1_1 extends Message_1_1 implements ReplyMessage
47  {
48  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/ReplyMessage_1_2.java
      * Line Number: 129
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
119          return this.ior;
120      }
121  
122      public void setIOR(IOR ior)
123      {
124          this.ior = ior;
125      }
126  
127      // IO methods
128  
129      public void read(org.omg.CORBA.portable.InputStream istream)
130      {
131          super.read(istream);
132          this.request_id = istream.read_ulong();
133          this.reply_status = istream.read_long();
134          isValidReplyStatus(this.reply_status); // raises exception on error
135          this.service_contexts = new ServiceContexts((org.omg.CORBA_2_3.portable.InputStream) istream);
136  
137          // CORBA formal 00-11-0 15.4.2.2 GIOP 1.2 body must be aligned on an 8 octet boundary. Ensures that the first
138          // read operation called from the stub code, during body deconstruction, would skip the header padding, that was
139          // inserted to ensure that the body was aligned on an 8-octet boundary.
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/ReplyMessage_1_2.java
      * Line Number: 135
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
125      }
126  
127      // IO methods
128  
129      public void read(org.omg.CORBA.portable.InputStream istream)
130      {
131          super.read(istream);
132          this.request_id = istream.read_ulong();
133          this.reply_status = istream.read_long();
134          isValidReplyStatus(this.reply_status); // raises exception on error
135          this.service_contexts = new ServiceContexts((org.omg.CORBA_2_3.portable.InputStream) istream);
136  
137          // CORBA formal 00-11-0 15.4.2.2 GIOP 1.2 body must be aligned on an 8 octet boundary. Ensures that the first
138          // read operation called from the stub code, during body deconstruction, would skip the header padding, that was
139          // inserted to ensure that the body was aligned on an 8-octet boundary.
140          ((CDRInputStream) istream).setHeaderPadding(true);
141  
142          // The code below reads the reply body in some cases SYSTEM_EXCEPTION & LOCATION_FORWARD & LOCATION_FORWARD_PERM
143          // & NEEDS_ADDRESSING_MODE
144          if (this.reply_status == SYSTEM_EXCEPTION)
145          {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/ReplyMessage_1_2.java
      * Line Number: 187
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
177          else if (this.reply_status == NEEDS_ADDRESSING_MODE)
178          {
179              // read GIOP::AddressingDisposition from body and resend the original request using the requested addressing
180              // mode. The resending is transparent to the client program.
181              this.addrDisposition = AddressingDispositionHelper.read(istream);
182          }
183      }
184  
185      // Note, this writes only the header information. SystemException or IOR or GIOP::AddressingDisposition may be
186      // written afterwards into the reply mesg body.
187      public void write(org.omg.CORBA.portable.OutputStream ostream)
188      {
189          super.write(ostream);
190          ostream.write_ulong(this.request_id);
191          ostream.write_long(this.reply_status);
192          if (this.service_contexts != null)
193          {
194              service_contexts.write((org.omg.CORBA_2_3.portable.OutputStream) ostream, GIOPVersion.V1_2);
195          }
196          else
197          {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/ReplyMessage_1_2.java
      * Line Number: 194
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
184  
185      // Note, this writes only the header information. SystemException or IOR or GIOP::AddressingDisposition may be
186      // written afterwards into the reply mesg body.
187      public void write(org.omg.CORBA.portable.OutputStream ostream)
188      {
189          super.write(ostream);
190          ostream.write_ulong(this.request_id);
191          ostream.write_long(this.reply_status);
192          if (this.service_contexts != null)
193          {
194              service_contexts.write((org.omg.CORBA_2_3.portable.OutputStream) ostream, GIOPVersion.V1_2);
195          }
196          else
197          {
198              ServiceContexts.writeNullServiceContext((org.omg.CORBA_2_3.portable.OutputStream) ostream);
199          }
200  
201          // CORBA formal 00-11-0 15.4.2.2 GIOP 1.2 body must be aligned on an 8 octet boundary. Ensures that the first
202          // write operation called from the stub code, during body construction, would insert a header padding, such that
203          // the body is aligned on an 8-octet boundary.
204          ((CDROutputStream) ostream).setHeaderPadding(true);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/ReplyMessage_1_2.java
      * Line Number: 198
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
188      {
189          super.write(ostream);
190          ostream.write_ulong(this.request_id);
191          ostream.write_long(this.reply_status);
192          if (this.service_contexts != null)
193          {
194              service_contexts.write((org.omg.CORBA_2_3.portable.OutputStream) ostream, GIOPVersion.V1_2);
195          }
196          else
197          {
198              ServiceContexts.writeNullServiceContext((org.omg.CORBA_2_3.portable.OutputStream) ostream);
199          }
200  
201          // CORBA formal 00-11-0 15.4.2.2 GIOP 1.2 body must be aligned on an 8 octet boundary. Ensures that the first
202          // write operation called from the stub code, during body construction, would insert a header padding, such that
203          // the body is aligned on an 8-octet boundary.
204          ((CDROutputStream) ostream).setHeaderPadding(true);
205  
206      }
207  
208      // Static methods
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/ReplyMessage_1_2.java
      * Line Number: 38
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
28  import org.jboss.com.sun.corba.se.impl.encoding.CDRInputStream;
29  import org.jboss.com.sun.corba.se.impl.encoding.CDROutputStream;
30  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
31  import org.jboss.com.sun.corba.se.impl.orbutil.ORBUtility;
32  import org.jboss.com.sun.corba.se.spi.ior.IOR;
33  import org.jboss.com.sun.corba.se.spi.ior.IORFactories;
34  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
35  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
36  import org.jboss.com.sun.corba.se.spi.orb.ORB;
37  import org.jboss.com.sun.corba.se.spi.servicecontext.ServiceContexts;
38  import org.omg.CORBA.CompletionStatus;
39  import org.omg.CORBA.SystemException;
40  
41  /**
42   * This implements the GIOP 1.2 Reply header.
43   * 
44   * @author Ram Jeyaraman 05/14/2000
45   */
46  
47  public final class ReplyMessage_1_2 extends Message_1_2 implements ReplyMessage
48  {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/ReplyMessage_1_2.java
      * Line Number: 39
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
29  import org.jboss.com.sun.corba.se.impl.encoding.CDROutputStream;
30  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
31  import org.jboss.com.sun.corba.se.impl.orbutil.ORBUtility;
32  import org.jboss.com.sun.corba.se.spi.ior.IOR;
33  import org.jboss.com.sun.corba.se.spi.ior.IORFactories;
34  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
35  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
36  import org.jboss.com.sun.corba.se.spi.orb.ORB;
37  import org.jboss.com.sun.corba.se.spi.servicecontext.ServiceContexts;
38  import org.omg.CORBA.CompletionStatus;
39  import org.omg.CORBA.SystemException;
40  
41  /**
42   * This implements the GIOP 1.2 Reply header.
43   * 
44   * @author Ram Jeyaraman 05/14/2000
45   */
46  
47  public final class ReplyMessage_1_2 extends Message_1_2 implements ReplyMessage
48  {
49  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/RequestMessage_1_0.java
      * Line Number: 136
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
126      // Mutators
127  
128      public void setThreadPoolToUse(int poolToUse)
129      {
130          // No-op, must be GIOP Version 1.1 or greater
131          // to support this SUN PROPRIETARY EXTENSION.
132      }
133  
134      // IO methods
135  
136      public void read(org.omg.CORBA.portable.InputStream istream)
137      {
138          super.read(istream);
139          this.service_contexts = new ServiceContexts((org.omg.CORBA_2_3.portable.InputStream) istream);
140          this.request_id = istream.read_ulong();
141          this.response_expected = istream.read_boolean();
142          int _len0 = istream.read_long();
143          this.object_key = new byte[_len0];
144          istream.read_octet_array(this.object_key, 0, _len0);
145          this.operation = istream.read_string();
146          this.requesting_principal = istream.read_Principal();
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/RequestMessage_1_0.java
      * Line Number: 139
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
129      {
130          // No-op, must be GIOP Version 1.1 or greater
131          // to support this SUN PROPRIETARY EXTENSION.
132      }
133  
134      // IO methods
135  
136      public void read(org.omg.CORBA.portable.InputStream istream)
137      {
138          super.read(istream);
139          this.service_contexts = new ServiceContexts((org.omg.CORBA_2_3.portable.InputStream) istream);
140          this.request_id = istream.read_ulong();
141          this.response_expected = istream.read_boolean();
142          int _len0 = istream.read_long();
143          this.object_key = new byte[_len0];
144          istream.read_octet_array(this.object_key, 0, _len0);
145          this.operation = istream.read_string();
146          this.requesting_principal = istream.read_Principal();
147      }
148  
149      public void write(org.omg.CORBA.portable.OutputStream ostream)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/RequestMessage_1_0.java
      * Line Number: 149
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
139          this.service_contexts = new ServiceContexts((org.omg.CORBA_2_3.portable.InputStream) istream);
140          this.request_id = istream.read_ulong();
141          this.response_expected = istream.read_boolean();
142          int _len0 = istream.read_long();
143          this.object_key = new byte[_len0];
144          istream.read_octet_array(this.object_key, 0, _len0);
145          this.operation = istream.read_string();
146          this.requesting_principal = istream.read_Principal();
147      }
148  
149      public void write(org.omg.CORBA.portable.OutputStream ostream)
150      {
151          super.write(ostream);
152          if (this.service_contexts != null)
153          {
154              service_contexts.write((org.omg.CORBA_2_3.portable.OutputStream) ostream, GIOPVersion.V1_0);
155          }
156          else
157          {
158              ServiceContexts.writeNullServiceContext((org.omg.CORBA_2_3.portable.OutputStream) ostream);
159          }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/RequestMessage_1_0.java
      * Line Number: 154
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
144          istream.read_octet_array(this.object_key, 0, _len0);
145          this.operation = istream.read_string();
146          this.requesting_principal = istream.read_Principal();
147      }
148  
149      public void write(org.omg.CORBA.portable.OutputStream ostream)
150      {
151          super.write(ostream);
152          if (this.service_contexts != null)
153          {
154              service_contexts.write((org.omg.CORBA_2_3.portable.OutputStream) ostream, GIOPVersion.V1_0);
155          }
156          else
157          {
158              ServiceContexts.writeNullServiceContext((org.omg.CORBA_2_3.portable.OutputStream) ostream);
159          }
160          ostream.write_ulong(this.request_id);
161          ostream.write_boolean(this.response_expected);
162          nullCheck(this.object_key);
163          ostream.write_long(this.object_key.length);
164          ostream.write_octet_array(this.object_key, 0, this.object_key.length);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/RequestMessage_1_0.java
      * Line Number: 158
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
148  
149      public void write(org.omg.CORBA.portable.OutputStream ostream)
150      {
151          super.write(ostream);
152          if (this.service_contexts != null)
153          {
154              service_contexts.write((org.omg.CORBA_2_3.portable.OutputStream) ostream, GIOPVersion.V1_0);
155          }
156          else
157          {
158              ServiceContexts.writeNullServiceContext((org.omg.CORBA_2_3.portable.OutputStream) ostream);
159          }
160          ostream.write_ulong(this.request_id);
161          ostream.write_boolean(this.response_expected);
162          nullCheck(this.object_key);
163          ostream.write_long(this.object_key.length);
164          ostream.write_octet_array(this.object_key, 0, this.object_key.length);
165          ostream.write_string(this.operation);
166          if (this.requesting_principal != null)
167          {
168              ostream.write_Principal(this.requesting_principal);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/RequestMessage_1_0.java
      * Line Number: 32
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
22   * or visit www.oracle.com if you need additional information or have any
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.protocol.giopmsgheaders;
27  
28  import org.jboss.com.sun.corba.se.spi.ior.ObjectKey;
29  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
30  import org.jboss.com.sun.corba.se.spi.orb.ORB;
31  import org.jboss.com.sun.corba.se.spi.servicecontext.ServiceContexts;
32  import org.omg.CORBA.Principal;
33  
34  /**
35   * This implements the GIOP 1.0 Request header.
36   * 
37   * @author Ram Jeyaraman 05/14/2000
38   */
39  
40  @SuppressWarnings("deprecation")
41  public final class RequestMessage_1_0 extends Message_1_0 implements RequestMessage
42  {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/RequestMessage_1_1.java
      * Line Number: 159
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
11   * This code is distributed in the hope that it will be useful, but WITHOUT
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/RequestMessage_1_1.java
      * Line Number: 136
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
126          return this.operation;
127      }
128  
129      public Principal getPrincipal()
130      {
131          return this.requesting_principal;
132      }
133  
134      // IO methods
135  
136      public void read(org.omg.CORBA.portable.InputStream istream)
137      {
138          super.read(istream);
139          this.service_contexts = new ServiceContexts((org.omg.CORBA_2_3.portable.InputStream) istream);
140          this.request_id = istream.read_ulong();
141          this.response_expected = istream.read_boolean();
142          this.reserved = new byte[3];
143          for (int _o0 = 0; _o0 < (3); ++_o0)
144          {
145              this.reserved[_o0] = istream.read_octet();
146          }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/RequestMessage_1_1.java
      * Line Number: 139
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
129      public Principal getPrincipal()
130      {
131          return this.requesting_principal;
132      }
133  
134      // IO methods
135  
136      public void read(org.omg.CORBA.portable.InputStream istream)
137      {
138          super.read(istream);
139          this.service_contexts = new ServiceContexts((org.omg.CORBA_2_3.portable.InputStream) istream);
140          this.request_id = istream.read_ulong();
141          this.response_expected = istream.read_boolean();
142          this.reserved = new byte[3];
143          for (int _o0 = 0; _o0 < (3); ++_o0)
144          {
145              this.reserved[_o0] = istream.read_octet();
146          }
147          int _len1 = istream.read_long();
148          this.object_key = new byte[_len1];
149          istream.read_octet_array(this.object_key, 0, _len1);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/RequestMessage_1_1.java
      * Line Number: 154
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
144          {
145              this.reserved[_o0] = istream.read_octet();
146          }
147          int _len1 = istream.read_long();
148          this.object_key = new byte[_len1];
149          istream.read_octet_array(this.object_key, 0, _len1);
150          this.operation = istream.read_string();
151          this.requesting_principal = istream.read_Principal();
152      }
153  
154      public void write(org.omg.CORBA.portable.OutputStream ostream)
155      {
156          super.write(ostream);
157          if (this.service_contexts != null)
158          {
159              service_contexts.write((org.omg.CORBA_2_3.portable.OutputStream) ostream, GIOPVersion.V1_1);
160          }
161          else
162          {
163              ServiceContexts.writeNullServiceContext((org.omg.CORBA_2_3.portable.OutputStream) ostream);
164          }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/RequestMessage_1_1.java
      * Line Number: 163
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
153  
154      public void write(org.omg.CORBA.portable.OutputStream ostream)
155      {
156          super.write(ostream);
157          if (this.service_contexts != null)
158          {
159              service_contexts.write((org.omg.CORBA_2_3.portable.OutputStream) ostream, GIOPVersion.V1_1);
160          }
161          else
162          {
163              ServiceContexts.writeNullServiceContext((org.omg.CORBA_2_3.portable.OutputStream) ostream);
164          }
165          ostream.write_ulong(this.request_id);
166          ostream.write_boolean(this.response_expected);
167          nullCheck(this.reserved);
168          if (this.reserved.length != (3))
169          {
170              throw wrapper.badReservedLength(org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);
171          }
172          for (int _i0 = 0; _i0 < (3); ++_i0)
173          {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/RequestMessage_1_1.java
      * Line Number: 170
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
160          }
161          else
162          {
163              ServiceContexts.writeNullServiceContext((org.omg.CORBA_2_3.portable.OutputStream) ostream);
164          }
165          ostream.write_ulong(this.request_id);
166          ostream.write_boolean(this.response_expected);
167          nullCheck(this.reserved);
168          if (this.reserved.length != (3))
169          {
170              throw wrapper.badReservedLength(org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);
171          }
172          for (int _i0 = 0; _i0 < (3); ++_i0)
173          {
174              ostream.write_octet(this.reserved[_i0]);
175          }
176          nullCheck(this.object_key);
177          ostream.write_long(this.object_key.length);
178          ostream.write_octet_array(this.object_key, 0, this.object_key.length);
179          ostream.write_string(this.operation);
180          if (this.requesting_principal != null)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/RequestMessage_1_1.java
      * Line Number: 34
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
24   */
25  
26  package org.jboss.com.sun.corba.se.impl.protocol.giopmsgheaders;
27  
28  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
29  import org.jboss.com.sun.corba.se.spi.ior.ObjectKey;
30  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
31  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
32  import org.jboss.com.sun.corba.se.spi.orb.ORB;
33  import org.jboss.com.sun.corba.se.spi.servicecontext.ServiceContexts;
34  import org.omg.CORBA.Principal;
35  
36  /**
37   * This implements the GIOP 1.1 Request header.
38   * 
39   * @author Ram Jeyaraman 05/14/2000
40   */
41  
42  @SuppressWarnings("deprecation")
43  public final class RequestMessage_1_1 extends Message_1_1 implements RequestMessage
44  {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/RequestMessage_1_2.java
      * Line Number: 145
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
135          return null;
136      }
137  
138      public ServiceContexts getServiceContexts()
139      {
140          return this.service_contexts;
141      }
142  
143      // IO methods
144  
145      public void read(org.omg.CORBA.portable.InputStream istream)
146      {
147          super.read(istream);
148          this.request_id = istream.read_ulong();
149          this.response_flags = istream.read_octet();
150          this.reserved = new byte[3];
151          for (int _o0 = 0; _o0 < (3); ++_o0)
152          {
153              this.reserved[_o0] = istream.read_octet();
154          }
155          this.target = TargetAddressHelper.read(istream);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/RequestMessage_1_2.java
      * Line Number: 158
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
148          this.request_id = istream.read_ulong();
149          this.response_flags = istream.read_octet();
150          this.reserved = new byte[3];
151          for (int _o0 = 0; _o0 < (3); ++_o0)
152          {
153              this.reserved[_o0] = istream.read_octet();
154          }
155          this.target = TargetAddressHelper.read(istream);
156          getObjectKey(); // this does AddressingDisposition check
157          this.operation = istream.read_string();
158          this.service_contexts = new ServiceContexts((org.omg.CORBA_2_3.portable.InputStream) istream);
159  
160          // CORBA formal 00-11-0 15.4.2.2 GIOP 1.2 body must be
161          // aligned on an 8 octet boundary.
162          // Ensures that the first read operation called from the stub code,
163          // during body deconstruction, would skip the header padding, that was
164          // inserted to ensure that the body was aligned on an 8-octet boundary.
165          ((CDRInputStream) istream).setHeaderPadding(true);
166  
167      }
168  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/RequestMessage_1_2.java
      * Line Number: 169
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
159  
160          // CORBA formal 00-11-0 15.4.2.2 GIOP 1.2 body must be
161          // aligned on an 8 octet boundary.
162          // Ensures that the first read operation called from the stub code,
163          // during body deconstruction, would skip the header padding, that was
164          // inserted to ensure that the body was aligned on an 8-octet boundary.
165          ((CDRInputStream) istream).setHeaderPadding(true);
166  
167      }
168  
169      public void write(org.omg.CORBA.portable.OutputStream ostream)
170      {
171          super.write(ostream);
172          ostream.write_ulong(this.request_id);
173          ostream.write_octet(this.response_flags);
174          nullCheck(this.reserved);
175          if (this.reserved.length != (3))
176          {
177              throw wrapper.badReservedLength(org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);
178          }
179          for (int _i0 = 0; _i0 < (3); ++_i0)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/RequestMessage_1_2.java
      * Line Number: 177
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
167      }
168  
169      public void write(org.omg.CORBA.portable.OutputStream ostream)
170      {
171          super.write(ostream);
172          ostream.write_ulong(this.request_id);
173          ostream.write_octet(this.response_flags);
174          nullCheck(this.reserved);
175          if (this.reserved.length != (3))
176          {
177              throw wrapper.badReservedLength(org.omg.CORBA.CompletionStatus.COMPLETED_MAYBE);
178          }
179          for (int _i0 = 0; _i0 < (3); ++_i0)
180          {
181              ostream.write_octet(this.reserved[_i0]);
182          }
183          nullCheck(this.target);
184          TargetAddressHelper.write(ostream, this.target);
185          ostream.write_string(this.operation);
186          if (this.service_contexts != null)
187          {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/RequestMessage_1_2.java
      * Line Number: 188
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
178          }
179          for (int _i0 = 0; _i0 < (3); ++_i0)
180          {
181              ostream.write_octet(this.reserved[_i0]);
182          }
183          nullCheck(this.target);
184          TargetAddressHelper.write(ostream, this.target);
185          ostream.write_string(this.operation);
186          if (this.service_contexts != null)
187          {
188              service_contexts.write((org.omg.CORBA_2_3.portable.OutputStream) ostream, GIOPVersion.V1_2);
189          }
190          else
191          {
192              ServiceContexts.writeNullServiceContext((org.omg.CORBA_2_3.portable.OutputStream) ostream);
193          }
194  
195          // CORBA formal 00-11-0 15.4.2.2 GIOP 1.2 body must be
196          // aligned on an 8 octet boundary.
197          // Ensures that the first write operation called from the stub code,
198          // during body construction, would insert a header padding, such that
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/RequestMessage_1_2.java
      * Line Number: 192
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
182          }
183          nullCheck(this.target);
184          TargetAddressHelper.write(ostream, this.target);
185          ostream.write_string(this.operation);
186          if (this.service_contexts != null)
187          {
188              service_contexts.write((org.omg.CORBA_2_3.portable.OutputStream) ostream, GIOPVersion.V1_2);
189          }
190          else
191          {
192              ServiceContexts.writeNullServiceContext((org.omg.CORBA_2_3.portable.OutputStream) ostream);
193          }
194  
195          // CORBA formal 00-11-0 15.4.2.2 GIOP 1.2 body must be
196          // aligned on an 8 octet boundary.
197          // Ensures that the first write operation called from the stub code,
198          // during body construction, would insert a header padding, such that
199          // the body is aligned on an 8-octet boundary.
200          ((CDROutputStream) ostream).setHeaderPadding(true);
201      }
202  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/RequestMessage_1_2.java
      * Line Number: 36
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
26  package org.jboss.com.sun.corba.se.impl.protocol.giopmsgheaders;
27  
28  import org.jboss.com.sun.corba.se.impl.encoding.CDRInputStream;
29  import org.jboss.com.sun.corba.se.impl.encoding.CDROutputStream;
30  import org.jboss.com.sun.corba.se.impl.logging.ORBUtilSystemException;
31  import org.jboss.com.sun.corba.se.spi.ior.ObjectKey;
32  import org.jboss.com.sun.corba.se.spi.ior.iiop.GIOPVersion;
33  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
34  import org.jboss.com.sun.corba.se.spi.orb.ORB;
35  import org.jboss.com.sun.corba.se.spi.servicecontext.ServiceContexts;
36  import org.omg.CORBA.Principal;
37  
38  /**
39   * This implements the GIOP 1.2 Request header.
40   * 
41   * @author Ram Jeyaraman 05/14/2000
42   */
43  
44  @SuppressWarnings("deprecation")
45  public final class RequestMessage_1_2 extends Message_1_2 implements RequestMessage
46  {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/TargetAddress.java
      * Line Number: 97
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
 87      public void profile(org.omg.IOP.TaggedProfile value)
 88      {
 89          __discriminator = ProfileAddr.value;
 90          ___profile = value;
 91          __uninitialized = false;
 92      }
 93  
 94      private void verifyprofile(short discriminator)
 95      {
 96          if (discriminator != ProfileAddr.value)
 97              throw new org.omg.CORBA.BAD_OPERATION();
 98      }
 99  
100      public IORAddressingInfo ior()
101      {
102          if (__uninitialized)
103              throw new org.omg.CORBA.BAD_OPERATION();
104          verifyior(__discriminator);
105          return ___ior;
106      }
107  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/TargetAddress.java
      * Line Number: 103
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
 93  
 94      private void verifyprofile(short discriminator)
 95      {
 96          if (discriminator != ProfileAddr.value)
 97              throw new org.omg.CORBA.BAD_OPERATION();
 98      }
 99  
100      public IORAddressingInfo ior()
101      {
102          if (__uninitialized)
103              throw new org.omg.CORBA.BAD_OPERATION();
104          verifyior(__discriminator);
105          return ___ior;
106      }
107  
108      public void ior(IORAddressingInfo value)
109      {
110          __discriminator = ReferenceAddr.value;
111          ___ior = value;
112          __uninitialized = false;
113      }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/TargetAddress.java
      * Line Number: 118
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
108      public void ior(IORAddressingInfo value)
109      {
110          __discriminator = ReferenceAddr.value;
111          ___ior = value;
112          __uninitialized = false;
113      }
114  
115      private void verifyior(short discriminator)
116      {
117          if (discriminator != ReferenceAddr.value)
118              throw new org.omg.CORBA.BAD_OPERATION();
119      }
120  
121      public void _default()
122      {
123          __discriminator = -32768;
124          __uninitialized = false;
125      }
126  
127  } // class TargetAddress

```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/TargetAddress.java
      * Line Number: 35
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
25  
26  package org.jboss.com.sun.corba.se.impl.protocol.giopmsgheaders;
27  
28  /**
29   * org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/TargetAddress.java Generated by the IDL-to-Java compiler (portable),
30   * version "3.0" from src/main/resources/idl/org/jboss/com/sun/corba/se/GiopIDL/g.idl Sunday, June 4, 2000 5:18:54
31   * PM PDT
32   */
33  
34  @SuppressWarnings("serial")
35  public final class TargetAddress implements org.omg.CORBA.portable.IDLEntity
36  {
37      private byte[] ___object_key;
38  
39      private org.omg.IOP.TaggedProfile ___profile;
40  
41      private IORAddressingInfo ___ior;
42  
43      private short __discriminator;
44  
45      private boolean __uninitialized = true;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/TargetAddress.java
      * Line Number: 54
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
44  
45      private boolean __uninitialized = true;
46  
47      public TargetAddress()
48      {
49      }
50  
51      public short discriminator()
52      {
53          if (__uninitialized)
54              throw new org.omg.CORBA.BAD_OPERATION();
55          return __discriminator;
56      }
57  
58      public byte[] object_key()
59      {
60          if (__uninitialized)
61              throw new org.omg.CORBA.BAD_OPERATION();
62          verifyobject_key(__discriminator);
63          return ___object_key;
64      }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/TargetAddress.java
      * Line Number: 61
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
51      public short discriminator()
52      {
53          if (__uninitialized)
54              throw new org.omg.CORBA.BAD_OPERATION();
55          return __discriminator;
56      }
57  
58      public byte[] object_key()
59      {
60          if (__uninitialized)
61              throw new org.omg.CORBA.BAD_OPERATION();
62          verifyobject_key(__discriminator);
63          return ___object_key;
64      }
65  
66      public void object_key(byte[] value)
67      {
68          __discriminator = KeyAddr.value;
69          ___object_key = value;
70          __uninitialized = false;
71      }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/TargetAddress.java
      * Line Number: 76
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
66      public void object_key(byte[] value)
67      {
68          __discriminator = KeyAddr.value;
69          ___object_key = value;
70          __uninitialized = false;
71      }
72  
73      private void verifyobject_key(short discriminator)
74      {
75          if (discriminator != KeyAddr.value)
76              throw new org.omg.CORBA.BAD_OPERATION();
77      }
78  
79      public org.omg.IOP.TaggedProfile profile()
80      {
81          if (__uninitialized)
82              throw new org.omg.CORBA.BAD_OPERATION();
83          verifyprofile(__discriminator);
84          return ___profile;
85      }
86  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/TargetAddress.java
      * Line Number: 82
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
72  
73      private void verifyobject_key(short discriminator)
74      {
75          if (discriminator != KeyAddr.value)
76              throw new org.omg.CORBA.BAD_OPERATION();
77      }
78  
79      public org.omg.IOP.TaggedProfile profile()
80      {
81          if (__uninitialized)
82              throw new org.omg.CORBA.BAD_OPERATION();
83          verifyprofile(__discriminator);
84          return ___profile;
85      }
86  
87      public void profile(org.omg.IOP.TaggedProfile value)
88      {
89          __discriminator = ProfileAddr.value;
90          ___profile = value;
91          __uninitialized = false;
92      }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/TargetAddressHelper.java
      * Line Number: 79
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/TargetAddressHelper.java
      * Line Number: 82
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/TargetAddressHelper.java
      * Line Number: 83
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/TargetAddressHelper.java
      * Line Number: 94
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/TargetAddressHelper.java
      * Line Number: 119
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/TargetAddressHelper.java
      * Line Number: 124
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/TargetAddressHelper.java
      * Line Number: 140
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/TargetAddressHelper.java
      * Line Number: 38
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
28  /**
29   * org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/TargetAddressHelper.java Generated by the IDL-to-Java
30   * compiler (portable), version "3.0" from src/main/resources/idl/org/jboss/com/sun/corba/se/GiopIDL/g.idl Sunday, June
31   * 4, 2000 5:18:54 PM PDT
32   */
33  
34  abstract public class TargetAddressHelper
35  {
36      private static String _id = "IDL:messages/TargetAddress:1.0";
37  
38      public static void insert(org.omg.CORBA.Any a, TargetAddress that)
39      {
40          org.omg.CORBA.portable.OutputStream out = a.create_output_stream();
41          a.type(type());
42          write(out, that);
43          a.read_value(out.create_input_stream(), type());
44      }
45  
46      public static TargetAddress extract(org.omg.CORBA.Any a)
47      {
48          return read(a.create_input_stream());
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/TargetAddressHelper.java
      * Line Number: 40
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
30   * compiler (portable), version "3.0" from src/main/resources/idl/org/jboss/com/sun/corba/se/GiopIDL/g.idl Sunday, June
31   * 4, 2000 5:18:54 PM PDT
32   */
33  
34  abstract public class TargetAddressHelper
35  {
36      private static String _id = "IDL:messages/TargetAddress:1.0";
37  
38      public static void insert(org.omg.CORBA.Any a, TargetAddress that)
39      {
40          org.omg.CORBA.portable.OutputStream out = a.create_output_stream();
41          a.type(type());
42          write(out, that);
43          a.read_value(out.create_input_stream(), type());
44      }
45  
46      public static TargetAddress extract(org.omg.CORBA.Any a)
47      {
48          return read(a.create_input_stream());
49      }
50  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/TargetAddressHelper.java
      * Line Number: 46
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
36      private static String _id = "IDL:messages/TargetAddress:1.0";
37  
38      public static void insert(org.omg.CORBA.Any a, TargetAddress that)
39      {
40          org.omg.CORBA.portable.OutputStream out = a.create_output_stream();
41          a.type(type());
42          write(out, that);
43          a.read_value(out.create_input_stream(), type());
44      }
45  
46      public static TargetAddress extract(org.omg.CORBA.Any a)
47      {
48          return read(a.create_input_stream());
49      }
50  
51      private static org.omg.CORBA.TypeCode __typeCode = null;
52  
53      synchronized public static org.omg.CORBA.TypeCode type()
54      {
55          if (__typeCode == null)
56          {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/TargetAddressHelper.java
      * Line Number: 51
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
41          a.type(type());
42          write(out, that);
43          a.read_value(out.create_input_stream(), type());
44      }
45  
46      public static TargetAddress extract(org.omg.CORBA.Any a)
47      {
48          return read(a.create_input_stream());
49      }
50  
51      private static org.omg.CORBA.TypeCode __typeCode = null;
52  
53      synchronized public static org.omg.CORBA.TypeCode type()
54      {
55          if (__typeCode == null)
56          {
57              org.omg.CORBA.TypeCode _disTypeCode0;
58              _disTypeCode0 = org.omg.CORBA.ORB.init().get_primitive_tc(org.omg.CORBA.TCKind.tk_short);
59              _disTypeCode0 = org.omg.CORBA.ORB.init().create_alias_tc(AddressingDispositionHelper.id(),
60                      "AddressingDisposition", _disTypeCode0);
61              org.omg.CORBA.UnionMember[] _members0 = new org.omg.CORBA.UnionMember[3];
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/TargetAddressHelper.java
      * Line Number: 53
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
43          a.read_value(out.create_input_stream(), type());
44      }
45  
46      public static TargetAddress extract(org.omg.CORBA.Any a)
47      {
48          return read(a.create_input_stream());
49      }
50  
51      private static org.omg.CORBA.TypeCode __typeCode = null;
52  
53      synchronized public static org.omg.CORBA.TypeCode type()
54      {
55          if (__typeCode == null)
56          {
57              org.omg.CORBA.TypeCode _disTypeCode0;
58              _disTypeCode0 = org.omg.CORBA.ORB.init().get_primitive_tc(org.omg.CORBA.TCKind.tk_short);
59              _disTypeCode0 = org.omg.CORBA.ORB.init().create_alias_tc(AddressingDispositionHelper.id(),
60                      "AddressingDisposition", _disTypeCode0);
61              org.omg.CORBA.UnionMember[] _members0 = new org.omg.CORBA.UnionMember[3];
62              org.omg.CORBA.TypeCode _tcOf_members0;
63              org.omg.CORBA.Any _anyOf_members0;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/TargetAddressHelper.java
      * Line Number: 57
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
47      {
48          return read(a.create_input_stream());
49      }
50  
51      private static org.omg.CORBA.TypeCode __typeCode = null;
52  
53      synchronized public static org.omg.CORBA.TypeCode type()
54      {
55          if (__typeCode == null)
56          {
57              org.omg.CORBA.TypeCode _disTypeCode0;
58              _disTypeCode0 = org.omg.CORBA.ORB.init().get_primitive_tc(org.omg.CORBA.TCKind.tk_short);
59              _disTypeCode0 = org.omg.CORBA.ORB.init().create_alias_tc(AddressingDispositionHelper.id(),
60                      "AddressingDisposition", _disTypeCode0);
61              org.omg.CORBA.UnionMember[] _members0 = new org.omg.CORBA.UnionMember[3];
62              org.omg.CORBA.TypeCode _tcOf_members0;
63              org.omg.CORBA.Any _anyOf_members0;
64  
65              // Branch for object_key
66              _anyOf_members0 = org.omg.CORBA.ORB.init().create_any();
67              _anyOf_members0.insert_short(KeyAddr.value);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/TargetAddressHelper.java
      * Line Number: 58
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
48          return read(a.create_input_stream());
49      }
50  
51      private static org.omg.CORBA.TypeCode __typeCode = null;
52  
53      synchronized public static org.omg.CORBA.TypeCode type()
54      {
55          if (__typeCode == null)
56          {
57              org.omg.CORBA.TypeCode _disTypeCode0;
58              _disTypeCode0 = org.omg.CORBA.ORB.init().get_primitive_tc(org.omg.CORBA.TCKind.tk_short);
59              _disTypeCode0 = org.omg.CORBA.ORB.init().create_alias_tc(AddressingDispositionHelper.id(),
60                      "AddressingDisposition", _disTypeCode0);
61              org.omg.CORBA.UnionMember[] _members0 = new org.omg.CORBA.UnionMember[3];
62              org.omg.CORBA.TypeCode _tcOf_members0;
63              org.omg.CORBA.Any _anyOf_members0;
64  
65              // Branch for object_key
66              _anyOf_members0 = org.omg.CORBA.ORB.init().create_any();
67              _anyOf_members0.insert_short(KeyAddr.value);
68              _tcOf_members0 = org.omg.CORBA.ORB.init().get_primitive_tc(org.omg.CORBA.TCKind.tk_octet);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/TargetAddressHelper.java
      * Line Number: 59
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
49      }
50  
51      private static org.omg.CORBA.TypeCode __typeCode = null;
52  
53      synchronized public static org.omg.CORBA.TypeCode type()
54      {
55          if (__typeCode == null)
56          {
57              org.omg.CORBA.TypeCode _disTypeCode0;
58              _disTypeCode0 = org.omg.CORBA.ORB.init().get_primitive_tc(org.omg.CORBA.TCKind.tk_short);
59              _disTypeCode0 = org.omg.CORBA.ORB.init().create_alias_tc(AddressingDispositionHelper.id(),
60                      "AddressingDisposition", _disTypeCode0);
61              org.omg.CORBA.UnionMember[] _members0 = new org.omg.CORBA.UnionMember[3];
62              org.omg.CORBA.TypeCode _tcOf_members0;
63              org.omg.CORBA.Any _anyOf_members0;
64  
65              // Branch for object_key
66              _anyOf_members0 = org.omg.CORBA.ORB.init().create_any();
67              _anyOf_members0.insert_short(KeyAddr.value);
68              _tcOf_members0 = org.omg.CORBA.ORB.init().get_primitive_tc(org.omg.CORBA.TCKind.tk_octet);
69              _tcOf_members0 = org.omg.CORBA.ORB.init().create_sequence_tc(0, _tcOf_members0);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/TargetAddressHelper.java
      * Line Number: 61
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
51      private static org.omg.CORBA.TypeCode __typeCode = null;
52  
53      synchronized public static org.omg.CORBA.TypeCode type()
54      {
55          if (__typeCode == null)
56          {
57              org.omg.CORBA.TypeCode _disTypeCode0;
58              _disTypeCode0 = org.omg.CORBA.ORB.init().get_primitive_tc(org.omg.CORBA.TCKind.tk_short);
59              _disTypeCode0 = org.omg.CORBA.ORB.init().create_alias_tc(AddressingDispositionHelper.id(),
60                      "AddressingDisposition", _disTypeCode0);
61              org.omg.CORBA.UnionMember[] _members0 = new org.omg.CORBA.UnionMember[3];
62              org.omg.CORBA.TypeCode _tcOf_members0;
63              org.omg.CORBA.Any _anyOf_members0;
64  
65              // Branch for object_key
66              _anyOf_members0 = org.omg.CORBA.ORB.init().create_any();
67              _anyOf_members0.insert_short(KeyAddr.value);
68              _tcOf_members0 = org.omg.CORBA.ORB.init().get_primitive_tc(org.omg.CORBA.TCKind.tk_octet);
69              _tcOf_members0 = org.omg.CORBA.ORB.init().create_sequence_tc(0, _tcOf_members0);
70              _members0[0] = new org.omg.CORBA.UnionMember("object_key", _anyOf_members0, _tcOf_members0, null);
71  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/TargetAddressHelper.java
      * Line Number: 62
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
52  
53      synchronized public static org.omg.CORBA.TypeCode type()
54      {
55          if (__typeCode == null)
56          {
57              org.omg.CORBA.TypeCode _disTypeCode0;
58              _disTypeCode0 = org.omg.CORBA.ORB.init().get_primitive_tc(org.omg.CORBA.TCKind.tk_short);
59              _disTypeCode0 = org.omg.CORBA.ORB.init().create_alias_tc(AddressingDispositionHelper.id(),
60                      "AddressingDisposition", _disTypeCode0);
61              org.omg.CORBA.UnionMember[] _members0 = new org.omg.CORBA.UnionMember[3];
62              org.omg.CORBA.TypeCode _tcOf_members0;
63              org.omg.CORBA.Any _anyOf_members0;
64  
65              // Branch for object_key
66              _anyOf_members0 = org.omg.CORBA.ORB.init().create_any();
67              _anyOf_members0.insert_short(KeyAddr.value);
68              _tcOf_members0 = org.omg.CORBA.ORB.init().get_primitive_tc(org.omg.CORBA.TCKind.tk_octet);
69              _tcOf_members0 = org.omg.CORBA.ORB.init().create_sequence_tc(0, _tcOf_members0);
70              _members0[0] = new org.omg.CORBA.UnionMember("object_key", _anyOf_members0, _tcOf_members0, null);
71  
72              // Branch for profile
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/TargetAddressHelper.java
      * Line Number: 63
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
53      synchronized public static org.omg.CORBA.TypeCode type()
54      {
55          if (__typeCode == null)
56          {
57              org.omg.CORBA.TypeCode _disTypeCode0;
58              _disTypeCode0 = org.omg.CORBA.ORB.init().get_primitive_tc(org.omg.CORBA.TCKind.tk_short);
59              _disTypeCode0 = org.omg.CORBA.ORB.init().create_alias_tc(AddressingDispositionHelper.id(),
60                      "AddressingDisposition", _disTypeCode0);
61              org.omg.CORBA.UnionMember[] _members0 = new org.omg.CORBA.UnionMember[3];
62              org.omg.CORBA.TypeCode _tcOf_members0;
63              org.omg.CORBA.Any _anyOf_members0;
64  
65              // Branch for object_key
66              _anyOf_members0 = org.omg.CORBA.ORB.init().create_any();
67              _anyOf_members0.insert_short(KeyAddr.value);
68              _tcOf_members0 = org.omg.CORBA.ORB.init().get_primitive_tc(org.omg.CORBA.TCKind.tk_octet);
69              _tcOf_members0 = org.omg.CORBA.ORB.init().create_sequence_tc(0, _tcOf_members0);
70              _members0[0] = new org.omg.CORBA.UnionMember("object_key", _anyOf_members0, _tcOf_members0, null);
71  
72              // Branch for profile
73              _anyOf_members0 = org.omg.CORBA.ORB.init().create_any();
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/TargetAddressHelper.java
      * Line Number: 66
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
56          {
57              org.omg.CORBA.TypeCode _disTypeCode0;
58              _disTypeCode0 = org.omg.CORBA.ORB.init().get_primitive_tc(org.omg.CORBA.TCKind.tk_short);
59              _disTypeCode0 = org.omg.CORBA.ORB.init().create_alias_tc(AddressingDispositionHelper.id(),
60                      "AddressingDisposition", _disTypeCode0);
61              org.omg.CORBA.UnionMember[] _members0 = new org.omg.CORBA.UnionMember[3];
62              org.omg.CORBA.TypeCode _tcOf_members0;
63              org.omg.CORBA.Any _anyOf_members0;
64  
65              // Branch for object_key
66              _anyOf_members0 = org.omg.CORBA.ORB.init().create_any();
67              _anyOf_members0.insert_short(KeyAddr.value);
68              _tcOf_members0 = org.omg.CORBA.ORB.init().get_primitive_tc(org.omg.CORBA.TCKind.tk_octet);
69              _tcOf_members0 = org.omg.CORBA.ORB.init().create_sequence_tc(0, _tcOf_members0);
70              _members0[0] = new org.omg.CORBA.UnionMember("object_key", _anyOf_members0, _tcOf_members0, null);
71  
72              // Branch for profile
73              _anyOf_members0 = org.omg.CORBA.ORB.init().create_any();
74              _anyOf_members0.insert_short(ProfileAddr.value);
75              _tcOf_members0 = org.omg.IOP.TaggedProfileHelper.type();
76              _members0[1] = new org.omg.CORBA.UnionMember("profile", _anyOf_members0, _tcOf_members0, null);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/TargetAddressHelper.java
      * Line Number: 68
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
58              _disTypeCode0 = org.omg.CORBA.ORB.init().get_primitive_tc(org.omg.CORBA.TCKind.tk_short);
59              _disTypeCode0 = org.omg.CORBA.ORB.init().create_alias_tc(AddressingDispositionHelper.id(),
60                      "AddressingDisposition", _disTypeCode0);
61              org.omg.CORBA.UnionMember[] _members0 = new org.omg.CORBA.UnionMember[3];
62              org.omg.CORBA.TypeCode _tcOf_members0;
63              org.omg.CORBA.Any _anyOf_members0;
64  
65              // Branch for object_key
66              _anyOf_members0 = org.omg.CORBA.ORB.init().create_any();
67              _anyOf_members0.insert_short(KeyAddr.value);
68              _tcOf_members0 = org.omg.CORBA.ORB.init().get_primitive_tc(org.omg.CORBA.TCKind.tk_octet);
69              _tcOf_members0 = org.omg.CORBA.ORB.init().create_sequence_tc(0, _tcOf_members0);
70              _members0[0] = new org.omg.CORBA.UnionMember("object_key", _anyOf_members0, _tcOf_members0, null);
71  
72              // Branch for profile
73              _anyOf_members0 = org.omg.CORBA.ORB.init().create_any();
74              _anyOf_members0.insert_short(ProfileAddr.value);
75              _tcOf_members0 = org.omg.IOP.TaggedProfileHelper.type();
76              _members0[1] = new org.omg.CORBA.UnionMember("profile", _anyOf_members0, _tcOf_members0, null);
77  
78              // Branch for ior
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/TargetAddressHelper.java
      * Line Number: 69
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
59              _disTypeCode0 = org.omg.CORBA.ORB.init().create_alias_tc(AddressingDispositionHelper.id(),
60                      "AddressingDisposition", _disTypeCode0);
61              org.omg.CORBA.UnionMember[] _members0 = new org.omg.CORBA.UnionMember[3];
62              org.omg.CORBA.TypeCode _tcOf_members0;
63              org.omg.CORBA.Any _anyOf_members0;
64  
65              // Branch for object_key
66              _anyOf_members0 = org.omg.CORBA.ORB.init().create_any();
67              _anyOf_members0.insert_short(KeyAddr.value);
68              _tcOf_members0 = org.omg.CORBA.ORB.init().get_primitive_tc(org.omg.CORBA.TCKind.tk_octet);
69              _tcOf_members0 = org.omg.CORBA.ORB.init().create_sequence_tc(0, _tcOf_members0);
70              _members0[0] = new org.omg.CORBA.UnionMember("object_key", _anyOf_members0, _tcOf_members0, null);
71  
72              // Branch for profile
73              _anyOf_members0 = org.omg.CORBA.ORB.init().create_any();
74              _anyOf_members0.insert_short(ProfileAddr.value);
75              _tcOf_members0 = org.omg.IOP.TaggedProfileHelper.type();
76              _members0[1] = new org.omg.CORBA.UnionMember("profile", _anyOf_members0, _tcOf_members0, null);
77  
78              // Branch for ior
79              _anyOf_members0 = org.omg.CORBA.ORB.init().create_any();
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/TargetAddressHelper.java
      * Line Number: 70
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
60                      "AddressingDisposition", _disTypeCode0);
61              org.omg.CORBA.UnionMember[] _members0 = new org.omg.CORBA.UnionMember[3];
62              org.omg.CORBA.TypeCode _tcOf_members0;
63              org.omg.CORBA.Any _anyOf_members0;
64  
65              // Branch for object_key
66              _anyOf_members0 = org.omg.CORBA.ORB.init().create_any();
67              _anyOf_members0.insert_short(KeyAddr.value);
68              _tcOf_members0 = org.omg.CORBA.ORB.init().get_primitive_tc(org.omg.CORBA.TCKind.tk_octet);
69              _tcOf_members0 = org.omg.CORBA.ORB.init().create_sequence_tc(0, _tcOf_members0);
70              _members0[0] = new org.omg.CORBA.UnionMember("object_key", _anyOf_members0, _tcOf_members0, null);
71  
72              // Branch for profile
73              _anyOf_members0 = org.omg.CORBA.ORB.init().create_any();
74              _anyOf_members0.insert_short(ProfileAddr.value);
75              _tcOf_members0 = org.omg.IOP.TaggedProfileHelper.type();
76              _members0[1] = new org.omg.CORBA.UnionMember("profile", _anyOf_members0, _tcOf_members0, null);
77  
78              // Branch for ior
79              _anyOf_members0 = org.omg.CORBA.ORB.init().create_any();
80              _anyOf_members0.insert_short(ReferenceAddr.value);
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/TargetAddressHelper.java
      * Line Number: 73
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
63              org.omg.CORBA.Any _anyOf_members0;
64  
65              // Branch for object_key
66              _anyOf_members0 = org.omg.CORBA.ORB.init().create_any();
67              _anyOf_members0.insert_short(KeyAddr.value);
68              _tcOf_members0 = org.omg.CORBA.ORB.init().get_primitive_tc(org.omg.CORBA.TCKind.tk_octet);
69              _tcOf_members0 = org.omg.CORBA.ORB.init().create_sequence_tc(0, _tcOf_members0);
70              _members0[0] = new org.omg.CORBA.UnionMember("object_key", _anyOf_members0, _tcOf_members0, null);
71  
72              // Branch for profile
73              _anyOf_members0 = org.omg.CORBA.ORB.init().create_any();
74              _anyOf_members0.insert_short(ProfileAddr.value);
75              _tcOf_members0 = org.omg.IOP.TaggedProfileHelper.type();
76              _members0[1] = new org.omg.CORBA.UnionMember("profile", _anyOf_members0, _tcOf_members0, null);
77  
78              // Branch for ior
79              _anyOf_members0 = org.omg.CORBA.ORB.init().create_any();
80              _anyOf_members0.insert_short(ReferenceAddr.value);
81              _tcOf_members0 = IORAddressingInfoHelper.type();
82              _members0[2] = new org.omg.CORBA.UnionMember("ior", _anyOf_members0, _tcOf_members0, null);
83              __typeCode = org.omg.CORBA.ORB.init().create_union_tc(TargetAddressHelper.id(), "TargetAddress",
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/protocol/giopmsgheaders/TargetAddressHelper.java
      * Line Number: 76
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
66              _anyOf_members0 = org.omg.CORBA.ORB.init().create_any();
67              _anyOf_members0.insert_short(KeyAddr.value);
68              _tcOf_members0 = org.omg.CORBA.ORB.init().get_primitive_tc(org.omg.CORBA.TCKind.tk_octet);
69              _tcOf_members0 = org.omg.CORBA.ORB.init().create_sequence_tc(0, _tcOf_members0);
70              _members0[0] = new org.omg.CORBA.UnionMember("object_key", _anyOf_members0, _tcOf_members0, null);
71  
72              // Branch for profile
73              _anyOf_members0 = org.omg.CORBA.ORB.init().create_any();
74              _anyOf_members0.insert_short(ProfileAddr.value);
75              _tcOf_members0 = org.omg.IOP.TaggedProfileHelper.type();
76              _members0[1] = new org.omg.CORBA.UnionMember("profile", _anyOf_members0, _tcOf_members0, null);
77  
78              // Branch for ior
79              _anyOf_members0 = org.omg.CORBA.ORB.init().create_any();
80              _anyOf_members0.insert_short(ReferenceAddr.value);
81              _tcOf_members0 = IORAddressingInfoHelper.type();
82              _members0[2] = new org.omg.CORBA.UnionMember("ior", _anyOf_members0, _tcOf_members0, null);
83              __typeCode = org.omg.CORBA.ORB.init().create_union_tc(TargetAddressHelper.id(), "TargetAddress",
84                      _disTypeCode0, _members0);
85          }
86          return __typeCode;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/util/RepositoryId.java
      * Line Number: 329
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
319              (byte) '6', (byte) '7', (byte) '8', (byte) '9', (byte) 'A', (byte) 'B', (byte) 'C', (byte) 'D', (byte) 'E',
320              (byte) 'F',};
321  
322      // bug fix for 4328952; to eliminate possibility of overriding this
323      // in a subclass.
324      public static final RepositoryIdCache cache = new RepositoryIdCache();
325  
326      // Interface Rep ID Strings
327      public static final String kjava_rmi_Remote = createForAnyType(java.rmi.Remote.class);
328  
329      public static final String korg_omg_CORBA_Object = createForAnyType(org.omg.CORBA.Object.class);
330  
331      // Dummy arguments for getIdFromHelper method
332      public static final Class<?> kNoParamTypes[] = {};
333  
334      public static final Object kNoArgs[] = {};
335  
336      // To create a RepositoryID, use code similar to the following: RepositoryId.cache.getId( id );
337  
338      RepositoryId()
339      {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/util/RepositoryId.java
      * Line Number: 42
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
32  package org.jboss.com.sun.corba.se.impl.util;
33  
34  import java.io.IOException;
35  import java.lang.reflect.Method;
36  import java.net.MalformedURLException;
37  import java.util.Hashtable;
38  
39  import javax.rmi.CORBA.Util;
40  
41  import org.jboss.com.sun.corba.se.impl.io.ObjectStreamClass;
42  import org.omg.CORBA.portable.IDLEntity;
43  import org.omg.CORBA.portable.ValueBase;
44  
45  public class RepositoryId
46  {
47  
48      // Legal IDL Identifier characters (1 = legal). Note that '.' (2E) is marked as legal even though it is not legal in
49      // IDL. This allows us to treat a fully qualified Java name with '.' package separators uniformly, and is safe
50      // because that is the only legal use of '.' in a Java name.
51  
52      public static final byte[] IDL_IDENTIFIER_CHARS = {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/util/RepositoryId.java
      * Line Number: 43
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
33  
34  import java.io.IOException;
35  import java.lang.reflect.Method;
36  import java.net.MalformedURLException;
37  import java.util.Hashtable;
38  
39  import javax.rmi.CORBA.Util;
40  
41  import org.jboss.com.sun.corba.se.impl.io.ObjectStreamClass;
42  import org.omg.CORBA.portable.IDLEntity;
43  import org.omg.CORBA.portable.ValueBase;
44  
45  public class RepositoryId
46  {
47  
48      // Legal IDL Identifier characters (1 = legal). Note that '.' (2E) is marked as legal even though it is not legal in
49      // IDL. This allows us to treat a fully qualified Java name with '.' package separators uniformly, and is safe
50      // because that is the only legal use of '.' in a Java name.
51  
52      public static final byte[] IDL_IDENTIFIER_CHARS = {
53  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/util/RepositoryId.java
      * Line Number: 915
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
905      {
906          try
907          {
908              Class<?> helperClazz = Utility.loadClassForClass(clazz.getName() + "Helper", null, clazz.getClassLoader(),
909                      clazz, clazz.getClassLoader());
910              Method idMethod = helperClazz.getDeclaredMethod("id", kNoParamTypes);
911              return (String) idMethod.invoke(null, kNoArgs);
912          }
913          catch (java.lang.ClassNotFoundException cnfe)
914          {
915              throw new org.omg.CORBA.MARSHAL(cnfe.toString());
916          }
917          catch (java.lang.NoSuchMethodException nsme)
918          {
919              throw new org.omg.CORBA.MARSHAL(nsme.toString());
920          }
921          catch (java.lang.reflect.InvocationTargetException ite)
922          {
923              throw new org.omg.CORBA.MARSHAL(ite.toString());
924          }
925          catch (java.lang.IllegalAccessException iae)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/util/RepositoryId.java
      * Line Number: 919
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
909                      clazz, clazz.getClassLoader());
910              Method idMethod = helperClazz.getDeclaredMethod("id", kNoParamTypes);
911              return (String) idMethod.invoke(null, kNoArgs);
912          }
913          catch (java.lang.ClassNotFoundException cnfe)
914          {
915              throw new org.omg.CORBA.MARSHAL(cnfe.toString());
916          }
917          catch (java.lang.NoSuchMethodException nsme)
918          {
919              throw new org.omg.CORBA.MARSHAL(nsme.toString());
920          }
921          catch (java.lang.reflect.InvocationTargetException ite)
922          {
923              throw new org.omg.CORBA.MARSHAL(ite.toString());
924          }
925          catch (java.lang.IllegalAccessException iae)
926          {
927              throw new org.omg.CORBA.MARSHAL(iae.toString());
928          }
929      }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/util/RepositoryId.java
      * Line Number: 923
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
913          catch (java.lang.ClassNotFoundException cnfe)
914          {
915              throw new org.omg.CORBA.MARSHAL(cnfe.toString());
916          }
917          catch (java.lang.NoSuchMethodException nsme)
918          {
919              throw new org.omg.CORBA.MARSHAL(nsme.toString());
920          }
921          catch (java.lang.reflect.InvocationTargetException ite)
922          {
923              throw new org.omg.CORBA.MARSHAL(ite.toString());
924          }
925          catch (java.lang.IllegalAccessException iae)
926          {
927              throw new org.omg.CORBA.MARSHAL(iae.toString());
928          }
929      }
930  
931      /**
932       * Createa a repository ID for the type if it is either a java type or an IDL type.
933       * 
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/util/RepositoryId.java
      * Line Number: 927
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
917          catch (java.lang.NoSuchMethodException nsme)
918          {
919              throw new org.omg.CORBA.MARSHAL(nsme.toString());
920          }
921          catch (java.lang.reflect.InvocationTargetException ite)
922          {
923              throw new org.omg.CORBA.MARSHAL(ite.toString());
924          }
925          catch (java.lang.IllegalAccessException iae)
926          {
927              throw new org.omg.CORBA.MARSHAL(iae.toString());
928          }
929      }
930  
931      /**
932       * Createa a repository ID for the type if it is either a java type or an IDL type.
933       * 
934       * @param type
935       *            The type to create rep. id for
936       * @return The rep. id.
937       **/
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/util/RepositoryId.java
      * Line Number: 968
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
958          catch (org.jboss.com.sun.corba.se.impl.io.TypeMismatchException e)
959          {
960              return null;
961          }
962  
963      }
964  
965      public static boolean isAbstractBase(Class<?> clazz)
966      {
967          return (clazz.isInterface() && IDLEntity.class.isAssignableFrom(clazz)
968                  && (!ValueBase.class.isAssignableFrom(clazz)) && (!org.omg.CORBA.Object.class.isAssignableFrom(clazz)));
969  
970      }
971  
972      public static boolean isAnyRequired(Class<?> clazz)
973      {
974          return ((clazz == java.lang.Object.class) || (clazz == java.io.Serializable.class) || (clazz == java.io.Externalizable.class));
975      }
976  
977      public static long fromHex(String hexNumber)
978      {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/util/StubEntry.java
      * Line Number: 1050
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/util/StubEntry.java
      * Line Number: 1054
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/util/Utility.java
      * Line Number: 1015
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
1005      }
1006  
1007      /**
1008       * Read an abstract interface type from the input stream and narrow it to the desired type.
1009       * 
1010       * @param in
1011       *            the stream to read from.
1012       * @throws ClassCastException
1013       *             if narrowFrom cannot be cast to narrowTo.
1014       */
1015      public static Object readAbstractAndNarrow(org.omg.CORBA_2_3.portable.InputStream in, Class<?> narrowTo)
1016              throws ClassCastException
1017      {
1018          Object result = in.read_abstract_interface();
1019          if (result != null)
1020              return PortableRemoteObject.narrow(result, narrowTo);
1021          else
1022              return null;
1023      }
1024  
1025      /**
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/util/Utility.java
      * Line Number: 48
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
38  
39  import javax.rmi.PortableRemoteObject;
40  import javax.rmi.CORBA.Tie;
41  import javax.rmi.CORBA.Util;
42  
43  import org.jboss.com.sun.corba.se.impl.logging.OMGSystemException;
44  import org.jboss.com.sun.corba.se.impl.logging.UtilSystemException;
45  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
46  import org.jboss.com.sun.corba.se.spi.presentation.rmi.PresentationManager;
47  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
48  import org.omg.CORBA.BAD_OPERATION;
49  import org.omg.CORBA.CompletionStatus;
50  import org.omg.CORBA.ORB;
51  import org.omg.CORBA.SystemException;
52  import org.omg.CORBA.portable.BoxedValueHelper;
53  import org.omg.CORBA.portable.Delegate;
54  import org.omg.CORBA.portable.InputStream;
55  import org.omg.CORBA.portable.ValueFactory;
56  
57  /**
58   * Handy class full of static functions.
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/util/Utility.java
      * Line Number: 49
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
39  import javax.rmi.PortableRemoteObject;
40  import javax.rmi.CORBA.Tie;
41  import javax.rmi.CORBA.Util;
42  
43  import org.jboss.com.sun.corba.se.impl.logging.OMGSystemException;
44  import org.jboss.com.sun.corba.se.impl.logging.UtilSystemException;
45  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
46  import org.jboss.com.sun.corba.se.spi.presentation.rmi.PresentationManager;
47  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
48  import org.omg.CORBA.BAD_OPERATION;
49  import org.omg.CORBA.CompletionStatus;
50  import org.omg.CORBA.ORB;
51  import org.omg.CORBA.SystemException;
52  import org.omg.CORBA.portable.BoxedValueHelper;
53  import org.omg.CORBA.portable.Delegate;
54  import org.omg.CORBA.portable.InputStream;
55  import org.omg.CORBA.portable.ValueFactory;
56  
57  /**
58   * Handy class full of static functions.
59   */
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/util/Utility.java
      * Line Number: 50
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
40  import javax.rmi.CORBA.Tie;
41  import javax.rmi.CORBA.Util;
42  
43  import org.jboss.com.sun.corba.se.impl.logging.OMGSystemException;
44  import org.jboss.com.sun.corba.se.impl.logging.UtilSystemException;
45  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
46  import org.jboss.com.sun.corba.se.spi.presentation.rmi.PresentationManager;
47  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
48  import org.omg.CORBA.BAD_OPERATION;
49  import org.omg.CORBA.CompletionStatus;
50  import org.omg.CORBA.ORB;
51  import org.omg.CORBA.SystemException;
52  import org.omg.CORBA.portable.BoxedValueHelper;
53  import org.omg.CORBA.portable.Delegate;
54  import org.omg.CORBA.portable.InputStream;
55  import org.omg.CORBA.portable.ValueFactory;
56  
57  /**
58   * Handy class full of static functions.
59   */
60  public final class Utility
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/util/Utility.java
      * Line Number: 51
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
41  import javax.rmi.CORBA.Util;
42  
43  import org.jboss.com.sun.corba.se.impl.logging.OMGSystemException;
44  import org.jboss.com.sun.corba.se.impl.logging.UtilSystemException;
45  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
46  import org.jboss.com.sun.corba.se.spi.presentation.rmi.PresentationManager;
47  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
48  import org.omg.CORBA.BAD_OPERATION;
49  import org.omg.CORBA.CompletionStatus;
50  import org.omg.CORBA.ORB;
51  import org.omg.CORBA.SystemException;
52  import org.omg.CORBA.portable.BoxedValueHelper;
53  import org.omg.CORBA.portable.Delegate;
54  import org.omg.CORBA.portable.InputStream;
55  import org.omg.CORBA.portable.ValueFactory;
56  
57  /**
58   * Handy class full of static functions.
59   */
60  public final class Utility
61  {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/util/Utility.java
      * Line Number: 52
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
42  
43  import org.jboss.com.sun.corba.se.impl.logging.OMGSystemException;
44  import org.jboss.com.sun.corba.se.impl.logging.UtilSystemException;
45  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
46  import org.jboss.com.sun.corba.se.spi.presentation.rmi.PresentationManager;
47  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
48  import org.omg.CORBA.BAD_OPERATION;
49  import org.omg.CORBA.CompletionStatus;
50  import org.omg.CORBA.ORB;
51  import org.omg.CORBA.SystemException;
52  import org.omg.CORBA.portable.BoxedValueHelper;
53  import org.omg.CORBA.portable.Delegate;
54  import org.omg.CORBA.portable.InputStream;
55  import org.omg.CORBA.portable.ValueFactory;
56  
57  /**
58   * Handy class full of static functions.
59   */
60  public final class Utility
61  {
62  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/util/Utility.java
      * Line Number: 53
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
43  import org.jboss.com.sun.corba.se.impl.logging.OMGSystemException;
44  import org.jboss.com.sun.corba.se.impl.logging.UtilSystemException;
45  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
46  import org.jboss.com.sun.corba.se.spi.presentation.rmi.PresentationManager;
47  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
48  import org.omg.CORBA.BAD_OPERATION;
49  import org.omg.CORBA.CompletionStatus;
50  import org.omg.CORBA.ORB;
51  import org.omg.CORBA.SystemException;
52  import org.omg.CORBA.portable.BoxedValueHelper;
53  import org.omg.CORBA.portable.Delegate;
54  import org.omg.CORBA.portable.InputStream;
55  import org.omg.CORBA.portable.ValueFactory;
56  
57  /**
58   * Handy class full of static functions.
59   */
60  public final class Utility
61  {
62  
63      public static final String STUB_PREFIX = "_";
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/util/Utility.java
      * Line Number: 54
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
44  import org.jboss.com.sun.corba.se.impl.logging.UtilSystemException;
45  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
46  import org.jboss.com.sun.corba.se.spi.presentation.rmi.PresentationManager;
47  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
48  import org.omg.CORBA.BAD_OPERATION;
49  import org.omg.CORBA.CompletionStatus;
50  import org.omg.CORBA.ORB;
51  import org.omg.CORBA.SystemException;
52  import org.omg.CORBA.portable.BoxedValueHelper;
53  import org.omg.CORBA.portable.Delegate;
54  import org.omg.CORBA.portable.InputStream;
55  import org.omg.CORBA.portable.ValueFactory;
56  
57  /**
58   * Handy class full of static functions.
59   */
60  public final class Utility
61  {
62  
63      public static final String STUB_PREFIX = "_";
64  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/util/Utility.java
      * Line Number: 452
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
442       * 
443       * Throws MARSHAL exception if no factory found.
444       */
445      public static ValueFactory getFactory(Class<?> clazz, String codebase, ORB orb, String repId)
446      {
447          ValueFactory factory = null;
448          if ((orb != null) && (repId != null))
449          {
450              try
451              {
452                  factory = ((org.omg.CORBA_2_3.ORB) orb).lookup_value_factory(repId);
453              }
454              catch (org.omg.CORBA.BAD_PARAM ex)
455              {
456                  // Try other way
457              }
458          }
459  
460          String className = null;
461          if (clazz != null)
462          {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/util/Utility.java
      * Line Number: 454
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
444       */
445      public static ValueFactory getFactory(Class<?> clazz, String codebase, ORB orb, String repId)
446      {
447          ValueFactory factory = null;
448          if ((orb != null) && (repId != null))
449          {
450              try
451              {
452                  factory = ((org.omg.CORBA_2_3.ORB) orb).lookup_value_factory(repId);
453              }
454              catch (org.omg.CORBA.BAD_PARAM ex)
455              {
456                  // Try other way
457              }
458          }
459  
460          String className = null;
461          if (clazz != null)
462          {
463              className = clazz.getName();
464              if (codebase == null)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/util/Utility.java
      * Line Number: 55
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
45  import org.jboss.com.sun.corba.se.spi.logging.CORBALogDomains;
46  import org.jboss.com.sun.corba.se.spi.presentation.rmi.PresentationManager;
47  import org.jboss.com.sun.corba.se.spi.presentation.rmi.StubAdapter;
48  import org.omg.CORBA.BAD_OPERATION;
49  import org.omg.CORBA.CompletionStatus;
50  import org.omg.CORBA.ORB;
51  import org.omg.CORBA.SystemException;
52  import org.omg.CORBA.portable.BoxedValueHelper;
53  import org.omg.CORBA.portable.Delegate;
54  import org.omg.CORBA.portable.InputStream;
55  import org.omg.CORBA.portable.ValueFactory;
56  
57  /**
58   * Handy class full of static functions.
59   */
60  public final class Utility
61  {
62  
63      public static final String STUB_PREFIX = "_";
64  
65      public static final String RMI_STUB_SUFFIX = "_Stub";
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/util/Utility.java
      * Line Number: 619
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
609       * @param remoteCodebase the codebase to use. May be null.
610       * 
611       * @param onlyMostDerived if true, will fail if cannot load a stub for the first repID in the tie. If false, will
612       * walk all repIDs.
613       * 
614       * @return the StubEntry or null if not found.
615       */
616      private static StubEntry loadStubAndUpdateCache(Tie tie, PresentationManager.StubFactory stubFactory,
617              String remoteCodebase, boolean onlyMostDerived)
618      {
619          org.omg.CORBA.Object stub = null;
620          StubEntry entry = null;
621          boolean tieIsStub = StubAdapter.isStub(tie);
622  
623          if (stubFactory != null)
624          {
625              try
626              {
627                  stub = stubFactory.makeStub();
628              }
629              catch (Throwable e)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/util/Utility.java
      * Line Number: 726
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
716                  }
717              }
718              else
719              {
720                  // Tie extends Servant
721                  try
722                  {
723                      Delegate delegate = StubAdapter.getDelegate(tie);
724                      StubAdapter.setDelegate(stub, delegate);
725                  }
726                  catch (org.omg.CORBA.BAD_INV_ORDER bad)
727                  {
728                      synchronized (stubToTieCache)
729                      {
730                          stubToTieCache.put(stub, tie);
731                      }
732                  }
733                  catch (Exception e)
734                  {
735                      // Exception is caught because of any of the
736                      // following reasons
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/util/Utility.java
      * Line Number: 754
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
744              entry = new StubEntry(stub, onlyMostDerived);
745              tieToStubCache.put(tie, entry);
746          }
747  
748          return entry;
749      }
750  
751      /*
752       * If we loadStub(Tie,...) stashed away a tie which was not connected, remove it from the cache and return it.
753       */
754      public static Tie getAndForgetTie(org.omg.CORBA.Object stub)
755      {
756          synchronized (stubToTieCache)
757          {
758              return (Tie) stubToTieCache.remove(stub);
759          }
760      }
761  
762      /*
763       * Remove any cached Stub for the given tie.
764       */
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/util/Utility.java
      * Line Number: 819
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
809          else
810          {
811              className = stubName(className);
812          }
813          return className;
814      }
815  
816      /*
817       * Load an RMI-IIOP Stub. This is used in PortableRemoteObject.narrow.
818       */
819      public static Object loadStub(org.omg.CORBA.Object narrowFrom, Class<?> narrowTo)
820      {
821          Object result = null;
822  
823          try
824          {
825              // Get the codebase from the delegate to use when loading the new stub, if possible...
826              String codebase = null;
827              try
828              {
829                  // We can't assume that narrowFrom is a CORBA_2_3 stub, yet it may have a 2_3 Delegate that provides a
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/impl/util/Utility.java
      * Line Number: 832
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
822  
823          try
824          {
825              // Get the codebase from the delegate to use when loading the new stub, if possible...
826              String codebase = null;
827              try
828              {
829                  // We can't assume that narrowFrom is a CORBA_2_3 stub, yet it may have a 2_3 Delegate that provides a
830                  // codebase. Swallow the ClassCastException otherwise.
831                  Delegate delegate = StubAdapter.getDelegate(narrowFrom);
832                  codebase = ((org.omg.CORBA_2_3.portable.Delegate) delegate).get_codebase(narrowFrom);
833  
834              }
835              catch (ClassCastException e)
836              {
837                  wrapper.classCastExceptionInLoadStub(e);
838              }
839  
840              PresentationManager.StubFactoryFactory sff = org.jboss.com.sun.corba.se.spi.orb.ORB.getStubFactoryFactory();
841              PresentationManager.StubFactory sf = sff.createStubFactory(narrowTo.getName(), false, codebase, narrowTo,
842                      narrowTo.getClassLoader());
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/org/omg/CORBA/ORB.java
      * Line Number: 28
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
18   * 2 along with this work; if not, write to the Free Software Foundation,
19   * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
20   *
21   * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
22   * or visit www.oracle.com if you need additional information or have any
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.org.omg.CORBA;
27  
28  import org.omg.CORBA.ORBPackage.InvalidName;
29  
30  /**
31   * This ORB class is defined to provide a home for the register_initial_reference operation, which is added by portable
32   * interceptors and CORBA 2.4. It is added here until there is an official Java language mapping for the method.
33   */
34  abstract public class ORB extends org.omg.CORBA_2_3.ORB
35  {
36      /**
37       * If this operation is called with an id, <code>"Y"</code>, and an object, <code>YY</code>, then a subsequent call
38       * to <code>ORB.resolve_initial_references( "Y" )</code> will return object <code>YY</code>.
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/org/omg/CORBA/ORB.java
      * Line Number: 34
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
24   */
25  
26  package org.jboss.com.sun.corba.se.org.omg.CORBA;
27  
28  import org.omg.CORBA.ORBPackage.InvalidName;
29  
30  /**
31   * This ORB class is defined to provide a home for the register_initial_reference operation, which is added by portable
32   * interceptors and CORBA 2.4. It is added here until there is an official Java language mapping for the method.
33   */
34  abstract public class ORB extends org.omg.CORBA_2_3.ORB
35  {
36      /**
37       * If this operation is called with an id, <code>"Y"</code>, and an object, <code>YY</code>, then a subsequent call
38       * to <code>ORB.resolve_initial_references( "Y" )</code> will return object <code>YY</code>.
39       * 
40       * @param id
41       *            The ID by which the initial reference will be known.
42       * @param obj
43       *            The initial reference itself.
44       * @throws InvalidName
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/org/omg/CORBA/ORB.java
      * Line Number: 50
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
40       * @param id
41       *            The ID by which the initial reference will be known.
42       * @param obj
43       *            The initial reference itself.
44       * @throws InvalidName
45       *             if this operation is called with an empty string id or this operation is called with an id that is
46       *             already registered, including the default names defined by OMG.
47       * @throws BAD_PARAM
48       *             if the obj parameter is null.
49       */
50      public void register_initial_reference(String id, org.omg.CORBA.Object obj) throws InvalidName
51      {
52          throw new org.omg.CORBA.NO_IMPLEMENT();
53      }
54  }

```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/org/omg/CORBA/ORB.java
      * Line Number: 52
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
42       * @param obj
43       *            The initial reference itself.
44       * @throws InvalidName
45       *             if this operation is called with an empty string id or this operation is called with an id that is
46       *             already registered, including the default names defined by OMG.
47       * @throws BAD_PARAM
48       *             if the obj parameter is null.
49       */
50      public void register_initial_reference(String id, org.omg.CORBA.Object obj) throws InvalidName
51      {
52          throw new org.omg.CORBA.NO_IMPLEMENT();
53      }
54  }

```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/pept/protocol/ClientRequestDispatcher.java
      * Line Number: 77
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
67       * @return {@link org.jboss.com.sun.corba.se.pept.encoding.InputObject InputObject} if the message is synchronous.
68       * 
69       * @throws {@link org.omg.CORBA.portable.ApplicationException ApplicationException} if the remote side raises an
70       *         exception declared in the remote interface.
71       * 
72       * @throws {@link org.omg.CORBA.portable.RemarshalException RemarshalException} if the PEPt runtime would like the
73       *         presentation block to start over.
74       */
75      public InputObject marshalingComplete(java.lang.Object self, OutputObject outputObject)
76      // REVISIT EXCEPTIONS
77              throws org.omg.CORBA.portable.ApplicationException, org.omg.CORBA.portable.RemarshalException;
78  
79      /**
80       * After the presentation block completes a request it signals the PEPt runtime by calling this method.
81       * 
82       * This method may release resources. In some cases it may cause control or error messages to be sent.
83       * 
84       * @param broker
85       *            -
86       * @param inputObject
87       *            -
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/spi/activation/POANameHelper.java
      * Line Number: 38
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
28  /**
29   * org/jboss/com/sun/corba/se/spi/activation/POANameHelper.java . Generated by the IDL-to-Java compiler (portable),
30   * version "3.2" from src/main/resources/idl/org/jboss/com/sun/corba/se/spi/activation/activation.idl Wednesday,
31   * February 2, 2011 5:13:28 PM PST
32   */
33  
34  abstract public class POANameHelper
35  {
36      private static String _id = "IDL:activation/POAName:1.0";
37  
38      public static void insert(org.omg.CORBA.Any a, String[] that)
39      {
40          org.omg.CORBA.portable.OutputStream out = a.create_output_stream();
41          a.type(type());
42          write(out, that);
43          a.read_value(out.create_input_stream(), type());
44      }
45  
46      public static String[] extract(org.omg.CORBA.Any a)
47      {
48          return read(a.create_input_stream());
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/spi/activation/POANameHelper.java
      * Line Number: 40
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
30   * version "3.2" from src/main/resources/idl/org/jboss/com/sun/corba/se/spi/activation/activation.idl Wednesday,
31   * February 2, 2011 5:13:28 PM PST
32   */
33  
34  abstract public class POANameHelper
35  {
36      private static String _id = "IDL:activation/POAName:1.0";
37  
38      public static void insert(org.omg.CORBA.Any a, String[] that)
39      {
40          org.omg.CORBA.portable.OutputStream out = a.create_output_stream();
41          a.type(type());
42          write(out, that);
43          a.read_value(out.create_input_stream(), type());
44      }
45  
46      public static String[] extract(org.omg.CORBA.Any a)
47      {
48          return read(a.create_input_stream());
49      }
50  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/spi/activation/POANameHelper.java
      * Line Number: 46
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
36      private static String _id = "IDL:activation/POAName:1.0";
37  
38      public static void insert(org.omg.CORBA.Any a, String[] that)
39      {
40          org.omg.CORBA.portable.OutputStream out = a.create_output_stream();
41          a.type(type());
42          write(out, that);
43          a.read_value(out.create_input_stream(), type());
44      }
45  
46      public static String[] extract(org.omg.CORBA.Any a)
47      {
48          return read(a.create_input_stream());
49      }
50  
51      private static org.omg.CORBA.TypeCode __typeCode = null;
52  
53      synchronized public static org.omg.CORBA.TypeCode type()
54      {
55          if (__typeCode == null)
56          {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/spi/activation/POANameHelper.java
      * Line Number: 51
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
41          a.type(type());
42          write(out, that);
43          a.read_value(out.create_input_stream(), type());
44      }
45  
46      public static String[] extract(org.omg.CORBA.Any a)
47      {
48          return read(a.create_input_stream());
49      }
50  
51      private static org.omg.CORBA.TypeCode __typeCode = null;
52  
53      synchronized public static org.omg.CORBA.TypeCode type()
54      {
55          if (__typeCode == null)
56          {
57              __typeCode = org.omg.CORBA.ORB.init().create_string_tc(0);
58              __typeCode = org.omg.CORBA.ORB.init().create_sequence_tc(0, __typeCode);
59              __typeCode = org.omg.CORBA.ORB.init().create_alias_tc(
60                      org.jboss.com.sun.corba.se.spi.activation.POANameHelper.id(), "POAName", __typeCode);
61          }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/spi/activation/POANameHelper.java
      * Line Number: 53
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
43          a.read_value(out.create_input_stream(), type());
44      }
45  
46      public static String[] extract(org.omg.CORBA.Any a)
47      {
48          return read(a.create_input_stream());
49      }
50  
51      private static org.omg.CORBA.TypeCode __typeCode = null;
52  
53      synchronized public static org.omg.CORBA.TypeCode type()
54      {
55          if (__typeCode == null)
56          {
57              __typeCode = org.omg.CORBA.ORB.init().create_string_tc(0);
58              __typeCode = org.omg.CORBA.ORB.init().create_sequence_tc(0, __typeCode);
59              __typeCode = org.omg.CORBA.ORB.init().create_alias_tc(
60                      org.jboss.com.sun.corba.se.spi.activation.POANameHelper.id(), "POAName", __typeCode);
61          }
62          return __typeCode;
63      }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/spi/activation/POANameHelper.java
      * Line Number: 57
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
47      {
48          return read(a.create_input_stream());
49      }
50  
51      private static org.omg.CORBA.TypeCode __typeCode = null;
52  
53      synchronized public static org.omg.CORBA.TypeCode type()
54      {
55          if (__typeCode == null)
56          {
57              __typeCode = org.omg.CORBA.ORB.init().create_string_tc(0);
58              __typeCode = org.omg.CORBA.ORB.init().create_sequence_tc(0, __typeCode);
59              __typeCode = org.omg.CORBA.ORB.init().create_alias_tc(
60                      org.jboss.com.sun.corba.se.spi.activation.POANameHelper.id(), "POAName", __typeCode);
61          }
62          return __typeCode;
63      }
64  
65      public static String id()
66      {
67          return _id;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/spi/activation/POANameHelper.java
      * Line Number: 58
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
48          return read(a.create_input_stream());
49      }
50  
51      private static org.omg.CORBA.TypeCode __typeCode = null;
52  
53      synchronized public static org.omg.CORBA.TypeCode type()
54      {
55          if (__typeCode == null)
56          {
57              __typeCode = org.omg.CORBA.ORB.init().create_string_tc(0);
58              __typeCode = org.omg.CORBA.ORB.init().create_sequence_tc(0, __typeCode);
59              __typeCode = org.omg.CORBA.ORB.init().create_alias_tc(
60                      org.jboss.com.sun.corba.se.spi.activation.POANameHelper.id(), "POAName", __typeCode);
61          }
62          return __typeCode;
63      }
64  
65      public static String id()
66      {
67          return _id;
68      }
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/spi/activation/POANameHelper.java
      * Line Number: 59
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
49      }
50  
51      private static org.omg.CORBA.TypeCode __typeCode = null;
52  
53      synchronized public static org.omg.CORBA.TypeCode type()
54      {
55          if (__typeCode == null)
56          {
57              __typeCode = org.omg.CORBA.ORB.init().create_string_tc(0);
58              __typeCode = org.omg.CORBA.ORB.init().create_sequence_tc(0, __typeCode);
59              __typeCode = org.omg.CORBA.ORB.init().create_alias_tc(
60                      org.jboss.com.sun.corba.se.spi.activation.POANameHelper.id(), "POAName", __typeCode);
61          }
62          return __typeCode;
63      }
64  
65      public static String id()
66      {
67          return _id;
68      }
69  
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/spi/activation/POANameHelper.java
      * Line Number: 70
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
60                      org.jboss.com.sun.corba.se.spi.activation.POANameHelper.id(), "POAName", __typeCode);
61          }
62          return __typeCode;
63      }
64  
65      public static String id()
66      {
67          return _id;
68      }
69  
70      public static String[] read(org.omg.CORBA.portable.InputStream istream)
71      {
72          String value[] = null;
73          int _len0 = istream.read_long();
74          value = new String[_len0];
75          for (int _o1 = 0; _o1 < value.length; ++_o1)
76              value[_o1] = istream.read_string();
77          return value;
78      }
79  
80      public static void write(org.omg.CORBA.portable.OutputStream ostream, String[] value)
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/spi/activation/POANameHelper.java
      * Line Number: 80
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
70      public static String[] read(org.omg.CORBA.portable.InputStream istream)
71      {
72          String value[] = null;
73          int _len0 = istream.read_long();
74          value = new String[_len0];
75          for (int _o1 = 0; _o1 < value.length; ++_o1)
76              value[_o1] = istream.read_string();
77          return value;
78      }
79  
80      public static void write(org.omg.CORBA.portable.OutputStream ostream, String[] value)
81      {
82          ostream.write_long(value.length);
83          for (int _i0 = 0; _i0 < value.length; ++_i0)
84              ostream.write_string(value[_i0]);
85      }
86  
87  }

```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/spi/extension/CopyObjectPolicy.java
      * Line Number: 29
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
19   * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
20   *
21   * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
22   * or visit www.oracle.com if you need additional information or have any
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.spi.extension;
27  
28  import org.jboss.com.sun.corba.se.impl.orbutil.ORBConstants;
29  import org.omg.CORBA.LocalObject;
30  import org.omg.CORBA.Policy;
31  
32  /** Policy used to specify the copyObject implementation to use. */
33  @SuppressWarnings("serial")
34  public class CopyObjectPolicy extends LocalObject implements Policy
35  {
36      private final int value;
37  
38      public CopyObjectPolicy(int value)
39      {
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/spi/extension/CopyObjectPolicy.java
      * Line Number: 30
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
20   *
21   * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
22   * or visit www.oracle.com if you need additional information or have any
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.spi.extension;
27  
28  import org.jboss.com.sun.corba.se.impl.orbutil.ORBConstants;
29  import org.omg.CORBA.LocalObject;
30  import org.omg.CORBA.Policy;
31  
32  /** Policy used to specify the copyObject implementation to use. */
33  @SuppressWarnings("serial")
34  public class CopyObjectPolicy extends LocalObject implements Policy
35  {
36      private final int value;
37  
38      public CopyObjectPolicy(int value)
39      {
40          this.value = value;
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/spi/extension/CopyObjectPolicy.java
      * Line Number: 53
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
43      public int getValue()
44      {
45          return value;
46      }
47  
48      public int policy_type()
49      {
50          return ORBConstants.COPY_OBJECT_POLICY;
51      }
52  
53      public org.omg.CORBA.Policy copy()
54      {
55          return this;
56      }
57  
58      public void destroy()
59      {
60          // NO-OP
61      }
62  
63      public String toString()
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/spi/extension/ServantCachingPolicy.java
      * Line Number: 152
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
142              minimalPolicy = new ServantCachingPolicy(MINIMAL_SEMANTICS);
143  
144          return minimalPolicy;
145      }
146  
147      public int policy_type()
148      {
149          return ORBConstants.SERVANT_CACHING_POLICY;
150      }
151  
152      public org.omg.CORBA.Policy copy()
153      {
154          return this;
155      }
156  
157      public void destroy()
158      {
159          // NO-OP
160      }
161  }

```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/spi/extension/ServantCachingPolicy.java
      * Line Number: 29
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
19   * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
20   *
21   * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
22   * or visit www.oracle.com if you need additional information or have any
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.spi.extension;
27  
28  import org.jboss.com.sun.corba.se.impl.orbutil.ORBConstants;
29  import org.omg.CORBA.LocalObject;
30  import org.omg.CORBA.Policy;
31  
32  /**
33   * Policy used to implement servant caching optimization in the POA. Creating a POA with an instance pol of this policy
34   * where pol.getType() &gt; NO_SERVANT_CACHING will cause the servant to be looked up in the POA and cached in the
35   * LocalClientRequestDispatcher when the ClientRequestDispatcher is colocated with the implementation of the objref.
36   * This greatly speeds up invocations at the cost of violating the POA semantics. In particular, every request to a
37   * particular objref must be handled by the same servant. Note that this is typically the case for EJB implementations.
38   * <p>
39   * If servant caching is used, there are two different additional features of the POA that are expensive:
```
  * file:///root/.m2/repository/org/jboss/spec/javax/rmi/jboss-rmi-api_1.0_spec/1.0.2.Final/org/jboss/com/sun/corba/se/spi/extension/ServantCachingPolicy.java
      * Line Number: 30
      * Message: 'Common Object Request Broker Architecture (CORBA) found in the application. CORBA is not recommended in cloud environments. Try to replace it with a more modern technology.'
      * Code Snippet:
```java
20   *
21   * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
22   * or visit www.oracle.com if you need additional information or have any
23   * questions.
24   */
25  
26  package org.jboss.com.sun.corba.se.spi.extension;
27  
28  import org.jboss.com.sun.corba.se.impl.orbutil.ORBConstants;
29  import org.omg.CORBA.LocalObject;
30  import org.omg.CORBA.Policy;
31  
32  /**
33   * Policy used to implement servant caching optimization in the POA. Creating a POA with an inst