/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.server.handler;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebExceptionHandler;
import reactor.core.publisher.Mono;

public class ResponseStatusExceptionHandler
implements WebExceptionHandler {
    private static final Log logger = LogFactory.getLog(ResponseStatusExceptionHandler.class);
    @Nullable
    private Log warnLogger;

    public void setWarnLogCategory(String loggerName) {
        this.warnLogger = LogFactory.getLog((String)loggerName);
    }

    @Override
    public Mono<Void> handle(ServerWebExchange exchange2, Throwable ex) {
        if (!this.updateResponse(exchange2.getResponse(), ex)) {
            return Mono.error((Throwable)ex);
        }
        String logPrefix = exchange2.getLogPrefix();
        if (this.warnLogger != null && this.warnLogger.isWarnEnabled()) {
            this.warnLogger.warn((Object)(logPrefix + this.formatError(ex, exchange2.getRequest())), ex);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)(logPrefix + this.formatError(ex, exchange2.getRequest())));
        }
        return exchange2.getResponse().setComplete();
    }

    private String formatError(Throwable ex, ServerHttpRequest request) {
        String reason = ex.getClass().getSimpleName() + ": " + ex.getMessage();
        String path = request.getURI().getRawPath();
        return "Resolved [" + reason + "] for HTTP " + request.getMethod() + " " + path;
    }

    private boolean updateResponse(ServerHttpResponse response, Throwable ex) {
        boolean result = false;
        HttpStatus status = this.determineStatus(ex);
        if (status != null) {
            if (response.setStatusCode(status)) {
                if (ex instanceof ResponseStatusException) {
                    ((ResponseStatusException)((Object)ex)).getResponseHeaders().forEach((name, values) -> values.forEach(value -> response.getHeaders().add(name, value)));
                }
                result = true;
            }
        } else {
            Throwable cause = ex.getCause();
            if (cause != null) {
                result = this.updateResponse(response, cause);
            }
        }
        return result;
    }

    @Nullable
    protected HttpStatus determineStatus(Throwable ex) {
        if (ex instanceof ResponseStatusException) {
            return ((ResponseStatusException)((Object)ex)).getStatus();
        }
        return null;
    }
}

