Thanks submitting your Operator. Please check below list before you create your Pull Request.

*************************************************
**Flat operator directory structure is obsolete from 23-rd of October 2019, only nested directory structure will be accepted.**
*************************************************

### New Submissions

* [ ] Does your operator have [nested directory structure](https://github.com/operator-framework/community-operators/blob/master/docs/contributing.md#create-a-bundle)?
* [ ] Have you selected the Project *Community Operator Submissions* in your PR on the right-hand menu bar?
* [ ] Are you familiar with our [contribution guidelines](https://github.com/operator-framework/community-operators/blob/master/docs/contributing.md)?
* [ ] Have you [packaged and deployed](https://github.com/operator-framework/community-operators/blob/master/docs/testing-operators.md) your Operator for Operator Framework?
* [ ] Have you tested your Operator with all Custom Resource Definitions?
* [ ] Have you tested your Operator in all supported [installation modes](https://github.com/operator-framework/operator-lifecycle-manager/blob/master/doc/design/building-your-csv.md#operator-metadata)?
* [ ] Have you considered whether you want use [semantic versioning order](https://github.com/operator-framework/community-operators/blob/master/docs/contributing.md#updating-your-existing-operator)?
* [ ] Is your submission [signed](https://github.com/operator-framework/community-operators/blob/master/docs/contributing.md#sign-your-work)?

### Updates to existing Operators

* [ ] Did you create a `ci.yaml` file according to the [update instructions](https://github.com/operator-framework/community-operators/blob/master/docs/contributing.md#updating-your-existing-operator)?
* [ ] Is your new CSV pointing to the previous version with the `replaces` property if you chose `replaces-mode` via the `updateGraph` property in `ci.yaml`?
* [X] Is your new CSV referenced in the [appropriate channel](https://github.com/operator-framework/community-operators/blob/master/docs/contributing.md#bundle-format) defined in the `package.yaml` or `annotations.yaml` ?
* [X] Have you tested an update to your Operator when deployed via OLM?
* [X] Is your submission [signed](https://github.com/operator-framework/community-operators/blob/master/docs/contributing.md#sign-your-work)?

### Your submission should not

* [X] Modify more than one operator
* [X] Modify an Operator you don't own
* [X] Rename an operator - please remove and add with a different name instead
* [X] Submit operators to both `upstream-community-operators` and `community-operators` at once
* [X] Modify any files outside the above mentioned folders
* [X] Contain more than one commit. **Please squash your commits.**

### Operator Description must contain (in order)

1. [X] Description about the managed Application and where to find more information
2. [X] Features and capabilities of your Operator and how to use it
3. [X] Any manual steps about potential pre-requisites for using your Operator

### Operator Metadata should contain

* [X] Human readable name and 1-liner description about your Operator
* [X] Valid [category name](https://github.com/operator-framework/community-operators/blob/master/docs/required-fields.md#categories)<sup>1</sup>
* [X] One of the pre-defined [capability levels](https://github.com/operator-framework/operator-courier/blob/4d1a25d2c8d52f7de6297ec18d8afd6521236aa2/operatorcourier/validate.py#L556)<sup>2</sup>
* [X] Links to the maintainer, source code and documentation
* [X] Example templates for all Custom Resource Definitions intended to be used
* [X] A quadratic logo

Remember that you can preview your CSV [here](https://operatorhub.io/preview).

--

<sup>1</sup> If you feel your Operator does not fit any of the pre-defined categories, file an issue against this repo and explain your need

<sup>2</sup> For more information see [here](https://github.com/operator-framework/operator-sdk/blob/master/doc/images/operator-capability-level.svg)
