/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogController {
    private static final Logger LOG = LoggerFactory.getLogger(LogController.class);

    public static void setLogLevel(Level level) {
        org.apache.log4j.Logger root = org.apache.log4j.Logger.getLogger((String)"org.jboss.windup");
        root.setLevel(level);
        LOG.info("Set logger to: " + level);
    }

    public static void setLogLevel(String level) {
        Level l = Level.toLevel((String)level, (Level)Level.INFO);
        LogController.setLogLevel(l);
    }

    public static void addFileAppender(File outputLocation) {
        String hashCode = outputLocation.toString().hashCode() + "";
        LOG.debug("Adding logger: " + outputLocation.getAbsolutePath() + " : " + hashCode);
        org.apache.log4j.Logger root = org.apache.log4j.Logger.getRootLogger();
        PatternLayout pl = new PatternLayout("%d %-5p [%c] (%t) %m%n");
        try {
            FileAppender fa = new FileAppender((Layout)pl, outputLocation.getAbsolutePath());
            fa.setName(hashCode);
            root.addAppender((Appender)fa);
            root.setAdditivity(false);
        }
        catch (IOException e) {
            LOG.error("Exception with file appender.", (Throwable)e);
        }
    }

    public static void removeFileAppender(File outputLocation) {
        String hashCode = outputLocation.toString().hashCode() + "";
        LOG.debug("Removing logger: " + outputLocation.getAbsolutePath() + " : " + hashCode);
        org.apache.log4j.Logger root = org.apache.log4j.Logger.getRootLogger();
        root.removeAppender(hashCode);
    }

    private static class LogPrintStream
    extends PrintStream {
        private static final Logger LOG = LoggerFactory.getLogger(LogPrintStream.class);

        public LogPrintStream(PrintStream stream) {
            super(stream);
        }

        @Override
        public void println(String top) {
            LOG.debug(top);
        }

        @Override
        public void print(String top) {
            LOG.debug(top);
        }
    }

    public static class LoggingAdapter {
        public static void tieSystemOutAndErrToLog() {
            System.setOut(LoggingAdapter.createLoggingProxy(System.out));
        }

        public static PrintStream createLoggingProxy(PrintStream realPrintStream) {
            return new LogPrintStream(realPrintStream);
        }
    }
}

