/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import javax.persistence.TemporalType;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.JpaParametersParameterAccessor;
import org.springframework.data.jpa.repository.query.ParameterMetadataProvider;
import org.springframework.data.jpa.repository.query.QueryParameterSetter;
import org.springframework.data.jpa.repository.query.StringQuery;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

abstract class QueryParameterSetterFactory {
    QueryParameterSetterFactory() {
    }

    @Nullable
    abstract QueryParameterSetter create(StringQuery.ParameterBinding var1, DeclaredQuery var2);

    static QueryParameterSetterFactory basic(JpaParameters parameters) {
        Assert.notNull((Object)((Object)parameters), (String)"JpaParameters must not be null!");
        return new BasicQueryParameterSetterFactory(parameters);
    }

    static QueryParameterSetterFactory forCriteriaQuery(JpaParameters parameters, List<ParameterMetadataProvider.ParameterMetadata<?>> metadata) {
        Assert.notNull((Object)((Object)parameters), (String)"JpaParameters must not be null!");
        Assert.notNull(metadata, (String)"ParameterMetadata must not be null!");
        return new CriteriaQueryParameterSetterFactory(parameters, metadata);
    }

    static QueryParameterSetterFactory parsing(SpelExpressionParser parser, QueryMethodEvaluationContextProvider evaluationContextProvider, Parameters<?, ?> parameters) {
        Assert.notNull((Object)parser, (String)"SpelExpressionParser must not be null!");
        Assert.notNull((Object)evaluationContextProvider, (String)"EvaluationContextProvider must not be null!");
        Assert.notNull(parameters, (String)"Parameters must not be null!");
        return new ExpressionBasedQueryParameterSetterFactory(parser, evaluationContextProvider, parameters);
    }

    private static QueryParameterSetter createSetter(Function<JpaParametersParameterAccessor, Object> valueExtractor, StringQuery.ParameterBinding binding, @Nullable JpaParameters.JpaParameter parameter) {
        TemporalType temporalType = parameter != null && parameter.isTemporalParameter() ? parameter.getRequiredTemporalType() : null;
        return new QueryParameterSetter.NamedOrIndexedQueryParameterSetter(valueExtractor.andThen(binding::prepare), ParameterImpl.of(parameter, binding), temporalType);
    }

    private static class ParameterImpl<T>
    implements javax.persistence.Parameter<T> {
        private final Class<T> parameterType;
        @Nullable
        private final String name;
        @Nullable
        private final Integer position;

        static javax.persistence.Parameter<?> of(@Nullable JpaParameters.JpaParameter parameter, StringQuery.ParameterBinding binding) {
            Class type = parameter == null ? Object.class : parameter.getType();
            return new ParameterImpl(type, ParameterImpl.getName(parameter, binding), binding.getPosition());
        }

        private ParameterImpl(Class<T> parameterType, @Nullable String name, @Nullable Integer position) {
            this.name = name;
            this.position = position;
            this.parameterType = parameterType;
        }

        @Nullable
        public String getName() {
            return this.name;
        }

        @Nullable
        public Integer getPosition() {
            return this.position;
        }

        public Class<T> getParameterType() {
            return this.parameterType;
        }

        @Nullable
        private static String getName(@Nullable JpaParameters.JpaParameter parameter, StringQuery.ParameterBinding binding) {
            if (parameter == null) {
                return binding.getName();
            }
            return parameter.isNamedParameter() ? (String)parameter.getName().orElseThrow(() -> new IllegalArgumentException("o_O parameter needs to have a name!")) : null;
        }
    }

    private static class CriteriaQueryParameterSetterFactory
    extends QueryParameterSetterFactory {
        private final JpaParameters parameters;
        private final List<ParameterMetadataProvider.ParameterMetadata<?>> expressions;

        CriteriaQueryParameterSetterFactory(JpaParameters parameters, List<ParameterMetadataProvider.ParameterMetadata<?>> metadata) {
            Assert.notNull((Object)((Object)parameters), (String)"JpaParameters must not be null!");
            Assert.notNull(metadata, (String)"Expressions must not be null!");
            this.parameters = parameters;
            this.expressions = metadata;
        }

        @Override
        public QueryParameterSetter create(StringQuery.ParameterBinding binding, DeclaredQuery declaredQuery) {
            int parameterIndex = binding.getRequiredPosition() - 1;
            Assert.isTrue((parameterIndex < this.expressions.size() ? 1 : 0) != 0, () -> String.format("At least %s parameter(s) provided but only %s parameter(s) present in query.", binding.getRequiredPosition(), this.expressions.size()));
            ParameterMetadataProvider.ParameterMetadata<?> metadata = this.expressions.get(parameterIndex);
            if (metadata.isIsNullParameter()) {
                return QueryParameterSetter.NOOP;
            }
            JpaParameters.JpaParameter parameter = (JpaParameters.JpaParameter)this.parameters.getBindableParameter(parameterIndex);
            TemporalType temporalType = parameter.isTemporalParameter() ? parameter.getRequiredTemporalType() : null;
            return new QueryParameterSetter.NamedOrIndexedQueryParameterSetter(values -> this.getAndPrepare(parameter, metadata, (JpaParametersParameterAccessor)((Object)values)), (javax.persistence.Parameter<?>)metadata.getExpression(), temporalType);
        }

        @Nullable
        private Object getAndPrepare(JpaParameters.JpaParameter parameter, ParameterMetadataProvider.ParameterMetadata<?> metadata, JpaParametersParameterAccessor accessor) {
            return metadata.prepare(accessor.getValue(parameter));
        }
    }

    private static class BasicQueryParameterSetterFactory
    extends QueryParameterSetterFactory {
        private final JpaParameters parameters;

        BasicQueryParameterSetterFactory(JpaParameters parameters) {
            Assert.notNull((Object)((Object)parameters), (String)"JpaParameters must not be null!");
            this.parameters = parameters;
        }

        @Override
        public QueryParameterSetter create(StringQuery.ParameterBinding binding, DeclaredQuery declaredQuery) {
            JpaParameters.JpaParameter parameter;
            Assert.notNull((Object)binding, (String)"Binding must not be null.");
            if (declaredQuery.hasNamedParameter()) {
                parameter = this.findParameterForBinding(binding);
            } else {
                JpaParameters bindableParameters;
                int parameterIndex = binding.getRequiredPosition() - 1;
                Assert.isTrue((parameterIndex < (bindableParameters = (JpaParameters)this.parameters.getBindableParameters()).getNumberOfParameters() ? 1 : 0) != 0, () -> String.format("At least %s parameter(s) provided but only %s parameter(s) present in query.", binding.getRequiredPosition(), bindableParameters.getNumberOfParameters()));
                parameter = (JpaParameters.JpaParameter)bindableParameters.getParameter(binding.getRequiredPosition() - 1);
            }
            return parameter == null ? QueryParameterSetter.NOOP : QueryParameterSetterFactory.createSetter(values -> this.getValue((JpaParametersParameterAccessor)((Object)values), parameter), binding, parameter);
        }

        @Nullable
        private JpaParameters.JpaParameter findParameterForBinding(StringQuery.ParameterBinding binding) {
            JpaParameters bindableParameters = (JpaParameters)this.parameters.getBindableParameters();
            Iterator iterator = bindableParameters.iterator();
            while (iterator.hasNext()) {
                JpaParameters.JpaParameter bindableParameter = (JpaParameters.JpaParameter)((Object)iterator.next());
                if (!binding.getRequiredName().equals(BasicQueryParameterSetterFactory.getName(bindableParameter))) continue;
                return bindableParameter;
            }
            return null;
        }

        private Object getValue(JpaParametersParameterAccessor accessor, Parameter parameter) {
            return accessor.getValue(parameter);
        }

        private static String getName(JpaParameters.JpaParameter p) {
            return (String)p.getName().orElseThrow(() -> new IllegalStateException("For queries with named parameters you need to use provide names for method parameters. Use @Param for query method parameters, or when on Java 8+ use the javac flag -parameters."));
        }
    }

    private static class ExpressionBasedQueryParameterSetterFactory
    extends QueryParameterSetterFactory {
        private final SpelExpressionParser parser;
        private final QueryMethodEvaluationContextProvider evaluationContextProvider;
        private final Parameters<?, ?> parameters;

        ExpressionBasedQueryParameterSetterFactory(SpelExpressionParser parser, QueryMethodEvaluationContextProvider evaluationContextProvider, Parameters<?, ?> parameters) {
            Assert.notNull((Object)evaluationContextProvider, (String)"EvaluationContextProvider must not be null!");
            Assert.notNull((Object)parser, (String)"SpelExpressionParser must not be null!");
            Assert.notNull(parameters, (String)"Parameters must not be null!");
            this.evaluationContextProvider = evaluationContextProvider;
            this.parser = parser;
            this.parameters = parameters;
        }

        @Override
        @Nullable
        public QueryParameterSetter create(StringQuery.ParameterBinding binding, DeclaredQuery declaredQuery) {
            if (!binding.isExpression()) {
                return null;
            }
            Expression expression = this.parser.parseExpression(binding.getExpression());
            return QueryParameterSetterFactory.createSetter(values -> this.evaluateExpression(expression, (JpaParametersParameterAccessor)((Object)values)), binding, null);
        }

        @Nullable
        private Object evaluateExpression(Expression expression, JpaParametersParameterAccessor accessor) {
            EvaluationContext context = this.evaluationContextProvider.getEvaluationContext(this.parameters, accessor.getValues());
            return expression.getValue(context, Object.class);
        }
    }
}

