/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.util;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class BlacklistPackageResolver {
    private Set<Pattern> generatedBlacklists;
    private Set<Pattern> classBlacklists;

    public void setGeneratedBlacklists(Set<Pattern> generatedBlacklists) {
        this.generatedBlacklists = generatedBlacklists;
    }

    public void setClassBlacklists(Set<Pattern> classBlacklists) {
        this.classBlacklists = classBlacklists;
    }

    protected boolean classContainedInList(Set<String> classImports, Set<Pattern> targetList) {
        for (String classImport : classImports) {
            for (Pattern listElement : targetList) {
                if (!listElement.matcher(classImport).find()) continue;
                return true;
            }
        }
        return false;
    }

    protected Set<String> extractMatchingEntries(Set<String> candidates, Set<Pattern> targetList) {
        HashSet<String> lists = new HashSet<String>();
        for (String clzImport : candidates) {
            for (Pattern listElement : targetList) {
                if (!listElement.matcher(clzImport).find()) continue;
                lists.add(clzImport);
            }
        }
        return lists;
    }

    public Set<String> extractBlacklist(Set<String> classImports) {
        return this.extractMatchingEntries(classImports, this.classBlacklists);
    }

    public boolean containsBlacklist(Set<String> classImports) {
        return this.classContainedInList(classImports, this.classBlacklists);
    }

    public boolean containsGenerated(Set<String> classImports) {
        return this.classContainedInList(classImports, this.generatedBlacklists);
    }
}

