/*
 * Decompiled with CFR 0.152.
 */
package wlp.lib.extract;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ProductMatch {
    private String productId;
    private String version;
    private String installType;
    private final List editions = new ArrayList();
    private String licenseType;
    private static final Pattern validNumericVersionOrRange = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+)\\+?$");
    static final int MATCHED = 0;
    static final int NOT_APPLICABLE = -1;
    static final int INVALID_VERSION = -2;
    static final int INVALID_EDITION = -3;
    static final int INVALID_INSTALL_TYPE = -4;

    public void add(String substring) {
        substring = substring.trim();
        if (this.productId == null) {
            this.productId = substring;
        } else if (substring.startsWith("productVersion")) {
            this.version = this.getValue(substring);
        } else if (substring.startsWith("productEdition")) {
            String editionStr = this.getValue(substring);
            int startIndex = 0;
            int endIndex = editionStr.indexOf(44);
            while (true) {
                this.editions.add(editionStr.substring(startIndex, endIndex == -1 ? editionStr.length() : endIndex));
                if (endIndex != -1) {
                    startIndex = endIndex;
                    endIndex = editionStr.indexOf(44, ++startIndex);
                    continue;
                }
                break;
            }
        } else if (substring.startsWith("productInstallType")) {
            this.installType = this.getValue(substring);
        } else if (substring.startsWith("productLicenseType")) {
            this.licenseType = this.getValue(substring);
        }
    }

    public int matches(Properties props) {
        if (this.productId.equals(props.getProperty("com.ibm.websphere.productId"))) {
            if (this.version != null) {
                int[] targetProductVersion;
                int[] minAppliesToVersion;
                String productVersion = props.getProperty("com.ibm.websphere.productVersion");
                Matcher appliesToMatcher = validNumericVersionOrRange.matcher(this.version);
                boolean appliesToIsRange = this.version.endsWith("+");
                Matcher productVersionMatcher = validNumericVersionOrRange.matcher(productVersion);
                if (appliesToMatcher.matches() && appliesToIsRange && productVersionMatcher.matches() ? !ProductMatch.versionSatisfiesMinimum(minAppliesToVersion = this.allMatcherGroupsToIntArray(appliesToMatcher), targetProductVersion = this.allMatcherGroupsToIntArray(productVersionMatcher)) : !this.version.equals(productVersion)) {
                    return -2;
                }
            }
            if (!this.editions.isEmpty() && !this.editions.contains(props.getProperty("com.ibm.websphere.productEdition"))) {
                return -3;
            }
            if (this.licenseType != null && !this.licenseType.equals(props.getProperty("com.ibm.websphere.productLicenseType"))) {
                return -3;
            }
            if (this.installType != null && !this.installType.equals(props.getProperty("com.ibm.websphere.productInstallType"))) {
                return -4;
            }
            return 0;
        }
        return -1;
    }

    private int[] allMatcherGroupsToIntArray(Matcher matcher) {
        int numGroups = matcher.groupCount();
        int[] digits = new int[numGroups];
        int i = 0;
        while (i < numGroups) {
            digits[i] = Integer.parseInt(matcher.group(i + 1));
            ++i;
        }
        return digits;
    }

    private String getValue(String substring) {
        int index = substring.indexOf(61);
        if ((substring = substring.substring(index + 1).trim()).charAt(0) == '\"') {
            return substring.substring(1, substring.length() - 1);
        }
        return substring;
    }

    public String getVersion() {
        return this.version;
    }

    public List getEditions() {
        return this.editions;
    }

    public static boolean versionSatisfiesMinimum(int[] minimumVersion, int[] queryVersion) {
        if (minimumVersion.length == queryVersion.length) {
            int i = 0;
            while (i < minimumVersion.length) {
                if (queryVersion[i] < minimumVersion[i]) {
                    return false;
                }
                if (queryVersion[i] != minimumVersion[i] && queryVersion[i] > minimumVersion[i]) {
                    return true;
                }
                ++i;
            }
            return true;
        }
        return false;
    }
}

