/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.common.client.ui.gui;

import com.ibm.wssvt.acme.common.client.ui.gui.AcmeGUI;
import com.ibm.wssvt.acme.common.client.ui.gui.PropertiesDialog;
import com.ibm.wssvt.acme.common.client.ui.gui.RefreshableAcmeGuiPanel;
import com.ibm.wssvt.acme.common.client.ui.gui.model.AdapterConfigurationDecorator;
import com.ibm.wssvt.acme.common.client.ui.gui.model.ExecutionUnitConfigurationDecorator;
import com.ibm.wssvt.acme.common.client.ui.gui.model.IAdapterBeansFactoryMap;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.AbstractListModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ExecutionUnitPanel
extends JPanel
implements RefreshableAcmeGuiPanel {
    private static final long serialVersionUID = 1L;
    private JComboBox cbConfiguredAdapters = null;
    private JList lstTemplateExecutionUnits = null;
    private JComboBox cbBeansFactory = null;
    private JButton btnAddEU = null;
    private JButton btnRemoveEU = null;
    private JList lstConfiguredExecutionUnits = null;
    private JScrollPane spConfiguredExecutionUnits = null;
    private JButton btnConfigureEU = null;
    private JLabel lblExecutionUnitMessage = null;
    private JLabel jLabel = null;
    private JLabel jLabel1 = null;
    private JLabel jLabel2 = null;
    private JLabel jLabel6 = null;
    private JTextField txtEURepeat = null;
    private JLabel jLabel7 = null;
    private JTextField txtEUDescription = null;
    private JLabel lblAdapterId = null;

    public ExecutionUnitPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setName("Execution Units");
        this.setSize(1076, 669);
        this.lblAdapterId = new JLabel();
        this.lblAdapterId.setBounds(new Rectangle(256, 81, 227, 16));
        this.lblAdapterId.setText("");
        this.jLabel7 = new JLabel();
        this.jLabel7.setBounds(new Rectangle(17, 108, 80, 16));
        this.jLabel7.setText("Description:");
        this.jLabel6 = new JLabel();
        this.jLabel6.setBounds(new Rectangle(17, 82, 48, 16));
        this.jLabel6.setText("Repeat");
        this.jLabel2 = new JLabel();
        this.jLabel2.setBounds(new Rectangle(30, 136, 220, 16));
        this.jLabel2.setText("Available Execution Units");
        this.jLabel1 = new JLabel();
        this.jLabel1.setBounds(new Rectangle(254, 19, 225, 16));
        this.jLabel1.setText("Available Beans Factory for Adapter");
        this.jLabel = new JLabel();
        this.jLabel.setBounds(new Rectangle(9, 22, 208, 16));
        this.jLabel.setText("Configured Services/ Adapters");
        this.lblExecutionUnitMessage = new JLabel();
        this.lblExecutionUnitMessage.setBounds(new Rectangle(26, 555, 839, 16));
        this.lblExecutionUnitMessage.setForeground(new Color(255, 51, 51));
        this.lblExecutionUnitMessage.setText("");
        this.setLayout(null);
        this.add((Component)this.getCbConfiguredAdapters(), null);
        this.add((Component)this.getLstTemplateExecutionUnits(), null);
        this.add((Component)this.getCbBeansFactory(), null);
        this.add((Component)this.getBtnAddEU(), null);
        this.add((Component)this.getBtnRemoveEU(), null);
        this.add((Component)this.getSpConfiguredExecutionUnits(), null);
        this.add((Component)this.getBtnConfigureEU(), null);
        this.add((Component)this.lblExecutionUnitMessage, null);
        this.add((Component)this.jLabel, null);
        this.add((Component)this.jLabel1, null);
        this.add((Component)this.jLabel2, null);
        this.add((Component)this.jLabel6, null);
        this.add((Component)this.getTxtEURepeat(), null);
        this.add((Component)this.jLabel7, null);
        this.add((Component)this.getTxtEUDescription(), null);
        this.add((Component)this.lblAdapterId, null);
        this.refresh();
    }

    @Override
    public void refresh() {
        AbstractListModel model;
        AdapterConfigurationDecorator selectedAdapter;
        DefaultComboBoxModel<AdapterConfigurationDecorator> cbModel = new DefaultComboBoxModel<AdapterConfigurationDecorator>(AcmeGUI.getSelectedAdaptersDataModel());
        this.cbConfiguredAdapters.setModel(cbModel);
        if (cbModel.getSize() > 0) {
            this.cbConfiguredAdapters.setSelectedIndex(0);
        }
        if ((selectedAdapter = (AdapterConfigurationDecorator)this.cbConfiguredAdapters.getSelectedItem()) != null) {
            model = new DefaultComboBoxModel<IAdapterBeansFactoryMap>(AcmeGUI.getAdapterBeansFactoryMap().getSupportedBeansFactories(selectedAdapter));
            this.cbBeansFactory.setModel(model);
            this.lblAdapterId.setText("AdapterId: " + selectedAdapter.getId());
            this.lblAdapterId.setForeground(Color.BLACK);
        }
        model = new DefaultListModel();
        for (ExecutionUnitConfigurationDecorator euConfig : AcmeGUI.getTemplateExecutionUnitsDataModel()) {
            ((DefaultListModel)model).addElement(euConfig);
        }
        this.lstTemplateExecutionUnits.setModel(model);
        model = new DefaultListModel();
        this.lstConfiguredExecutionUnits.setModel(model);
        for (int i = 0; i < AcmeGUI.getConfiguredExecutionUnitsDataModel().size(); ++i) {
            ((DefaultListModel)model).addElement(AcmeGUI.getConfiguredExecutionUnitsDataModel().get(i));
        }
    }

    private JComboBox getCbConfiguredAdapters() {
        if (this.cbConfiguredAdapters == null) {
            this.cbConfiguredAdapters = new JComboBox();
            this.cbConfiguredAdapters.setBounds(new Rectangle(10, 44, 210, 25));
            this.cbConfiguredAdapters.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    ExecutionUnitPanel.this.cbConfiguredAdapters.setModel(new DefaultComboBoxModel<AdapterConfigurationDecorator>(AcmeGUI.getSelectedAdaptersDataModel()));
                    AdapterConfigurationDecorator selected = (AdapterConfigurationDecorator)ExecutionUnitPanel.this.cbConfiguredAdapters.getSelectedItem();
                    if (selected == null) {
                        return;
                    }
                    DefaultComboBoxModel<IAdapterBeansFactoryMap> model = new DefaultComboBoxModel<IAdapterBeansFactoryMap>(AcmeGUI.getAdapterBeansFactoryMap().getSupportedBeansFactories(selected));
                    ExecutionUnitPanel.this.cbBeansFactory.setModel(model);
                    ExecutionUnitPanel.this.lblAdapterId.setText("AdapterId: " + selected.getId());
                    ExecutionUnitPanel.this.lblAdapterId.setForeground(Color.BLACK);
                }
            });
            this.cbConfiguredAdapters.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AdapterConfigurationDecorator selected = (AdapterConfigurationDecorator)ExecutionUnitPanel.this.cbConfiguredAdapters.getSelectedItem();
                    if (selected == null) {
                        ExecutionUnitPanel.this.lblExecutionUnitMessage.setText("You MUST selecte an adapter first!!");
                        ExecutionUnitPanel.this.lblExecutionUnitMessage.setForeground(Color.RED);
                        return;
                    }
                    DefaultComboBoxModel<IAdapterBeansFactoryMap> model = new DefaultComboBoxModel<IAdapterBeansFactoryMap>(AcmeGUI.getAdapterBeansFactoryMap().getSupportedBeansFactories(selected));
                    ExecutionUnitPanel.this.cbBeansFactory.setModel(model);
                    ExecutionUnitPanel.this.lblAdapterId.setText("AdapterId: " + selected.getId());
                    ExecutionUnitPanel.this.lblExecutionUnitMessage.setForeground(Color.BLACK);
                }
            });
        }
        return this.cbConfiguredAdapters;
    }

    private JList getLstTemplateExecutionUnits() {
        if (this.lstTemplateExecutionUnits == null) {
            this.lstTemplateExecutionUnits = new JList();
            this.lstTemplateExecutionUnits.setToolTipText("An execution unit is a series of operations to perform using a service adapter");
            this.lstTemplateExecutionUnits.setBounds(new Rectangle(28, 159, 283, 367));
            this.lstTemplateExecutionUnits.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (-1 == ExecutionUnitPanel.this.lstTemplateExecutionUnits.getSelectedIndex()) {
                        return;
                    }
                    ExecutionUnitConfigurationDecorator eu = (ExecutionUnitConfigurationDecorator)((DefaultListModel)ExecutionUnitPanel.this.lstTemplateExecutionUnits.getModel()).get(ExecutionUnitPanel.this.lstTemplateExecutionUnits.getSelectedIndex());
                    ExecutionUnitPanel.this.txtEURepeat.setText("" + eu.getRepeat());
                    ExecutionUnitPanel.this.txtEUDescription.setText(eu.getDescription());
                }
            });
        }
        return this.lstTemplateExecutionUnits;
    }

    private JComboBox getCbBeansFactory() {
        if (this.cbBeansFactory == null) {
            this.cbBeansFactory = new JComboBox();
            this.cbBeansFactory.setBounds(new Rectangle(256, 41, 185, 25));
        }
        return this.cbBeansFactory;
    }

    private JButton getBtnAddEU() {
        if (this.btnAddEU == null) {
            this.btnAddEU = new JButton();
            this.btnAddEU.setBounds(new Rectangle(335, 192, 107, 31));
            this.btnAddEU.setText("Add --->");
            this.btnAddEU.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AdapterConfigurationDecorator adapter = (AdapterConfigurationDecorator)((DefaultComboBoxModel)ExecutionUnitPanel.this.cbConfiguredAdapters.getModel()).getSelectedItem();
                    if (adapter == null) {
                        ExecutionUnitPanel.this.lblExecutionUnitMessage.setText("Update adapters selection first!");
                        ExecutionUnitPanel.this.lblExecutionUnitMessage.setForeground(Color.RED);
                        return;
                    }
                    ExecutionUnitConfigurationDecorator eu = (ExecutionUnitConfigurationDecorator)ExecutionUnitPanel.this.lstTemplateExecutionUnits.getSelectedValue();
                    if (eu == null) {
                        ExecutionUnitPanel.this.lblExecutionUnitMessage.setText("select an EU from the left to add.");
                        ExecutionUnitPanel.this.lblExecutionUnitMessage.setForeground(Color.RED);
                        return;
                    }
                    ExecutionUnitConfigurationDecorator copy = eu.clone();
                    copy.setAdapterId(adapter.getId());
                    IAdapterBeansFactoryMap beansFacttory = (IAdapterBeansFactoryMap)((DefaultComboBoxModel)ExecutionUnitPanel.this.cbBeansFactory.getModel()).getSelectedItem();
                    copy.setBeansFactoryClass(beansFacttory.getName());
                    try {
                        copy.setRepeat(Integer.parseInt(ExecutionUnitPanel.this.txtEURepeat.getText()));
                    }
                    catch (Exception ex) {
                        ExecutionUnitPanel.this.lblExecutionUnitMessage.setText("repeat must be a valid number");
                        ExecutionUnitPanel.this.lblExecutionUnitMessage.setForeground(Color.RED);
                    }
                    copy.setDescription(ExecutionUnitPanel.this.txtEUDescription.getText());
                    AcmeGUI.getConfiguredExecutionUnitsDataModel().add(copy);
                    ((DefaultListModel)ExecutionUnitPanel.this.lstConfiguredExecutionUnits.getModel()).addElement(copy);
                    ExecutionUnitPanel.this.lblExecutionUnitMessage.setText("Added OK");
                    ExecutionUnitPanel.this.lblExecutionUnitMessage.setForeground(Color.BLACK);
                }
            });
        }
        return this.btnAddEU;
    }

    private JButton getBtnRemoveEU() {
        if (this.btnRemoveEU == null) {
            this.btnRemoveEU = new JButton();
            this.btnRemoveEU.setBounds(new Rectangle(335, 272, 111, 29));
            this.btnRemoveEU.setText("<--- Remove");
            this.btnRemoveEU.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExecutionUnitConfigurationDecorator eu = (ExecutionUnitConfigurationDecorator)ExecutionUnitPanel.this.lstConfiguredExecutionUnits.getSelectedValue();
                    int idx = ExecutionUnitPanel.this.lstConfiguredExecutionUnits.getSelectedIndex();
                    if (eu == null) {
                        ExecutionUnitPanel.this.lblExecutionUnitMessage.setText("Select an EU from the Right to remove");
                        ExecutionUnitPanel.this.lblExecutionUnitMessage.setForeground(Color.RED);
                        return;
                    }
                    AcmeGUI.getConfiguredExecutionUnitsDataModel().remove(idx);
                    ((DefaultListModel)ExecutionUnitPanel.this.lstConfiguredExecutionUnits.getModel()).remove(idx);
                    ExecutionUnitPanel.this.lblExecutionUnitMessage.setText("Removed OK");
                    ExecutionUnitPanel.this.lblExecutionUnitMessage.setForeground(Color.BLACK);
                }
            });
        }
        return this.btnRemoveEU;
    }

    private JList getLstConfiguredExecutionUnits() {
        if (this.lstConfiguredExecutionUnits == null) {
            this.lstConfiguredExecutionUnits = new JList();
            DefaultListModel model = new DefaultListModel();
            this.lstConfiguredExecutionUnits.setModel(model);
        }
        return this.lstConfiguredExecutionUnits;
    }

    private JScrollPane getSpConfiguredExecutionUnits() {
        if (this.spConfiguredExecutionUnits == null) {
            this.spConfiguredExecutionUnits = new JScrollPane();
            this.spConfiguredExecutionUnits.setBounds(new Rectangle(526, 20, 345, 467));
            this.spConfiguredExecutionUnits.setViewportView(this.getLstConfiguredExecutionUnits());
        }
        return this.spConfiguredExecutionUnits;
    }

    private JButton getBtnConfigureEU() {
        if (this.btnConfigureEU == null) {
            this.btnConfigureEU = new JButton();
            this.btnConfigureEU.setBounds(new Rectangle(632, 506, 147, 26));
            this.btnConfigureEU.setText("Configure Params");
            this.btnConfigureEU.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExecutionUnitConfigurationDecorator eu = (ExecutionUnitConfigurationDecorator)ExecutionUnitPanel.this.lstConfiguredExecutionUnits.getSelectedValue();
                    if (eu == null) {
                        ExecutionUnitPanel.this.lblExecutionUnitMessage.setText("select an EU from the right to configure.");
                        ExecutionUnitPanel.this.lblExecutionUnitMessage.setForeground(Color.RED);
                        return;
                    }
                    ExecutionUnitPanel.this.lblExecutionUnitMessage.setText("configure params...");
                    ExecutionUnitPanel.this.lblExecutionUnitMessage.setForeground(Color.BLACK);
                    PropertiesDialog pd = new PropertiesDialog(eu);
                    pd.setModal(true);
                    pd.setVisible(true);
                    ExecutionUnitPanel.this.lblExecutionUnitMessage.setText("");
                    ExecutionUnitPanel.this.lblExecutionUnitMessage.setForeground(Color.BLACK);
                }
            });
        }
        return this.btnConfigureEU;
    }

    private JTextField getTxtEURepeat() {
        if (this.txtEURepeat == null) {
            this.txtEURepeat = new JTextField();
            this.txtEURepeat.setToolTipText("This is the number of times to execute this EU before moving on to the next EU.");
            this.txtEURepeat.setBounds(new Rectangle(75, 82, 136, 20));
        }
        return this.txtEURepeat;
    }

    private JTextField getTxtEUDescription() {
        if (this.txtEUDescription == null) {
            this.txtEUDescription = new JTextField();
            this.txtEUDescription.setBounds(new Rectangle(111, 106, 311, 20));
        }
        return this.txtEUDescription;
    }
}

