/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.common.client.ui.gui;

import com.ibm.wssvt.acme.common.client.ui.gui.AcmeGUI;
import com.ibm.wssvt.acme.common.client.ui.gui.PropertiesDialog;
import com.ibm.wssvt.acme.common.client.ui.gui.RefreshableAcmeGuiPanel;
import com.ibm.wssvt.acme.common.client.ui.gui.model.ExceptionHandlerConfigurationDecorator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ExceptionHandlerPanel
extends JPanel
implements RefreshableAcmeGuiPanel {
    private static final long serialVersionUID = 1L;
    private JList lstTemplateExceptionHandlers = null;
    private JScrollPane spTemplateExceptionHandlers = null;
    private JLabel jLabel3 = null;
    private JTextField txtExceptionClassName = null;
    private JLabel jLabel4 = null;
    private JScrollPane spExceptionClassName = null;
    private JScrollPane spConfiguredExceptionHandlers = null;
    private JList lstConfiguredExceptionHandlers = null;
    private JButton btnAddExHandler = null;
    private JButton btnRemove = null;
    private JButton btnConfigureExHandler = null;
    private JLabel lblExHandlerMessage = null;

    public ExceptionHandlerPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setName("Exception Handlers");
        this.setSize(1076, 669);
        this.lblExHandlerMessage = new JLabel();
        this.lblExHandlerMessage.setBounds(new Rectangle(33, 469, 663, 16));
        this.lblExHandlerMessage.setForeground(new Color(255, 51, 51));
        this.lblExHandlerMessage.setText("");
        this.jLabel4 = new JLabel();
        this.jLabel4.setBounds(new Rectangle(17, 104, 128, 16));
        this.jLabel4.setText("Available Handlers");
        this.jLabel3 = new JLabel();
        this.jLabel3.setBounds(new Rectangle(10, 36, 111, 16));
        this.jLabel3.setText("Exception Class");
        this.setLayout(null);
        this.add((Component)this.getSpTemplateExceptionHandlers(), null);
        this.add((Component)this.jLabel3, null);
        this.add((Component)this.jLabel4, null);
        this.add((Component)this.getSpExceptionClassName(), null);
        this.add((Component)this.getSpConfiguredExceptionHandlers(), null);
        this.add((Component)this.getBtnAddExHandler(), null);
        this.add((Component)this.getBtnRemove(), null);
        this.add((Component)this.getBtnConfigureExHandler(), null);
        this.add((Component)this.lblExHandlerMessage, null);
        this.refresh();
    }

    @Override
    public void refresh() {
        DefaultListModel<ExceptionHandlerConfigurationDecorator> model = new DefaultListModel<ExceptionHandlerConfigurationDecorator>();
        this.lstTemplateExceptionHandlers.setModel(model);
        Iterator<ExceptionHandlerConfigurationDecorator> i = AcmeGUI.getTemplateExceptionHandlersDataModel().iterator();
        while (i.hasNext()) {
            model.addElement(i.next());
        }
        model = new DefaultListModel();
        this.lstConfiguredExceptionHandlers.setModel(model);
        for (int i2 = 0; i2 < AcmeGUI.getConfiguredExceptionHandlersDataModel().size(); ++i2) {
            model.addElement(AcmeGUI.getConfiguredExceptionHandlersDataModel().get(i2));
        }
    }

    private JList getLstTemplateExceptionHandlers() {
        if (this.lstTemplateExceptionHandlers == null) {
            this.lstTemplateExceptionHandlers = new JList();
            this.lstTemplateExceptionHandlers.setToolTipText("An exception handler specifies what action to take when an exception of a particular type is encountered.");
            this.lstTemplateExceptionHandlers.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    ExceptionHandlerConfigurationDecorator eh = (ExceptionHandlerConfigurationDecorator)ExceptionHandlerPanel.this.lstTemplateExceptionHandlers.getSelectedValue();
                    if (eh == null) {
                        return;
                    }
                    ExceptionHandlerPanel.this.txtExceptionClassName.setText(eh.getExceptionClassName());
                }
            });
        }
        return this.lstTemplateExceptionHandlers;
    }

    private JScrollPane getSpTemplateExceptionHandlers() {
        if (this.spTemplateExceptionHandlers == null) {
            this.spTemplateExceptionHandlers = new JScrollPane();
            this.spTemplateExceptionHandlers.setBounds(new Rectangle(31, 134, 207, 316));
            this.spTemplateExceptionHandlers.setViewportView(this.getLstTemplateExceptionHandlers());
        }
        return this.spTemplateExceptionHandlers;
    }

    private JTextField getTxtExceptionClassName() {
        if (this.txtExceptionClassName == null) {
            this.txtExceptionClassName = new JTextField();
            this.txtExceptionClassName.setToolTipText("This is the exception class (including package name) for which the selected handler will be used.  A wild card (*) may be used for class or package.");
        }
        return this.txtExceptionClassName;
    }

    private JScrollPane getSpExceptionClassName() {
        if (this.spExceptionClassName == null) {
            this.spExceptionClassName = new JScrollPane();
            this.spExceptionClassName.setBounds(new Rectangle(20, 56, 409, 37));
            this.spExceptionClassName.setViewportView(this.getTxtExceptionClassName());
        }
        return this.spExceptionClassName;
    }

    private JScrollPane getSpConfiguredExceptionHandlers() {
        if (this.spConfiguredExceptionHandlers == null) {
            this.spConfiguredExceptionHandlers = new JScrollPane();
            this.spConfiguredExceptionHandlers.setBounds(new Rectangle(481, 60, 216, 347));
            this.spConfiguredExceptionHandlers.setViewportView(this.getLstConfiguredExceptionHandlers());
        }
        return this.spConfiguredExceptionHandlers;
    }

    private JList getLstConfiguredExceptionHandlers() {
        if (this.lstConfiguredExceptionHandlers == null) {
            this.lstConfiguredExceptionHandlers = new JList();
        }
        return this.lstConfiguredExceptionHandlers;
    }

    private JButton getBtnAddExHandler() {
        if (this.btnAddExHandler == null) {
            this.btnAddExHandler = new JButton();
            this.btnAddExHandler.setBounds(new Rectangle(301, 154, 119, 26));
            this.btnAddExHandler.setText("Add --->");
            this.btnAddExHandler.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExceptionHandlerConfigurationDecorator eh = (ExceptionHandlerConfigurationDecorator)ExceptionHandlerPanel.this.lstTemplateExceptionHandlers.getSelectedValue();
                    if (eh == null) {
                        ExceptionHandlerPanel.this.lblExHandlerMessage.setText("Select an Exception Handler from the left first");
                        ExceptionHandlerPanel.this.lblExHandlerMessage.setForeground(Color.RED);
                        return;
                    }
                    if (ExceptionHandlerPanel.this.txtExceptionClassName.getText().trim().length() < 5) {
                        ExceptionHandlerPanel.this.lblExHandlerMessage.setText("provide at least 5 chars for the exception class name (like com.*)");
                        ExceptionHandlerPanel.this.lblExHandlerMessage.setForeground(Color.RED);
                        return;
                    }
                    ExceptionHandlerConfigurationDecorator copy = eh.clone();
                    copy.setExceptionClassName(ExceptionHandlerPanel.this.txtExceptionClassName.getText());
                    AcmeGUI.getConfiguredExceptionHandlersDataModel().add(copy);
                    ((DefaultListModel)ExceptionHandlerPanel.this.lstConfiguredExceptionHandlers.getModel()).addElement(copy);
                    ExceptionHandlerPanel.this.lblExHandlerMessage.setText("Added OK");
                    ExceptionHandlerPanel.this.lblExHandlerMessage.setForeground(Color.BLACK);
                }
            });
        }
        return this.btnAddExHandler;
    }

    private JButton getBtnRemove() {
        if (this.btnRemove == null) {
            this.btnRemove = new JButton();
            this.btnRemove.setBounds(new Rectangle(304, 216, 116, 29));
            this.btnRemove.setText("<--- Remove");
            this.btnRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExceptionHandlerConfigurationDecorator eh = (ExceptionHandlerConfigurationDecorator)ExceptionHandlerPanel.this.lstConfiguredExceptionHandlers.getSelectedValue();
                    int idx = ExceptionHandlerPanel.this.lstConfiguredExceptionHandlers.getSelectedIndex();
                    if (eh == null) {
                        ExceptionHandlerPanel.this.lblExHandlerMessage.setText("Select an Exception Handler from the Right to remove");
                        ExceptionHandlerPanel.this.lblExHandlerMessage.setForeground(Color.RED);
                        return;
                    }
                    AcmeGUI.getConfiguredExceptionHandlersDataModel().remove(idx);
                    ((DefaultListModel)ExceptionHandlerPanel.this.lstConfiguredExceptionHandlers.getModel()).remove(idx);
                    ExceptionHandlerPanel.this.lblExHandlerMessage.setText("Removed OK.");
                    ExceptionHandlerPanel.this.lblExHandlerMessage.setForeground(Color.BLACK);
                }
            });
        }
        return this.btnRemove;
    }

    private JButton getBtnConfigureExHandler() {
        if (this.btnConfigureExHandler == null) {
            this.btnConfigureExHandler = new JButton();
            this.btnConfigureExHandler.setBounds(new Rectangle(519, 419, 137, 28));
            this.btnConfigureExHandler.setText("Configure Params");
            this.btnConfigureExHandler.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExceptionHandlerConfigurationDecorator eh = (ExceptionHandlerConfigurationDecorator)ExceptionHandlerPanel.this.lstConfiguredExceptionHandlers.getSelectedValue();
                    if (eh == null) {
                        ExceptionHandlerPanel.this.lblExHandlerMessage.setText("Select a value from  the right to configure");
                        ExceptionHandlerPanel.this.lblExHandlerMessage.setForeground(Color.RED);
                        return;
                    }
                    ExceptionHandlerPanel.this.lblExHandlerMessage.setText("update params...");
                    ExceptionHandlerPanel.this.lblExHandlerMessage.setForeground(Color.BLACK);
                    PropertiesDialog pd = new PropertiesDialog(eh);
                    pd.setModal(true);
                    pd.setVisible(true);
                    ExceptionHandlerPanel.this.lblExHandlerMessage.setText("");
                }
            });
        }
        return this.btnConfigureExHandler;
    }
}

