/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.adapter;

import com.ibm.wssvt.acme.annuity.common.bean.IAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.bean.IContact;
import com.ibm.wssvt.acme.annuity.common.bean.IPayor;
import com.ibm.wssvt.acme.annuity.common.bean.IPayout;
import com.ibm.wssvt.acme.annuity.common.bean.IRider;
import com.ibm.wssvt.acme.annuity.common.business.IAnnuityService;
import com.ibm.wssvt.acme.annuity.common.client.adapter.IAnnuityServerAdapter;
import com.ibm.wssvt.acme.annuity.common.exception.EntityAlreadyExistsException;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.annuity.common.util.AnnuityLoggerFactory;
import com.ibm.wssvt.acme.common.adapter.AbstractServerAdapter;
import com.ibm.wssvt.acme.common.adapter.ServerAdapterCommunicationException;
import com.ibm.wssvt.acme.common.bean.Configrable;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import com.ibm.wssvt.acme.common.log.AcmeLoggerConfig;
import java.rmi.RemoteException;
import java.util.List;
import java.util.logging.Logger;

public abstract class AbstractAnnuityServerAdapter
extends AbstractServerAdapter
implements IAnnuityServerAdapter {
    private static final long serialVersionUID = 6826107504077969435L;

    protected AcmeLogger getLogger(String loggerName) {
        Logger root = Logger.getLogger(this.getClientContext().getPrefixedRootLoggerName());
        AcmeLoggerConfig.setClientFileNamePattern((String)"", (String)this.getClientContext().getClientId(), (int)this.getClientContext().getThreadId(), (Configrable)this);
        Logger theLogger = AnnuityLoggerFactory.getClientLogger(root, (Configrable<String, String>)this, this.getClientContext().getLoggerPrefix() + loggerName);
        return new AcmeLogger(theLogger);
    }

    @Override
    public IAnnuity createAnnuity(IAnnuity annuity) throws ServerAdapterCommunicationException, ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException, RemoteException {
        IAnnuityService service = this.getAnnuityService();
        this.getServerAdapterEvent().incrumentRequest();
        IAnnuity result = service.createAnnuity(annuity);
        this.getServerAdapterEvent().incrumentCreate();
        this.incrumentRunServerInfo(result);
        return result;
    }

    @Override
    public IAnnuity findAnnuityById(IAnnuity annuity) throws ServerAdapterCommunicationException, ServerInternalErrorException, EntityNotFoundException, InvalidArgumentException, RemoteException {
        IAnnuityService service = this.getAnnuityService();
        this.getServerAdapterEvent().incrumentRequest();
        IAnnuity result = service.findAnnuityById(annuity);
        this.getServerAdapterEvent().incrumentRead();
        this.incrumentRunServerInfo(result);
        return result;
    }

    @Override
    public void deleteAnnuityById(IAnnuity annuity) throws ServerAdapterCommunicationException, ServerInternalErrorException, EntityNotFoundException, InvalidArgumentException, RemoteException {
        IAnnuityService service = this.getAnnuityService();
        this.getServerAdapterEvent().incrumentRequest();
        service.deleteAnnuity(annuity);
        this.getServerAdapterEvent().incrumentDelete();
    }

    @Override
    public IAnnuity updateAnnuity(IAnnuity annuity) throws ServerAdapterCommunicationException, ServerInternalErrorException, EntityNotFoundException, InvalidArgumentException, RemoteException {
        IAnnuityService service = this.getAnnuityService();
        this.getServerAdapterEvent().incrumentRequest();
        IAnnuity result = service.updateAnnuity(annuity);
        this.getServerAdapterEvent().incrumentUpdate();
        this.incrumentRunServerInfo(result);
        return result;
    }

    @Override
    public IAnnuityHolder createAnnuityHolder(IAnnuityHolder annHolder) throws ServerAdapterCommunicationException, ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException, RemoteException {
        IAnnuityService service = this.getAnnuityService();
        this.getServerAdapterEvent().incrumentRequest();
        IAnnuityHolder result = service.createAnnuityHolder(annHolder);
        this.getServerAdapterEvent().incrumentCreate();
        this.incrumentRunServerInfo(result);
        return result;
    }

    @Override
    public IContact createContact(IContact contact) throws ServerAdapterCommunicationException, ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException, RemoteException {
        IAnnuityService service = this.getAnnuityService();
        this.getServerAdapterEvent().incrumentRequest();
        IContact result = service.createContact(contact);
        this.getServerAdapterEvent().incrumentCreate();
        this.incrumentRunServerInfo(result);
        return result;
    }

    @Override
    public IPayor createPayor(IPayor payor) throws ServerAdapterCommunicationException, ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException, RemoteException {
        IAnnuityService service = this.getAnnuityService();
        this.getServerAdapterEvent().incrumentRequest();
        IPayor result = service.createPayor(payor);
        this.getServerAdapterEvent().incrumentCreate();
        this.incrumentRunServerInfo(result);
        return result;
    }

    @Override
    public void deleteAnnuityHolder(IAnnuityHolder annHolder) throws ServerAdapterCommunicationException, ServerInternalErrorException, InvalidArgumentException, RemoteException {
        IAnnuityService service = this.getAnnuityService();
        this.getServerAdapterEvent().incrumentRequest();
        service.deleteAnnuityHolder(annHolder);
        this.getServerAdapterEvent().incrumentDelete();
    }

    @Override
    public void deleteContact(IContact contact) throws ServerAdapterCommunicationException, ServerInternalErrorException, InvalidArgumentException, RemoteException {
        IAnnuityService service = this.getAnnuityService();
        this.getServerAdapterEvent().incrumentRequest();
        service.deleteContact(contact);
        this.getServerAdapterEvent().incrumentDelete();
    }

    @Override
    public void deletePayor(IPayor payor) throws ServerAdapterCommunicationException, ServerInternalErrorException, InvalidArgumentException, RemoteException {
        IAnnuityService service = this.getAnnuityService();
        this.getServerAdapterEvent().incrumentRequest();
        service.deletePayor(payor);
        this.getServerAdapterEvent().incrumentDelete();
    }

    @Override
    public IAnnuityHolder findAnnuityHolder(IAnnuity annuity) throws ServerAdapterCommunicationException, EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException, RemoteException {
        IAnnuityService service = this.getAnnuityService();
        this.getServerAdapterEvent().incrumentRequest();
        IAnnuityHolder result = service.findAnnuityHolder(annuity);
        this.getServerAdapterEvent().incrumentRead();
        this.incrumentRunServerInfo(result);
        return result;
    }

    @Override
    public IContact findContactById(IContact contact) throws ServerAdapterCommunicationException, EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException, RemoteException {
        IAnnuityService service = this.getAnnuityService();
        this.getServerAdapterEvent().incrumentRequest();
        IContact result = service.findContactById(contact);
        this.getServerAdapterEvent().incrumentRead();
        this.incrumentRunServerInfo(result);
        return result;
    }

    @Override
    public List<IAnnuity> findHolderAnnuities(IAnnuityHolder annuityHolder) throws ServerAdapterCommunicationException, ServerInternalErrorException, InvalidArgumentException, RemoteException {
        IAnnuityService service = this.getAnnuityService();
        this.getServerAdapterEvent().incrumentRequest();
        List<IAnnuity> results = service.findHolderAnnuities(annuityHolder);
        this.getServerAdapterEvent().incrumentRead();
        return results;
    }

    @Override
    public IAnnuityHolder findHolderById(IAnnuityHolder annuityHolder) throws ServerAdapterCommunicationException, EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException, RemoteException {
        IAnnuityService service = this.getAnnuityService();
        this.getServerAdapterEvent().incrumentRequest();
        IAnnuityHolder result = service.findHolderById(annuityHolder);
        this.getServerAdapterEvent().incrumentRead();
        this.incrumentRunServerInfo(result);
        return result;
    }

    @Override
    public IAnnuityHolder updateAnnuityHolder(IAnnuityHolder annHolder) throws ServerAdapterCommunicationException, ServerInternalErrorException, InvalidArgumentException, RemoteException {
        IAnnuityService service = this.getAnnuityService();
        this.getServerAdapterEvent().incrumentRequest();
        IAnnuityHolder result = service.updateAnnuityHolder(annHolder);
        this.getServerAdapterEvent().incrumentUpdate();
        this.incrumentRunServerInfo(result);
        return result;
    }

    @Override
    public IContact updateContact(IContact contact) throws ServerAdapterCommunicationException, ServerInternalErrorException, InvalidArgumentException, RemoteException {
        IAnnuityService service = this.getAnnuityService();
        this.getServerAdapterEvent().incrumentRequest();
        IContact result = service.updateContact(contact);
        this.getServerAdapterEvent().incrumentUpdate();
        this.incrumentRunServerInfo(result);
        return result;
    }

    @Override
    public IPayor updatePayor(IPayor payor) throws ServerAdapterCommunicationException, ServerInternalErrorException, InvalidArgumentException, RemoteException {
        IAnnuityService service = this.getAnnuityService();
        this.getServerAdapterEvent().incrumentRequest();
        IPayor result = service.updatePayor(payor);
        this.getServerAdapterEvent().incrumentUpdate();
        this.incrumentRunServerInfo(result);
        return result;
    }

    @Override
    public IPayor findPayorById(IPayor payor) throws ServerAdapterCommunicationException, EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException, RemoteException {
        IAnnuityService service = this.getAnnuityService();
        this.getServerAdapterEvent().incrumentRequest();
        IPayor result = service.findPayorById(payor);
        this.getServerAdapterEvent().incrumentRead();
        this.incrumentRunServerInfo(result);
        return result;
    }

    @Override
    public IPayout findPayoutById(IPayout payout) throws ServerAdapterCommunicationException, EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException, RemoteException {
        IAnnuityService service = this.getAnnuityService();
        this.getServerAdapterEvent().incrumentRequest();
        IPayout result = service.findPayoutById(payout);
        this.getServerAdapterEvent().incrumentRead();
        this.incrumentRunServerInfo(result);
        return result;
    }

    @Override
    public IRider findRiderById(IRider rider) throws ServerAdapterCommunicationException, EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException, RemoteException {
        IAnnuityService service = this.getAnnuityService();
        this.getServerAdapterEvent().incrumentRequest();
        IRider result = service.findRiderById(rider);
        this.getServerAdapterEvent().incrumentRead();
        this.incrumentRunServerInfo(result);
        return result;
    }

    @Override
    public List<IAnnuity> findPayorAnnuities(IPayor payor) throws ServerAdapterCommunicationException, ServerInternalErrorException, InvalidArgumentException, RemoteException {
        IAnnuityService service = this.getAnnuityService();
        this.getServerAdapterEvent().incrumentRequest();
        List<IAnnuity> results = service.findPayorAnnuities(payor);
        this.getServerAdapterEvent().incrumentRead();
        return results;
    }

    @Override
    public IPayout createPayout(IPayout payout) throws ServerAdapterCommunicationException, ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException, RemoteException {
        IAnnuityService service = this.getAnnuityService();
        this.getServerAdapterEvent().incrumentRequest();
        IPayout result = service.createPayout(payout);
        this.getServerAdapterEvent().incrumentCreate();
        this.incrumentRunServerInfo(result);
        return result;
    }

    @Override
    public IPayout updatePayout(IPayout payout) throws ServerAdapterCommunicationException, ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException, RemoteException {
        IAnnuityService service = this.getAnnuityService();
        this.getServerAdapterEvent().incrumentRequest();
        IPayout result = service.updatePayout(payout);
        this.getServerAdapterEvent().incrumentUpdate();
        this.incrumentRunServerInfo(result);
        return result;
    }

    @Override
    public void deletePayout(IPayout payout) throws ServerAdapterCommunicationException, ServerInternalErrorException, InvalidArgumentException, RemoteException {
        IAnnuityService service = this.getAnnuityService();
        this.getServerAdapterEvent().incrumentRequest();
        service.deletePayout(payout);
        this.getServerAdapterEvent().incrumentDelete();
    }

    @Override
    public void deleteRider(IRider rider) throws ServerAdapterCommunicationException, ServerInternalErrorException, InvalidArgumentException, RemoteException {
        IAnnuityService service = this.getAnnuityService();
        this.getServerAdapterEvent().incrumentRequest();
        service.deleteRider(rider);
        this.getServerAdapterEvent().incrumentDelete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrumentRunServerInfo(Configrable<String, String> configrable) {
        if (configrable != null && configrable.getConfiguration() != null && configrable.getConfiguration().getParameterValue((Object)"internal.runningOnServerInfo") != null) {
            String[] servers = ((String)configrable.getConfiguration().getParameterValue((Object)"internal.runningOnServerInfo")).split(";;");
            this.getServerAdapterEvent().incrumentRunServerCount(servers[0]);
            for (int i = 0; i < servers.length; ++i) {
                this.getServerAdapterEvent().incrumentOverallRunServerCount(servers[i]);
            }
            Configrable<String, String> configrable2 = configrable;
            synchronized (configrable2) {
                configrable.getConfiguration().addParameter((Object)"internal.runningOnServerInfo", (Object)"");
            }
        }
    }

    protected abstract IAnnuityService getAnnuityService() throws ServerAdapterCommunicationException;
}

