/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit;

import com.ibm.wssvt.acme.annuity.common.bean.IAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.bean.IPayor;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.AbastractAnnuityExecutionUnit;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.BasicExecutionUnitLibrarry;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.ExecutionUnitVerificationHelper;
import com.ibm.wssvt.acme.annuity.common.exception.EntityAlreadyExistsException;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.annuity.common.util.ServerExceptionMapper;
import com.ibm.wssvt.acme.annuity.common.util.ServerExceptionType;
import com.ibm.wssvt.acme.common.adapter.ServerAdapterCommunicationException;
import com.ibm.wssvt.acme.common.executionunit.ExecutionUnitVerificationException;
import com.ibm.wssvt.acme.common.executionunit.IExecutionUnit;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class DeletePayorWODeletingFromAnnuityEU
extends AbastractAnnuityExecutionUnit {
    private static final long serialVersionUID = -4336074758814892669L;
    private String useId = null;
    private int startHolderId = 0;
    private int endHolderId = 0;
    private static final String USE_ID = "useId";
    private static final String START_ID = "startHolderId";
    private static final String END_ID = "endHolderId";
    AcmeLogger logger = null;

    public void execute() {
        this.setScenarioVariables();
        String sHolderId = null;
        String sAnnuityId = null;
        IAnnuityHolder annuityHolderReturn = null;
        IAnnuity returnAnnuity = null;
        List<Object> annuities = new ArrayList();
        if (this.useId == null && this.endHolderId == 0) {
            this.logger.severe("Scenario parameter error: Either useId or endHolderId must be set > 0 for scenario: " + this.getDescription() + ": failed to execute");
            InvalidArgumentException e = new InvalidArgumentException("Scenario parameter error: Either useId or endHolderId must be set > 0 for scenario");
            this.getExecutionUnitEvent().addException((Exception)((Object)e));
            return;
        }
        sHolderId = this.useId == null ? "" + (this.startHolderId + this.getRandomInteger(0, this.endHolderId - this.startHolderId)) : this.useId;
        this.logger.fine("Looking up holder id: " + sHolderId);
        try {
            annuityHolderReturn = this.findAnnuityHolder(sHolderId);
        }
        catch (Exception e) {
            this.logger.warning("Failed to find AnnuityHolder, Id = " + sHolderId + " Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        try {
            ExecutionUnitVerificationHelper.assertEquals((IExecutionUnit)this, (Comparable)((Object)sHolderId), (Comparable)annuityHolderReturn.getId(), "Returned Annuity Holder id is not equal to requested id", "Mismatch was found.");
        }
        catch (Exception e) {
            this.logger.info("Failed on verify find annuity holder. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        try {
            annuityHolderReturn.setConfiguration(this.getConfiguration());
            annuities = this.getServerAdapter().findHolderAnnuities(annuityHolderReturn);
            returnAnnuity = (IAnnuity)annuities.get(0);
        }
        catch (Exception e) {
            this.logger.warning("Failed to find list of annuities from holder Id = " + sHolderId + " Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        sAnnuityId = (String)returnAnnuity.getId();
        this.logger.fine("Found Annuity,  look for Payor link.");
        List<IPayor> payorsList = returnAnnuity.getPayors();
        if (payorsList == null) {
            this.logger.fine("This Annuity did not have any Payors, unable to continue");
            ExecutionUnitVerificationException e = new ExecutionUnitVerificationException("This Annuity did not have any Payors, unable to continue.");
            this.getExecutionUnitEvent().addException((Exception)((Object)e));
            return;
        }
        this.logger.fine(" AnnuityID:" + (String)returnAnnuity.getId() + " #payors: " + payorsList.size());
        for (IPayor payor : payorsList) {
            this.logger.fine("Validating - AnnuityID: " + (String)returnAnnuity.getId() + " payor: " + (String)payor.getId());
        }
        IPayor payorToDelete = payorsList.get(0);
        this.logger.fine("Try to delete the payor: " + (String)payorToDelete.getId());
        try {
            this.deletePayor(payorToDelete);
            this.logger.fine("No exception on delete of Payor, this is an error.");
            ExecutionUnitVerificationException e = new ExecutionUnitVerificationException("No exception on delete of Payor, this is an error.");
            this.getExecutionUnitEvent().addException((Exception)((Object)e));
            return;
        }
        catch (Exception e) {
            if (!ServerExceptionType.FOREIGN_KEY_VIOLATION_EXCEPTION.equals((Object)ServerExceptionMapper.getExceptionType(e))) {
                this.logger.info("Fail - got different exception on delete of payor, error: " + e);
                this.getExecutionUnitEvent().addException(e);
                return;
            }
            this.logger.fine("Success - got expected exception on delete of payor");
            this.logger.fine("Second lookup of Annuity id: " + sAnnuityId);
            try {
                returnAnnuity = this.findAnnuity(sAnnuityId);
            }
            catch (EntityNotFoundException e2) {
                this.logger.warning("Got a not found exception on second lookup of : " + sAnnuityId);
                this.getExecutionUnitEvent().addException((Exception)((Object)e2));
                return;
            }
            catch (Exception e1) {
                this.logger.warning("Unexpected exception on second lookup of , Id = " + sAnnuityId + " Error: " + e1);
                this.getExecutionUnitEvent().addException(e1);
                return;
            }
            this.logger.fine("Second time - Found Annuity,  look for Payor link.");
            payorsList = returnAnnuity.getPayors();
            if (payorsList == null) {
                this.logger.fine("Annuity did not have any Payors this time - error");
                ExecutionUnitVerificationException e3 = new ExecutionUnitVerificationException("This Annuity did not have any Payors after exception on delete of Payor");
                this.getExecutionUnitEvent().addException((Exception)((Object)e3));
                return;
            }
            this.logger.fine(" AnnuityID:" + (String)returnAnnuity.getId() + " #payors: " + payorsList.size());
            for (IPayor payor : payorsList) {
                this.logger.fine("Validating - AnnuityID: " + (String)returnAnnuity.getId() + " payor: " + (String)payor.getId());
            }
            IPayor payorToDelete2 = payorsList.get(0);
            try {
                ExecutionUnitVerificationHelper.assertEquals((IExecutionUnit)this, (Comparable)payorToDelete2.getId(), (Comparable)payorToDelete.getId(), "Exception from validating Payor ids after attempted delete ", "Mismatch was found.");
            }
            catch (ExecutionUnitVerificationException e4) {
                this.logger.fine("Exception from validating Payor ids after attempted delete - : " + (Object)((Object)e4));
                this.getExecutionUnitEvent().addException((Exception)((Object)e4));
                return;
            }
            this.logger.fine("Validation successful, Payor list the same after attempted delete.");
            return;
        }
    }

    private void setScenarioVariables() {
        this.logger = this.getLogger(((Object)((Object)this)).getClass().getName());
        try {
            this.useId = (String)this.getConfiguration().getParameterValue((Object)USE_ID);
            this.endHolderId = 0;
            this.startHolderId = 0;
        }
        catch (Exception e) {
            this.logger.fine("useId parameter not in config file, use random");
        }
        if (this.useId == null) {
            try {
                this.startHolderId = this.getParameterValueInt(START_ID);
            }
            catch (Exception e) {
                this.logger.fine("startHolderId parameter not in config file, use default startHolderId");
            }
            try {
                this.endHolderId = this.getParameterValueInt(END_ID);
            }
            catch (Exception e) {
                this.logger.fine("endHolderId parameter not in config file, use default endHolderId");
            }
        }
    }

    private IAnnuity findAnnuity(String id) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IAnnuity result = null;
        IAnnuity annuity = BasicExecutionUnitLibrarry.getBasicAnnuity(this.getAnnuityBeansFactory());
        annuity.setId(id);
        annuity.setConfiguration(this.getConfiguration());
        result = this.getServerAdapter().findAnnuityById(annuity);
        return result;
    }

    private void deletePayor(IPayor payor) throws EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IPayor removed = BasicExecutionUnitLibrarry.getPayor(this.getAnnuityBeansFactory());
        removed.setId(payor.getId());
        removed.setConfiguration(this.getConfiguration());
        this.getServerAdapter().deletePayor(removed);
    }

    private IAnnuityHolder findAnnuityHolder(String id) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IAnnuityHolder annuityHolder = null;
        annuityHolder = BasicExecutionUnitLibrarry.getAnnuityHolder(this.getAnnuityBeansFactory());
        annuityHolder.setId(id);
        annuityHolder.setConfiguration(this.getConfiguration());
        annuityHolder = this.getServerAdapter().findHolderById(annuityHolder);
        return annuityHolder;
    }
}

