/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit;

import com.ibm.wssvt.acme.annuity.common.bean.IAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.bean.IPayor;
import com.ibm.wssvt.acme.annuity.common.bean.IPayout;
import com.ibm.wssvt.acme.annuity.common.bean.IRider;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.AbastractAnnuityExecutionUnit;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.BasicExecutionUnitLibrarry;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.ExecutionUnitVerificationHelper;
import com.ibm.wssvt.acme.common.executionunit.IExecutionUnit;
import com.ibm.wssvt.acme.common.executionunit.InvalidExecutionUnitParameterException;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.util.Iterator;
import java.util.List;

public class ReadAllSystemDataEU
extends AbastractAnnuityExecutionUnit {
    private static final long serialVersionUID = -2363569260137693290L;
    private int startId = 0;
    private int idCount = 0;
    private int overRideIdint = 0;

    public void execute() {
        String sHolderId = null;
        IAnnuityHolder annuityHolder = null;
        IAnnuityHolder annuityHolderResults = null;
        AcmeLogger logger = this.getLogger(((Object)((Object)this)).getClass().getName());
        try {
            this.setAndVerifyScenarioParams(logger);
        }
        catch (Exception e) {
            logger.warning("Invalid scenario parameters for scenario description:" + this.getDescription() + "  Error is: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        for (int i = this.startId; i < this.startId + this.idCount; ++i) {
            try {
                sHolderId = Integer.toString(i);
                annuityHolder = BasicExecutionUnitLibrarry.getAnnuityHolder(this.getAnnuityBeansFactory());
                annuityHolder.setId(sHolderId);
            }
            catch (Exception e) {
                logger.severe("Setting up holder ID info: " + sHolderId + "Failed. Exception=" + e);
                this.getExecutionUnitEvent().addException(e);
                break;
            }
            try {
                logger.fine("Looking up holder ID: " + sHolderId);
                annuityHolder.setConfiguration(this.getConfiguration());
                annuityHolderResults = this.getServerAdapter().findHolderById(annuityHolder);
                logger.fine("Found holder ID: " + sHolderId);
            }
            catch (Exception e) {
                logger.severe("Looking for holder id: " + sHolderId + " Failed. Exception=" + e);
                this.getExecutionUnitEvent().addException(e);
                break;
            }
            try {
                ExecutionUnitVerificationHelper.assertEquals((IExecutionUnit)this, (Comparable)((Object)sHolderId), (Comparable)annuityHolderResults.getId(), " ERROR: requested holder id: " + sHolderId, " Retrieved holder id: " + (String)annuityHolderResults.getId());
                logger.fine("Validated holder ID: " + sHolderId);
            }
            catch (Exception e) {
                logger.severe("Validating holder ID: " + sHolderId + "Failed.");
                this.getExecutionUnitEvent().addException(e);
            }
            try {
                ExecutionUnitVerificationHelper.assertIdContains((IExecutionUnit)this, (String)annuityHolderResults.getContact().getId(), sHolderId, " ERROR: requested contact id: " + sHolderId, " Retrieved contact id: " + (String)annuityHolderResults.getContact().getId());
                logger.fine("Validated contact ID: " + (String)annuityHolderResults.getContact().getId());
            }
            catch (Exception e) {
                logger.severe("Validating contact ID: " + sHolderId + "Failed.");
                this.getExecutionUnitEvent().addException(e);
            }
            try {
                logger.fine("Validating person firstName: " + annuityHolderResults.getFirstName() + " for Holder ID: " + sHolderId);
                ExecutionUnitVerificationHelper.assertIdContains((IExecutionUnit)this, annuityHolderResults.getFirstName(), sHolderId, "ERROR: requested Holder FirstName: " + annuityHolderResults.getFirstName(), " postMsg-does not contain holder id: " + sHolderId);
                logger.fine("Validated person firstName: " + annuityHolder.getFirstName() + " for Holder ID: " + sHolderId);
            }
            catch (Exception e) {
                logger.severe("Validating person Firstname: " + annuityHolderResults.getFirstName() + " for sHolderId: " + sHolderId + " Failed.");
                this.getExecutionUnitEvent().addException(e);
            }
            List<IAnnuity> annuityListResults = null;
            try {
                logger.fine("Looking up annuities for holder ID: " + (String)annuityHolder.getId());
                annuityHolder.setConfiguration(this.getConfiguration());
                annuityListResults = this.getServerAdapter().findHolderAnnuities(annuityHolder);
                logger.fine("Looked up annuities for holder ID: " + (String)annuityHolder.getId());
            }
            catch (Exception e) {
                logger.severe("Error Holder ID: " + (String)annuityHolder.getId() + " failed finding annuities. Exception: " + e);
                this.getExecutionUnitEvent().addException(e);
            }
            if (annuityListResults != null) {
                logger.fine("HolderId: " + sHolderId + " has: " + annuityListResults.size() + " annuities");
                Iterator<IAnnuity> it = annuityListResults.iterator();
                while (it.hasNext()) {
                    try {
                        IAnnuity p = it.next();
                        logger.fine("HolderId: " + p.getAnnuityHolderId() + " Annuity ID: " + (String)p.getId());
                        ExecutionUnitVerificationHelper.assertIdContains((IExecutionUnit)this, p.getAnnuityHolderId(), sHolderId, "ERROR: requested annuity id: " + p.getAnnuityHolderId(), " does not contain holder id: " + sHolderId);
                        Iterator<IRider> itRider = p.getRiders().iterator();
                        logger.fine("HolderID: " + p.getAnnuityHolderId() + " AnnuityID: " + (String)p.getId() + " #riders: " + p.getRiders().size());
                        while (itRider.hasNext()) {
                            IRider rider = itRider.next();
                            logger.fine("Validating - HolderID: " + p.getAnnuityHolderId() + " AnnuityID: " + (String)p.getId() + " rider: " + (String)rider.getId());
                            ExecutionUnitVerificationHelper.assertIdContains((IExecutionUnit)this, (String)rider.getId(), sHolderId, "ERROR: requested rider id: " + (String)rider.getId(), " does not contain holder id: " + sHolderId);
                        }
                        Iterator<IPayor> itPayor = p.getPayors().iterator();
                        logger.fine("HolderID: " + p.getAnnuityHolderId() + " AnnuityID:" + (String)p.getId() + " #payors: " + p.getPayors().size());
                        while (itPayor.hasNext()) {
                            IPayor payor = itPayor.next();
                            logger.fine("Validating - HolderID: " + p.getAnnuityHolderId() + " AnnuityID: " + (String)p.getId() + " payor: " + (String)payor.getId());
                        }
                        Iterator<IPayout> itPayout = p.getPayouts().iterator();
                        logger.fine("HolderID: " + p.getAnnuityHolderId() + " AnnuityID:" + (String)p.getId() + " #payouts: " + p.getPayouts().size());
                        while (itPayout.hasNext()) {
                            IPayout payout = itPayout.next();
                            logger.fine("Validating - HolderID: " + p.getAnnuityHolderId() + " AnnuityID: " + (String)p.getId() + " payout: " + (String)payout.getId());
                            this.verbosePayoutTrace(p, payout, logger);
                            ExecutionUnitVerificationHelper.assertIdContains((IExecutionUnit)this, (String)payout.getId(), sHolderId, "ERROR: requested payout id: " + (String)payout.getId(), " does not contain holder id: " + sHolderId);
                        }
                    }
                    catch (Exception e) {
                        logger.severe("validating holder ID: " + sHolderId + " Failed for annuity: ");
                        this.getExecutionUnitEvent().addException(e);
                    }
                }
                continue;
            }
            logger.fine("Holder ID: " + sHolderId + " has 0 annuities");
        }
    }

    private void verbosePayoutTrace(IAnnuity annuity, IPayout payout, AcmeLogger logger) {
        logger.fine("annuityID=" + (String)annuity.getId() + " PayoutId=" + (String)payout.getId() + " payoutTax=" + payout.getTaxableAmount().toString() + " payoutEndDate=" + payout.getEndDate().toString() + " payoutStartDate=" + payout.getStartDate().toString() + " payoutLastupdateDate=" + payout.getLastUpdateDate().toString());
    }

    private void setAndVerifyScenarioParams(AcmeLogger logger) throws InvalidExecutionUnitParameterException {
        String START_ID_KEY = "startId";
        String ID_COUNT_KEY = "idCount";
        String OVERRIDE_ID_KEY = "overRideId";
        String RANDOM_READ_KEY = "randomRead";
        boolean randomRead = false;
        this.startId = this.getParameterValueInt("startId");
        this.idCount = this.getParameterValueInt("idCount");
        try {
            randomRead = this.getParameterValueBoolean("randomRead");
        }
        catch (InvalidExecutionUnitParameterException e) {
            logger.warning("the attribute: randomRead is missing for scenario: " + this.getDescription() + ".  Setting the default to false.");
            randomRead = false;
        }
        try {
            this.overRideIdint = this.getParameterValueInt("overRideId");
        }
        catch (Exception e) {
            logger.warning("the attribute:overRideId is missing for scenario: " + this.getDescription() + " .Setting the default to zero");
            this.overRideIdint = 0;
        }
        if (this.startId <= 0) {
            throw new InvalidExecutionUnitParameterException("startId is less or equal to 0.  Invalid value for scenario with description: " + this.getDescription() + ".  Value must be one or more.");
        }
        if (this.idCount <= 0) {
            throw new InvalidExecutionUnitParameterException("idCount is less or equal to 0.  Invalid value for scenario with description: " + this.getDescription() + ".  Value must be one or more.");
        }
        if (this.overRideIdint < 0) {
            throw new InvalidExecutionUnitParameterException("overRideId is less or equal to 0.  Invalid value for scenario with description: " + this.getDescription() + ".  Value must be one or more.");
        }
        if (randomRead) {
            this.overRideIdint = this.getRandomInteger(this.startId, this.startId + (this.idCount - 1));
        }
        if (this.overRideIdint > 0) {
            this.startId = this.overRideIdint;
            this.idCount = 1;
        }
    }
}

