/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.business.jaxrpc;

import com.ibm.wssvt.acme.annuity.common.bean.IAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.bean.IContact;
import com.ibm.wssvt.acme.annuity.common.bean.IPayor;
import com.ibm.wssvt.acme.annuity.common.bean.IPayout;
import com.ibm.wssvt.acme.annuity.common.bean.IRider;
import com.ibm.wssvt.acme.annuity.common.business.AnnuityBusinessServiceLookup;
import com.ibm.wssvt.acme.annuity.common.business.IAnnuityService;
import com.ibm.wssvt.acme.annuity.common.business.jaxrpc.AnnuityMgmtSvcJAXRPC;
import com.ibm.wssvt.acme.annuity.common.business.jaxrpc.bean.Annuity;
import com.ibm.wssvt.acme.annuity.common.business.jaxrpc.bean.AnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.business.jaxrpc.bean.AnnuityValueObject;
import com.ibm.wssvt.acme.annuity.common.business.jaxrpc.bean.Contact;
import com.ibm.wssvt.acme.annuity.common.business.jaxrpc.bean.Payor;
import com.ibm.wssvt.acme.annuity.common.business.jaxrpc.bean.PayoutValueObject;
import com.ibm.wssvt.acme.annuity.common.business.jaxrpc.bean.Rider;
import com.ibm.wssvt.acme.annuity.common.business.jaxrpc.beanconverter.JPABeanToJaxrpcBusinessBean;
import com.ibm.wssvt.acme.annuity.common.business.jaxrpc.beanconverter.JaxrpcBusinessBeanToJPABean;
import com.ibm.wssvt.acme.annuity.common.business.jaxrpc.exception.EntityAlreadyExistsException;
import com.ibm.wssvt.acme.annuity.common.business.jaxrpc.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.business.jaxrpc.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.business.jaxrpc.exception.ServerBusinessModuleException;
import com.ibm.wssvt.acme.annuity.common.business.jaxrpc.exception.ServerPersistenceModuleException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.annuity.common.util.AnnuityLoggerFactory;
import com.ibm.wssvt.acme.annuity.common.util.RunningServerInfo;
import com.ibm.wssvt.acme.common.bean.Configrable;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.rmi.RemoteException;
import java.util.List;

public class JAXRPCBusinessBaseProxy
implements AnnuityMgmtSvcJAXRPC {
    @Override
    public AnnuityValueObject createAnnuity(AnnuityValueObject annuityVO) throws EntityAlreadyExistsException, InvalidArgumentException, ServerPersistenceModuleException, ServerBusinessModuleException {
        this.checkAnnuityValueObject(annuityVO);
        IAnnuity jpaAnnuity = JaxrpcBusinessBeanToJPABean.getAnnuity(annuityVO.getAnnuityData());
        this.checkConfigrableArgument(jpaAnnuity);
        AcmeLogger logger = this.getLogger(jpaAnnuity);
        logger.finest("create annuity called. Annuity: " + jpaAnnuity);
        try {
            logger.finest("calling create on the EJB3 ");
            jpaAnnuity = this.getAnnuityService(jpaAnnuity).createAnnuity(jpaAnnuity);
            logger.finest("after call to create Annuity, EJB3 returned:" + jpaAnnuity);
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e), logger);
        }
        catch (com.ibm.wssvt.acme.annuity.common.exception.EntityAlreadyExistsException e) {
            throw new EntityAlreadyExistsException(e.getMessage() + logger.getAllLogs());
        }
        catch (com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException e) {
            throw new InvalidArgumentException(e.getMessage() + logger.getAllLogs());
        }
        RunningServerInfo.getInstance().setRunningServerInfo(jpaAnnuity);
        AnnuityValueObject result = new AnnuityValueObject();
        result.setAnnuity(JPABeanToJaxrpcBusinessBean.getAnnuity(jpaAnnuity));
        return result;
    }

    @Override
    public AnnuityHolder createAnnuityHolder(AnnuityHolder annHolder) throws EntityAlreadyExistsException, InvalidArgumentException, ServerPersistenceModuleException, ServerBusinessModuleException {
        IAnnuityHolder jpaAnnuityHolder = JaxrpcBusinessBeanToJPABean.getAnnuityHolder(annHolder);
        this.checkConfigrableArgument(jpaAnnuityHolder);
        AcmeLogger logger = this.getLogger(jpaAnnuityHolder);
        try {
            jpaAnnuityHolder = this.getAnnuityService(jpaAnnuityHolder).createAnnuityHolder(jpaAnnuityHolder);
        }
        catch (com.ibm.wssvt.acme.annuity.common.exception.EntityAlreadyExistsException e) {
            throw new EntityAlreadyExistsException(e.getMessage());
        }
        catch (com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException e) {
            throw new InvalidArgumentException(e.getMessage());
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e), logger);
        }
        RunningServerInfo.getInstance().setRunningServerInfo(jpaAnnuityHolder);
        return JPABeanToJaxrpcBusinessBean.getAnnuityHolder(jpaAnnuityHolder);
    }

    @Override
    public Contact createContact(Contact contact) throws EntityAlreadyExistsException, InvalidArgumentException, ServerPersistenceModuleException, ServerBusinessModuleException {
        IContact jpaContact = JaxrpcBusinessBeanToJPABean.getContact(contact);
        this.checkConfigrableArgument(jpaContact);
        AcmeLogger logger = this.getLogger(jpaContact);
        try {
            jpaContact = this.getAnnuityService(jpaContact).createContact(jpaContact);
        }
        catch (com.ibm.wssvt.acme.annuity.common.exception.EntityAlreadyExistsException e) {
            throw new EntityAlreadyExistsException(e.getMessage());
        }
        catch (com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException e) {
            throw new InvalidArgumentException(e.getMessage());
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e), logger);
        }
        RunningServerInfo.getInstance().setRunningServerInfo(jpaContact);
        return JPABeanToJaxrpcBusinessBean.getContact(jpaContact);
    }

    @Override
    public Payor createPayor(Payor payor) throws EntityAlreadyExistsException, InvalidArgumentException, ServerPersistenceModuleException, ServerBusinessModuleException {
        IPayor jpaPayor = JaxrpcBusinessBeanToJPABean.getPayor(payor);
        this.checkConfigrableArgument(jpaPayor);
        AcmeLogger logger = this.getLogger(jpaPayor);
        try {
            jpaPayor = this.getAnnuityService(jpaPayor).createPayor(jpaPayor);
        }
        catch (com.ibm.wssvt.acme.annuity.common.exception.EntityAlreadyExistsException e) {
            throw new EntityAlreadyExistsException(e.getMessage());
        }
        catch (com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException e) {
            throw new InvalidArgumentException(e.getMessage());
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e), logger);
        }
        RunningServerInfo.getInstance().setRunningServerInfo(jpaPayor);
        return JPABeanToJaxrpcBusinessBean.getPayor(jpaPayor);
    }

    @Override
    public PayoutValueObject createPayout(PayoutValueObject payoutVO) throws EntityAlreadyExistsException, InvalidArgumentException, ServerPersistenceModuleException, ServerBusinessModuleException {
        this.checkPayoutValueObject(payoutVO);
        IPayout jpaPayout = JaxrpcBusinessBeanToJPABean.getPayout(payoutVO.getPayoutData());
        this.checkConfigrableArgument(jpaPayout);
        AcmeLogger logger = this.getLogger(jpaPayout);
        try {
            jpaPayout = this.getAnnuityService(jpaPayout).createPayout(jpaPayout);
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e), logger);
        }
        catch (com.ibm.wssvt.acme.annuity.common.exception.EntityAlreadyExistsException e) {
            throw new EntityAlreadyExistsException(e.getMessage());
        }
        catch (com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException e) {
            throw new InvalidArgumentException(e.getMessage());
        }
        RunningServerInfo.getInstance().setRunningServerInfo(jpaPayout);
        PayoutValueObject result = new PayoutValueObject();
        result.setPayout(JPABeanToJaxrpcBusinessBean.getPayout(jpaPayout));
        return result;
    }

    @Override
    public void deleteAnnuity(AnnuityValueObject annuityVO) throws InvalidArgumentException, ServerPersistenceModuleException, ServerBusinessModuleException {
        this.checkAnnuityValueObject(annuityVO);
        IAnnuity annuity = JaxrpcBusinessBeanToJPABean.getAnnuity(annuityVO.getAnnuityData());
        this.checkConfigrableArgument(annuity);
        AcmeLogger logger = this.getLogger(annuity);
        try {
            this.getAnnuityService(annuity).deleteAnnuity(annuity);
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e), logger);
        }
        catch (com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException e) {
            throw new InvalidArgumentException(e.getMessage());
        }
    }

    @Override
    public void deleteAnnuityHolder(AnnuityHolder annHolder) throws InvalidArgumentException, ServerPersistenceModuleException, ServerBusinessModuleException {
        IAnnuityHolder jpaAnnuityHolder = JaxrpcBusinessBeanToJPABean.getAnnuityHolder(annHolder);
        this.checkConfigrableArgument(jpaAnnuityHolder);
        AcmeLogger logger = this.getLogger(jpaAnnuityHolder);
        try {
            this.getAnnuityService(jpaAnnuityHolder).deleteAnnuityHolder(jpaAnnuityHolder);
        }
        catch (com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException e) {
            throw new InvalidArgumentException(e.getMessage());
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e), logger);
        }
    }

    @Override
    public void deleteContact(Contact contact) throws InvalidArgumentException, ServerPersistenceModuleException, ServerBusinessModuleException {
        IContact jpaContact = JaxrpcBusinessBeanToJPABean.getContact(contact);
        this.checkConfigrableArgument(jpaContact);
        AcmeLogger logger = this.getLogger(jpaContact);
        try {
            this.getAnnuityService(jpaContact).deleteContact(jpaContact);
        }
        catch (com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException e) {
            throw new InvalidArgumentException(e.getMessage());
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e), logger);
        }
    }

    @Override
    public void deletePayor(Payor payor) throws InvalidArgumentException, ServerPersistenceModuleException, ServerBusinessModuleException {
        IPayor jpaPayor = JaxrpcBusinessBeanToJPABean.getPayor(payor);
        this.checkConfigrableArgument(jpaPayor);
        AcmeLogger logger = this.getLogger(jpaPayor);
        try {
            this.getAnnuityService(jpaPayor).deletePayor(jpaPayor);
        }
        catch (com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException e) {
            throw new InvalidArgumentException(e.getMessage());
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e), logger);
        }
    }

    @Override
    public void deletePayout(PayoutValueObject payoutVO) throws InvalidArgumentException, ServerPersistenceModuleException, ServerBusinessModuleException {
        this.checkPayoutValueObject(payoutVO);
        IPayout jpaPayout = JaxrpcBusinessBeanToJPABean.getPayout(payoutVO.getPayoutData());
        this.checkConfigrableArgument(jpaPayout);
        AcmeLogger logger = this.getLogger(jpaPayout);
        try {
            this.getAnnuityService(jpaPayout).deletePayout(jpaPayout);
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e), logger);
        }
        catch (com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException e) {
            throw new InvalidArgumentException(e.getMessage());
        }
    }

    @Override
    public void deleteRider(Rider rider) throws InvalidArgumentException, ServerPersistenceModuleException, ServerBusinessModuleException {
        IRider jpaRider = JaxrpcBusinessBeanToJPABean.getRider(rider);
        this.checkConfigrableArgument(jpaRider);
        AcmeLogger logger = this.getLogger(jpaRider);
        try {
            this.getAnnuityService(jpaRider).deleteRider(jpaRider);
        }
        catch (com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException e) {
            throw new InvalidArgumentException(e.getMessage());
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e), logger);
        }
    }

    @Override
    public AnnuityValueObject findAnnuityById(AnnuityValueObject annuityVO) throws EntityNotFoundException, InvalidArgumentException, ServerPersistenceModuleException, ServerBusinessModuleException {
        this.checkAnnuityValueObject(annuityVO);
        IAnnuity jpaAnnuity = JaxrpcBusinessBeanToJPABean.getAnnuity(annuityVO.getAnnuityData());
        this.checkConfigrableArgument(jpaAnnuity);
        AcmeLogger logger = this.getLogger(jpaAnnuity);
        logger.finest("finding the annuity by the ID: " + jpaAnnuity);
        try {
            logger.finest("calling find on the EJB3 ");
            jpaAnnuity = this.getAnnuityService(jpaAnnuity).findAnnuityById(jpaAnnuity);
            logger.finest("after call to Annuity, EJB3 returned:" + jpaAnnuity);
        }
        catch (com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException e) {
            throw new EntityNotFoundException(e.getMessage());
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e), logger);
        }
        catch (com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException e) {
            throw new InvalidArgumentException(e.getMessage() + logger.getAllLogs());
        }
        RunningServerInfo.getInstance().setRunningServerInfo(jpaAnnuity);
        AnnuityValueObject result = new AnnuityValueObject();
        result.setAnnuity(JPABeanToJaxrpcBusinessBean.getAnnuity(jpaAnnuity));
        return result;
    }

    @Override
    public AnnuityHolder findAnnuityHolder(AnnuityValueObject annuityVO) throws EntityNotFoundException, InvalidArgumentException, ServerPersistenceModuleException, ServerBusinessModuleException {
        IAnnuity jpaAnnuity = JaxrpcBusinessBeanToJPABean.getAnnuity(annuityVO.getAnnuityData());
        this.checkConfigrableArgument(jpaAnnuity);
        AcmeLogger logger = this.getLogger(jpaAnnuity);
        logger.finest("finding annuity holder: " + jpaAnnuity);
        IAnnuityHolder jpaAnnuityHolder = null;
        try {
            jpaAnnuityHolder = this.getAnnuityService(jpaAnnuity).findAnnuityHolder(jpaAnnuity);
        }
        catch (com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException e) {
            throw new EntityNotFoundException(e.getMessage());
        }
        catch (com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException e) {
            throw new InvalidArgumentException(e.getMessage());
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e), logger);
        }
        RunningServerInfo.getInstance().setRunningServerInfo(jpaAnnuityHolder);
        return JPABeanToJaxrpcBusinessBean.getAnnuityHolder(jpaAnnuityHolder);
    }

    @Override
    public Contact findContactById(Contact contact) throws EntityNotFoundException, InvalidArgumentException, ServerPersistenceModuleException, ServerBusinessModuleException {
        IContact jpaContact = JaxrpcBusinessBeanToJPABean.getContact(contact);
        this.checkConfigrableArgument(jpaContact);
        AcmeLogger logger = this.getLogger(jpaContact);
        try {
            jpaContact = this.getAnnuityService(jpaContact).findContactById(jpaContact);
        }
        catch (com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException e) {
            throw new EntityNotFoundException(e.getMessage());
        }
        catch (com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException e) {
            throw new InvalidArgumentException(e.getMessage());
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e), logger);
        }
        RunningServerInfo.getInstance().setRunningServerInfo(jpaContact);
        return JPABeanToJaxrpcBusinessBean.getContact(jpaContact);
    }

    @Override
    public AnnuityValueObject[] findHolderAnnuities(AnnuityHolder annuityHolder) throws InvalidArgumentException, ServerPersistenceModuleException, ServerBusinessModuleException {
        IAnnuityHolder jpaAnnuityHolder = JaxrpcBusinessBeanToJPABean.getAnnuityHolder(annuityHolder);
        this.checkConfigrableArgument(jpaAnnuityHolder);
        AcmeLogger logger = this.getLogger(jpaAnnuityHolder);
        List<IAnnuity> resultList = null;
        try {
            resultList = this.getAnnuityService(jpaAnnuityHolder).findHolderAnnuities(jpaAnnuityHolder);
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e), logger);
        }
        catch (com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException e) {
            throw new InvalidArgumentException(e.getMessage());
        }
        if (resultList == null) {
            return null;
        }
        AnnuityValueObject[] retArray = new AnnuityValueObject[resultList.size()];
        for (int i = 0; i < resultList.size(); ++i) {
            IAnnuity jpaAnnuity = resultList.get(i);
            RunningServerInfo.getInstance().setRunningServerInfo(jpaAnnuity);
            AnnuityValueObject annuityVo = new AnnuityValueObject();
            Annuity jaxrpcAnnuity = JPABeanToJaxrpcBusinessBean.getAnnuity(jpaAnnuity);
            annuityVo.setAnnuity(jaxrpcAnnuity);
            retArray[i] = annuityVo;
        }
        return retArray;
    }

    @Override
    public AnnuityHolder findHolderById(AnnuityHolder annuityHolder) throws EntityNotFoundException, InvalidArgumentException, ServerPersistenceModuleException, ServerBusinessModuleException {
        IAnnuityHolder jpaAnnuityHolder = JaxrpcBusinessBeanToJPABean.getAnnuityHolder(annuityHolder);
        this.checkConfigrableArgument(jpaAnnuityHolder);
        AcmeLogger logger = this.getLogger(jpaAnnuityHolder);
        try {
            jpaAnnuityHolder = this.getAnnuityService(jpaAnnuityHolder).findHolderById(jpaAnnuityHolder);
        }
        catch (com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException e) {
            throw new EntityNotFoundException(e.getMessage());
        }
        catch (com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException e) {
            throw new InvalidArgumentException(e.getMessage());
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e), logger);
        }
        RunningServerInfo.getInstance().setRunningServerInfo(jpaAnnuityHolder);
        return JPABeanToJaxrpcBusinessBean.getAnnuityHolder(jpaAnnuityHolder);
    }

    @Override
    public AnnuityValueObject[] findPayorAnnuities(Payor payor) throws InvalidArgumentException, ServerPersistenceModuleException, ServerBusinessModuleException {
        IPayor jpaPayor = JaxrpcBusinessBeanToJPABean.getPayor(payor);
        this.checkConfigrableArgument(jpaPayor);
        AcmeLogger logger = this.getLogger(jpaPayor);
        List<IAnnuity> resultList = null;
        try {
            resultList = this.getAnnuityService(jpaPayor).findPayorAnnuities(jpaPayor);
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e), logger);
        }
        catch (com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException e) {
            throw new InvalidArgumentException(e.getMessage());
        }
        if (resultList == null) {
            return null;
        }
        AnnuityValueObject[] retArray = new AnnuityValueObject[resultList.size()];
        for (int i = 0; i < resultList.size(); ++i) {
            IAnnuity jpaAnnuity = resultList.get(i);
            RunningServerInfo.getInstance().setRunningServerInfo(jpaAnnuity);
            AnnuityValueObject annuityVo = new AnnuityValueObject();
            Annuity jaxrpcAnnuity = JPABeanToJaxrpcBusinessBean.getAnnuity(jpaAnnuity);
            annuityVo.setAnnuity(jaxrpcAnnuity);
            retArray[i] = annuityVo;
        }
        return retArray;
    }

    @Override
    public Payor findPayorById(Payor payor) throws EntityNotFoundException, InvalidArgumentException, ServerPersistenceModuleException, ServerBusinessModuleException {
        IPayor jpaPayor = JaxrpcBusinessBeanToJPABean.getPayor(payor);
        this.checkConfigrableArgument(jpaPayor);
        AcmeLogger logger = this.getLogger(jpaPayor);
        try {
            jpaPayor = this.getAnnuityService(jpaPayor).findPayorById(jpaPayor);
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e), logger);
        }
        catch (com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException e) {
            throw new InvalidArgumentException(e.getMessage());
        }
        catch (com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException e) {
            throw new EntityNotFoundException(e.getMessage());
        }
        RunningServerInfo.getInstance().setRunningServerInfo(jpaPayor);
        return JPABeanToJaxrpcBusinessBean.getPayor(jpaPayor);
    }

    @Override
    public PayoutValueObject findPayoutById(PayoutValueObject payoutVO) throws EntityNotFoundException, InvalidArgumentException, ServerPersistenceModuleException, ServerBusinessModuleException {
        this.checkPayoutValueObject(payoutVO);
        IPayout jpaPayout = JaxrpcBusinessBeanToJPABean.getPayout(payoutVO.getPayoutData());
        this.checkConfigrableArgument(jpaPayout);
        AcmeLogger logger = this.getLogger(jpaPayout);
        try {
            jpaPayout = this.getAnnuityService(jpaPayout).findPayoutById(jpaPayout);
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e), logger);
        }
        catch (com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException e) {
            throw new EntityNotFoundException(e.getMessage());
        }
        catch (com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException e) {
            throw new InvalidArgumentException(e.getMessage());
        }
        RunningServerInfo.getInstance().setRunningServerInfo(jpaPayout);
        PayoutValueObject result = new PayoutValueObject();
        result.setPayout(JPABeanToJaxrpcBusinessBean.getPayout(jpaPayout));
        return result;
    }

    @Override
    public Rider findRiderById(Rider rider) throws EntityNotFoundException, InvalidArgumentException, ServerPersistenceModuleException, ServerBusinessModuleException {
        IRider jpaRider = JaxrpcBusinessBeanToJPABean.getRider(rider);
        this.checkConfigrableArgument(jpaRider);
        AcmeLogger logger = this.getLogger(jpaRider);
        try {
            jpaRider = this.getAnnuityService(jpaRider).findRiderById(jpaRider);
        }
        catch (com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException e) {
            throw new EntityNotFoundException(e.getMessage());
        }
        catch (com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException e) {
            throw new InvalidArgumentException(e.getMessage());
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e), logger);
        }
        RunningServerInfo.getInstance().setRunningServerInfo(jpaRider);
        return JPABeanToJaxrpcBusinessBean.getRider(jpaRider);
    }

    @Override
    public AnnuityValueObject updateAnnuity(AnnuityValueObject annuityVO) throws InvalidArgumentException, ServerPersistenceModuleException, ServerBusinessModuleException {
        this.checkAnnuityValueObject(annuityVO);
        IAnnuity jpaAnnuity = JaxrpcBusinessBeanToJPABean.getAnnuity(annuityVO.getAnnuityData());
        this.checkConfigrableArgument(jpaAnnuity);
        AcmeLogger logger = this.getLogger(jpaAnnuity);
        try {
            jpaAnnuity = this.getAnnuityService(jpaAnnuity).updateAnnuity(jpaAnnuity);
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e), logger);
        }
        catch (com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException e) {
            throw new InvalidArgumentException(e.getMessage());
        }
        RunningServerInfo.getInstance().setRunningServerInfo(jpaAnnuity);
        AnnuityValueObject result = new AnnuityValueObject();
        result.setAnnuity(JPABeanToJaxrpcBusinessBean.getAnnuity(jpaAnnuity));
        return result;
    }

    @Override
    public AnnuityHolder updateAnnuityHolder(AnnuityHolder annHolder) throws InvalidArgumentException, ServerPersistenceModuleException, ServerBusinessModuleException {
        IAnnuityHolder jpaAnnuityHolder = JaxrpcBusinessBeanToJPABean.getAnnuityHolder(annHolder);
        this.checkConfigrableArgument(jpaAnnuityHolder);
        AcmeLogger logger = this.getLogger(jpaAnnuityHolder);
        try {
            jpaAnnuityHolder = this.getAnnuityService(jpaAnnuityHolder).updateAnnuityHolder(jpaAnnuityHolder);
        }
        catch (com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException e) {
            throw new InvalidArgumentException(e.getMessage());
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e), logger);
        }
        RunningServerInfo.getInstance().setRunningServerInfo(jpaAnnuityHolder);
        return JPABeanToJaxrpcBusinessBean.getAnnuityHolder(jpaAnnuityHolder);
    }

    @Override
    public Contact updateContact(Contact contact) throws InvalidArgumentException, ServerPersistenceModuleException, ServerBusinessModuleException {
        IContact jpaContact = JaxrpcBusinessBeanToJPABean.getContact(contact);
        this.checkConfigrableArgument(jpaContact);
        AcmeLogger logger = this.getLogger(jpaContact);
        try {
            jpaContact = this.getAnnuityService(jpaContact).updateContact(jpaContact);
        }
        catch (com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException e) {
            throw new InvalidArgumentException(e.getMessage());
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e), logger);
        }
        RunningServerInfo.getInstance().setRunningServerInfo(jpaContact);
        return JPABeanToJaxrpcBusinessBean.getContact(jpaContact);
    }

    @Override
    public Payor updatePayor(Payor payor) throws InvalidArgumentException, ServerPersistenceModuleException, ServerBusinessModuleException {
        IPayor jpaPayor = JaxrpcBusinessBeanToJPABean.getPayor(payor);
        this.checkConfigrableArgument(jpaPayor);
        AcmeLogger logger = this.getLogger(jpaPayor);
        try {
            jpaPayor = this.getAnnuityService(jpaPayor).updatePayor(jpaPayor);
        }
        catch (com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException e) {
            throw new InvalidArgumentException(e.getMessage());
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e), logger);
        }
        RunningServerInfo.getInstance().setRunningServerInfo(jpaPayor);
        return JPABeanToJaxrpcBusinessBean.getPayor(jpaPayor);
    }

    @Override
    public PayoutValueObject updatePayout(PayoutValueObject payoutVO) throws InvalidArgumentException, ServerPersistenceModuleException, ServerBusinessModuleException {
        this.checkPayoutValueObject(payoutVO);
        IPayout jpaPayout = JaxrpcBusinessBeanToJPABean.getPayout(payoutVO.getPayoutData());
        this.checkConfigrableArgument(jpaPayout);
        AcmeLogger logger = this.getLogger(jpaPayout);
        try {
            jpaPayout = this.getAnnuityService(jpaPayout).updatePayout(jpaPayout);
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e), logger);
        }
        catch (com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException e) {
            throw new InvalidArgumentException(e.getMessage());
        }
        RunningServerInfo.getInstance().setRunningServerInfo(jpaPayout);
        PayoutValueObject result = new PayoutValueObject();
        result.setPayout(JPABeanToJaxrpcBusinessBean.getPayout(jpaPayout));
        return result;
    }

    private AcmeLogger getLogger(Configrable<String, String> configrable) {
        return AnnuityLoggerFactory.getAcmeServerLogger(configrable, this.getClass().getName());
    }

    private void checkConfigrableArgument(Configrable<String, String> configrable) throws InvalidArgumentException {
        if (configrable == null) {
            throw new InvalidArgumentException("The input parameter is invalid.  It null.");
        }
        if (configrable.getConfiguration() == null) {
            throw new InvalidArgumentException("The input parameter has null configuration. It is invalid.");
        }
    }

    private void checkAnnuityValueObject(AnnuityValueObject annuityVO) throws InvalidArgumentException {
        if (annuityVO == null) {
            throw new InvalidArgumentException("The AnnuityValueObject parameter is invalid.  It is null");
        }
        if (annuityVO.getAnnuityData() == null) {
            throw new InvalidArgumentException("The AnnuityValueObject contains no valid Annuity");
        }
    }

    private void checkPayoutValueObject(PayoutValueObject payoutVO) throws InvalidArgumentException {
        if (payoutVO == null) {
            throw new InvalidArgumentException("The PayoutValueObject parameter is invalid.  It is null");
        }
        if (payoutVO.getPayoutData() == null) {
            throw new InvalidArgumentException("The PayoutValueObject contains no valid Payout");
        }
    }

    private void convertServerException(Exception e, AcmeLogger logger) throws ServerPersistenceModuleException, ServerBusinessModuleException {
        if (e instanceof ServerInternalErrorException) {
            if (e instanceof ServerPersistenceModuleException) {
                throw new ServerPersistenceModuleException(e.getMessage() + logger.getAllLogs());
            }
            throw new ServerBusinessModuleException(e.getMessage());
        }
        if (e instanceof RemoteException) {
            throw new ServerBusinessModuleException("Remote Exception" + e.getMessage() + logger.getAllLogs());
        }
        throw new ServerBusinessModuleException("Unknown Server Exception: " + e.getMessage() + logger.getAllLogs());
    }

    protected IAnnuityService getAnnuityService(Configrable<String, String> configrable) throws ServerBusinessModuleException {
        try {
            return new AnnuityBusinessServiceLookup().getAnnuityAnnuityService(configrable);
        }
        catch (Exception e) {
            throw new ServerBusinessModuleException(e.getMessage());
        }
    }
}

