/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.adapter;

import com.ibm.wssvt.acme.annuity.common.bean.IConfigData;
import com.ibm.wssvt.acme.annuity.common.business.IAnnuitySingletonService;
import com.ibm.wssvt.acme.annuity.common.client.adapter.ISingletonServerAdapter;
import com.ibm.wssvt.acme.annuity.common.exception.EntityAlreadyExistsException;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.annuity.common.util.AnnuityLoggerFactory;
import com.ibm.wssvt.acme.common.adapter.AbstractServerAdapter;
import com.ibm.wssvt.acme.common.adapter.ServerAdapterCommunicationException;
import com.ibm.wssvt.acme.common.bean.Configrable;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import com.ibm.wssvt.acme.common.log.AcmeLoggerConfig;
import java.rmi.RemoteException;
import java.util.logging.Logger;

public abstract class AbstractSingletonServerAdapter
extends AbstractServerAdapter
implements ISingletonServerAdapter {
    private static final long serialVersionUID = 6826107504077969435L;

    protected AcmeLogger getLogger(String loggerName) {
        Logger root = Logger.getLogger(this.getClientContext().getPrefixedRootLoggerName());
        AcmeLoggerConfig.setClientFileNamePattern((String)"", (String)this.getClientContext().getClientId(), (int)this.getClientContext().getThreadId(), (Configrable)this);
        Logger theLogger = AnnuityLoggerFactory.getClientLogger(root, (Configrable<String, String>)this, this.getClientContext().getLoggerPrefix() + loggerName);
        return new AcmeLogger(theLogger);
    }

    @Override
    public void updateConfigDataInDB(IConfigData configData) throws InvalidArgumentException, ServerInternalErrorException, ServerAdapterCommunicationException {
        IAnnuitySingletonService service = this.getAnnuityService();
        this.getServerAdapterEvent().incrumentRequest();
        service.updateConfigDataInDB(configData);
        this.incrumentRunServerInfo(configData);
        this.getServerAdapterEvent().incrumentUpdate();
        this.incrumentRunServerInfo(configData);
    }

    @Override
    public void refreshConfigDataFromDB() throws EntityNotFoundException, InvalidArgumentException, ServerInternalErrorException, ServerAdapterCommunicationException {
        IAnnuitySingletonService service = this.getAnnuityService();
        this.getServerAdapterEvent().incrumentRequest();
        service.refreshConfigDataFromDB();
        this.getServerAdapterEvent().incrumentRead();
    }

    @Override
    public IConfigData getServerConfigData(Configrable<String, String> configuration) throws ServerAdapterCommunicationException {
        IAnnuitySingletonService service = this.getAnnuityService();
        this.getServerAdapterEvent().incrumentRequest();
        IConfigData result = service.getServerConfigData(configuration);
        this.getServerAdapterEvent().incrumentRead();
        this.incrumentRunServerInfo(result);
        return result;
    }

    @Override
    public void testReadConcurrency(IConfigData configData) throws ServerAdapterCommunicationException {
        IAnnuitySingletonService service = this.getAnnuityService();
        this.getServerAdapterEvent().incrumentRequest();
        service.testReadConcurrency(configData);
        this.getServerAdapterEvent().incrumentRead();
        this.incrumentRunServerInfo(configData);
    }

    @Override
    public void testWriteConcurrency(IConfigData configData) throws ServerAdapterCommunicationException {
        IAnnuitySingletonService service = this.getAnnuityService();
        this.getServerAdapterEvent().incrumentRequest();
        service.testWriteConcurrency(configData);
        this.getServerAdapterEvent().incrumentUpdate();
        this.incrumentRunServerInfo(configData);
    }

    @Override
    public void setServerConfigData(IConfigData configData) throws ServerAdapterCommunicationException {
        IAnnuitySingletonService service = this.getAnnuityService();
        this.getServerAdapterEvent().incrumentRequest();
        service.setServerConfigData(configData);
        this.getServerAdapterEvent().incrumentUpdate();
        this.incrumentRunServerInfo(configData);
    }

    @Override
    public IConfigData createConfigData(IConfigData configData) throws ServerAdapterCommunicationException, ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException, RemoteException {
        IAnnuitySingletonService service = this.getAnnuityService();
        this.getServerAdapterEvent().incrumentRequest();
        IConfigData result = service.createConfigData(configData);
        this.getServerAdapterEvent().incrumentCreate();
        this.incrumentRunServerInfo(result);
        return result;
    }

    @Override
    public IConfigData updateConfigData(IConfigData configData) throws ServerAdapterCommunicationException, ServerInternalErrorException, InvalidArgumentException, RemoteException {
        IAnnuitySingletonService service = this.getAnnuityService();
        this.getServerAdapterEvent().incrumentRequest();
        IConfigData result = service.updateConfigData(configData);
        this.getServerAdapterEvent().incrumentUpdate();
        this.incrumentRunServerInfo(result);
        return result;
    }

    @Override
    public void deleteConfigData(IConfigData configData) throws ServerAdapterCommunicationException, ServerInternalErrorException, InvalidArgumentException, RemoteException {
        IAnnuitySingletonService service = this.getAnnuityService();
        this.getServerAdapterEvent().incrumentRequest();
        service.deleteConfigData(configData);
        this.getServerAdapterEvent().incrumentDelete();
    }

    @Override
    public IConfigData findConfigDataById(IConfigData configData) throws ServerAdapterCommunicationException, EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException, RemoteException {
        IAnnuitySingletonService service = this.getAnnuityService();
        this.getServerAdapterEvent().incrumentRequest();
        IConfigData result = service.findConfigDataById(configData);
        this.getServerAdapterEvent().incrumentRead();
        this.incrumentRunServerInfo(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrumentRunServerInfo(Configrable<String, String> configrable) {
        if (configrable != null && configrable.getConfiguration() != null) {
            if (configrable.getConfiguration().getParameterValue((Object)"internal.runningOnServerInfo") != null) {
                String[] servers = ((String)configrable.getConfiguration().getParameterValue((Object)"internal.runningOnServerInfo")).split(";;");
                this.getServerAdapterEvent().incrumentRunServerCount(servers[0]);
                for (int i = 0; i < servers.length; ++i) {
                    this.getServerAdapterEvent().incrumentOverallRunServerCount(servers[i]);
                }
            }
            Configrable<String, String> configrable2 = configrable;
            synchronized (configrable2) {
                configrable.getConfiguration().addParameter((Object)"internal.runningOnServerInfo", (Object)"");
            }
        }
    }

    protected abstract IAnnuitySingletonService getAnnuityService() throws ServerAdapterCommunicationException;
}

