/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit;

import com.ibm.wssvt.acme.annuity.common.bean.IAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IEquityAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IFixedAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IPayor;
import com.ibm.wssvt.acme.annuity.common.bean.IPayout;
import com.ibm.wssvt.acme.annuity.common.bean.IRider;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.AbastractAnnuityExecutionUnit;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.AsynchMethodHelper;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.BasicExecutionUnitLibrarry;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.ExecutionUnitVerificationHelper;
import com.ibm.wssvt.acme.annuity.common.exception.EntityAlreadyExistsException;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.annuity.common.util.AnnuityType;
import com.ibm.wssvt.acme.common.adapter.ServerAdapterCommunicationException;
import com.ibm.wssvt.acme.common.executionunit.ExecutionUnitVerificationException;
import com.ibm.wssvt.acme.common.executionunit.IExecutionUnit;
import com.ibm.wssvt.acme.common.executionunit.InvalidExecutionUnitParameterException;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;

public class CRUDAnnuityRiderPayoutPayorEU
extends AbastractAnnuityExecutionUnit {
    private static final long serialVersionUID = -8980124038714550844L;
    private AcmeLogger logger;

    public void execute() {
        try {
            this.setScenarioVariables();
        }
        catch (Exception e) {
            this.logger.warning("Failed to get correct parameters. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.info("Creating Annuity with Rider");
        IAnnuity annuity = null;
        AnnuityType annuityType = this.getRandomEnum(AnnuityType.class);
        try {
            annuity = this.createAnnuityWithRider(annuityType);
        }
        catch (Exception e) {
            this.logger.warning("Failed to create annuity with rider. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.info("Verifying Annuity with Rider");
        try {
            this.verifyAnnuityValues(annuity, annuityType);
        }
        catch (Exception e) {
            this.logger.warning("Failed to verify create annuity with rider. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
        this.logger.info("Updating Annuity with Rider");
        try {
            annuity = this.updateAnnuityWithRider(annuity);
        }
        catch (Exception e) {
            this.logger.warning("Failed to update annuity with rider. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.info("Verifying Annuity with Rider");
        try {
            this.verifyAnnuityValues(annuity, annuityType);
        }
        catch (Exception e) {
            this.logger.warning("Failed to verify update annuity with rider. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
        this.logger.info("Deleting Annuity with Rider");
        try {
            this.deleteAnnuityWithRider(annuity);
        }
        catch (Exception e) {
            this.logger.warning("Failed to delete annuity with rider. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.info("Verifying Annuity with Rider");
        try {
            this.verifyDeleteAnnuity(annuity, annuityType);
        }
        catch (Exception e) {
            this.logger.warning("Failed to verify delete annuity with rider. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
        this.logger.info("Creating Annuity with Payout");
        try {
            annuity = this.createAnnuityWithPayout(annuityType);
        }
        catch (Exception e) {
            this.logger.warning("Failed to create annuity with Payout. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.info("Verifying Annuity with Payout");
        try {
            this.verifyAnnuityValues(annuity, annuityType);
        }
        catch (Exception e) {
            this.logger.warning("Failed to verify create annuity with Payout. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
        this.logger.info("Updating Annuity with Payout");
        try {
            annuity = this.updateAnnuityWithPayout(annuity);
        }
        catch (Exception e) {
            this.logger.warning("Failed to update annuity with Payout. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.info("Verifying Annuity with Payout");
        try {
            this.verifyAnnuityValues(annuity, annuityType);
        }
        catch (Exception e) {
            this.logger.warning("Failed to verify update annuity with Payout. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
        this.logger.info("Deleting Annuity with Payout");
        try {
            this.deleteAnnuityWithPayout(annuity);
        }
        catch (Exception e) {
            this.logger.warning("Failed to delete annuity with Payout. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.info("Verifying Annuity with Payout");
        try {
            this.verifyDeleteAnnuity(annuity, annuityType);
        }
        catch (Exception e) {
            this.logger.warning("Failed to verify delete annuity with Payout. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
        this.logger.fine("Creating Payor");
        IPayor payor = null;
        try {
            payor = this.createPayor();
        }
        catch (Exception e) {
            this.logger.warning("Failed to create Payor. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.fine("Verifying Create Payor");
        try {
            this.verifyCreatePayor(payor);
        }
        catch (Exception e) {
            this.logger.info("Create Payor verification failed.  Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
        this.logger.info("Creating Annuity with Payor");
        try {
            annuity = this.createAnnuityWithPayor(annuityType, payor);
        }
        catch (Exception e) {
            this.logger.warning("Failed to create annuity with payor. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.info("Verifying Annuity with Payor");
        try {
            this.verifyAnnuityValues(annuity, annuityType);
        }
        catch (Exception e) {
            this.logger.info("Failed to verify create annuity with payor. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
        this.logger.info("Updating Annuity with Payor");
        try {
            annuity = this.updateAnnuityWithPayor(annuity);
        }
        catch (Exception e) {
            this.logger.warning("Failed to update annuity with Payor. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.info("Verifying Annuity with Payor");
        try {
            this.verifyAnnuityValues(annuity, annuityType);
        }
        catch (Exception e) {
            this.logger.warning("Failed to verify update annuity with Payor. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
        this.logger.info("Deleting Annuity with Payor");
        try {
            this.deleteAnnuityWithPayor(annuity);
        }
        catch (Exception e) {
            this.logger.warning("Failed to delete annuity with Payor. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        this.logger.info("Verifying Annuity with Payor");
        try {
            this.verifyDeleteAnnuity(annuity, annuityType);
        }
        catch (Exception e) {
            this.logger.warning("Failed to verify delete annuity with Payor. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
        }
    }

    private void setScenarioVariables() throws InvalidExecutionUnitParameterException {
        this.logger = this.getLogger(((Object)((Object)this)).getClass().getName());
    }

    private IPayor createPayor() throws EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IPayor payor = BasicExecutionUnitLibrarry.getPayor(this.getAnnuityBeansFactory());
        payor.setConfiguration(this.getConfiguration());
        payor = this.getServerAdapter().createPayor(payor);
        return payor;
    }

    private void verifyCreatePayor(IPayor payor) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        IPayor results = this.getAnnuityBeansFactory().createPayor();
        results.setId(payor.getId());
        results.setConfiguration(this.getConfiguration());
        results = this.getServerAdapter().findPayorById(results);
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, payor, results, "Payor from client is not equal to DB value", "Payor Create mismacth was found.");
    }

    private IAnnuity createAnnuityWithRider(AnnuityType annuityType) throws EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IAnnuity annuity = BasicExecutionUnitLibrarry.getAnnuity(this.getAnnuityBeansFactory(), annuityType);
        IRider rider = BasicExecutionUnitLibrarry.getRider(this.getAnnuityBeansFactory());
        annuity.getRiders().add(rider);
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().createAnnuity(annuity);
        return annuity;
    }

    private IAnnuity updateAnnuityWithRider(IAnnuity annuity) throws EntityNotFoundException, EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IRider rider2 = BasicExecutionUnitLibrarry.getRider(this.getAnnuityBeansFactory());
        annuity.getRiders().add(rider2);
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().updateAnnuity(annuity);
        IRider rider1 = annuity.getRiders().get(0);
        annuity.getRiders().remove(0);
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().updateAnnuity(annuity);
        IRider removed = BasicExecutionUnitLibrarry.getRider(this.getAnnuityBeansFactory());
        removed.setId(rider1.getId());
        removed.setConfiguration(this.getConfiguration());
        this.getServerAdapter().deleteRider(removed);
        IRider rider3 = BasicExecutionUnitLibrarry.getRider(this.getAnnuityBeansFactory());
        annuity.getRiders().add(rider3);
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().updateAnnuity(annuity);
        annuity.getRiders().get(0).setRule("updated rule");
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().updateAnnuity(annuity);
        return annuity;
    }

    private void deleteAnnuityWithRider(IAnnuity annuity) throws EntityNotFoundException, EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        ArrayList riderIds = new ArrayList();
        for (IRider rider : annuity.getRiders()) {
            riderIds.add(rider.getId());
        }
        annuity.getRiders().clear();
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().updateAnnuity(annuity);
        IRider removed = BasicExecutionUnitLibrarry.getRider(this.getAnnuityBeansFactory());
        for (String id : riderIds) {
            removed.setId(id);
            removed.setConfiguration(this.getConfiguration());
            this.getServerAdapter().deleteRider(removed);
        }
        annuity.setConfiguration(this.getConfiguration());
        this.getServerAdapter().deleteAnnuityById(annuity);
    }

    private IAnnuity createAnnuityWithPayout(AnnuityType annuityType) throws EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IAnnuity annuity = BasicExecutionUnitLibrarry.getAnnuity(this.getAnnuityBeansFactory(), annuityType);
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().createAnnuity(annuity);
        IPayout payout = BasicExecutionUnitLibrarry.getPayout(this.getAnnuityBeansFactory());
        payout.setAnnuity(annuity);
        payout.setConfiguration(this.getConfiguration());
        payout = this.getServerAdapter().createPayout(payout);
        annuity.getPayouts().add(payout);
        return annuity;
    }

    private IAnnuity updateAnnuityWithPayout(IAnnuity annuity) throws EntityNotFoundException, EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IPayout payout1 = annuity.getPayouts().get(0);
        IPayout payout2 = BasicExecutionUnitLibrarry.getPayout(this.getAnnuityBeansFactory());
        payout2.setAnnuity(annuity);
        payout2.setConfiguration(this.getConfiguration());
        payout2 = this.getServerAdapter().createPayout(payout2);
        annuity.getPayouts().add(payout2);
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().updateAnnuity(annuity);
        annuity.getPayouts().remove(0);
        payout1.setConfiguration(this.getConfiguration());
        this.getServerAdapter().deletePayout(payout1);
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().updateAnnuity(annuity);
        IPayout payout3 = BasicExecutionUnitLibrarry.getPayout(this.getAnnuityBeansFactory());
        payout3.setAnnuity(annuity);
        payout3.setConfiguration(this.getConfiguration());
        payout3 = this.getServerAdapter().createPayout(payout3);
        annuity.getPayouts().add(payout3);
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().updateAnnuity(annuity);
        GregorianCalendar newEndDate = new GregorianCalendar();
        ((Calendar)newEndDate).add(2, 11);
        IPayout updatePayout = annuity.getPayouts().get(0);
        updatePayout.setEndDate(newEndDate);
        updatePayout.setAnnuity(annuity);
        updatePayout.setConfiguration(this.getConfiguration());
        updatePayout = this.getServerAdapter().updatePayout(updatePayout);
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().updateAnnuity(annuity);
        return annuity;
    }

    private void deleteAnnuityWithPayout(IAnnuity annuity) throws EntityNotFoundException, EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        List<IPayout> payouts = annuity.getPayouts();
        for (IPayout payout : payouts) {
            payout.setConfiguration(this.getConfiguration());
            this.getServerAdapter().deletePayout(payout);
        }
        annuity.setConfiguration(this.getConfiguration());
        this.getServerAdapter().deleteAnnuityById(annuity);
    }

    private IAnnuity createAnnuityWithPayor(AnnuityType annuityType, IPayor payor) throws EntityNotFoundException, EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IAnnuity annuity = BasicExecutionUnitLibrarry.getAnnuity(this.getAnnuityBeansFactory(), annuityType);
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().createAnnuity(annuity);
        annuity.getPayors().add(payor);
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().updateAnnuity(annuity);
        return annuity;
    }

    private IAnnuity updateAnnuityWithPayor(IAnnuity annuity) throws EntityNotFoundException, EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IPayor payor2 = BasicExecutionUnitLibrarry.getPayor(this.getAnnuityBeansFactory());
        payor2.setConfiguration(this.getConfiguration());
        payor2 = this.getServerAdapter().createPayor(payor2);
        annuity.getPayors().add(payor2);
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().updateAnnuity(annuity);
        IPayor payor1 = annuity.getPayors().get(0);
        annuity.getPayors().remove(0);
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().updateAnnuity(annuity);
        payor1.setConfiguration(this.getConfiguration());
        this.getServerAdapter().deletePayor(payor1);
        IPayor payor3 = BasicExecutionUnitLibrarry.getPayor(this.getAnnuityBeansFactory());
        payor3.setConfiguration(this.getConfiguration());
        payor3 = this.getServerAdapter().createPayor(payor3);
        annuity.getPayors().add(payor3);
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().updateAnnuity(annuity);
        IPayor updatePayor = annuity.getPayors().get(0);
        updatePayor.setName("updated name");
        updatePayor.setConfiguration(this.getConfiguration());
        updatePayor = this.getServerAdapter().updatePayor(updatePayor);
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().updateAnnuity(annuity);
        return annuity;
    }

    private void deleteAnnuityWithPayor(IAnnuity annuity) throws EntityNotFoundException, EntityAlreadyExistsException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        ArrayList payorIds = new ArrayList();
        for (IPayor payor : annuity.getPayors()) {
            payorIds.add(payor.getId());
        }
        annuity.getPayors().clear();
        annuity.setConfiguration(this.getConfiguration());
        annuity = this.getServerAdapter().updateAnnuity(annuity);
        IPayor removed = BasicExecutionUnitLibrarry.getPayor(this.getAnnuityBeansFactory());
        for (String id : payorIds) {
            removed.setId(id);
            removed.setConfiguration(this.getConfiguration());
            this.getServerAdapter().deletePayor(removed);
        }
        annuity.setConfiguration(this.getConfiguration());
        this.getServerAdapter().deleteAnnuityById(annuity);
    }

    private void verifyAnnuityValues(IAnnuity annuity, AnnuityType annuityType) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        int i;
        IAnnuity results = null;
        if (AnnuityType.BASIC.equals((Object)annuityType)) {
            results = this.getAnnuityBeansFactory().createAnnuity();
        }
        if (AnnuityType.EQUITY.equals((Object)annuityType)) {
            results = this.getAnnuityBeansFactory().createAnnEquity();
        }
        if (AnnuityType.FIXED.equals((Object)annuityType)) {
            results = this.getAnnuityBeansFactory().createAnnFixed();
        }
        results.setId(annuity.getId());
        results.setConfiguration(this.getConfiguration());
        results = this.getServerAdapter().findAnnuityById(results);
        if (annuity instanceof IFixedAnnuity) {
            ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, (IFixedAnnuity)annuity, (IFixedAnnuity)results, "Fixed Annuity from Client is not equal to DB value", "Mismacth was found.");
        } else if (annuity instanceof IEquityAnnuity) {
            ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, (IEquityAnnuity)annuity, (IEquityAnnuity)results, "Equity Annuity from Client is not equal to DB value", "Mismacth was found.");
        } else {
            ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, annuity, results, "Basic Annuity from Client is not equal to DB value", "Mismacth was found.");
        }
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, annuity.getPayouts(), results.getPayouts(), "Annuity payouts from Client is not equal to DB value", "Mismacth was found in number of payouts");
        boolean found = false;
        if (annuity.getPayouts() != null) {
            IPayout clientPayout = null;
            for (i = 0; i < annuity.getPayouts().size(); ++i) {
                found = false;
                clientPayout = annuity.getPayouts().get(i);
                for (IPayout resultPayout : results.getPayouts()) {
                    if (!((String)clientPayout.getId()).equals(resultPayout.getId())) continue;
                    found = true;
                    ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, clientPayout, resultPayout, "Annuity Payout from Client is not equal to DB value at location: " + i, "Mismacth was found");
                }
                if (found || clientPayout == null) continue;
                throw new ExecutionUnitVerificationException("Annuity Payout from client is not equal to DB.  Found Payout with id: " + (String)clientPayout.getId() + " on the client side, but not in the database for annuity id:" + (String)annuity.getId());
            }
        }
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, annuity.getRiders(), results.getRiders(), "Annuity rider from Client is not equal to DB value", "Mismacth was found in number of rider");
        if (annuity.getRiders() != null) {
            IRider clientRider = null;
            for (i = 0; i < annuity.getRiders().size(); ++i) {
                found = false;
                clientRider = annuity.getRiders().get(i);
                for (IRider resultRider : results.getRiders()) {
                    if (!((String)clientRider.getId()).equals(resultRider.getId())) continue;
                    found = true;
                    ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, clientRider, resultRider, "Annuity rider from Client is not equal to DB value at location: " + i, "Mismacth was found");
                }
                if (found || clientRider == null) continue;
                throw new ExecutionUnitVerificationException("Annuity rider from client is not equal to DB.  Found rider with id: " + (String)clientRider.getId() + " on the client side, but not in the database for annuity id:" + (String)annuity.getId());
            }
        }
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, annuity.getPayors(), results.getPayors(), "Annuity Payor from Client is not equal to DB value", "Mismacth was found.");
        if (annuity.getPayors() != null) {
            IPayor clientPayor = null;
            for (i = 0; i < annuity.getPayors().size(); ++i) {
                found = false;
                clientPayor = annuity.getPayors().get(i);
                for (IPayor resultPayor : results.getPayors()) {
                    if (!((String)clientPayor.getId()).equals(resultPayor.getId())) continue;
                    found = true;
                    ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, annuity.getPayors().get(i), resultPayor, "Annuity payor from Client is not equal to DB value at location: " + i, "Mismacth was found");
                }
                if (found || clientPayor == null) continue;
                throw new ExecutionUnitVerificationException("Annuity payor from client is not equal to DB.  Found payor with id: " + (String)clientPayor.getId() + " on the client side, but not in the database for annuity id:" + (String)annuity.getId());
            }
        }
    }

    private void verifyDeleteAnnuity(IAnnuity annuity, AnnuityType annuityType) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException, InvalidExecutionUnitParameterException, InterruptedException {
        AsynchMethodHelper.verifyAnnuityDelete(annuity, annuityType, this, this.logger);
    }
}

