/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit;

import com.ibm.wssvt.acme.annuity.common.bean.IContact;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.AbastractAnnuityExecutionUnit;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.BasicExecutionUnitLibrarry;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.ExecutionUnitVerificationHelper;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.common.adapter.ServerAdapterCommunicationException;
import com.ibm.wssvt.acme.common.executionunit.ExecutionUnitVerificationException;
import com.ibm.wssvt.acme.common.executionunit.IExecutionUnit;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.rmi.RemoteException;

public class CreateContactEU
extends AbastractAnnuityExecutionUnit {
    private static final long serialVersionUID = -3967925682867028969L;

    public void execute() {
        try {
            AcmeLogger logger = this.getLogger(((Object)((Object)this)).getClass().getName());
            IContact original = BasicExecutionUnitLibrarry.getContact(this.getAnnuityBeansFactory());
            original.setConfiguration(this.getConfiguration());
            logger.info("creating contact");
            IContact result = this.getServerAdapter().createContact(original);
            logger.info("contact email is: " + result.getEmail());
            this.verifyContactValues(original);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getExecutionUnitEvent().addException(e);
        }
    }

    private void verifyContactValues(IContact contact) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, ExecutionUnitVerificationException, RemoteException {
        IContact results = this.getAnnuityBeansFactory().createContact();
        results.setId(contact.getId());
        results.setConfiguration(this.getConfiguration());
        results = this.getServerAdapter().findContactById(results);
        ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, contact, results, "contact from Client is not equal to DB value", "Mismacth was found.");
    }
}

