/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.jdbc;

import java.io.PrintWriter;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.jdbc.InternalDriver;

public class JDBCBoot {
    private Properties bootProperties = new Properties();
    private static final String NETWORK_SERVER_AUTOSTART_CLASS_NAME = "org.apache.derby.iapi.jdbc.DRDAServerStarter";

    void addProperty(String name, String value) {
        this.bootProperties.put(name, value);
    }

    public void boot(String protocol, PrintWriter logging) {
        if (InternalDriver.activeDriver() == null) {
            this.addProperty("derby.service.jdbc", "org.apache.derby.jdbc.InternalDriver");
            this.addProperty("derby.service.authentication", "org.apache.derby.iapi.jdbc.AuthenticationService");
            Monitor.startMonitor(this.bootProperties, logging);
            if (Boolean.valueOf(PropertyUtil.getSystemProperty("derby.drda.startNetworkServer")).booleanValue()) {
                try {
                    Monitor.startSystemModule(NETWORK_SERVER_AUTOSTART_CLASS_NAME);
                }
                catch (StandardException se) {
                    Monitor.logTextMessage("J102", se.getMessage());
                }
            }
        }
    }
}

