/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.security;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import javax.security.auth.Subject;
import org.apache.derby.authentication.SystemPrincipal;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.security.Securable;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.sql.conn.Authorizer;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.StatementPermission;
import org.apache.derby.iapi.sql.dictionary.StatementRoutinePermission;
import org.apache.derby.iapi.util.IdUtil;

public class SecurityUtil {
    public static Subject createSystemPrincipalSubject(String user) {
        HashSet<SystemPrincipal> principals = new HashSet<SystemPrincipal>();
        if (user != null) {
            principals.add(new SystemPrincipal(user));
            principals.add(new SystemPrincipal(SecurityUtil.getAuthorizationId(user)));
        }
        boolean readOnly = true;
        HashSet credentials = new HashSet();
        return new Subject(true, principals, credentials, credentials);
    }

    private static String getAuthorizationId(String name) {
        if (name == null) {
            throw new NullPointerException("name can't be null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("name can't be empty");
        }
        try {
            return IdUtil.getUserAuthorizationId(name);
        }
        catch (StandardException se) {
            throw new IllegalArgumentException(se.getMessage());
        }
    }

    public static void checkSubjectHasPermission(final Subject subject, final Permission perm) {
        final PrivilegedAction<Void> runCheck = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                AccessController.checkPermission(perm);
                return null;
            }
        };
        PrivilegedAction<Void> runCheckAsPrivilegedUser = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                AccessControlContext acc = null;
                Subject.doAsPrivileged(subject, runCheck, acc);
                return null;
            }
        };
        AccessController.doPrivileged(runCheckAsPrivilegedUser);
    }

    public static void checkUserHasPermission(String user, Permission perm) {
        if (System.getSecurityManager() == null) {
            return;
        }
        Subject subject = SecurityUtil.createSystemPrincipalSubject(user);
        SecurityUtil.checkSubjectHasPermission(subject, perm);
    }

    public static void authorize(Securable operation) throws StandardException {
        LanguageConnectionContext lcc = (LanguageConnectionContext)ContextService.getContextOrNull("LanguageConnectionContext");
        if (lcc.usesSqlAuthorization()) {
            Authorizer authorizer = lcc.getAuthorizer();
            DataDictionary dd = lcc.getDataDictionary();
            AliasDescriptor ad = dd.getRoutineList(operation.routineSchemaID, operation.routineName, operation.routineType).get(0);
            ArrayList<StatementPermission> requiredPermissions = new ArrayList<StatementPermission>();
            StatementRoutinePermission executePermission = new StatementRoutinePermission(ad.getObjectID());
            requiredPermissions.add(executePermission);
            authorizer.authorize(requiredPermissions, lcc.getLastActivation());
        }
    }
}

