/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collections;
import java.util.EnumSet;
import org.apache.derby.iapi.services.io.FilePermissionService;

final class FilePermissionServiceImpl
implements FilePermissionService {
    FilePermissionServiceImpl() {
    }

    @Override
    public boolean limitAccessToOwner(File file) throws IOException {
        Path fileP = file.toPath();
        PosixFileAttributeView posixView = Files.getFileAttributeView(fileP, PosixFileAttributeView.class, new LinkOption[0]);
        if (posixView != null) {
            EnumSet<PosixFilePermission> perms = EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE);
            if (file.isDirectory()) {
                perms.add(PosixFilePermission.OWNER_EXECUTE);
            }
            posixView.setPermissions(perms);
            return true;
        }
        AclFileAttributeView aclView = Files.getFileAttributeView(fileP, AclFileAttributeView.class, new LinkOption[0]);
        if (aclView != null) {
            AclEntry ace = AclEntry.newBuilder().setPrincipal(Files.getOwner(fileP, new LinkOption[0])).setType(AclEntryType.ALLOW).setPermissions(EnumSet.allOf(AclEntryPermission.class)).build();
            aclView.setAcl(Collections.singletonList(ace));
            return true;
        }
        return false;
    }
}

