/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.derby.iapi.services.info.JVMInfo;
import org.apache.derby.iapi.services.io.FilePermissionService;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.io.StorageFactory;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.WritableStorageFactory;

public abstract class FileUtil {
    private static final int BUFFER_SIZE = 16384;
    private static final FilePermissionService filePermissionService = FileUtil.loadFilePermissionService();

    public static boolean removeDirectory(File directory) {
        if (directory == null) {
            return false;
        }
        if (!directory.exists()) {
            return true;
        }
        if (!directory.isDirectory()) {
            return false;
        }
        String[] list = directory.list();
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                File entry = new File(directory, list[i]);
                if (!(entry.isDirectory() ? !FileUtil.removeDirectory(entry) : !entry.delete())) continue;
                return false;
            }
        }
        return directory.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(File from, File to, byte[] buf) {
        if (buf == null) {
            buf = new byte[16384];
        }
        FileInputStream from_s = null;
        FileOutputStream to_s = null;
        try {
            from_s = new FileInputStream(from);
            to_s = new FileOutputStream(to);
            FileUtil.limitAccessToOwner(to);
            int bytesRead = from_s.read(buf);
            while (bytesRead != -1) {
                to_s.write(buf, 0, bytesRead);
                bytesRead = from_s.read(buf);
            }
            from_s.close();
            from_s = null;
            to_s.getFD().sync();
            to_s.close();
            to_s = null;
        }
        catch (IOException ioe) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (from_s != null) {
                try {
                    from_s.close();
                }
                catch (IOException ioe) {}
            }
            if (to_s != null) {
                try {
                    to_s.close();
                }
                catch (IOException ioe) {}
            }
        }
        return true;
    }

    public static boolean copyDirectory(StorageFactory storageFactory, StorageFile from, File to, byte[] buffer, String[] filter, boolean copySubDirs) {
        if (from == null) {
            return false;
        }
        if (!from.exists()) {
            return true;
        }
        if (!from.isDirectory()) {
            return false;
        }
        if (to.exists()) {
            return false;
        }
        if (!to.mkdirs()) {
            return false;
        }
        try {
            FileUtil.limitAccessToOwner(to);
        }
        catch (IOException ioe) {
            return false;
        }
        String[] list = from.list();
        if (list != null) {
            if (buffer == null) {
                buffer = new byte[16384];
            }
            block2: for (int i = 0; i < list.length; ++i) {
                StorageFile entry;
                String fileName = list[i];
                if (filter != null) {
                    for (int j = 0; j < filter.length; ++j) {
                        if (fileName.equals(filter[j])) continue block2;
                    }
                }
                if (!((entry = storageFactory.newStorageFile(from, fileName)).isDirectory() ? copySubDirs && !FileUtil.copyDirectory(storageFactory, entry, new File(to, fileName), buffer, filter, copySubDirs) : !FileUtil.copyFile(storageFactory, entry, new File(to, fileName), buffer))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean copyFile(StorageFactory storageFactory, StorageFile from, File to) {
        return FileUtil.copyFile(storageFactory, from, to, (byte[])null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(StorageFactory storageFactory, StorageFile from, File to, byte[] buf) {
        InputStream from_s = null;
        FileOutputStream to_s = null;
        try {
            from_s = from.getInputStream();
            to_s = new FileOutputStream(to);
            FileUtil.limitAccessToOwner(to);
            if (buf == null) {
                buf = new byte[16384];
            }
            int bytesRead = from_s.read(buf);
            while (bytesRead != -1) {
                to_s.write(buf, 0, bytesRead);
                bytesRead = from_s.read(buf);
            }
            from_s.close();
            from_s = null;
            to_s.getFD().sync();
            to_s.close();
            to_s = null;
        }
        catch (IOException ioe) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (from_s != null) {
                try {
                    from_s.close();
                }
                catch (IOException ioe) {}
            }
            if (to_s != null) {
                try {
                    to_s.close();
                }
                catch (IOException ioe) {}
            }
        }
        return true;
    }

    public static boolean copyDirectory(WritableStorageFactory storageFactory, File from, StorageFile to) {
        return FileUtil.copyDirectory(storageFactory, from, to, null, null);
    }

    public static boolean copyDirectory(WritableStorageFactory storageFactory, File from, StorageFile to, byte[] buffer, String[] filter) {
        if (from == null) {
            return false;
        }
        if (!from.exists()) {
            return true;
        }
        if (!from.isDirectory()) {
            return false;
        }
        if (to.exists()) {
            return false;
        }
        if (!to.mkdirs()) {
            return false;
        }
        try {
            to.limitAccessToOwner();
        }
        catch (IOException ioe) {
            return false;
        }
        String[] list = from.list();
        if (list != null) {
            if (buffer == null) {
                buffer = new byte[16384];
            }
            block2: for (int i = 0; i < list.length; ++i) {
                File entry;
                String fileName = list[i];
                if (filter != null) {
                    for (int j = 0; j < filter.length; ++j) {
                        if (fileName.equals(filter[j])) continue block2;
                    }
                }
                if (!((entry = new File(from, fileName)).isDirectory() ? !FileUtil.copyDirectory(storageFactory, entry, storageFactory.newStorageFile(to, fileName), buffer, filter) : !FileUtil.copyFile(storageFactory, entry, storageFactory.newStorageFile(to, fileName), buffer))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean copyFile(WritableStorageFactory storageFactory, File from, StorageFile to) {
        return FileUtil.copyFile(storageFactory, from, to, (byte[])null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(WritableStorageFactory storageFactory, File from, StorageFile to, byte[] buf) {
        FileInputStream from_s = null;
        OutputStream to_s = null;
        try {
            from_s = new FileInputStream(from);
            to_s = to.getOutputStream();
            if (buf == null) {
                buf = new byte[16384];
            }
            int bytesRead = ((InputStream)from_s).read(buf);
            while (bytesRead != -1) {
                to_s.write(buf, 0, bytesRead);
                bytesRead = ((InputStream)from_s).read(buf);
            }
            ((InputStream)from_s).close();
            from_s = null;
            storageFactory.sync(to_s, false);
            to_s.close();
            to_s = null;
        }
        catch (IOException ioe) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (from_s != null) {
                try {
                    ((InputStream)from_s).close();
                }
                catch (IOException ioe) {}
            }
            if (to_s != null) {
                try {
                    to_s.close();
                }
                catch (IOException ioe) {}
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(WritableStorageFactory storageFactory, StorageFile from, StorageFile to) {
        InputStream from_s = null;
        OutputStream to_s = null;
        try {
            from_s = from.getInputStream();
            to_s = to.getOutputStream();
            byte[] buf = new byte[16384];
            int bytesRead = from_s.read(buf);
            while (bytesRead != -1) {
                to_s.write(buf, 0, bytesRead);
                bytesRead = from_s.read(buf);
            }
            from_s.close();
            from_s = null;
            storageFactory.sync(to_s, false);
            to_s.close();
            to_s = null;
        }
        catch (IOException ioe) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (from_s != null) {
                try {
                    from_s.close();
                }
                catch (IOException ioe) {}
            }
            if (to_s != null) {
                try {
                    to_s.close();
                }
                catch (IOException ioe) {}
            }
        }
        return true;
    }

    public static String stripProtocolFromFileName(String originalName) {
        String result = originalName;
        try {
            URL url = new URL(originalName);
            result = url.getFile();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return result;
    }

    private static FilePermissionService loadFilePermissionService() {
        try {
            Class<?> cl = Class.forName(FilePermissionService.class.getName() + "Impl");
            return (FilePermissionService)cl.newInstance();
        }
        catch (ClassNotFoundException ex) {
        }
        catch (InstantiationException ex) {
        }
        catch (IllegalAccessException ex) {
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        return null;
    }

    public static void limitAccessToOwner(File file) throws IOException {
        String value = PropertyUtil.getSystemProperty("derby.storage.useDefaultFilePermissions");
        if (value != null) {
            if (Boolean.valueOf(value.trim()).booleanValue()) {
                return;
            }
        } else if (JVMInfo.JDK_ID < 8 || !PropertyUtil.getSystemBoolean("derby.__serverStartedFromCmdLine", false)) {
            return;
        }
        if (FileUtil.limitAccessToOwnerViaFile(file)) {
            return;
        }
        FileUtil.limitAccessToOwnerViaFileAttributeView(file);
    }

    private static boolean limitAccessToOwnerViaFile(File file) {
        boolean success = file.setWritable(false, false);
        success &= file.setWritable(true, true);
        success &= file.setReadable(false, false);
        success &= file.setReadable(true, true);
        if (file.isDirectory()) {
            success &= file.setExecutable(false, false);
            success &= file.setExecutable(true, true);
        }
        return success;
    }

    private static boolean limitAccessToOwnerViaFileAttributeView(File file) throws IOException {
        if (filePermissionService == null) {
            return false;
        }
        return filePermissionService.limitAccessToOwner(file);
    }
}

