/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.StreamCorruptedException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.io.ApplicationObjectInputStream;
import org.apache.derby.iapi.services.io.CloneableStream;
import org.apache.derby.iapi.services.io.ErrorInfo;
import org.apache.derby.iapi.services.io.ErrorObjectInput;
import org.apache.derby.iapi.services.io.FormatIdUtil;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.io.Storable;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.loader.ClassFactoryContext;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.types.Resetable;

public final class FormatIdInputStream
extends DataInputStream
implements ErrorObjectInput,
Resetable,
CloneableStream {
    protected ClassFactory cf;
    private ErrorInfo errorInfo;
    private Exception myNestedException;

    public FormatIdInputStream(InputStream in) {
        super(in);
    }

    @Override
    public Object readObject() throws IOException, ClassNotFoundException {
        this.setErrorInfo(null);
        int fmtId = FormatIdUtil.readFormatIdInteger(this);
        if (fmtId == 0) {
            return null;
        }
        if (fmtId == 1) {
            return this.readUTF();
        }
        try {
            if (fmtId == 2) {
                ObjectInputStream ois = this.getObjectStream();
                try {
                    Object result = ois.readObject();
                    return result;
                }
                catch (IOException ioe) {
                    throw this.handleReadError(ioe, ois);
                }
                catch (ClassNotFoundException cnfe) {
                    throw this.handleReadError(cnfe, ois);
                }
                catch (LinkageError le) {
                    throw this.handleReadError(le, ois);
                }
                catch (ClassCastException cce) {
                    throw this.handleReadError(cce, ois);
                }
            }
            try {
                boolean isNull;
                Formatable f = (Formatable)Monitor.newInstanceFromIdentifier(fmtId);
                if (f instanceof Storable && (isNull = this.readBoolean())) {
                    Storable s = (Storable)f;
                    s.restoreToNull();
                    return s;
                }
                f.readExternal(this);
                return f;
            }
            catch (StandardException se) {
                throw new ClassNotFoundException(se.toString());
            }
        }
        catch (ClassCastException cce) {
            StreamCorruptedException sce = new StreamCorruptedException(cce.toString());
            sce.initCause(cce);
            throw sce;
        }
    }

    public void setInput(InputStream in) {
        this.in = in;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    @Override
    public String getErrorInfo() {
        if (this.errorInfo == null) {
            return "";
        }
        return this.errorInfo.getErrorInfo();
    }

    @Override
    public Exception getNestedException() {
        if (this.myNestedException != null) {
            return null;
        }
        if (this.errorInfo == null) {
            return null;
        }
        return this.errorInfo.getNestedException();
    }

    private void setErrorInfo(ErrorInfo ei) {
        this.errorInfo = ei;
    }

    private <T extends Throwable> T handleReadError(T cause, ObjectInputStream stream) {
        if (stream instanceof ErrorInfo) {
            this.setErrorInfo((ErrorInfo)((Object)stream));
        }
        return cause;
    }

    ClassFactory getClassFactory() {
        ClassFactoryContext cfc;
        if (this.cf == null && (cfc = (ClassFactoryContext)ContextService.getContextOrNull("ClassFactoryContext")) != null) {
            this.cf = cfc.getClassFactory();
        }
        return this.cf;
    }

    private ObjectInputStream getObjectStream() throws IOException {
        return this.getClassFactory() == null ? new ObjectInputStream(this) : new ApplicationObjectInputStream(this, this.cf);
    }

    @Override
    public void resetStream() throws IOException, StandardException {
        ((Resetable)((Object)this.in)).resetStream();
    }

    @Override
    public void initStream() throws StandardException {
        ((Resetable)((Object)this.in)).initStream();
    }

    @Override
    public void closeStream() {
        ((Resetable)((Object)this.in)).closeStream();
    }

    @Override
    public InputStream cloneStream() {
        InputStream new_input_stream = ((CloneableStream)((Object)this.in)).cloneStream();
        return new FormatIdInputStream(new_input_stream);
    }
}

