/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Dependent;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.UniqueTupleDescriptor;
import org.apache.derby.shared.common.sanity.SanityManager;

public final class DefaultDescriptor
extends UniqueTupleDescriptor
implements Provider,
Dependent {
    private final int columnNumber;
    private final UUID defaultUUID;
    private final UUID tableUUID;

    public DefaultDescriptor(DataDictionary dataDictionary, UUID defaultUUID, UUID tableUUID, int columnNumber) {
        super(dataDictionary);
        this.defaultUUID = defaultUUID;
        this.tableUUID = tableUUID;
        this.columnNumber = columnNumber;
    }

    @Override
    public UUID getUUID() {
        return this.defaultUUID;
    }

    public UUID getTableUUID() {
        return this.tableUUID;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public String toString() {
        return "defaultUUID: " + this.defaultUUID + "\n" + "tableUUID: " + this.tableUUID + "\n" + "columnNumber: " + this.columnNumber + "\n";
    }

    @Override
    public DependableFinder getDependableFinder() {
        return this.getDependableFinder(325);
    }

    @Override
    public String getObjectName() {
        return "default";
    }

    @Override
    public UUID getObjectID() {
        return this.defaultUUID;
    }

    @Override
    public String getClassType() {
        return "Default";
    }

    @Override
    public synchronized boolean isValid() {
        return true;
    }

    @Override
    public void prepareToInvalidate(Provider p, int action, LanguageConnectionContext lcc) throws StandardException {
        DependencyManager dm = this.getDataDictionary().getDependencyManager();
        switch (action) {
            default: 
        }
        DataDictionary dd = this.getDataDictionary();
        ColumnDescriptor cd = dd.getColumnDescriptorByDefaultId(this.defaultUUID);
        TableDescriptor td = dd.getTableDescriptor(cd.getReferencingUUID());
        throw StandardException.newException("X0Y25.S", dm.getActionString(action), p.getObjectName(), "DEFAULT", td.getQualifiedName() + "." + cd.getColumnName());
    }

    @Override
    public void makeInvalid(int action, LanguageConnectionContext lcc) throws StandardException {
        DependencyManager dm = this.getDataDictionary().getDependencyManager();
        SanityManager.THROWASSERT("makeInvalid(" + dm.getActionString(action) + ") not expected to get called");
    }
}

