/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import java.util.List;
import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Dependent;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.IndexLister;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.StatisticsDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptorList;
import org.apache.derby.iapi.sql.dictionary.UniqueSQLObjectDescriptor;
import org.apache.derby.iapi.sql.dictionary.ViewDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.shared.common.sanity.SanityManager;

public class TableDescriptor
extends UniqueSQLObjectDescriptor
implements Provider,
Dependent {
    public static final int BASE_TABLE_TYPE = 0;
    public static final int SYSTEM_TABLE_TYPE = 1;
    public static final int VIEW_TYPE = 2;
    public static final int GLOBAL_TEMPORARY_TABLE_TYPE = 3;
    public static final int SYNONYM_TYPE = 4;
    public static final int VTI_TYPE = 5;
    public static final char ROW_LOCK_GRANULARITY = 'R';
    public static final char TABLE_LOCK_GRANULARITY = 'T';
    public static final char DEFAULT_LOCK_GRANULARITY = 'R';
    public static final int ISTATS_CREATE_THRESHOLD = PropertyUtil.getSystemInt("derby.storage.indexStats.debug.createThreshold", 100);
    public static final int ISTATS_ABSDIFF_THRESHOLD = PropertyUtil.getSystemInt("derby.storage.indexStats.debug.absdiffThreshold", 1000);
    public static final double ISTATS_LNDIFF_THRESHOLD;
    private char lockGranularity;
    private boolean onCommitDeleteRows;
    private boolean onRollbackDeleteRows;
    private boolean indexStatsUpToDate = true;
    private String indexStatsUpdateReason;
    SchemaDescriptor schema;
    String tableName;
    UUID oid;
    int tableType;
    private volatile long heapConglomNumber = -1L;
    ColumnDescriptorList columnDescriptorList;
    ConglomerateDescriptorList conglomerateDescriptorList;
    ConstraintDescriptorList constraintDescriptorList;
    private TriggerDescriptorList triggerDescriptorList;
    ViewDescriptor viewDescriptor;
    private List<StatisticsDescriptor> statisticsDescriptorList;

    private FormatableBitSet referencedColumnMapGet() {
        LanguageConnectionContext lcc = (LanguageConnectionContext)ContextService.getContextOrNull("LanguageConnectionContext");
        SanityManager.ASSERT(lcc != null);
        return lcc.getReferencedColumnMap(this);
    }

    private void referencedColumnMapPut(FormatableBitSet newReferencedColumnMap) {
        LanguageConnectionContext lcc = (LanguageConnectionContext)ContextService.getContextOrNull("LanguageConnectionContext");
        SanityManager.ASSERT(lcc != null || newReferencedColumnMap == null);
        if (lcc != null) {
            lcc.setReferencedColumnMap(this, newReferencedColumnMap);
        }
    }

    public TableDescriptor(DataDictionary dataDictionary, String tableName, SchemaDescriptor schema, int tableType, boolean onCommitDeleteRows, boolean onRollbackDeleteRows) {
        this(dataDictionary, tableName, schema, tableType, '\u0000');
        this.onCommitDeleteRows = onCommitDeleteRows;
        this.onRollbackDeleteRows = onRollbackDeleteRows;
    }

    public TableDescriptor(DataDictionary dataDictionary, String tableName, SchemaDescriptor schema, int tableType, char lockGranularity) {
        super(dataDictionary);
        this.schema = schema;
        this.tableName = tableName;
        this.tableType = tableType;
        this.lockGranularity = lockGranularity;
        this.conglomerateDescriptorList = new ConglomerateDescriptorList();
        this.columnDescriptorList = new ColumnDescriptorList();
        this.constraintDescriptorList = new ConstraintDescriptorList();
        this.triggerDescriptorList = new TriggerDescriptorList();
    }

    public String getSchemaName() {
        return this.schema.getSchemaName();
    }

    @Override
    public SchemaDescriptor getSchemaDescriptor() {
        return this.schema;
    }

    @Override
    public String getName() {
        return this.tableName;
    }

    public void setTableName(String newTableName) {
        this.tableName = newTableName;
    }

    public String getQualifiedName() {
        return IdUtil.mkQualifiedName(this.getSchemaName(), this.getName());
    }

    @Override
    public UUID getUUID() {
        return this.oid;
    }

    public int getTableType() {
        return this.tableType;
    }

    public long getHeapConglomerateId() throws StandardException {
        ConglomerateDescriptor cd = null;
        if (this.heapConglomNumber != -1L) {
            return this.heapConglomNumber;
        }
        ConglomerateDescriptor[] cds = this.getConglomerateDescriptors();
        for (int index = 0; index < cds.length && (cd = cds[index]).isIndex(); ++index) {
        }
        if (cd == null) {
            SanityManager.THROWASSERT("cd is expected to be non-null for " + this.tableName);
        }
        if (cd.isIndex()) {
            SanityManager.THROWASSERT("Did not find heap conglomerate for " + this.tableName);
        }
        this.heapConglomNumber = cd.getConglomerateNumber();
        return this.heapConglomNumber;
    }

    public int getNumberOfColumns() {
        return this.getColumnDescriptorList().size();
    }

    public FormatableBitSet getReferencedColumnMap() {
        return this.referencedColumnMapGet();
    }

    public void setReferencedColumnMap(FormatableBitSet referencedColumnMap) {
        this.referencedColumnMapPut(referencedColumnMap);
    }

    public FormatableBitSet makeColumnMap(ColumnDescriptorList cdl) {
        FormatableBitSet result = new FormatableBitSet(this.columnDescriptorList.size() + 1);
        int count = cdl.size();
        for (int i = 0; i < count; ++i) {
            ColumnDescriptor cd = cdl.elementAt(i);
            result.set(cd.getPosition());
        }
        return result;
    }

    public int getMaxColumnID() throws StandardException {
        int maxColumnID = 1;
        for (ColumnDescriptor cd : this.columnDescriptorList) {
            maxColumnID = Math.max(maxColumnID, cd.getPosition());
        }
        return maxColumnID;
    }

    public void setUUID(UUID oid) {
        this.oid = oid;
    }

    public char getLockGranularity() {
        return this.lockGranularity;
    }

    public void setLockGranularity(char lockGranularity) {
        this.lockGranularity = lockGranularity;
    }

    public boolean isOnRollbackDeleteRows() {
        return this.onRollbackDeleteRows;
    }

    public boolean isOnCommitDeleteRows() {
        return this.onCommitDeleteRows;
    }

    public void resetHeapConglomNumber() {
        if (this.tableType != 3) {
            SanityManager.THROWASSERT("tableType expected to be TableDescriptor.GLOBAL_TEMPORARY_TABLE_TYPE, not " + this.tableType);
        }
        this.heapConglomNumber = -1L;
    }

    public ExecRow getEmptyExecRow() throws StandardException {
        int columnCount = this.getNumberOfColumns();
        ExecRow result = this.getDataDictionary().getExecutionFactory().getValueRow(columnCount);
        for (int index = 0; index < columnCount; ++index) {
            ColumnDescriptor cd = this.columnDescriptorList.elementAt(index);
            DataValueDescriptor dataValue = cd.getType().getNull();
            result.setColumn(index + 1, dataValue);
        }
        return result;
    }

    public int[] getColumnCollationIds() throws StandardException {
        int[] collation_ids = new int[this.getNumberOfColumns()];
        for (int index = 0; index < collation_ids.length; ++index) {
            ColumnDescriptor cd = this.columnDescriptorList.elementAt(index);
            collation_ids[index] = cd.getType().getCollationType();
        }
        return collation_ids;
    }

    public ConglomerateDescriptorList getConglomerateDescriptorList() {
        return this.conglomerateDescriptorList;
    }

    public ViewDescriptor getViewDescriptor() {
        return this.viewDescriptor;
    }

    public void setViewDescriptor(ViewDescriptor viewDescriptor) {
        if (this.tableType != 2) {
            SanityManager.THROWASSERT("tableType expected to be TableDescriptor.VIEW_TYPE, not " + this.tableType);
        }
        this.viewDescriptor = viewDescriptor;
    }

    @Override
    public boolean isPersistent() {
        if (this.tableType == 3) {
            return false;
        }
        return super.isPersistent();
    }

    public boolean isSynonymDescriptor() {
        return this.tableType == 4;
    }

    public int getTotalNumberOfIndexes() throws StandardException {
        return this.getQualifiedNumberOfIndexes(0, false);
    }

    public int getQualifiedNumberOfIndexes(int minColCount, boolean nonUniqeTrumpsColCount) {
        int matches = 0;
        for (ConglomerateDescriptor cd : this.conglomerateDescriptorList) {
            IndexRowGenerator irg;
            if (!cd.isIndex() || (irg = cd.getIndexDescriptor()).numberOfOrderedColumns() < minColCount && (!nonUniqeTrumpsColCount || irg.isUnique())) continue;
            ++matches;
        }
        return matches;
    }

    public void getAllRelevantTriggers(int statementType, int[] changedColumnIds, TriggerDescriptorList relevantTriggers) throws StandardException {
        SanityManager.ASSERT(statementType == 1 || statementType == 2 || statementType == 3 || statementType == 4, "invalid statement type " + statementType);
        DataDictionary dd = this.getDataDictionary();
        for (TriggerDescriptor tgr : dd.getTriggerDescriptors(this)) {
            if (!tgr.needsToFire(statementType, changedColumnIds)) continue;
            relevantTriggers.add(tgr);
        }
    }

    public void getAllRelevantConstraints(int statementType, int[] changedColumnIds, boolean[] needsDeferredProcessing, ConstraintDescriptorList relevantConstraints) throws StandardException {
        SanityManager.ASSERT(statementType == 1 || statementType == 2 || statementType == 3 || statementType == 4, "invalid statement type " + statementType);
        DataDictionary dd = this.getDataDictionary();
        ConstraintDescriptorList cdl = dd.getConstraintDescriptors(this);
        int cdlSize = cdl.size();
        for (int index = 0; index < cdlSize; ++index) {
            ConstraintDescriptor cd = cdl.elementAt(index);
            if (!needsDeferredProcessing[0] && cd instanceof ReferencedKeyConstraintDescriptor && statementType != 3 && statementType != 2) {
                needsDeferredProcessing[0] = ((ReferencedKeyConstraintDescriptor)cd).hasSelfReferencingFK(cdl, 1);
            }
            if (!cd.needsToFire(statementType, changedColumnIds)) continue;
            if (cd instanceof ReferencedKeyConstraintDescriptor && (statementType == 3 || statementType == 2)) {
                needsDeferredProcessing[0] = true;
            }
            relevantConstraints.add(cd);
        }
    }

    @Override
    public DependableFinder getDependableFinder() {
        if (this.referencedColumnMapGet() == null) {
            return this.getDependableFinder(137);
        }
        return this.getColumnDependableFinder(393, this.referencedColumnMapGet().getByteArray());
    }

    @Override
    public String getObjectName() {
        if (this.referencedColumnMapGet() == null) {
            return this.tableName;
        }
        StringBuilder name = new StringBuilder();
        name.append(this.tableName);
        boolean first = true;
        for (ColumnDescriptor cd : this.columnDescriptorList) {
            if (!this.referencedColumnMapGet().isSet(cd.getPosition())) continue;
            if (first) {
                name.append("(").append(cd.getColumnName());
                first = false;
                continue;
            }
            name.append(", ").append(cd.getColumnName());
        }
        if (!first) {
            name.append(")");
        }
        return name.toString();
    }

    @Override
    public UUID getObjectID() {
        return this.oid;
    }

    @Override
    public String getClassType() {
        return "Table";
    }

    public String toString() {
        String tempString = "\nschema: " + this.schema + "\n" + "tableName: " + this.tableName + "\n" + "oid: " + this.oid + " tableType: " + this.tableType + "\n" + "conglomerateDescriptorList: " + this.conglomerateDescriptorList + "\n" + "columnDescriptorList: " + this.columnDescriptorList + "\n" + "constraintDescriptorList: " + this.constraintDescriptorList + "\n" + "heapConglomNumber: " + this.heapConglomNumber + "\n";
        if (this.tableType == 3) {
            tempString = tempString + "onCommitDeleteRows: " + "\n" + this.onCommitDeleteRows + "\n";
            tempString = tempString + "onRollbackDeleteRows: " + "\n" + this.onRollbackDeleteRows;
        } else {
            tempString = tempString + "lockGranularity: " + this.lockGranularity;
        }
        return tempString;
    }

    public ColumnDescriptorList getColumnDescriptorList() {
        return this.columnDescriptorList;
    }

    public ColumnDescriptorList getGeneratedColumns() {
        ColumnDescriptorList fullList = this.getColumnDescriptorList();
        ColumnDescriptorList result = new ColumnDescriptorList();
        int count = fullList.size();
        for (int i = 0; i < count; ++i) {
            ColumnDescriptor cd = fullList.elementAt(i);
            if (!cd.hasGenerationClause()) continue;
            result.add(this.oid, cd);
        }
        return result;
    }

    public int[] getColumnIDs(String[] names) {
        int count = names.length;
        int[] result = new int[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.getColumnDescriptor(names[i]).getPosition();
        }
        return result;
    }

    public ConstraintDescriptorList getConstraintDescriptorList() throws StandardException {
        return this.constraintDescriptorList;
    }

    public void setConstraintDescriptorList(ConstraintDescriptorList newCDL) {
        this.constraintDescriptorList = newCDL;
    }

    public void emptyConstraintDescriptorList() throws StandardException {
        this.constraintDescriptorList = new ConstraintDescriptorList();
    }

    public ReferencedKeyConstraintDescriptor getPrimaryKey() throws StandardException {
        ConstraintDescriptorList cdl = this.getDataDictionary().getConstraintDescriptors(this);
        return cdl.getPrimaryKey();
    }

    public TriggerDescriptorList getTriggerDescriptorList() throws StandardException {
        return this.triggerDescriptorList;
    }

    public void setTriggerDescriptorList(TriggerDescriptorList newCDL) {
        this.triggerDescriptorList = newCDL;
    }

    public void emptyTriggerDescriptorList() throws StandardException {
        this.triggerDescriptorList = new TriggerDescriptorList();
    }

    public boolean tableNameEquals(String otherTableName, String otherSchemaName) {
        String schemaName = this.getSchemaName();
        if (schemaName == null || otherSchemaName == null) {
            return this.tableName.equals(otherTableName);
        }
        return schemaName.equals(otherSchemaName) && this.tableName.equals(otherTableName);
    }

    public void removeConglomerateDescriptor(ConglomerateDescriptor cd) throws StandardException {
        this.conglomerateDescriptorList.dropConglomerateDescriptor(this.getUUID(), cd);
    }

    public void removeConstraintDescriptor(ConstraintDescriptor cd) throws StandardException {
        this.constraintDescriptorList.remove(cd);
    }

    public ColumnDescriptor getColumnDescriptor(String columnName) {
        return this.columnDescriptorList.getColumnDescriptor(this.oid, columnName);
    }

    public ColumnDescriptor getColumnDescriptor(int columnNumber) {
        return this.columnDescriptorList.getColumnDescriptor(this.oid, columnNumber);
    }

    public ConglomerateDescriptor[] getConglomerateDescriptors() {
        int size = this.conglomerateDescriptorList.size();
        ConglomerateDescriptor[] cdls = new ConglomerateDescriptor[size];
        this.conglomerateDescriptorList.toArray(cdls);
        return cdls;
    }

    public ConglomerateDescriptor getConglomerateDescriptor(long conglomerateNumber) throws StandardException {
        return this.conglomerateDescriptorList.getConglomerateDescriptor(conglomerateNumber);
    }

    public ConglomerateDescriptor[] getConglomerateDescriptors(long conglomerateNumber) throws StandardException {
        return this.conglomerateDescriptorList.getConglomerateDescriptors(conglomerateNumber);
    }

    public ConglomerateDescriptor getConglomerateDescriptor(UUID conglomerateUUID) throws StandardException {
        return this.conglomerateDescriptorList.getConglomerateDescriptor(conglomerateUUID);
    }

    public ConglomerateDescriptor[] getConglomerateDescriptors(UUID conglomerateUUID) throws StandardException {
        return this.conglomerateDescriptorList.getConglomerateDescriptors(conglomerateUUID);
    }

    public IndexLister getIndexLister() throws StandardException {
        return new IndexLister(this);
    }

    public boolean tableHasAutoincrement() {
        for (ColumnDescriptor cd : this.columnDescriptorList) {
            if (!cd.isAutoincrement()) continue;
            return true;
        }
        return false;
    }

    public String[] getColumnNamesArray() {
        int size = this.getNumberOfColumns();
        String[] s = new String[size];
        for (int i = 0; i < size; ++i) {
            s[i] = this.getColumnDescriptor(i + 1).getColumnName();
        }
        return s;
    }

    public long[] getAutoincIncrementArray() {
        if (!this.tableHasAutoincrement()) {
            return null;
        }
        int size = this.getNumberOfColumns();
        long[] inc = new long[size];
        for (int i = 0; i < size; ++i) {
            ColumnDescriptor cd = this.getColumnDescriptor(i + 1);
            if (!cd.isAutoincrement()) continue;
            inc[i] = cd.getAutoincInc();
        }
        return inc;
    }

    public synchronized List<StatisticsDescriptor> getStatistics() throws StandardException {
        if (this.statisticsDescriptorList != null) {
            return this.statisticsDescriptorList;
        }
        DataDictionary dd = this.getDataDictionary();
        this.statisticsDescriptorList = dd.getStatisticsDescriptors(this);
        return this.statisticsDescriptorList;
    }

    public void markForIndexStatsUpdate(long tableRowCountEstimate) throws StandardException {
        List<StatisticsDescriptor> sdl = this.getStatistics();
        if (sdl.isEmpty() && tableRowCountEstimate >= (long)ISTATS_CREATE_THRESHOLD) {
            this.indexStatsUpToDate = false;
            this.indexStatsUpdateReason = "no stats, row-estimate=" + tableRowCountEstimate;
            return;
        }
        for (StatisticsDescriptor sd : sdl) {
            double cmp;
            long indexRowCountEstimate = sd.getStatistic().getRowEstimate();
            long diff = Math.abs(tableRowCountEstimate - indexRowCountEstimate);
            if (diff < (long)ISTATS_ABSDIFF_THRESHOLD || Double.compare(cmp = Math.abs(Math.log(indexRowCountEstimate) - Math.log(tableRowCountEstimate)), ISTATS_LNDIFF_THRESHOLD) != 1) continue;
            this.indexStatsUpToDate = false;
            this.indexStatsUpdateReason = "t-est=" + tableRowCountEstimate + ", i-est=" + indexRowCountEstimate + " => cmp=" + cmp;
            break;
        }
    }

    public boolean getAndClearIndexStatsIsUpToDate() {
        boolean tmp = this.indexStatsUpToDate;
        this.indexStatsUpToDate = true;
        return tmp;
    }

    public String getIndexStatsUpdateReason() {
        return this.indexStatsUpdateReason;
    }

    public boolean statisticsExist(ConglomerateDescriptor cd) throws StandardException {
        List<StatisticsDescriptor> sdl = this.getStatistics();
        if (cd == null) {
            return sdl.size() > 0;
        }
        UUID cdUUID = cd.getUUID();
        for (StatisticsDescriptor statDesc : sdl) {
            if (!cdUUID.equals(statDesc.getReferenceID())) continue;
            return true;
        }
        return false;
    }

    public double selectivityForConglomerate(ConglomerateDescriptor cd, int numKeys) throws StandardException {
        UUID referenceUUID = cd.getUUID();
        for (StatisticsDescriptor statDesc : this.getStatistics()) {
            if (!referenceUUID.equals(statDesc.getReferenceID()) || statDesc.getColumnCount() != numKeys) continue;
            return statDesc.getStatistic().selectivity(null);
        }
        return Math.pow(0.1, numKeys);
    }

    @Override
    public String getDescriptorName() {
        return this.tableName;
    }

    @Override
    public String getDescriptorType() {
        return this.tableType == 4 ? "Synonym" : "Table/View";
    }

    @Override
    public synchronized boolean isValid() {
        return true;
    }

    @Override
    public void prepareToInvalidate(Provider p, int action, LanguageConnectionContext lcc) throws StandardException {
        DependencyManager dm = this.getDataDictionary().getDependencyManager();
        switch (action) {
            default: 
        }
        throw StandardException.newException("X0Y29.S", dm.getActionString(action), p.getObjectName(), this.getQualifiedName());
    }

    @Override
    public void makeInvalid(int action, LanguageConnectionContext lcc) throws StandardException {
        DependencyManager dm = this.getDataDictionary().getDependencyManager();
        SanityManager.THROWASSERT("makeInvalid(" + dm.getActionString(action) + ") not expected to get called");
    }

    public static String makeSequenceName(UUID tableID) {
        return tableID.toANSIidentifier();
    }

    static {
        double tmpLog2Diff = 1.0;
        try {
            String tmpStr = PropertyUtil.getSystemProperty("derby.storage.indexStats.debug.lndiffThreshold");
            if (tmpStr != null) {
                tmpLog2Diff = Double.parseDouble(tmpStr);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        ISTATS_LNDIFF_THRESHOLD = tmpLog2Diff;
    }
}

