/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.derby.iapi.db.DatabaseContext;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.i18n.LocaleFinder;
import org.apache.derby.iapi.types.DataType;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.DateTimeDataValue;
import org.apache.derby.iapi.types.DateTimeParser;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.SQLInteger;
import org.apache.derby.iapi.types.SQLTimestamp;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.shared.common.sanity.SanityManager;

public final class SQLDate
extends DataType
implements DateTimeDataValue {
    private int encodedDate;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(SQLDate.class);
    static final char ISO_SEPARATOR = '-';
    private static final char[] ISO_SEPARATOR_ONLY = new char[]{'-'};
    private static final char IBM_USA_SEPARATOR = '/';
    private static final char[] IBM_USA_SEPARATOR_ONLY = new char[]{'/'};
    private static final char IBM_EUR_SEPARATOR = '.';
    private static final char[] IBM_EUR_SEPARATOR_ONLY = new char[]{'.'};
    private static final char[] END_OF_STRING = new char[]{'\u0000'};

    @Override
    public int estimateMemoryUsage() {
        return BASE_MEMORY_USAGE;
    }

    int getEncodedDate() {
        return this.encodedDate;
    }

    @Override
    public String getString() {
        if (!this.isNull()) {
            return SQLDate.encodedDateToString(this.encodedDate);
        }
        return null;
    }

    @Override
    public Timestamp getTimestamp(Calendar cal) {
        if (this.isNull()) {
            return null;
        }
        return new Timestamp(this.getTimeInMillis(cal));
    }

    private long getTimeInMillis(Calendar cal) {
        if (cal == null) {
            cal = new GregorianCalendar();
        }
        cal.clear();
        SQLDate.setDateInCalendar(cal, this.encodedDate);
        return cal.getTimeInMillis();
    }

    static void setDateInCalendar(Calendar cal, int encodedDate) {
        cal.set(SQLDate.getYear(encodedDate), SQLDate.getMonth(encodedDate) - 1, SQLDate.getDay(encodedDate));
    }

    @Override
    public Object getObject() {
        return this.getDate((Calendar)null);
    }

    @Override
    public int getLength() {
        return 4;
    }

    @Override
    public String getTypeName() {
        return "DATE";
    }

    @Override
    public int getTypeFormatId() {
        return 298;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SanityManager.ASSERT(!this.isNull(), "writeExternal() is not supposed to be called for null values.");
        out.writeInt(this.encodedDate);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.encodedDate = in.readInt();
    }

    @Override
    public DataValueDescriptor cloneValue(boolean forceMaterialization) {
        return new SQLDate(this.encodedDate);
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new SQLDate();
    }

    @Override
    public void restoreToNull() {
        this.encodedDate = 0;
    }

    @Override
    public void setValueFromResultSet(ResultSet resultSet, int colNumber, boolean isNullable) throws SQLException, StandardException {
        this.setValue(resultSet.getDate(colNumber), (Calendar)null);
    }

    @Override
    public int compare(DataValueDescriptor other) throws StandardException {
        if (this.typePrecedence() < other.typePrecedence()) {
            return -other.compare(this);
        }
        boolean thisNull = this.isNull();
        boolean otherNull = other.isNull();
        if (thisNull || otherNull) {
            if (!thisNull) {
                return -1;
            }
            if (!otherNull) {
                return 1;
            }
            return 0;
        }
        int otherVal = 0;
        otherVal = other instanceof SQLDate ? ((SQLDate)other).encodedDate : SQLDate.computeEncodedDate(other.getDate(new GregorianCalendar()));
        int comparison = this.encodedDate > otherVal ? 1 : (this.encodedDate < otherVal ? -1 : 0);
        return comparison;
    }

    @Override
    public boolean compare(int op, DataValueDescriptor other, boolean orderedNulls, boolean unknownRV) throws StandardException {
        if (!orderedNulls && (this.isNull() || other.isNull())) {
            return unknownRV;
        }
        return super.compare(op, other, orderedNulls, unknownRV);
    }

    public SQLDate() {
    }

    public SQLDate(Date value) throws StandardException {
        this.parseDate(value);
    }

    private void parseDate(java.util.Date value) throws StandardException {
        this.encodedDate = SQLDate.computeEncodedDate(value);
    }

    private SQLDate(int encodedDate) {
        this.encodedDate = encodedDate;
    }

    public SQLDate(String dateStr, boolean isJdbcEscape, LocaleFinder localeFinder) throws StandardException {
        this.parseDate(dateStr, isJdbcEscape, localeFinder, null);
    }

    public SQLDate(String dateStr, boolean isJdbcEscape, LocaleFinder localeFinder, Calendar cal) throws StandardException {
        this.parseDate(dateStr, isJdbcEscape, localeFinder, cal);
    }

    private void parseDate(String dateStr, boolean isJdbcEscape, LocaleFinder localeFinder, Calendar cal) throws StandardException {
        boolean validSyntax = true;
        DateTimeParser parser = new DateTimeParser(dateStr);
        int year = 0;
        int month = 0;
        int day = 0;
        StandardException thrownSE = null;
        try {
            switch (parser.nextSeparator()) {
                case '-': {
                    this.encodedDate = SQLTimestamp.parseDateOrTimestamp(parser, false)[0];
                    return;
                }
                case '/': {
                    if (isJdbcEscape) {
                        validSyntax = false;
                        break;
                    }
                    month = parser.parseInt(2, true, IBM_USA_SEPARATOR_ONLY, false);
                    day = parser.parseInt(2, true, IBM_USA_SEPARATOR_ONLY, false);
                    year = parser.parseInt(4, false, END_OF_STRING, false);
                    break;
                }
                case '.': {
                    if (isJdbcEscape) {
                        validSyntax = false;
                        break;
                    }
                    day = parser.parseInt(2, true, IBM_EUR_SEPARATOR_ONLY, false);
                    month = parser.parseInt(2, true, IBM_EUR_SEPARATOR_ONLY, false);
                    year = parser.parseInt(4, false, END_OF_STRING, false);
                    break;
                }
                default: {
                    validSyntax = false;
                    break;
                }
            }
        }
        catch (StandardException se) {
            validSyntax = false;
            thrownSE = se;
        }
        if (validSyntax) {
            this.encodedDate = SQLDate.computeEncodedDate(year, month, day);
        } else {
            dateStr = StringUtil.trimTrailing(dateStr);
            DateFormat dateFormat = null;
            dateFormat = localeFinder == null ? DateFormat.getDateInstance() : (cal == null ? localeFinder.getDateFormat() : (DateFormat)localeFinder.getDateFormat().clone());
            if (cal != null) {
                dateFormat.setCalendar(cal);
            }
            try {
                this.encodedDate = SQLDate.computeEncodedDate(dateFormat.parse(dateStr), cal);
            }
            catch (ParseException pe) {
                try {
                    this.encodedDate = SQLTimestamp.parseLocalTimestamp(dateStr, localeFinder, cal)[0];
                }
                catch (ParseException pe2) {
                    if (thrownSE != null) {
                        throw thrownSE;
                    }
                    throw StandardException.newException("22007.S.181", new Object[0]);
                }
            }
        }
    }

    @Override
    void setObject(Object theValue) throws StandardException {
        this.setValue((Date)theValue);
    }

    @Override
    protected void setFrom(DataValueDescriptor theValue) throws StandardException {
        if (theValue instanceof SQLDate) {
            this.restoreToNull();
            this.encodedDate = ((SQLDate)theValue).encodedDate;
        } else {
            GregorianCalendar cal = new GregorianCalendar();
            this.setValue(theValue.getDate(cal), (Calendar)cal);
        }
    }

    @Override
    public void setValue(Date value, Calendar cal) throws StandardException {
        this.restoreToNull();
        this.encodedDate = SQLDate.computeEncodedDate(value, cal);
    }

    @Override
    public void setValue(Timestamp value, Calendar cal) throws StandardException {
        this.restoreToNull();
        this.encodedDate = SQLDate.computeEncodedDate(value, cal);
    }

    @Override
    public void setValue(String theValue) throws StandardException {
        this.restoreToNull();
        if (theValue != null) {
            DatabaseContext databaseContext = (DatabaseContext)ContextService.getContext("Database");
            this.parseDate(theValue, false, databaseContext == null ? null : databaseContext.getDatabase(), null);
        }
    }

    NumberDataValue nullValueInt() {
        return new SQLInteger();
    }

    @Override
    public NumberDataValue getYear(NumberDataValue result) throws StandardException {
        if (this.isNull()) {
            return this.nullValueInt();
        }
        return SQLDate.setSource(SQLDate.getYear(this.encodedDate), result);
    }

    @Override
    public NumberDataValue getMonth(NumberDataValue result) throws StandardException {
        if (this.isNull()) {
            return this.nullValueInt();
        }
        return SQLDate.setSource(SQLDate.getMonth(this.encodedDate), result);
    }

    @Override
    public NumberDataValue getDate(NumberDataValue result) throws StandardException {
        if (this.isNull()) {
            return this.nullValueInt();
        }
        return SQLDate.setSource(SQLDate.getDay(this.encodedDate), result);
    }

    @Override
    public NumberDataValue getHours(NumberDataValue result) throws StandardException {
        throw StandardException.newException("42X25", "getHours", "Date");
    }

    @Override
    public NumberDataValue getMinutes(NumberDataValue result) throws StandardException {
        throw StandardException.newException("42X25", "getMinutes", "Date");
    }

    @Override
    public NumberDataValue getSeconds(NumberDataValue result) throws StandardException {
        throw StandardException.newException("42X25", "getSeconds", "Date");
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return this.getDate((Calendar)null).toString();
    }

    public int hashCode() {
        return this.encodedDate;
    }

    @Override
    public int typePrecedence() {
        return 100;
    }

    @Override
    public final boolean isNull() {
        return this.encodedDate == 0;
    }

    @Override
    public Date getDate(Calendar cal) {
        if (this.isNull()) {
            return null;
        }
        return new Date(this.getTimeInMillis(cal));
    }

    static int getYear(int encodedDate) {
        return encodedDate >>> 16;
    }

    static int getMonth(int encodedDate) {
        return encodedDate >>> 8 & 0xFF;
    }

    static int getDay(int encodedDate) {
        return encodedDate & 0xFF;
    }

    static int computeEncodedDate(Calendar cal) throws StandardException {
        return SQLDate.computeEncodedDate(cal.get(1), cal.get(2) + 1, cal.get(5));
    }

    static int computeEncodedDate(int y, int m, int d) throws StandardException {
        int maxDay = 31;
        switch (m) {
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                maxDay = 30;
                break;
            }
            case 2: {
                int n = maxDay = y % 4 == 0 && (y % 100 != 0 || y % 400 == 0) ? 29 : 28;
            }
        }
        if (y < 1 || y > 9999 || m < 1 || m > 12 || d < 1 || d > maxDay) {
            throw StandardException.newException("22007.S.180", new Object[0]);
        }
        return (y << 16) + (m << 8) + d;
    }

    static void dateToString(int year, int month, int day, StringBuffer sb) {
        String yearStr = Integer.toString(year);
        for (int i = yearStr.length(); i < 4; ++i) {
            sb.append('0');
        }
        sb.append(yearStr);
        sb.append('-');
        String monthStr = Integer.toString(month);
        String dayStr = Integer.toString(day);
        if (monthStr.length() == 1) {
            sb.append('0');
        }
        sb.append(monthStr);
        sb.append('-');
        if (dayStr.length() == 1) {
            sb.append('0');
        }
        sb.append(dayStr);
    }

    static String encodedDateToString(int encodedDate) {
        StringBuffer vstr = new StringBuffer();
        SQLDate.dateToString(SQLDate.getYear(encodedDate), SQLDate.getMonth(encodedDate), SQLDate.getDay(encodedDate), vstr);
        return vstr.toString();
    }

    static NumberDataValue setSource(int value, NumberDataValue source) throws StandardException {
        if (source == null) {
            source = new SQLInteger();
        }
        source.setValue(value);
        return source;
    }

    private static int computeEncodedDate(java.util.Date value) throws StandardException {
        return SQLDate.computeEncodedDate(value, null);
    }

    static int computeEncodedDate(java.util.Date value, Calendar currentCal) throws StandardException {
        if (value == null) {
            return 0;
        }
        if (currentCal == null) {
            currentCal = new GregorianCalendar();
        }
        currentCal.setTime(value);
        return SQLDate.computeEncodedDate(currentCal);
    }

    public static DateTimeDataValue computeDateFunction(DataValueDescriptor operand, DataValueFactory dvf) throws StandardException {
        try {
            if (operand.isNull()) {
                return new SQLDate();
            }
            if (operand instanceof SQLDate) {
                return (SQLDate)operand.cloneValue(false);
            }
            if (operand instanceof SQLTimestamp) {
                SQLDate retVal = new SQLDate();
                retVal.setValue(operand);
                return retVal;
            }
            if (operand instanceof NumberDataValue) {
                int daysSinceEpoch = operand.getInt();
                if (daysSinceEpoch <= 0 || daysSinceEpoch > 3652059) {
                    throw StandardException.newException("22008.S", operand.getString(), "date");
                }
                GregorianCalendar cal = new GregorianCalendar(1970, 0, 1, 12, 0, 0);
                ((Calendar)cal).add(5, daysSinceEpoch - 1);
                return new SQLDate(SQLDate.computeEncodedDate(cal.get(1), cal.get(2) + 1, cal.get(5)));
            }
            String str = operand.getString();
            if (str.length() == 7) {
                int year = SQLTimestamp.parseDateTimeInteger(str, 0, 4);
                int dayOfYear = SQLTimestamp.parseDateTimeInteger(str, 4, 3);
                if (dayOfYear < 1 || dayOfYear > 366) {
                    throw StandardException.newException("22008.S", operand.getString(), "date");
                }
                GregorianCalendar cal = new GregorianCalendar(year, 0, 1, 2, 0, 0);
                ((Calendar)cal).add(6, dayOfYear - 1);
                int y = cal.get(1);
                if (y != year) {
                    throw StandardException.newException("22008.S", operand.getString(), "date");
                }
                return new SQLDate(SQLDate.computeEncodedDate(year, cal.get(2) + 1, cal.get(5)));
            }
            return dvf.getDateValue(str, false);
        }
        catch (StandardException se) {
            if ("22007.S.181".startsWith(se.getSQLState())) {
                throw StandardException.newException("22008.S", operand.getString(), "date");
            }
            throw se;
        }
    }

    @Override
    public void setInto(PreparedStatement ps, int position) throws SQLException, StandardException {
        ps.setDate(position, this.getDate((Calendar)null));
    }

    @Override
    public DateTimeDataValue timestampAdd(int intervalType, NumberDataValue intervalCount, Date currentDate, DateTimeDataValue resultHolder) throws StandardException {
        return this.toTimestamp().timestampAdd(intervalType, intervalCount, currentDate, resultHolder);
    }

    private SQLTimestamp toTimestamp() throws StandardException {
        return new SQLTimestamp(this.getEncodedDate(), 0, 0);
    }

    @Override
    public NumberDataValue timestampDiff(int intervalType, DateTimeDataValue time1, Date currentDate, NumberDataValue resultHolder) throws StandardException {
        return this.toTimestamp().timestampDiff(intervalType, time1, currentDate, resultHolder);
    }
}

