/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataType;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.SQLBoolean;
import org.apache.derby.shared.common.sanity.SanityManager;

public final class SQLSmallint
extends NumberDataType {
    static final int SMALLINT_LENGTH = 2;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(SQLSmallint.class);
    private short value;
    private boolean isnull;

    @Override
    public int getInt() {
        return this.value;
    }

    @Override
    public byte getByte() throws StandardException {
        if (this.value > 127 || this.value < -128) {
            throw StandardException.newException("22003", "TINYINT");
        }
        return (byte)this.value;
    }

    @Override
    public short getShort() {
        return this.value;
    }

    @Override
    public long getLong() {
        return this.value;
    }

    @Override
    public float getFloat() {
        return this.value;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public boolean getBoolean() {
        return this.value != 0;
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return null;
        }
        return Short.toString(this.value);
    }

    @Override
    public int getLength() {
        return 2;
    }

    @Override
    public Object getObject() {
        if (this.isNull()) {
            return null;
        }
        return new Integer(this.value);
    }

    @Override
    public String getTypeName() {
        return "SMALLINT";
    }

    @Override
    public int getTypeFormatId() {
        return 83;
    }

    @Override
    public boolean isNull() {
        return this.isnull;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SanityManager.ASSERT(!this.isNull());
        out.writeShort(this.value);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.value = in.readShort();
        this.isnull = false;
    }

    @Override
    public void restoreToNull() {
        this.value = 0;
        this.isnull = true;
    }

    @Override
    protected int typeCompare(DataValueDescriptor arg) throws StandardException {
        int otherValue;
        int thisValue = this.getInt();
        if (thisValue == (otherValue = arg.getInt())) {
            return 0;
        }
        if (thisValue > otherValue) {
            return 1;
        }
        return -1;
    }

    @Override
    public DataValueDescriptor cloneValue(boolean forceMaterialization) {
        return new SQLSmallint(this.value, this.isnull);
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new SQLSmallint();
    }

    @Override
    public void setValueFromResultSet(ResultSet resultSet, int colNumber, boolean isNullable) throws SQLException {
        try {
            this.value = resultSet.getShort(colNumber);
            this.isnull = isNullable && resultSet.wasNull();
        }
        catch (SQLException selq) {
            int i = resultSet.getInt(colNumber);
            this.value = (short)i;
            this.isnull = false;
        }
    }

    @Override
    public final void setInto(PreparedStatement ps, int position) throws SQLException {
        if (this.isNull()) {
            ps.setNull(position, 5);
            return;
        }
        ps.setShort(position, this.value);
    }

    @Override
    public final void setInto(ResultSet rs, int position) throws SQLException, StandardException {
        rs.updateShort(position, this.value);
    }

    public SQLSmallint() {
        this.isnull = true;
    }

    public SQLSmallint(short val) {
        this.value = val;
    }

    private SQLSmallint(short val, boolean isnull) {
        this.value = val;
        this.isnull = isnull;
    }

    public SQLSmallint(Short obj) {
        this.isnull = obj == null;
        if (!this.isnull) {
            this.value = obj;
        }
    }

    @Override
    public void setValue(String theValue) throws StandardException {
        if (theValue == null) {
            this.value = 0;
            this.isnull = true;
        } else {
            try {
                this.value = Short.valueOf(theValue.trim());
            }
            catch (NumberFormatException nfe) {
                throw this.invalidFormat();
            }
            this.isnull = false;
        }
    }

    @Override
    public void setValue(short theValue) {
        this.value = theValue;
        this.isnull = false;
    }

    @Override
    public void setValue(byte theValue) {
        this.value = theValue;
        this.isnull = false;
    }

    @Override
    public void setValue(int theValue) throws StandardException {
        if (theValue > Short.MAX_VALUE || theValue < Short.MIN_VALUE) {
            throw StandardException.newException("22003", "SMALLINT");
        }
        this.value = (short)theValue;
        this.isnull = false;
    }

    @Override
    public void setValue(long theValue) throws StandardException {
        if (theValue > 32767L || theValue < -32768L) {
            throw StandardException.newException("22003", "SMALLINT");
        }
        this.value = (short)theValue;
        this.isnull = false;
    }

    @Override
    public void setValue(float theValue) throws StandardException {
        if ((theValue = NumberDataType.normalizeREAL(theValue)) > 32767.0f || theValue < -32768.0f) {
            throw StandardException.newException("22003", "SMALLINT");
        }
        float floorValue = (float)Math.floor(theValue);
        this.value = (short)floorValue;
        this.isnull = false;
    }

    @Override
    public void setValue(double theValue) throws StandardException {
        if ((theValue = NumberDataType.normalizeDOUBLE(theValue)) > 32767.0 || theValue < -32768.0) {
            throw StandardException.newException("22003", "SMALLINT");
        }
        double floorValue = Math.floor(theValue);
        this.value = (short)floorValue;
        this.isnull = false;
    }

    @Override
    public void setValue(boolean theValue) {
        this.value = theValue ? (short)1 : 0;
        this.isnull = false;
    }

    @Override
    protected void setFrom(DataValueDescriptor theValue) throws StandardException {
        this.setValue(theValue.getShort());
    }

    @Override
    public int typePrecedence() {
        return 40;
    }

    @Override
    public BooleanDataValue equals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getShort() == right.getShort());
    }

    @Override
    public BooleanDataValue notEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getShort() != right.getShort());
    }

    @Override
    public BooleanDataValue lessThan(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getShort() < right.getShort());
    }

    @Override
    public BooleanDataValue greaterThan(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getShort() > right.getShort());
    }

    @Override
    public BooleanDataValue lessOrEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getShort() <= right.getShort());
    }

    @Override
    public BooleanDataValue greaterOrEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getShort() >= right.getShort());
    }

    @Override
    public NumberDataValue times(NumberDataValue left, NumberDataValue right, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLSmallint();
        }
        if (left.isNull() || right.isNull()) {
            result.setToNull();
            return result;
        }
        int product = left.getShort() * right.getShort();
        result.setValue(product);
        return result;
    }

    @Override
    public NumberDataValue mod(NumberDataValue dividend, NumberDataValue divisor, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLSmallint();
        }
        if (dividend.isNull() || divisor.isNull()) {
            result.setToNull();
            return result;
        }
        short shortDivisor = divisor.getShort();
        if (shortDivisor == 0) {
            throw StandardException.newException("22012", new Object[0]);
        }
        result.setValue(dividend.getShort() % shortDivisor);
        return result;
    }

    @Override
    public NumberDataValue minus(NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLSmallint();
        }
        if (this.isNull()) {
            result.setToNull();
            return result;
        }
        short operandValue = this.getShort();
        result.setValue((int)(-operandValue));
        return result;
    }

    @Override
    protected boolean isNegative() {
        return !this.isNull() && this.value < 0;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return Short.toString(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    @Override
    public int estimateMemoryUsage() {
        return BASE_MEMORY_USAGE;
    }
}

