/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.db;

import org.apache.derby.iapi.db.Database;
import org.apache.derby.iapi.db.DatabaseContext;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextImpl;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;

final class DatabaseContextImpl
extends ContextImpl
implements DatabaseContext {
    private final Database db;

    DatabaseContextImpl(ContextManager cm, Database db) {
        super(cm, "Database");
        this.db = db;
    }

    @Override
    public void cleanupOnError(Throwable t) {
        DataDictionary dd;
        if (!(t instanceof StandardException)) {
            return;
        }
        StandardException se = (StandardException)t;
        if (se.getSeverity() < 40000) {
            return;
        }
        this.popMe();
        if (se.getSeverity() >= 45000 && (dd = this.db.getDataDictionary()) != null) {
            dd.disableIndexStatsRefresher();
        }
        if (se.getSeverity() == 45000) {
            ContextService.getFactory().notifyAllActiveThreads(this);
            Monitor.getMonitor().shutdown(this.db);
        }
    }

    public boolean equals(Object other) {
        if (other instanceof DatabaseContext) {
            return ((DatabaseContextImpl)other).db == this.db;
        }
        return false;
    }

    public int hashCode() {
        return this.db.hashCode();
    }

    @Override
    public Database getDatabase() {
        return this.db;
    }
}

