/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Map;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.CharacterStreamDescriptor;
import org.apache.derby.iapi.jdbc.EngineResultSet;
import org.apache.derby.iapi.services.io.CloseFilterInputStream;
import org.apache.derby.iapi.services.io.LimitInputStream;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.sql.PreparedStatement;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.execute.CursorActivation;
import org.apache.derby.iapi.sql.execute.ExecCursorTableReference;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RawToBinaryFormatStream;
import org.apache.derby.iapi.types.ReaderToUTF8Stream;
import org.apache.derby.iapi.types.SQLDecimal;
import org.apache.derby.iapi.types.StringDataValue;
import org.apache.derby.iapi.types.UserDataValue;
import org.apache.derby.iapi.types.VariableSizeDataValue;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.jdbc.BinaryToRawStream;
import org.apache.derby.impl.jdbc.ConnectionChild;
import org.apache.derby.impl.jdbc.EmbedBlob;
import org.apache.derby.impl.jdbc.EmbedClob;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.EmbedStatement;
import org.apache.derby.impl.jdbc.ReaderToAscii;
import org.apache.derby.impl.jdbc.TransactionResourceImpl;
import org.apache.derby.impl.jdbc.UTF8Reader;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.impl.sql.execute.ScrollInsensitiveResultSet;
import org.apache.derby.shared.common.sanity.SanityManager;

public class EmbedResultSet
extends ConnectionChild
implements EngineResultSet,
Comparable {
    private static long fetchedRowBase = 0L;
    protected static final int FIRST = 1;
    protected static final int NEXT = 2;
    protected static final int LAST = 3;
    protected static final int PREVIOUS = 4;
    protected static final int BEFOREFIRST = 5;
    protected static final int AFTERLAST = 6;
    protected static final int ABSOLUTE = 7;
    protected static final int RELATIVE = 8;
    private ExecRow currentRow;
    protected boolean wasNull;
    boolean isClosed;
    private boolean isOnInsertRow;
    private Object currentStream;
    private ResultSet theResults;
    private boolean forMetaData;
    private SQLWarning topWarning;
    Activation singleUseActivation;
    final int order;
    private final ResultDescription resultDescription;
    private long maxRows;
    private final int maxFieldSize;
    private long NumberofFetchedRows = fetchedRowBase;
    private final EmbedStatement stmt;
    private EmbedStatement owningStmt;
    private Statement applicationStmt;
    private final long timeoutMillis;
    private final boolean isAtomic;
    private final int concurrencyOfThisResultSet;
    private final ExecRow updateRow;
    private boolean[] columnGotUpdated;
    private boolean currentRowHasBeenUpdated;
    private int fetchDirection;
    private int fetchSize;
    private boolean[] columnUsedFlags;

    public EmbedResultSet(EmbedConnection conn, ResultSet resultsToWrap, boolean forMetaData, EmbedStatement stmt, boolean isAtomic) throws SQLException {
        super(conn);
        SanityManager.ASSERT(resultsToWrap != null);
        this.theResults = resultsToWrap;
        this.forMetaData = forMetaData;
        if (this.forMetaData) {
            this.singleUseActivation = resultsToWrap.getActivation();
        }
        this.stmt = this.owningStmt = stmt;
        this.applicationStmt = this.owningStmt;
        this.timeoutMillis = stmt == null ? 0L : stmt.timeoutMillis;
        this.isAtomic = isAtomic;
        if (stmt == null) {
            this.concurrencyOfThisResultSet = 1007;
        } else if (stmt.resultSetConcurrency == 1007) {
            this.concurrencyOfThisResultSet = 1007;
        } else if (!this.isForUpdate()) {
            this.concurrencyOfThisResultSet = 1007;
            SQLWarning w = StandardException.newWarning("01J06", new Object[0]);
            this.addWarning(w);
        } else {
            this.concurrencyOfThisResultSet = 1008;
        }
        this.resultDescription = this.theResults.getResultDescription();
        if (this.concurrencyOfThisResultSet == 1008) {
            int columnCount = this.resultDescription.getColumnCount();
            ExecutionFactory factory = conn.getLanguageConnection().getLanguageConnectionFactory().getExecutionFactory();
            try {
                this.columnGotUpdated = new boolean[columnCount];
                this.updateRow = factory.getValueRow(columnCount);
                for (int i = 1; i <= columnCount; ++i) {
                    this.updateRow.setColumn(i, this.resultDescription.getColumnDescriptor(i).getType().getNull());
                }
                this.initializeUpdateRowModifiers();
            }
            catch (StandardException t) {
                throw EmbedResultSet.noStateChangeException(t);
            }
        } else {
            this.updateRow = null;
        }
        if (stmt != null) {
            if (stmt.resultSetType == 1003) {
                this.maxRows = stmt.maxRows;
            }
            this.maxFieldSize = stmt.MaxFieldSize;
        } else {
            this.maxFieldSize = 0;
        }
        this.order = conn.getResultSetOrderId();
    }

    public static void setFetchedRowBase(long newBase) {
        fetchedRowBase = newBase;
    }

    private void checkNotOnInsertRow() throws SQLException {
        if (this.isOnInsertRow) {
            throw EmbedResultSet.newSQLException("24000", new Object[0]);
        }
    }

    protected final void checkOnRow() throws SQLException {
        if (this.currentRow == null) {
            throw EmbedResultSet.newSQLException("24000", new Object[0]);
        }
    }

    private void initializeUpdateRowModifiers() {
        this.currentRowHasBeenUpdated = false;
        Arrays.fill(this.columnGotUpdated, false);
    }

    final int getColumnType(int columnIndex) throws SQLException {
        if (!this.isOnInsertRow) {
            this.checkOnRow();
        }
        if (columnIndex < 1 || columnIndex > this.resultDescription.getColumnCount()) {
            throw EmbedResultSet.newSQLException("S0022", new Integer(columnIndex));
        }
        return this.resultDescription.getColumnDescriptor(columnIndex).getType().getJDBCTypeId();
    }

    @Override
    public boolean next() throws SQLException {
        if (this.maxRows != 0L) {
            ++this.NumberofFetchedRows;
            if (this.NumberofFetchedRows > this.maxRows) {
                this.closeCurrentStream();
                return false;
            }
        }
        return this.movePosition(2, 0, "next");
    }

    protected boolean movePosition(int position, String positionText) throws SQLException {
        return this.movePosition(position, 0, positionText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean movePosition(int position, int row, String positionText) throws SQLException {
        this.closeCurrentStream();
        this.checkExecIfClosed(positionText);
        if (this.isOnInsertRow) {
            this.moveToCurrentRow();
        }
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            boolean bl;
            this.setupContextStack();
            try {
                boolean onRow;
                ExecRow newRow;
                LanguageConnectionContext lcc = this.getEmbedConnection().getLanguageConnection();
                try {
                    StatementContext statementContext = lcc.pushStatementContext(this.isAtomic, this.concurrencyOfThisResultSet == 1007, this.getSQLText(), this.getParameterValueSet(), false, this.timeoutMillis);
                    switch (position) {
                        case 5: {
                            newRow = this.theResults.setBeforeFirstRow();
                            break;
                        }
                        case 1: {
                            newRow = this.theResults.getFirstRow();
                            break;
                        }
                        case 2: {
                            newRow = this.theResults.getNextRow();
                            break;
                        }
                        case 3: {
                            newRow = this.theResults.getLastRow();
                            break;
                        }
                        case 6: {
                            newRow = this.theResults.setAfterLastRow();
                            break;
                        }
                        case 4: {
                            newRow = this.theResults.getPreviousRow();
                            break;
                        }
                        case 7: {
                            newRow = this.theResults.getAbsoluteRow(row);
                            break;
                        }
                        case 8: {
                            newRow = this.theResults.getRelativeRow(row);
                            break;
                        }
                        default: {
                            newRow = null;
                            SanityManager.THROWASSERT("Unexpected value for position - " + position);
                        }
                    }
                    lcc.popStatementContext(statementContext, null);
                    InterruptStatus.restoreIntrFlagIfSeen(lcc);
                }
                catch (Throwable t) {
                    throw this.closeOnTransactionError(t);
                }
                SQLWarning w = this.theResults.getWarnings();
                if (w != null) {
                    this.addWarning(w);
                }
                boolean bl2 = onRow = (this.currentRow = newRow) != null;
                if (!(onRow || position != 2 || this.forMetaData && lcc.getActivationCount() > 1 || this.owningStmt == null || this.owningStmt.getResultSetType() != 1003)) {
                    this.owningStmt.resultSetClosing(this);
                }
                if (this.columnUsedFlags != null) {
                    Arrays.fill(this.columnUsedFlags, false);
                }
                if (this.columnGotUpdated != null && this.currentRowHasBeenUpdated) {
                    this.initializeUpdateRowModifiers();
                }
                bl = onRow;
            }
            catch (Throwable throwable) {
                this.restoreContextStack();
                throw throwable;
            }
            this.restoreContextStack();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.closeCurrentStream();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            try {
                this.setupContextStack();
            }
            catch (SQLException se) {
                return;
            }
            try {
                LanguageConnectionContext lcc = this.getEmbedConnection().getLanguageConnection();
                try {
                    this.theResults.close();
                    if (this.singleUseActivation != null) {
                        this.singleUseActivation.close();
                        this.singleUseActivation = null;
                    }
                    InterruptStatus.restoreIntrFlagIfSeen(lcc);
                }
                catch (Throwable t) {
                    throw this.handleException(t);
                }
                if (this.forMetaData) {
                    if (lcc.getActivationCount() > 1) {
                    } else if (this.owningStmt != null) {
                        this.owningStmt.resultSetClosing(this);
                    }
                } else if (this.owningStmt != null) {
                    this.owningStmt.resultSetClosing(this);
                }
            }
            finally {
                this.markClosed();
                this.restoreContextStack();
            }
            this.currentRow = null;
        }
    }

    private void markClosed() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        if (this.stmt != null) {
            this.stmt.closeMeOnCompletion();
        }
        if (this.owningStmt != null && this.owningStmt != this.stmt) {
            this.owningStmt.closeMeOnCompletion();
        }
    }

    @Override
    public final boolean wasNull() throws SQLException {
        this.checkIfClosed("wasNull");
        return this.wasNull;
    }

    @Override
    public final String getString(int columnIndex) throws SQLException {
        this.checkIfClosed("getString");
        int columnType = this.getColumnType(columnIndex);
        if (columnType == 2004 || columnType == 2005) {
            this.checkLOBMultiCall(columnIndex);
        }
        try {
            DataValueDescriptor dvd = this.getColumn(columnIndex);
            this.wasNull = dvd.isNull();
            if (this.wasNull) {
                return null;
            }
            String value = dvd.getString();
            if (this.maxFieldSize > 0 && EmbedResultSet.isMaxFieldSizeType(columnType) && value.length() > this.maxFieldSize) {
                value = value.substring(0, this.maxFieldSize);
            }
            return value;
        }
        catch (Throwable t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    @Override
    public final boolean getBoolean(int columnIndex) throws SQLException {
        this.checkIfClosed("getBoolean");
        try {
            DataValueDescriptor dvd = this.getColumn(columnIndex);
            this.wasNull = dvd.isNull();
            if (this.wasNull) {
                return false;
            }
            return dvd.getBoolean();
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    @Override
    public final byte getByte(int columnIndex) throws SQLException {
        this.checkIfClosed("getByte");
        try {
            DataValueDescriptor dvd = this.getColumn(columnIndex);
            this.wasNull = dvd.isNull();
            if (this.wasNull) {
                return 0;
            }
            return dvd.getByte();
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    @Override
    public final short getShort(int columnIndex) throws SQLException {
        this.checkIfClosed("getShort");
        try {
            DataValueDescriptor dvd = this.getColumn(columnIndex);
            this.wasNull = dvd.isNull();
            if (this.wasNull) {
                return 0;
            }
            return dvd.getShort();
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    @Override
    public final int getInt(int columnIndex) throws SQLException {
        this.checkIfClosed("getInt");
        try {
            DataValueDescriptor dvd = this.getColumn(columnIndex);
            this.wasNull = dvd.isNull();
            if (this.wasNull) {
                return 0;
            }
            return dvd.getInt();
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    @Override
    public final long getLong(int columnIndex) throws SQLException {
        this.checkIfClosed("getLong");
        try {
            DataValueDescriptor dvd = this.getColumn(columnIndex);
            this.wasNull = dvd.isNull();
            if (this.wasNull) {
                return 0L;
            }
            return dvd.getLong();
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    @Override
    public final float getFloat(int columnIndex) throws SQLException {
        this.checkIfClosed("getFloat");
        try {
            DataValueDescriptor dvd = this.getColumn(columnIndex);
            this.wasNull = dvd.isNull();
            if (this.wasNull) {
                return 0.0f;
            }
            return dvd.getFloat();
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    @Override
    public final double getDouble(int columnIndex) throws SQLException {
        this.checkIfClosed("getDouble");
        try {
            DataValueDescriptor dvd = this.getColumn(columnIndex);
            this.wasNull = dvd.isNull();
            if (this.wasNull) {
                return 0.0;
            }
            return dvd.getDouble();
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    @Override
    public final byte[] getBytes(int columnIndex) throws SQLException {
        this.checkIfClosed("getBytes");
        int columnType = this.getColumnType(columnIndex);
        if (columnType == 2004) {
            this.checkLOBMultiCall(columnIndex);
        }
        try {
            DataValueDescriptor dvd = this.getColumn(columnIndex);
            this.wasNull = dvd.isNull();
            if (this.wasNull) {
                return null;
            }
            byte[] value = dvd.getBytes();
            if (this.maxFieldSize > 0 && EmbedResultSet.isMaxFieldSizeType(columnType) && value.length > this.maxFieldSize) {
                byte[] limited_value = new byte[this.maxFieldSize];
                System.arraycopy(value, 0, limited_value, 0, this.maxFieldSize);
                value = limited_value;
            }
            return value;
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    @Override
    public final Date getDate(int columnIndex) throws SQLException {
        return this.getDate(columnIndex, (Calendar)null);
    }

    @Override
    public final Time getTime(int columnIndex) throws SQLException {
        return this.getTime(columnIndex, (Calendar)null);
    }

    @Override
    public final Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getTimestamp(columnIndex, (Calendar)null);
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        this.checkIfClosed("getDate");
        try {
            DataValueDescriptor dvd = this.getColumn(columnIndex);
            this.wasNull = dvd.isNull();
            if (this.wasNull) {
                return null;
            }
            if (cal == null) {
                cal = this.getCal();
            }
            return dvd.getDate(cal);
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        this.checkIfClosed("getDate");
        return this.getDate(this.findColumnName(columnName), cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        this.checkIfClosed("getTime");
        try {
            DataValueDescriptor dvd = this.getColumn(columnIndex);
            this.wasNull = dvd.isNull();
            if (this.wasNull) {
                return null;
            }
            if (cal == null) {
                cal = this.getCal();
            }
            return dvd.getTime(cal);
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        this.checkIfClosed("getTime");
        return this.getTime(this.findColumnName(columnName), cal);
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        this.checkIfClosed("getTimestamp");
        return this.getTimestamp(this.findColumnName(columnName), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        this.checkIfClosed("getTimestamp");
        try {
            DataValueDescriptor dvd = this.getColumn(columnIndex);
            this.wasNull = dvd.isNull();
            if (this.wasNull) {
                return null;
            }
            if (cal == null) {
                cal = this.getCal();
            }
            return dvd.getTimestamp(cal);
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Reader getCharacterStream(int columnIndex) throws SQLException {
        Object syncLock;
        int lmfs;
        this.checkIfClosed("getCharacterStream");
        int colType = this.getColumnType(columnIndex);
        switch (colType) {
            case -1: 
            case 1: 
            case 12: {
                lmfs = this.maxFieldSize;
                break;
            }
            case 2005: {
                lmfs = 0;
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                try {
                    InputStream is = this.getBinaryStream(columnIndex);
                    if (is == null) {
                        return null;
                    }
                    InputStreamReader r = new InputStreamReader(is, "UTF-16BE");
                    this.currentStream = r;
                    return r;
                }
                catch (UnsupportedEncodingException uee) {
                    throw new SQLException(uee.getMessage());
                }
            }
            default: {
                throw this.dataTypeConversion("java.io.Reader", columnIndex);
            }
        }
        Object object = syncLock = this.getConnectionSynchronization();
        synchronized (object) {
            boolean pushStack = false;
            try {
                Reader ret;
                this.useStreamOrLOB(columnIndex);
                StringDataValue dvd = (StringDataValue)this.getColumn(columnIndex);
                this.wasNull = dvd.isNull();
                if (this.wasNull) {
                    Reader reader = null;
                    return reader;
                }
                pushStack = true;
                this.setupContextStack();
                if (dvd.hasStream()) {
                    CharacterStreamDescriptor csd = dvd.getStreamWithDescriptor();
                    if (lmfs > 0) {
                        csd = new CharacterStreamDescriptor.Builder().copyState(csd).maxCharLength(lmfs).build();
                    }
                    ret = new UTF8Reader(csd, this, syncLock);
                } else {
                    String val = dvd.getString();
                    if (lmfs > 0 && val.length() > lmfs) {
                        val = val.substring(0, lmfs);
                    }
                    ret = new StringReader(val);
                }
                this.currentStream = ret;
                Reader reader = ret;
                return reader;
            }
            catch (Throwable t) {
                throw EmbedResultSet.noStateChangeException(t);
            }
            finally {
                if (pushStack) {
                    this.restoreContextStack();
                }
            }
        }
    }

    @Override
    public final InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.checkIfClosed("getAsciiStream");
        int colType = this.getColumnType(columnIndex);
        switch (colType) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return this.getBinaryStream(columnIndex);
            }
            default: {
                throw this.dataTypeConversion("java.io.InputStream(ASCII)", columnIndex);
            }
        }
        Reader reader = this.getCharacterStream(columnIndex);
        if (reader == null) {
            return null;
        }
        return new ReaderToAscii(reader);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final InputStream getBinaryStream(int columnIndex) throws SQLException {
        Object syncLock;
        int lmfs;
        this.checkIfClosed("getBinaryStream");
        int colType = this.getColumnType(columnIndex);
        switch (colType) {
            case -4: 
            case -3: 
            case -2: {
                lmfs = this.maxFieldSize;
                break;
            }
            case 2004: {
                lmfs = 0;
                break;
            }
            default: {
                throw this.dataTypeConversion("java.io.InputStream", columnIndex);
            }
        }
        Object object = syncLock = this.getConnectionSynchronization();
        synchronized (object) {
            boolean pushStack = false;
            try {
                this.useStreamOrLOB(columnIndex);
                DataValueDescriptor dvd = this.getColumn(columnIndex);
                this.wasNull = dvd.isNull();
                if (this.wasNull) {
                    InputStream inputStream = null;
                    return inputStream;
                }
                pushStack = true;
                this.setupContextStack();
                InputStream stream = dvd.hasStream() ? new BinaryToRawStream(dvd.getStream(), dvd) : new ByteArrayInputStream(dvd.getBytes());
                if (lmfs > 0) {
                    LimitInputStream limitResultIn = new LimitInputStream(stream);
                    limitResultIn.setLimit(lmfs);
                    stream = limitResultIn;
                }
                stream = new CloseFilterInputStream(stream);
                this.currentStream = stream;
                InputStream inputStream = stream;
                return inputStream;
            }
            catch (Throwable t) {
                throw EmbedResultSet.noStateChangeException(t);
            }
            finally {
                if (pushStack) {
                    this.restoreContextStack();
                }
            }
        }
    }

    @Override
    public final String getString(String columnName) throws SQLException {
        this.checkIfClosed("getString");
        return this.getString(this.findColumnName(columnName));
    }

    @Override
    public final boolean getBoolean(String columnName) throws SQLException {
        this.checkIfClosed("getBoolean");
        return this.getBoolean(this.findColumnName(columnName));
    }

    @Override
    public final byte getByte(String columnName) throws SQLException {
        this.checkIfClosed("getByte");
        return this.getByte(this.findColumnName(columnName));
    }

    @Override
    public final short getShort(String columnName) throws SQLException {
        this.checkIfClosed("getShort");
        return this.getShort(this.findColumnName(columnName));
    }

    @Override
    public final int getInt(String columnName) throws SQLException {
        this.checkIfClosed("getInt");
        return this.getInt(this.findColumnName(columnName));
    }

    @Override
    public final long getLong(String columnName) throws SQLException {
        this.checkIfClosed("getLong");
        return this.getLong(this.findColumnName(columnName));
    }

    @Override
    public final float getFloat(String columnName) throws SQLException {
        this.checkIfClosed("getFloat");
        return this.getFloat(this.findColumnName(columnName));
    }

    @Override
    public final double getDouble(String columnName) throws SQLException {
        this.checkIfClosed("getDouble");
        return this.getDouble(this.findColumnName(columnName));
    }

    @Override
    @Deprecated
    public final BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        BigDecimal ret = this.getBigDecimal(columnIndex);
        if (ret != null) {
            return ret.setScale(scale, 5);
        }
        return null;
    }

    @Override
    public final BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.checkIfClosed("getBigDecimal");
        try {
            DataValueDescriptor dvd = this.getColumn(columnIndex);
            this.wasNull = dvd.isNull();
            if (this.wasNull) {
                return null;
            }
            return SQLDecimal.getBigDecimal(dvd);
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    @Override
    @Deprecated
    public final BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        this.checkIfClosed("getBigDecimal");
        return this.getBigDecimal(this.findColumnName(columnName), scale);
    }

    @Override
    public final BigDecimal getBigDecimal(String columnName) throws SQLException {
        this.checkIfClosed("getBigDecimal");
        return this.getBigDecimal(this.findColumnName(columnName));
    }

    @Override
    public final byte[] getBytes(String columnName) throws SQLException {
        this.checkIfClosed("getBytes");
        return this.getBytes(this.findColumnName(columnName));
    }

    @Override
    public final Date getDate(String columnName) throws SQLException {
        this.checkIfClosed("getDate");
        return this.getDate(this.findColumnName(columnName));
    }

    @Override
    public final Time getTime(String columnName) throws SQLException {
        this.checkIfClosed("getTime");
        return this.getTime(this.findColumnName(columnName));
    }

    @Override
    public final Timestamp getTimestamp(String columnName) throws SQLException {
        this.checkIfClosed("getTimestamp");
        return this.getTimestamp(this.findColumnName(columnName));
    }

    @Override
    public final Reader getCharacterStream(String columnName) throws SQLException {
        this.checkIfClosed("getCharacterStream");
        return this.getCharacterStream(this.findColumnName(columnName));
    }

    @Override
    public final InputStream getAsciiStream(String columnName) throws SQLException {
        this.checkIfClosed("getAsciiStream");
        return this.getAsciiStream(this.findColumnName(columnName));
    }

    @Override
    public final InputStream getBinaryStream(String columnName) throws SQLException {
        this.checkIfClosed("getBinaryStream");
        return this.getBinaryStream(this.findColumnName(columnName));
    }

    @Override
    @Deprecated
    public final InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw Util.notImplemented("getUnicodeStream");
    }

    @Override
    @Deprecated
    public final InputStream getUnicodeStream(String columnName) throws SQLException {
        throw Util.notImplemented("getUnicodeStream");
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final SQLWarning getWarnings() throws SQLException {
        this.checkIfClosed("getWarnings");
        return this.topWarning;
    }

    @Override
    public final void clearWarnings() throws SQLException {
        this.checkIfClosed("clearWarnings");
        this.topWarning = null;
    }

    @Override
    public final String getCursorName() throws SQLException {
        this.checkIfClosed("getCursorName");
        return this.theResults.getCursorName();
    }

    @Override
    public final ResultSetMetaData getMetaData() throws SQLException {
        this.checkIfClosed("getMetaData");
        ResultSetMetaData rMetaData = this.resultDescription.getMetaData();
        if (rMetaData == null) {
            rMetaData = this.factory.newEmbedResultSetMetaData(this.resultDescription.getColumnInfo());
            this.resultDescription.setMetaData(rMetaData);
        }
        return rMetaData;
    }

    @Override
    public final int getHoldability() throws SQLException {
        this.checkIfClosed("getHoldability");
        if (this.theResults.getActivation().getResultSetHoldability()) {
            return 1;
        }
        return 2;
    }

    @Override
    public final Object getObject(int columnIndex) throws SQLException {
        this.checkIfClosed("getObject");
        int colType = this.getColumnType(columnIndex);
        switch (colType) {
            case -1: 
            case 1: 
            case 12: {
                return this.getString(columnIndex);
            }
            case 2005: {
                return this.getClob(columnIndex);
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytes(columnIndex);
            }
            case 2004: {
                return this.getBlob(columnIndex);
            }
        }
        try {
            DataValueDescriptor dvd = this.getColumn(columnIndex);
            this.wasNull = dvd.isNull();
            if (this.wasNull) {
                return null;
            }
            return dvd.getObject();
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    @Override
    public final Object getObject(String columnName) throws SQLException {
        this.checkIfClosed("getObject");
        return this.getObject(this.findColumnName(columnName));
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        this.checkIfClosed("getObject");
        if (map == null) {
            throw Util.generateCsSQLException("XJ081.S", map, "map", "java.sql.ResultSet.getObject");
        }
        if (!map.isEmpty()) {
            throw Util.notImplemented();
        }
        return this.getObject(columnIndex);
    }

    @Override
    public Object getObject(String colName, Map<String, Class<?>> map) throws SQLException {
        this.checkIfClosed("getObject");
        return this.getObject(this.findColumn(colName), map);
    }

    @Override
    public final int findColumn(String columnName) throws SQLException {
        this.checkIfClosed("findColumn");
        return this.findColumnName(columnName);
    }

    @Override
    public final Statement getStatement() throws SQLException {
        this.checkIfClosed("getStatement");
        return this.applicationStmt;
    }

    public final void setApplicationStatement(Statement applicationStmt) {
        this.applicationStmt = applicationStmt;
    }

    @Override
    public final Ref getRef(int i) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final Array getArray(int i) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final Ref getRef(String colName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final Array getArray(String colName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.checkRowPosition(101, "isBeforeFirst");
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.checkRowPosition(104, "isAfterLast");
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.checkRowPosition(102, "isFirst");
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.checkRowPosition(103, "isLast");
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkScrollCursor("beforeFirst()");
        this.movePosition(5, "beforeFirst");
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkScrollCursor("afterLast()");
        this.movePosition(6, "afterLast");
    }

    @Override
    public boolean first() throws SQLException {
        this.checkScrollCursor("first()");
        return this.movePosition(1, "first");
    }

    @Override
    public boolean last() throws SQLException {
        this.checkScrollCursor("last()");
        return this.movePosition(3, "last");
    }

    @Override
    public int getRow() throws SQLException {
        this.checkScrollCursor("getRow()");
        return this.theResults.getRowNumber();
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.checkScrollCursor("absolute()");
        return this.movePosition(7, row, "absolute");
    }

    @Override
    public boolean relative(int row) throws SQLException {
        this.checkScrollCursor("relative()");
        return this.movePosition(8, row, "relative");
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkScrollCursor("previous()");
        return this.movePosition(4, "previous");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkScrollCursor("setFetchDirection()");
        this.fetchDirection = direction;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkIfClosed("getFetchDirection");
        if (this.fetchDirection == 0) {
            return this.stmt.getFetchDirection();
        }
        return this.fetchDirection;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkIfClosed("setFetchSize");
        if (rows < 0) {
            throw Util.generateCsSQLException("XJ062.S", new Integer(rows));
        }
        if (rows > 0) {
            this.fetchSize = rows;
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkIfClosed("getFetchSize");
        if (this.fetchSize == 0) {
            return this.stmt.getFetchSize();
        }
        return this.fetchSize;
    }

    @Override
    public int getType() throws SQLException {
        this.checkIfClosed("getType");
        return this.stmt.getResultSetType();
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkIfClosed("getConcurrency");
        return this.concurrencyOfThisResultSet;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.checkIfClosed("rowUpdated");
        this.checkNotOnInsertRow();
        this.checkOnRow();
        boolean rvalue = false;
        try {
            if (this.isForUpdate() && this.getType() == 1004) {
                rvalue = ((ScrollInsensitiveResultSet)this.theResults).isUpdated();
            }
        }
        catch (Throwable t) {
            this.handleException(t);
        }
        return rvalue;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.checkIfClosed("rowInserted");
        this.checkNotOnInsertRow();
        this.checkOnRow();
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.checkIfClosed("rowDeleted");
        this.checkNotOnInsertRow();
        this.checkOnRow();
        boolean rvalue = false;
        try {
            if (this.isForUpdate() && this.getType() == 1004) {
                rvalue = ((ScrollInsensitiveResultSet)this.theResults).isDeleted();
            }
        }
        catch (Throwable t) {
            this.handleException(t);
        }
        return rvalue;
    }

    protected void checksBeforeUpdateXXX(String methodName, int columnIndex) throws SQLException {
        this.checksBeforeUpdateOrDelete(methodName, columnIndex);
        ResultDescription rd = this.theResults.getResultDescription();
        if (columnIndex < 1 || columnIndex > rd.getColumnCount()) {
            throw Util.generateCsSQLException("XCL14.S", new Integer(columnIndex), String.valueOf(rd.getColumnCount()));
        }
        if (rd.getColumnDescriptor(columnIndex).getSourceTableName() == null) {
            throw Util.generateCsSQLException("XJ084.U", methodName);
        }
        if (!this.getMetaData().isWritable(columnIndex)) {
            throw Util.generateCsSQLException("42X31", this.theResults.getResultDescription().getColumnDescriptor(columnIndex).getName(), this.getCursorName());
        }
    }

    protected void checksBeforeUpdateOrDelete(String methodName, int columnIndex) throws SQLException {
        this.checkIfClosed(methodName);
        this.checkUpdatableCursor(methodName);
        if (!this.isOnInsertRow) {
            this.checkOnRow();
        }
    }

    protected DataValueDescriptor getDVDforColumnToBeUpdated(int columnIndex, String updateMethodName) throws StandardException, SQLException {
        this.checksBeforeUpdateXXX(updateMethodName, columnIndex);
        this.columnGotUpdated[columnIndex - 1] = true;
        this.currentRowHasBeenUpdated = true;
        return this.updateRow.getColumn(columnIndex);
    }

    protected void checksBeforeInsert() throws SQLException {
        this.checkIfClosed("insertRow");
        this.checkUpdatableCursor("insertRow");
        if (!this.isOnInsertRow) {
            throw EmbedResultSet.newSQLException("XJ086.S", new Object[0]);
        }
    }

    private void checksBeforeUpdateAsciiStream(int columnIndex) throws SQLException {
        this.checksBeforeUpdateXXX("updateAsciiStream", columnIndex);
        int colType = this.getColumnType(columnIndex);
        if (!DataTypeDescriptor.isAsciiStreamAssignable(colType)) {
            throw this.dataTypeConversion(columnIndex, "java.io.InputStream");
        }
    }

    private void checksBeforeUpdateBinaryStream(int columnIndex) throws SQLException {
        this.checksBeforeUpdateXXX("updateBinaryStream", columnIndex);
        int colType = this.getColumnType(columnIndex);
        if (!DataTypeDescriptor.isBinaryStreamAssignable(colType)) {
            throw this.dataTypeConversion(columnIndex, "java.io.InputStream");
        }
    }

    private void checksBeforeUpdateCharacterStream(int columnIndex) throws SQLException {
        this.checksBeforeUpdateXXX("updateCharacterStream", columnIndex);
        int colType = this.getColumnType(columnIndex);
        if (!DataTypeDescriptor.isCharacterStreamAssignable(colType)) {
            throw this.dataTypeConversion(columnIndex, "java.io.Reader");
        }
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(columnIndex, "updateNull").setToNull();
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(columnIndex, "updateBoolean").setValue(x);
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(columnIndex, "updateByte").setValue(x);
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(columnIndex, "updateShort").setValue(x);
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(columnIndex, "updateInt").setValue(x);
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(columnIndex, "updateLong").setValue(x);
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(columnIndex, "updateFloat").setValue(x);
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(columnIndex, "updateDouble").setValue(x);
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(columnIndex, "updateBigDecimal").setBigDecimal(x);
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.checkIfClosed("updateBigDecimal");
        this.updateBigDecimal(this.findColumnName(columnName), x);
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(columnIndex, "updateString").setValue(x);
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(columnIndex, "updateBytes").setValue(x);
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(columnIndex, "updateDate").setValue(x);
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(columnIndex, "updateTime").setValue(x);
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(columnIndex, "updateTimestamp").setValue(x);
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.checksBeforeUpdateAsciiStream(columnIndex);
        InputStreamReader r = null;
        if (x != null) {
            try {
                r = new InputStreamReader(x, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException uee) {
                throw new SQLException(uee.getMessage());
            }
        }
        this.updateCharacterStreamInternal(columnIndex, r, false, length, "updateAsciiStream");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this.checksBeforeUpdateAsciiStream(columnIndex);
        InputStreamReader r = null;
        if (x != null) {
            try {
                r = new InputStreamReader(x, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException uee) {
                throw new SQLException(uee.getMessage());
            }
        }
        this.updateCharacterStreamInternal(columnIndex, r, true, -1L, "updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.checksBeforeUpdateBinaryStream(columnIndex);
        if (x == null) {
            this.updateNull(columnIndex);
            return;
        }
        this.updateBinaryStreamInternal(columnIndex, x, false, length, "updateBinaryStream");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this.checksBeforeUpdateBinaryStream(columnIndex);
        this.updateBinaryStreamInternal(columnIndex, x, true, -1L, "updateBinaryStream");
    }

    private void updateBinaryStreamInternal(int columnIndex, InputStream x, boolean lengthLess, long length, String updateMethodName) throws SQLException {
        RawToBinaryFormatStream rawStream;
        if (!lengthLess) {
            if (length < 0L) {
                throw EmbedResultSet.newSQLException("XJ025.S", new Object[0]);
            }
            if (length > Integer.MAX_VALUE) {
                throw EmbedResultSet.newSQLException("22003", this.getColumnSQLType(columnIndex));
            }
            rawStream = new RawToBinaryFormatStream(x, (int)length);
        } else {
            length = -1L;
            rawStream = new RawToBinaryFormatStream(x, this.getMaxColumnWidth(columnIndex), this.getColumnSQLType(columnIndex));
        }
        try {
            this.getDVDforColumnToBeUpdated(columnIndex, updateMethodName).setValue(rawStream, (int)length);
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.checksBeforeUpdateCharacterStream(columnIndex);
        this.updateCharacterStreamInternal(columnIndex, x, false, length, "updateCharacterStream");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.checksBeforeUpdateCharacterStream(columnIndex);
        this.updateCharacterStreamInternal(columnIndex, x, true, -1L, "updateCharacterStream");
    }

    private void updateCharacterStreamInternal(int columnIndex, Reader reader, boolean lengthLess, long length, String updateMethodName) throws SQLException {
        try {
            ReaderToUTF8Stream utfIn;
            if (reader == null) {
                this.updateNull(columnIndex);
                return;
            }
            StringDataValue dvd = (StringDataValue)this.getDVDforColumnToBeUpdated(columnIndex, updateMethodName);
            dvd.setStreamHeaderFormat(!this.getEmbedConnection().getDatabase().getDataDictionary().checkVersion(170, null));
            int usableLength = -1;
            if (!lengthLess) {
                int colWidth;
                if (length < 0L) {
                    throw EmbedResultSet.newSQLException("XJ025.S", new Object[0]);
                }
                if (length > Integer.MAX_VALUE) {
                    throw EmbedResultSet.newSQLException("22003", this.getColumnSQLType(columnIndex));
                }
                usableLength = (int)length;
                int truncationLength = 0;
                if (this.getColumnType(columnIndex) == 2005 && usableLength > (colWidth = this.getMaxColumnWidth(columnIndex))) {
                    truncationLength = usableLength - colWidth;
                    usableLength = colWidth;
                }
                utfIn = new ReaderToUTF8Stream(reader, usableLength, truncationLength, this.getColumnSQLType(columnIndex), dvd.getStreamHeaderGenerator());
            } else {
                int colWidth = this.getMaxColumnWidth(columnIndex);
                utfIn = new ReaderToUTF8Stream(reader, colWidth, this.getColumnSQLType(columnIndex), dvd.getStreamHeaderGenerator());
            }
            dvd.setValue(utfIn, usableLength);
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.updateObject(columnIndex, x);
        this.adjustScale(columnIndex, scale);
    }

    protected void adjustScale(int columnIndex, int scale) throws SQLException {
        int colType = this.getColumnType(columnIndex);
        if (colType == 3 || colType == 2) {
            if (scale < 0) {
                throw EmbedResultSet.newSQLException("XJ044.S", new Integer(scale));
            }
            try {
                DataValueDescriptor value = this.updateRow.getColumn(columnIndex);
                int origvaluelen = value.getLength();
                ((VariableSizeDataValue)((Object)value)).setWidth(-1, scale, false);
            }
            catch (StandardException t) {
                throw EmbedResultSet.noStateChangeException(t);
            }
        }
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.checksBeforeUpdateXXX("updateObject", columnIndex);
        int colType = this.getColumnType(columnIndex);
        if (colType == 2000) {
            try {
                ((UserDataValue)this.getDVDforColumnToBeUpdated(columnIndex, "updateObject")).setValue(x);
                return;
            }
            catch (StandardException t) {
                throw EmbedResultSet.noStateChangeException(t);
            }
        }
        if (x == null) {
            this.updateNull(columnIndex);
            return;
        }
        if (x instanceof String) {
            this.updateString(columnIndex, (String)x);
            return;
        }
        if (x instanceof Boolean) {
            this.updateBoolean(columnIndex, (boolean)((Boolean)x));
            return;
        }
        if (x instanceof Short) {
            this.updateShort(columnIndex, (short)((Short)x));
            return;
        }
        if (x instanceof Integer) {
            this.updateInt(columnIndex, (int)((Integer)x));
            return;
        }
        if (x instanceof Long) {
            this.updateLong(columnIndex, (long)((Long)x));
            return;
        }
        if (x instanceof Float) {
            this.updateFloat(columnIndex, ((Float)x).floatValue());
            return;
        }
        if (x instanceof Double) {
            this.updateDouble(columnIndex, (double)((Double)x));
            return;
        }
        if (x instanceof BigDecimal) {
            this.updateBigDecimal(columnIndex, (BigDecimal)x);
            return;
        }
        if (x instanceof byte[]) {
            this.updateBytes(columnIndex, (byte[])x);
            return;
        }
        if (x instanceof Date) {
            this.updateDate(columnIndex, (Date)x);
            return;
        }
        if (x instanceof Time) {
            this.updateTime(columnIndex, (Time)x);
            return;
        }
        if (x instanceof Timestamp) {
            this.updateTimestamp(columnIndex, (Timestamp)x);
            return;
        }
        if (x instanceof Blob) {
            this.updateBlob(columnIndex, (Blob)x);
            return;
        }
        if (x instanceof Clob) {
            this.updateClob(columnIndex, (Clob)x);
            return;
        }
        throw this.dataTypeConversion(columnIndex, x.getClass().getName());
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        this.checkIfClosed("updateNull");
        this.updateNull(this.findColumnName(columnName));
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.checkIfClosed("updateBoolean");
        this.updateBoolean(this.findColumnName(columnName), x);
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        this.checkIfClosed("updateByte");
        this.updateByte(this.findColumnName(columnName), x);
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        this.checkIfClosed("updateShort");
        this.updateShort(this.findColumnName(columnName), x);
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        this.checkIfClosed("updateInt");
        this.updateInt(this.findColumnName(columnName), x);
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        this.checkIfClosed("updateLong");
        this.updateLong(this.findColumnName(columnName), x);
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        this.checkIfClosed("updateFloat");
        this.updateFloat(this.findColumnName(columnName), x);
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        this.checkIfClosed("updateDouble");
        this.updateDouble(this.findColumnName(columnName), x);
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        this.checkIfClosed("updateString");
        this.updateString(this.findColumnName(columnName), x);
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.checkIfClosed("updateBytes");
        this.updateBytes(this.findColumnName(columnName), x);
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        this.checkIfClosed("updateDate");
        this.updateDate(this.findColumnName(columnName), x);
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        this.checkIfClosed("updateTime");
        this.updateTime(this.findColumnName(columnName), x);
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.checkIfClosed("updateTimestamp");
        this.updateTimestamp(this.findColumnName(columnName), x);
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.checkIfClosed("updateAsciiStream");
        this.updateAsciiStream(this.findColumnName(columnName), x, length);
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.checkIfClosed("updateBinaryStream");
        this.updateBinaryStream(this.findColumnName(columnName), x, length);
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.checkIfClosed("updateCharacterStream");
        this.updateCharacterStream(this.findColumnName(columnName), reader, length);
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.checkIfClosed("updateObject");
        this.updateObject(this.findColumnName(columnName), x, scale);
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        this.checkIfClosed("updateObject");
        this.updateObject(this.findColumnName(columnName), x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertRow() throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.checksBeforeInsert();
            this.setupContextStack();
            LanguageConnectionContext lcc = this.getEmbedConnection().getLanguageConnection();
            StatementContext statementContext = null;
            try {
                boolean foundOneColumnAlready = false;
                StringBuffer insertSQL = new StringBuffer("INSERT INTO ");
                StringBuffer valuesSQL = new StringBuffer("VALUES (");
                CursorActivation activation = lcc.lookupCursorActivation(this.getCursorName());
                ExecCursorTableReference targetTable = activation.getPreparedStatement().getTargetTable();
                insertSQL.append(this.getFullBaseTableName(targetTable));
                ResultDescription rd = this.theResults.getResultDescription();
                insertSQL.append(" (");
                for (int i = 1; i <= rd.getColumnCount(); ++i) {
                    if (foundOneColumnAlready) {
                        insertSQL.append(",");
                        valuesSQL.append(",");
                    }
                    insertSQL.append(IdUtil.normalToDelimited(rd.getColumnDescriptor(i).getName()));
                    if (this.columnGotUpdated[i - 1]) {
                        valuesSQL.append("?");
                    } else {
                        valuesSQL.append("DEFAULT");
                    }
                    foundOneColumnAlready = true;
                }
                insertSQL.append(") ");
                valuesSQL.append(") ");
                insertSQL.append(valuesSQL);
                StatementContext currSC = lcc.getStatementContext();
                Activation parentAct = null;
                if (currSC != null) {
                    parentAct = currSC.getActivation();
                }
                statementContext = lcc.pushStatementContext(this.isAtomic, false, insertSQL.toString(), null, false, 0L);
                statementContext.setActivation(parentAct);
                PreparedStatement ps = lcc.prepareInternalStatement(insertSQL.toString());
                Activation act = ps.getActivation(lcc, false);
                statementContext.setActivation(act);
                int paramPosition = 0;
                for (int i = 1; i <= rd.getColumnCount(); ++i) {
                    if (!this.columnGotUpdated[i - 1]) continue;
                    act.getParameterValueSet().getParameterForSet(paramPosition++).setValue(this.updateRow.getColumn(i));
                }
                ResultSet rs = ps.executeSubStatement(activation, act, true, 0L);
                act.close();
                lcc.popStatementContext(statementContext, null);
                InterruptStatus.restoreIntrFlagIfSeen(lcc);
                if (statementContext != null) {
                    lcc.popStatementContext(statementContext, null);
                }
            }
            catch (Throwable t) {
                try {
                    throw this.closeOnTransactionError(t);
                }
                catch (Throwable throwable) {
                    if (statementContext != null) {
                        lcc.popStatementContext(statementContext, null);
                    }
                    this.restoreContextStack();
                    throw throwable;
                }
            }
            this.restoreContextStack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRow() throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            StatementContext statementContext;
            LanguageConnectionContext lcc;
            block17: {
                block18: {
                    this.checksBeforeUpdateOrDelete("updateRow", -1);
                    this.checkNotOnInsertRow();
                    this.setupContextStack();
                    lcc = this.getEmbedConnection().getLanguageConnection();
                    statementContext = null;
                    if (this.currentRowHasBeenUpdated) break block17;
                    if (statementContext == null) break block18;
                    lcc.popStatementContext(statementContext, null);
                }
                this.restoreContextStack();
                this.initializeUpdateRowModifiers();
                return;
            }
            try {
                boolean foundOneColumnAlready = false;
                StringBuffer updateWhereCurrentOfSQL = new StringBuffer("UPDATE ");
                CursorActivation activation = lcc.lookupCursorActivation(this.getCursorName());
                ExecCursorTableReference targetTable = activation.getPreparedStatement().getTargetTable();
                updateWhereCurrentOfSQL.append(this.getFullBaseTableName(targetTable));
                updateWhereCurrentOfSQL.append(" SET ");
                ResultDescription rd = this.theResults.getResultDescription();
                for (int i = 1; i <= rd.getColumnCount(); ++i) {
                    if (!this.columnGotUpdated[i - 1]) continue;
                    if (foundOneColumnAlready) {
                        updateWhereCurrentOfSQL.append(",");
                    }
                    updateWhereCurrentOfSQL.append(IdUtil.normalToDelimited(rd.getColumnDescriptor(i).getName()) + "=?");
                    foundOneColumnAlready = true;
                }
                updateWhereCurrentOfSQL.append(" WHERE CURRENT OF " + IdUtil.normalToDelimited(this.getCursorName()));
                StatementContext currSC = lcc.getStatementContext();
                Activation parentAct = null;
                if (currSC != null) {
                    parentAct = currSC.getActivation();
                }
                statementContext = lcc.pushStatementContext(this.isAtomic, false, updateWhereCurrentOfSQL.toString(), null, false, 0L);
                statementContext.setActivation(parentAct);
                PreparedStatement ps = lcc.prepareInternalStatement(updateWhereCurrentOfSQL.toString());
                Activation act = ps.getActivation(lcc, false);
                statementContext.setActivation(act);
                int paramPosition = 0;
                for (int i = 1; i <= rd.getColumnCount(); ++i) {
                    if (!this.columnGotUpdated[i - 1]) continue;
                    act.getParameterValueSet().getParameterForSet(paramPosition++).setValue(this.updateRow.getColumn(i));
                }
                ResultSet rs = ps.executeSubStatement(activation, act, true, 0L);
                SQLWarning w = act.getWarnings();
                if (w != null) {
                    this.addWarning(w);
                }
                act.close();
                if (this.getType() == 1003) {
                    this.currentRow = null;
                } else {
                    this.movePosition(8, 0, "relative");
                }
                lcc.popStatementContext(statementContext, null);
                InterruptStatus.restoreIntrFlagIfSeen(lcc);
                if (statementContext != null) {
                    lcc.popStatementContext(statementContext, null);
                }
            }
            catch (Throwable t) {
                try {
                    throw this.closeOnTransactionError(t);
                }
                catch (Throwable throwable) {
                    if (statementContext != null) {
                        lcc.popStatementContext(statementContext, null);
                    }
                    this.restoreContextStack();
                    this.initializeUpdateRowModifiers();
                    throw throwable;
                }
            }
            this.restoreContextStack();
            this.initializeUpdateRowModifiers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRow() throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.checksBeforeUpdateOrDelete("deleteRow", -1);
            this.checkNotOnInsertRow();
            this.setupContextStack();
            LanguageConnectionContext lcc = this.getEmbedConnection().getLanguageConnection();
            StatementContext statementContext = null;
            try {
                StringBuffer deleteWhereCurrentOfSQL = new StringBuffer("DELETE FROM ");
                CursorActivation activation = lcc.lookupCursorActivation(this.getCursorName());
                deleteWhereCurrentOfSQL.append(this.getFullBaseTableName(activation.getPreparedStatement().getTargetTable()));
                deleteWhereCurrentOfSQL.append(" WHERE CURRENT OF " + IdUtil.normalToDelimited(this.getCursorName()));
                StatementContext currSC = lcc.getStatementContext();
                Activation parentAct = null;
                if (currSC != null) {
                    parentAct = currSC.getActivation();
                }
                statementContext = lcc.pushStatementContext(this.isAtomic, false, deleteWhereCurrentOfSQL.toString(), null, false, 0L);
                statementContext.setActivation(parentAct);
                PreparedStatement ps = lcc.prepareInternalStatement(deleteWhereCurrentOfSQL.toString());
                Activation act = ps.getActivation(lcc, false);
                statementContext.setActivation(act);
                ResultSet rs = ps.executeSubStatement(activation, act, true, 0L);
                SQLWarning w = act.getWarnings();
                if (w != null) {
                    this.addWarning(w);
                }
                act.close();
                this.currentRow = null;
                lcc.popStatementContext(statementContext, null);
                InterruptStatus.restoreIntrFlagIfSeen(lcc);
                if (statementContext != null) {
                    lcc.popStatementContext(statementContext, null);
                }
            }
            catch (Throwable t) {
                try {
                    throw this.closeOnTransactionError(t);
                }
                catch (Throwable throwable) {
                    if (statementContext != null) {
                        lcc.popStatementContext(statementContext, null);
                    }
                    this.restoreContextStack();
                    this.initializeUpdateRowModifiers();
                    throw throwable;
                }
            }
            this.restoreContextStack();
            this.initializeUpdateRowModifiers();
        }
    }

    private String getFullBaseTableName(ExecCursorTableReference targetTable) {
        return IdUtil.mkQualifiedName(targetTable.getSchemaName(), targetTable.getBaseName());
    }

    @Override
    public void refreshRow() throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.checksBeforeUpdateOrDelete("cancelRowUpdates", -1);
        this.checkNotOnInsertRow();
        this.initializeUpdateRowModifiers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveToInsertRow() throws SQLException {
        this.checkExecIfClosed("moveToInsertRow");
        this.checkUpdatableCursor("moveToInsertRow");
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            try {
                this.setupContextStack();
                this.initializeUpdateRowModifiers();
                this.isOnInsertRow = true;
                for (int i = 1; i <= this.columnGotUpdated.length; ++i) {
                    this.updateRow.setColumn(i, this.resultDescription.getColumnDescriptor(i).getType().getNull());
                }
                InterruptStatus.restoreIntrFlagIfSeen(this.getEmbedConnection().getLanguageConnection());
            }
            catch (Throwable ex) {
                this.handleException(ex);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveToCurrentRow() throws SQLException {
        this.checkExecIfClosed("moveToCurrentRow");
        this.checkUpdatableCursor("moveToCurrentRow");
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            try {
                if (this.isOnInsertRow) {
                    this.initializeUpdateRowModifiers();
                    this.isOnInsertRow = false;
                }
                InterruptStatus.restoreIntrFlagIfSeen();
            }
            catch (Throwable ex) {
                this.handleException(ex);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        this.closeCurrentStream();
        this.checkIfClosed("getBlob");
        this.useStreamOrLOB(columnIndex);
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            int colType = this.getColumnType(columnIndex);
            if (colType != 2004) {
                throw this.dataTypeConversion("java.sql.Blob", columnIndex);
            }
            boolean pushStack = false;
            try {
                DataValueDescriptor dvd = this.getColumn(columnIndex);
                EmbedConnection ec = this.getEmbedConnection();
                this.wasNull = dvd.isNull();
                if (this.wasNull) {
                    InterruptStatus.restoreIntrFlagIfSeen();
                    Blob blob = null;
                    return blob;
                }
                if (dvd.hasStream()) {
                    pushStack = true;
                }
                if (pushStack) {
                    this.setupContextStack();
                }
                EmbedBlob result = new EmbedBlob(dvd, ec);
                EmbedResultSet.restoreIntrFlagIfSeen(pushStack, ec);
                EmbedBlob embedBlob = result;
                return embedBlob;
            }
            catch (Throwable t) {
                throw this.handleException(t);
            }
            finally {
                if (pushStack) {
                    this.restoreContextStack();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Clob getClob(int columnIndex) throws SQLException {
        this.closeCurrentStream();
        this.checkIfClosed("getClob");
        this.useStreamOrLOB(columnIndex);
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            int colType = this.getColumnType(columnIndex);
            if (colType != 2005) {
                throw this.dataTypeConversion("java.sql.Clob", columnIndex);
            }
            boolean pushStack = false;
            EmbedConnection ec = this.getEmbedConnection();
            try {
                StringDataValue dvd = (StringDataValue)this.getColumn(columnIndex);
                LanguageConnectionContext lcc = ec.getLanguageConnection();
                this.wasNull = dvd.isNull();
                if (this.wasNull) {
                    InterruptStatus.restoreIntrFlagIfSeen();
                    Clob clob = null;
                    return clob;
                }
                if (dvd.hasStream()) {
                    pushStack = true;
                    this.setupContextStack();
                }
                EmbedClob result = new EmbedClob(ec, dvd);
                EmbedResultSet.restoreIntrFlagIfSeen(pushStack, ec);
                EmbedClob embedClob = result;
                return embedClob;
            }
            catch (Throwable t) {
                throw this.handleException(t);
            }
            finally {
                if (pushStack) {
                    this.restoreContextStack();
                }
            }
        }
    }

    @Override
    public final Blob getBlob(String columnName) throws SQLException {
        this.checkIfClosed("getBlob");
        return this.getBlob(this.findColumnName(columnName));
    }

    @Override
    public final Clob getClob(String columnName) throws SQLException {
        this.checkIfClosed("getClob");
        return this.getClob(this.findColumnName(columnName));
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.checksBeforeUpdateXXX("updateBlob", columnIndex);
        int colType = this.getColumnType(columnIndex);
        if (colType != 2004) {
            throw this.dataTypeConversion(columnIndex, "java.sql.Blob");
        }
        if (x == null) {
            this.updateNull(columnIndex);
        } else {
            long length = x.length();
            this.updateBinaryStreamInternal(columnIndex, x.getBinaryStream(), false, length, "updateBlob");
        }
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
        this.checkIfClosed("updateBlob");
        this.updateBlob(this.findColumnName(columnName), x);
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.checksBeforeUpdateXXX("updateClob", columnIndex);
        int colType = this.getColumnType(columnIndex);
        if (colType != 2005) {
            throw this.dataTypeConversion(columnIndex, "java.sql.Clob");
        }
        if (x == null) {
            this.updateNull(columnIndex);
        } else {
            long length = x.length();
            this.updateCharacterStreamInternal(columnIndex, x.getCharacterStream(), false, length, "updateClob");
        }
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
        this.checkIfClosed("updateClob");
        this.updateClob(this.findColumnName(columnName), x);
    }

    protected int findColumnName(String columnName) throws SQLException {
        if (columnName == null) {
            throw EmbedResultSet.newSQLException("XJ018.S", new Object[0]);
        }
        int position = this.resultDescription.findColumnInsenstive(columnName);
        if (position == -1) {
            throw EmbedResultSet.newSQLException("S0022", columnName);
        }
        return position;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void closeCurrentStream() {
        if (this.currentStream != null) {
            try {
                EmbedResultSet embedResultSet = this;
                synchronized (embedResultSet) {
                    if (this.currentStream != null) {
                        if (this.currentStream instanceof Reader) {
                            ((Reader)this.currentStream).close();
                        } else {
                            ((InputStream)this.currentStream).close();
                        }
                    }
                }
            }
            catch (IOException iOException) {
            }
            finally {
                this.currentStream = null;
            }
        }
    }

    final void checkIfClosed(String operation) throws SQLException {
        if (this.isClosed || this.theResults.isClosed()) {
            if (!this.isClosed) {
                this.closeCurrentStream();
                this.markClosed();
            }
            throw EmbedResultSet.newSQLException("XCL16.S", operation);
        }
    }

    final void checkExecIfClosed(String operation) throws SQLException {
        this.checkIfClosed(operation);
        Connection appConn = this.getEmbedConnection().getApplicationConnection();
        if (appConn == null) {
            throw Util.noCurrentConnection();
        }
        if (appConn.isClosed()) {
            this.closeCurrentStream();
            this.markClosed();
            throw Util.noCurrentConnection();
        }
    }

    protected String getSQLText() {
        if (this.stmt == null) {
            return null;
        }
        return this.stmt.getSQLText();
    }

    protected ParameterValueSet getParameterValueSet() {
        if (this.stmt == null) {
            return null;
        }
        return this.stmt.getParameterValueSet();
    }

    private static boolean isMaxFieldSizeType(int colType) {
        return colType == -2 || colType == -3 || colType == -4 || colType == 1 || colType == 12 || colType == -1;
    }

    final SQLException closeOnTransactionError(Throwable thrownException) throws SQLException {
        StandardException se;
        int severity;
        SQLException sqle = this.handleException(thrownException);
        if (thrownException instanceof StandardException && (severity = (se = (StandardException)thrownException).getSeverity()) == 30000) {
            try {
                this.close();
            }
            catch (Throwable t) {
                sqle.setNextException(this.handleException(t));
            }
        }
        return sqle;
    }

    protected final DataValueDescriptor getColumn(int columnIndex) throws SQLException, StandardException {
        this.closeCurrentStream();
        if (columnIndex < 1 || columnIndex > this.resultDescription.getColumnCount()) {
            throw EmbedResultSet.newSQLException("S0022", new Integer(columnIndex));
        }
        if (this.isOnInsertRow || this.currentRowHasBeenUpdated && this.columnGotUpdated[columnIndex - 1]) {
            return this.updateRow.getColumn(columnIndex);
        }
        this.checkOnRow();
        return this.currentRow.getColumn(columnIndex);
    }

    static final SQLException noStateChangeException(Throwable thrownException) {
        return TransactionResourceImpl.wrapInSQLException(thrownException);
    }

    void setDynamicResultSet(EmbedStatement owningStmt) {
        if (owningStmt != null) {
            this.owningStmt = owningStmt;
            this.applicationStmt = owningStmt.applicationStatement;
            this.localConn = owningStmt.getEmbedConnection();
        } else {
            this.localConn = this.localConn.rootConnection;
        }
        this.singleUseActivation = this.theResults.getActivation();
    }

    public final int compareTo(Object other) {
        EmbedResultSet olrs = (EmbedResultSet)other;
        return this.order - olrs.order;
    }

    private void checkScrollCursor(String methodName) throws SQLException {
        this.checkIfClosed(methodName);
        if (this.stmt.getResultSetType() == 1003) {
            throw Util.generateCsSQLException("XJ061.S", methodName);
        }
    }

    private void checkUpdatableCursor(String operation) throws SQLException {
        if (this.getConcurrency() != 1008) {
            throw Util.generateCsSQLException("XJ083.U", operation);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkRowPosition(int position, String positionText) throws SQLException {
        this.checkScrollCursor(positionText);
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            LanguageConnectionContext lcc = this.getEmbedConnection().getLanguageConnection();
            try {
                StatementContext statementContext = lcc.pushStatementContext(this.isAtomic, this.concurrencyOfThisResultSet == 1007, this.getSQLText(), this.getParameterValueSet(), false, 0L);
                boolean result = this.theResults.checkRowPosition(position);
                lcc.popStatementContext(statementContext, null);
                InterruptStatus.restoreIntrFlagIfSeen(lcc);
                boolean bl = result;
                return bl;
            }
            catch (Throwable t) {
                throw this.closeOnTransactionError(t);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    @Override
    public final boolean isForUpdate() {
        if (this.theResults instanceof NoPutResultSet) {
            return ((NoPutResultSet)this.theResults).isForUpdate();
        }
        return false;
    }

    final String getColumnSQLType(int column) {
        return this.resultDescription.getColumnDescriptor(column).getType().getTypeId().getSQLTypeName();
    }

    private final int getMaxColumnWidth(int columnIndex) {
        return this.resultDescription.getColumnDescriptor(columnIndex).getType().getMaximumWidth();
    }

    private final SQLException dataTypeConversion(String targetType, int column) {
        return EmbedResultSet.newSQLException("22005", targetType, this.getColumnSQLType(column));
    }

    private final SQLException dataTypeConversion(int column, String targetType) {
        return EmbedResultSet.newSQLException("22005", this.getColumnSQLType(column), targetType);
    }

    final void useStreamOrLOB(int columnIndex) throws SQLException {
        this.checkLOBMultiCall(columnIndex);
        this.columnUsedFlags[columnIndex - 1] = true;
    }

    private void checkLOBMultiCall(int columnIndex) throws SQLException {
        if (this.columnUsedFlags == null) {
            this.columnUsedFlags = new boolean[this.getMetaData().getColumnCount()];
        } else if (this.columnUsedFlags[columnIndex - 1]) {
            throw EmbedResultSet.newSQLException("XCL18.S", new Object[0]);
        }
    }

    @Override
    public final boolean isClosed() throws SQLException {
        if (this.isClosed) {
            return true;
        }
        try {
            this.checkExecIfClosed("");
            return false;
        }
        catch (SQLException sqle) {
            return this.isClosed;
        }
    }

    private void addWarning(SQLWarning w) {
        if (this.topWarning == null) {
            this.topWarning = w;
        } else {
            this.topWarning.setNextWarning(w);
        }
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.checkIfClosed("updateAsciiStream");
        this.updateAsciiStream(columnIndex, x, (long)length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.checkIfClosed("updateBinaryStream");
        this.updateBinaryStream(columnIndex, x, (long)length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.checkIfClosed("updateCharacterStream");
        this.updateCharacterStream(columnIndex, x, (long)length);
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, long length) throws SQLException {
        this.checkIfClosed("updateAsciiStream");
        this.updateAsciiStream(this.findColumnName(columnName), x, length);
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x) throws SQLException {
        this.checkIfClosed("updateAsciiStream");
        this.updateAsciiStream(this.findColumnName(columnName), x);
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, long length) throws SQLException {
        this.checkIfClosed("updateBinaryStream");
        this.updateBinaryStream(this.findColumnName(columnName), x, length);
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x) throws SQLException {
        this.checkIfClosed("updateBinaryStream");
        this.updateBinaryStream(this.findColumnName(columnName), x);
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, long length) throws SQLException {
        this.checkIfClosed("updateCharacterStream");
        this.updateCharacterStream(this.findColumnName(columnName), reader, length);
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader) throws SQLException {
        this.checkIfClosed("updateCharacterStream");
        this.updateCharacterStream(this.findColumnName(columnName), reader);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream x, long length) throws SQLException {
        this.checksBeforeUpdateXXX("updateBlob", columnIndex);
        int colType = this.getColumnType(columnIndex);
        if (colType != 2004) {
            throw this.dataTypeConversion(columnIndex, "java.sql.Blob");
        }
        if (x == null) {
            this.updateNull(columnIndex);
        } else {
            this.updateBinaryStreamInternal(columnIndex, x, false, length, "updateBlob");
        }
    }

    @Override
    public void updateBlob(int columnIndex, InputStream x) throws SQLException {
        this.checksBeforeUpdateXXX("updateBlob", columnIndex);
        int colType = this.getColumnType(columnIndex);
        if (colType != 2004) {
            throw this.dataTypeConversion(columnIndex, "java.sql.Blob");
        }
        this.updateBinaryStreamInternal(columnIndex, x, true, -1L, "updateBlob");
    }

    @Override
    public void updateBlob(String columnName, InputStream x, long length) throws SQLException {
        this.checkIfClosed("updateBlob");
        this.updateBlob(this.findColumnName(columnName), x, length);
    }

    @Override
    public void updateBlob(String columnName, InputStream x) throws SQLException {
        this.checkIfClosed("updateBlob");
        this.updateBlob(this.findColumnName(columnName), x);
    }

    @Override
    public void updateClob(int columnIndex, Reader x, long length) throws SQLException {
        this.checksBeforeUpdateXXX("updateClob", columnIndex);
        int colType = this.getColumnType(columnIndex);
        if (colType != 2005) {
            throw this.dataTypeConversion(columnIndex, "java.sql.Clob");
        }
        if (x == null) {
            this.updateNull(columnIndex);
        } else {
            this.updateCharacterStreamInternal(columnIndex, x, false, length, "updateClob");
        }
    }

    @Override
    public void updateClob(int columnIndex, Reader x) throws SQLException {
        this.checksBeforeUpdateXXX("updateClob", columnIndex);
        int colType = this.getColumnType(columnIndex);
        if (colType != 2005) {
            throw this.dataTypeConversion(columnIndex, "java.sql.Clob");
        }
        this.updateCharacterStreamInternal(columnIndex, x, true, -1L, "updateClob");
    }

    @Override
    public void updateClob(String columnName, Reader x, long length) throws SQLException {
        this.checkIfClosed("updateClob");
        this.updateClob(this.findColumnName(columnName), x, length);
    }

    @Override
    public void updateClob(String columnName, Reader x) throws SQLException {
        this.checkIfClosed("updateClob");
        this.updateClob(this.findColumnName(columnName), x);
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public RowId getRowId(String columnName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void updateNCharacterStream(String columnName, Reader x) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void updateNCharacterStream(String columnName, Reader x, long length) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void updateNString(String columnName, String nString) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void updateNClob(String columnName, NClob nClob) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void updateNClob(String columnName, Reader reader) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public Reader getNCharacterStream(String columnName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public NClob getNClob(int i) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public NClob getNClob(String colName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public String getNString(String columnName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void updateRowId(String columnName, RowId x) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public SQLXML getSQLXML(String colName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void updateSQLXML(String columnName, SQLXML xmlObject) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public boolean isWrapperFor(Class<?> interfaces) throws SQLException {
        this.checkIfClosed("isWrapperFor");
        return interfaces.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> interfaces) throws SQLException {
        this.checkIfClosed("unwrap");
        try {
            return interfaces.cast(this);
        }
        catch (ClassCastException cce) {
            throw EmbedResultSet.newSQLException("XJ128.S", interfaces);
        }
    }

    @Override
    public void updateNClob(int columnIndex, Reader x, long length) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void updateNClob(String columnName, Reader x, long length) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        this.checkIfClosed("getObject");
        if (type == null) {
            throw this.mismatchException("NULL", columnIndex);
        }
        Object retval = String.class.equals(type) ? this.getString(columnIndex) : (BigDecimal.class.equals(type) ? this.getBigDecimal(columnIndex) : (Boolean.class.equals(type) ? Boolean.valueOf(this.getBoolean(columnIndex)) : (Byte.class.equals(type) ? Byte.valueOf(this.getByte(columnIndex)) : (Short.class.equals(type) ? Short.valueOf(this.getShort(columnIndex)) : (Integer.class.equals(type) ? Integer.valueOf(this.getInt(columnIndex)) : (Long.class.equals(type) ? Long.valueOf(this.getLong(columnIndex)) : (Float.class.equals(type) ? Float.valueOf(this.getFloat(columnIndex)) : (Double.class.equals(type) ? Double.valueOf(this.getDouble(columnIndex)) : (Date.class.equals(type) ? this.getDate(columnIndex) : (Time.class.equals(type) ? this.getTime(columnIndex) : (Timestamp.class.equals(type) ? this.getTimestamp(columnIndex) : (Blob.class.equals(type) ? this.getBlob(columnIndex) : (Clob.class.equals(type) ? this.getClob(columnIndex) : (type.isArray() && type.getComponentType().equals(Byte.TYPE) ? (Object)this.getBytes(columnIndex) : this.getObject(columnIndex)))))))))))))));
        if (this.wasNull()) {
            retval = null;
        }
        if (retval == null || type.isInstance(retval)) {
            return type.cast(retval);
        }
        throw this.mismatchException(type.getName(), columnIndex);
    }

    private SQLException mismatchException(String targetTypeName, int columnIndex) throws SQLException {
        String sourceTypeName = this.getMetaData().getColumnTypeName(columnIndex);
        return EmbedResultSet.newSQLException("22005", targetTypeName, sourceTypeName);
    }

    @Override
    public <T> T getObject(String columnName, Class<T> type) throws SQLException {
        this.checkIfClosed("getObject");
        return this.getObject(this.findColumn(columnName), type);
    }

    @Override
    public boolean isNull(int columnIndex) throws SQLException {
        try {
            DataValueDescriptor dvd = this.getColumn(columnIndex);
            return dvd.isNull();
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    @Override
    public int getLength(int columnIndex) throws SQLException {
        try {
            DataValueDescriptor dvd = this.getColumn(columnIndex);
            return dvd.getLength();
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }
}

