/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.stream;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;

public class RollingFileStream
extends OutputStream {
    private MeteredStream meter;
    private boolean append;
    private int limit;
    private int count;
    private String pattern;
    private String lockFileName;
    private FileOutputStream lockStream;
    private File[] files;
    private static final int MAX_LOCKS = 100;
    private static HashMap<String, String> locks = new HashMap();

    public RollingFileStream() throws IOException, SecurityException {
        this("%d/derby-%g.log", 0, 1, false);
    }

    public RollingFileStream(String pattern, int limit, int count, boolean append) throws IOException, SecurityException {
        if (limit < 0 || count < 1 || pattern.length() < 1) {
            throw new IllegalArgumentException();
        }
        this.pattern = pattern;
        this.limit = limit;
        this.count = count;
        this.append = append;
        this.openFiles();
    }

    @Override
    public void write(int b) throws IOException {
        this.meter.write(b);
        this.checkMeter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void openFiles() throws IOException {
        if (this.count < 1) {
            throw new IllegalArgumentException("file count = " + this.count);
        }
        if (this.limit < 0) {
            this.limit = 0;
        }
        int unique = -1;
        while (true) {
            if (++unique > 100) {
                throw new IOException("Couldn't get lock for " + this.pattern);
            }
            this.lockFileName = this.generate(this.pattern, 0, unique).toString() + ".lck";
            HashMap<String, String> hashMap = locks;
            synchronized (hashMap) {
                FileChannel fc;
                if (locks.get(this.lockFileName) != null) {
                    continue;
                }
                try {
                    this.lockStream = this.openFile(this.lockFileName, false);
                    fc = this.lockStream.getChannel();
                }
                catch (IOException ix) {
                    continue;
                }
                try {
                    FileLock fl = fc.tryLock();
                    if (fl != null) break;
                }
                catch (IOException ix) {
                    // empty catch block
                    break;
                }
            }
        }
        {
            locks.put(this.lockFileName, this.lockFileName);
        }
        this.files = new File[this.count];
        for (int i = 0; i < this.count; ++i) {
            this.files[i] = this.generate(this.pattern, i, unique);
        }
        if (this.append) {
            this.open(this.files[0], true);
            return;
        }
        this.rotate();
    }

    private File generate(String pattern, int generation, int unique) throws IOException {
        File file = null;
        String word = "";
        int ix = 0;
        boolean sawg = false;
        boolean sawu = false;
        while (ix < pattern.length()) {
            char ch = pattern.charAt(ix);
            char ch2 = '\u0000';
            if (++ix < pattern.length()) {
                ch2 = Character.toLowerCase(pattern.charAt(ix));
            }
            if (ch == '/') {
                file = file == null ? new File(word) : new File(file, word);
                word = "";
                continue;
            }
            if (ch == '%') {
                if (ch2 == 't') {
                    String tmpDir = this.getSystemProperty("java.io.tmpdir");
                    if (tmpDir == null) {
                        tmpDir = this.getSystemProperty("user.home");
                    }
                    file = new File(tmpDir);
                    ++ix;
                    word = "";
                    continue;
                }
                if (ch2 == 'h') {
                    file = new File(this.getSystemProperty("user.home"));
                    ++ix;
                    word = "";
                    continue;
                }
                if (ch2 == 'd') {
                    String derbyHome = this.getSystemProperty("derby.system.home");
                    if (derbyHome == null) {
                        derbyHome = this.getSystemProperty("user.dir");
                    }
                    file = new File(derbyHome);
                    ++ix;
                    word = "";
                    continue;
                }
                if (ch2 == 'g') {
                    word = word + generation;
                    sawg = true;
                    ++ix;
                    continue;
                }
                if (ch2 == 'u') {
                    word = word + unique;
                    sawu = true;
                    ++ix;
                    continue;
                }
                if (ch2 == '%') {
                    word = word + "%";
                    ++ix;
                    continue;
                }
            }
            word = word + ch;
        }
        if (this.count > 1 && !sawg) {
            word = word + "." + generation;
        }
        if (unique > 0 && !sawu) {
            word = word + "." + unique;
        }
        if (word.length() > 0) {
            file = file == null ? new File(word) : new File(file, word);
        }
        return file;
    }

    private synchronized void rotate() throws IOException {
        if (null != this.meter) {
            this.meter.close();
        }
        for (int i = this.count - 2; i >= 0; --i) {
            File f1 = this.files[i];
            File f2 = this.files[i + 1];
            if (!this.fileExists(f1)) continue;
            if (this.fileExists(f2)) {
                this.fileDelete(f2);
            }
            this.fileRename(f1, f2);
        }
        try {
            this.open(this.files[0], false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws SecurityException {
        if (null != this.meter) {
            try {
                this.meter.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        if (this.lockFileName == null) {
            return;
        }
        try {
            this.lockStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        HashMap<String, String> hashMap = locks;
        synchronized (hashMap) {
            locks.remove(this.lockFileName);
        }
        this.fileDelete(new File(this.lockFileName));
        this.lockFileName = null;
        this.lockStream = null;
    }

    private String getSystemProperty(final String property) {
        String value = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(property);
            }
        });
        return value;
    }

    private FileOutputStream openFile(final String filename, final boolean append) throws IOException {
        FileOutputStream fis = null;
        try {
            fis = AccessController.doPrivileged(new PrivilegedExceptionAction<FileOutputStream>(){

                @Override
                public FileOutputStream run() throws FileNotFoundException {
                    FileOutputStream res = new FileOutputStream(filename, append);
                    return res;
                }
            });
            return fis;
        }
        catch (PrivilegedActionException x) {
            throw (IOException)x.getException();
        }
    }

    private boolean fileExists(final File file) {
        Boolean value = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return new Boolean(file.exists());
            }
        });
        return value;
    }

    private void fileDelete(final File file) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                file.delete();
                return null;
            }
        });
    }

    private boolean fileRename(final File file1, final File file2) {
        Boolean value = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return new Boolean(file1.renameTo(file2));
            }
        });
        return value;
    }

    private long fileLength(final File file) {
        Long value = AccessController.doPrivileged(new PrivilegedAction<Long>(){

            @Override
            public Long run() {
                return new Long(file.length());
            }
        });
        return value;
    }

    private void open(File fname, boolean append) throws IOException {
        int len = 0;
        if (append) {
            len = (int)this.fileLength(fname);
        }
        FileOutputStream fout = this.openFile(fname.toString(), append);
        this.meter = new MeteredStream(fout, len);
    }

    private void checkMeter() throws IOException {
        if (this.limit > 0 && this.meter.written >= this.limit) {
            this.rotate();
        }
    }

    private class MeteredStream
    extends OutputStream {
        OutputStream out;
        int written;

        MeteredStream(OutputStream out, int written) {
            this.out = out;
            this.written = written;
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.written;
        }

        public int getWritten() {
            return this.written;
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }
}

