/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.timer;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.timer.TimerFactory;

public class SingletonTimerFactory
implements TimerFactory,
ModuleControl {
    private Timer singletonTimer;
    private final AtomicInteger cancelCount = new AtomicInteger();

    public SingletonTimerFactory() {
        ClassLoader savecl = SingletonTimerFactory.getContextClassLoader();
        if (savecl != null) {
            SingletonTimerFactory.setContextClassLoader(null);
        }
        this.singletonTimer = new Timer(true);
        if (savecl != null) {
            SingletonTimerFactory.setContextClassLoader(savecl);
        }
    }

    @Override
    public void schedule(TimerTask task, long delay) {
        this.singletonTimer.schedule(task, delay);
    }

    @Override
    public void cancel(TimerTask task) {
        task.cancel();
        if (this.cancelCount.incrementAndGet() % 1000 == 0) {
            this.singletonTimer.purge();
        }
    }

    @Override
    public void boot(boolean create, Properties properties) throws StandardException {
    }

    @Override
    public void stop() {
        this.singletonTimer.cancel();
    }

    private static ClassLoader getContextClassLoader() {
        try {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
        catch (SecurityException se) {
            return null;
        }
    }

    private static void setContextClassLoader(final ClassLoader cl) {
        try {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    Thread.currentThread().setContextClassLoader(cl);
                    return null;
                }
            });
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

