/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.dictionary.CatalogRowFactory;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SequenceDescriptor;
import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.iapi.types.SQLVarchar;
import org.apache.derby.iapi.types.UserType;
import org.apache.derby.impl.sql.catalog.SystemColumnImpl;
import org.apache.derby.shared.common.sanity.SanityManager;

public class SYSSEQUENCESRowFactory
extends CatalogRowFactory {
    public static final String TABLENAME_STRING = "SYSSEQUENCES";
    public static final int SYSSEQUENCES_COLUMN_COUNT = 10;
    public static final int SYSSEQUENCES_SEQUENCEID = 1;
    public static final int SYSSEQUENCES_SEQUENCENAME = 2;
    public static final int SYSSEQUENCES_SCHEMAID = 3;
    public static final int SYSSEQUENCES_SEQUENCEDATATYPE = 4;
    public static final int SYSSEQUENCES_CURRENT_VALUE = 5;
    public static final int SYSSEQUENCES_START_VALUE = 6;
    public static final int SYSSEQUENCES_MINIMUM_VALUE = 7;
    public static final int SYSSEQUENCES_MAXIMUM_VALUE = 8;
    public static final int SYSSEQUENCES_INCREMENT = 9;
    public static final int SYSSEQUENCES_CYCLE_OPTION = 10;
    private static final int[][] indexColumnPositions = new int[][]{{1}, {3, 2}};
    static final int SYSSEQUENCES_INDEX1_ID = 0;
    static final int SYSSEQUENCES_INDEX2_ID = 1;
    private static final boolean[] uniqueness = null;
    private static final String[] uuids = new String[]{"9810800c-0121-c5e2-e794-00000043e718", "6ea6ffac-0121-c5e6-29e6-00000043e718", "7a92cf84-0121-c5fa-caf1-00000043e718", "6b138684-0121-c5e9-9114-00000043e718"};

    SYSSEQUENCESRowFactory(UUIDFactory uuidf, ExecutionFactory ef, DataValueFactory dvf) {
        super(uuidf, ef, dvf);
        this.initInfo(10, TABLENAME_STRING, indexColumnPositions, uniqueness, uuids);
    }

    @Override
    public ExecRow makeRow(TupleDescriptor td, TupleDescriptor parent) throws StandardException {
        String oidString = null;
        String sequenceName = null;
        String schemaIdString = null;
        TypeDescriptor typeDesc = null;
        Long currentValue = null;
        long startValue = 0L;
        long minimumValue = 0L;
        long maximumValue = 0L;
        long increment = 0L;
        boolean canCycle = false;
        if (td != null) {
            SequenceDescriptor sd = (SequenceDescriptor)td;
            UUID oid = sd.getUUID();
            oidString = oid.toString();
            sequenceName = sd.getSequenceName();
            UUID schemaId = sd.getSchemaId();
            schemaIdString = schemaId.toString();
            typeDesc = sd.getDataType().getCatalogType();
            currentValue = sd.getCurrentValue();
            startValue = sd.getStartValue();
            minimumValue = sd.getMinimumValue();
            maximumValue = sd.getMaximumValue();
            increment = sd.getIncrement();
            canCycle = sd.canCycle();
        }
        ExecRow row = this.getExecutionFactory().getValueRow(10);
        row.setColumn(1, new SQLChar(oidString));
        row.setColumn(2, new SQLVarchar(sequenceName));
        row.setColumn(3, new SQLChar(schemaIdString));
        row.setColumn(4, new UserType(typeDesc));
        SQLLongint curVal = currentValue == null ? new SQLLongint() : new SQLLongint((long)currentValue);
        row.setColumn(5, curVal);
        row.setColumn(6, new SQLLongint(startValue));
        row.setColumn(7, new SQLLongint(minimumValue));
        row.setColumn(8, new SQLLongint(maximumValue));
        row.setColumn(9, new SQLLongint(increment));
        row.setColumn(10, new SQLChar(canCycle ? "Y" : "N"));
        return row;
    }

    @Override
    public TupleDescriptor buildDescriptor(ExecRow row, TupleDescriptor parentTupleDescriptor, DataDictionary dd) throws StandardException {
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        SanityManager.ASSERT(row.nColumns() == 10, "Wrong number of columns for a SYSSEQUENCES row");
        DataValueDescriptor col = row.getColumn(1);
        String oidString = col.getString();
        UUID ouuid = this.getUUIDFactory().recreateUUID(oidString);
        col = row.getColumn(2);
        String sequenceName = col.getString();
        col = row.getColumn(3);
        String schemaIdString = col.getString();
        UUID suuid = this.getUUIDFactory().recreateUUID(schemaIdString);
        TypeDescriptor catalogType = (TypeDescriptor)row.getColumn(4).getObject();
        DataTypeDescriptor dataTypeServices = DataTypeDescriptor.getType(catalogType);
        col = row.getColumn(5);
        Long currentValue = col.isNull() ? null : new Long(col.getLong());
        col = row.getColumn(6);
        long startValue = col.getLong();
        col = row.getColumn(7);
        long minimumValue = col.getLong();
        col = row.getColumn(8);
        long maximumValue = col.getLong();
        col = row.getColumn(9);
        long increment = col.getLong();
        col = row.getColumn(10);
        String cycleOption = col.getString();
        SequenceDescriptor descriptor = ddg.newSequenceDescriptor(dd.getSchemaDescriptor(suuid, null), ouuid, sequenceName, dataTypeServices, currentValue, startValue, minimumValue, maximumValue, increment, cycleOption.equals("Y"));
        return descriptor;
    }

    @Override
    public SystemColumn[] buildColumnList() throws StandardException {
        return new SystemColumn[]{SystemColumnImpl.getUUIDColumn("SEQUENCEID", false), SystemColumnImpl.getIdentifierColumn("SEQUENCENAME", false), SystemColumnImpl.getUUIDColumn("SCHEMAID", false), SystemColumnImpl.getJavaColumn("SEQUENCEDATATYPE", "org.apache.derby.catalog.TypeDescriptor", false), SystemColumnImpl.getColumn("CURRENTVALUE", -5, true), SystemColumnImpl.getColumn("STARTVALUE", -5, false), SystemColumnImpl.getColumn("MINIMUMVALUE", -5, false), SystemColumnImpl.getColumn("MAXIMUMVALUE", -5, false), SystemColumnImpl.getColumn("INCREMENT", -5, false), SystemColumnImpl.getIndicatorColumn("CYCLEOPTION")};
    }
}

