/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;

class BaseColumnNode
extends ValueNode {
    private String columnName;
    private TableName tableName;

    BaseColumnNode(String columnName, TableName tableName, DataTypeDescriptor dtd, ContextManager cm) throws StandardException {
        super(cm);
        this.columnName = columnName;
        this.tableName = tableName;
        this.setType(dtd);
    }

    @Override
    public String toString() {
        return "columnName: " + this.columnName + "\n" + "tableName: " + (this.tableName != null ? this.tableName.toString() : "null") + "\n" + super.toString();
    }

    @Override
    String getColumnName() {
        return this.columnName;
    }

    @Override
    String getTableName() {
        return this.tableName != null ? this.tableName.getTableName() : null;
    }

    @Override
    String getSchemaName() throws StandardException {
        return this.tableName != null ? this.tableName.getSchemaName() : null;
    }

    @Override
    void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        throw StandardException.newException("42Z50", this.nodeHeader());
    }

    @Override
    protected int getOrderableVariantType() {
        return 1;
    }

    @Override
    boolean isEquivalent(ValueNode o) {
        if (this.isSameNodeKind(o)) {
            BaseColumnNode other = (BaseColumnNode)o;
            return other.tableName.equals(this.tableName) && other.columnName.equals(this.columnName);
        }
        return false;
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.tableName != null) {
            this.tableName = (TableName)this.tableName.accept(v);
        }
    }
}

