/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.catalog.types.DefaultInfoImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.Parser;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.DefaultDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.CursorNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.RowResultSetNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.UntypedNullConstantNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.sanity.SanityManager;

public class DefaultNode
extends ValueNode {
    private String columnName;
    private String defaultText;
    private ValueNode defaultTree;

    DefaultNode(ContextManager cm) {
        super(cm);
    }

    DefaultNode(ValueNode defaultTree, String defaultText, ContextManager cm) {
        super(cm);
        this.defaultTree = defaultTree;
        this.defaultText = defaultText;
    }

    DefaultNode(String columnName, ContextManager cm) {
        super(cm);
        this.columnName = columnName;
    }

    public String getDefaultText() {
        return this.defaultText;
    }

    ValueNode getDefaultTree() {
        return this.defaultTree;
    }

    @Override
    public String toString() {
        return "columnName: " + this.columnName + "\n" + "defaultText: " + this.defaultText + "\n" + super.toString();
    }

    @Override
    void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.defaultTree != null) {
            this.printLabel(depth, "defaultTree:");
            this.defaultTree.treePrint(depth + 1);
        }
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> aggregates) throws StandardException {
        TableDescriptor td;
        ColumnDescriptor cd;
        SanityManager.ASSERT(fromList.size() != 0, "fromList expected to be non-empty");
        if (!(fromList.elementAt(0) instanceof FromBaseTable)) {
            SanityManager.THROWASSERT("fromList.elementAt(0) expected to be instanceof FromBaseTable, not " + ((ResultSetNode)fromList.elementAt(0)).getClass().getName());
        }
        SanityManager.ASSERT((cd = (td = ((FromBaseTable)fromList.elementAt(0)).getTableDescriptor()).getColumnDescriptor(this.columnName)) != null, "cd expected to be non-null");
        DefaultInfoImpl defaultInfo = (DefaultInfoImpl)cd.getDefaultInfo();
        if (defaultInfo != null) {
            String defaultTxt = defaultInfo.getDefaultText();
            ValueNode defaultTre = DefaultNode.parseDefault(defaultTxt, this.getLanguageConnectionContext(), this.getCompilerContext());
            DefaultDescriptor defaultDescriptor = cd.getDefaultDescriptor(this.getDataDictionary());
            this.getCompilerContext().createDependency(defaultDescriptor);
            return defaultTre.bindExpression(fromList, subqueryList, aggregates);
        }
        return new UntypedNullConstantNode(this.getContextManager());
    }

    public static ValueNode parseDefault(String defaultText, LanguageConnectionContext lcc, CompilerContext cc) throws StandardException {
        CursorNode cn;
        String values = "VALUES " + defaultText;
        CompilerContext newCC = lcc.pushCompilerContext();
        Parser p = newCC.getParser();
        Visitable qt = p.parseStatement(values);
        if (!(qt instanceof CursorNode)) {
            SanityManager.THROWASSERT("qt expected to be instanceof CursorNode, not " + qt.getClass().getName());
        }
        if (!((cn = (CursorNode)qt).getResultSetNode() instanceof RowResultSetNode)) {
            SanityManager.THROWASSERT("cn.getResultSetNode() expected to be instanceof RowResultSetNode, not " + cn.getResultSetNode().getClass().getName());
        }
        ValueNode defaultTree = ((ResultColumn)((CursorNode)qt).getResultSetNode().getResultColumns().elementAt(0)).getExpression();
        lcc.popCompilerContext(newCC);
        return defaultTree;
    }

    @Override
    void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        SanityManager.THROWASSERT("generateExpression not expected to be called");
    }

    @Override
    boolean isEquivalent(ValueNode other) {
        return false;
    }
}

