/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.BaseTypeCompiler;
import org.apache.derby.shared.common.sanity.SanityManager;

class LOBTypeCompiler
extends BaseTypeCompiler {
    LOBTypeCompiler() {
    }

    @Override
    public boolean convertible(TypeId otherType, boolean forDataTypeFunction) {
        return otherType.isBlobTypeId();
    }

    @Override
    public boolean compatible(TypeId otherType) {
        return this.convertible(otherType, false);
    }

    @Override
    public boolean storable(TypeId otherType, ClassFactory cf) {
        return otherType.isBlobTypeId();
    }

    @Override
    public String interfaceName() {
        return "org.apache.derby.iapi.types.BitDataValue";
    }

    @Override
    public String getCorrespondingPrimitiveTypeName() {
        int formatId = this.getStoredFormatIdFromTypeId();
        switch (formatId) {
            case 440: {
                return "java.sql.Blob";
            }
        }
        SanityManager.THROWASSERT("unexpected formatId in getCorrespondingPrimitiveTypeName() - " + formatId);
        return null;
    }

    @Override
    public int getCastToCharWidth(DataTypeDescriptor dts) {
        return dts.getMaximumWidth();
    }

    @Override
    String nullMethodName() {
        int formatId = this.getStoredFormatIdFromTypeId();
        switch (formatId) {
            case 440: {
                return "getNullBlob";
            }
        }
        SanityManager.THROWASSERT("unexpected formatId in nullMethodName() - " + formatId);
        return null;
    }

    @Override
    String dataValueMethodName() {
        int formatId = this.getStoredFormatIdFromTypeId();
        switch (formatId) {
            case 440: {
                return "getBlobDataValue";
            }
        }
        SanityManager.THROWASSERT("unexpected formatId in dataValueMethodName() - " + formatId);
        return null;
    }
}

