/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.shared.common.sanity.SanityManager;

class OffsetOrderVisitor<T extends QueryTreeNode>
implements Visitor {
    private static final Comparator<QueryTreeNode> COMPARATOR = new Comparator<QueryTreeNode>(){

        @Override
        public int compare(QueryTreeNode node1, QueryTreeNode node2) {
            return node1.getBeginOffset() - node2.getBeginOffset();
        }
    };
    private final Class<T> nodeClass;
    private final TreeSet<T> nodes = new TreeSet<QueryTreeNode>(COMPARATOR);
    private final int lowOffset;
    private final int highOffset;

    OffsetOrderVisitor(Class<T> nodeClass, int low, int high) {
        this.nodeClass = nodeClass;
        this.lowOffset = low;
        this.highOffset = high;
        SanityManager.ASSERT(this.lowOffset >= 0 && this.highOffset >= 0, "offsets should be non-negative");
    }

    @Override
    public Visitable visit(Visitable node) throws StandardException {
        QueryTreeNode qtn;
        if (this.nodeClass.isInstance(node) && (qtn = (QueryTreeNode)this.nodeClass.cast(node)).getBeginOffset() >= this.lowOffset && qtn.getEndOffset() < this.highOffset) {
            this.nodes.add(qtn);
        }
        return node;
    }

    @Override
    public boolean visitChildrenFirst(Visitable node) {
        return false;
    }

    @Override
    public boolean stopTraversal() {
        return false;
    }

    @Override
    public boolean skipChildren(Visitable node) throws StandardException {
        return false;
    }

    SortedSet<T> getNodes() {
        return this.nodes;
    }
}

