/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.HashSet;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.impl.sql.compile.OrderedColumn;
import org.apache.derby.impl.sql.compile.QueryTreeNodeVector;
import org.apache.derby.impl.sql.execute.IndexColumnOrder;

public abstract class OrderedColumnList<E extends OrderedColumn>
extends QueryTreeNodeVector<E> {
    public OrderedColumnList(Class<E> eltClass, ContextManager cm) {
        super(eltClass, cm);
    }

    IndexColumnOrder[] getColumnOrdering() {
        int numCols = this.size();
        IndexColumnOrder[] ordering = new IndexColumnOrder[numCols];
        HashSet<Integer> hashColumns = new HashSet<Integer>();
        int actualCols = 0;
        for (int i = 0; i < numCols; ++i) {
            OrderedColumn oc = (OrderedColumn)this.elementAt(i);
            int position = oc.getColumnPosition() - 1;
            if (!hashColumns.add(ReuseFactory.getInteger(position))) continue;
            ordering[i] = new IndexColumnOrder(position, oc.isAscending(), oc.isNullsOrderedLow());
            ++actualCols;
        }
        if (actualCols < numCols) {
            IndexColumnOrder[] newOrdering = new IndexColumnOrder[actualCols];
            System.arraycopy(ordering, 0, newOrdering, 0, actualCols);
            ordering = newOrdering;
        }
        return ordering;
    }
}

