/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.impl.sql.compile.ConstraintDefinitionNode;
import org.apache.derby.impl.sql.compile.ModifyColumnNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;

class TableElementNode
extends QueryTreeNode {
    public static final int AT_UNKNOWN = 0;
    public static final int AT_ADD_FOREIGN_KEY_CONSTRAINT = 1;
    public static final int AT_ADD_PRIMARY_KEY_CONSTRAINT = 2;
    public static final int AT_ADD_UNIQUE_CONSTRAINT = 3;
    public static final int AT_ADD_CHECK_CONSTRAINT = 4;
    public static final int AT_DROP_CONSTRAINT = 5;
    public static final int AT_MODIFY_COLUMN = 6;
    public static final int AT_DROP_COLUMN = 7;
    public static final int AT_MODIFY_CONSTRAINT = 8;
    String name;
    int elementType;

    TableElementNode(String name, ContextManager cm) {
        super(cm);
        this.name = name;
    }

    @Override
    public String toString() {
        return "name: " + this.name + "\n" + "elementType: " + this.getElementType() + "\n" + super.toString();
    }

    boolean hasPrimaryKeyConstraint() {
        return false;
    }

    boolean hasUniqueKeyConstraint() {
        return false;
    }

    boolean hasForeignKeyConstraint() {
        return false;
    }

    boolean hasCheckConstraint() {
        return false;
    }

    boolean hasConstraint() {
        return false;
    }

    String getName() {
        return this.name;
    }

    int getElementType() {
        if (this.hasForeignKeyConstraint()) {
            return 1;
        }
        if (this.hasPrimaryKeyConstraint()) {
            return 2;
        }
        if (this.hasUniqueKeyConstraint()) {
            return 3;
        }
        if (this.hasCheckConstraint()) {
            return 4;
        }
        if (this instanceof ConstraintDefinitionNode) {
            return 5;
        }
        if (this instanceof ModifyColumnNode) {
            if (((ModifyColumnNode)this).kind == 4) {
                return 7;
            }
            return 6;
        }
        return this.elementType;
    }
}

