/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.BaseTypeCompiler;

class TimestampTypeCompiler
extends BaseTypeCompiler {
    TimestampTypeCompiler() {
    }

    @Override
    public boolean convertible(TypeId otherType, boolean forDataTypeFunction) {
        if (otherType.isStringTypeId() && !otherType.isLongConcatableTypeId()) {
            return true;
        }
        int otherJDBCTypeId = otherType.getJDBCTypeId();
        if (otherJDBCTypeId == 93) {
            return true;
        }
        return otherJDBCTypeId == 91 || otherJDBCTypeId == 92;
    }

    @Override
    public boolean compatible(TypeId otherType) {
        if (otherType.isStringTypeId() && !otherType.isLongConcatableTypeId()) {
            return true;
        }
        return this.getStoredFormatIdFromTypeId() == otherType.getTypeFormatId();
    }

    @Override
    public boolean storable(TypeId otherType, ClassFactory cf) {
        int otherJDBCTypeId = otherType.getJDBCTypeId();
        if (otherJDBCTypeId == 93 || otherJDBCTypeId == 1 || otherJDBCTypeId == 12) {
            return true;
        }
        return cf.getClassInspector().assignableTo(otherType.getCorrespondingJavaTypeName(), "java.sql.Timestamp");
    }

    @Override
    public String interfaceName() {
        return "org.apache.derby.iapi.types.DateTimeDataValue";
    }

    @Override
    public String getCorrespondingPrimitiveTypeName() {
        return "java.sql.Timestamp";
    }

    @Override
    public int getCastToCharWidth(DataTypeDescriptor dts) {
        return 26;
    }

    public double estimatedMemoryUsage(DataTypeDescriptor dtd) {
        return 12.0;
    }

    @Override
    String nullMethodName() {
        return "getNullTimestamp";
    }
}

