/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.derby.catalog.DefaultInfo;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.TagFilter;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.CheckConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptorList;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.CastNode;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.CurrentOfNode;
import org.apache.derby.impl.sql.compile.CurrentRowLocationNode;
import org.apache.derby.impl.sql.compile.DMLModStatementNode;
import org.apache.derby.impl.sql.compile.DefaultNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromSubquery;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.MatchingClauseNode;
import org.apache.derby.impl.sql.compile.NormalizeResultSetNode;
import org.apache.derby.impl.sql.compile.NumericConstantNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.StaticMethodCallNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.UntypedNullConstantNode;
import org.apache.derby.impl.sql.compile.VTIDeferModPolicy;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.sanity.SanityManager;

public final class UpdateNode
extends DMLModStatementNode {
    int[] changedColumnIds;
    boolean deferred;
    ValueNode checkConstraints;
    protected FromTable targetTable;
    protected FormatableBitSet readColsBitSet;
    protected boolean positionedUpdate;
    static final String COLUMNNAME = "###RowLocationToUpdate";

    UpdateNode(TableName targetTableName, ResultSetNode resultSet, MatchingClauseNode matchingClause, ContextManager cm) {
        super(resultSet, matchingClause, cm);
        this.targetTableName = targetTableName;
    }

    @Override
    public String toString() {
        return this.targetTableName.toString() + "\n" + super.toString();
    }

    @Override
    String statementToString() {
        return "UPDATE";
    }

    @Override
    void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.targetTableName != null) {
            this.printLabel(depth, "targetTableName: ");
            this.targetTableName.treePrint(depth + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindStatement() throws StandardException {
        ValueNode rowLocationNode;
        boolean needBaseColumns;
        TableName synonymTab;
        this.getCompilerContext().pushCurrentPrivType(0);
        FromList fromList = new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager());
        TableName cursorTargetTableName = null;
        CurrentOfNode currentOfNode = null;
        ResultColumnList afterColumns = null;
        DataDictionary dataDictionary = this.getDataDictionary();
        if (this.targetTableName != null && (synonymTab = this.resolveTableToSynonym(this.targetTableName)) != null) {
            this.synonymTableName = this.targetTableName;
            this.targetTableName = synonymTab;
        }
        if (this.inMatchingClause()) {
            this.tagOriginalResultSetColumns();
        }
        ArrayList<String> explicitlySetColumns = this.getExplicitlySetColumns();
        List<CastNode> allCastNodes = this.collectAllCastNodes();
        this.tagPrivilegedNodes();
        TagFilter tagFilter = new TagFilter("updatePrivs");
        this.getCompilerContext().addPrivilegeFilter(tagFilter);
        this.bindTables(dataDictionary);
        SanityManager.ASSERT(this.resultSet != null && this.resultSet instanceof SelectNode, "Update must have a select result set");
        SelectNode sel = (SelectNode)this.resultSet;
        this.targetTable = (FromTable)sel.fromList.elementAt(0);
        if (this.targetTable instanceof CurrentOfNode) {
            this.positionedUpdate = true;
            currentOfNode = (CurrentOfNode)this.targetTable;
            cursorTargetTableName = currentOfNode.getBaseCursorTargetTableName();
            SanityManager.ASSERT(cursorTargetTableName != null);
        }
        if (this.targetTable instanceof FromVTI) {
            this.targetVTI = (FromVTI)this.targetTable;
            this.targetVTI.setTarget();
        } else if (this.targetTableName == null) {
            SanityManager.ASSERT(cursorTargetTableName != null);
            this.targetTableName = cursorTargetTableName;
        } else if (cursorTargetTableName != null && !this.targetTableName.equals(cursorTargetTableName)) {
            throw StandardException.newException("42X29", this.targetTableName, currentOfNode.getCursorName());
        }
        this.verifyTargetTable();
        this.addUpdatePriv(explicitlySetColumns);
        SanityManager.ASSERT(fromList.size() == 0, "fromList.size() is expected to be 0, not " + fromList.size() + " on return from RS.bindExpressions()");
        ColumnDescriptorList addedGeneratedColumns = new ColumnDescriptorList();
        ColumnDescriptorList affectedGeneratedColumns = new ColumnDescriptorList();
        this.addGeneratedColumns(this.targetTableDescriptor, this.resultSet, affectedGeneratedColumns, addedGeneratedColumns);
        this.resultSet.getResultColumns().markUpdated();
        SanityManager.ASSERT(this.resultSet.getResultColumns() != null, "resultColumns is expected not to be null at bind time");
        if (this.synonymTableName != null) {
            this.normalizeSynonymColumns(this.resultSet.getResultColumns(), this.targetTable);
        }
        this.normalizeCorrelatedColumns(this.resultSet.getResultColumns(), this.targetTable);
        this.resultSet.bindResultColumns(this.targetTableDescriptor, this.targetVTI, this.resultSet.getResultColumns(), this, fromList);
        this.forbidGenerationOverrides(this.resultSet.getResultColumns(), addedGeneratedColumns);
        LanguageConnectionContext lcc = this.getLanguageConnectionContext();
        if (!lcc.getAutoincrementUpdate()) {
            this.resultSet.getResultColumns().forbidOverrides(null);
        }
        boolean allColumns = false;
        if (this.targetTable instanceof FromBaseTable) {
            ((FromBaseTable)this.targetTable).markUpdated(this.resultSet.getResultColumns());
        } else if (this.targetTable instanceof FromVTI || this.targetTable instanceof FromSubquery) {
            this.resultColumnList = this.resultSet.getResultColumns();
        } else {
            SanityManager.ASSERT(currentOfNode != null, "currentOfNode is null");
            ExecPreparedStatement cursorStmt = currentOfNode.getCursorStatement();
            if (!cursorStmt.hasUpdateColumns()) {
                this.getResultColumnList();
                afterColumns = this.resultSet.getResultColumns().expandToAll(this.targetTableDescriptor, this.targetTable.getTableName());
                this.getAffectedIndexes(this.targetTableDescriptor, null, null);
                allColumns = true;
            } else {
                this.resultSet.getResultColumns().checkColumnUpdateability(cursorStmt, currentOfNode.getCursorName());
            }
        }
        this.changedColumnIds = this.getChangedColumnIds(this.resultSet.getResultColumns());
        boolean bl = needBaseColumns = this.targetVTI == null || this.inMatchingClause();
        if (!allColumns && needBaseColumns) {
            this.getCompilerContext().pushCurrentPrivType(-1);
            try {
                int i;
                this.readColsBitSet = new FormatableBitSet();
                FromBaseTable fbt = this.getResultColumnList(this.resultSet.getResultColumns());
                afterColumns = this.resultSet.getResultColumns().copyListAndObjects();
                this.readColsBitSet = this.getReadMap(dataDictionary, this.targetTableDescriptor, afterColumns, affectedGeneratedColumns);
                afterColumns = fbt.addColsToList(afterColumns, this.readColsBitSet);
                this.resultColumnList = fbt.addColsToList(this.resultColumnList, this.readColsBitSet);
                int size = this.targetTableDescriptor.getMaxColumnID();
                for (i = 1; i <= size && this.readColsBitSet.get(i); ++i) {
                }
                if (i > size) {
                    this.readColsBitSet = null;
                }
            }
            finally {
                this.getCompilerContext().popCurrentPrivType();
            }
        }
        if (needBaseColumns) {
            this.resultColumnList.appendResultColumns(afterColumns, false);
            rowLocationNode = new CurrentRowLocationNode(this.getContextManager());
        } else {
            rowLocationNode = new NumericConstantNode(TypeId.getBuiltInTypeId(4), ReuseFactory.getInteger(0), this.getContextManager());
        }
        ResultColumn rowLocationColumn = new ResultColumn(COLUMNNAME, rowLocationNode, this.getContextManager());
        rowLocationColumn.markGenerated();
        this.resultColumnList.addResultColumn(rowLocationColumn);
        this.checkTableNameAndScrubResultColumns(this.resultColumnList);
        this.resultSet.setResultColumns(this.resultColumnList);
        if (this.inMatchingClause()) {
            this.associateAddedColumns();
        }
        SelectNode.checkNoWindowFunctions(this.resultSet, "<update source>");
        super.bindExpressions();
        this.resultSet.getResultColumns().bindUntypedNullsToResultColumns(this.resultColumnList);
        rowLocationColumn.bindResultColumnToExpression();
        this.resultColumnList.checkStorableExpressions();
        if (!this.resultColumnList.columnTypesAndLengthsMatch()) {
            this.resultSet = new NormalizeResultSetNode(this.resultSet, this.resultColumnList, null, true, this.getContextManager());
            if (this.hasCheckConstraints(dataDictionary, this.targetTableDescriptor) || this.hasGenerationClauses(this.targetTableDescriptor)) {
                int afterColumnsSize = afterColumns.size();
                afterColumns = new ResultColumnList(this.getContextManager());
                ResultColumnList normalizedRCs = this.resultSet.getResultColumns();
                for (int index = 0; index < afterColumnsSize; ++index) {
                    afterColumns.addElement(normalizedRCs.elementAt(index + afterColumnsSize));
                }
            }
        }
        if (null != this.targetVTI && !this.inMatchingClause()) {
            this.deferred = VTIDeferModPolicy.deferIt(2, this.targetVTI, this.resultColumnList.getColumnNames(), sel.getWhereClause());
        } else {
            boolean hasTriggers = this.getAllRelevantTriggers(dataDictionary, this.targetTableDescriptor, this.changedColumnIds, true).size() > 0;
            ResultColumnList sourceRCL = hasTriggers ? this.resultColumnList : afterColumns;
            this.parseAndBindGenerationClauses(dataDictionary, this.targetTableDescriptor, afterColumns, this.resultColumnList, true, this.resultSet);
            this.checkConstraints = this.bindConstraints(dataDictionary, this.getOptimizerFactory(), this.targetTableDescriptor, null, sourceRCL, this.changedColumnIds, this.readColsBitSet, true, new boolean[1]);
            if (this.resultSet.subqueryReferencesTarget(this.targetTableDescriptor.getName(), true) || this.requiresDeferredProcessing()) {
                this.deferred = true;
            }
        }
        this.getCompilerContext().popCurrentPrivType();
        this.getCompilerContext().removePrivilegeFilter(tagFilter);
        for (CastNode value : allCastNodes) {
            this.addUDTUsagePriv(value);
        }
    }

    @Override
    int getPrivType() {
        return 1;
    }

    private ArrayList<String> getExplicitlySetColumns() throws StandardException {
        ArrayList<String> result = new ArrayList<String>();
        ResultColumnList rcl = this.resultSet.getResultColumns();
        for (int i = 0; i < rcl.size(); ++i) {
            result.add(((ResultColumn)rcl.elementAt(i)).getName());
        }
        return result;
    }

    private void associateAddedColumns() throws StandardException {
        for (ColumnReference cr : this.collectAllResultSetColumns()) {
            if (cr.taggedWith("origUpdateCol")) continue;
            cr.setMergeTableID(2);
        }
    }

    private void tagOriginalResultSetColumns() throws StandardException {
        for (ColumnReference cr : this.collectAllResultSetColumns()) {
            cr.addTag("origUpdateCol");
        }
    }

    private List<ColumnReference> collectAllResultSetColumns() throws StandardException {
        CollectNodesVisitor<ColumnReference> crVisitor = new CollectNodesVisitor<ColumnReference>(ColumnReference.class);
        this.resultSet.getResultColumns().accept(crVisitor);
        return crVisitor.getList();
    }

    private List<CastNode> collectAllCastNodes() throws StandardException {
        CollectNodesVisitor<CastNode> getCasts = new CollectNodesVisitor<CastNode>(CastNode.class);
        ValueNode whereClause = ((SelectNode)this.resultSet).whereClause;
        if (whereClause != null) {
            whereClause.accept(getCasts);
        }
        ResultColumnList rcl = this.resultSet.getResultColumns();
        for (int i = 0; i < rcl.size(); ++i) {
            ((ResultColumn)rcl.elementAt(i)).getExpression().accept(getCasts);
        }
        return getCasts.getList();
    }

    private void tagPrivilegedNodes() throws StandardException {
        ArrayList<QueryTreeNode> result = new ArrayList<QueryTreeNode>();
        SelectNode selectNode = (SelectNode)this.resultSet;
        result.add(this);
        ValueNode whereClause = selectNode.whereClause;
        if (whereClause != null) {
            this.collectPrivilegedNodes(result, whereClause);
        }
        ResultColumnList rcl = this.resultSet.getResultColumns();
        for (int i = 0; i < rcl.size(); ++i) {
            this.collectPrivilegedNodes(result, ((ResultColumn)rcl.elementAt(i)).getExpression());
        }
        for (QueryTreeNode expr : result) {
            expr.addTag("updatePrivs");
        }
    }

    private void collectPrivilegedNodes(ArrayList<QueryTreeNode> result, QueryTreeNode expr) throws StandardException {
        CollectNodesVisitor<ColumnReference> getCRs = new CollectNodesVisitor<ColumnReference>(ColumnReference.class);
        expr.accept(getCRs);
        result.addAll(getCRs.getList());
        CollectNodesVisitor<StaticMethodCallNode> getSMCNs = new CollectNodesVisitor<StaticMethodCallNode>(StaticMethodCallNode.class);
        expr.accept(getSMCNs);
        result.addAll(getSMCNs.getList());
        CollectNodesVisitor<FromBaseTable> getFBTs = new CollectNodesVisitor<FromBaseTable>(FromBaseTable.class);
        expr.accept(getFBTs);
        result.addAll(getFBTs.getList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUpdatePriv(ArrayList<String> explicitlySetColumns) throws StandardException {
        if (!this.isPrivilegeCollectionRequired()) {
            return;
        }
        CompilerContext cc = this.getCompilerContext();
        cc.pushCurrentPrivType(1);
        try {
            for (String columnName : explicitlySetColumns) {
                ColumnDescriptor cd = this.targetTableDescriptor.getColumnDescriptor(columnName);
                cc.addRequiredColumnPriv(cd);
            }
        }
        finally {
            cc.popCurrentPrivType();
        }
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return this.resultSet.referencesSessionSchema();
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        ConglomerateDescriptor updateCD;
        if (!this.deferred && !this.inMatchingClause() && (updateCD = this.targetTable.getTrulyTheBestAccessPath().getConglomerateDescriptor()) != null && updateCD.isIndex()) {
            int[] baseColumns = updateCD.getIndexDescriptor().baseColumnPositions();
            if (this.resultSet.getResultColumns().updateOverlaps(baseColumns)) {
                this.deferred = true;
            }
        }
        if (null == this.targetTableDescriptor) {
            return this.getGenericConstantActionFactory().getUpdatableVTIConstantAction(2, this.deferred, this.changedColumnIds);
        }
        int lckMode = this.inMatchingClause() ? 6 : this.resultSet.updateTargetLockMode();
        long heapConglomId = this.targetTableDescriptor.getHeapConglomerateId();
        TransactionController tc = this.getLanguageConnectionContext().getTransactionCompile();
        StaticCompiledOpenConglomInfo[] indexSCOCIs = new StaticCompiledOpenConglomInfo[this.indexConglomerateNumbers.length];
        for (int index = 0; index < indexSCOCIs.length; ++index) {
            indexSCOCIs[index] = tc.getStaticCompiledConglomInfo(this.indexConglomerateNumbers[index]);
        }
        if (this.targetTableDescriptor.getLockGranularity() == 'T') {
            lckMode = 7;
        }
        return this.getGenericConstantActionFactory().getUpdateConstantAction(this.targetTableDescriptor, tc.getStaticCompiledConglomInfo(heapConglomId), this.indicesToMaintain, this.indexConglomerateNumbers, indexSCOCIs, this.indexNames, this.deferred, this.targetTableDescriptor.getUUID(), lckMode, false, this.changedColumnIds, null, null, this.getFKInfo(), this.getTriggerInfo(), this.readColsBitSet == null ? (FormatableBitSet)null : new FormatableBitSet(this.readColsBitSet), UpdateNode.getReadColMap(this.targetTableDescriptor.getNumberOfColumns(), this.readColsBitSet), this.resultColumnList.getStreamStorableColIds(this.targetTableDescriptor.getNumberOfColumns()), this.readColsBitSet == null ? this.targetTableDescriptor.getNumberOfColumns() : this.readColsBitSet.getNumBitsSet(), this.positionedUpdate, this.resultSet.isOneRowResultSet(), this.inMatchingClause());
    }

    protected void setDeferredForUpdateOfIndexColumn() {
        ConglomerateDescriptor updateCD;
        if (!this.deferred && (updateCD = this.targetTable.getTrulyTheBestAccessPath().getConglomerateDescriptor()) != null && updateCD.isIndex()) {
            int[] baseColumns = updateCD.getIndexDescriptor().baseColumnPositions();
            if (this.resultSet.getResultColumns().updateOverlaps(baseColumns)) {
                this.deferred = true;
            }
        }
    }

    @Override
    void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.generateCodeForTemporaryTable(acb);
        if (!this.isDependentTable) {
            this.generateParameterValueSet(acb);
        }
        acb.newFieldDeclaration(2, "org.apache.derby.iapi.sql.execute.CursorResultSet", acb.newRowLocationScanResultSetName());
        acb.pushGetResultSetFactoryExpression(mb);
        if (this.inMatchingClause()) {
            this.matchingClause.generateResultSetField(acb, mb);
        } else {
            this.resultSet.generate(acb, mb);
        }
        if (null != this.targetVTI && !this.inMatchingClause()) {
            this.targetVTI.assignCostEstimate(this.resultSet.getNewCostEstimate());
            mb.callMethod((short)185, null, "getUpdateVTIResultSet", "org.apache.derby.iapi.sql.ResultSet", 1);
        } else {
            this.generateGenerationClauses(this.resultColumnList, this.resultSet.getResultSetNumber(), true, acb, mb);
            this.generateCheckConstraints(this.checkConstraints, acb, mb);
            if (this.isDependentTable) {
                mb.push(acb.addItem(this.makeConstantAction()));
                mb.push(acb.addItem(this.makeResultDescription()));
                mb.callMethod((short)185, null, "getDeleteCascadeUpdateResultSet", "org.apache.derby.iapi.sql.ResultSet", 5);
            } else {
                mb.callMethod((short)185, null, "getUpdateResultSet", "org.apache.derby.iapi.sql.ResultSet", 3);
            }
        }
    }

    @Override
    protected final int getStatementType() {
        return 3;
    }

    FormatableBitSet getReadMap(DataDictionary dd, TableDescriptor baseTable, ResultColumnList updateColumnList, ColumnDescriptorList affectedGeneratedColumns) throws StandardException {
        boolean[] needsDeferredProcessing = new boolean[]{this.requiresDeferredProcessing()};
        ArrayList<ConglomerateDescriptor> conglomerates = new ArrayList<ConglomerateDescriptor>();
        this.relevantCdl = new ConstraintDescriptorList();
        this.relevantTriggers = new TriggerDescriptorList();
        FormatableBitSet columnMap = UpdateNode.getUpdateReadMap(dd, baseTable, updateColumnList, conglomerates, this.relevantCdl, this.relevantTriggers, needsDeferredProcessing, affectedGeneratedColumns);
        this.markAffectedIndexes(conglomerates);
        this.adjustDeferredFlag(needsDeferredProcessing[0]);
        return columnMap;
    }

    private int[] getChangedColumnIds(ResultColumnList rcl) {
        if (rcl == null) {
            return null;
        }
        return rcl.sortMe();
    }

    static FormatableBitSet getUpdateReadMap(DataDictionary dd, TableDescriptor baseTable, ResultColumnList updateColumnList, List<ConglomerateDescriptor> conglomerates, ConstraintDescriptorList relevantConstraints, TriggerDescriptorList relevantTriggers, boolean[] needsDeferredProcessing, ColumnDescriptorList affectedGeneratedColumns) throws StandardException {
        Object refColumns;
        SanityManager.ASSERT(updateColumnList != null, "updateColumnList is null");
        int columnCount = baseTable.getMaxColumnID();
        FormatableBitSet columnMap = new FormatableBitSet(columnCount + 1);
        int[] changedColumnIds = updateColumnList.sortMe();
        for (int ix = 0; ix < changedColumnIds.length; ++ix) {
            columnMap.set(changedColumnIds[ix]);
        }
        DMLModStatementNode.getXAffectedIndexes(baseTable, updateColumnList, columnMap, conglomerates);
        baseTable.getAllRelevantConstraints(3, changedColumnIds, needsDeferredProcessing, relevantConstraints);
        int rclSize = relevantConstraints.size();
        for (int index = 0; index < rclSize; ++index) {
            ConstraintDescriptor cd = relevantConstraints.elementAt(index);
            if (cd.getConstraintType() != 4) continue;
            refColumns = ((CheckConstraintDescriptor)cd).getReferencedColumns();
            for (int i = 0; i < ((int[])refColumns).length; ++i) {
                columnMap.set(refColumns[i]);
            }
        }
        UpdateNode.addGeneratedColumnPrecursors(baseTable, affectedGeneratedColumns, columnMap);
        baseTable.getAllRelevantTriggers(3, changedColumnIds, relevantTriggers);
        if (relevantTriggers.size() > 0) {
            needsDeferredProcessing[0] = true;
            boolean needToIncludeAllColumns = false;
            boolean in10_9_orHigherVersion = dd.checkVersion(210, null);
            refColumns = relevantTriggers.iterator();
            while (refColumns.hasNext()) {
                TriggerDescriptor trd = (TriggerDescriptor)refColumns.next();
                if (in10_9_orHigherVersion) {
                    int ix;
                    int[] referencedColsInTriggerAction = trd.getReferencedColsInTriggerAction();
                    int[] triggerCols = trd.getReferencedCols();
                    if (triggerCols == null || triggerCols.length == 0) {
                        for (int i = 0; i < columnCount; ++i) {
                            columnMap.set(i + 1);
                        }
                        break;
                    }
                    if (referencedColsInTriggerAction == null || referencedColsInTriggerAction.length == 0) {
                        if (!trd.getReferencingNew() && !trd.getReferencingOld()) {
                            for (ix = 0; ix < triggerCols.length; ++ix) {
                                columnMap.set(triggerCols[ix]);
                            }
                            continue;
                        }
                        needToIncludeAllColumns = true;
                        break;
                    }
                    for (ix = 0; ix < triggerCols.length; ++ix) {
                        columnMap.set(triggerCols[ix]);
                    }
                    for (ix = 0; ix < referencedColsInTriggerAction.length; ++ix) {
                        columnMap.set(referencedColsInTriggerAction[ix]);
                    }
                    continue;
                }
                if (!trd.getReferencingNew() && !trd.getReferencingOld()) continue;
                needToIncludeAllColumns = true;
                break;
            }
            if (needToIncludeAllColumns) {
                for (int i = 1; i <= columnCount; ++i) {
                    columnMap.set(i);
                }
            }
        }
        return columnMap;
    }

    private static void addGeneratedColumnPrecursors(TableDescriptor baseTable, ColumnDescriptorList affectedGeneratedColumns, FormatableBitSet columnMap) throws StandardException {
        int generatedColumnCount = affectedGeneratedColumns.size();
        for (int gcIdx = 0; gcIdx < generatedColumnCount; ++gcIdx) {
            ColumnDescriptor gc = affectedGeneratedColumns.elementAt(gcIdx);
            String[] mentionedColumnNames = gc.getDefaultInfo().getReferencedColumnNames();
            int[] mentionedColumns = baseTable.getColumnIDs(mentionedColumnNames);
            int mentionedColumnCount = mentionedColumns.length;
            for (int mcIdx = 0; mcIdx < mentionedColumnCount; ++mcIdx) {
                columnMap.set(mentionedColumns[mcIdx]);
            }
        }
    }

    private void addGeneratedColumns(TableDescriptor baseTable, ResultSetNode updateSet, ColumnDescriptorList affectedGeneratedColumns, ColumnDescriptorList addedGeneratedColumns) throws StandardException {
        ResultColumnList updateColumnList = updateSet.getResultColumns();
        ColumnDescriptorList generatedColumns = baseTable.getGeneratedColumns();
        HashSet<String> updatedColumns = new HashSet<String>();
        UUID tableID = baseTable.getObjectID();
        for (ResultColumn rc : updateColumnList) {
            updatedColumns.add(rc.getName());
        }
        block1: for (ColumnDescriptor gc : generatedColumns) {
            DefaultInfo defaultInfo = gc.getDefaultInfo();
            String[] mentionedColumnNames = defaultInfo.getReferencedColumnNames();
            int mentionedColumnCount = mentionedColumnNames.length;
            if (updatedColumns.contains(gc.getColumnName())) {
                affectedGeneratedColumns.add(tableID, gc);
            }
            for (String mcn : mentionedColumnNames) {
                if (!updatedColumns.contains(mcn)) continue;
                affectedGeneratedColumns.add(tableID, gc);
                if (updatedColumns.contains(gc.getColumnName())) continue block1;
                addedGeneratedColumns.add(tableID, gc);
                UntypedNullConstantNode dummy = new UntypedNullConstantNode(this.getContextManager());
                ResultColumn newResultColumn = new ResultColumn(gc.getType(), (ValueNode)dummy, this.getContextManager());
                newResultColumn.setColumnDescriptor(baseTable, gc);
                newResultColumn.setName(gc.getColumnName());
                updateColumnList.addResultColumn(newResultColumn);
                continue block1;
            }
        }
    }

    private void normalizeCorrelatedColumns(ResultColumnList rcl, FromTable fromTable) throws StandardException {
        String correlationName = fromTable.getCorrelationName();
        if (correlationName == null) {
            return;
        }
        TableName tableNameNode = fromTable instanceof CurrentOfNode ? ((CurrentOfNode)fromTable).getBaseCursorTargetTableName() : this.makeTableName(null, fromTable.getBaseTableName());
        for (ResultColumn column : rcl) {
            ColumnReference reference = column.getReference();
            if (reference == null || !correlationName.equals(reference.getTableName())) continue;
            reference.setQualifiedTableName(tableNameNode);
        }
    }

    private void checkTableNameAndScrubResultColumns(ResultColumnList rcl) throws StandardException {
        for (ResultColumn column : rcl) {
            boolean foundMatchingTable = false;
            if (column.getTableName() != null && !this.inMatchingClause()) {
                for (ResultSetNode rsn : ((SelectNode)this.resultSet).fromList) {
                    FromTable fromTable = (FromTable)rsn;
                    String tableName = fromTable instanceof CurrentOfNode ? ((CurrentOfNode)fromTable).getBaseCursorTargetTableName().getTableName() : fromTable.getBaseTableName();
                    if (!column.getTableName().equals(tableName)) continue;
                    foundMatchingTable = true;
                    break;
                }
                if (!foundMatchingTable) {
                    throw StandardException.newException("42X04", column.getTableName() + "." + column.getName());
                }
            }
            column.clearTableName();
        }
    }

    private void normalizeSynonymColumns(ResultColumnList rcl, FromTable fromTable) throws StandardException {
        if (fromTable.getCorrelationName() != null) {
            return;
        }
        TableName tableNameNode = fromTable instanceof CurrentOfNode ? ((CurrentOfNode)fromTable).getBaseCursorTargetTableName() : this.makeTableName(null, fromTable.getBaseTableName());
        super.normalizeSynonymColumns(rcl, tableNameNode);
    }

    private void forbidGenerationOverrides(ResultColumnList targetRCL, ColumnDescriptorList addedGeneratedColumns) throws StandardException {
        int count = targetRCL.size();
        ResultColumnList resultRCL = this.resultSet.getResultColumns();
        for (int i = 0; i < count; ++i) {
            ValueNode resultExpression;
            ResultColumn rc = (ResultColumn)targetRCL.elementAt(i);
            if (rc.wasDefaultColumn() || !rc.hasGenerationClause() || (resultExpression = ((ResultColumn)resultRCL.elementAt(i)).getExpression()) instanceof DefaultNode) continue;
            boolean allIsForgiven = false;
            String columnName = rc.getTableColumnDescriptor().getColumnName();
            int addedCount = addedGeneratedColumns.size();
            for (int j = 0; j < addedCount; ++j) {
                String addedColumnName = addedGeneratedColumns.elementAt(j).getColumnName();
                if (!columnName.equals(addedColumnName)) continue;
                allIsForgiven = true;
                break;
            }
            if (allIsForgiven) continue;
            throw StandardException.newException("42XA3", rc.getName());
        }
    }
}

