/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.sql.execute.RowChanger;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.DMLWriteResultSet;
import org.apache.derby.impl.sql.execute.DeleteConstantAction;
import org.apache.derby.impl.sql.execute.FKInfo;
import org.apache.derby.impl.sql.execute.RISetChecker;
import org.apache.derby.impl.sql.execute.RowUtil;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderImpl;
import org.apache.derby.impl.sql.execute.TriggerEventActivator;
import org.apache.derby.impl.sql.execute.TriggerEvents;
import org.apache.derby.impl.sql.execute.TriggerInfo;
import org.apache.derby.shared.common.sanity.SanityManager;

class DeleteResultSet
extends DMLWriteResultSet {
    private TransactionController tc;
    DeleteConstantAction constants;
    protected NoPutResultSet source;
    NoPutResultSet savedSource;
    int numIndexes;
    protected RowChanger rc;
    private ExecRow row;
    protected ConglomerateController deferredBaseCC;
    protected TemporaryRowHolderImpl rowHolder;
    private int numOpens;
    private boolean firstExecute;
    private FormatableBitSet baseRowReadList;
    private int rlColumnNumber;
    protected FKInfo[] fkInfoArray;
    private TriggerInfo triggerInfo;
    private RISetChecker fkChecker;
    private TriggerEventActivator triggerActivator;
    private boolean noTriggersOrFks;
    ExecRow deferredSparseRow;
    ExecRow deferredBaseRow;
    int lockMode;
    protected boolean cascadeDelete;
    ExecRow deferredRLRow = null;
    int numberOfBaseColumns = 0;

    DeleteResultSet(NoPutResultSet source, Activation activation) throws StandardException {
        this(source, activation.getConstantAction(), activation);
    }

    DeleteResultSet(NoPutResultSet source, ConstantAction passedInConstantAction, Activation activation) throws StandardException {
        super(activation, passedInConstantAction);
        this.source = source;
        this.tc = activation.getTransactionController();
        this.constants = (DeleteConstantAction)this.constantAction;
        this.fkInfoArray = this.constants.getFKInfo();
        this.triggerInfo = this.constants.getTriggerInfo();
        this.noTriggersOrFks = this.fkInfoArray == null && this.triggerInfo == null;
        this.baseRowReadList = this.constants.getBaseRowReadList();
        this.resultDescription = source != null ? source.getResultDescription() : this.constants.resultDescription;
    }

    @Override
    public void open() throws StandardException {
        this.setup();
        boolean rowsFound = this.collectAffectedRows();
        if (!rowsFound) {
            this.activation.addWarning(StandardException.newWarning("02000", new Object[0]));
        }
        if (this.constants.deferred) {
            this.runFkChecker(true);
            this.fireBeforeTriggers();
            this.deleteDeferredRows();
            this.runFkChecker(false);
            this.rc.finish();
            this.fireAfterTriggers();
        }
        if (this.lcc.getRunTimeStatisticsMode()) {
            this.savedSource = this.source;
        }
        this.cleanUp();
        this.endTime = this.getCurrentTimeMillis();
    }

    @Override
    void setup() throws StandardException {
        super.setup();
        this.firstExecute = this.rc == null;
        try {
            if (this.numOpens++ == 0) {
                this.source.openCore();
            } else {
                this.source.reopenCore();
            }
        }
        catch (StandardException se) {
            this.activation.checkStatementValidity();
            throw se;
        }
        this.activation.checkStatementValidity();
        if (this.firstExecute) {
            this.rc = this.lcc.getLanguageConnectionFactory().getExecutionFactory().getRowChanger(this.constants.conglomId, this.constants.heapSCOCI, this.heapDCOCI, this.constants.irgs, this.constants.indexCIDS, this.constants.indexSCOCIs, this.indexDCOCIs, this.constants.numColumns, this.tc, null, this.baseRowReadList, this.constants.getBaseRowReadMap(), this.constants.getStreamStorableHeapColIds(), this.activation);
        }
        this.lockMode = this.decodeLockMode(this.constants.lockMode);
        this.rc.open(this.lockMode);
        if (this.constants.deferred || this.cascadeDelete) {
            this.activation.clearIndexScanInfo();
        }
        this.rowCount = 0L;
        if (!this.cascadeDelete) {
            this.row = this.getNextRowCore(this.source);
        }
        if (this.resultDescription == null) {
            SanityManager.ASSERT(this.triggerInfo == null, "result description is needed to supply to trigger result sets");
            this.numberOfBaseColumns = this.row == null ? 0 : this.row.nColumns();
        } else {
            this.numberOfBaseColumns = this.resultDescription.getColumnCount();
        }
        this.numIndexes = this.constants.irgs.length;
        if (this.constants.deferred || this.cascadeDelete) {
            Properties properties = new Properties();
            this.rc.getHeapConglomerateController().getInternalTablePropertySet(properties);
            this.deferredRLRow = RowUtil.getEmptyValueRow(1, this.lcc);
            int n = this.rlColumnNumber = this.noTriggersOrFks ? 1 : this.numberOfBaseColumns;
            this.rowHolder = this.cascadeDelete ? new TemporaryRowHolderImpl(this.activation, properties, this.resultDescription != null ? this.resultDescription.truncateColumns(this.rlColumnNumber) : null, false) : new TemporaryRowHolderImpl(this.activation, properties, this.resultDescription != null ? this.resultDescription.truncateColumns(this.rlColumnNumber) : null);
            this.rc.setRowHolder(this.rowHolder);
        }
        if (this.fkInfoArray != null) {
            if (this.fkChecker == null) {
                this.fkChecker = new RISetChecker(this.lcc, this.tc, this.fkInfoArray);
            } else {
                this.fkChecker.reopen();
            }
        }
    }

    boolean collectAffectedRows() throws StandardException {
        boolean rowsFound = false;
        if (this.cascadeDelete) {
            this.row = this.getNextRowCore(this.source);
        }
        while (this.row != null) {
            rowsFound = true;
            DataValueDescriptor rlColumn = this.row.getColumn(this.row.nColumns());
            if (this.constants.deferred || this.cascadeDelete) {
                if (this.noTriggersOrFks) {
                    this.deferredRLRow.setColumn(1, rlColumn);
                    this.rowHolder.insert(this.deferredRLRow);
                } else {
                    this.rowHolder.insert(this.row);
                }
                if (this.deferredBaseRow == null) {
                    this.deferredBaseRow = RowUtil.getEmptyValueRow(this.numberOfBaseColumns - 1, this.lcc);
                    RowUtil.copyCloneColumns(this.deferredBaseRow, this.row, this.numberOfBaseColumns - 1);
                    this.deferredSparseRow = this.makeDeferredSparseRow(this.deferredBaseRow, this.baseRowReadList, this.lcc);
                }
            } else {
                RowLocation baseRowLocation;
                if (this.fkChecker != null) {
                    this.fkChecker.doPKCheck(this.activation, this.row, false, 2);
                }
                SanityManager.ASSERT((baseRowLocation = (RowLocation)rlColumn.getObject()) != null, "baseRowLocation is null");
                this.rc.deleteRow(this.row, baseRowLocation);
                this.source.markRowAsDeleted();
            }
            ++this.rowCount;
            if (this.constants.singleRowSource) {
                this.row = null;
                continue;
            }
            this.row = this.getNextRowCore(this.source);
        }
        return rowsFound;
    }

    void fireBeforeTriggers() throws StandardException {
        if (this.triggerInfo != null) {
            if (this.triggerActivator == null) {
                this.triggerActivator = new TriggerEventActivator(this.lcc, this.constants.targetUUID, this.triggerInfo, 2, this.activation, null);
            } else {
                this.triggerActivator.reopen();
            }
            this.triggerActivator.notifyEvent(TriggerEvents.BEFORE_DELETE, this.rowHolder.getResultSet(), null, this.constants.getBaseRowReadMap());
            this.triggerActivator.cleanup();
        }
    }

    void fireAfterTriggers() throws StandardException {
        if (this.triggerActivator != null) {
            this.triggerActivator.reopen();
            this.triggerActivator.notifyEvent(TriggerEvents.AFTER_DELETE, this.rowHolder.getResultSet(), null, this.constants.getBaseRowReadMap());
            this.triggerActivator.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteDeferredRows() throws StandardException {
        this.deferredBaseCC = this.tc.openCompiledConglomerate(false, 8196, this.lockMode, 5, this.constants.heapSCOCI, this.heapDCOCI);
        CursorResultSet rs = this.rowHolder.getResultSet();
        try {
            ExecRow defRLRow;
            FormatableBitSet readBitSet = RowUtil.shift(this.baseRowReadList, 1);
            rs.open();
            while ((defRLRow = rs.getNextRow()) != null) {
                DataValueDescriptor rlColumn = defRLRow.getColumn(this.rlColumnNumber);
                RowLocation baseRowLocation = (RowLocation)rlColumn.getObject();
                boolean row_exists = this.deferredBaseCC.fetch(baseRowLocation, this.deferredSparseRow.getRowArray(), readBitSet);
                if (this.cascadeDelete && !row_exists) continue;
                if (!row_exists) {
                    SanityManager.THROWASSERT("could not find row " + baseRowLocation);
                }
                this.rc.deleteRow(this.deferredBaseRow, baseRowLocation);
                this.source.markRowAsDeleted();
            }
        }
        finally {
            rs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runFkChecker(boolean restrictCheckOnly) throws StandardException {
        if (this.fkChecker != null) {
            CursorResultSet rs = this.rowHolder.getResultSet();
            try {
                ExecRow defRLRow;
                rs.open();
                while ((defRLRow = rs.getNextRow()) != null) {
                    this.fkChecker.doPKCheck(this.activation, defRLRow, restrictCheckOnly, 1);
                }
                if (restrictCheckOnly) {
                    this.fkChecker.postCheck();
                }
            }
            finally {
                rs.close();
            }
        }
    }

    NoPutResultSet createDependentSource(RowChanger rc) throws StandardException {
        return null;
    }

    @Override
    public void cleanUp() throws StandardException {
        this.numOpens = 0;
        if (this.source != null) {
            this.source.close();
        }
        if (this.rc != null) {
            this.rc.close();
        }
        if (this.rowHolder != null) {
            this.rowHolder.close();
        }
        if (this.fkChecker != null) {
            this.fkChecker.close();
        }
        if (this.deferredBaseCC != null) {
            this.deferredBaseCC.close();
        }
        this.deferredBaseCC = null;
        if (this.rc != null) {
            this.rc.close();
        }
        this.close();
    }

    @Override
    public void close() throws StandardException {
        super.close(this.constants.underMerge());
    }

    @Override
    public void finish() throws StandardException {
        if (this.source != null) {
            this.source.finish();
        }
        super.finish();
    }
}

