/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.types.SQLBoolean;
import org.apache.derby.impl.sql.execute.BaseActivation;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderImpl;

public class MatchingClauseConstantAction
implements ConstantAction,
Formatable {
    private static final long serialVersionUID = -6725483265211088817L;
    private static final int FIRST_VERSION = 0;
    private int _clauseType;
    private String _matchRefinementName;
    private ResultDescription _thenColumnSignature;
    private String _rowMakingMethodName;
    private String _resultSetFieldName;
    private String _actionMethodName;
    private ConstantAction _thenAction;
    private transient GeneratedMethod _matchRefinementMethod;
    private transient GeneratedMethod _rowMakingMethod;
    private transient ResultSet _actionRS;

    public MatchingClauseConstantAction() {
    }

    public MatchingClauseConstantAction(int clauseType, String matchRefinementName, ResultDescription thenColumnSignature, String rowMakingMethodName, String resultSetFieldName, String actionMethodName, ConstantAction thenAction) {
        this._clauseType = clauseType;
        this._matchRefinementName = matchRefinementName;
        this._thenColumnSignature = thenColumnSignature;
        this._rowMakingMethodName = rowMakingMethodName;
        this._resultSetFieldName = resultSetFieldName;
        this._actionMethodName = actionMethodName;
        this._thenAction = thenAction;
    }

    public int clauseType() {
        return this._clauseType;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeConstantAction(Activation activation, TemporaryRowHolderImpl thenRows) throws StandardException {
        if (thenRows == null) {
            return;
        }
        CursorResultSet sourceRS = thenRows.getResultSet();
        GeneratedMethod actionGM = ((BaseActivation)activation).getMethod(this._actionMethodName);
        try {
            activation.pushConstantAction(this._thenAction);
            try {
                Field resultSetField = activation.getClass().getField(this._resultSetFieldName);
                resultSetField.set(activation, sourceRS);
                Activation cursorActivation = sourceRS.getActivation();
                Method actionMethod = activation.getClass().getMethod(this._actionMethodName, new Class[0]);
                this._actionRS = (ResultSet)actionMethod.invoke((Object)activation, null);
            }
            catch (Exception e) {
                throw StandardException.plainWrapException(e);
            }
            this._actionRS.open();
        }
        finally {
            activation.popConstantAction();
        }
    }

    void init() throws StandardException {
        this._actionRS = null;
    }

    boolean evaluateRefinementClause(Activation activation) throws StandardException {
        SQLBoolean result;
        if (this._matchRefinementName == null) {
            return true;
        }
        if (this._matchRefinementMethod == null) {
            this._matchRefinementMethod = ((BaseActivation)activation).getMethod(this._matchRefinementName);
        }
        if ((result = (SQLBoolean)this._matchRefinementMethod.invoke(activation)).isNull()) {
            return false;
        }
        return result.getBoolean();
    }

    TemporaryRowHolderImpl bufferThenRow(Activation activation, TemporaryRowHolderImpl thenRows, ExecRow selectRow) throws StandardException {
        if (thenRows == null) {
            thenRows = this.createThenRows(activation);
        }
        ExecRow thenRow = this.bufferThenRow(activation);
        thenRows.insert(thenRow);
        return thenRows;
    }

    void cleanUp() throws StandardException {
        if (this._actionRS != null) {
            this._actionRS.close();
            this._actionRS = null;
        }
        this._matchRefinementMethod = null;
        this._rowMakingMethod = null;
    }

    private ExecRow bufferThenRow(Activation activation) throws StandardException {
        if (this._rowMakingMethod == null) {
            this._rowMakingMethod = ((BaseActivation)activation).getMethod(this._rowMakingMethodName);
        }
        return (ExecRow)this._rowMakingMethod.invoke(activation);
    }

    private TemporaryRowHolderImpl createThenRows(Activation activation) throws StandardException {
        return new TemporaryRowHolderImpl(activation, new Properties(), this._thenColumnSignature);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int oldVersion = in.readInt();
        this._clauseType = in.readInt();
        this._matchRefinementName = (String)in.readObject();
        this._thenColumnSignature = (ResultDescription)in.readObject();
        this._rowMakingMethodName = (String)in.readObject();
        this._resultSetFieldName = (String)in.readObject();
        this._actionMethodName = (String)in.readObject();
        this._thenAction = (ConstantAction)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(0);
        out.writeInt(this._clauseType);
        out.writeObject(this._matchRefinementName);
        out.writeObject(this._thenColumnSignature);
        out.writeObject(this._rowMakingMethodName);
        out.writeObject(this._resultSetFieldName);
        out.writeObject(this._actionMethodName);
        out.writeObject(this._thenAction);
    }

    @Override
    public int getTypeFormatId() {
        return 476;
    }
}

