/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.sql.execute.ResultSetStatistics;
import org.apache.derby.impl.sql.catalog.XPLAINResultSetDescriptor;
import org.apache.derby.impl.sql.execute.rts.RealNestedLoopJoinStatistics;

public class RealNestedLoopLeftOuterJoinStatistics
extends RealNestedLoopJoinStatistics {
    public int emptyRightRowsReturned;

    public RealNestedLoopLeftOuterJoinStatistics(int numOpens, int rowsSeen, int rowsFiltered, long constructorTime, long openTime, long nextTime, long closeTime, int resultSetNumber, int rowsSeenLeft, int rowsSeenRight, int rowsReturned, long restrictionTime, double optimizerEstimatedRowCount, double optimizerEstimatedCost, String userSuppliedOptimizerOverrides, ResultSetStatistics leftResultSetStatistics, ResultSetStatistics rightResultSetStatistics, int emptyRightRowsReturned) {
        super(numOpens, rowsSeen, rowsFiltered, constructorTime, openTime, nextTime, closeTime, resultSetNumber, rowsSeenLeft, rowsSeenRight, rowsReturned, restrictionTime, false, optimizerEstimatedRowCount, optimizerEstimatedCost, userSuppliedOptimizerOverrides, leftResultSetStatistics, rightResultSetStatistics);
        this.emptyRightRowsReturned = emptyRightRowsReturned;
    }

    @Override
    public String getStatementExecutionPlanText(int depth) {
        this.initFormatInfo(depth);
        return this.indent + this.resultSetName + ":" + "\n" + this.indent + MessageService.getTextMessage("43X03.U", new Object[0]) + " = " + this.numOpens + "\n" + this.indent + MessageService.getTextMessage("43X79.U", new Object[0]) + " = " + this.rowsSeenLeft + "\n" + this.indent + MessageService.getTextMessage("43X80.U", new Object[0]) + " = " + this.rowsSeenRight + "\n" + this.indent + MessageService.getTextMessage("43X88.U", new Object[0]) + " = " + this.emptyRightRowsReturned + "\n" + this.indent + MessageService.getTextMessage("43X32.U", new Object[0]) + " = " + this.rowsFiltered + "\n" + this.indent + MessageService.getTextMessage("43X81.U", new Object[0]) + " = " + this.rowsReturned + "\n" + this.dumpTimeStats(this.indent, this.subIndent) + "\n" + this.dumpEstimatedCosts(this.subIndent) + "\n" + this.indent + MessageService.getTextMessage("43X82.U", new Object[0]) + ":\n" + this.leftResultSetStatistics.getStatementExecutionPlanText(this.sourceDepth) + "\n" + this.indent + MessageService.getTextMessage("43X83.U", new Object[0]) + ":\n" + this.rightResultSetStatistics.getStatementExecutionPlanText(this.sourceDepth) + "\n";
    }

    @Override
    public String getScanStatisticsText(String tableName, int depth) {
        return this.leftResultSetStatistics.getScanStatisticsText(tableName, depth) + this.rightResultSetStatistics.getScanStatisticsText(tableName, depth);
    }

    @Override
    public String toString() {
        return this.getStatementExecutionPlanText(0);
    }

    @Override
    protected void setNames() {
        this.nodeName = MessageService.getTextMessage("43X89.U", new Object[0]);
        this.resultSetName = MessageService.getTextMessage("43X90.U", new Object[0]);
    }

    @Override
    public String getRSXplainType() {
        return "LONLJOIN";
    }

    @Override
    public String getRSXplainDetails() {
        String op_details = "(" + this.resultSetNumber + "), " + this.resultSetName;
        if (this.oneRowRightSide) {
            op_details = op_details + ", EXISTS JOIN";
        }
        return op_details;
    }

    @Override
    public Object getResultSetDescriptor(Object rsID, Object parentID, Object scanID, Object sortID, Object stmtID, Object timingID) {
        return new XPLAINResultSetDescriptor((UUID)rsID, this.getRSXplainType(), this.getRSXplainDetails(), new Integer(this.numOpens), null, null, null, (UUID)parentID, new Double(this.optimizerEstimatedRowCount), new Double(this.optimizerEstimatedCost), null, null, null, new Integer(this.rowsSeenLeft), new Integer(this.rowsSeenRight), new Integer(this.rowsFiltered), new Integer(this.rowsReturned), new Integer(this.emptyRightRowsReturned), null, (UUID)scanID, (UUID)sortID, (UUID)stmtID, (UUID)timingID);
    }
}

