/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.util.Observable;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.impl.store.raw.data.ContainerActionOnCommit;
import org.apache.derby.shared.common.sanity.SanityManager;

public class DropOnCommit
extends ContainerActionOnCommit {
    protected boolean isStreamContainer = false;

    public DropOnCommit(ContainerKey identity) {
        super(identity);
    }

    public DropOnCommit(ContainerKey identity, boolean isStreamContainer) {
        super(identity);
        this.isStreamContainer = isStreamContainer;
    }

    @Override
    public void update(Observable obj, Object arg) {
        if (arg == null) {
            SanityManager.THROWASSERT("still on observer list " + this);
        }
        if (arg.equals(RawTransaction.COMMIT) || arg.equals(RawTransaction.ABORT)) {
            RawTransaction xact = (RawTransaction)obj;
            try {
                if (this.isStreamContainer) {
                    xact.dropStreamContainer(this.identity.getSegmentId(), this.identity.getContainerId());
                } else {
                    xact.dropContainer(this.identity);
                }
            }
            catch (StandardException se) {
                xact.setObserverException(se);
            }
            obj.deleteObserver(this);
        }
    }
}

