/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.DynamicByteArrayOutputStream;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.PhysicalPageOperation;
import org.apache.derby.shared.common.sanity.SanityManager;

public final class UpdateOperation
extends PhysicalPageOperation {
    protected int doMeSlot;
    protected int recordId;
    protected transient int nextColumn;
    protected transient ByteArray preparedLog;

    UpdateOperation(RawTransaction t, BasePage page, int slot, int recordId, Object[] row, FormatableBitSet validColumns, int realStartColumn, DynamicByteArrayOutputStream logBuffer, int realSpaceOnPage, RecordHandle headRowHandle) throws StandardException {
        super(page);
        this.doMeSlot = slot;
        this.recordId = recordId;
        this.nextColumn = -1;
        try {
            this.writeOptionalDataToBuffer(t, logBuffer, row, validColumns, realStartColumn, realSpaceOnPage, headRowHandle);
        }
        catch (IOException ioe) {
            throw StandardException.newException("XSDA4.S", ioe, new Object[0]);
        }
    }

    public UpdateOperation() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        CompressedNumber.writeInt(out, this.doMeSlot);
        CompressedNumber.writeInt(out, this.recordId);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.doMeSlot = CompressedNumber.readInt(in);
        this.recordId = CompressedNumber.readInt(in);
    }

    @Override
    public int getTypeFormatId() {
        return 108;
    }

    public int getNextStartColumn() {
        return this.nextColumn;
    }

    @Override
    public void doMe(Transaction xact, LogInstant instant, LimitObjectInput in) throws StandardException, IOException {
        this.page.storeRecord(instant, this.doMeSlot, false, in);
    }

    @Override
    public void undoMe(Transaction xact, BasePage undoPage, LogInstant CLRInstant, LimitObjectInput in) throws StandardException, IOException {
        int slot = undoPage.findRecordById(this.recordId, 0);
        undoPage.skipRecord(in);
        undoPage.storeRecord(CLRInstant, slot, false, in);
        undoPage.setAuxObject(null);
    }

    @Override
    public ByteArray getPreparedLog() {
        return this.preparedLog;
    }

    private void writeOptionalDataToBuffer(RawTransaction t, DynamicByteArrayOutputStream logBuffer, Object[] row, FormatableBitSet validColumns, int realStartColumn, int realSpaceOnPage, RecordHandle headRowHandle) throws StandardException, IOException {
        SanityManager.ASSERT(this.page != null);
        if (realStartColumn == -1) {
            logBuffer = t.getLogBuffer();
        }
        int optionalDataStart = logBuffer.getPosition();
        SanityManager.ASSERT(realStartColumn != -1 || optionalDataStart == 0, "Buffer for writing optional data should start at position 0");
        this.nextColumn = this.page.logRow(this.doMeSlot, false, this.recordId, row, validColumns, logBuffer, 0, (byte)8, realStartColumn, realSpaceOnPage, 100);
        FormatableBitSet loggedColumns = validColumns;
        if (this.nextColumn != -1 && validColumns != null) {
            int numberFields = this.page.getHeaderAtSlot(this.doMeSlot).getNumberFields();
            loggedColumns = new FormatableBitSet(validColumns);
            int endField = this.nextColumn + numberFields;
            loggedColumns.grow(endField);
            for (int i = this.nextColumn; i < endField; ++i) {
                loggedColumns.set(i);
            }
        }
        this.page.logRecord(this.doMeSlot, 1, this.recordId, loggedColumns, logBuffer, headRowHandle);
        optionalDataStart = logBuffer.getBeginPosition();
        int optionalDataLength = logBuffer.getPosition() - optionalDataStart;
        logBuffer.setPosition(optionalDataStart);
        this.preparedLog = new ByteArray(logBuffer.getByteArray(), optionalDataStart, optionalDataLength);
    }

    @Override
    public void restoreMe(Transaction xact, BasePage undoPage, LogInstant CLRInstant, LimitObjectInput in) throws StandardException, IOException {
        this.undoMe(xact, undoPage, CLRInstant, in);
    }

    @Override
    public String toString() {
        return super.toString() + "Update " + " Slot=" + this.doMeSlot + " recordId=" + this.recordId;
    }
}

