/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.Notifier;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ConsoleNotifier
implements Notifier {
    private final boolean verbose;

    public ConsoleNotifier(boolean verbose) {
        this.verbose = verbose;
        if (verbose) {
            this.info("Verbose logging enabled");
        }
    }

    @Override
    public void info(String message) {
        if (this.verbose) {
            System.out.println(ConsoleNotifier.formatMessage(message));
        }
    }

    @Override
    public void error(String message) {
        System.err.println(ConsoleNotifier.formatMessage(message));
    }

    @Override
    public void error(String message, Throwable t) {
        System.err.println(ConsoleNotifier.formatMessage(message));
        t.printStackTrace(System.err);
    }

    private static String formatMessage(String message) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        String date = df.format(new Date());
        return String.format("%s %s", date, message);
    }
}

