# encoding: utf-8
require "logstash/environment"
require "logstash/errors"
if LogStash::Environment.jruby?
  require "jrjackson"
  require "logstash/java_integration"
else
  require  "oj"
end

module LogStash
  module Json
    class ParserError < LogStash::Error; end
    class GeneratorError < LogStash::Error; end

    extend self

    ### MRI

    def mri_load(data, options = {})
      Oj.load(data)
    rescue Oj::ParseError => e
      raise LogStash::Json::ParserError.new(e.message)
    end

    def mri_dump(o)
      Oj.dump(o, :mode => :compat, :use_to_json => true)
    rescue => e
      raise LogStash::Json::GeneratorError.new(e.message)
    end

    ### JRuby

    def jruby_load(data, options = {})
      # TODO [guyboertje] remove these comments in 5.0
      # options[:symbolize_keys] ? JrJackson::Raw.parse_sym(data) : JrJackson::Raw.parse_raw(data)

      JrJackson::Ruby.parse(data, options)

    rescue JrJackson::ParseError => e
      raise LogStash::Json::ParserError.new(e.message)
    end

    def jruby_dump(o, options={})
      # TODO [guyboertje] remove these comments in 5.0
      # test for enumerable here to work around an omission in JrJackson::Json.dump to
      # also look for Java::JavaUtil::ArrayList, see TODO submit issue
      # o.is_a?(Enumerable) ? JrJackson::Raw.generate(o) : JrJackson::Json.dump(o)
      JrJackson::Base.generate(o, options)

    rescue => e
      raise LogStash::Json::GeneratorError.new(e.message)
    end

    prefix = LogStash::Environment.jruby? ? "jruby" : "mri"
    alias_method :load, "#{prefix}_load".to_sym
    alias_method :dump, "#{prefix}_dump".to_sym

  end
end
