/*******************************************************************************
 * Copyright (c) 2015, 2018 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package com.ibm.ws.cdi12.fat.tests;

import static org.junit.Assert.assertTrue;

import java.net.MalformedURLException;

import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

import com.ibm.ws.fat.util.browser.WebBrowser;
import com.ibm.ws.fat.util.browser.WebBrowserException;
import com.ibm.ws.fat.util.browser.WebResponse;

import componenttest.annotation.AllowedFFDC;
import componenttest.annotation.IgnoreTestNamesRule;

public class AroundConstructEjbTest extends AroundConstructTestBase {

    /*
     * (non-Javadoc)
     *
     * @see com.ibm.ws.cdi12.fat.tests.AroundConstructTestBase#getServletName()
     */
    @Override
    protected String getServletName() {
        // TODO Auto-generated method stub
        return "ejbTestServlet";
    }
    /*
     * This is allready called by AroundConstructBeanTest. For some reason calling it twice causes test failures. 
     * @BeforeClass
     * public static void setUp() throws Exception {
     *     AroundConstructTestBase.setUp();
     * }
     */

    @Test
    public void testStatelessAroundConstruct() {}

    @BeforeClass
    public static void setUp() throws Exception {
        AroundConstructTestBase.setUp();
    }

    @Test
    @IgnoreTestNamesRule
    @AllowedFFDC({ "javax.ejb.EJBException", "java.lang.reflect.UndeclaredThrowableException", "java.lang.IllegalStateException" })
    public void testPostConstructErrorMessage() {
        int errMsgCount = 0;
        WebBrowser browser = createWebBrowserForTestCase();

        try {
            WebResponse response = browser.request(createURL("/postConstructErrorMessageApp/errorMessageTestServlet"));
        } catch (MalformedURLException e1) {
            // TODO Auto-generated catch block
            // Do you need FFDC here? Remember FFDC instrumentation and @FFDCIgnore
            // http://was.pok.ibm.com/xwiki/bin/view/Liberty/LoggingFFDC
            e1.printStackTrace();
        } catch (WebBrowserException e1) {
            // TODO Auto-generated catch block
            // Do you need FFDC here? Remember FFDC instrumentation and @FFDCIgnore
            // http://was.pok.ibm.com/xwiki/bin/view/Liberty/LoggingFFDC
            e1.printStackTrace();
        }
        try {
            errMsgCount = super.server.findStringsInLogs("CWOWB2001E(?=.*POST_CONSTRUCT)(?=.*java.lang.IllegalStateException)").size();
        } catch (Exception e) {
            // TODO Auto-generated catch block
            // Do you need FFDC here? Remember FFDC instrumentation and @FFDCIgnore
            // http://was.pok.ibm.com/xwiki/bin/view/Liberty/LoggingFFDC
            e.printStackTrace();
        }

        assertTrue("The expected error message stating that an interceptor lifecycle callback threw an exception did not appear", errMsgCount > 0);
    }

    private String createURL(String path) throws MalformedURLException {
        return "http://" + server.getHostname() + ":" + server.getHttpDefaultPort() + path;
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (server != null && server.isStarted()) {
            server.stopServer("CWOWB2001E", "CNTR0019E", "SRVE0777E", "SRVE0315E");
        }
    }

}
