/*******************************************************************************
 * Copyright (c) 2020 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package com.informix.jdbcx;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class IfxStatement implements Statement {
	Statement wrappedStmt = null;

	IfxConnection ifxConn = null;

	static boolean failoverQuery = false;

	IfxStatement(Statement realStmt, IfxConnection ifxConnection) {
		wrappedStmt = realStmt;
		ifxConn = ifxConnection;
	}

	@Override
	public void addBatch(String sql) throws SQLException {
		wrappedStmt.addBatch(sql);
	}

	@Override
	public void cancel() throws SQLException {
		wrappedStmt.cancel();
	}

	@Override
	public void clearBatch() throws SQLException {
		wrappedStmt.clearBatch();
	}

	@Override
	public void clearWarnings() throws SQLException {
		wrappedStmt.clearWarnings();
	}

	@Override
	public void close() throws SQLException {
		wrappedStmt.close();
	}

	@Override
	public boolean execute(String sql) throws SQLException {
		boolean ret = wrappedStmt.execute(sql);
		return ret;
	}

	@Override
	public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
		boolean ret = wrappedStmt.execute(sql, autoGeneratedKeys);
		return ret;
	}

	@Override
	public boolean execute(String sql, int[] columnIndexes) throws SQLException {
		boolean ret = wrappedStmt.execute(sql, columnIndexes);
		return ret;
	}

	@Override
	public boolean execute(String sql, String[] columnNames) throws SQLException {
		boolean ret = wrappedStmt.execute(sql, columnNames);
		return ret;
	}

	@Override
	public int[] executeBatch() throws SQLException {
		int[] ret = null;
		boolean failOver = false;
		System.out.println("SIMHADB: executeBatch, this - " + this + ", wrapped - " + wrappedStmt);

		if (IfxConnection.isFailoverEnabled()) {
			System.out
					.println("SIMHADB: executeBatch, failover Enabled, Counter -" + IfxConnection.getFailoverCounter());
			IfxConnection.incrementFailoverCounter();
			if (IfxConnection.getFailoverCounter() == IfxConnection.getFailoverValue())
				failOver = true;
		}

		if (failOver) {
			System.out.println("SIMHADB: Feigning query failover, close connection");
			IfxConnectionPoolDataSource.setTestingFailoverAtRuntime(false);
			Connection myconn = getConnection();
			try {
				myconn.rollback();
				myconn.close();
			} catch (Exception ex) {
				System.out.println("SIMHADB: on close connection, caught exc: " + ex);
			}
			String sqlReason = "Generated internally";
			String sqlState = "Generated reason";
			int reasonCode = IfxConnection.getSimSQLCode(); // FOR DB2 should be
															// -4498, Oracle
															// 17410
			System.out.println("SIMHADB: sqlcode set to: " + reasonCode);
			SQLException sqlex = new SQLException(sqlReason, sqlState, reasonCode);
			throw sqlex;
		} else {
			System.out.println("SIMHADB: ExecuteBatch");
			ret = wrappedStmt.executeBatch();
		}

		System.out.println("SIMHADB: executeBatch - " + ret);
		return ret;
	}

	@Override
	public ResultSet executeQuery(String sql) throws SQLException {
		System.out.println("SIMHADB: executeQuery, this - " + this + ", sql - " + sql); // +
																						// ",
																						// fail
																						// Counter
																						// -"
																						// +
																						// failoverCounter
																						// +
																						// ",
																						// wrapped
																						// -
																						// "
																						// +
																						// wrappedStmt);

		simQueryFailover();

		ResultSet ret = wrappedStmt.executeQuery(sql);
		System.out.println("SIMHADB: executeQuery exit, ret - " + ret);
		return ret;
	}

	@Override
	public int executeUpdate(String sql) throws SQLException {
		System.out.println("SIMHADB: executeUpdate, this - " + this + ", sql: " + sql);

		simQueryFailover();

		int ret = wrappedStmt.executeUpdate(sql);
		System.out.println("SIMHADB: executeUpdate exit, ret - " + ret);
		return ret;
	}

	@Override
	public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
		System.out.println("SIMHADB: executeUpdate, this - " + this + ", sql: " + sql + ", keys: " + autoGeneratedKeys);

		simQueryFailover();

		int ret = wrappedStmt.executeUpdate(sql, autoGeneratedKeys);
		System.out.println("SIMHADB: executeUpdate exit, ret - " + ret);
		return ret;
	}

	@Override
	public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
		System.out.println("SIMHADB: executeUpdate, this - " + this + ", sql: " + sql + ", columnindexes");

		simQueryFailover();

		int ret = wrappedStmt.executeUpdate(sql, columnIndexes);
		System.out.println("SIMHADB: executeUpdate exit, ret - " + ret);
		return ret;
	}

	@Override
	public int executeUpdate(String sql, String[] columnNames) throws SQLException {
		System.out.println("SIMHADB: executeUpdate, this - " + this + ", sql: " + sql + ", columnnames");

		simQueryFailover();
		int ret = wrappedStmt.executeUpdate(sql, columnNames);
		System.out.println("SIMHADB: executeUpdate exit, ret - " + ret);
		return ret;
	}

	@Override
	public Connection getConnection() throws SQLException {
		Connection ret = wrappedStmt.getConnection();
		return ret;
	}

	@Override
	public int getFetchDirection() throws SQLException {
		int ret = wrappedStmt.getFetchDirection();
		return ret;
	}

	@Override
	public int getFetchSize() throws SQLException {
		int ret = wrappedStmt.getFetchSize();
		return ret;
	}

	@Override
	public ResultSet getGeneratedKeys() throws SQLException {
		ResultSet ret = wrappedStmt.getGeneratedKeys();
		return ret;
	}

	@Override
	public int getMaxFieldSize() throws SQLException {
		int ret = wrappedStmt.getMaxFieldSize();
		return ret;
	}

	@Override
	public int getMaxRows() throws SQLException {
		int ret = wrappedStmt.getMaxRows();
		return ret;
	}

	@Override
	public boolean getMoreResults() throws SQLException {
		boolean ret = wrappedStmt.getMoreResults();
		return ret;
	}

	@Override
	public boolean getMoreResults(int current) throws SQLException {
		boolean ret = wrappedStmt.getMoreResults(current);
		return ret;
	}

	@Override
	public int getQueryTimeout() throws SQLException {
		int ret = wrappedStmt.getQueryTimeout();
		return ret;
	}

	@Override
	public ResultSet getResultSet() throws SQLException {
		ResultSet ret = wrappedStmt.getResultSet();
		return ret;
	}

	@Override
	public int getResultSetConcurrency() throws SQLException {
		int ret = wrappedStmt.getResultSetConcurrency();
		return ret;
	}

	@Override
	public int getResultSetHoldability() throws SQLException {
		int ret = wrappedStmt.getResultSetHoldability();
		return ret;
	}

	@Override
	public int getResultSetType() throws SQLException {
		int ret = wrappedStmt.getResultSetType();
		return ret;
	}

	@Override
	public int getUpdateCount() throws SQLException {
		int ret = wrappedStmt.getUpdateCount();
		return ret;
	}

	@Override
	public SQLWarning getWarnings() throws SQLException {
		SQLWarning ret = wrappedStmt.getWarnings();
		return ret;
	}

	@Override
	public void setCursorName(String name) throws SQLException {
		wrappedStmt.setCursorName(name);
	}

	@Override
	public void setEscapeProcessing(boolean enable) throws SQLException {
		wrappedStmt.setEscapeProcessing(enable);
	}

	@Override
	public void setFetchDirection(int direction) throws SQLException {
		wrappedStmt.setFetchDirection(direction);
	}

	@Override
	public void setFetchSize(int rows) throws SQLException {
		wrappedStmt.setFetchSize(rows);
	}

	@Override
	public void setMaxFieldSize(int max) throws SQLException {
		wrappedStmt.setMaxFieldSize(max);
	}

	@Override
	public void setMaxRows(int max) throws SQLException {
		wrappedStmt.setMaxRows(max);
	}

	@Override
	public void setQueryTimeout(int seconds) throws SQLException {
		wrappedStmt.setQueryTimeout(seconds);
	}

	@Override
	public boolean isClosed() throws SQLException {
		boolean ret = wrappedStmt.isClosed();
		return ret;
	}

	@Override
	public void setPoolable(boolean poolable) throws SQLException {
		wrappedStmt.setPoolable(poolable);
	}

	@Override
	public boolean isPoolable() throws SQLException {
		boolean ret = wrappedStmt.isPoolable();
		return ret;
	}

	@Override
	public <T> T unwrap(Class<T> iface) throws SQLException {
		T ret = wrappedStmt.unwrap(iface);
		return ret;
	}

	@Override
	public boolean isWrapperFor(Class<?> iface) throws SQLException {
		boolean ret = wrappedStmt.isWrapperFor(iface);
		return ret;
	}

	private void simQueryFailover() throws SQLException {
		if (IfxConnection.isQueryFailoverEnabled() && IfxConnectionPoolDataSource.isTestingFailoverAtRuntime()) {
			System.out.println(
					"SIMHADB: executeQuery, failover Enabled, Counter -" + IfxConnection.getQueryFailoverCounter());
			IfxConnection.incrementQueryFailoverCounter();

			if (IfxConnection.getQueryFailoverCounter() == 1) {

				System.out.println("SIMHADB: Feigning executequery failover, rollback on connection");
				Connection myconn = getConnection();
				try {
					myconn.rollback();
					// myconn.close();

				} catch (Exception ex) {
					System.out.println("SIMHADB: on close connection, caught exc: " + ex);
				}
				String sqlReason = "Generated internally";
				String sqlState = "Generated reason";
				int reasonCode = IfxConnection.getSimSQLCode(); // FOR DB2
																// should be
																// -4498, Oracle
																// 17410
				SQLException sqlex = new SQLException(sqlReason, sqlState, reasonCode);
				throw sqlex;
			}
			if (IfxConnection.getQueryFailoverCounter() == 4) {
				System.out.println("SIMHADB: counter reached 4 disable startup flag");
				IfxConnectionPoolDataSource.setTestingFailoverAtRuntime(false);
			}

			if (IfxConnection.getQueryFailoverCounter() >= 2 && IfxConnection.getQueryFailoverCounter() <= 4) {

				System.out.println("SIMHADB: Feigning query failover - (2,3)");
				// Connection myconn = getConnection();

				String sqlReason = "Generated internally";
				String sqlState = "Generated reason";
				int reasonCode = IfxConnection.getSimSQLCode(); // FOR DB2
																// should be
																// -4498, Oracle
																// 17410
				SQLException sqlex = new SQLException(sqlReason, sqlState, reasonCode);
				throw sqlex;
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.sql.Statement#closeOnCompletion()
	 */
	@Override
	public void closeOnCompletion() throws SQLException {
		// TODO Auto-generated method stub

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.sql.Statement#isCloseOnCompletion()
	 */
	@Override
	public boolean isCloseOnCompletion() throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}
}
