/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Collator;
import java.text.RuleBasedCollator;
import java.util.Locale;
import java.util.Properties;
import org.apache.derby.iapi.db.DatabaseContext;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.i18n.LocaleFinder;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.types.BitDataValue;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.CollatorSQLChar;
import org.apache.derby.iapi.types.CollatorSQLClob;
import org.apache.derby.iapi.types.CollatorSQLLongvarchar;
import org.apache.derby.iapi.types.CollatorSQLVarchar;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.DateTimeDataValue;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.RefDataValue;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.SQLBit;
import org.apache.derby.iapi.types.SQLBlob;
import org.apache.derby.iapi.types.SQLBoolean;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.iapi.types.SQLClob;
import org.apache.derby.iapi.types.SQLDate;
import org.apache.derby.iapi.types.SQLDecimal;
import org.apache.derby.iapi.types.SQLDouble;
import org.apache.derby.iapi.types.SQLInteger;
import org.apache.derby.iapi.types.SQLLongVarbit;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.iapi.types.SQLLongvarchar;
import org.apache.derby.iapi.types.SQLReal;
import org.apache.derby.iapi.types.SQLRef;
import org.apache.derby.iapi.types.SQLSmallint;
import org.apache.derby.iapi.types.SQLTime;
import org.apache.derby.iapi.types.SQLTimestamp;
import org.apache.derby.iapi.types.SQLTinyint;
import org.apache.derby.iapi.types.SQLVarbit;
import org.apache.derby.iapi.types.SQLVarchar;
import org.apache.derby.iapi.types.StringDataValue;
import org.apache.derby.iapi.types.UserDataValue;
import org.apache.derby.iapi.types.UserType;
import org.apache.derby.iapi.types.XML;
import org.apache.derby.iapi.types.XMLDataValue;
import org.apache.derby.impl.store.access.heap.HeapRowLocation;
import org.apache.derby.shared.common.sanity.SanityManager;

public final class DataValueFactoryImpl
implements DataValueFactory,
ModuleControl {
    private LocaleFinder localeFinder;
    private Locale databaseLocale;
    private RuleBasedCollator collatorForCharacterTypes;

    @Override
    public void boot(boolean create, Properties properties) throws StandardException {
        int collationType;
        String userDefinedCollation;
        ModuleFactory monitor = Monitor.getMonitor();
        this.databaseLocale = monitor.getLocale(this);
        if (create && (userDefinedCollation = properties.getProperty("collation")) != null && (collationType = DataTypeDescriptor.getCollationType(userDefinedCollation)) != 0) {
            if (collationType >= 1 && collationType < 5) {
                int strength = collationType - 2;
                this.collatorForCharacterTypes = this.verifyCollatorSupport(strength);
            } else {
                throw StandardException.newException("XBM03.D", userDefinedCollation);
            }
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public NumberDataValue getDataValue(int value, NumberDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLInteger(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public NumberDataValue getDataValue(Integer value, NumberDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLInteger(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public NumberDataValue getDataValue(char value, NumberDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLInteger(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public NumberDataValue getDataValue(short value, NumberDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLSmallint(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public NumberDataValue getDataValue(Short value, NumberDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLSmallint(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public NumberDataValue getDataValue(byte value, NumberDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLTinyint(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public NumberDataValue getDataValue(Byte value, NumberDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLTinyint(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public NumberDataValue getDataValue(long value, NumberDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLLongint(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public NumberDataValue getDataValue(Long value, NumberDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLLongint(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public NumberDataValue getDataValue(float value, NumberDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLReal(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public NumberDataValue getDataValue(Float value, NumberDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLReal(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public NumberDataValue getDataValue(double value, NumberDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLDouble(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public NumberDataValue getDataValue(Double value, NumberDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLDouble(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public final NumberDataValue getDecimalDataValue(Number value, NumberDataValue previous) throws StandardException {
        NumberDataValue retValue = previous == null ? this.getNullDecimal(null) : previous;
        retValue.setValue(value);
        return retValue;
    }

    @Override
    public BooleanDataValue getDataValue(boolean value, BooleanDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLBoolean(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public BooleanDataValue getDataValue(Boolean value, BooleanDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLBoolean(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public BitDataValue getBitDataValue(byte[] value) throws StandardException {
        return new SQLBit(value);
    }

    @Override
    public BitDataValue getBitDataValue(byte[] value, BitDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLBit(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public BitDataValue getVarbitDataValue(byte[] value, BitDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLVarbit(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public BitDataValue getLongVarbitDataValue(byte[] value, BitDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLLongVarbit(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public BitDataValue getBlobDataValue(byte[] value, BitDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLBlob(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public BitDataValue getBlobDataValue(Blob value, BitDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLBlob(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public StringDataValue getCharDataValue(String value) {
        return new SQLChar(value);
    }

    @Override
    public StringDataValue getCharDataValue(String value, StringDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLChar(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public StringDataValue getCharDataValue(String value, StringDataValue previous, int collationType) throws StandardException {
        if (collationType == 0) {
            return this.getCharDataValue(value, previous);
        }
        if (previous == null) {
            return new CollatorSQLChar(value, this.getCharacterCollator(collationType));
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public StringDataValue getVarcharDataValue(String value) {
        return new SQLVarchar(value);
    }

    @Override
    public StringDataValue getVarcharDataValue(String value, StringDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLVarchar(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public StringDataValue getVarcharDataValue(String value, StringDataValue previous, int collationType) throws StandardException {
        if (collationType == 0) {
            return this.getVarcharDataValue(value, previous);
        }
        if (previous == null) {
            return new CollatorSQLVarchar(value, this.getCharacterCollator(collationType));
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public StringDataValue getLongvarcharDataValue(String value) {
        return new SQLLongvarchar(value);
    }

    @Override
    public StringDataValue getLongvarcharDataValue(String value, StringDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLLongvarchar(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public StringDataValue getLongvarcharDataValue(String value, StringDataValue previous, int collationType) throws StandardException {
        if (collationType == 0) {
            return this.getLongvarcharDataValue(value, previous);
        }
        if (previous == null) {
            return new CollatorSQLLongvarchar(value, this.getCharacterCollator(collationType));
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public StringDataValue getClobDataValue(String value, StringDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLClob(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public StringDataValue getClobDataValue(Clob value, StringDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLClob(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public StringDataValue getClobDataValue(Clob value, StringDataValue previous, int collationType) throws StandardException {
        if (collationType == 0) {
            return this.getClobDataValue(value, previous);
        }
        if (previous == null) {
            return new CollatorSQLClob(value, this.getCharacterCollator(collationType));
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public StringDataValue getClobDataValue(String value, StringDataValue previous, int collationType) throws StandardException {
        if (collationType == 0) {
            return this.getClobDataValue(value, previous);
        }
        if (previous == null) {
            return new CollatorSQLClob(value, this.getCharacterCollator(collationType));
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public DateTimeDataValue getDataValue(Date value, DateTimeDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLDate(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public DateTimeDataValue getDataValue(Time value, DateTimeDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLTime(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public DateTimeDataValue getDataValue(Timestamp value, DateTimeDataValue previous) throws StandardException {
        if (previous == null) {
            return new SQLTimestamp(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public DateTimeDataValue getDate(DataValueDescriptor operand) throws StandardException {
        return SQLDate.computeDateFunction(operand, this);
    }

    @Override
    public DateTimeDataValue getTimestamp(DataValueDescriptor operand) throws StandardException {
        return SQLTimestamp.computeTimestampFunction(operand, this);
    }

    @Override
    public DateTimeDataValue getTimestamp(DataValueDescriptor date, DataValueDescriptor time) throws StandardException {
        return new SQLTimestamp(date, time);
    }

    @Override
    public UserDataValue getDataValue(Object value, UserDataValue previous) {
        if (previous == null) {
            return new UserType(value);
        }
        ((UserType)previous).setValue(value);
        return previous;
    }

    @Override
    public RefDataValue getDataValue(RowLocation value, RefDataValue previous) {
        if (previous == null) {
            return new SQLRef(value);
        }
        previous.setValue(value);
        return previous;
    }

    @Override
    public NumberDataValue getNullInteger(NumberDataValue dataValue) {
        if (dataValue == null) {
            return new SQLInteger();
        }
        dataValue.setToNull();
        return dataValue;
    }

    @Override
    public NumberDataValue getNullShort(NumberDataValue dataValue) {
        if (dataValue == null) {
            return new SQLSmallint();
        }
        dataValue.setToNull();
        return dataValue;
    }

    @Override
    public NumberDataValue getNullLong(NumberDataValue dataValue) {
        if (dataValue == null) {
            return new SQLLongint();
        }
        dataValue.setToNull();
        return dataValue;
    }

    @Override
    public NumberDataValue getNullByte(NumberDataValue dataValue) {
        if (dataValue == null) {
            return new SQLTinyint();
        }
        dataValue.setToNull();
        return dataValue;
    }

    @Override
    public NumberDataValue getNullFloat(NumberDataValue dataValue) {
        if (dataValue == null) {
            return new SQLReal();
        }
        dataValue.setToNull();
        return dataValue;
    }

    @Override
    public NumberDataValue getNullDouble(NumberDataValue dataValue) {
        if (dataValue == null) {
            return new SQLDouble();
        }
        dataValue.setToNull();
        return dataValue;
    }

    @Override
    public final NumberDataValue getNullDecimal(NumberDataValue dataValue) {
        if (dataValue == null) {
            return new SQLDecimal();
        }
        dataValue.setToNull();
        return dataValue;
    }

    @Override
    public BooleanDataValue getNullBoolean(BooleanDataValue dataValue) {
        if (dataValue == null) {
            return new SQLBoolean();
        }
        dataValue.setToNull();
        return dataValue;
    }

    @Override
    public BitDataValue getNullBit(BitDataValue dataValue) throws StandardException {
        if (dataValue == null) {
            return this.getBitDataValue(null);
        }
        dataValue.setToNull();
        return dataValue;
    }

    @Override
    public BitDataValue getNullVarbit(BitDataValue dataValue) throws StandardException {
        if (dataValue == null) {
            return new SQLVarbit();
        }
        dataValue.setToNull();
        return dataValue;
    }

    @Override
    public BitDataValue getNullLongVarbit(BitDataValue dataValue) throws StandardException {
        if (dataValue == null) {
            return new SQLLongVarbit();
        }
        dataValue.setToNull();
        return dataValue;
    }

    @Override
    public BitDataValue getNullBlob(BitDataValue dataValue) throws StandardException {
        if (dataValue == null) {
            return new SQLBlob();
        }
        dataValue.setToNull();
        return dataValue;
    }

    @Override
    public StringDataValue getNullChar(StringDataValue dataValue) {
        if (dataValue == null) {
            return this.getCharDataValue(null);
        }
        dataValue.setToNull();
        return dataValue;
    }

    @Override
    public StringDataValue getNullChar(StringDataValue previous, int collationType) throws StandardException {
        if (collationType == 0) {
            return this.getNullChar(previous);
        }
        if (previous == null) {
            return new CollatorSQLChar(this.getCharacterCollator(collationType));
        }
        previous.setToNull();
        return previous;
    }

    @Override
    public StringDataValue getNullVarchar(StringDataValue dataValue) {
        if (dataValue == null) {
            return this.getVarcharDataValue(null);
        }
        dataValue.setToNull();
        return dataValue;
    }

    @Override
    public StringDataValue getNullVarchar(StringDataValue previous, int collationType) throws StandardException {
        if (collationType == 0) {
            return this.getNullChar(previous);
        }
        if (previous == null) {
            return new CollatorSQLVarchar(this.getCharacterCollator(collationType));
        }
        previous.setToNull();
        return previous;
    }

    @Override
    public StringDataValue getNullLongvarchar(StringDataValue dataValue) {
        if (dataValue == null) {
            return this.getLongvarcharDataValue(null);
        }
        dataValue.setToNull();
        return dataValue;
    }

    @Override
    public StringDataValue getNullLongvarchar(StringDataValue previous, int collationType) throws StandardException {
        if (collationType == 0) {
            return this.getNullChar(previous);
        }
        if (previous == null) {
            return new CollatorSQLLongvarchar(this.getCharacterCollator(collationType));
        }
        previous.setToNull();
        return previous;
    }

    @Override
    public StringDataValue getNullClob(StringDataValue dataValue) {
        if (dataValue == null) {
            return new SQLClob();
        }
        dataValue.setToNull();
        return dataValue;
    }

    @Override
    public StringDataValue getNullClob(StringDataValue previous, int collationType) throws StandardException {
        if (collationType == 0) {
            return this.getNullChar(previous);
        }
        if (previous == null) {
            return new CollatorSQLClob(this.getCharacterCollator(collationType));
        }
        previous.setToNull();
        return previous;
    }

    @Override
    public UserDataValue getNullObject(UserDataValue dataValue) {
        if (dataValue == null) {
            return new UserType(null);
        }
        dataValue.setToNull();
        return dataValue;
    }

    @Override
    public RefDataValue getNullRef(RefDataValue dataValue) {
        if (dataValue == null) {
            return new SQLRef();
        }
        dataValue.setToNull();
        return dataValue;
    }

    @Override
    public DateTimeDataValue getNullDate(DateTimeDataValue dataValue) {
        if (dataValue == null) {
            try {
                return new SQLDate(null);
            }
            catch (StandardException se) {
                SanityManager.THROWASSERT("Could not get a null date.", se);
                return null;
            }
        }
        dataValue.setToNull();
        return dataValue;
    }

    @Override
    public DateTimeDataValue getNullTime(DateTimeDataValue dataValue) {
        if (dataValue == null) {
            try {
                return new SQLTime(null);
            }
            catch (StandardException se) {
                SanityManager.THROWASSERT("Could not get a null time.", se);
                return null;
            }
        }
        dataValue.setToNull();
        return dataValue;
    }

    @Override
    public DateTimeDataValue getNullTimestamp(DateTimeDataValue dataValue) {
        if (dataValue == null) {
            try {
                return new SQLTimestamp(null);
            }
            catch (StandardException se) {
                SanityManager.THROWASSERT("Could not get a null timestamp.", se);
                return null;
            }
        }
        dataValue.setToNull();
        return dataValue;
    }

    @Override
    public DateTimeDataValue getDateValue(String dateStr, boolean isJdbcEscape) throws StandardException {
        return new SQLDate(dateStr, isJdbcEscape, this.getLocaleFinder());
    }

    @Override
    public DateTimeDataValue getTimeValue(String timeStr, boolean isJdbcEscape) throws StandardException {
        return new SQLTime(timeStr, isJdbcEscape, this.getLocaleFinder());
    }

    @Override
    public DateTimeDataValue getTimestampValue(String timestampStr, boolean isJdbcEscape) throws StandardException {
        return new SQLTimestamp(timestampStr, isJdbcEscape, this.getLocaleFinder());
    }

    @Override
    public XMLDataValue getXMLDataValue(XMLDataValue previous) throws StandardException {
        return this.getNullXML(previous);
    }

    @Override
    public XMLDataValue getNullXML(XMLDataValue dataValue) {
        if (dataValue == null) {
            return new XML();
        }
        dataValue.setToNull();
        return dataValue;
    }

    @Override
    public RuleBasedCollator getCharacterCollator(int collationType) throws StandardException {
        if (collationType == 0) {
            return null;
        }
        if (this.collatorForCharacterTypes == null) {
            int strength = collationType - 2;
            this.collatorForCharacterTypes = this.verifyCollatorSupport(strength);
            return this.collatorForCharacterTypes;
        }
        return this.collatorForCharacterTypes;
    }

    private RuleBasedCollator verifyCollatorSupport(int strength) throws StandardException {
        Locale[] availLocales = Collator.getAvailableLocales();
        boolean localeFound = false;
        for (int i = 0; i < availLocales.length; ++i) {
            if (!availLocales[i].equals(this.databaseLocale)) continue;
            localeFound = true;
            break;
        }
        if (!localeFound) {
            throw StandardException.newException("XBM04.D", this.databaseLocale.toString());
        }
        RuleBasedCollator collator = (RuleBasedCollator)Collator.getInstance(this.databaseLocale);
        if (strength != -1) {
            collator.setStrength(strength);
        }
        return collator;
    }

    @Override
    public DataValueDescriptor getNull(int formatId, int collationType) throws StandardException {
        DataValueDescriptor returnDVD = DataValueFactoryImpl.getNullDVDWithUCS_BASICcollation(formatId);
        if (collationType == 0) {
            return returnDVD;
        }
        if (returnDVD instanceof StringDataValue) {
            return ((StringDataValue)returnDVD).getValue(this.getCharacterCollator(collationType));
        }
        return returnDVD;
    }

    public static DataValueDescriptor getNullDVDWithUCS_BASICcollation(int formatId) {
        switch (formatId) {
            case 87: {
                return new SQLBit();
            }
            case 77: {
                return new SQLBoolean();
            }
            case 78: {
                return new SQLChar();
            }
            case 298: {
                return new SQLDate();
            }
            case 200: {
                return new SQLDecimal();
            }
            case 79: {
                return new SQLDouble();
            }
            case 80: {
                return new SQLInteger();
            }
            case 84: {
                return new SQLLongint();
            }
            case 81: {
                return new SQLReal();
            }
            case 82: {
                return new SQLRef();
            }
            case 83: {
                return new SQLSmallint();
            }
            case 299: {
                return new SQLTime();
            }
            case 31: {
                return new SQLTimestamp();
            }
            case 199: {
                return new SQLTinyint();
            }
            case 85: {
                return new SQLVarchar();
            }
            case 235: {
                return new SQLLongvarchar();
            }
            case 88: {
                return new SQLVarbit();
            }
            case 234: {
                return new SQLLongVarbit();
            }
            case 266: {
                return new UserType();
            }
            case 443: {
                return new SQLBlob();
            }
            case 447: {
                return new SQLClob();
            }
            case 458: {
                return new XML();
            }
            case 90: {
                return new HeapRowLocation();
            }
        }
        return null;
    }

    private LocaleFinder getLocaleFinder() {
        DatabaseContext dc;
        if (this.localeFinder == null && (dc = (DatabaseContext)ContextService.getContext("Database")) != null) {
            this.localeFinder = dc.getDatabase();
        }
        return this.localeFinder;
    }
}

