/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Properties;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.util.StringUtil;

public abstract class IdUtil {
    public static final int DBCP_SCHEMA_NAME = 0;
    public static final int DBCP_SQL_JAR_NAME = 1;

    public static String normalToDelimited(String id) {
        return StringUtil.quoteString(id, '\"');
    }

    public static String mkQualifiedName(String id1, String id2) {
        if (null == id1) {
            return IdUtil.normalToDelimited(id2);
        }
        return IdUtil.normalToDelimited(id1) + "." + IdUtil.normalToDelimited(id2);
    }

    public static String mkQualifiedName(String[] ids) {
        StringBuffer sb = new StringBuffer();
        for (int ix = 0; ix < ids.length; ++ix) {
            if (ix != 0) {
                sb.append(".");
            }
            sb.append(IdUtil.normalToDelimited(ids[ix]));
        }
        return sb.toString();
    }

    public static String[] parseMultiPartSQLIdentifier(String s) throws StandardException {
        StringReader r = new StringReader(s);
        String[] qName = IdUtil.parseMultiPartSQLIdentifier(r);
        IdUtil.verifyEmpty(r);
        return qName;
    }

    /*
     * Exception decompiling
     */
    private static String[] parseMultiPartSQLIdentifier(StringReader r) throws StandardException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String parseSQLIdentifier(String s) throws StandardException {
        StringReader r = new StringReader(s);
        String id = IdUtil.parseId(r, true);
        IdUtil.verifyEmpty(r);
        return id;
    }

    private static String parseId(StringReader r, boolean normalize) throws StandardException {
        try {
            r.mark(0);
            int c = r.read();
            if (c == -1) {
                throw StandardException.newException("XCXA0.S", new Object[0]);
            }
            r.reset();
            if (c == 34) {
                return IdUtil.parseQId(r, normalize);
            }
            return IdUtil.parseUnQId(r, normalize);
        }
        catch (IOException ioe) {
            throw StandardException.newException("XCXA0.S", ioe, new Object[0]);
        }
    }

    public static String SQLIdentifier2CanonicalPropertyUsername(String authid) {
        boolean needsQuote = false;
        for (int i = 0; i < authid.length(); ++i) {
            char c = authid.charAt(i);
            if (c >= 'A' && c <= 'Z' || c == '_' || i > 0 && c >= '0' && c <= '9') continue;
            needsQuote = true;
            break;
        }
        String result = !needsQuote ? authid.toLowerCase() : IdUtil.normalToDelimited(authid);
        return result;
    }

    private static String parseUnQId(StringReader r, boolean normalize) throws IOException, StandardException {
        int c;
        StringBuffer b = new StringBuffer();
        boolean first = true;
        while (true) {
            r.mark(0);
            c = r.read();
            if (!IdUtil.idChar(first, c)) break;
            b.append((char)c);
            first = false;
        }
        if (c != -1) {
            r.reset();
        }
        String id = b.toString();
        if (normalize) {
            return StringUtil.SQLToUpperCase(id);
        }
        return id;
    }

    private static boolean idChar(boolean first, int c) {
        if (c >= 97 && c <= 122 || c >= 65 && c <= 90 || !first && c >= 48 && c <= 57 || !first && c == 95) {
            return true;
        }
        if (Character.isLetter((char)c)) {
            return true;
        }
        return !first && Character.isDigit((char)c);
    }

    private static String parseQId(StringReader r, boolean normalize) throws IOException, StandardException {
        StringBuffer b = new StringBuffer();
        int c = r.read();
        if (c != 34) {
            throw StandardException.newException("XCXA0.S", new Object[0]);
        }
        while (true) {
            if ((c = r.read()) == 34) {
                r.mark(0);
                int c2 = r.read();
                if (c2 != 34) {
                    if (c2 == -1) break;
                    r.reset();
                    break;
                }
            } else if (c == -1) {
                throw StandardException.newException("XCXA0.S", new Object[0]);
            }
            b.append((char)c);
        }
        if (b.length() == 0) {
            throw StandardException.newException("XCXA0.S", new Object[0]);
        }
        if (normalize) {
            return b.toString();
        }
        return IdUtil.normalToDelimited(b.toString());
    }

    private static void verifyEmpty(Reader r) throws StandardException {
        try {
            if (r.read() != -1) {
                throw StandardException.newException("XCXA0.S", new Object[0]);
            }
        }
        catch (IOException ioe) {
            throw StandardException.newException("XCXA0.S", ioe, new Object[0]);
        }
    }

    public static String[][] parseDbClassPath(String input) throws StandardException {
        if (input.length() == 0) {
            return new String[0][];
        }
        Vector<String[]> v = new Vector<String[]>();
        StringReader r = new StringReader(input);
        try {
            int delim;
            do {
                String[] thisQName;
                if ((thisQName = IdUtil.parseMultiPartSQLIdentifier(r)).length != 2) {
                    throw StandardException.newException("XCXB0.S", input);
                }
                v.add(thisQName);
            } while ((delim = r.read()) == 58);
            if (delim != -1) {
                throw StandardException.newException("XCXB0.S", input);
            }
        }
        catch (StandardException se) {
            if (se.getMessageId().equals("XCXA0.S")) {
                throw StandardException.newException("XCXB0.S", se, input);
            }
            throw se;
        }
        catch (IOException ioe) {
            throw StandardException.newException("XCXB0.S", ioe, input);
        }
        String[][] result = new String[v.size()][];
        v.copyInto((Object[])result);
        return result;
    }

    public static String[] parseIdList(String p) throws StandardException {
        if (p == null) {
            return null;
        }
        StringReader r = new StringReader(p);
        String[] result = IdUtil.parseIdList(r, true);
        IdUtil.verifyEmpty(r);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String[] parseIdList(StringReader r, boolean normalize) throws StandardException {
        Vector<String> v = new Vector<String>();
        try {
            int delim;
            do {
                String thisId = IdUtil.parseId(r, normalize);
                v.add(thisId);
                r.mark(0);
            } while ((delim = r.read()) == 44);
            if (delim != -1) {
                r.reset();
            }
        }
        catch (StandardException se) {
            if (se.getMessageId().equals("XCXC0.S")) {
                throw StandardException.newException("XCXC0.S", se, new Object[0]);
            }
            throw se;
        }
        catch (IOException ioe) {
            throw StandardException.newException("XCXC0.S", ioe, new Object[0]);
        }
        if (v.size() == 0) {
            return null;
        }
        Object[] result = new String[v.size()];
        v.copyInto(result);
        return result;
    }

    public static String intersect(String[] l1, String[] l2) {
        if (l1 == null || l2 == null) {
            return null;
        }
        HashSet<String> h = new HashSet<String>();
        for (int ix = 0; ix < l2.length; ++ix) {
            h.add(l2[ix]);
        }
        Vector<String> v = new Vector<String>();
        for (int ix = 0; ix < l1.length; ++ix) {
            if (!h.contains(l1[ix])) continue;
            v.add(l1[ix]);
        }
        return IdUtil.vectorToIdList(v, true);
    }

    private static String vectorToIdList(Vector<String> v, boolean normal) {
        if (v.size() == 0) {
            return null;
        }
        Object[] a = new String[v.size()];
        v.copyInto(a);
        if (normal) {
            return IdUtil.mkIdList((String[])a);
        }
        return IdUtil.mkIdListAsEntered((String[])a);
    }

    public static String getUserAuthorizationId(String userName) throws StandardException {
        try {
            if (userName != null) {
                return IdUtil.parseSQLIdentifier(userName);
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        throw StandardException.newException("28502", userName);
    }

    public static String getUserNameFromURLProps(Properties params) {
        String userName = params.getProperty("user", "APP");
        if (userName.equals("")) {
            userName = "APP";
        }
        return userName;
    }

    public static String dups(String[] l) {
        if (l == null) {
            return null;
        }
        HashSet<String> h = new HashSet<String>();
        Vector<String> v = new Vector<String>();
        for (int ix = 0; ix < l.length; ++ix) {
            if (!h.contains(l[ix])) {
                h.add(l[ix]);
                continue;
            }
            v.add(l[ix]);
        }
        return IdUtil.vectorToIdList(v, true);
    }

    public static String pruneDups(String l) throws StandardException {
        if (l == null) {
            return null;
        }
        String[] normal_a = IdUtil.parseIdList(l);
        StringReader r = new StringReader(l);
        String[] external_a = IdUtil.parseIdList(r, false);
        HashSet<String> h = new HashSet<String>();
        Vector<String> v = new Vector<String>();
        for (int ix = 0; ix < normal_a.length; ++ix) {
            if (h.contains(normal_a[ix])) continue;
            h.add(normal_a[ix]);
            v.add(external_a[ix]);
        }
        return IdUtil.vectorToIdList(v, false);
    }

    public static String mkIdList(String[] ids) {
        StringBuffer sb = new StringBuffer();
        for (int ix = 0; ix < ids.length; ++ix) {
            if (ix != 0) {
                sb.append(",");
            }
            sb.append(IdUtil.normalToDelimited(ids[ix]));
        }
        return sb.toString();
    }

    private static String mkIdListAsEntered(String[] externalIds) {
        StringBuffer sb = new StringBuffer();
        for (int ix = 0; ix < externalIds.length; ++ix) {
            if (ix != 0) {
                sb.append(",");
            }
            sb.append(externalIds[ix]);
        }
        return sb.toString();
    }

    public static boolean idOnList(String id, String list) throws StandardException {
        if (list == null) {
            return false;
        }
        String[] list_a = IdUtil.parseIdList(list);
        for (int ix = 0; ix < list_a.length; ++ix) {
            if (!id.equals(list_a[ix])) continue;
            return true;
        }
        return false;
    }

    public static String deleteId(String id, String list) throws StandardException {
        if (list == null) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        StringReader r = new StringReader(list);
        String[] enteredList_a = IdUtil.parseIdList(r, false);
        for (int ix = 0; ix < enteredList_a.length; ++ix) {
            if (id.equals(IdUtil.parseSQLIdentifier(enteredList_a[ix]))) continue;
            v.add(enteredList_a[ix]);
        }
        if (v.size() == 0) {
            return null;
        }
        return IdUtil.vectorToIdList(v, false);
    }

    public static String appendNormalToList(String id, String list) throws StandardException {
        String delimitedId = IdUtil.normalToDelimited(id);
        if (list == null) {
            return delimitedId;
        }
        return list + "," + delimitedId;
    }

    public static String parseRoleId(String roleName) throws StandardException {
        if (StringUtil.SQLToUpperCase(roleName = roleName.trim()).equals("NONE")) {
            throw StandardException.newException("XCXA0.S", new Object[0]);
        }
        roleName = IdUtil.parseSQLIdentifier(roleName);
        IdUtil.checkIdentifierLengthLimit(roleName, 128);
        return roleName;
    }

    public static void checkIdentifierLengthLimit(String identifier, int identifier_length_limit) throws StandardException {
        if (identifier.length() > identifier_length_limit) {
            throw StandardException.newException("42622", identifier, String.valueOf(identifier_length_limit));
        }
    }
}

